/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRunnable;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.index.translog.transfer.FileSnapshot;
import org.opensearch.index.translog.transfer.FileTransferException;
import org.opensearch.index.translog.transfer.TransferService;

public class BlobStoreTransferService
implements TransferService {
    private final BlobStore blobStore;
    private final ExecutorService executorService;
    private static final Logger logger = LogManager.getLogger(BlobStoreTransferService.class);

    public BlobStoreTransferService(BlobStore blobStore, ExecutorService executorService) {
        this.blobStore = blobStore;
        this.executorService = executorService;
    }

    @Override
    public void uploadBlobAsync(FileSnapshot.TransferFileSnapshot fileSnapshot, Iterable<String> remoteTransferPath, ActionListener<FileSnapshot.TransferFileSnapshot> listener) {
        assert (remoteTransferPath instanceof BlobPath);
        BlobPath blobPath = (BlobPath)remoteTransferPath;
        this.executorService.execute(ActionRunnable.wrap(listener, l -> {
            try (InputStream inputStream = fileSnapshot.inputStream();){
                this.blobStore.blobContainer(blobPath).writeBlobAtomic(fileSnapshot.getName(), inputStream, fileSnapshot.getContentLength(), true);
                l.onResponse(fileSnapshot);
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("Failed to upload blob {}", (Object)fileSnapshot.getName()), (Throwable)e);
                l.onFailure(new FileTransferException(fileSnapshot, (Throwable)e));
            }
        }));
    }

    @Override
    public void uploadBlob(FileSnapshot.TransferFileSnapshot fileSnapshot, Iterable<String> remoteTransferPath) throws IOException {
        assert (remoteTransferPath instanceof BlobPath);
        BlobPath blobPath = (BlobPath)remoteTransferPath;
        try (InputStream inputStream = fileSnapshot.inputStream();){
            this.blobStore.blobContainer(blobPath).writeBlobAtomic(fileSnapshot.getName(), inputStream, fileSnapshot.getContentLength(), true);
        }
    }

    @Override
    public InputStream downloadBlob(Iterable<String> path, String fileName) throws IOException {
        return this.blobStore.blobContainer((BlobPath)path).readBlob(fileName);
    }

    @Override
    public void deleteBlobs(Iterable<String> path, List<String> fileNames) throws IOException {
        this.blobStore.blobContainer((BlobPath)path).deleteBlobsIgnoringIfNotExists(fileNames);
    }

    @Override
    public Set<String> listAll(Iterable<String> path) throws IOException {
        return this.blobStore.blobContainer((BlobPath)path).listBlobs().keySet();
    }
}

