/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.common.collect.Tuple;
import org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.opensearch.indices.replication.common.ReplicationState;
import org.opensearch.indices.replication.common.ReplicationTimer;

public class SegmentReplicationState
implements ReplicationState {
    private Stage stage = Stage.INIT;
    private final ReplicationLuceneIndex index;
    private final ReplicationTimer overallTimer;
    private final ReplicationTimer stageTimer;
    private final List<Tuple<String, Long>> timingData;
    private long replicationId;

    public SegmentReplicationState(ReplicationLuceneIndex index) {
        this.index = index;
        this.timingData = new ArrayList<Tuple<String, Long>>(Stage.values().length + 1);
        this.overallTimer = new ReplicationTimer();
        this.stageTimer = new ReplicationTimer();
        this.stageTimer.start();
        this.replicationId = -1L;
    }

    public SegmentReplicationState(ReplicationLuceneIndex index, long replicationId) {
        this(index);
        this.replicationId = replicationId;
    }

    @Override
    public ReplicationLuceneIndex getIndex() {
        return this.index;
    }

    public long getReplicationId() {
        return this.replicationId;
    }

    @Override
    public ReplicationTimer getTimer() {
        return this.overallTimer;
    }

    public List<Tuple<String, Long>> getTimingData() {
        return this.timingData;
    }

    public Stage getStage() {
        return this.stage;
    }

    protected void validateAndSetStage(Stage expected, Stage next) {
        if (this.stage != expected) {
            assert (false) : "can't move replication to stage [" + next + "]. current stage: [" + this.stage + "] (expected [" + expected + "])";
            throw new IllegalStateException("can't move replication to stage [" + next + "]. current stage: [" + this.stage + "] (expected [" + expected + "])");
        }
        this.stopTimersAndSetStage(next);
    }

    private void stopTimersAndSetStage(Stage next) {
        this.stageTimer.stop();
        this.timingData.add((Tuple<String, Long>)new Tuple((Object)this.stage.name(), (Object)this.stageTimer.time()));
        this.stageTimer.reset();
        this.stageTimer.start();
        this.stage = next;
    }

    public void setStage(Stage stage) {
        switch (stage) {
            case INIT: {
                this.stage = Stage.INIT;
                break;
            }
            case REPLICATING: {
                this.validateAndSetStage(Stage.INIT, stage);
                this.overallTimer.start();
                break;
            }
            case GET_CHECKPOINT_INFO: {
                this.validateAndSetStage(Stage.REPLICATING, stage);
                break;
            }
            case FILE_DIFF: {
                this.validateAndSetStage(Stage.GET_CHECKPOINT_INFO, stage);
                break;
            }
            case GET_FILES: {
                this.validateAndSetStage(Stage.FILE_DIFF, stage);
                break;
            }
            case FINALIZE_REPLICATION: {
                this.validateAndSetStage(Stage.GET_FILES, stage);
                break;
            }
            case DONE: {
                this.validateAndSetStage(Stage.FINALIZE_REPLICATION, stage);
                this.overallTimer.stop();
                this.timingData.add((Tuple<String, Long>)new Tuple((Object)"OVERALL", (Object)this.overallTimer.time()));
                break;
            }
            case CANCELLED: {
                if (this.stage == Stage.DONE) {
                    throw new IllegalStateException("can't move replication to Cancelled state from Done.");
                }
                this.stopTimersAndSetStage(Stage.CANCELLED);
                this.overallTimer.stop();
                this.timingData.add((Tuple<String, Long>)new Tuple((Object)"OVERALL", (Object)this.overallTimer.time()));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown SegmentReplicationState.Stage [" + stage + "]");
            }
        }
    }

    public static final class Stage
    extends Enum<Stage> {
        public static final /* enum */ Stage DONE = new Stage(0);
        public static final /* enum */ Stage INIT = new Stage(1);
        public static final /* enum */ Stage REPLICATING = new Stage(2);
        public static final /* enum */ Stage GET_CHECKPOINT_INFO = new Stage(3);
        public static final /* enum */ Stage FILE_DIFF = new Stage(4);
        public static final /* enum */ Stage GET_FILES = new Stage(5);
        public static final /* enum */ Stage FINALIZE_REPLICATION = new Stage(6);
        public static final /* enum */ Stage CANCELLED = new Stage(7);
        private static final Stage[] STAGES;
        private final byte id;
        private static final /* synthetic */ Stage[] $VALUES;

        public static Stage[] values() {
            return (Stage[])$VALUES.clone();
        }

        public static Stage valueOf(String name) {
            return Enum.valueOf(Stage.class, name);
        }

        private Stage(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Stage fromId(byte id) {
            if (id < 0 || id >= STAGES.length) {
                throw new IllegalArgumentException("No mapping for id [" + id + "]");
            }
            return STAGES[id];
        }

        static {
            $VALUES = new Stage[]{DONE, INIT, REPLICATING, GET_CHECKPOINT_INFO, FILE_DIFF, GET_FILES, FINALIZE_REPLICATION, CANCELLED};
            STAGES = new Stage[Stage.values().length];
            for (Stage stage : Stage.values()) {
                assert (stage.id() < STAGES.length && stage.id() >= 0);
                Stage.STAGES[stage.id] = stage;
            }
        }
    }
}

