/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.index;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.commons.notifications.action.CreateNotificationConfigRequest;
import org.opensearch.commons.notifications.action.CreateNotificationConfigResponse;
import org.opensearch.commons.notifications.action.DeleteNotificationConfigRequest;
import org.opensearch.commons.notifications.action.DeleteNotificationConfigResponse;
import org.opensearch.commons.notifications.action.GetChannelListRequest;
import org.opensearch.commons.notifications.action.GetChannelListResponse;
import org.opensearch.commons.notifications.action.GetNotificationConfigRequest;
import org.opensearch.commons.notifications.action.GetNotificationConfigResponse;
import org.opensearch.commons.notifications.action.UpdateNotificationConfigRequest;
import org.opensearch.commons.notifications.action.UpdateNotificationConfigResponse;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.Channel;
import org.opensearch.commons.notifications.model.ChannelList;
import org.opensearch.commons.notifications.model.Chime;
import org.opensearch.commons.notifications.model.ConfigType;
import org.opensearch.commons.notifications.model.Email;
import org.opensearch.commons.notifications.model.EmailGroup;
import org.opensearch.commons.notifications.model.NotificationConfig;
import org.opensearch.commons.notifications.model.NotificationConfigInfo;
import org.opensearch.commons.notifications.model.NotificationConfigSearchResult;
import org.opensearch.commons.notifications.model.SesAccount;
import org.opensearch.commons.notifications.model.Slack;
import org.opensearch.commons.notifications.model.SmtpAccount;
import org.opensearch.commons.notifications.model.Sns;
import org.opensearch.commons.notifications.model.Webhook;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.notifications.index.ConfigIndexingActions;
import org.opensearch.notifications.index.ConfigOperations;
import org.opensearch.notifications.metrics.Metrics;
import org.opensearch.notifications.model.DocMetadata;
import org.opensearch.notifications.model.NotificationConfigDoc;
import org.opensearch.notifications.model.NotificationConfigDocInfo;
import org.opensearch.notifications.security.UserAccess;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J#\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0014\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ#\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ#\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020 2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J#\u0010\"\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020 2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J#\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020%2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170(H\u0002J#\u0010)\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J)\u0010)\u001a\u00020\u001f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010*\u001a\u00020+2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ#\u0010,\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020.2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u001a\u00100\u001a\u00020+2\u0006\u00101\u001a\u0002022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J#\u00103\u001a\u00020+2\u0006\u00104\u001a\u0002052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J#\u00107\u001a\u00020+2\u0006\u00108\u001a\u0002092\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u001a\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020=2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020@2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u00020C2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010D\u001a\u00020+2\u0006\u0010E\u001a\u00020F2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010G\u001a\u00020+2\u0006\u0010H\u001a\u00020I2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010J\u001a\u00020+2\u0006\u0010K\u001a\u00020L2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006M"}, d2={"Lorg/opensearch/notifications/index/ConfigIndexingActions;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "operations", "Lorg/opensearch/notifications/index/ConfigOperations;", "userAccess", "Lorg/opensearch/notifications/security/UserAccess;", "create", "Lorg/opensearch/commons/notifications/action/CreateNotificationConfigResponse;", "request", "Lorg/opensearch/commons/notifications/action/CreateNotificationConfigRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/commons/notifications/action/CreateNotificationConfigRequest;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "delete", "Lorg/opensearch/commons/notifications/action/DeleteNotificationConfigResponse;", "configId", "", "(Ljava/lang/String;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configIds", "", "(Ljava/util/Set;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lorg/opensearch/commons/notifications/action/DeleteNotificationConfigRequest;", "(Lorg/opensearch/commons/notifications/action/DeleteNotificationConfigRequest;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "get", "Lorg/opensearch/commons/notifications/action/GetNotificationConfigResponse;", "Lorg/opensearch/commons/notifications/action/GetNotificationConfigRequest;", "(Lorg/opensearch/commons/notifications/action/GetNotificationConfigRequest;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAll", "getChannelList", "Lorg/opensearch/commons/notifications/action/GetChannelListResponse;", "Lorg/opensearch/commons/notifications/action/GetChannelListRequest;", "(Lorg/opensearch/commons/notifications/action/GetChannelListRequest;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSupportedChannelList", "", "info", "initialize", "", "update", "Lorg/opensearch/commons/notifications/action/UpdateNotificationConfigResponse;", "Lorg/opensearch/commons/notifications/action/UpdateNotificationConfigRequest;", "(Lorg/opensearch/commons/notifications/action/UpdateNotificationConfigRequest;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateChimeConfig", "chime", "Lorg/opensearch/commons/notifications/model/Chime;", "validateConfig", "config", "Lorg/opensearch/commons/notifications/model/NotificationConfig;", "(Lorg/opensearch/commons/notifications/model/NotificationConfig;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateEmailConfig", "email", "Lorg/opensearch/commons/notifications/model/Email;", "(Lorg/opensearch/commons/notifications/model/Email;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateEmailGroupConfig", "emailGroup", "Lorg/opensearch/commons/notifications/model/EmailGroup;", "validateSesAccountConfig", "sesAccount", "Lorg/opensearch/commons/notifications/model/SesAccount;", "validateSlackConfig", "slack", "Lorg/opensearch/commons/notifications/model/Slack;", "validateSmtpAccountConfig", "smtpAccount", "Lorg/opensearch/commons/notifications/model/SmtpAccount;", "validateSnsConfig", "sns", "Lorg/opensearch/commons/notifications/model/Sns;", "validateWebhookConfig", "webhook", "Lorg/opensearch/commons/notifications/model/Webhook;", "opensearch-notifications"})
public final class ConfigIndexingActions {
    @NotNull
    public static final ConfigIndexingActions INSTANCE = new ConfigIndexingActions();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ConfigIndexingActions.class);
    private static ConfigOperations operations;
    private static UserAccess userAccess;

    private ConfigIndexingActions() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull ConfigOperations operations, @NotNull UserAccess userAccess) {
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        Intrinsics.checkNotNullParameter((Object)userAccess, (String)"userAccess");
        ConfigIndexingActions.operations = operations;
        ConfigIndexingActions.userAccess = userAccess;
    }

    private final void validateSlackConfig(Slack slack, User user) {
    }

    private final void validateChimeConfig(Chime chime, User user) {
    }

    private final void validateWebhookConfig(Webhook webhook, User user) {
    }

    private final void validateSnsConfig(Sns sns, User user) {
    }

    /*
     * Unable to fully structure code
     */
    private final Object validateEmailConfig(Email var1_1, User var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof validateEmailConfig.1)) ** GOTO lbl-1000
        var18_4 = var3_3;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$validateEmailConfig(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var22_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (email.getEmailGroupIds().contains(email.getEmailAccountID())) {
                    throw new OpenSearchStatusException("Config IDs " + email.getEmailAccountID() + " is in both emailAccountID and emailGroupIds", RestStatus.BAD_REQUEST, new Object[0]);
                }
                configIds = CollectionsKt.union((Iterable)SetsKt.setOf((Object)email.getEmailAccountID()), (Iterable)email.getEmailGroupIds());
                v0 = ConfigIndexingActions.operations;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v0 = null;
                }
                $continuation.L$0 = email;
                $continuation.L$1 = user;
                $continuation.L$2 = configIds;
                $continuation.label = 1;
                v1 = v0.getNotificationConfigs(configIds, (Continuation<? super List<NotificationConfigDocInfo>>)$continuation);
                if (v1 == var22_6) {
                    return var22_6;
                }
                ** GOTO lbl33
            }
            case 1: {
                configIds = (Set)$continuation.L$2;
                user = (User)$continuation.L$1;
                email = (Email)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                if ((configDocs = (List)v1).size() != configIds.size()) {
                    $this$map$iv = configDocs;
                    $i$f$map = false;
                    var9_13 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_22 = (NotificationConfigDocInfo)item$iv$iv;
                        var16_24 = destination$iv$iv;
                        $i$a$-map-ConfigIndexingActions$validateEmailConfig$availableIds$1 = false;
                        var16_24.add(it.getDocInfo().getId());
                    }
                    availableIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    $this$filterNot$iv = configIds;
                    $i$f$filterNot = false;
                    $this$mapTo$iv$iv = $this$filterNot$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        it = (String)element$iv$iv;
                        $i$a$-filterNot-ConfigIndexingActions$validateEmailConfig$2 = false;
                        if (availableIds.contains(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    var19_27 = new Object[]{};
                    var20_28 = RestStatus.NOT_FOUND;
                    var21_29 = "Config IDs not found:" + (List)destination$iv$iv;
                    throw new OpenSearchStatusException(var21_29, var20_28, var19_27);
                }
                $this$forEach$iv = configDocs;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (NotificationConfigDocInfo)element$iv;
                    $i$a$-forEach-ConfigIndexingActions$validateEmailConfig$3 = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[it.getConfigDoc().getConfig().getConfigType().ordinal()]) {
                        case 1: {
                            if (!Intrinsics.areEqual((Object)it.getDocInfo().getId(), (Object)email.getEmailAccountID())) break;
                            Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_ACCOUNT_ID.getCounter().increment();
                            throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email account ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                        }
                        case 2: {
                            if (Intrinsics.areEqual((Object)it.getDocInfo().getId(), (Object)email.getEmailAccountID())) break;
                            Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_GROUP_ID.getCounter().increment();
                            throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email group ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                        }
                        case 3: {
                            if (Intrinsics.areEqual((Object)it.getDocInfo().getId(), (Object)email.getEmailAccountID())) break;
                            Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_GROUP_ID.getCounter().increment();
                            throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email group ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                        }
                        default: {
                            Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_NEITHER_EMAIL_NOR_GROUP.getCounter().increment();
                            throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email group ID or email account ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                        }
                    }
                    currentMetadata = it.getConfigDoc().getMetadata();
                    v2 = ConfigIndexingActions.userAccess;
                    if (v2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                        v2 = null;
                    }
                    if (v2.doesUserHaveAccess(user, currentMetadata.getAccess())) continue;
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + it.getDocInfo().getId(), RestStatus.FORBIDDEN, new Object[0]);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void validateSmtpAccountConfig(SmtpAccount smtpAccount, User user) {
    }

    private final void validateSesAccountConfig(SesAccount sesAccount, User user) {
    }

    private final void validateEmailGroupConfig(EmailGroup emailGroup, User user) {
    }

    private final Object validateConfig(NotificationConfig config, User user, Continuation<? super Unit> $completion) {
        switch (WhenMappings.$EnumSwitchMapping$0[config.getConfigType().ordinal()]) {
            case 4: {
                throw new OpenSearchStatusException("NotificationConfig with type NONE is not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
            }
            case 5: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.Slack");
                }
                this.validateSlackConfig((Slack)baseConfigData, user);
                break;
            }
            case 6: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.Chime");
                }
                this.validateChimeConfig((Chime)baseConfigData, user);
                break;
            }
            case 7: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.Webhook");
                }
                this.validateWebhookConfig((Webhook)baseConfigData, user);
                break;
            }
            case 8: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.Email");
                }
                Object object = this.validateEmailConfig((Email)baseConfigData, user, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            case 2: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.SmtpAccount");
                }
                this.validateSmtpAccountConfig((SmtpAccount)baseConfigData, user);
                break;
            }
            case 3: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.SesAccount");
                }
                this.validateSesAccountConfig((SesAccount)baseConfigData, user);
                break;
            }
            case 1: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.EmailGroup");
                }
                this.validateEmailGroupConfig((EmailGroup)baseConfigData, user);
                break;
            }
            case 9: {
                BaseConfigData baseConfigData = config.getConfigData();
                if (baseConfigData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.notifications.model.Sns");
                }
                this.validateSnsConfig((Sns)baseConfigData, user);
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object create(@NotNull CreateNotificationConfigRequest var1_1, @Nullable User var2_2, @NotNull Continuation<? super CreateNotificationConfigResponse> var3_3) {
        if (!(var3_3 instanceof create.1)) ** GOTO lbl-1000
        var10_4 = var3_3;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.create(null, null, (Continuation<? super CreateNotificationConfigResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-create");
                v0 = ConfigIndexingActions.userAccess;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v0 = null;
                }
                v0.validateUser(user);
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = user;
                $continuation.label = 1;
                v1 = this.validateConfig(request.getNotificationConfig(), user, (Continuation<? super Unit>)$continuation);
                if (v1 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                user = (User)$continuation.L$2;
                request = (CreateNotificationConfigRequest)$continuation.L$1;
                this = (ConfigIndexingActions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                currentTime = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)currentTime, (String)"currentTime");
                v2 = ConfigIndexingActions.userAccess;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v2 = null;
                }
                metadata = new DocMetadata(currentTime, currentTime, v2.getAllAccessInfo(user));
                configDoc = new NotificationConfigDoc(metadata, request.getNotificationConfig());
                v3 = ConfigIndexingActions.operations;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v3 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v4 = v3.createNotificationConfig(configDoc, request.getConfigId(), (Continuation<? super String>)$continuation);
                if (v4 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl56
            }
            case 2: {
                this = (ConfigIndexingActions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl56:
                // 2 sources

                if ((docId = (String)v4) == null) {
                    $i$a$-run-ConfigIndexingActions$create$2 = false;
                    Metrics.NOTIFICATIONS_CONFIG_CREATE_SYSTEM_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig Creation failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                return new CreateNotificationConfigResponse(docId);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object update(@NotNull UpdateNotificationConfigRequest var1_1, @Nullable User var2_2, @NotNull Continuation<? super UpdateNotificationConfigResponse> var3_3) {
        if (!(var3_3 instanceof update.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.update(null, null, (Continuation<? super UpdateNotificationConfigResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-update " + request.getConfigId());
                v0 = ConfigIndexingActions.userAccess;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v0 = null;
                }
                v0.validateUser(user);
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = user;
                $continuation.label = 1;
                v1 = this.validateConfig(request.getNotificationConfig(), user, (Continuation<? super Unit>)$continuation);
                if (v1 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                user = (User)$continuation.L$2;
                request = (UpdateNotificationConfigRequest)$continuation.L$1;
                this = (ConfigIndexingActions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                if ((v2 = ConfigIndexingActions.operations) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v2 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = user;
                $continuation.label = 2;
                v3 = v2.getNotificationConfig(request.getConfigId(), (Continuation<? super NotificationConfigDocInfo>)$continuation);
                if (v3 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl49
            }
            case 2: {
                user = (User)$continuation.L$2;
                request = (UpdateNotificationConfigRequest)$continuation.L$1;
                this = (ConfigIndexingActions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl49:
                // 2 sources

                if ((currentConfigDoc = (NotificationConfigDocInfo)v3) == null) {
                    $i$a$-run-ConfigIndexingActions$update$2 = false;
                    Metrics.NOTIFICATIONS_CONFIG_UPDATE_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + request.getConfigId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                currentMetadata = currentConfigDoc.getConfigDoc().getMetadata();
                v4 = ConfigIndexingActions.userAccess;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v4 = null;
                }
                if (!v4.doesUserHaveAccess(user, currentMetadata.getAccess())) {
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + request.getConfigId(), RestStatus.FORBIDDEN, new Object[0]);
                }
                if (currentConfigDoc.getConfigDoc().getConfig().getConfigType() != request.getNotificationConfig().getConfigType()) {
                    throw new OpenSearchStatusException("Config type cannot be changed after creation", RestStatus.CONFLICT, new Object[0]);
                }
                $i$a$-run-ConfigIndexingActions$update$2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)$i$a$-run-ConfigIndexingActions$update$2, (String)"now()");
                newMetadata = DocMetadata.copy$default(currentMetadata, $i$a$-run-ConfigIndexingActions$update$2, null, null, 6, null);
                newConfigData = new NotificationConfigDoc(newMetadata, request.getNotificationConfig());
                v5 = ConfigIndexingActions.operations;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v5 = null;
                }
                $continuation.L$0 = request;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v6 = v5.updateNotificationConfig(request.getConfigId(), newConfigData, (Continuation<? super Boolean>)$continuation);
                if (v6 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl84
            }
            case 3: {
                request = (UpdateNotificationConfigRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl84:
                // 2 sources

                if (!((Boolean)v6).booleanValue()) {
                    Metrics.NOTIFICATIONS_CONFIG_UPDATE_SYSTEM_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig Update failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                return new UpdateNotificationConfigResponse(request.getConfigId());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object get(@NotNull GetNotificationConfigRequest request, @Nullable User user, @NotNull Continuation<? super GetNotificationConfigResponse> $completion) {
        this.getLog().info("notifications:NotificationConfig-get " + request);
        UserAccess userAccess = ConfigIndexingActions.userAccess;
        if (userAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess = null;
        }
        userAccess.validateUser(user);
        switch (request.getConfigIds().size()) {
            case 0: {
                return this.getAll(request, user, $completion);
            }
            case 1: {
                return this.info((String)CollectionsKt.first((Iterable)request.getConfigIds()), user, $completion);
            }
        }
        return this.info(request.getConfigIds(), user, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object info(String var1_1, User var2_2, Continuation<? super GetNotificationConfigResponse> var3_3) {
        if (!(var3_3 instanceof info.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$info(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-info " + configId);
                v0 = ConfigIndexingActions.operations;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v0 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = configId;
                $continuation.L$2 = user;
                $continuation.label = 1;
                v1 = v0.getNotificationConfig(configId, (Continuation<? super NotificationConfigDocInfo>)$continuation);
                if (v1 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl31
            }
            case 1: {
                user = (User)$continuation.L$2;
                configId = (String)$continuation.L$1;
                this = (ConfigIndexingActions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 2 sources

                if ((configDoc = (NotificationConfigDocInfo)v1) == null) {
                    $i$a$-run-ConfigIndexingActions$info$2 = false;
                    Metrics.NOTIFICATIONS_CONFIG_INFO_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + configId + " not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                metadata = configDoc.getConfigDoc().getMetadata();
                v2 = ConfigIndexingActions.userAccess;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v2 = null;
                }
                if (!v2.doesUserHaveAccess(user, metadata.getAccess())) {
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + configId, RestStatus.FORBIDDEN, new Object[0]);
                }
                configInfo = new NotificationConfigInfo(configId, metadata.getLastUpdateTime(), metadata.getCreatedTime(), configDoc.getConfigDoc().getConfig());
                return new GetNotificationConfigResponse(new NotificationConfigSearchResult(configInfo));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object info(Set<String> var1_1, User var2_2, Continuation<? super GetNotificationConfigResponse> var3_3) {
        if (!(var3_3 instanceof info.3)) ** GOTO lbl-1000
        var17_4 = var3_3;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$info(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-info " + configIds);
                v0 = ConfigIndexingActions.operations;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v0 = null;
                }
                $continuation.L$0 = configIds;
                $continuation.L$1 = user;
                $continuation.label = 1;
                v1 = v0.getNotificationConfigs(configIds, (Continuation<? super List<NotificationConfigDocInfo>>)$continuation);
                if (v1 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                user = (User)$continuation.L$1;
                configIds = (Set)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                if ((configDocs = (List)v1).size() != configIds.size()) {
                    mutableSet = CollectionsKt.toMutableSet((Iterable)configIds);
                    $this$forEach$iv = configDocs;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (NotificationConfigDocInfo)element$iv;
                        $i$a$-forEach-ConfigIndexingActions$info$4 = false;
                        ((Collection)mutableSet).remove(it.getDocInfo().getId());
                    }
                    Metrics.NOTIFICATIONS_CONFIG_INFO_USER_ERROR_SET_NOT_FOUND.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + mutableSet + " not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                $this$forEach$iv = configDocs;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (NotificationConfigDocInfo)element$iv /* !! */ ;
                    $i$a$-forEach-ConfigIndexingActions$info$5 = false;
                    currentMetadata = it.getConfigDoc().getMetadata();
                    v2 = ConfigIndexingActions.userAccess;
                    if (v2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                        v2 = null;
                    }
                    if (v2.doesUserHaveAccess(user, currentMetadata.getAccess())) continue;
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + it.getDocInfo().getId(), RestStatus.FORBIDDEN, new Object[0]);
                }
                $this$map$iv = configDocs;
                $i$f$map = false;
                element$iv /* !! */  = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var13_25 = (NotificationConfigDocInfo)item$iv$iv;
                    var15_27 = destination$iv$iv;
                    $i$a$-map-ConfigIndexingActions$info$configSearchResult$1 = false;
                    v3 = it.getDocInfo().getId();
                    Intrinsics.checkNotNull((Object)v3);
                    var15_27.add(new NotificationConfigInfo(v3, it.getConfigDoc().getMetadata().getLastUpdateTime(), it.getConfigDoc().getMetadata().getCreatedTime(), it.getConfigDoc().getConfig()));
                }
                configSearchResult = (List)destination$iv$iv;
                return new GetNotificationConfigResponse(new NotificationConfigSearchResult(configSearchResult));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getAll(GetNotificationConfigRequest var1_1, User var2_2, Continuation<? super GetNotificationConfigResponse> var3_3) {
        if (!(var3_3 instanceof getAll.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$getAll(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-getAll");
                v0 = ConfigIndexingActions.operations;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v0 = null;
                }
                if ((v1 = ConfigIndexingActions.userAccess) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v1 = null;
                }
                $continuation.label = 1;
                v2 = v0.getAllNotificationConfigs(v1.getSearchAccessInfo((User)user), (GetNotificationConfigRequest)request, (Continuation<? super NotificationConfigSearchResult>)$continuation);
                if (v2 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl28:
                // 2 sources

                searchResult = (NotificationConfigSearchResult)v2;
                return new GetNotificationConfigResponse(searchResult);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getChannelList(@NotNull GetChannelListRequest var1_1, @Nullable User var2_2, @NotNull Continuation<? super GetChannelListResponse> var3_3) {
        if (!(var3_3 instanceof getChannelList.1)) ** GOTO lbl-1000
        var22_4 = var3_3;
        if ((var22_4.label & -2147483648) != 0) {
            var22_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getChannelList(null, null, (Continuation<? super GetChannelListResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:getChannelList " + (GetChannelListRequest)request);
                v0 = ConfigIndexingActions.userAccess;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v0 = null;
                }
                v0.validateUser((User)user);
                supportedChannelListString = CollectionsKt.joinToString$default((Iterable)this.getSupportedChannelList(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                filterParams = MapsKt.mapOf((Pair)new Pair((Object)"config_type", (Object)supportedChannelListString));
                getAllRequest = new GetNotificationConfigRequest(null, 0, 0, null, null, filterParams, 31, null);
                v1 = ConfigIndexingActions.operations;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v1 = null;
                }
                if ((v2 = ConfigIndexingActions.userAccess) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v2 = null;
                }
                $continuation.label = 1;
                v3 = v1.getAllNotificationConfigs(v2.getSearchAccessInfo((User)user), getAllRequest, (Continuation<? super NotificationConfigSearchResult>)$continuation);
                if (v3 == var23_6) {
                    return var23_6;
                }
                ** GOTO lbl36
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl36:
                // 2 sources

                getAllResult = (NotificationConfigSearchResult)v3;
                $this$map$iv = getAllResult.getObjectList();
                $i$f$map = false;
                var11_13 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var16_18 = (NotificationConfigInfo)item$iv$iv;
                    var20_22 = destination$iv$iv;
                    $i$a$-map-ConfigIndexingActions$getChannelList$searchResult$1 = false;
                    configId = it.getConfigId();
                    config = it.getNotificationConfig();
                    var20_22.add(new Channel(configId, config.getName(), config.getDescription(), config.getConfigType(), config.isEnabled()));
                }
                searchResult = (List)destination$iv$iv;
                ChannelList = new ChannelList(searchResult);
                return new GetChannelListResponse(ChannelList);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final List<String> getSupportedChannelList() {
        Object[] objectArray = new String[]{ConfigType.SLACK.getTag(), ConfigType.CHIME.getTag(), ConfigType.WEBHOOK.getTag(), ConfigType.EMAIL.getTag(), ConfigType.SNS.getTag()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Unable to fully structure code
     */
    private final Object delete(String var1_1, User var2_2, Continuation<? super DeleteNotificationConfigResponse> var3_3) {
        if (!(var3_3 instanceof delete.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$delete(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-delete " + configId);
                v0 = ConfigIndexingActions.userAccess;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v0 = null;
                }
                v0.validateUser(user);
                v1 = ConfigIndexingActions.operations;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v1 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = configId;
                $continuation.L$2 = user;
                $continuation.label = 1;
                v2 = v1.getNotificationConfig(configId, (Continuation<? super NotificationConfigDocInfo>)$continuation);
                if (v2 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl36
            }
            case 1: {
                user = (User)$continuation.L$2;
                configId = (String)$continuation.L$1;
                this = (ConfigIndexingActions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl36:
                // 2 sources

                if ((currentConfigDoc = (NotificationConfigDocInfo)v2) == null) {
                    $i$a$-run-ConfigIndexingActions$delete$2 = false;
                    Metrics.NOTIFICATIONS_CONFIG_DELETE_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + configId + " not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                currentMetadata = currentConfigDoc.getConfigDoc().getMetadata();
                v3 = ConfigIndexingActions.userAccess;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v3 = null;
                }
                if (!v3.doesUserHaveAccess(user, currentMetadata.getAccess())) {
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + configId, RestStatus.FORBIDDEN, new Object[0]);
                }
                v4 = ConfigIndexingActions.operations;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v4 = null;
                }
                $continuation.L$0 = configId;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v5 = v4.deleteNotificationConfig(configId, (Continuation<? super Boolean>)$continuation);
                if (v5 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl65
            }
            case 2: {
                configId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl65:
                // 2 sources

                if (!((Boolean)v5).booleanValue()) {
                    Metrics.NOTIFICATIONS_CONFIG_DELETE_SYSTEM_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + configId + " delete failed", RestStatus.REQUEST_TIMEOUT, new Object[0]);
                }
                return new DeleteNotificationConfigResponse(MapsKt.mapOf((Pair)new Pair((Object)configId, (Object)RestStatus.OK)));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object delete(Set<String> var1_1, User var2_2, Continuation<? super DeleteNotificationConfigResponse> var3_3) {
        if (!(var3_3 instanceof delete.3)) ** GOTO lbl-1000
        var13_4 = var3_3;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$delete(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-delete " + configIds);
                v0 = ConfigIndexingActions.userAccess;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v0 = null;
                }
                v0.validateUser(user);
                v1 = ConfigIndexingActions.operations;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v1 = null;
                }
                $continuation.L$0 = configIds;
                $continuation.L$1 = user;
                $continuation.label = 1;
                v2 = v1.getNotificationConfigs(configIds, (Continuation<? super List<NotificationConfigDocInfo>>)$continuation);
                if (v2 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl34
            }
            case 1: {
                user = (User)$continuation.L$1;
                configIds = (Set)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl34:
                // 2 sources

                if ((configDocs = (List)v2).size() != configIds.size()) {
                    mutableSet = CollectionsKt.toMutableSet((Iterable)configIds);
                    $this$forEach$iv = configDocs;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (NotificationConfigDocInfo)element$iv;
                        $i$a$-forEach-ConfigIndexingActions$delete$4 = false;
                        ((Collection)mutableSet).remove(it.getDocInfo().getId());
                    }
                    Metrics.NOTIFICATIONS_CONFIG_DELETE_USER_ERROR_SET_NOT_FOUND.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + mutableSet + " not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                $this$forEach$iv = configDocs;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (NotificationConfigDocInfo)element$iv;
                    $i$a$-forEach-ConfigIndexingActions$delete$5 = false;
                    currentMetadata = it.getConfigDoc().getMetadata();
                    v3 = ConfigIndexingActions.userAccess;
                    if (v3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                        v3 = null;
                    }
                    if (v3.doesUserHaveAccess(user, currentMetadata.getAccess())) continue;
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + it.getDocInfo().getId(), RestStatus.FORBIDDEN, new Object[0]);
                }
                v4 = ConfigIndexingActions.operations;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v4 = null;
                }
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v5 = v4.deleteNotificationConfigs(configIds, (Continuation<? super Map<String, ? extends RestStatus>>)$continuation);
                if (v5 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl74
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl74:
                // 2 sources

                deleteStatus = (Map)v5;
                return new DeleteNotificationConfigResponse(deleteStatus);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object delete(@NotNull DeleteNotificationConfigRequest request, @Nullable User user, @NotNull Continuation<? super DeleteNotificationConfigResponse> $completion) {
        this.getLog().info("notifications:NotificationConfig-delete " + request.getConfigIds());
        if (request.getConfigIds().size() == 1) {
            return this.delete((String)CollectionsKt.first((Iterable)request.getConfigIds()), user, $completion);
        }
        return this.delete(request.getConfigIds(), user, $completion);
    }

    public static final /* synthetic */ Object access$validateEmailConfig(ConfigIndexingActions $this, Email email, User user, Continuation $completion) {
        return $this.validateEmailConfig(email, user, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$validateConfig(ConfigIndexingActions $this, NotificationConfig config, User user, Continuation $completion) {
        return $this.validateConfig(config, user, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$info(ConfigIndexingActions $this, String configId, User user, Continuation $completion) {
        return $this.info(configId, user, (Continuation<? super GetNotificationConfigResponse>)$completion);
    }

    public static final /* synthetic */ Object access$info(ConfigIndexingActions $this, Set configIds, User user, Continuation $completion) {
        return $this.info(configIds, user, (Continuation<? super GetNotificationConfigResponse>)$completion);
    }

    public static final /* synthetic */ Object access$getAll(ConfigIndexingActions $this, GetNotificationConfigRequest request, User user, Continuation $completion) {
        return $this.getAll(request, user, (Continuation<? super GetNotificationConfigResponse>)$completion);
    }

    public static final /* synthetic */ Object access$delete(ConfigIndexingActions $this, String configId, User user, Continuation $completion) {
        return $this.delete(configId, user, (Continuation<? super DeleteNotificationConfigResponse>)$completion);
    }

    public static final /* synthetic */ Object access$delete(ConfigIndexingActions $this, Set configIds, User user, Continuation $completion) {
        return $this.delete(configIds, user, (Continuation<? super DeleteNotificationConfigResponse>)$completion);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigType.values().length];
            nArray[ConfigType.EMAIL_GROUP.ordinal()] = 1;
            nArray[ConfigType.SMTP_ACCOUNT.ordinal()] = 2;
            nArray[ConfigType.SES_ACCOUNT.ordinal()] = 3;
            nArray[ConfigType.NONE.ordinal()] = 4;
            nArray[ConfigType.SLACK.ordinal()] = 5;
            nArray[ConfigType.CHIME.ordinal()] = 6;
            nArray[ConfigType.WEBHOOK.ordinal()] = 7;
            nArray[ConfigType.EMAIL.ordinal()] = 8;
            nArray[ConfigType.SNS.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

