/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.flipkart.zjsonpatch.CompatibilityFlags;
import com.flipkart.zjsonpatch.CopyingApplyProcessor;
import com.flipkart.zjsonpatch.InPlaceApplyProcessor;
import com.flipkart.zjsonpatch.InvalidJsonPatchException;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import com.flipkart.zjsonpatch.JsonPatchProcessor;
import com.flipkart.zjsonpatch.NoopProcessor;
import com.flipkart.zjsonpatch.Operation;
import com.flipkart.zjsonpatch.PathUtils;
import java.util.EnumSet;
import java.util.List;

public final class JsonPatch {
    private JsonPatch() {
    }

    private static JsonNode getPatchAttr(JsonNode jsonNode, String attr) {
        JsonNode child = jsonNode.get(attr);
        if (child == null) {
            throw new InvalidJsonPatchException("Invalid JSON Patch payload (missing '" + attr + "' field)");
        }
        return child;
    }

    private static JsonNode getPatchAttrWithDefault(JsonNode jsonNode, String attr, JsonNode defaultValue) {
        JsonNode child = jsonNode.get(attr);
        if (child == null) {
            return defaultValue;
        }
        return child;
    }

    private static void process(JsonNode patch, JsonPatchProcessor processor, EnumSet<CompatibilityFlags> flags) throws InvalidJsonPatchException {
        if (!patch.isArray()) {
            throw new InvalidJsonPatchException("Invalid JSON Patch payload (not an array)");
        }
        for (JsonNode jsonNode : patch) {
            if (!jsonNode.isObject()) {
                throw new InvalidJsonPatchException("Invalid JSON Patch payload (not an object)");
            }
            Operation operation = Operation.fromRfcName(JsonPatch.getPatchAttr(jsonNode, "op").toString().replaceAll("\"", ""));
            List<String> path = PathUtils.getPath(JsonPatch.getPatchAttr(jsonNode, "path"));
            switch (operation) {
                case REMOVE: {
                    processor.remove(path);
                    break;
                }
                case ADD: {
                    JsonNode value = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? JsonPatch.getPatchAttr(jsonNode, "value") : JsonPatch.getPatchAttrWithDefault(jsonNode, "value", (JsonNode)NullNode.getInstance());
                    processor.add(path, value.deepCopy());
                    break;
                }
                case REPLACE: {
                    JsonNode value = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? JsonPatch.getPatchAttr(jsonNode, "value") : JsonPatch.getPatchAttrWithDefault(jsonNode, "value", (JsonNode)NullNode.getInstance());
                    processor.replace(path, value.deepCopy());
                    break;
                }
                case MOVE: {
                    List<String> fromPath = PathUtils.getPath(JsonPatch.getPatchAttr(jsonNode, "from"));
                    processor.move(fromPath, path);
                    break;
                }
                case COPY: {
                    List<String> fromPath = PathUtils.getPath(JsonPatch.getPatchAttr(jsonNode, "from"));
                    processor.copy(fromPath, path);
                    break;
                }
                case TEST: {
                    JsonNode value = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? JsonPatch.getPatchAttr(jsonNode, "value") : JsonPatch.getPatchAttrWithDefault(jsonNode, "value", (JsonNode)NullNode.getInstance());
                    processor.test(path, value.deepCopy());
                    break;
                }
            }
        }
    }

    public static void validate(JsonNode patch, EnumSet<CompatibilityFlags> flags) throws InvalidJsonPatchException {
        JsonPatch.process(patch, NoopProcessor.INSTANCE, flags);
    }

    public static void validate(JsonNode patch) throws InvalidJsonPatchException {
        JsonPatch.validate(patch, CompatibilityFlags.defaults());
    }

    public static JsonNode apply(JsonNode patch, JsonNode source, EnumSet<CompatibilityFlags> flags) throws JsonPatchApplicationException {
        CopyingApplyProcessor processor = new CopyingApplyProcessor(source, flags);
        JsonPatch.process(patch, processor, flags);
        return processor.result();
    }

    public static JsonNode apply(JsonNode patch, JsonNode source) throws JsonPatchApplicationException {
        return JsonPatch.apply(patch, source, CompatibilityFlags.defaults());
    }

    public static void applyInPlace(JsonNode patch, JsonNode source) {
        JsonPatch.applyInPlace(patch, source, CompatibilityFlags.defaults());
    }

    public static void applyInPlace(JsonNode patch, JsonNode source, EnumSet<CompatibilityFlags> flags) {
        InPlaceApplyProcessor processor = new InPlaceApplyProcessor(source, flags);
        JsonPatch.process(patch, processor, flags);
    }
}

