/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class GraphicalDelayText
extends GraphicalElement {
    private final Component compText;
    private final ParticipantBox p1;
    private final ParticipantBox p2;

    public GraphicalDelayText(double startingY, Component compText, ParticipantBox first, ParticipantBox last) {
        super(startingY);
        this.compText = compText;
        this.p1 = first;
        this.p2 = last;
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        StringBounder stringBounder = ug.getStringBounder();
        double x1 = this.p1.getCenterX(stringBounder);
        double x2 = this.p2.getCenterX(stringBounder);
        double middle = (x1 + x2) / 2.0;
        double textWidth = this.compText.getPreferredWidth(stringBounder);
        ug = ug.apply(new UTranslate(middle - textWidth / 2.0, this.getStartingY()));
        XDimension2D dim = new XDimension2D(textWidth, this.compText.getPreferredHeight(stringBounder));
        this.compText.drawU(ug, new Area(dim), context);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.compText.getPreferredHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.compText.getPreferredWidth(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        return 0.0;
    }

    public double getEndingY(StringBounder stringBounder) {
        return this.getStartingY() + this.compText.getPreferredHeight(stringBounder);
    }
}

