/* Multitasking.c generated by valac 0.56.3, the Vala compiler
 * generated from Multitasking.vala, do not modify */

/*
* Copyright 2011-2019 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Tom Beckmann
*/

#include "pantheon-desktop.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <handy.h>

#define PANTHEON_SHELL_MULTITASKING_ANIMATIONS_SCHEMA "org.pantheon.desktop.gala.animations"
#define PANTHEON_SHELL_MULTITASKING_ANIMATIONS_KEY "enable-animations"

enum  {
	PANTHEON_SHELL_MULTITASKING_0_PROPERTY,
	PANTHEON_SHELL_MULTITASKING_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_multitasking_properties[PANTHEON_SHELL_MULTITASKING_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL (pantheon_shell_multitasking_hotcorner_control_get_type ())
#define PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl))
#define PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControlClass))
#define PANTHEON_SHELL_MULTITASKING_IS_HOTCORNER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL))
#define PANTHEON_SHELL_MULTITASKING_IS_HOTCORNER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL))
#define PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControlClass))

typedef struct _PantheonShellMultitaskingHotcornerControl PantheonShellMultitaskingHotcornerControl;
typedef struct _PantheonShellMultitaskingHotcornerControlClass PantheonShellMultitaskingHotcornerControlClass;
typedef struct _PantheonShellMultitaskingHotcornerControlPrivate PantheonShellMultitaskingHotcornerControlPrivate;
enum  {
	PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_0_PROPERTY,
	PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY,
	PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY,
	PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_multitasking_hotcorner_control_properties[PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _PantheonShellMultitaskingPrivate {
	GSettings* behavior_settings;
};

struct _PantheonShellMultitaskingHotcornerControl {
	GtkGrid parent_instance;
	PantheonShellMultitaskingHotcornerControlPrivate * priv;
};

struct _PantheonShellMultitaskingHotcornerControlClass {
	GtkGridClass parent_class;
};

struct _PantheonShellMultitaskingHotcornerControlPrivate {
	gchar* _label;
	gchar* _position;
	GtkEntry* command_entry;
};

static gint PantheonShellMultitasking_private_offset;
static gpointer pantheon_shell_multitasking_parent_class = NULL;
static gint PantheonShellMultitaskingHotcornerControl_private_offset;
static gpointer pantheon_shell_multitasking_hotcorner_control_parent_class = NULL;
static GSettings* pantheon_shell_multitasking_hotcorner_control_settings;
static GSettings* pantheon_shell_multitasking_hotcorner_control_settings = NULL;
static GtkSizeGroup* pantheon_shell_multitasking_hotcorner_control_size_group;
static GtkSizeGroup* pantheon_shell_multitasking_hotcorner_control_size_group = NULL;

static GType pantheon_shell_multitasking_hotcorner_control_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PantheonShellMultitaskingHotcornerControl* pantheon_shell_multitasking_hotcorner_control_new (const gchar* label,
                                                                                              const gchar* position);
static PantheonShellMultitaskingHotcornerControl* pantheon_shell_multitasking_hotcorner_control_construct (GType object_type,
                                                                                                    const gchar* label,
                                                                                                    const gchar* position);
static void pantheon_shell_multitasking_hotcorner_control_get_command_string (PantheonShellMultitaskingHotcornerControl* self);
static const gchar* pantheon_shell_multitasking_hotcorner_control_get_position (PantheonShellMultitaskingHotcornerControl* self);
static const gchar* pantheon_shell_multitasking_hotcorner_control_get_label (PantheonShellMultitaskingHotcornerControl* self);
static void pantheon_shell_multitasking_hotcorner_control_set_label (PantheonShellMultitaskingHotcornerControl* self,
                                                              const gchar* value);
static void pantheon_shell_multitasking_hotcorner_control_set_position (PantheonShellMultitaskingHotcornerControl* self,
                                                                 const gchar* value);
static GObject * pantheon_shell_multitasking_hotcorner_control_constructor (GType type,
                                                                     guint n_construct_properties,
                                                                     GObjectConstructParam * construct_properties);
static gboolean _pantheon_shell_multitasking_hotcorner_control___lambda13_ (GValue* value,
                                                                     GVariant* variant,
                                                                     void* user_data);
static gboolean __pantheon_shell_multitasking_hotcorner_control___lambda13__gsettings_bind_get_mapping (GValue* value,
                                                                                                 GVariant* variant,
                                                                                                 void* user_data);
static GVariant* _pantheon_shell_multitasking_hotcorner_control___lambda14_ (GValue* value,
                                                                      const GVariantType* expected_type,
                                                                      void* user_data);
static GVariant* __pantheon_shell_multitasking_hotcorner_control___lambda14__gsettings_bind_set_mapping (GValue* value,
                                                                                                  const GVariantType* expected_type,
                                                                                                  void* user_data);
static void _pantheon_shell_multitasking_hotcorner_control___lambda15_ (PantheonShellMultitaskingHotcornerControl* self);
static void __pantheon_shell_multitasking_hotcorner_control___lambda15__g_settings_changed (GSettings* _sender,
                                                                                     const gchar* key,
                                                                                     gpointer self);
static void _pantheon_shell_multitasking_hotcorner_control___lambda16_ (PantheonShellMultitaskingHotcornerControl* self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void __pantheon_shell_multitasking_hotcorner_control___lambda16__gtk_editable_changed (GtkEditable* _sender,
                                                                                       gpointer self);
static void pantheon_shell_multitasking_hotcorner_control_finalize (GObject * obj);
static GType pantheon_shell_multitasking_hotcorner_control_get_type_once (void);
static void _vala_pantheon_shell_multitasking_hotcorner_control_get_property (GObject * object,
                                                                       guint property_id,
                                                                       GValue * value,
                                                                       GParamSpec * pspec);
static void _vala_pantheon_shell_multitasking_hotcorner_control_set_property (GObject * object,
                                                                       guint property_id,
                                                                       const GValue * value,
                                                                       GParamSpec * pspec);
static GObject * pantheon_shell_multitasking_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void pantheon_shell_multitasking_finalize (GObject * obj);
static GType pantheon_shell_multitasking_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
pantheon_shell_multitasking_get_instance_private (PantheonShellMultitasking* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellMultitasking_private_offset);
}

PantheonShellMultitasking*
pantheon_shell_multitasking_construct (GType object_type)
{
	PantheonShellMultitasking * self = NULL;
	self = (PantheonShellMultitasking*) g_object_new (object_type, NULL);
	return self;
}

PantheonShellMultitasking*
pantheon_shell_multitasking_new (void)
{
	return pantheon_shell_multitasking_construct (PANTHEON_SHELL_TYPE_MULTITASKING);
}

static inline gpointer
pantheon_shell_multitasking_hotcorner_control_get_instance_private (PantheonShellMultitaskingHotcornerControl* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellMultitaskingHotcornerControl_private_offset);
}

static PantheonShellMultitaskingHotcornerControl*
pantheon_shell_multitasking_hotcorner_control_construct (GType object_type,
                                                         const gchar* label,
                                                         const gchar* position)
{
	PantheonShellMultitaskingHotcornerControl * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (position != NULL, NULL);
	self = (PantheonShellMultitaskingHotcornerControl*) g_object_new (object_type, "label", label, "position", position, NULL);
	return self;
}

static PantheonShellMultitaskingHotcornerControl*
pantheon_shell_multitasking_hotcorner_control_new (const gchar* label,
                                                   const gchar* position)
{
	return pantheon_shell_multitasking_hotcorner_control_construct (PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, label, position);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
pantheon_shell_multitasking_hotcorner_control_get_command_string (PantheonShellMultitaskingHotcornerControl* self)
{
	gchar* setting_string = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* this_command = NULL;
	gchar* _tmp2_;
	gchar** commands = NULL;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint commands_length1;
	gint _commands_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GtkEntry* _tmp17_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pantheon_shell_multitasking_hotcorner_control_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "hotcorner-custom-command");
	setting_string = _tmp1_;
	_tmp2_ = g_strdup ("");
	this_command = _tmp2_;
	_tmp3_ = setting_string;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ";;", 0);
	commands = _tmp5_;
	commands_length1 = _vala_array_length (_tmp4_);
	_commands_size_ = commands_length1;
	_tmp6_ = commands;
	_tmp6__length1 = commands_length1;
	{
		gchar** command_collection = NULL;
		gint command_collection_length1 = 0;
		gint _command_collection_size_ = 0;
		gint command_it = 0;
		command_collection = _tmp6_;
		command_collection_length1 = _tmp6__length1;
		for (command_it = 0; command_it < command_collection_length1; command_it = command_it + 1) {
			const gchar* command = NULL;
			command = command_collection[command_it];
			{
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gboolean _tmp11_;
				_tmp7_ = command;
				_tmp8_ = self->priv->_position;
				_tmp9_ = g_strconcat ("hotcorner-", _tmp8_, NULL);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_str_has_prefix (_tmp7_, _tmp10_);
				_g_free0 (_tmp10_);
				if (_tmp11_) {
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = command;
					_tmp13_ = self->priv->_position;
					_tmp14_ = g_strdup_printf ("hotcorner-%s:", _tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = string_replace (_tmp12_, _tmp15_, "");
					_g_free0 (this_command);
					this_command = _tmp16_;
					_g_free0 (_tmp15_);
				}
			}
		}
	}
	_tmp17_ = self->priv->command_entry;
	_tmp18_ = this_command;
	gtk_entry_set_text (_tmp17_, _tmp18_);
	commands = (_vala_array_free (commands, commands_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (this_command);
	_g_free0 (setting_string);
}

static const gchar*
pantheon_shell_multitasking_hotcorner_control_get_label (PantheonShellMultitaskingHotcornerControl* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
pantheon_shell_multitasking_hotcorner_control_set_label (PantheonShellMultitaskingHotcornerControl* self,
                                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_multitasking_hotcorner_control_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_multitasking_hotcorner_control_properties[PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY]);
	}
}

static const gchar*
pantheon_shell_multitasking_hotcorner_control_get_position (PantheonShellMultitaskingHotcornerControl* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_position;
	result = _tmp0_;
	return result;
}

static void
pantheon_shell_multitasking_hotcorner_control_set_position (PantheonShellMultitaskingHotcornerControl* self,
                                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_multitasking_hotcorner_control_get_position (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_position);
		self->priv->_position = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_multitasking_hotcorner_control_properties[PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY]);
	}
}

static gboolean
_pantheon_shell_multitasking_hotcorner_control___lambda13_ (GValue* value,
                                                            GVariant* variant,
                                                            void* user_data)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_string (variant, NULL);
	g_value_set_boolean (value, g_strcmp0 (_tmp0_, "custom-command") == 0);
	result = TRUE;
	return result;
}

static gboolean
__pantheon_shell_multitasking_hotcorner_control___lambda13__gsettings_bind_get_mapping (GValue* value,
                                                                                        GVariant* variant,
                                                                                        void* user_data)
{
	gboolean result;
	result = _pantheon_shell_multitasking_hotcorner_control___lambda13_ (value, variant, user_data);
	return result;
}

static GVariant*
_pantheon_shell_multitasking_hotcorner_control___lambda14_ (GValue* value,
                                                            const GVariantType* expected_type,
                                                            void* user_data)
{
	GVariant* _tmp0_;
	GVariant* result;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	_tmp0_ = g_variant_new_string ("custom-command");
	g_variant_ref_sink (_tmp0_);
	result = _tmp0_;
	return result;
}

static GVariant*
__pantheon_shell_multitasking_hotcorner_control___lambda14__gsettings_bind_set_mapping (GValue* value,
                                                                                        const GVariantType* expected_type,
                                                                                        void* user_data)
{
	GVariant* result;
	result = _pantheon_shell_multitasking_hotcorner_control___lambda14_ (value, expected_type, user_data);
	return result;
}

static void
_pantheon_shell_multitasking_hotcorner_control___lambda15_ (PantheonShellMultitaskingHotcornerControl* self)
{
	pantheon_shell_multitasking_hotcorner_control_get_command_string (self);
}

static void
__pantheon_shell_multitasking_hotcorner_control___lambda15__g_settings_changed (GSettings* _sender,
                                                                                const gchar* key,
                                                                                gpointer self)
{
	_pantheon_shell_multitasking_hotcorner_control___lambda15_ ((PantheonShellMultitaskingHotcornerControl*) self);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
_pantheon_shell_multitasking_hotcorner_control___lambda16_ (PantheonShellMultitaskingHotcornerControl* self)
{
	gchar* this_command = NULL;
	const gchar* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* setting_string = NULL;
	GSettings* _tmp5_;
	gchar* _tmp6_;
	gboolean found = FALSE;
	gchar** commands = NULL;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint commands_length1;
	gint _commands_size_;
	GSettings* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar* _tmp27_;
	_tmp0_ = self->priv->_position;
	_tmp1_ = self->priv->command_entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("hotcorner-%s:%s", _tmp0_, _tmp3_);
	this_command = _tmp4_;
	_tmp5_ = pantheon_shell_multitasking_hotcorner_control_settings;
	_tmp6_ = g_settings_get_string (_tmp5_, "hotcorner-custom-command");
	setting_string = _tmp6_;
	found = FALSE;
	_tmp7_ = setting_string;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ";;", 0);
	commands = _tmp9_;
	commands_length1 = _vala_array_length (_tmp8_);
	_commands_size_ = commands_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gchar** _tmp12_;
				gint _tmp12__length1;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gboolean _tmp18_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = commands;
				_tmp12__length1 = commands_length1;
				if (!(i < _tmp12__length1)) {
					break;
				}
				_tmp13_ = commands;
				_tmp13__length1 = commands_length1;
				_tmp14_ = _tmp13_[i];
				_tmp15_ = self->priv->_position;
				_tmp16_ = g_strconcat ("hotcorner-", _tmp15_, NULL);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_str_has_prefix (_tmp14_, _tmp17_);
				_g_free0 (_tmp17_);
				if (_tmp18_) {
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					found = TRUE;
					_tmp19_ = commands;
					_tmp19__length1 = commands_length1;
					_tmp20_ = this_command;
					_tmp21_ = g_strdup (_tmp20_);
					_g_free0 (_tmp19_[i]);
					_tmp19_[i] = _tmp21_;
				}
			}
		}
	}
	if (!found) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = this_command;
		_tmp23_ = g_strdup (_tmp22_);
		_vala_array_add1 (&commands, &commands_length1, &_commands_size_, _tmp23_);
	}
	_tmp24_ = pantheon_shell_multitasking_hotcorner_control_settings;
	_tmp25_ = commands;
	_tmp25__length1 = commands_length1;
	_tmp26_ = _vala_g_strjoinv (";;", _tmp25_, (gint) _tmp25__length1);
	_tmp27_ = _tmp26_;
	g_settings_set_string (_tmp24_, "hotcorner-custom-command", _tmp27_);
	_g_free0 (_tmp27_);
	commands = (_vala_array_free (commands, commands_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (setting_string);
	_g_free0 (this_command);
}

static void
__pantheon_shell_multitasking_hotcorner_control___lambda16__gtk_editable_changed (GtkEditable* _sender,
                                                                                  gpointer self)
{
	_pantheon_shell_multitasking_hotcorner_control___lambda16_ ((PantheonShellMultitaskingHotcornerControl*) self);
}

static GObject *
pantheon_shell_multitasking_hotcorner_control_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellMultitaskingHotcornerControl * self;
	GtkLabel* label = NULL;
	const gchar* _tmp0_;
	GtkLabel* _tmp1_ = NULL;
	GtkStyleContext* label_style_context = NULL;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	const gchar* _tmp8_;
	GtkComboBoxText* combo = NULL;
	GtkComboBoxText* _tmp9_ = NULL;
	GtkComboBoxText* _tmp10_;
	GtkComboBoxText* _tmp11_;
	GtkComboBoxText* _tmp12_;
	GtkComboBoxText* _tmp13_;
	GtkComboBoxText* _tmp14_;
	GtkComboBoxText* _tmp15_;
	GtkComboBoxText* _tmp16_;
	gchar* _tmp17_;
	GtkEntry* _tmp18_ = NULL;
	GtkRevealer* command_revealer = NULL;
	GtkRevealer* _tmp19_ = NULL;
	GtkRevealer* _tmp20_;
	GtkEntry* _tmp21_;
	GtkLabel* _tmp22_;
	GtkComboBoxText* _tmp23_;
	GtkRevealer* _tmp24_;
	GtkSizeGroup* _tmp25_;
	GtkLabel* _tmp26_;
	GSettings* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkComboBoxText* _tmp31_;
	GSettings* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GtkRevealer* _tmp36_;
	GSettings* _tmp37_;
	GtkEntry* _tmp38_;
	parent_class = G_OBJECT_CLASS (pantheon_shell_multitasking_hotcorner_control_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl);
	_tmp0_ = self->priv->_label;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	gtk_label_set_max_width_chars (_tmp1_, 12);
	g_object_set (_tmp1_, "wrap", TRUE, NULL);
	g_object_set (_tmp1_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = label;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	label_style_context = _tmp3_;
	_tmp4_ = label_style_context;
	gtk_style_context_add_class (_tmp4_, GRANITE_STYLE_CLASS_CARD);
	_tmp5_ = label_style_context;
	gtk_style_context_add_class (_tmp5_, GRANITE_STYLE_CLASS_ROUNDED);
	_tmp6_ = label_style_context;
	gtk_style_context_add_class (_tmp6_, "hotcorner");
	_tmp7_ = label_style_context;
	_tmp8_ = self->priv->_position;
	gtk_style_context_add_class (_tmp7_, _tmp8_);
	_tmp9_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp9_);
	combo = _tmp9_;
	_tmp10_ = combo;
	gtk_combo_box_text_append (_tmp10_, "none", _ ("Do nothing"));
	_tmp11_ = combo;
	gtk_combo_box_text_append (_tmp11_, "show-workspace-view", _ ("Multitasking View"));
	_tmp12_ = combo;
	gtk_combo_box_text_append (_tmp12_, "maximize-current", _ ("Maximize current window"));
	_tmp13_ = combo;
	gtk_combo_box_text_append (_tmp13_, "open-launcher", _ ("Show Applications Menu"));
	_tmp14_ = combo;
	gtk_combo_box_text_append (_tmp14_, "window-overview-all", _ ("Show all windows"));
	_tmp15_ = combo;
	gtk_combo_box_text_append (_tmp15_, "switch-to-workspace-last", _ ("Switch to new workspace"));
	_tmp16_ = combo;
	gtk_combo_box_text_append (_tmp16_, "custom-command", _ ("Execute custom command"));
	_tmp17_ = g_strdup ("utilities-terminal-symbolic");
	_tmp18_ = (GtkEntry*) gtk_entry_new ();
	g_object_set (_tmp18_, "primary-icon-name", _tmp17_, NULL);
	_g_free0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->command_entry);
	self->priv->command_entry = _tmp18_;
	_tmp19_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp19_, 6);
	gtk_revealer_set_transition_type (_tmp19_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	g_object_ref_sink (_tmp19_);
	command_revealer = _tmp19_;
	_tmp20_ = command_revealer;
	_tmp21_ = self->priv->command_entry;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 12);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	_tmp22_ = label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp22_, 0, 0, 1, 2);
	_tmp23_ = combo;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp23_, 1, 0, 1, 1);
	_tmp24_ = command_revealer;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp24_, 1, 1, 1, 1);
	_tmp25_ = pantheon_shell_multitasking_hotcorner_control_size_group;
	_tmp26_ = label;
	gtk_size_group_add_widget (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = pantheon_shell_multitasking_hotcorner_control_settings;
	_tmp28_ = self->priv->_position;
	_tmp29_ = g_strconcat ("hotcorner-", _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = combo;
	g_settings_bind (_tmp27_, _tmp30_, (GObject*) _tmp31_, "active-id", G_SETTINGS_BIND_DEFAULT);
	_g_free0 (_tmp30_);
	_tmp32_ = pantheon_shell_multitasking_hotcorner_control_settings;
	_tmp33_ = self->priv->_position;
	_tmp34_ = g_strconcat ("hotcorner-", _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = command_revealer;
	g_settings_bind_with_mapping (_tmp32_, _tmp35_, (GObject*) _tmp36_, "reveal-child", G_SETTINGS_BIND_GET, __pantheon_shell_multitasking_hotcorner_control___lambda13__gsettings_bind_get_mapping, __pantheon_shell_multitasking_hotcorner_control___lambda14__gsettings_bind_set_mapping, NULL, NULL);
	_g_free0 (_tmp35_);
	pantheon_shell_multitasking_hotcorner_control_get_command_string (self);
	_tmp37_ = pantheon_shell_multitasking_hotcorner_control_settings;
	g_signal_connect_object (_tmp37_, "changed::hotcorner-custom-command", (GCallback) __pantheon_shell_multitasking_hotcorner_control___lambda15__g_settings_changed, self, 0);
	_tmp38_ = self->priv->command_entry;
	g_signal_connect_object ((GtkEditable*) _tmp38_, "changed", (GCallback) __pantheon_shell_multitasking_hotcorner_control___lambda16__gtk_editable_changed, self, 0);
	_g_object_unref0 (command_revealer);
	_g_object_unref0 (combo);
	_g_object_unref0 (label);
	return obj;
}

static void
pantheon_shell_multitasking_hotcorner_control_class_init (PantheonShellMultitaskingHotcornerControlClass * klass,
                                                          gpointer klass_data)
{
	GSettings* _tmp0_;
	GtkSizeGroup* _tmp1_;
	pantheon_shell_multitasking_hotcorner_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellMultitaskingHotcornerControl_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pantheon_shell_multitasking_hotcorner_control_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pantheon_shell_multitasking_hotcorner_control_set_property;
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_multitasking_hotcorner_control_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_multitasking_hotcorner_control_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY, pantheon_shell_multitasking_hotcorner_control_properties[PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY, pantheon_shell_multitasking_hotcorner_control_properties[PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY] = g_param_spec_string ("position", "position", "position", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_settings_new ("org.pantheon.desktop.gala.behavior");
	_g_object_unref0 (pantheon_shell_multitasking_hotcorner_control_settings);
	pantheon_shell_multitasking_hotcorner_control_settings = _tmp0_;
	_tmp1_ = gtk_size_group_new (GTK_SIZE_GROUP_BOTH);
	_g_object_unref0 (pantheon_shell_multitasking_hotcorner_control_size_group);
	pantheon_shell_multitasking_hotcorner_control_size_group = _tmp1_;
}

static void
pantheon_shell_multitasking_hotcorner_control_instance_init (PantheonShellMultitaskingHotcornerControl * self,
                                                             gpointer klass)
{
	self->priv = pantheon_shell_multitasking_hotcorner_control_get_instance_private (self);
}

static void
pantheon_shell_multitasking_hotcorner_control_finalize (GObject * obj)
{
	PantheonShellMultitaskingHotcornerControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_position);
	_g_object_unref0 (self->priv->command_entry);
	G_OBJECT_CLASS (pantheon_shell_multitasking_hotcorner_control_parent_class)->finalize (obj);
}

static GType
pantheon_shell_multitasking_hotcorner_control_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellMultitaskingHotcornerControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_multitasking_hotcorner_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellMultitaskingHotcornerControl), 0, (GInstanceInitFunc) pantheon_shell_multitasking_hotcorner_control_instance_init, NULL };
	GType pantheon_shell_multitasking_hotcorner_control_type_id;
	pantheon_shell_multitasking_hotcorner_control_type_id = g_type_register_static (gtk_grid_get_type (), "PantheonShellMultitaskingHotcornerControl", &g_define_type_info, 0);
	PantheonShellMultitaskingHotcornerControl_private_offset = g_type_add_instance_private (pantheon_shell_multitasking_hotcorner_control_type_id, sizeof (PantheonShellMultitaskingHotcornerControlPrivate));
	return pantheon_shell_multitasking_hotcorner_control_type_id;
}

static GType
pantheon_shell_multitasking_hotcorner_control_get_type (void)
{
	static volatile gsize pantheon_shell_multitasking_hotcorner_control_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_multitasking_hotcorner_control_type_id__once)) {
		GType pantheon_shell_multitasking_hotcorner_control_type_id;
		pantheon_shell_multitasking_hotcorner_control_type_id = pantheon_shell_multitasking_hotcorner_control_get_type_once ();
		g_once_init_leave (&pantheon_shell_multitasking_hotcorner_control_type_id__once, pantheon_shell_multitasking_hotcorner_control_type_id);
	}
	return pantheon_shell_multitasking_hotcorner_control_type_id__once;
}

static void
_vala_pantheon_shell_multitasking_hotcorner_control_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec)
{
	PantheonShellMultitaskingHotcornerControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl);
	switch (property_id) {
		case PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY:
		g_value_set_string (value, pantheon_shell_multitasking_hotcorner_control_get_label (self));
		break;
		case PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY:
		g_value_set_string (value, pantheon_shell_multitasking_hotcorner_control_get_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pantheon_shell_multitasking_hotcorner_control_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec)
{
	PantheonShellMultitaskingHotcornerControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_MULTITASKING_TYPE_HOTCORNER_CONTROL, PantheonShellMultitaskingHotcornerControl);
	switch (property_id) {
		case PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_LABEL_PROPERTY:
		pantheon_shell_multitasking_hotcorner_control_set_label (self, g_value_get_string (value));
		break;
		case PANTHEON_SHELL_MULTITASKING_HOTCORNER_CONTROL_POSITION_PROPERTY:
		pantheon_shell_multitasking_hotcorner_control_set_position (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
pantheon_shell_multitasking_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellMultitasking * self;
	GtkLabel* hotcorner_title = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	GtkStyleContext* _tmp2_;
	PantheonShellMultitaskingHotcornerControl* topleft = NULL;
	PantheonShellMultitaskingHotcornerControl* _tmp3_;
	PantheonShellMultitaskingHotcornerControl* topright = NULL;
	PantheonShellMultitaskingHotcornerControl* _tmp4_;
	PantheonShellMultitaskingHotcornerControl* bottomleft = NULL;
	PantheonShellMultitaskingHotcornerControl* _tmp5_;
	PantheonShellMultitaskingHotcornerControl* bottomright = NULL;
	PantheonShellMultitaskingHotcornerControl* _tmp6_;
	GraniteHeaderLabel* workspaces_label = NULL;
	GraniteHeaderLabel* _tmp7_ = NULL;
	GtkCheckButton* fullscreen_checkbutton = NULL;
	GtkCheckButton* _tmp8_;
	GtkCheckButton* maximize_checkbutton = NULL;
	GtkCheckButton* _tmp9_;
	GtkGrid* checkbutton_grid = NULL;
	GtkGrid* _tmp10_ = NULL;
	GtkGrid* _tmp11_;
	GtkCheckButton* _tmp12_;
	GtkGrid* _tmp13_;
	GtkCheckButton* _tmp14_;
	GtkLabel* animations_label = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkSwitch* animations_switch = NULL;
	GtkSwitch* _tmp16_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp17_ = NULL;
	GtkGrid* _tmp18_;
	GtkLabel* _tmp19_;
	GtkGrid* _tmp20_;
	PantheonShellMultitaskingHotcornerControl* _tmp21_;
	GtkGrid* _tmp22_;
	PantheonShellMultitaskingHotcornerControl* _tmp23_;
	GtkGrid* _tmp24_;
	PantheonShellMultitaskingHotcornerControl* _tmp25_;
	GtkGrid* _tmp26_;
	PantheonShellMultitaskingHotcornerControl* _tmp27_;
	GtkGrid* _tmp28_;
	GraniteHeaderLabel* _tmp29_;
	GtkGrid* _tmp30_;
	GtkGrid* _tmp31_;
	GtkGrid* _tmp32_;
	GtkLabel* _tmp33_;
	GtkGrid* _tmp34_;
	GtkSwitch* _tmp35_;
	HdyClamp* clamp = NULL;
	HdyClamp* _tmp36_;
	HdyClamp* _tmp37_;
	GtkGrid* _tmp38_;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp39_ = NULL;
	GtkScrolledWindow* _tmp40_;
	HdyClamp* _tmp41_;
	GtkScrolledWindow* _tmp42_;
	GSettings* animations_settings = NULL;
	GSettings* _tmp43_;
	GSettings* _tmp44_;
	GtkSwitch* _tmp45_;
	GSettings* _tmp46_;
	GSettings* _tmp47_;
	GtkCheckButton* _tmp48_;
	GSettings* _tmp49_;
	GtkCheckButton* _tmp50_;
	parent_class = G_OBJECT_CLASS (pantheon_shell_multitasking_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_MULTITASKING, PantheonShellMultitasking);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("When the pointer enters a display corner"));
	gtk_widget_set_halign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp0_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp0_, 6);
	g_object_ref_sink (_tmp0_);
	hotcorner_title = _tmp0_;
	_tmp1_ = hotcorner_title;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, GRANITE_STYLE_CLASS_H4_LABEL);
	_tmp3_ = pantheon_shell_multitasking_hotcorner_control_new (_ ("Top Left"), "topleft");
	g_object_ref_sink (_tmp3_);
	topleft = _tmp3_;
	_tmp4_ = pantheon_shell_multitasking_hotcorner_control_new (_ ("Top Right"), "topright");
	g_object_ref_sink (_tmp4_);
	topright = _tmp4_;
	_tmp5_ = pantheon_shell_multitasking_hotcorner_control_new (_ ("Bottom Left"), "bottomleft");
	g_object_ref_sink (_tmp5_);
	bottomleft = _tmp5_;
	_tmp6_ = pantheon_shell_multitasking_hotcorner_control_new (_ ("Bottom Right"), "bottomright");
	g_object_ref_sink (_tmp6_);
	bottomright = _tmp6_;
	_tmp7_ = granite_header_label_new (_ ("Move windows to a new workspace"));
	gtk_widget_set_margin_top ((GtkWidget*) _tmp7_, 12);
	g_object_ref_sink (_tmp7_);
	workspaces_label = _tmp7_;
	_tmp8_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("When entering fullscreen"));
	g_object_ref_sink (_tmp8_);
	fullscreen_checkbutton = _tmp8_;
	_tmp9_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("When maximizing"));
	g_object_ref_sink (_tmp9_);
	maximize_checkbutton = _tmp9_;
	_tmp10_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp10_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp10_, 12);
	g_object_ref_sink (_tmp10_);
	checkbutton_grid = _tmp10_;
	_tmp11_ = checkbutton_grid;
	_tmp12_ = fullscreen_checkbutton;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = checkbutton_grid;
	_tmp14_ = maximize_checkbutton;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("Window animations:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp15_);
	animations_label = _tmp15_;
	_tmp16_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp16_, TRUE);
	g_object_ref_sink (_tmp16_);
	animations_switch = _tmp16_;
	_tmp17_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp17_, 12);
	gtk_grid_set_row_spacing (_tmp17_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp17_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp17_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp17_, 12);
	g_object_ref_sink (_tmp17_);
	grid = _tmp17_;
	_tmp18_ = grid;
	_tmp19_ = hotcorner_title;
	gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp19_, 0, 0, 2, 1);
	_tmp20_ = grid;
	_tmp21_ = topleft;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 0, 1, 2, 1);
	_tmp22_ = grid;
	_tmp23_ = topright;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 0, 2, 2, 1);
	_tmp24_ = grid;
	_tmp25_ = bottomleft;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 0, 3, 2, 1);
	_tmp26_ = grid;
	_tmp27_ = bottomright;
	gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp27_, 0, 4, 2, 1);
	_tmp28_ = grid;
	_tmp29_ = workspaces_label;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 0, 6, 2, 1);
	_tmp30_ = grid;
	_tmp31_ = checkbutton_grid;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 0, 7, 2, 1);
	_tmp32_ = grid;
	_tmp33_ = animations_label;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 0, 8, 1, 1);
	_tmp34_ = grid;
	_tmp35_ = animations_switch;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 1, 8, 1, 1);
	_tmp36_ = (HdyClamp*) hdy_clamp_new ();
	g_object_ref_sink (_tmp36_);
	clamp = _tmp36_;
	_tmp37_ = clamp;
	_tmp38_ = grid;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set (_tmp39_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp39_);
	scrolled = _tmp39_;
	_tmp40_ = scrolled;
	_tmp41_ = clamp;
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = scrolled;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp42_);
	_tmp43_ = g_settings_new (PANTHEON_SHELL_MULTITASKING_ANIMATIONS_SCHEMA);
	animations_settings = _tmp43_;
	_tmp44_ = animations_settings;
	_tmp45_ = animations_switch;
	g_settings_bind (_tmp44_, PANTHEON_SHELL_MULTITASKING_ANIMATIONS_KEY, (GObject*) _tmp45_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp46_ = g_settings_new ("org.pantheon.desktop.gala.behavior");
	_g_object_unref0 (self->priv->behavior_settings);
	self->priv->behavior_settings = _tmp46_;
	_tmp47_ = self->priv->behavior_settings;
	_tmp48_ = fullscreen_checkbutton;
	g_settings_bind (_tmp47_, "move-fullscreened-workspace", (GObject*) _tmp48_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp49_ = self->priv->behavior_settings;
	_tmp50_ = maximize_checkbutton;
	g_settings_bind (_tmp49_, "move-maximized-workspace", (GObject*) _tmp50_, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (animations_settings);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (clamp);
	_g_object_unref0 (grid);
	_g_object_unref0 (animations_switch);
	_g_object_unref0 (animations_label);
	_g_object_unref0 (checkbutton_grid);
	_g_object_unref0 (maximize_checkbutton);
	_g_object_unref0 (fullscreen_checkbutton);
	_g_object_unref0 (workspaces_label);
	_g_object_unref0 (bottomright);
	_g_object_unref0 (bottomleft);
	_g_object_unref0 (topright);
	_g_object_unref0 (topleft);
	_g_object_unref0 (hotcorner_title);
	return obj;
}

static void
pantheon_shell_multitasking_class_init (PantheonShellMultitaskingClass * klass,
                                        gpointer klass_data)
{
	pantheon_shell_multitasking_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellMultitasking_private_offset);
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_multitasking_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_multitasking_finalize;
}

static void
pantheon_shell_multitasking_instance_init (PantheonShellMultitasking * self,
                                           gpointer klass)
{
	self->priv = pantheon_shell_multitasking_get_instance_private (self);
}

static void
pantheon_shell_multitasking_finalize (GObject * obj)
{
	PantheonShellMultitasking * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_MULTITASKING, PantheonShellMultitasking);
	_g_object_unref0 (self->priv->behavior_settings);
	G_OBJECT_CLASS (pantheon_shell_multitasking_parent_class)->finalize (obj);
}

static GType
pantheon_shell_multitasking_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellMultitaskingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_multitasking_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellMultitasking), 0, (GInstanceInitFunc) pantheon_shell_multitasking_instance_init, NULL };
	GType pantheon_shell_multitasking_type_id;
	pantheon_shell_multitasking_type_id = g_type_register_static (gtk_box_get_type (), "PantheonShellMultitasking", &g_define_type_info, 0);
	PantheonShellMultitasking_private_offset = g_type_add_instance_private (pantheon_shell_multitasking_type_id, sizeof (PantheonShellMultitaskingPrivate));
	return pantheon_shell_multitasking_type_id;
}

GType
pantheon_shell_multitasking_get_type (void)
{
	static volatile gsize pantheon_shell_multitasking_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_multitasking_type_id__once)) {
		GType pantheon_shell_multitasking_type_id;
		pantheon_shell_multitasking_type_id = pantheon_shell_multitasking_get_type_once ();
		g_once_init_leave (&pantheon_shell_multitasking_type_id__once, pantheon_shell_multitasking_type_id);
	}
	return pantheon_shell_multitasking_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

