// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32h743v.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32h743

// STM32H743
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32H743"
	CPU          = "CM7"
	FPUPresent   = true
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// WWDG
	IRQ_WWDG1 = 0

	// External interrupt/event controller
	IRQ_PVD_PVM = 1

	// RTC
	IRQ_RTC_TAMP_STAMP_CSS_LSE = 2

	// RTC
	IRQ_RTC_WKUP = 3

	// Flash
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	// DMA controller
	IRQ_DMA_STR0 = 11

	// DMA controller
	IRQ_DMA1_STR0 = 11

	// DMA controller
	IRQ_DMA_STR1 = 12

	// DMA controller
	IRQ_DMA1_STR1 = 12

	// DMA controller
	IRQ_DMA1_STR2 = 13

	// DMA controller
	IRQ_DMA1_STR3 = 14

	// DMA controller
	IRQ_DMA1_STR4 = 15

	// DMA controller
	IRQ_DMA1_STR5 = 16

	// DMA controller
	IRQ_DMA1_STR6 = 17

	IRQ_ADC1_2 = 18

	// FDCAN1
	IRQ_FDCAN1_IT0 = 19

	IRQ_FDCAN2_IT0 = 20

	// FDCAN1
	IRQ_FDCAN1_IT1 = 21

	IRQ_FDCAN2_IT1 = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// Advanced-timers
	IRQ_TIM1_BRK = 24

	// Advanced-timers
	IRQ_TIM1_UP = 25

	// Advanced-timers
	IRQ_TIM1_TRG_COM = 26

	// Advanced-timers
	IRQ_TIM_CC = 27

	// General purpose timers
	IRQ_TIM2 = 28

	// General purpose timers
	IRQ_TIM3 = 29

	IRQ_TIM4 = 30

	// I2C
	IRQ_I2C1_EV = 31

	// I2C
	IRQ_I2C1_ER = 32

	IRQ_I2C2_EV = 33

	IRQ_I2C2_ER = 34

	// Serial peripheral interface
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// External interrupt/event controller
	IRQ_RTC_ALARM = 41

	// General purpose timers
	IRQ_TIM8_BRK_TIM12 = 43

	// General purpose timers
	IRQ_TIM8_UP_TIM13 = 44

	IRQ_TIM8_TRG_COM_TIM14 = 45

	IRQ_TIM8_CC = 46

	// DMA controller
	IRQ_DMA1_STR7 = 47

	// FMC
	IRQ_FMC = 48

	// SDMMC1
	IRQ_SDMMC1 = 49

	IRQ_TIM5 = 50

	IRQ_SPI3 = 51

	IRQ_UART4 = 52

	IRQ_UART5 = 53

	// Basic timers
	IRQ_TIM6_DAC = 54

	IRQ_TIM7 = 55

	IRQ_DMA2_STR0 = 56

	IRQ_DMA2_STR1 = 57

	IRQ_DMA2_STR2 = 58

	IRQ_DMA2_STR3 = 59

	IRQ_DMA2_STR4 = 60

	// Ethernet: media access control (MAC)
	IRQ_ETH = 61

	IRQ_ETH_WKUP = 62

	// FDCAN1
	IRQ_FDCAN_CAL = 63

	IRQ_DMA2_STR5 = 68

	IRQ_DMA2_STR6 = 69

	IRQ_DMA2_STR7 = 70

	IRQ_USART6 = 71

	IRQ_I2C3_EV = 72

	IRQ_I2C3_ER = 73

	IRQ_OTG_HS_EP1_OUT = 74

	IRQ_OTG_HS_EP1_IN = 75

	IRQ_OTG_HS_WKUP = 76

	IRQ_OTG_HS = 77

	// Digital camera interface
	IRQ_DCMI = 78

	// Floting point unit
	IRQ_FPU = 81

	IRQ_UART7 = 82

	IRQ_UART8 = 83

	IRQ_SPI4 = 84

	IRQ_SPI5 = 85

	IRQ_SPI6 = 86

	IRQ_SAI1 = 87

	// LCD-TFT Controller
	IRQ_LTDC = 88

	// LCD-TFT Controller
	IRQ_LTDC_ER = 89

	// DMA2D
	IRQ_DMA2D = 90

	IRQ_SAI2 = 91

	// QUADSPI
	IRQ_QUADSPI = 92

	// Low power timer
	IRQ_LPTIM1 = 93

	// CEC
	IRQ_CEC = 94

	IRQ_I2C4_EV = 95

	IRQ_I2C4_ER = 96

	// Receiver Interface
	IRQ_SPDIF = 97

	IRQ_OTG_FS_EP1_OUT = 98

	IRQ_OTG_FS_EP1_IN = 99

	IRQ_OTG_FS_WKUP = 100

	// USB 1 on the go high speed
	IRQ_OTG_FS = 101

	// DMAMUX
	IRQ_DMAMUX1_OV = 102

	// High Resolution Timer: TIMA
	IRQ_HRTIM1_MST = 103

	// High Resolution Timer: TIMB
	IRQ_HRTIM1_TIMA = 104

	// High Resolution Timer: TIMC
	IRQ_HRTIM_TIMB = 105

	// High Resolution Timer: TIMD
	IRQ_HRTIM1_TIMC = 106

	// High Resolution Timer: TIME
	IRQ_HRTIM1_TIMD = 107

	// High Resolution Timer: Common functions
	IRQ_HRTIM_TIME = 108

	// High Resolution Timer: TIMA
	IRQ_HRTIM1_FLT = 109

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT0 = 110

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT1 = 111

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT2 = 112

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT3 = 113

	IRQ_SAI3 = 114

	// General purpose timers
	IRQ_SWPMI1 = 115

	// General purpose timers
	IRQ_TIM15 = 116

	// General-purpose-timers
	IRQ_TIM16 = 117

	// General-purpose-timers
	IRQ_TIM17 = 118

	// Management data input/output slave
	IRQ_MDIOS_WKUP = 119

	// Management data input/output slave
	IRQ_MDIOS = 120

	// JPEG
	IRQ_JPEG = 121

	// MDMA
	IRQ_MDMA = 122

	// SDMMC1
	IRQ_SDMMC = 124

	// HSEM
	IRQ_HSEM0 = 125

	// Analog to Digital Converter
	IRQ_ADC3 = 127

	// DMAMUX
	IRQ_DMAMUX2_OVR = 128

	// BDMA
	IRQ_BDMA_CH1 = 129

	// BDMA
	IRQ_BDMA_CH2 = 130

	// BDMA
	IRQ_BDMA_CH3 = 131

	// BDMA
	IRQ_BDMA_CH4 = 132

	// BDMA
	IRQ_BDMA_CH5 = 133

	// BDMA
	IRQ_BDMA_CH6 = 134

	// BDMA
	IRQ_BDMA_CH7 = 135

	// BDMA
	IRQ_BDMA_CH8 = 136

	// COMP1
	IRQ_COMP = 137

	IRQ_LPTIM2 = 138

	// Low power timer
	IRQ_LPTIM3 = 139

	IRQ_LPTIM4 = 140

	IRQ_LPTIM5 = 141

	// LPUART1
	IRQ_LPUART = 142

	// WWDG
	IRQ_WWDG1_RST = 143

	// CRS
	IRQ_CRS = 144

	// RAM ECC monitoring
	IRQ_RAMECC = 145

	// SAI
	IRQ_SAI4 = 146

	// DELAY_Block_SDMMC1
	IRQ_WKUP = 149

	// Highest interrupt number on this device.
	IRQ_max = 149
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG1_IRQHandler
func interruptWWDG1() {
	callHandlers(IRQ_WWDG1)
}

//export PVD_PVM_IRQHandler
func interruptPVD_PVM() {
	callHandlers(IRQ_PVD_PVM)
}

//export RTC_TAMP_STAMP_CSS_LSE_IRQHandler
func interruptRTC_TAMP_STAMP_CSS_LSE() {
	callHandlers(IRQ_RTC_TAMP_STAMP_CSS_LSE)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA_STR0_IRQHandler
func interruptDMA_STR0() {
	callHandlers(IRQ_DMA_STR0)
}

//export DMA1_STR0_IRQHandler
func interruptDMA1_STR0() {
	callHandlers(IRQ_DMA1_STR0)
}

//export DMA_STR1_IRQHandler
func interruptDMA_STR1() {
	callHandlers(IRQ_DMA_STR1)
}

//export DMA1_STR1_IRQHandler
func interruptDMA1_STR1() {
	callHandlers(IRQ_DMA1_STR1)
}

//export DMA1_STR2_IRQHandler
func interruptDMA1_STR2() {
	callHandlers(IRQ_DMA1_STR2)
}

//export DMA1_STR3_IRQHandler
func interruptDMA1_STR3() {
	callHandlers(IRQ_DMA1_STR3)
}

//export DMA1_STR4_IRQHandler
func interruptDMA1_STR4() {
	callHandlers(IRQ_DMA1_STR4)
}

//export DMA1_STR5_IRQHandler
func interruptDMA1_STR5() {
	callHandlers(IRQ_DMA1_STR5)
}

//export DMA1_STR6_IRQHandler
func interruptDMA1_STR6() {
	callHandlers(IRQ_DMA1_STR6)
}

//export ADC1_2_IRQHandler
func interruptADC1_2() {
	callHandlers(IRQ_ADC1_2)
}

//export FDCAN1_IT0_IRQHandler
func interruptFDCAN1_IT0() {
	callHandlers(IRQ_FDCAN1_IT0)
}

//export FDCAN2_IT0_IRQHandler
func interruptFDCAN2_IT0() {
	callHandlers(IRQ_FDCAN2_IT0)
}

//export FDCAN1_IT1_IRQHandler
func interruptFDCAN1_IT1() {
	callHandlers(IRQ_FDCAN1_IT1)
}

//export FDCAN2_IT1_IRQHandler
func interruptFDCAN2_IT1() {
	callHandlers(IRQ_FDCAN2_IT1)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM1_BRK_IRQHandler
func interruptTIM1_BRK() {
	callHandlers(IRQ_TIM1_BRK)
}

//export TIM1_UP_IRQHandler
func interruptTIM1_UP() {
	callHandlers(IRQ_TIM1_UP)
}

//export TIM1_TRG_COM_IRQHandler
func interruptTIM1_TRG_COM() {
	callHandlers(IRQ_TIM1_TRG_COM)
}

//export TIM_CC_IRQHandler
func interruptTIM_CC() {
	callHandlers(IRQ_TIM_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_IRQHandler
func interruptI2C2_EV() {
	callHandlers(IRQ_I2C2_EV)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_ALARM_IRQHandler
func interruptRTC_ALARM() {
	callHandlers(IRQ_RTC_ALARM)
}

//export TIM8_BRK_TIM12_IRQHandler
func interruptTIM8_BRK_TIM12() {
	callHandlers(IRQ_TIM8_BRK_TIM12)
}

//export TIM8_UP_TIM13_IRQHandler
func interruptTIM8_UP_TIM13() {
	callHandlers(IRQ_TIM8_UP_TIM13)
}

//export TIM8_TRG_COM_TIM14_IRQHandler
func interruptTIM8_TRG_COM_TIM14() {
	callHandlers(IRQ_TIM8_TRG_COM_TIM14)
}

//export TIM8_CC_IRQHandler
func interruptTIM8_CC() {
	callHandlers(IRQ_TIM8_CC)
}

//export DMA1_STR7_IRQHandler
func interruptDMA1_STR7() {
	callHandlers(IRQ_DMA1_STR7)
}

//export FMC_IRQHandler
func interruptFMC() {
	callHandlers(IRQ_FMC)
}

//export SDMMC1_IRQHandler
func interruptSDMMC1() {
	callHandlers(IRQ_SDMMC1)
}

//export TIM5_IRQHandler
func interruptTIM5() {
	callHandlers(IRQ_TIM5)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export UART5_IRQHandler
func interruptUART5() {
	callHandlers(IRQ_UART5)
}

//export TIM6_DAC_IRQHandler
func interruptTIM6_DAC() {
	callHandlers(IRQ_TIM6_DAC)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export DMA2_STR0_IRQHandler
func interruptDMA2_STR0() {
	callHandlers(IRQ_DMA2_STR0)
}

//export DMA2_STR1_IRQHandler
func interruptDMA2_STR1() {
	callHandlers(IRQ_DMA2_STR1)
}

//export DMA2_STR2_IRQHandler
func interruptDMA2_STR2() {
	callHandlers(IRQ_DMA2_STR2)
}

//export DMA2_STR3_IRQHandler
func interruptDMA2_STR3() {
	callHandlers(IRQ_DMA2_STR3)
}

//export DMA2_STR4_IRQHandler
func interruptDMA2_STR4() {
	callHandlers(IRQ_DMA2_STR4)
}

//export ETH_IRQHandler
func interruptETH() {
	callHandlers(IRQ_ETH)
}

//export ETH_WKUP_IRQHandler
func interruptETH_WKUP() {
	callHandlers(IRQ_ETH_WKUP)
}

//export FDCAN_CAL_IRQHandler
func interruptFDCAN_CAL() {
	callHandlers(IRQ_FDCAN_CAL)
}

//export DMA2_STR5_IRQHandler
func interruptDMA2_STR5() {
	callHandlers(IRQ_DMA2_STR5)
}

//export DMA2_STR6_IRQHandler
func interruptDMA2_STR6() {
	callHandlers(IRQ_DMA2_STR6)
}

//export DMA2_STR7_IRQHandler
func interruptDMA2_STR7() {
	callHandlers(IRQ_DMA2_STR7)
}

//export USART6_IRQHandler
func interruptUSART6() {
	callHandlers(IRQ_USART6)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export OTG_HS_EP1_OUT_IRQHandler
func interruptOTG_HS_EP1_OUT() {
	callHandlers(IRQ_OTG_HS_EP1_OUT)
}

//export OTG_HS_EP1_IN_IRQHandler
func interruptOTG_HS_EP1_IN() {
	callHandlers(IRQ_OTG_HS_EP1_IN)
}

//export OTG_HS_WKUP_IRQHandler
func interruptOTG_HS_WKUP() {
	callHandlers(IRQ_OTG_HS_WKUP)
}

//export OTG_HS_IRQHandler
func interruptOTG_HS() {
	callHandlers(IRQ_OTG_HS)
}

//export DCMI_IRQHandler
func interruptDCMI() {
	callHandlers(IRQ_DCMI)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export UART7_IRQHandler
func interruptUART7() {
	callHandlers(IRQ_UART7)
}

//export UART8_IRQHandler
func interruptUART8() {
	callHandlers(IRQ_UART8)
}

//export SPI4_IRQHandler
func interruptSPI4() {
	callHandlers(IRQ_SPI4)
}

//export SPI5_IRQHandler
func interruptSPI5() {
	callHandlers(IRQ_SPI5)
}

//export SPI6_IRQHandler
func interruptSPI6() {
	callHandlers(IRQ_SPI6)
}

//export SAI1_IRQHandler
func interruptSAI1() {
	callHandlers(IRQ_SAI1)
}

//export LTDC_IRQHandler
func interruptLTDC() {
	callHandlers(IRQ_LTDC)
}

//export LTDC_ER_IRQHandler
func interruptLTDC_ER() {
	callHandlers(IRQ_LTDC_ER)
}

//export DMA2D_IRQHandler
func interruptDMA2D() {
	callHandlers(IRQ_DMA2D)
}

//export SAI2_IRQHandler
func interruptSAI2() {
	callHandlers(IRQ_SAI2)
}

//export QUADSPI_IRQHandler
func interruptQUADSPI() {
	callHandlers(IRQ_QUADSPI)
}

//export LPTIM1_IRQHandler
func interruptLPTIM1() {
	callHandlers(IRQ_LPTIM1)
}

//export CEC_IRQHandler
func interruptCEC() {
	callHandlers(IRQ_CEC)
}

//export I2C4_EV_IRQHandler
func interruptI2C4_EV() {
	callHandlers(IRQ_I2C4_EV)
}

//export I2C4_ER_IRQHandler
func interruptI2C4_ER() {
	callHandlers(IRQ_I2C4_ER)
}

//export SPDIF_IRQHandler
func interruptSPDIF() {
	callHandlers(IRQ_SPDIF)
}

//export OTG_FS_EP1_OUT_IRQHandler
func interruptOTG_FS_EP1_OUT() {
	callHandlers(IRQ_OTG_FS_EP1_OUT)
}

//export OTG_FS_EP1_IN_IRQHandler
func interruptOTG_FS_EP1_IN() {
	callHandlers(IRQ_OTG_FS_EP1_IN)
}

//export OTG_FS_WKUP_IRQHandler
func interruptOTG_FS_WKUP() {
	callHandlers(IRQ_OTG_FS_WKUP)
}

//export OTG_FS_IRQHandler
func interruptOTG_FS() {
	callHandlers(IRQ_OTG_FS)
}

//export DMAMUX1_OV_IRQHandler
func interruptDMAMUX1_OV() {
	callHandlers(IRQ_DMAMUX1_OV)
}

//export HRTIM1_MST_IRQHandler
func interruptHRTIM1_MST() {
	callHandlers(IRQ_HRTIM1_MST)
}

//export HRTIM1_TIMA_IRQHandler
func interruptHRTIM1_TIMA() {
	callHandlers(IRQ_HRTIM1_TIMA)
}

//export HRTIM_TIMB_IRQHandler
func interruptHRTIM_TIMB() {
	callHandlers(IRQ_HRTIM_TIMB)
}

//export HRTIM1_TIMC_IRQHandler
func interruptHRTIM1_TIMC() {
	callHandlers(IRQ_HRTIM1_TIMC)
}

//export HRTIM1_TIMD_IRQHandler
func interruptHRTIM1_TIMD() {
	callHandlers(IRQ_HRTIM1_TIMD)
}

//export HRTIM_TIME_IRQHandler
func interruptHRTIM_TIME() {
	callHandlers(IRQ_HRTIM_TIME)
}

//export HRTIM1_FLT_IRQHandler
func interruptHRTIM1_FLT() {
	callHandlers(IRQ_HRTIM1_FLT)
}

//export DFSDM1_FLT0_IRQHandler
func interruptDFSDM1_FLT0() {
	callHandlers(IRQ_DFSDM1_FLT0)
}

//export DFSDM1_FLT1_IRQHandler
func interruptDFSDM1_FLT1() {
	callHandlers(IRQ_DFSDM1_FLT1)
}

//export DFSDM1_FLT2_IRQHandler
func interruptDFSDM1_FLT2() {
	callHandlers(IRQ_DFSDM1_FLT2)
}

//export DFSDM1_FLT3_IRQHandler
func interruptDFSDM1_FLT3() {
	callHandlers(IRQ_DFSDM1_FLT3)
}

//export SAI3_IRQHandler
func interruptSAI3() {
	callHandlers(IRQ_SAI3)
}

//export SWPMI1_IRQHandler
func interruptSWPMI1() {
	callHandlers(IRQ_SWPMI1)
}

//export TIM15_IRQHandler
func interruptTIM15() {
	callHandlers(IRQ_TIM15)
}

//export TIM16_IRQHandler
func interruptTIM16() {
	callHandlers(IRQ_TIM16)
}

//export TIM17_IRQHandler
func interruptTIM17() {
	callHandlers(IRQ_TIM17)
}

//export MDIOS_WKUP_IRQHandler
func interruptMDIOS_WKUP() {
	callHandlers(IRQ_MDIOS_WKUP)
}

//export MDIOS_IRQHandler
func interruptMDIOS() {
	callHandlers(IRQ_MDIOS)
}

//export JPEG_IRQHandler
func interruptJPEG() {
	callHandlers(IRQ_JPEG)
}

//export MDMA_IRQHandler
func interruptMDMA() {
	callHandlers(IRQ_MDMA)
}

//export SDMMC_IRQHandler
func interruptSDMMC() {
	callHandlers(IRQ_SDMMC)
}

//export HSEM0_IRQHandler
func interruptHSEM0() {
	callHandlers(IRQ_HSEM0)
}

//export ADC3_IRQHandler
func interruptADC3() {
	callHandlers(IRQ_ADC3)
}

//export DMAMUX2_OVR_IRQHandler
func interruptDMAMUX2_OVR() {
	callHandlers(IRQ_DMAMUX2_OVR)
}

//export BDMA_CH1_IRQHandler
func interruptBDMA_CH1() {
	callHandlers(IRQ_BDMA_CH1)
}

//export BDMA_CH2_IRQHandler
func interruptBDMA_CH2() {
	callHandlers(IRQ_BDMA_CH2)
}

//export BDMA_CH3_IRQHandler
func interruptBDMA_CH3() {
	callHandlers(IRQ_BDMA_CH3)
}

//export BDMA_CH4_IRQHandler
func interruptBDMA_CH4() {
	callHandlers(IRQ_BDMA_CH4)
}

//export BDMA_CH5_IRQHandler
func interruptBDMA_CH5() {
	callHandlers(IRQ_BDMA_CH5)
}

//export BDMA_CH6_IRQHandler
func interruptBDMA_CH6() {
	callHandlers(IRQ_BDMA_CH6)
}

//export BDMA_CH7_IRQHandler
func interruptBDMA_CH7() {
	callHandlers(IRQ_BDMA_CH7)
}

//export BDMA_CH8_IRQHandler
func interruptBDMA_CH8() {
	callHandlers(IRQ_BDMA_CH8)
}

//export COMP_IRQHandler
func interruptCOMP() {
	callHandlers(IRQ_COMP)
}

//export LPTIM2_IRQHandler
func interruptLPTIM2() {
	callHandlers(IRQ_LPTIM2)
}

//export LPTIM3_IRQHandler
func interruptLPTIM3() {
	callHandlers(IRQ_LPTIM3)
}

//export LPTIM4_IRQHandler
func interruptLPTIM4() {
	callHandlers(IRQ_LPTIM4)
}

//export LPTIM5_IRQHandler
func interruptLPTIM5() {
	callHandlers(IRQ_LPTIM5)
}

//export LPUART_IRQHandler
func interruptLPUART() {
	callHandlers(IRQ_LPUART)
}

//export WWDG1_RST_IRQHandler
func interruptWWDG1_RST() {
	callHandlers(IRQ_WWDG1_RST)
}

//export CRS_IRQHandler
func interruptCRS() {
	callHandlers(IRQ_CRS)
}

//export RAMECC_IRQHandler
func interruptRAMECC() {
	callHandlers(IRQ_RAMECC)
}

//export SAI4_IRQHandler
func interruptSAI4() {
	callHandlers(IRQ_SAI4)
}

//export WKUP_IRQHandler
func interruptWKUP() {
	callHandlers(IRQ_WKUP)
}

// Peripherals.
var (
	// COMP1
	COMP1 = (*COMP1_Type)(unsafe.Pointer(uintptr(0x58003800)))

	// CRS
	CRS = (*CRS_Type)(unsafe.Pointer(uintptr(0x40008400)))

	// DAC
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// BDMA
	BDMA = (*BDMA_Type)(unsafe.Pointer(uintptr(0x58025400)))

	// DMA2D
	DMA2D = (*DMA2D_Type)(unsafe.Pointer(uintptr(0x52001000)))

	// DMAMUX
	DMAMUX2 = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x58025800)))

	// FMC
	FMC = (*FMC_Type)(unsafe.Pointer(uintptr(0x52004000)))

	// CEC
	CEC = (*CEC_Type)(unsafe.Pointer(uintptr(0x40006c00)))

	// HSEM
	HSEM = (*HSEM_Type)(unsafe.Pointer(uintptr(0x58026400)))

	// I2C
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// GPIO
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58020000)))

	// JPEG
	JPEG = (*JPEG_Type)(unsafe.Pointer(uintptr(0x52003000)))

	// MDMA
	MDMA = (*MDMA_Type)(unsafe.Pointer(uintptr(0x52000000)))

	// QUADSPI
	QUADSPI = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0x52005000)))

	// RNG
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x48021800)))

	// RTC
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x58004000)))

	// SAI
	SAI4 = (*SAI_Type)(unsafe.Pointer(uintptr(0x58005400)))

	// SDMMC1
	SDMMC1 = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x52007000)))

	// VREFBUF
	VREFBUF = (*VREFBUF_Type)(unsafe.Pointer(uintptr(0x58003c00)))

	// IWDG
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x58004800)))

	// WWDG
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x50003000)))

	// PWR
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x58024800)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// LCD-TFT Controller
	LTDC = (*LTDC_Type)(unsafe.Pointer(uintptr(0x50001000)))

	// Receiver Interface
	SPDIFRX = (*SPDIFRX_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Analog to Digital Converter
	ADC3 = (*ADC_Type)(unsafe.Pointer(uintptr(0x58026000)))

	// Analog-to-Digital Converter
	ADC3_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x58026300)))

	// DMAMUX
	DMAMUX1 = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// Cryptographic processor
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x58024c00)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x58024400)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Low power timer
	LPTIM3 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x58002800)))

	// LPUART1
	LPUART1 = (*LPUART_Type)(unsafe.Pointer(uintptr(0x58000c00)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x58000400)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x58000000)))

	// DELAY_Block_SDMMC1
	DELAY_Block_SDMMC1 = (*DLYB_Type)(unsafe.Pointer(uintptr(0x52008000)))

	// Flash
	FLASH = (*FLASH_Type)(unsafe.Pointer(uintptr(0x52002000)))

	// AXI interconnect registers
	AXI = (*AXI_Type)(unsafe.Pointer(uintptr(0x51000000)))

	// Digital camera interface
	DCMI = (*DCMI_Type)(unsafe.Pointer(uintptr(0x48020000)))

	// USB 1 on the go high speed
	OTG1_HS_GLOBAL = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// USB 1 on the go high speed
	OTG1_HS_HOST = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040400)))

	// USB 1 on the go high speed
	OTG1_HS_DEVICE = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040800)))

	// USB 1 on the go high speed
	OTG1_HS_PWRCLK = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040e00)))

	// Ethernet: DMA mode register (DMA)
	Ethernet_DMA = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40029000)))

	// Ethernet: MTL mode register (MTL)
	Ethernet_MTL = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028c00)))

	// Ethernet: media access control (MAC)
	Ethernet_MAC = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// DMA controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// High Resolution Timer: Master Timers
	HRTIM_Master = (*HRTIM_Type)(unsafe.Pointer(uintptr(0x40017400)))

	// High Resolution Timer: TIMA
	HRTIM_TIMA = (*HRTIM_Type)(unsafe.Pointer(uintptr(0x40017480)))

	// High Resolution Timer: TIMB
	HRTIM_TIMB = (*HRTIM_Type)(unsafe.Pointer(uintptr(0x40017500)))

	// High Resolution Timer: TIMC
	HRTIM_TIMC = (*HRTIM_Type)(unsafe.Pointer(uintptr(0x40017580)))

	// High Resolution Timer: TIMD
	HRTIM_TIMD = (*HRTIM_Type)(unsafe.Pointer(uintptr(0x40017600)))

	// High Resolution Timer: TIME
	HRTIM_TIME = (*HRTIM_Type)(unsafe.Pointer(uintptr(0x40017680)))

	// High Resolution Timer: Common functions
	HRTIM_Common = (*HRTIM_Type)(unsafe.Pointer(uintptr(0x40017780)))

	// Digital filter for sigma delta modulators
	DFSDM = (*DFSDM_Type)(unsafe.Pointer(uintptr(0x40017000)))

	// General-purpose-timers
	TIM16 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General-purpose-timers
	TIM17 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// General purpose timers
	TIM15 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// FDCAN1
	FDCAN1 = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// CCU registers
	CAN_CCU = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x4000a800)))

	// Management data input/output slave
	MDIOS = (*MDIOS_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// Operational amplifiers
	OPAMP = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// Single Wire Protocol Master Interface
	SWPMI = (*SWPMI_Type)(unsafe.Pointer(uintptr(0x40008800)))

	// General purpose timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Microcontroller Debug Unit
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0x5c001000)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Processor features
	PF = (*PF_Type)(unsafe.Pointer(uintptr(0xe000ed78)))

	// Access control
	AC = (*AC_Type)(unsafe.Pointer(uintptr(0xe000ef90)))

	// General purpose timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General purpose timers
	TIM12 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// General purpose timers
	TIM13 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// RAM ECC monitoring
	RAMECC1 = (*RAMECC_Type)(unsafe.Pointer(uintptr(0x52009000)))

	// RAM ECC monitoring
	RAMECC3 = (*RAMECC_Type)(unsafe.Pointer(uintptr(0x58027000)))

	// I2C
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// I2C
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// I2C
	I2C4 = (*I2C_Type)(unsafe.Pointer(uintptr(0x58001c00)))

	// GPIO
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58020400)))

	// GPIO
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58020800)))

	// GPIO
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58020c00)))

	// GPIO
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58021000)))

	// GPIO
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58021400)))

	// GPIO
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58021800)))

	// GPIO
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58021c00)))

	// GPIO
	GPIOI = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58022000)))

	// GPIO
	GPIOJ = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58022400)))

	// GPIO
	GPIOK = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58022800)))

	// SAI
	SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// SAI
	SAI2 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015c00)))

	// SAI
	SAI3 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40016000)))

	// SDMMC1
	SDMMC2 = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x48022400)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Serial peripheral interface
	SPI4 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Serial peripheral interface
	SPI5 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Serial peripheral interface
	SPI6 = (*SPI_Type)(unsafe.Pointer(uintptr(0x58001400)))

	// Analog to Digital Converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Analog to Digital Converter
	ADC2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40022100)))

	// Analog-to-Digital Converter
	ADC12_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x40022300)))

	// Low power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x58002400)))

	// Low power timer
	LPTIM4 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x58002c00)))

	// Low power timer
	LPTIM5 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x58003000)))

	// DELAY_Block_SDMMC1
	DELAY_Block_QUADSPI = (*DLYB_Type)(unsafe.Pointer(uintptr(0x52006000)))

	// DELAY_Block_SDMMC1
	DELAY_Block_SDMMC2 = (*DLYB_Type)(unsafe.Pointer(uintptr(0x48022800)))

	// USB 1 on the go high speed
	OTG2_HS_GLOBAL = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// USB 1 on the go high speed
	OTG2_HS_HOST = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40080400)))

	// USB 1 on the go high speed
	OTG2_HS_DEVICE = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40080800)))

	// USB 1 on the go high speed
	OTG2_HS_PWRCLK = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40080e00)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Universal synchronous asynchronous receiver transmitter
	USART6 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))

	// Universal synchronous asynchronous receiver transmitter
	UART7 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Universal synchronous asynchronous receiver transmitter
	UART8 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// FDCAN1
	FDCAN2 = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x4000a400)))

	// General purpose timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// General purpose timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General purpose timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// DMA controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// RAM ECC monitoring
	RAMECC2 = (*RAMECC_Type)(unsafe.Pointer(uintptr(0x48023000)))
)

// COMP1
type COMP1_Type struct {
	SR    volatile.Register32 // 0x0
	ICFR  volatile.Register32 // 0x4
	OR    volatile.Register32 // 0x8
	CFGR1 volatile.Register32 // 0xC
	CFGR2 volatile.Register32 // 0x10
}

// COMP1.SR: Comparator status register
func (o *COMP1_Type) SetSR_C1VAL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *COMP1_Type) GetSR_C1VAL() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *COMP1_Type) SetSR_C2VAL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *COMP1_Type) GetSR_C2VAL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *COMP1_Type) SetSR_C1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *COMP1_Type) GetSR_C1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *COMP1_Type) SetSR_C2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *COMP1_Type) GetSR_C2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// COMP1.ICFR: Comparator interrupt clear flag register
func (o *COMP1_Type) SetICFR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.ICFR.Reg, volatile.LoadUint32(&o.ICFR.Reg)&^(0x10000)|value<<16)
}
func (o *COMP1_Type) GetICFR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.ICFR.Reg) & 0x10000) >> 16
}
func (o *COMP1_Type) SetICFR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.ICFR.Reg, volatile.LoadUint32(&o.ICFR.Reg)&^(0x20000)|value<<17)
}
func (o *COMP1_Type) GetICFR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.ICFR.Reg) & 0x20000) >> 17
}

// COMP1.OR: Comparator option register
func (o *COMP1_Type) SetOR_AFOP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x7ff)|value)
}
func (o *COMP1_Type) GetOR_AFOP() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x7ff
}
func (o *COMP1_Type) SetOR(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0xfffff800)|value<<11)
}
func (o *COMP1_Type) GetOR() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0xfffff800) >> 11
}

// COMP1.CFGR1: Comparator configuration register 1
func (o *COMP1_Type) SetCFGR1_EN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1)|value)
}
func (o *COMP1_Type) GetCFGR1_EN() uint32 {
	return volatile.LoadUint32(&o.CFGR1.Reg) & 0x1
}
func (o *COMP1_Type) SetCFGR1_BRGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x2)|value<<1)
}
func (o *COMP1_Type) GetCFGR1_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x2) >> 1
}
func (o *COMP1_Type) SetCFGR1_SCALEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x4)|value<<2)
}
func (o *COMP1_Type) GetCFGR1_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x4) >> 2
}
func (o *COMP1_Type) SetCFGR1_POLARITY(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x8)|value<<3)
}
func (o *COMP1_Type) GetCFGR1_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x8) >> 3
}
func (o *COMP1_Type) SetCFGR1_ITEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *COMP1_Type) GetCFGR1_ITEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40) >> 6
}
func (o *COMP1_Type) SetCFGR1_HYST(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x300)|value<<8)
}
func (o *COMP1_Type) GetCFGR1_HYST() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x300) >> 8
}
func (o *COMP1_Type) SetCFGR1_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *COMP1_Type) GetCFGR1_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x3000) >> 12
}
func (o *COMP1_Type) SetCFGR1_INMSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x70000)|value<<16)
}
func (o *COMP1_Type) GetCFGR1_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x70000) >> 16
}
func (o *COMP1_Type) SetCFGR1_INPSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100000)|value<<20)
}
func (o *COMP1_Type) GetCFGR1_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100000) >> 20
}
func (o *COMP1_Type) SetCFGR1_BLANKING(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xf000000)|value<<24)
}
func (o *COMP1_Type) GetCFGR1_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xf000000) >> 24
}
func (o *COMP1_Type) SetCFGR1_LOCK(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP1_Type) GetCFGR1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80000000) >> 31
}

// COMP1.CFGR2: Comparator configuration register 2
func (o *COMP1_Type) SetCFGR2_EN(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *COMP1_Type) GetCFGR2_EN() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}
func (o *COMP1_Type) SetCFGR2_BRGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *COMP1_Type) GetCFGR2_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *COMP1_Type) SetCFGR2_SCALEN(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4)|value<<2)
}
func (o *COMP1_Type) GetCFGR2_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4) >> 2
}
func (o *COMP1_Type) SetCFGR2_POLARITY(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x8)|value<<3)
}
func (o *COMP1_Type) GetCFGR2_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x8) >> 3
}
func (o *COMP1_Type) SetCFGR2_WINMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x10)|value<<4)
}
func (o *COMP1_Type) GetCFGR2_WINMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x10) >> 4
}
func (o *COMP1_Type) SetCFGR2_ITEN(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x40)|value<<6)
}
func (o *COMP1_Type) GetCFGR2_ITEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x40) >> 6
}
func (o *COMP1_Type) SetCFGR2_HYST(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x300)|value<<8)
}
func (o *COMP1_Type) GetCFGR2_HYST() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x300) >> 8
}
func (o *COMP1_Type) SetCFGR2_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x3000)|value<<12)
}
func (o *COMP1_Type) GetCFGR2_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x3000) >> 12
}
func (o *COMP1_Type) SetCFGR2_INMSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x70000)|value<<16)
}
func (o *COMP1_Type) GetCFGR2_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x70000) >> 16
}
func (o *COMP1_Type) SetCFGR2_INPSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x100000)|value<<20)
}
func (o *COMP1_Type) GetCFGR2_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x100000) >> 20
}
func (o *COMP1_Type) SetCFGR2_BLANKING(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0xf000000)|value<<24)
}
func (o *COMP1_Type) GetCFGR2_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0xf000000) >> 24
}
func (o *COMP1_Type) SetCFGR2_LOCK(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP1_Type) GetCFGR2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x80000000) >> 31
}

// CRS
type CRS_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	ISR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
}

// CRS.CR: CRS control register
func (o *CRS_Type) SetCR_SYNCOKIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetCR_SYNCOKIE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *CRS_Type) SetCR_SYNCWARNIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetCR_SYNCWARNIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetCR_ESYNCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetCR_ESYNCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *CRS_Type) SetCR_CEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *CRS_Type) GetCR_CEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *CRS_Type) SetCR_AUTOTRIMEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *CRS_Type) GetCR_AUTOTRIMEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *CRS_Type) SetCR_SWSYNC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRS_Type) GetCR_SWSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRS_Type) SetCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3f00)|value<<8)
}
func (o *CRS_Type) GetCR_TRIM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3f00) >> 8
}

// CRS.CFGR: This register can be written only when the frequency error counter is disabled (CEN bit is cleared in CRS_CR). When the counter is enabled, this register is write-protected.
func (o *CRS_Type) SetCFGR_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xffff)|value)
}
func (o *CRS_Type) GetCFGR_RELOAD() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0xffff
}
func (o *CRS_Type) SetCFGR_FELIM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xff0000)|value<<16)
}
func (o *CRS_Type) GetCFGR_FELIM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xff0000) >> 16
}
func (o *CRS_Type) SetCFGR_SYNCDIV(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *CRS_Type) GetCFGR_SYNCDIV() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *CRS_Type) SetCFGR_SYNCSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x30000000)|value<<28)
}
func (o *CRS_Type) GetCFGR_SYNCSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x30000000) >> 28
}
func (o *CRS_Type) SetCFGR_SYNCPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *CRS_Type) GetCFGR_SYNCPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}

// CRS.ISR: CRS interrupt and status register
func (o *CRS_Type) SetISR_SYNCOKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetISR_SYNCOKF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *CRS_Type) SetISR_SYNCWARNF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetISR_SYNCWARNF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetISR_ERRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetISR_ERRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetISR_ESYNCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetISR_ESYNCF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *CRS_Type) SetISR_SYNCERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *CRS_Type) GetISR_SYNCERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *CRS_Type) SetISR_SYNCMISS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *CRS_Type) GetISR_SYNCMISS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *CRS_Type) SetISR_TRIMOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *CRS_Type) GetISR_TRIMOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *CRS_Type) SetISR_FEDIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *CRS_Type) GetISR_FEDIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *CRS_Type) SetISR_FECAP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CRS_Type) GetISR_FECAP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xffff0000) >> 16
}

// CRS.ICR: CRS interrupt flag clear register
func (o *CRS_Type) SetICR_SYNCOKC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetICR_SYNCOKC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *CRS_Type) SetICR_SYNCWARNC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetICR_SYNCWARNC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetICR_ERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetICR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetICR_ESYNCC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetICR_ESYNCC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// DAC
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRGR  volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
	CCR     volatile.Register32 // 0x38
	MCR     volatile.Register32 // 0x3C
	SHSR1   volatile.Register32 // 0x40
	SHSR2   volatile.Register32 // 0x44
	SHHR    volatile.Register32 // 0x48
	SHRR    volatile.Register32 // 0x4C
}

// DAC.CR: DAC control register
func (o *DAC_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DAC_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1c)|value<<2)
}
func (o *DAC_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1c) >> 2
}
func (o *DAC_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetCR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetCR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetCR_CEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetCR_CEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetCR_EN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_EN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_TEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DAC_Type) GetCR_TEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *DAC_Type) SetCR_TSEL2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1c0000)|value<<18)
}
func (o *DAC_Type) GetCR_TSEL2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1c0000) >> 18
}
func (o *DAC_Type) SetCR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00000)|value<<22)
}
func (o *DAC_Type) GetCR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00000) >> 22
}
func (o *DAC_Type) SetCR_MAMP2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetCR_MAMP2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *DAC_Type) SetCR_DMAEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetCR_DMAEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetCR_DMAUDRIE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetCR_DMAUDRIE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetCR_CEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *DAC_Type) GetCR_CEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}

// DAC.SWTRGR: DAC software trigger register
func (o *DAC_Type) SetSWTRGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRGR.Reg, volatile.LoadUint32(&o.SWTRGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSWTRGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRGR.Reg) & 0x1
}
func (o *DAC_Type) SetSWTRGR_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRGR.Reg, volatile.LoadUint32(&o.SWTRGR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSWTRGR_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRGR.Reg) & 0x2) >> 1
}

// DAC.DHR12R1: DAC channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC.DHR12L1: DAC channel1 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R1: DAC channel1 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC.DHR12R2: DAC channel2 12-bit right aligned data holding register
func (o *DAC_Type) SetDHR12R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R2.Reg, volatile.LoadUint32(&o.DHR12R2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R2.Reg) & 0xfff
}

// DAC.DHR12L2: DAC channel2 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L2.Reg, volatile.LoadUint32(&o.DHR12L2.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L2_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L2.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R2: DAC channel2 8-bit right-aligned data holding register
func (o *DAC_Type) SetDHR8R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R2.Reg, volatile.LoadUint32(&o.DHR8R2.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R2.Reg) & 0xff
}

// DAC.DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff
}
func (o *DAC_Type) SetDHR12RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDHR12RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff0000) >> 16
}

// DAC.DHR12LD: DUAL DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff0) >> 4
}
func (o *DAC_Type) SetDHR12LD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDHR12LD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff00000) >> 20
}

// DAC.DHR8RD: DUAL DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff
}
func (o *DAC_Type) SetDHR8RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDHR8RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff00) >> 8
}

// DAC.DOR1: DAC channel1 data output register
func (o *DAC_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC.DOR2: DAC channel2 data output register
func (o *DAC_Type) SetDOR2_DACC2DOR(value uint32) {
	volatile.StoreUint32(&o.DOR2.Reg, volatile.LoadUint32(&o.DOR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR2_DACC2DOR() uint32 {
	return volatile.LoadUint32(&o.DOR2.Reg) & 0xfff
}

// DAC.SR: DAC status register
func (o *DAC_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetSR_CAL_FLAG1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetSR_CAL_FLAG1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetSR_BWST1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *DAC_Type) GetSR_BWST1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *DAC_Type) SetSR_DMAUDR2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetSR_DMAUDR2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetSR_CAL_FLAG2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *DAC_Type) GetSR_CAL_FLAG2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *DAC_Type) SetSR_BWST2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *DAC_Type) GetSR_BWST2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// DAC.CCR: DAC calibration control register
func (o *DAC_Type) SetCCR_OTRIM1(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1f)|value)
}
func (o *DAC_Type) GetCCR_OTRIM1() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1f
}
func (o *DAC_Type) SetCCR_OTRIM2(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DAC_Type) GetCCR_OTRIM2() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x1f0000) >> 16
}

// DAC.MCR: DAC mode control register
func (o *DAC_Type) SetMCR_MODE1(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x7)|value)
}
func (o *DAC_Type) GetMCR_MODE1() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x7
}
func (o *DAC_Type) SetMCR_MODE2(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x70000)|value<<16)
}
func (o *DAC_Type) GetMCR_MODE2() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x70000) >> 16
}

// DAC.SHSR1: DAC Sample and Hold sample time register 1
func (o *DAC_Type) SetSHSR1_TSAMPLE1(value uint32) {
	volatile.StoreUint32(&o.SHSR1.Reg, volatile.LoadUint32(&o.SHSR1.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHSR1_TSAMPLE1() uint32 {
	return volatile.LoadUint32(&o.SHSR1.Reg) & 0x3ff
}

// DAC.SHSR2: DAC Sample and Hold sample time register 2
func (o *DAC_Type) SetSHSR2_TSAMPLE2(value uint32) {
	volatile.StoreUint32(&o.SHSR2.Reg, volatile.LoadUint32(&o.SHSR2.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHSR2_TSAMPLE2() uint32 {
	return volatile.LoadUint32(&o.SHSR2.Reg) & 0x3ff
}

// DAC.SHHR: DAC Sample and Hold hold time register
func (o *DAC_Type) SetSHHR_THOLD1(value uint32) {
	volatile.StoreUint32(&o.SHHR.Reg, volatile.LoadUint32(&o.SHHR.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHHR_THOLD1() uint32 {
	return volatile.LoadUint32(&o.SHHR.Reg) & 0x3ff
}
func (o *DAC_Type) SetSHHR_THOLD2(value uint32) {
	volatile.StoreUint32(&o.SHHR.Reg, volatile.LoadUint32(&o.SHHR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DAC_Type) GetSHHR_THOLD2() uint32 {
	return (volatile.LoadUint32(&o.SHHR.Reg) & 0x3ff0000) >> 16
}

// DAC.SHRR: DAC Sample and Hold refresh time register
func (o *DAC_Type) SetSHRR_TREFRESH1(value uint32) {
	volatile.StoreUint32(&o.SHRR.Reg, volatile.LoadUint32(&o.SHRR.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetSHRR_TREFRESH1() uint32 {
	return volatile.LoadUint32(&o.SHRR.Reg) & 0xff
}
func (o *DAC_Type) SetSHRR_TREFRESH2(value uint32) {
	volatile.StoreUint32(&o.SHRR.Reg, volatile.LoadUint32(&o.SHRR.Reg)&^(0xff0000)|value<<16)
}
func (o *DAC_Type) GetSHRR_TREFRESH2() uint32 {
	return (volatile.LoadUint32(&o.SHRR.Reg) & 0xff0000) >> 16
}

// BDMA
type BDMA_Type struct {
	ISR  volatile.Register32 // 0x0
	IFCR volatile.Register32 // 0x4
	CH   [8]BDMA_CH_Type     // 0x8
}

// BDMA.ISR: DMA interrupt status register
func (o *BDMA_Type) SetISR_GIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *BDMA_Type) GetISR_GIF1() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *BDMA_Type) SetISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *BDMA_Type) GetISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *BDMA_Type) SetISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *BDMA_Type) GetISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *BDMA_Type) SetISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *BDMA_Type) GetISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *BDMA_Type) SetISR_GIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *BDMA_Type) GetISR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *BDMA_Type) SetISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *BDMA_Type) GetISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *BDMA_Type) SetISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *BDMA_Type) GetISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *BDMA_Type) SetISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *BDMA_Type) GetISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *BDMA_Type) SetISR_GIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *BDMA_Type) GetISR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *BDMA_Type) SetISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *BDMA_Type) GetISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *BDMA_Type) SetISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *BDMA_Type) GetISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *BDMA_Type) SetISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *BDMA_Type) GetISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *BDMA_Type) SetISR_GIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *BDMA_Type) GetISR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *BDMA_Type) SetISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *BDMA_Type) GetISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *BDMA_Type) SetISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *BDMA_Type) GetISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *BDMA_Type) SetISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *BDMA_Type) GetISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *BDMA_Type) SetISR_GIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *BDMA_Type) GetISR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *BDMA_Type) SetISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *BDMA_Type) GetISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *BDMA_Type) SetISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *BDMA_Type) GetISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *BDMA_Type) SetISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *BDMA_Type) GetISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *BDMA_Type) SetISR_GIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *BDMA_Type) GetISR_GIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *BDMA_Type) SetISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *BDMA_Type) GetISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *BDMA_Type) SetISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *BDMA_Type) GetISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *BDMA_Type) SetISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *BDMA_Type) GetISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *BDMA_Type) SetISR_GIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *BDMA_Type) GetISR_GIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *BDMA_Type) SetISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *BDMA_Type) GetISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *BDMA_Type) SetISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *BDMA_Type) GetISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *BDMA_Type) SetISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *BDMA_Type) GetISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *BDMA_Type) SetISR_GIF8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *BDMA_Type) GetISR_GIF8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}
func (o *BDMA_Type) SetISR_TCIF8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *BDMA_Type) GetISR_TCIF8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *BDMA_Type) SetISR_HTIF8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *BDMA_Type) GetISR_HTIF8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *BDMA_Type) SetISR_TEIF8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *BDMA_Type) GetISR_TEIF8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// BDMA.IFCR: DMA interrupt flag clear register
func (o *BDMA_Type) SetIFCR_CGIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *BDMA_Type) GetIFCR_CGIF1() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}
func (o *BDMA_Type) SetIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *BDMA_Type) GetIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *BDMA_Type) SetIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *BDMA_Type) GetIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *BDMA_Type) SetIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *BDMA_Type) GetIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *BDMA_Type) SetIFCR_CGIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *BDMA_Type) GetIFCR_CGIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *BDMA_Type) SetIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *BDMA_Type) GetIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *BDMA_Type) SetIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *BDMA_Type) GetIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *BDMA_Type) SetIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *BDMA_Type) GetIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *BDMA_Type) SetIFCR_CGIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *BDMA_Type) GetIFCR_CGIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *BDMA_Type) SetIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *BDMA_Type) GetIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *BDMA_Type) SetIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *BDMA_Type) GetIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *BDMA_Type) SetIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *BDMA_Type) GetIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *BDMA_Type) SetIFCR_CGIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000)|value<<12)
}
func (o *BDMA_Type) GetIFCR_CGIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000) >> 12
}
func (o *BDMA_Type) SetIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000)|value<<13)
}
func (o *BDMA_Type) GetIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000) >> 13
}
func (o *BDMA_Type) SetIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000)|value<<14)
}
func (o *BDMA_Type) GetIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000) >> 14
}
func (o *BDMA_Type) SetIFCR_CTEIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000)|value<<15)
}
func (o *BDMA_Type) GetIFCR_CTEIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000) >> 15
}
func (o *BDMA_Type) SetIFCR_CGIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000)|value<<16)
}
func (o *BDMA_Type) GetIFCR_CGIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000) >> 16
}
func (o *BDMA_Type) SetIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000)|value<<17)
}
func (o *BDMA_Type) GetIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000) >> 17
}
func (o *BDMA_Type) SetIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000)|value<<18)
}
func (o *BDMA_Type) GetIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000) >> 18
}
func (o *BDMA_Type) SetIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000)|value<<19)
}
func (o *BDMA_Type) GetIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000) >> 19
}
func (o *BDMA_Type) SetIFCR_CGIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100000)|value<<20)
}
func (o *BDMA_Type) GetIFCR_CGIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100000) >> 20
}
func (o *BDMA_Type) SetIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200000)|value<<21)
}
func (o *BDMA_Type) GetIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200000) >> 21
}
func (o *BDMA_Type) SetIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400000)|value<<22)
}
func (o *BDMA_Type) GetIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400000) >> 22
}
func (o *BDMA_Type) SetIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800000)|value<<23)
}
func (o *BDMA_Type) GetIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800000) >> 23
}
func (o *BDMA_Type) SetIFCR_CGIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *BDMA_Type) GetIFCR_CGIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000000) >> 24
}
func (o *BDMA_Type) SetIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *BDMA_Type) GetIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000000) >> 25
}
func (o *BDMA_Type) SetIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *BDMA_Type) GetIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000000) >> 26
}
func (o *BDMA_Type) SetIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *BDMA_Type) GetIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000000) >> 27
}
func (o *BDMA_Type) SetIFCR_CGIF8(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000000)|value<<28)
}
func (o *BDMA_Type) GetIFCR_CGIF8() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000000) >> 28
}
func (o *BDMA_Type) SetIFCR_CTCIF8(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000000)|value<<29)
}
func (o *BDMA_Type) GetIFCR_CTCIF8() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000000) >> 29
}
func (o *BDMA_Type) SetIFCR_CHTIF8(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000000)|value<<30)
}
func (o *BDMA_Type) GetIFCR_CHTIF8() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000000) >> 30
}
func (o *BDMA_Type) SetIFCR_CTEIF8(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000000)|value<<31)
}
func (o *BDMA_Type) GetIFCR_CTEIF8() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000000) >> 31
}

type BDMA_CH_Type struct {
	CR   volatile.Register32 // 0x8
	NDTR volatile.Register32 // 0xC
	PAR  volatile.Register32 // 0x10
	M0AR volatile.Register32 // 0x14
	M1AR volatile.Register32 // 0x18
}

// BDMA_CH.CR: DMA channel x configuration register
func (o *BDMA_CH_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *BDMA_CH_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *BDMA_CH_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *BDMA_CH_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *BDMA_CH_Type) SetCR_HTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *BDMA_CH_Type) GetCR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *BDMA_CH_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *BDMA_CH_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *BDMA_CH_Type) SetCR_DIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *BDMA_CH_Type) GetCR_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *BDMA_CH_Type) SetCR_CIRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *BDMA_CH_Type) GetCR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *BDMA_CH_Type) SetCR_PINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *BDMA_CH_Type) GetCR_PINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *BDMA_CH_Type) SetCR_MINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *BDMA_CH_Type) GetCR_MINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *BDMA_CH_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *BDMA_CH_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *BDMA_CH_Type) SetCR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *BDMA_CH_Type) GetCR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *BDMA_CH_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3000)|value<<12)
}
func (o *BDMA_CH_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3000) >> 12
}
func (o *BDMA_CH_Type) SetCR_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *BDMA_CH_Type) GetCR_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *BDMA_CH_Type) SetCR_CT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *BDMA_CH_Type) GetCR_CT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *BDMA_CH_Type) SetCR_DBM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *BDMA_CH_Type) GetCR_DBM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}

// BDMA_CH.NDTR: DMA channel x number of data register
func (o *BDMA_CH_Type) SetNDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.NDTR.Reg, volatile.LoadUint32(&o.NDTR.Reg)&^(0xffff)|value)
}
func (o *BDMA_CH_Type) GetNDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.NDTR.Reg) & 0xffff
}

// BDMA_CH.PAR: This register must not be written when the channel is enabled.
func (o *BDMA_CH_Type) SetPAR(value uint32) {
	volatile.StoreUint32(&o.PAR.Reg, value)
}
func (o *BDMA_CH_Type) GetPAR() uint32 {
	return volatile.LoadUint32(&o.PAR.Reg)
}

// BDMA_CH.M0AR: This register must not be written when the channel is enabled.
func (o *BDMA_CH_Type) SetM0AR(value uint32) {
	volatile.StoreUint32(&o.M0AR.Reg, value)
}
func (o *BDMA_CH_Type) GetM0AR() uint32 {
	return volatile.LoadUint32(&o.M0AR.Reg)
}

// BDMA_CH.M1AR: Channel x memory 1 address register
func (o *BDMA_CH_Type) SetM1AR(value uint32) {
	volatile.StoreUint32(&o.M1AR.Reg, value)
}
func (o *BDMA_CH_Type) GetM1AR() uint32 {
	return volatile.LoadUint32(&o.M1AR.Reg)
}

// DMA2D
type DMA2D_Type struct {
	CR      volatile.Register32 // 0x0
	ISR     volatile.Register32 // 0x4
	IFCR    volatile.Register32 // 0x8
	FGMAR   volatile.Register32 // 0xC
	FGOR    volatile.Register32 // 0x10
	BGMAR   volatile.Register32 // 0x14
	BGOR    volatile.Register32 // 0x18
	FGPFCCR volatile.Register32 // 0x1C
	FGCOLR  volatile.Register32 // 0x20
	BGPFCCR volatile.Register32 // 0x24
	BGCOLR  volatile.Register32 // 0x28
	FGCMAR  volatile.Register32 // 0x2C
	BGCMAR  volatile.Register32 // 0x30
	OPFCCR  volatile.Register32 // 0x34
	OCOLR   volatile.Register32 // 0x38
	OMAR    volatile.Register32 // 0x3C
	OOR     volatile.Register32 // 0x40
	NLR     volatile.Register32 // 0x44
	LWR     volatile.Register32 // 0x48
	AMTCR   volatile.Register32 // 0x4C
}

// DMA2D.CR: DMA2D control register
func (o *DMA2D_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DMA2D_Type) SetCR_SUSP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetCR_SUSP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetCR_ABORT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetCR_ABORT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA2D_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DMA2D_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA2D_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *DMA2D_Type) SetCR_TWIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA2D_Type) GetCR_TWIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *DMA2D_Type) SetCR_CAEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *DMA2D_Type) GetCR_CAEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *DMA2D_Type) SetCR_CTCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA2D_Type) GetCR_CTCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DMA2D_Type) SetCR_CEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA2D_Type) GetCR_CEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DMA2D_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}

// DMA2D.ISR: DMA2D Interrupt Status Register
func (o *DMA2D_Type) SetISR_TEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetISR_TEIF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DMA2D_Type) SetISR_TCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetISR_TCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetISR_TWIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetISR_TWIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetISR_CAEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2D_Type) GetISR_CAEIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA2D_Type) SetISR_CTCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetISR_CTCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetISR_CEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetISR_CEIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}

// DMA2D.IFCR: DMA2D interrupt flag clear register
func (o *DMA2D_Type) SetIFCR_CTEIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetIFCR_CTEIF() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}
func (o *DMA2D_Type) SetIFCR_CTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetIFCR_CTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetIFCR_CTWIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetIFCR_CTWIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetIFCR_CAECIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2D_Type) GetIFCR_CAECIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA2D_Type) SetIFCR_CCTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetIFCR_CCTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetIFCR_CCEIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetIFCR_CCEIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}

// DMA2D.FGMAR: DMA2D foreground memory address register
func (o *DMA2D_Type) SetFGMAR(value uint32) {
	volatile.StoreUint32(&o.FGMAR.Reg, value)
}
func (o *DMA2D_Type) GetFGMAR() uint32 {
	return volatile.LoadUint32(&o.FGMAR.Reg)
}

// DMA2D.FGOR: DMA2D foreground offset register
func (o *DMA2D_Type) SetFGOR_LO(value uint32) {
	volatile.StoreUint32(&o.FGOR.Reg, volatile.LoadUint32(&o.FGOR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetFGOR_LO() uint32 {
	return volatile.LoadUint32(&o.FGOR.Reg) & 0xffff
}

// DMA2D.BGMAR: DMA2D background memory address register
func (o *DMA2D_Type) SetBGMAR(value uint32) {
	volatile.StoreUint32(&o.BGMAR.Reg, value)
}
func (o *DMA2D_Type) GetBGMAR() uint32 {
	return volatile.LoadUint32(&o.BGMAR.Reg)
}

// DMA2D.BGOR: DMA2D background offset register
func (o *DMA2D_Type) SetBGOR_LO(value uint32) {
	volatile.StoreUint32(&o.BGOR.Reg, volatile.LoadUint32(&o.BGOR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetBGOR_LO() uint32 {
	return volatile.LoadUint32(&o.BGOR.Reg) & 0xffff
}

// DMA2D.FGPFCCR: DMA2D foreground PFC control register
func (o *DMA2D_Type) SetFGPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xf)|value)
}
func (o *DMA2D_Type) GetFGPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xf
}
func (o *DMA2D_Type) SetFGPFCCR_CCM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetFGPFCCR_CCM() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetFGPFCCR_START(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetFGPFCCR_START() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetFGPFCCR_CS(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetFGPFCCR_CS() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetFGPFCCR_AM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetFGPFCCR_AM() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x30000) >> 16
}
func (o *DMA2D_Type) SetFGPFCCR_CSS(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA2D_Type) GetFGPFCCR_CSS() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xc0000) >> 18
}
func (o *DMA2D_Type) SetFGPFCCR_AI(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA2D_Type) GetFGPFCCR_AI() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x100000) >> 20
}
func (o *DMA2D_Type) SetFGPFCCR_RBS(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA2D_Type) GetFGPFCCR_RBS() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x200000) >> 21
}
func (o *DMA2D_Type) SetFGPFCCR_ALPHA(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetFGPFCCR_ALPHA() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xff000000) >> 24
}

// DMA2D.FGCOLR: DMA2D foreground color register
func (o *DMA2D_Type) SetFGCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetFGCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff
}
func (o *DMA2D_Type) SetFGCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetFGCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetFGCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetFGCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff0000) >> 16
}

// DMA2D.BGPFCCR: DMA2D background PFC control register
func (o *DMA2D_Type) SetBGPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xf)|value)
}
func (o *DMA2D_Type) GetBGPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xf
}
func (o *DMA2D_Type) SetBGPFCCR_CCM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetBGPFCCR_CCM() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetBGPFCCR_START(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetBGPFCCR_START() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetBGPFCCR_CS(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetBGPFCCR_CS() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetBGPFCCR_AM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetBGPFCCR_AM() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x30000) >> 16
}
func (o *DMA2D_Type) SetBGPFCCR_AI(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA2D_Type) GetBGPFCCR_AI() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x100000) >> 20
}
func (o *DMA2D_Type) SetBGPFCCR_RBS(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA2D_Type) GetBGPFCCR_RBS() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x200000) >> 21
}
func (o *DMA2D_Type) SetBGPFCCR_ALPHA(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetBGPFCCR_ALPHA() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xff000000) >> 24
}

// DMA2D.BGCOLR: DMA2D background color register
func (o *DMA2D_Type) SetBGCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetBGCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff
}
func (o *DMA2D_Type) SetBGCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetBGCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetBGCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetBGCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff0000) >> 16
}

// DMA2D.FGCMAR: DMA2D foreground CLUT memory address register
func (o *DMA2D_Type) SetFGCMAR(value uint32) {
	volatile.StoreUint32(&o.FGCMAR.Reg, value)
}
func (o *DMA2D_Type) GetFGCMAR() uint32 {
	return volatile.LoadUint32(&o.FGCMAR.Reg)
}

// DMA2D.BGCMAR: DMA2D background CLUT memory address register
func (o *DMA2D_Type) SetBGCMAR(value uint32) {
	volatile.StoreUint32(&o.BGCMAR.Reg, value)
}
func (o *DMA2D_Type) GetBGCMAR() uint32 {
	return volatile.LoadUint32(&o.BGCMAR.Reg)
}

// DMA2D.OPFCCR: DMA2D output PFC control register
func (o *DMA2D_Type) SetOPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x7)|value)
}
func (o *DMA2D_Type) GetOPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.OPFCCR.Reg) & 0x7
}
func (o *DMA2D_Type) SetOPFCCR_AI(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA2D_Type) GetOPFCCR_AI() uint32 {
	return (volatile.LoadUint32(&o.OPFCCR.Reg) & 0x100000) >> 20
}
func (o *DMA2D_Type) SetOPFCCR_RBS(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA2D_Type) GetOPFCCR_RBS() uint32 {
	return (volatile.LoadUint32(&o.OPFCCR.Reg) & 0x200000) >> 21
}
func (o *DMA2D_Type) SetOPFCCR_SB(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA2D_Type) GetOPFCCR_SB() uint32 {
	return (volatile.LoadUint32(&o.OPFCCR.Reg) & 0x100) >> 8
}

// DMA2D.OCOLR: DMA2D output color register
func (o *DMA2D_Type) SetOCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetOCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.OCOLR.Reg) & 0xff
}
func (o *DMA2D_Type) SetOCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetOCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetOCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetOCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetOCOLR_ALPHA(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetOCOLR_ALPHA() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff000000) >> 24
}

// DMA2D.OMAR: DMA2D output memory address register
func (o *DMA2D_Type) SetOMAR(value uint32) {
	volatile.StoreUint32(&o.OMAR.Reg, value)
}
func (o *DMA2D_Type) GetOMAR() uint32 {
	return volatile.LoadUint32(&o.OMAR.Reg)
}

// DMA2D.OOR: DMA2D output offset register
func (o *DMA2D_Type) SetOOR_LO(value uint32) {
	volatile.StoreUint32(&o.OOR.Reg, volatile.LoadUint32(&o.OOR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetOOR_LO() uint32 {
	return volatile.LoadUint32(&o.OOR.Reg) & 0xffff
}

// DMA2D.NLR: DMA2D number of line register
func (o *DMA2D_Type) SetNLR_NL(value uint32) {
	volatile.StoreUint32(&o.NLR.Reg, volatile.LoadUint32(&o.NLR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetNLR_NL() uint32 {
	return volatile.LoadUint32(&o.NLR.Reg) & 0xffff
}
func (o *DMA2D_Type) SetNLR_PL(value uint32) {
	volatile.StoreUint32(&o.NLR.Reg, volatile.LoadUint32(&o.NLR.Reg)&^(0x3fff0000)|value<<16)
}
func (o *DMA2D_Type) GetNLR_PL() uint32 {
	return (volatile.LoadUint32(&o.NLR.Reg) & 0x3fff0000) >> 16
}

// DMA2D.LWR: DMA2D line watermark register
func (o *DMA2D_Type) SetLWR_LW(value uint32) {
	volatile.StoreUint32(&o.LWR.Reg, volatile.LoadUint32(&o.LWR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetLWR_LW() uint32 {
	return volatile.LoadUint32(&o.LWR.Reg) & 0xffff
}

// DMA2D.AMTCR: DMA2D AXI master timer configuration register
func (o *DMA2D_Type) SetAMTCR_EN(value uint32) {
	volatile.StoreUint32(&o.AMTCR.Reg, volatile.LoadUint32(&o.AMTCR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetAMTCR_EN() uint32 {
	return volatile.LoadUint32(&o.AMTCR.Reg) & 0x1
}
func (o *DMA2D_Type) SetAMTCR_DT(value uint32) {
	volatile.StoreUint32(&o.AMTCR.Reg, volatile.LoadUint32(&o.AMTCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetAMTCR_DT() uint32 {
	return (volatile.LoadUint32(&o.AMTCR.Reg) & 0xff00) >> 8
}

// DMAMUX
type DMAMUX_Type struct {
	CCR0  volatile.Register32 // 0x0
	CCR1  volatile.Register32 // 0x4
	CCR2  volatile.Register32 // 0x8
	CCR3  volatile.Register32 // 0xC
	CCR4  volatile.Register32 // 0x10
	CCR5  volatile.Register32 // 0x14
	CCR6  volatile.Register32 // 0x18
	CCR7  volatile.Register32 // 0x1C
	_     [96]byte
	CSR   volatile.Register32 // 0x80
	CFR   volatile.Register32 // 0x84
	_     [120]byte
	RGCR0 volatile.Register32 // 0x100
	RGCR1 volatile.Register32 // 0x104
	RGCR2 volatile.Register32 // 0x108
	RGCR3 volatile.Register32 // 0x10C
	RGCR4 volatile.Register32 // 0x110
	RGCR5 volatile.Register32 // 0x114
	RGCR6 volatile.Register32 // 0x118
	RGCR7 volatile.Register32 // 0x11C
	_     [32]byte
	RGSR  volatile.Register32 // 0x140
	RGCFR volatile.Register32 // 0x144
}

// DMAMUX.CCR0: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR0_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR0_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR0.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR0_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR0_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR0_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR0_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR0_SE(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR0_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR0_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR0_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR0_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR0_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR0_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR0_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR1: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR1_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR1_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR1_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR1_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR1_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR1_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR1_SE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR1_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR1_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR1_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR1_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR1_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR1_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR1_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR2: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR2_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR2_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR2_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR2_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR2_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR2_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR2_SE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR2_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR2_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR2_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR2_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR2_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR2_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR2_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR3: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR3_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR3_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR3_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR3_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR3_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR3_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR3_SE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR3_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR3_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR3_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR3_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR3_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR3_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR3_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR4: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR4_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR4_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR4_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR4_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR4_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR4_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR4_SE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR4_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR4_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR4_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR4_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR4_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR4_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR4_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR5: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR5_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR5_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR5_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR5_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR5_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR5_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR5_SE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR5_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR5_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR5_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR5_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR5_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR5_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR5_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR6: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR6_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR6_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR6_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR6_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR6_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR6_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR6_SE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR6_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR6_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR6_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR6_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR6_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR6_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR6_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR7: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR7_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR7_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR7.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR7_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR7_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR7_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR7_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR7_SE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR7_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR7_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR7_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR7_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR7_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR7_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR7_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CSR: DMAMUX request line multiplexer interrupt channel status register
func (o *DMAMUX_Type) SetCSR_SOF0(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCSR_SOF0() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCSR_SOF1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCSR_SOF1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCSR_SOF2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCSR_SOF2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCSR_SOF3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCSR_SOF3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCSR_SOF4(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCSR_SOF4() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCSR_SOF5(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCSR_SOF5() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCSR_SOF6(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCSR_SOF6() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCSR_SOF7(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCSR_SOF7() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *DMAMUX_Type) SetCSR_SOF8(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCSR_SOF8() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCSR_SOF9(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCSR_SOF9() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCSR_SOF10(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *DMAMUX_Type) GetCSR_SOF10() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *DMAMUX_Type) SetCSR_SOF11(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *DMAMUX_Type) GetCSR_SOF11() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *DMAMUX_Type) SetCSR_SOF12(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAMUX_Type) GetCSR_SOF12() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *DMAMUX_Type) SetCSR_SOF13(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAMUX_Type) GetCSR_SOF13() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *DMAMUX_Type) SetCSR_SOF14(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAMUX_Type) GetCSR_SOF14() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000) >> 14
}
func (o *DMAMUX_Type) SetCSR_SOF15(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAMUX_Type) GetCSR_SOF15() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000) >> 15
}

// DMAMUX.CFR: DMAMUX request line multiplexer interrupt clear flag register
func (o *DMAMUX_Type) SetCFR_CSOF0(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCFR_CSOF0() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCFR_CSOF1(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCFR_CSOF1() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCFR_CSOF2(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCFR_CSOF2() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCFR_CSOF3(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCFR_CSOF3() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCFR_CSOF4(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCFR_CSOF4() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCFR_CSOF5(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCFR_CSOF5() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCFR_CSOF6(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCFR_CSOF6() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCFR_CSOF7(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCFR_CSOF7() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x80) >> 7
}
func (o *DMAMUX_Type) SetCFR_CSOF8(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCFR_CSOF8() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCFR_CSOF9(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCFR_CSOF9() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCFR_CSOF10(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x400)|value<<10)
}
func (o *DMAMUX_Type) GetCFR_CSOF10() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x400) >> 10
}
func (o *DMAMUX_Type) SetCFR_CSOF11(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x800)|value<<11)
}
func (o *DMAMUX_Type) GetCFR_CSOF11() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x800) >> 11
}
func (o *DMAMUX_Type) SetCFR_CSOF12(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAMUX_Type) GetCFR_CSOF12() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x1000) >> 12
}
func (o *DMAMUX_Type) SetCFR_CSOF13(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAMUX_Type) GetCFR_CSOF13() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x2000) >> 13
}
func (o *DMAMUX_Type) SetCFR_CSOF14(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAMUX_Type) GetCFR_CSOF14() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x4000) >> 14
}
func (o *DMAMUX_Type) SetCFR_CSOF15(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAMUX_Type) GetCFR_CSOF15() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x8000) >> 15
}

// DMAMUX.RGCR0: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR0_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR0.Reg, volatile.LoadUint32(&o.RGCR0.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR0_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR0.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR0_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR0.Reg, volatile.LoadUint32(&o.RGCR0.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR0_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR0.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR0_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR0.Reg, volatile.LoadUint32(&o.RGCR0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR0_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR0.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR0_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR0.Reg, volatile.LoadUint32(&o.RGCR0.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR0_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR0.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR0_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR0.Reg, volatile.LoadUint32(&o.RGCR0.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR0_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR0.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR1: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR1_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR1.Reg, volatile.LoadUint32(&o.RGCR1.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR1_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR1.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR1_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR1.Reg, volatile.LoadUint32(&o.RGCR1.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR1_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR1.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR1_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR1.Reg, volatile.LoadUint32(&o.RGCR1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR1_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR1.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR1_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR1.Reg, volatile.LoadUint32(&o.RGCR1.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR1_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR1.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR1_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR1.Reg, volatile.LoadUint32(&o.RGCR1.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR1_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR1.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR2: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR2_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR2.Reg, volatile.LoadUint32(&o.RGCR2.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR2_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR2.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR2_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR2.Reg, volatile.LoadUint32(&o.RGCR2.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR2_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR2.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR2_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR2.Reg, volatile.LoadUint32(&o.RGCR2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR2_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR2.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR2_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR2.Reg, volatile.LoadUint32(&o.RGCR2.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR2_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR2.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR2_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR2.Reg, volatile.LoadUint32(&o.RGCR2.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR2_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR2.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR3: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR3_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR3.Reg, volatile.LoadUint32(&o.RGCR3.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR3_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR3.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR3_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR3.Reg, volatile.LoadUint32(&o.RGCR3.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR3_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR3.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR3_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR3.Reg, volatile.LoadUint32(&o.RGCR3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR3_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR3.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR3_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR3.Reg, volatile.LoadUint32(&o.RGCR3.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR3_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR3.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR3_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR3.Reg, volatile.LoadUint32(&o.RGCR3.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR3_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR3.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR4: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR4_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR4.Reg, volatile.LoadUint32(&o.RGCR4.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR4_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR4.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR4_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR4.Reg, volatile.LoadUint32(&o.RGCR4.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR4_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR4.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR4_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR4.Reg, volatile.LoadUint32(&o.RGCR4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR4_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR4.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR4_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR4.Reg, volatile.LoadUint32(&o.RGCR4.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR4_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR4.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR4_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR4.Reg, volatile.LoadUint32(&o.RGCR4.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR4_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR4.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR5: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR5_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR5.Reg, volatile.LoadUint32(&o.RGCR5.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR5_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR5.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR5_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR5.Reg, volatile.LoadUint32(&o.RGCR5.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR5_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR5.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR5_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR5.Reg, volatile.LoadUint32(&o.RGCR5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR5_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR5.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR5_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR5.Reg, volatile.LoadUint32(&o.RGCR5.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR5_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR5.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR5_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR5.Reg, volatile.LoadUint32(&o.RGCR5.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR5_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR5.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR6: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR6_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR6.Reg, volatile.LoadUint32(&o.RGCR6.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR6_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR6.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR6_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR6.Reg, volatile.LoadUint32(&o.RGCR6.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR6_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR6.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR6_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR6.Reg, volatile.LoadUint32(&o.RGCR6.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR6_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR6.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR6_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR6.Reg, volatile.LoadUint32(&o.RGCR6.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR6_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR6.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR6_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR6.Reg, volatile.LoadUint32(&o.RGCR6.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR6_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR6.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR7: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR7_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR7.Reg, volatile.LoadUint32(&o.RGCR7.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR7_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR7.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR7_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR7.Reg, volatile.LoadUint32(&o.RGCR7.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR7_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR7.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR7_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR7.Reg, volatile.LoadUint32(&o.RGCR7.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR7_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR7.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR7_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR7.Reg, volatile.LoadUint32(&o.RGCR7.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR7_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR7.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR7_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR7.Reg, volatile.LoadUint32(&o.RGCR7.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR7_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR7.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGSR: DMAMux - DMA request generator status register
func (o *DMAMUX_Type) SetRGSR_OF0(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGSR_OF0() uint32 {
	return volatile.LoadUint32(&o.RGSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGSR_OF1(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGSR_OF1() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGSR_OF2(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGSR_OF2() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGSR_OF3(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGSR_OF3() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetRGSR_OF4(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetRGSR_OF4() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetRGSR_OF5(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetRGSR_OF5() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetRGSR_OF6(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetRGSR_OF6() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetRGSR_OF7(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetRGSR_OF7() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x80) >> 7
}

// DMAMUX.RGCFR: DMAMux - DMA request generator clear flag register
func (o *DMAMUX_Type) SetRGCFR_COF0(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGCFR_COF0() uint32 {
	return volatile.LoadUint32(&o.RGCFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGCFR_COF1(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGCFR_COF1() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGCFR_COF2(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGCFR_COF2() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGCFR_COF3(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGCFR_COF3() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetRGCFR_COF4(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetRGCFR_COF4() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetRGCFR_COF5(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetRGCFR_COF5() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetRGCFR_COF6(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetRGCFR_COF6() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetRGCFR_COF7(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetRGCFR_COF7() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x80) >> 7
}

// FMC
type FMC_Type struct {
	BCR1   volatile.Register32 // 0x0
	BTR1   volatile.Register32 // 0x4
	BCR2   volatile.Register32 // 0x8
	BTR2   volatile.Register32 // 0xC
	BCR3   volatile.Register32 // 0x10
	BTR3   volatile.Register32 // 0x14
	BCR4   volatile.Register32 // 0x18
	BTR4   volatile.Register32 // 0x1C
	_      [96]byte
	PCR    volatile.Register32 // 0x80
	SR     volatile.Register32 // 0x84
	PMEM   volatile.Register32 // 0x88
	PATT   volatile.Register32 // 0x8C
	_      [4]byte
	ECCR   volatile.Register32 // 0x94
	_      [108]byte
	BWTR1  volatile.Register32 // 0x104
	_      [4]byte
	BWTR2  volatile.Register32 // 0x10C
	_      [4]byte
	BWTR3  volatile.Register32 // 0x114
	_      [4]byte
	BWTR4  volatile.Register32 // 0x11C
	_      [32]byte
	SDBANK [2]FMC_SDBANK_Type // 0x140
	_      [8]byte
	SDCMR  volatile.Register32 // 0x150
	SDRTR  volatile.Register32 // 0x154
	SDSR   volatile.Register32 // 0x158
}

// FMC.BCR1: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.
func (o *FMC_Type) SetBCR1_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR1_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR1.Reg) & 0x1
}
func (o *FMC_Type) SetBCR1_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR1_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR1_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR1_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR1_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR1_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR1_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR1_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR1_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR1_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR1_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR1_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR1_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR1_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR1_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR1_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR1_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR1_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR1_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR1_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR1_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR1_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR1_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x70000)|value<<16)
}
func (o *FMC_Type) GetBCR1_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x70000) >> 16
}
func (o *FMC_Type) SetBCR1_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR1_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR1_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100000)|value<<20)
}
func (o *FMC_Type) GetBCR1_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100000) >> 20
}
func (o *FMC_Type) SetBCR1_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200000)|value<<21)
}
func (o *FMC_Type) GetBCR1_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200000) >> 21
}
func (o *FMC_Type) SetBCR1_BMAP(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x3000000)|value<<24)
}
func (o *FMC_Type) GetBCR1_BMAP() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x3000000) >> 24
}
func (o *FMC_Type) SetBCR1_FMCEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x80000000)|value<<31)
}
func (o *FMC_Type) GetBCR1_FMCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x80000000) >> 31
}

// FMC.BTR1: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.If the EXTMOD bit is set in the FMC_BCRx register, then this register is partitioned for write and read access, that is, 2 registers are available: one to configure read accesses (this register) and one to configure write accesses (FMC_BWTRx registers).
func (o *FMC_Type) SetBTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR1.Reg) & 0xf
}
func (o *FMC_Type) SetBTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0x30000000) >> 28
}

// FMC.BCR2: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.
func (o *FMC_Type) SetBCR2_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR2_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR2.Reg) & 0x1
}
func (o *FMC_Type) SetBCR2_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR2_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR2_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR2_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR2_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR2_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR2_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR2_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR2_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR2_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR2_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR2_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR2_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR2_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR2_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR2_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR2_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR2_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR2_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR2_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR2_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR2_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR2_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x70000)|value<<16)
}
func (o *FMC_Type) GetBCR2_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x70000) >> 16
}
func (o *FMC_Type) SetBCR2_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR2_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR2_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x100000)|value<<20)
}
func (o *FMC_Type) GetBCR2_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x100000) >> 20
}
func (o *FMC_Type) SetBCR2_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x200000)|value<<21)
}
func (o *FMC_Type) GetBCR2_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x200000) >> 21
}
func (o *FMC_Type) SetBCR2_BMAP(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x3000000)|value<<24)
}
func (o *FMC_Type) GetBCR2_BMAP() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x3000000) >> 24
}
func (o *FMC_Type) SetBCR2_FMCEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x80000000)|value<<31)
}
func (o *FMC_Type) GetBCR2_FMCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x80000000) >> 31
}

// FMC.BTR2: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.If the EXTMOD bit is set in the FMC_BCRx register, then this register is partitioned for write and read access, that is, 2 registers are available: one to configure read accesses (this register) and one to configure write accesses (FMC_BWTRx registers).
func (o *FMC_Type) SetBTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR2.Reg) & 0xf
}
func (o *FMC_Type) SetBTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0x30000000) >> 28
}

// FMC.BCR3: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.
func (o *FMC_Type) SetBCR3_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR3_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR3.Reg) & 0x1
}
func (o *FMC_Type) SetBCR3_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR3_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR3_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR3_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR3_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR3_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR3_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR3_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR3_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR3_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR3_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR3_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR3_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR3_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR3_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR3_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR3_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR3_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR3_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR3_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR3_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR3_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR3_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x70000)|value<<16)
}
func (o *FMC_Type) GetBCR3_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x70000) >> 16
}
func (o *FMC_Type) SetBCR3_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR3_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR3_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x100000)|value<<20)
}
func (o *FMC_Type) GetBCR3_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x100000) >> 20
}
func (o *FMC_Type) SetBCR3_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x200000)|value<<21)
}
func (o *FMC_Type) GetBCR3_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x200000) >> 21
}
func (o *FMC_Type) SetBCR3_BMAP(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x3000000)|value<<24)
}
func (o *FMC_Type) GetBCR3_BMAP() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x3000000) >> 24
}
func (o *FMC_Type) SetBCR3_FMCEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x80000000)|value<<31)
}
func (o *FMC_Type) GetBCR3_FMCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x80000000) >> 31
}

// FMC.BTR3: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.If the EXTMOD bit is set in the FMC_BCRx register, then this register is partitioned for write and read access, that is, 2 registers are available: one to configure read accesses (this register) and one to configure write accesses (FMC_BWTRx registers).
func (o *FMC_Type) SetBTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR3.Reg) & 0xf
}
func (o *FMC_Type) SetBTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0x30000000) >> 28
}

// FMC.BCR4: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.
func (o *FMC_Type) SetBCR4_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR4_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR4.Reg) & 0x1
}
func (o *FMC_Type) SetBCR4_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR4_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR4_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR4_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR4_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR4_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR4_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR4_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR4_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR4_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR4_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR4_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR4_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR4_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR4_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR4_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR4_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR4_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR4_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR4_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR4_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR4_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR4_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x70000)|value<<16)
}
func (o *FMC_Type) GetBCR4_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x70000) >> 16
}
func (o *FMC_Type) SetBCR4_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR4_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR4_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x100000)|value<<20)
}
func (o *FMC_Type) GetBCR4_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x100000) >> 20
}
func (o *FMC_Type) SetBCR4_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x200000)|value<<21)
}
func (o *FMC_Type) GetBCR4_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x200000) >> 21
}
func (o *FMC_Type) SetBCR4_BMAP(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x3000000)|value<<24)
}
func (o *FMC_Type) GetBCR4_BMAP() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x3000000) >> 24
}
func (o *FMC_Type) SetBCR4_FMCEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x80000000)|value<<31)
}
func (o *FMC_Type) GetBCR4_FMCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x80000000) >> 31
}

// FMC.BTR4: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.If the EXTMOD bit is set in the FMC_BCRx register, then this register is partitioned for write and read access, that is, 2 registers are available: one to configure read accesses (this register) and one to configure write accesses (FMC_BWTRx registers).
func (o *FMC_Type) SetBTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR4.Reg) & 0xf
}
func (o *FMC_Type) SetBTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0x30000000) >> 28
}

// FMC.PCR: NAND Flash control registers
func (o *FMC_Type) SetPCR_PWAITEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetPCR_PWAITEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetPCR_PBKEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x4)|value<<2)
}
func (o *FMC_Type) GetPCR_PBKEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x4) >> 2
}
func (o *FMC_Type) SetPCR_PWID(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetPCR_PWID() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetPCR_ECCEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetPCR_ECCEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetPCR_TCLR(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1e00)|value<<9)
}
func (o *FMC_Type) GetPCR_TCLR() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1e00) >> 9
}
func (o *FMC_Type) SetPCR_TAR(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1e000)|value<<13)
}
func (o *FMC_Type) GetPCR_TAR() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1e000) >> 13
}
func (o *FMC_Type) SetPCR_ECCPS(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0xe0000)|value<<17)
}
func (o *FMC_Type) GetPCR_ECCPS() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0xe0000) >> 17
}

// FMC.SR: This register contains information about the FIFO status and interrupt. The FMC features a FIFO that is used when writing to memories to transfer up to 16 words of data.This is used to quickly write to the FIFO and free the AXI bus for transactions to peripherals other than the FMC, while the FMC is draining its FIFO into the memory. One of these register bits indicates the status of the FIFO, for ECC purposes.The ECC is calculated while the data are written to the memory. To read the correct ECC, the software must consequently wait until the FIFO is empty.
func (o *FMC_Type) SetSR_IRS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetSR_IRS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *FMC_Type) SetSR_ILS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetSR_ILS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetSR_IFS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *FMC_Type) GetSR_IFS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *FMC_Type) SetSR_IREN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *FMC_Type) GetSR_IREN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *FMC_Type) SetSR_ILEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *FMC_Type) GetSR_ILEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *FMC_Type) SetSR_IFEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *FMC_Type) GetSR_IFEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *FMC_Type) SetSR_FEMPT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetSR_FEMPT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}

// FMC.PMEM: The FMC_PMEM read/write register contains the timing information for NAND Flash memory bank. This information is used to access either the common memory space of the NAND Flash for command, address write access and data read/write access.
func (o *FMC_Type) SetPMEM_MEMSET(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff)|value)
}
func (o *FMC_Type) GetPMEM_MEMSET() uint32 {
	return volatile.LoadUint32(&o.PMEM.Reg) & 0xff
}
func (o *FMC_Type) SetPMEM_MEMWAIT(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetPMEM_MEMWAIT() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetPMEM_MEMHOLD(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff0000)|value<<16)
}
func (o *FMC_Type) GetPMEM_MEMHOLD() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff0000) >> 16
}
func (o *FMC_Type) SetPMEM_MEMHIZ(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff000000)|value<<24)
}
func (o *FMC_Type) GetPMEM_MEMHIZ() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff000000) >> 24
}

// FMC.PATT: The FMC_PATT read/write register contains the timing information for NAND Flash memory bank. It is used for 8-bit accesses to the attribute memory space of the NAND Flash for the last address write access if the timing must differ from that of previous accesses (for Ready/Busy management, refer to Section20.8.5: NAND Flash prewait feature).
func (o *FMC_Type) SetPATT_ATTSET(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff)|value)
}
func (o *FMC_Type) GetPATT_ATTSET() uint32 {
	return volatile.LoadUint32(&o.PATT.Reg) & 0xff
}
func (o *FMC_Type) SetPATT_ATTWAIT(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetPATT_ATTWAIT() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetPATT_ATTHOLD(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff0000)|value<<16)
}
func (o *FMC_Type) GetPATT_ATTHOLD() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff0000) >> 16
}
func (o *FMC_Type) SetPATT_ATTHIZ(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff000000)|value<<24)
}
func (o *FMC_Type) GetPATT_ATTHIZ() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff000000) >> 24
}

// FMC.ECCR: This register contain the current error correction code value computed by the ECC computation modules of the FMC NAND controller. When the CPU reads/writes the data from a NAND Flash memory page at the correct address (refer to Section20.8.6: Computation of the error correction code (ECC) in NAND Flash memory), the data read/written from/to the NAND Flash memory are processed automatically by the ECC computation module. When X bytes have been read (according to the ECCPS field in the FMC_PCR registers), the CPU must read the computed ECC value from the FMC_ECC registers. It then verifies if these computed parity data are the same as the parity value recorded in the spare area, to determine whether a page is valid, and, to correct it otherwise. The FMC_ECCR register should be cleared after being read by setting the ECCEN bit to 0. To compute a new data block, the ECCEN bit must be set to 1.
func (o *FMC_Type) SetECCR(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, value)
}
func (o *FMC_Type) GetECCR() uint32 {
	return volatile.LoadUint32(&o.ECCR.Reg)
}

// FMC.BWTR1: This register contains the control information of each memory bank. It is used for SRAMs, PSRAMs and NOR Flash memories. When the EXTMOD bit is set in the FMC_BCRx register, then this register is active for write access.
func (o *FMC_Type) SetBWTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR1.Reg) & 0xf
}
func (o *FMC_Type) SetBWTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBWTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBWTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0x30000000) >> 28
}

// FMC.BWTR2: This register contains the control information of each memory bank. It is used for SRAMs, PSRAMs and NOR Flash memories. When the EXTMOD bit is set in the FMC_BCRx register, then this register is active for write access.
func (o *FMC_Type) SetBWTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR2.Reg) & 0xf
}
func (o *FMC_Type) SetBWTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBWTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBWTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0x30000000) >> 28
}

// FMC.BWTR3: This register contains the control information of each memory bank. It is used for SRAMs, PSRAMs and NOR Flash memories. When the EXTMOD bit is set in the FMC_BCRx register, then this register is active for write access.
func (o *FMC_Type) SetBWTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR3.Reg) & 0xf
}
func (o *FMC_Type) SetBWTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBWTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBWTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0x30000000) >> 28
}

// FMC.BWTR4: This register contains the control information of each memory bank. It is used for SRAMs, PSRAMs and NOR Flash memories. When the EXTMOD bit is set in the FMC_BCRx register, then this register is active for write access.
func (o *FMC_Type) SetBWTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR4.Reg) & 0xf
}
func (o *FMC_Type) SetBWTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBWTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBWTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0x30000000) >> 28
}

// FMC.SDCMR: This register contains the command issued when the SDRAM device is accessed. This register is used to initialize the SDRAM device, and to activate the Self-refresh and the Power-down modes. As soon as the MODE field is written, the command will be issued only to one or to both SDRAM banks according to CTB1 and CTB2 command bits. This register is the same for both SDRAM banks.
func (o *FMC_Type) SetSDCMR_MODE(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x7)|value)
}
func (o *FMC_Type) GetSDCMR_MODE() uint32 {
	return volatile.LoadUint32(&o.SDCMR.Reg) & 0x7
}
func (o *FMC_Type) SetSDCMR_CTB2(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x8)|value<<3)
}
func (o *FMC_Type) GetSDCMR_CTB2() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x8) >> 3
}
func (o *FMC_Type) SetSDCMR_CTB1(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x10)|value<<4)
}
func (o *FMC_Type) GetSDCMR_CTB1() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x10) >> 4
}
func (o *FMC_Type) SetSDCMR_NRFS(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x1e0)|value<<5)
}
func (o *FMC_Type) GetSDCMR_NRFS() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x1e0) >> 5
}
func (o *FMC_Type) SetSDCMR_MRD(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x7ffe00)|value<<9)
}
func (o *FMC_Type) GetSDCMR_MRD() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x7ffe00) >> 9
}

// FMC.SDRTR: This register sets the refresh rate in number of SDCLK clock cycles between the refresh cycles by configuring the Refresh Timer Count value.Examplewhere 64 ms is the SDRAM refresh period.The refresh rate must be increased by 20 SDRAM clock cycles (as in the above example) to obtain a safe margin if an internal refresh request occurs when a read request has been accepted. It corresponds to a COUNT value of 0000111000000 (448). This 13-bit field is loaded into a timer which is decremented using the SDRAM clock. This timer generates a refresh pulse when zero is reached. The COUNT value must be set at least to 41 SDRAM clock cycles.As soon as the FMC_SDRTR register is programmed, the timer starts counting. If the value programmed in the register is 0, no refresh is carried out. This register must not be reprogrammed after the initialization procedure to avoid modifying the refresh rate.Each time a refresh pulse is generated, this 13-bit COUNT field is reloaded into the counter.If a memory access is in progress, the Auto-refresh request is delayed. However, if the memory access and Auto-refresh requests are generated simultaneously, the Auto-refresh takes precedence. If the memory access occurs during a refresh operation, the request is buffered to be processed when the refresh is complete.This register is common to SDRAM bank 1 and bank 2.
func (o *FMC_Type) SetSDRTR_CRE(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetSDRTR_CRE() uint32 {
	return volatile.LoadUint32(&o.SDRTR.Reg) & 0x1
}
func (o *FMC_Type) SetSDRTR_COUNT(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x3ffe)|value<<1)
}
func (o *FMC_Type) GetSDRTR_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SDRTR.Reg) & 0x3ffe) >> 1
}
func (o *FMC_Type) SetSDRTR_REIE(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetSDRTR_REIE() uint32 {
	return (volatile.LoadUint32(&o.SDRTR.Reg) & 0x4000) >> 14
}

// FMC.SDSR: SDRAM Status register
func (o *FMC_Type) SetSDSR_RE(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetSDSR_RE() uint32 {
	return volatile.LoadUint32(&o.SDSR.Reg) & 0x1
}
func (o *FMC_Type) SetSDSR_MODES1(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x6)|value<<1)
}
func (o *FMC_Type) GetSDSR_MODES1() uint32 {
	return (volatile.LoadUint32(&o.SDSR.Reg) & 0x6) >> 1
}
func (o *FMC_Type) SetSDSR_MODES2(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x18)|value<<3)
}
func (o *FMC_Type) GetSDSR_MODES2() uint32 {
	return (volatile.LoadUint32(&o.SDSR.Reg) & 0x18) >> 3
}

type FMC_SDBANK_Type struct {
	SDCR volatile.Register32 // 0x140
	_    [4]byte
	SDTR volatile.Register32 // 0x148
}

// FMC_SDBANK.SDCR: This register contains the control parameters for each SDRAM memory bank
func (o *FMC_SDBANK_Type) SetSDCR_NC(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x3)|value)
}
func (o *FMC_SDBANK_Type) GetSDCR_NC() uint32 {
	return volatile.LoadUint32(&o.SDCR.Reg) & 0x3
}
func (o *FMC_SDBANK_Type) SetSDCR_NR(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0xc)|value<<2)
}
func (o *FMC_SDBANK_Type) GetSDCR_NR() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0xc) >> 2
}
func (o *FMC_SDBANK_Type) SetSDCR_MWID(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x30)|value<<4)
}
func (o *FMC_SDBANK_Type) GetSDCR_MWID() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x30) >> 4
}
func (o *FMC_SDBANK_Type) SetSDCR_NB(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x40)|value<<6)
}
func (o *FMC_SDBANK_Type) GetSDCR_NB() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x40) >> 6
}
func (o *FMC_SDBANK_Type) SetSDCR_CAS(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x180)|value<<7)
}
func (o *FMC_SDBANK_Type) GetSDCR_CAS() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x180) >> 7
}
func (o *FMC_SDBANK_Type) SetSDCR_WP(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x200)|value<<9)
}
func (o *FMC_SDBANK_Type) GetSDCR_WP() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x200) >> 9
}
func (o *FMC_SDBANK_Type) SetSDCR_SDCLK(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0xc00)|value<<10)
}
func (o *FMC_SDBANK_Type) GetSDCR_SDCLK() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0xc00) >> 10
}
func (o *FMC_SDBANK_Type) SetSDCR_RBURST(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_SDBANK_Type) GetSDCR_RBURST() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x1000) >> 12
}
func (o *FMC_SDBANK_Type) SetSDCR_RPIPE(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x6000)|value<<13)
}
func (o *FMC_SDBANK_Type) GetSDCR_RPIPE() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x6000) >> 13
}

// FMC_SDBANK.SDTR: This register contains the timing parameters of each SDRAM bank
func (o *FMC_SDBANK_Type) SetSDTR_TMRD(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf)|value)
}
func (o *FMC_SDBANK_Type) GetSDTR_TMRD() uint32 {
	return volatile.LoadUint32(&o.SDTR.Reg) & 0xf
}
func (o *FMC_SDBANK_Type) SetSDTR_TXSR(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_SDBANK_Type) GetSDTR_TXSR() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf0) >> 4
}
func (o *FMC_SDBANK_Type) SetSDTR_TRAS(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf00)|value<<8)
}
func (o *FMC_SDBANK_Type) GetSDTR_TRAS() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf00) >> 8
}
func (o *FMC_SDBANK_Type) SetSDTR_TRC(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf000)|value<<12)
}
func (o *FMC_SDBANK_Type) GetSDTR_TRC() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf000) >> 12
}
func (o *FMC_SDBANK_Type) SetSDTR_TWR(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_SDBANK_Type) GetSDTR_TWR() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf0000) >> 16
}
func (o *FMC_SDBANK_Type) SetSDTR_TRP(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_SDBANK_Type) GetSDTR_TRP() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf00000) >> 20
}
func (o *FMC_SDBANK_Type) SetSDTR_TRCD(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_SDBANK_Type) GetSDTR_TRCD() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf000000) >> 24
}

// CEC
type CEC_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	TXDR volatile.Register32 // 0x8
	RXDR volatile.Register32 // 0xC
	ISR  volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
}

// CEC.CR: CEC control register
func (o *CEC_Type) SetCR_CECEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetCR_CECEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *CEC_Type) SetCR_TXSOM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetCR_TXSOM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetCR_TXEOM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetCR_TXEOM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// CEC.CFGR: This register is used to configure the HDMI-CEC controller. It is mandatory to write CEC_CFGR only when CECEN=0.
func (o *CEC_Type) SetCFGR_SFT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7)|value)
}
func (o *CEC_Type) GetCFGR_SFT() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x7
}
func (o *CEC_Type) SetCFGR_RXTOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetCFGR_RXTOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetCFGR_BRESTP(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetCFGR_BRESTP() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetCFGR_BREGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetCFGR_BREGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetCFGR_LBPEGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetCFGR_LBPEGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetCFGR_BRDNOGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetCFGR_BRDNOGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetCFGR_SFTOPT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetCFGR_SFTOPT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetCFGR_OAR(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7fff0000)|value<<16)
}
func (o *CEC_Type) GetCFGR_OAR() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7fff0000) >> 16
}
func (o *CEC_Type) SetCFGR_LSTN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *CEC_Type) GetCFGR_LSTN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}

// CEC.TXDR: CEC Tx data register
func (o *CEC_Type) SetTXDR_TXD(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *CEC_Type) GetTXDR_TXD() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// CEC.RXDR: CEC Rx Data Register
func (o *CEC_Type) SetRXDR_RXD(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *CEC_Type) GetRXDR_RXD() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// CEC.ISR: CEC Interrupt and Status Register
func (o *CEC_Type) SetISR_RXBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetISR_RXBR() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *CEC_Type) SetISR_RXEND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetISR_RXEND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetISR_RXOVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetISR_RXOVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetISR_BRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetISR_BRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetISR_SBPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetISR_SBPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetISR_LBPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetISR_LBPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetISR_RXACKE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetISR_RXACKE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetISR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetISR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetISR_TXBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetISR_TXBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetISR_TXEND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *CEC_Type) GetISR_TXEND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *CEC_Type) SetISR_TXUDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *CEC_Type) GetISR_TXUDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *CEC_Type) SetISR_TXERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *CEC_Type) GetISR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *CEC_Type) SetISR_TXACKE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *CEC_Type) GetISR_TXACKE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}

// CEC.IER: CEC interrupt enable register
func (o *CEC_Type) SetIER_RXBRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetIER_RXBRIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *CEC_Type) SetIER_RXENDIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetIER_RXENDIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetIER_RXOVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetIER_RXOVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetIER_BREIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetIER_BREIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetIER_SBPEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetIER_SBPEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetIER_LBPEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetIER_LBPEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetIER_RXACKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetIER_RXACKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetIER_ARBLSTIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetIER_ARBLSTIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetIER_TXBRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetIER_TXBRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetIER_TXENDIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *CEC_Type) GetIER_TXENDIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *CEC_Type) SetIER_TXUDRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *CEC_Type) GetIER_TXUDRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *CEC_Type) SetIER_TXERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *CEC_Type) GetIER_TXERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *CEC_Type) SetIER_TXACKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *CEC_Type) GetIER_TXACKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}

// HSEM
type HSEM_Type struct {
	R0    volatile.Register32 // 0x0
	R1    volatile.Register32 // 0x4
	R2    volatile.Register32 // 0x8
	R3    volatile.Register32 // 0xC
	R4    volatile.Register32 // 0x10
	R5    volatile.Register32 // 0x14
	R6    volatile.Register32 // 0x18
	R7    volatile.Register32 // 0x1C
	R8    volatile.Register32 // 0x20
	R9    volatile.Register32 // 0x24
	R10   volatile.Register32 // 0x28
	R11   volatile.Register32 // 0x2C
	R12   volatile.Register32 // 0x30
	R13   volatile.Register32 // 0x34
	R14   volatile.Register32 // 0x38
	R15   volatile.Register32 // 0x3C
	R16   volatile.Register32 // 0x40
	R17   volatile.Register32 // 0x44
	R18   volatile.Register32 // 0x48
	R19   volatile.Register32 // 0x4C
	R20   volatile.Register32 // 0x50
	R21   volatile.Register32 // 0x54
	R22   volatile.Register32 // 0x58
	R23   volatile.Register32 // 0x5C
	R24   volatile.Register32 // 0x60
	R25   volatile.Register32 // 0x64
	R26   volatile.Register32 // 0x68
	R27   volatile.Register32 // 0x6C
	R28   volatile.Register32 // 0x70
	R29   volatile.Register32 // 0x74
	R30   volatile.Register32 // 0x78
	R31   volatile.Register32 // 0x7C
	RLR0  volatile.Register32 // 0x80
	RLR1  volatile.Register32 // 0x84
	RLR2  volatile.Register32 // 0x88
	RLR3  volatile.Register32 // 0x8C
	RLR4  volatile.Register32 // 0x90
	RLR5  volatile.Register32 // 0x94
	RLR6  volatile.Register32 // 0x98
	RLR7  volatile.Register32 // 0x9C
	RLR8  volatile.Register32 // 0xA0
	RLR9  volatile.Register32 // 0xA4
	RLR10 volatile.Register32 // 0xA8
	RLR11 volatile.Register32 // 0xAC
	RLR12 volatile.Register32 // 0xB0
	RLR13 volatile.Register32 // 0xB4
	RLR14 volatile.Register32 // 0xB8
	RLR15 volatile.Register32 // 0xBC
	RLR16 volatile.Register32 // 0xC0
	RLR17 volatile.Register32 // 0xC4
	RLR18 volatile.Register32 // 0xC8
	RLR19 volatile.Register32 // 0xCC
	RLR20 volatile.Register32 // 0xD0
	RLR21 volatile.Register32 // 0xD4
	RLR22 volatile.Register32 // 0xD8
	RLR23 volatile.Register32 // 0xDC
	RLR24 volatile.Register32 // 0xE0
	RLR25 volatile.Register32 // 0xE4
	RLR26 volatile.Register32 // 0xE8
	RLR27 volatile.Register32 // 0xEC
	RLR28 volatile.Register32 // 0xF0
	RLR29 volatile.Register32 // 0xF4
	RLR30 volatile.Register32 // 0xF8
	RLR31 volatile.Register32 // 0xFC
	IER   volatile.Register32 // 0x100
	ICR   volatile.Register32 // 0x104
	ISR   volatile.Register32 // 0x108
	MISR  volatile.Register32 // 0x10C
	_     [48]byte
	CR    volatile.Register32 // 0x140
	KEYR  volatile.Register32 // 0x144
}

// HSEM.R0: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR0_PROCID(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR0_PROCID() uint32 {
	return volatile.LoadUint32(&o.R0.Reg) & 0xff
}
func (o *HSEM_Type) SetR0_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR0_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R0.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR0_LOCK(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR0_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R0.Reg) & 0x80000000) >> 31
}

// HSEM.R1: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR1_PROCID(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR1_PROCID() uint32 {
	return volatile.LoadUint32(&o.R1.Reg) & 0xff
}
func (o *HSEM_Type) SetR1_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR1_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R1.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR1_LOCK(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R1.Reg) & 0x80000000) >> 31
}

// HSEM.R2: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR2_PROCID(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR2_PROCID() uint32 {
	return volatile.LoadUint32(&o.R2.Reg) & 0xff
}
func (o *HSEM_Type) SetR2_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR2_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R2.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR2_LOCK(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R2.Reg) & 0x80000000) >> 31
}

// HSEM.R3: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR3_PROCID(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR3_PROCID() uint32 {
	return volatile.LoadUint32(&o.R3.Reg) & 0xff
}
func (o *HSEM_Type) SetR3_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR3_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R3.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR3_LOCK(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR3_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R3.Reg) & 0x80000000) >> 31
}

// HSEM.R4: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR4_PROCID(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR4_PROCID() uint32 {
	return volatile.LoadUint32(&o.R4.Reg) & 0xff
}
func (o *HSEM_Type) SetR4_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR4_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R4.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR4_LOCK(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR4_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R4.Reg) & 0x80000000) >> 31
}

// HSEM.R5: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR5_PROCID(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR5_PROCID() uint32 {
	return volatile.LoadUint32(&o.R5.Reg) & 0xff
}
func (o *HSEM_Type) SetR5_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR5_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R5.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR5_LOCK(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR5_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R5.Reg) & 0x80000000) >> 31
}

// HSEM.R6: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR6_PROCID(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR6_PROCID() uint32 {
	return volatile.LoadUint32(&o.R6.Reg) & 0xff
}
func (o *HSEM_Type) SetR6_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR6_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R6.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR6_LOCK(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR6_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R6.Reg) & 0x80000000) >> 31
}

// HSEM.R7: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR7_PROCID(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR7_PROCID() uint32 {
	return volatile.LoadUint32(&o.R7.Reg) & 0xff
}
func (o *HSEM_Type) SetR7_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR7_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R7.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR7_LOCK(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR7_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R7.Reg) & 0x80000000) >> 31
}

// HSEM.R8: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR8_PROCID(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR8_PROCID() uint32 {
	return volatile.LoadUint32(&o.R8.Reg) & 0xff
}
func (o *HSEM_Type) SetR8_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR8_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R8.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR8_LOCK(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR8_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R8.Reg) & 0x80000000) >> 31
}

// HSEM.R9: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR9_PROCID(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR9_PROCID() uint32 {
	return volatile.LoadUint32(&o.R9.Reg) & 0xff
}
func (o *HSEM_Type) SetR9_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR9_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R9.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR9_LOCK(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR9_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R9.Reg) & 0x80000000) >> 31
}

// HSEM.R10: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR10_PROCID(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR10_PROCID() uint32 {
	return volatile.LoadUint32(&o.R10.Reg) & 0xff
}
func (o *HSEM_Type) SetR10_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR10_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R10.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR10_LOCK(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR10_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R10.Reg) & 0x80000000) >> 31
}

// HSEM.R11: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR11_PROCID(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR11_PROCID() uint32 {
	return volatile.LoadUint32(&o.R11.Reg) & 0xff
}
func (o *HSEM_Type) SetR11_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR11_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R11.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR11_LOCK(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR11_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R11.Reg) & 0x80000000) >> 31
}

// HSEM.R12: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR12_PROCID(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR12_PROCID() uint32 {
	return volatile.LoadUint32(&o.R12.Reg) & 0xff
}
func (o *HSEM_Type) SetR12_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR12_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R12.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR12_LOCK(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR12_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R12.Reg) & 0x80000000) >> 31
}

// HSEM.R13: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR13_PROCID(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR13_PROCID() uint32 {
	return volatile.LoadUint32(&o.R13.Reg) & 0xff
}
func (o *HSEM_Type) SetR13_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR13_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R13.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR13_LOCK(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR13_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R13.Reg) & 0x80000000) >> 31
}

// HSEM.R14: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR14_PROCID(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR14_PROCID() uint32 {
	return volatile.LoadUint32(&o.R14.Reg) & 0xff
}
func (o *HSEM_Type) SetR14_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR14_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R14.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR14_LOCK(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR14_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R14.Reg) & 0x80000000) >> 31
}

// HSEM.R15: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR15_PROCID(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR15_PROCID() uint32 {
	return volatile.LoadUint32(&o.R15.Reg) & 0xff
}
func (o *HSEM_Type) SetR15_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR15_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R15.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR15_LOCK(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR15_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R15.Reg) & 0x80000000) >> 31
}

// HSEM.R16: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR16_PROCID(value uint32) {
	volatile.StoreUint32(&o.R16.Reg, volatile.LoadUint32(&o.R16.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR16_PROCID() uint32 {
	return volatile.LoadUint32(&o.R16.Reg) & 0xff
}
func (o *HSEM_Type) SetR16_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R16.Reg, volatile.LoadUint32(&o.R16.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR16_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R16.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR16_LOCK(value uint32) {
	volatile.StoreUint32(&o.R16.Reg, volatile.LoadUint32(&o.R16.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR16_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R16.Reg) & 0x80000000) >> 31
}

// HSEM.R17: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR17_PROCID(value uint32) {
	volatile.StoreUint32(&o.R17.Reg, volatile.LoadUint32(&o.R17.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR17_PROCID() uint32 {
	return volatile.LoadUint32(&o.R17.Reg) & 0xff
}
func (o *HSEM_Type) SetR17_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R17.Reg, volatile.LoadUint32(&o.R17.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR17_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R17.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR17_LOCK(value uint32) {
	volatile.StoreUint32(&o.R17.Reg, volatile.LoadUint32(&o.R17.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR17_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R17.Reg) & 0x80000000) >> 31
}

// HSEM.R18: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR18_PROCID(value uint32) {
	volatile.StoreUint32(&o.R18.Reg, volatile.LoadUint32(&o.R18.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR18_PROCID() uint32 {
	return volatile.LoadUint32(&o.R18.Reg) & 0xff
}
func (o *HSEM_Type) SetR18_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R18.Reg, volatile.LoadUint32(&o.R18.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR18_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R18.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR18_LOCK(value uint32) {
	volatile.StoreUint32(&o.R18.Reg, volatile.LoadUint32(&o.R18.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR18_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R18.Reg) & 0x80000000) >> 31
}

// HSEM.R19: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR19_PROCID(value uint32) {
	volatile.StoreUint32(&o.R19.Reg, volatile.LoadUint32(&o.R19.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR19_PROCID() uint32 {
	return volatile.LoadUint32(&o.R19.Reg) & 0xff
}
func (o *HSEM_Type) SetR19_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R19.Reg, volatile.LoadUint32(&o.R19.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR19_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R19.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR19_LOCK(value uint32) {
	volatile.StoreUint32(&o.R19.Reg, volatile.LoadUint32(&o.R19.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR19_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R19.Reg) & 0x80000000) >> 31
}

// HSEM.R20: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR20_PROCID(value uint32) {
	volatile.StoreUint32(&o.R20.Reg, volatile.LoadUint32(&o.R20.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR20_PROCID() uint32 {
	return volatile.LoadUint32(&o.R20.Reg) & 0xff
}
func (o *HSEM_Type) SetR20_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R20.Reg, volatile.LoadUint32(&o.R20.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR20_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R20.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR20_LOCK(value uint32) {
	volatile.StoreUint32(&o.R20.Reg, volatile.LoadUint32(&o.R20.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR20_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R20.Reg) & 0x80000000) >> 31
}

// HSEM.R21: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR21_PROCID(value uint32) {
	volatile.StoreUint32(&o.R21.Reg, volatile.LoadUint32(&o.R21.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR21_PROCID() uint32 {
	return volatile.LoadUint32(&o.R21.Reg) & 0xff
}
func (o *HSEM_Type) SetR21_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R21.Reg, volatile.LoadUint32(&o.R21.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR21_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R21.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR21_LOCK(value uint32) {
	volatile.StoreUint32(&o.R21.Reg, volatile.LoadUint32(&o.R21.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR21_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R21.Reg) & 0x80000000) >> 31
}

// HSEM.R22: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR22_PROCID(value uint32) {
	volatile.StoreUint32(&o.R22.Reg, volatile.LoadUint32(&o.R22.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR22_PROCID() uint32 {
	return volatile.LoadUint32(&o.R22.Reg) & 0xff
}
func (o *HSEM_Type) SetR22_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R22.Reg, volatile.LoadUint32(&o.R22.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR22_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R22.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR22_LOCK(value uint32) {
	volatile.StoreUint32(&o.R22.Reg, volatile.LoadUint32(&o.R22.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR22_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R22.Reg) & 0x80000000) >> 31
}

// HSEM.R23: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR23_PROCID(value uint32) {
	volatile.StoreUint32(&o.R23.Reg, volatile.LoadUint32(&o.R23.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR23_PROCID() uint32 {
	return volatile.LoadUint32(&o.R23.Reg) & 0xff
}
func (o *HSEM_Type) SetR23_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R23.Reg, volatile.LoadUint32(&o.R23.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR23_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R23.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR23_LOCK(value uint32) {
	volatile.StoreUint32(&o.R23.Reg, volatile.LoadUint32(&o.R23.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR23_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R23.Reg) & 0x80000000) >> 31
}

// HSEM.R24: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR24_PROCID(value uint32) {
	volatile.StoreUint32(&o.R24.Reg, volatile.LoadUint32(&o.R24.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR24_PROCID() uint32 {
	return volatile.LoadUint32(&o.R24.Reg) & 0xff
}
func (o *HSEM_Type) SetR24_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R24.Reg, volatile.LoadUint32(&o.R24.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR24_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R24.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR24_LOCK(value uint32) {
	volatile.StoreUint32(&o.R24.Reg, volatile.LoadUint32(&o.R24.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR24_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R24.Reg) & 0x80000000) >> 31
}

// HSEM.R25: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR25_PROCID(value uint32) {
	volatile.StoreUint32(&o.R25.Reg, volatile.LoadUint32(&o.R25.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR25_PROCID() uint32 {
	return volatile.LoadUint32(&o.R25.Reg) & 0xff
}
func (o *HSEM_Type) SetR25_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R25.Reg, volatile.LoadUint32(&o.R25.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR25_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R25.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR25_LOCK(value uint32) {
	volatile.StoreUint32(&o.R25.Reg, volatile.LoadUint32(&o.R25.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR25_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R25.Reg) & 0x80000000) >> 31
}

// HSEM.R26: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR26_PROCID(value uint32) {
	volatile.StoreUint32(&o.R26.Reg, volatile.LoadUint32(&o.R26.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR26_PROCID() uint32 {
	return volatile.LoadUint32(&o.R26.Reg) & 0xff
}
func (o *HSEM_Type) SetR26_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R26.Reg, volatile.LoadUint32(&o.R26.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR26_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R26.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR26_LOCK(value uint32) {
	volatile.StoreUint32(&o.R26.Reg, volatile.LoadUint32(&o.R26.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR26_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R26.Reg) & 0x80000000) >> 31
}

// HSEM.R27: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR27_PROCID(value uint32) {
	volatile.StoreUint32(&o.R27.Reg, volatile.LoadUint32(&o.R27.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR27_PROCID() uint32 {
	return volatile.LoadUint32(&o.R27.Reg) & 0xff
}
func (o *HSEM_Type) SetR27_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R27.Reg, volatile.LoadUint32(&o.R27.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR27_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R27.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR27_LOCK(value uint32) {
	volatile.StoreUint32(&o.R27.Reg, volatile.LoadUint32(&o.R27.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR27_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R27.Reg) & 0x80000000) >> 31
}

// HSEM.R28: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR28_PROCID(value uint32) {
	volatile.StoreUint32(&o.R28.Reg, volatile.LoadUint32(&o.R28.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR28_PROCID() uint32 {
	return volatile.LoadUint32(&o.R28.Reg) & 0xff
}
func (o *HSEM_Type) SetR28_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R28.Reg, volatile.LoadUint32(&o.R28.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR28_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R28.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR28_LOCK(value uint32) {
	volatile.StoreUint32(&o.R28.Reg, volatile.LoadUint32(&o.R28.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR28_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R28.Reg) & 0x80000000) >> 31
}

// HSEM.R29: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR29_PROCID(value uint32) {
	volatile.StoreUint32(&o.R29.Reg, volatile.LoadUint32(&o.R29.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR29_PROCID() uint32 {
	return volatile.LoadUint32(&o.R29.Reg) & 0xff
}
func (o *HSEM_Type) SetR29_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R29.Reg, volatile.LoadUint32(&o.R29.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR29_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R29.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR29_LOCK(value uint32) {
	volatile.StoreUint32(&o.R29.Reg, volatile.LoadUint32(&o.R29.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR29_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R29.Reg) & 0x80000000) >> 31
}

// HSEM.R30: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR30_PROCID(value uint32) {
	volatile.StoreUint32(&o.R30.Reg, volatile.LoadUint32(&o.R30.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR30_PROCID() uint32 {
	return volatile.LoadUint32(&o.R30.Reg) & 0xff
}
func (o *HSEM_Type) SetR30_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R30.Reg, volatile.LoadUint32(&o.R30.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR30_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R30.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR30_LOCK(value uint32) {
	volatile.StoreUint32(&o.R30.Reg, volatile.LoadUint32(&o.R30.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR30_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R30.Reg) & 0x80000000) >> 31
}

// HSEM.R31: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR31_PROCID(value uint32) {
	volatile.StoreUint32(&o.R31.Reg, volatile.LoadUint32(&o.R31.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR31_PROCID() uint32 {
	return volatile.LoadUint32(&o.R31.Reg) & 0xff
}
func (o *HSEM_Type) SetR31_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R31.Reg, volatile.LoadUint32(&o.R31.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR31_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R31.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR31_LOCK(value uint32) {
	volatile.StoreUint32(&o.R31.Reg, volatile.LoadUint32(&o.R31.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR31_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R31.Reg) & 0x80000000) >> 31
}

// HSEM.RLR0: HSEM Read lock register
func (o *HSEM_Type) SetRLR0_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR0_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR0.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR0_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR0_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR0.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR0_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR0_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR0.Reg) & 0x80000000) >> 31
}

// HSEM.RLR1: HSEM Read lock register
func (o *HSEM_Type) SetRLR1_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR1_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR1.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR1_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR1_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR1.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR1_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR1.Reg) & 0x80000000) >> 31
}

// HSEM.RLR2: HSEM Read lock register
func (o *HSEM_Type) SetRLR2_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR2_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR2.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR2_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR2_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR2.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR2_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR2.Reg) & 0x80000000) >> 31
}

// HSEM.RLR3: HSEM Read lock register
func (o *HSEM_Type) SetRLR3_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR3_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR3.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR3_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR3_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR3.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR3_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR3_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR3.Reg) & 0x80000000) >> 31
}

// HSEM.RLR4: HSEM Read lock register
func (o *HSEM_Type) SetRLR4_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR4_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR4.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR4_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR4_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR4.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR4_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR4_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR4.Reg) & 0x80000000) >> 31
}

// HSEM.RLR5: HSEM Read lock register
func (o *HSEM_Type) SetRLR5_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR5_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR5.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR5_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR5_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR5.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR5_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR5_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR5.Reg) & 0x80000000) >> 31
}

// HSEM.RLR6: HSEM Read lock register
func (o *HSEM_Type) SetRLR6_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR6_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR6.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR6_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR6_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR6.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR6_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR6_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR6.Reg) & 0x80000000) >> 31
}

// HSEM.RLR7: HSEM Read lock register
func (o *HSEM_Type) SetRLR7_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR7_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR7.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR7_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR7_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR7.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR7_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR7_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR7.Reg) & 0x80000000) >> 31
}

// HSEM.RLR8: HSEM Read lock register
func (o *HSEM_Type) SetRLR8_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR8_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR8.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR8_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR8_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR8.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR8_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR8_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR8.Reg) & 0x80000000) >> 31
}

// HSEM.RLR9: HSEM Read lock register
func (o *HSEM_Type) SetRLR9_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR9_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR9.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR9_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR9_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR9.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR9_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR9_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR9.Reg) & 0x80000000) >> 31
}

// HSEM.RLR10: HSEM Read lock register
func (o *HSEM_Type) SetRLR10_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR10_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR10.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR10_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR10_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR10.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR10_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR10_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR10.Reg) & 0x80000000) >> 31
}

// HSEM.RLR11: HSEM Read lock register
func (o *HSEM_Type) SetRLR11_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR11_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR11.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR11_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR11_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR11.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR11_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR11_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR11.Reg) & 0x80000000) >> 31
}

// HSEM.RLR12: HSEM Read lock register
func (o *HSEM_Type) SetRLR12_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR12_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR12.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR12_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR12_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR12.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR12_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR12_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR12.Reg) & 0x80000000) >> 31
}

// HSEM.RLR13: HSEM Read lock register
func (o *HSEM_Type) SetRLR13_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR13_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR13.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR13_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR13_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR13.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR13_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR13_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR13.Reg) & 0x80000000) >> 31
}

// HSEM.RLR14: HSEM Read lock register
func (o *HSEM_Type) SetRLR14_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR14_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR14.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR14_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR14_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR14.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR14_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR14_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR14.Reg) & 0x80000000) >> 31
}

// HSEM.RLR15: HSEM Read lock register
func (o *HSEM_Type) SetRLR15_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR15_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR15.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR15_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR15_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR15.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR15_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR15_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR15.Reg) & 0x80000000) >> 31
}

// HSEM.RLR16: HSEM Read lock register
func (o *HSEM_Type) SetRLR16_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR16.Reg, volatile.LoadUint32(&o.RLR16.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR16_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR16.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR16_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR16.Reg, volatile.LoadUint32(&o.RLR16.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR16_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR16.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR16_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR16.Reg, volatile.LoadUint32(&o.RLR16.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR16_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR16.Reg) & 0x80000000) >> 31
}

// HSEM.RLR17: HSEM Read lock register
func (o *HSEM_Type) SetRLR17_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR17.Reg, volatile.LoadUint32(&o.RLR17.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR17_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR17.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR17_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR17.Reg, volatile.LoadUint32(&o.RLR17.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR17_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR17.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR17_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR17.Reg, volatile.LoadUint32(&o.RLR17.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR17_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR17.Reg) & 0x80000000) >> 31
}

// HSEM.RLR18: HSEM Read lock register
func (o *HSEM_Type) SetRLR18_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR18.Reg, volatile.LoadUint32(&o.RLR18.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR18_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR18.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR18_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR18.Reg, volatile.LoadUint32(&o.RLR18.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR18_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR18.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR18_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR18.Reg, volatile.LoadUint32(&o.RLR18.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR18_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR18.Reg) & 0x80000000) >> 31
}

// HSEM.RLR19: HSEM Read lock register
func (o *HSEM_Type) SetRLR19_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR19.Reg, volatile.LoadUint32(&o.RLR19.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR19_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR19.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR19_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR19.Reg, volatile.LoadUint32(&o.RLR19.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR19_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR19.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR19_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR19.Reg, volatile.LoadUint32(&o.RLR19.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR19_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR19.Reg) & 0x80000000) >> 31
}

// HSEM.RLR20: HSEM Read lock register
func (o *HSEM_Type) SetRLR20_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR20.Reg, volatile.LoadUint32(&o.RLR20.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR20_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR20.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR20_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR20.Reg, volatile.LoadUint32(&o.RLR20.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR20_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR20.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR20_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR20.Reg, volatile.LoadUint32(&o.RLR20.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR20_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR20.Reg) & 0x80000000) >> 31
}

// HSEM.RLR21: HSEM Read lock register
func (o *HSEM_Type) SetRLR21_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR21.Reg, volatile.LoadUint32(&o.RLR21.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR21_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR21.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR21_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR21.Reg, volatile.LoadUint32(&o.RLR21.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR21_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR21.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR21_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR21.Reg, volatile.LoadUint32(&o.RLR21.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR21_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR21.Reg) & 0x80000000) >> 31
}

// HSEM.RLR22: HSEM Read lock register
func (o *HSEM_Type) SetRLR22_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR22.Reg, volatile.LoadUint32(&o.RLR22.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR22_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR22.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR22_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR22.Reg, volatile.LoadUint32(&o.RLR22.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR22_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR22.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR22_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR22.Reg, volatile.LoadUint32(&o.RLR22.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR22_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR22.Reg) & 0x80000000) >> 31
}

// HSEM.RLR23: HSEM Read lock register
func (o *HSEM_Type) SetRLR23_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR23.Reg, volatile.LoadUint32(&o.RLR23.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR23_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR23.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR23_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR23.Reg, volatile.LoadUint32(&o.RLR23.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR23_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR23.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR23_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR23.Reg, volatile.LoadUint32(&o.RLR23.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR23_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR23.Reg) & 0x80000000) >> 31
}

// HSEM.RLR24: HSEM Read lock register
func (o *HSEM_Type) SetRLR24_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR24.Reg, volatile.LoadUint32(&o.RLR24.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR24_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR24.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR24_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR24.Reg, volatile.LoadUint32(&o.RLR24.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR24_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR24.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR24_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR24.Reg, volatile.LoadUint32(&o.RLR24.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR24_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR24.Reg) & 0x80000000) >> 31
}

// HSEM.RLR25: HSEM Read lock register
func (o *HSEM_Type) SetRLR25_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR25.Reg, volatile.LoadUint32(&o.RLR25.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR25_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR25.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR25_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR25.Reg, volatile.LoadUint32(&o.RLR25.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR25_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR25.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR25_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR25.Reg, volatile.LoadUint32(&o.RLR25.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR25_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR25.Reg) & 0x80000000) >> 31
}

// HSEM.RLR26: HSEM Read lock register
func (o *HSEM_Type) SetRLR26_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR26.Reg, volatile.LoadUint32(&o.RLR26.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR26_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR26.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR26_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR26.Reg, volatile.LoadUint32(&o.RLR26.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR26_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR26.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR26_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR26.Reg, volatile.LoadUint32(&o.RLR26.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR26_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR26.Reg) & 0x80000000) >> 31
}

// HSEM.RLR27: HSEM Read lock register
func (o *HSEM_Type) SetRLR27_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR27.Reg, volatile.LoadUint32(&o.RLR27.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR27_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR27.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR27_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR27.Reg, volatile.LoadUint32(&o.RLR27.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR27_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR27.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR27_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR27.Reg, volatile.LoadUint32(&o.RLR27.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR27_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR27.Reg) & 0x80000000) >> 31
}

// HSEM.RLR28: HSEM Read lock register
func (o *HSEM_Type) SetRLR28_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR28.Reg, volatile.LoadUint32(&o.RLR28.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR28_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR28.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR28_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR28.Reg, volatile.LoadUint32(&o.RLR28.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR28_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR28.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR28_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR28.Reg, volatile.LoadUint32(&o.RLR28.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR28_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR28.Reg) & 0x80000000) >> 31
}

// HSEM.RLR29: HSEM Read lock register
func (o *HSEM_Type) SetRLR29_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR29.Reg, volatile.LoadUint32(&o.RLR29.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR29_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR29.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR29_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR29.Reg, volatile.LoadUint32(&o.RLR29.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR29_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR29.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR29_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR29.Reg, volatile.LoadUint32(&o.RLR29.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR29_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR29.Reg) & 0x80000000) >> 31
}

// HSEM.RLR30: HSEM Read lock register
func (o *HSEM_Type) SetRLR30_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR30.Reg, volatile.LoadUint32(&o.RLR30.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR30_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR30.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR30_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR30.Reg, volatile.LoadUint32(&o.RLR30.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR30_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR30.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR30_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR30.Reg, volatile.LoadUint32(&o.RLR30.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR30_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR30.Reg) & 0x80000000) >> 31
}

// HSEM.RLR31: HSEM Read lock register
func (o *HSEM_Type) SetRLR31_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR31.Reg, volatile.LoadUint32(&o.RLR31.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR31_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR31.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR31_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR31.Reg, volatile.LoadUint32(&o.RLR31.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR31_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR31.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR31_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR31.Reg, volatile.LoadUint32(&o.RLR31.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR31_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR31.Reg) & 0x80000000) >> 31
}

// HSEM.IER: HSEM Interrupt enable register
func (o *HSEM_Type) SetIER_ISEM0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetIER_ISEM0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *HSEM_Type) SetIER_ISEM1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetIER_ISEM1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetIER_ISEM2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetIER_ISEM2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetIER_ISEM3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetIER_ISEM3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetIER_ISEM4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetIER_ISEM4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetIER_ISEM5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetIER_ISEM5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetIER_ISEM6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetIER_ISEM6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetIER_ISEM7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetIER_ISEM7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetIER_ISEM8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetIER_ISEM8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetIER_ISEM9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetIER_ISEM9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetIER_ISEM10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetIER_ISEM10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetIER_ISEM11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetIER_ISEM11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetIER_ISEM12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetIER_ISEM12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetIER_ISEM13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetIER_ISEM13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetIER_ISEM14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetIER_ISEM14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetIER_ISEM15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetIER_ISEM15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *HSEM_Type) SetIER_ISEM16(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *HSEM_Type) GetIER_ISEM16() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *HSEM_Type) SetIER_ISEM17(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *HSEM_Type) GetIER_ISEM17() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *HSEM_Type) SetIER_ISEM18(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *HSEM_Type) GetIER_ISEM18() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *HSEM_Type) SetIER_ISEM19(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *HSEM_Type) GetIER_ISEM19() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *HSEM_Type) SetIER_ISEM20(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *HSEM_Type) GetIER_ISEM20() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *HSEM_Type) SetIER_ISEM21(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *HSEM_Type) GetIER_ISEM21() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *HSEM_Type) SetIER_ISEM22(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *HSEM_Type) GetIER_ISEM22() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *HSEM_Type) SetIER_ISEM23(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *HSEM_Type) GetIER_ISEM23() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *HSEM_Type) SetIER_ISEM24(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *HSEM_Type) GetIER_ISEM24() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *HSEM_Type) SetIER_ISEM25(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *HSEM_Type) GetIER_ISEM25() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *HSEM_Type) SetIER_ISEM26(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *HSEM_Type) GetIER_ISEM26() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *HSEM_Type) SetIER_ISEM27(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *HSEM_Type) GetIER_ISEM27() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *HSEM_Type) SetIER_ISEM28(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *HSEM_Type) GetIER_ISEM28() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *HSEM_Type) SetIER_ISEM29(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *HSEM_Type) GetIER_ISEM29() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *HSEM_Type) SetIER_ISEM30(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *HSEM_Type) GetIER_ISEM30() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *HSEM_Type) SetIER_ISEM31(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetIER_ISEM31() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// HSEM.ICR: HSEM Interrupt clear register
func (o *HSEM_Type) SetICR_ISEM0(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetICR_ISEM0() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *HSEM_Type) SetICR_ISEM1(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetICR_ISEM1() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetICR_ISEM2(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetICR_ISEM2() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetICR_ISEM3(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetICR_ISEM3() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetICR_ISEM4(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetICR_ISEM4() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetICR_ISEM5(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetICR_ISEM5() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetICR_ISEM6(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetICR_ISEM6() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetICR_ISEM7(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetICR_ISEM7() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetICR_ISEM8(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetICR_ISEM8() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetICR_ISEM9(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetICR_ISEM9() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetICR_ISEM10(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetICR_ISEM10() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetICR_ISEM11(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetICR_ISEM11() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetICR_ISEM12(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetICR_ISEM12() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetICR_ISEM13(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetICR_ISEM13() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetICR_ISEM14(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetICR_ISEM14() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetICR_ISEM15(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetICR_ISEM15() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8000) >> 15
}
func (o *HSEM_Type) SetICR_ISEM16(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10000)|value<<16)
}
func (o *HSEM_Type) GetICR_ISEM16() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10000) >> 16
}
func (o *HSEM_Type) SetICR_ISEM17(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *HSEM_Type) GetICR_ISEM17() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *HSEM_Type) SetICR_ISEM18(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40000)|value<<18)
}
func (o *HSEM_Type) GetICR_ISEM18() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40000) >> 18
}
func (o *HSEM_Type) SetICR_ISEM19(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80000)|value<<19)
}
func (o *HSEM_Type) GetICR_ISEM19() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80000) >> 19
}
func (o *HSEM_Type) SetICR_ISEM20(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *HSEM_Type) GetICR_ISEM20() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}
func (o *HSEM_Type) SetICR_ISEM21(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200000)|value<<21)
}
func (o *HSEM_Type) GetICR_ISEM21() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200000) >> 21
}
func (o *HSEM_Type) SetICR_ISEM22(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400000)|value<<22)
}
func (o *HSEM_Type) GetICR_ISEM22() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400000) >> 22
}
func (o *HSEM_Type) SetICR_ISEM23(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800000)|value<<23)
}
func (o *HSEM_Type) GetICR_ISEM23() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800000) >> 23
}
func (o *HSEM_Type) SetICR_ISEM24(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSEM_Type) GetICR_ISEM24() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000000) >> 24
}
func (o *HSEM_Type) SetICR_ISEM25(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSEM_Type) GetICR_ISEM25() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000000) >> 25
}
func (o *HSEM_Type) SetICR_ISEM26(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSEM_Type) GetICR_ISEM26() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4000000) >> 26
}
func (o *HSEM_Type) SetICR_ISEM27(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSEM_Type) GetICR_ISEM27() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8000000) >> 27
}
func (o *HSEM_Type) SetICR_ISEM28(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSEM_Type) GetICR_ISEM28() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10000000) >> 28
}
func (o *HSEM_Type) SetICR_ISEM29(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSEM_Type) GetICR_ISEM29() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000000) >> 29
}
func (o *HSEM_Type) SetICR_ISEM30(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSEM_Type) GetICR_ISEM30() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40000000) >> 30
}
func (o *HSEM_Type) SetICR_ISEM31(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetICR_ISEM31() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80000000) >> 31
}

// HSEM.ISR: HSEM Interrupt status register
func (o *HSEM_Type) SetISR_ISEM0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetISR_ISEM0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *HSEM_Type) SetISR_ISEM1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetISR_ISEM1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetISR_ISEM2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetISR_ISEM2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetISR_ISEM3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetISR_ISEM3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetISR_ISEM4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetISR_ISEM4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetISR_ISEM5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetISR_ISEM5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetISR_ISEM6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetISR_ISEM6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetISR_ISEM7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetISR_ISEM7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetISR_ISEM8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetISR_ISEM8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetISR_ISEM9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetISR_ISEM9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetISR_ISEM10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetISR_ISEM10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetISR_ISEM11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetISR_ISEM11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetISR_ISEM12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetISR_ISEM12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetISR_ISEM13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetISR_ISEM13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetISR_ISEM14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetISR_ISEM14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetISR_ISEM15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetISR_ISEM15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *HSEM_Type) SetISR_ISEM16(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *HSEM_Type) GetISR_ISEM16() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *HSEM_Type) SetISR_ISEM17(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *HSEM_Type) GetISR_ISEM17() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *HSEM_Type) SetISR_ISEM18(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *HSEM_Type) GetISR_ISEM18() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *HSEM_Type) SetISR_ISEM19(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *HSEM_Type) GetISR_ISEM19() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *HSEM_Type) SetISR_ISEM20(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *HSEM_Type) GetISR_ISEM20() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *HSEM_Type) SetISR_ISEM21(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *HSEM_Type) GetISR_ISEM21() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *HSEM_Type) SetISR_ISEM22(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *HSEM_Type) GetISR_ISEM22() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *HSEM_Type) SetISR_ISEM23(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *HSEM_Type) GetISR_ISEM23() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *HSEM_Type) SetISR_ISEM24(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSEM_Type) GetISR_ISEM24() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *HSEM_Type) SetISR_ISEM25(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSEM_Type) GetISR_ISEM25() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *HSEM_Type) SetISR_ISEM26(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSEM_Type) GetISR_ISEM26() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *HSEM_Type) SetISR_ISEM27(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSEM_Type) GetISR_ISEM27() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *HSEM_Type) SetISR_ISEM28(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSEM_Type) GetISR_ISEM28() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}
func (o *HSEM_Type) SetISR_ISEM29(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSEM_Type) GetISR_ISEM29() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *HSEM_Type) SetISR_ISEM30(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSEM_Type) GetISR_ISEM30() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *HSEM_Type) SetISR_ISEM31(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetISR_ISEM31() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// HSEM.MISR: HSEM Masked interrupt status register
func (o *HSEM_Type) SetMISR_ISEM0(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetMISR_ISEM0() uint32 {
	return volatile.LoadUint32(&o.MISR.Reg) & 0x1
}
func (o *HSEM_Type) SetMISR_ISEM1(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetMISR_ISEM1() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetMISR_ISEM2(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetMISR_ISEM2() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetMISR_ISEM3(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetMISR_ISEM3() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetMISR_ISEM4(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetMISR_ISEM4() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetMISR_ISEM5(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetMISR_ISEM5() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetMISR_ISEM6(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetMISR_ISEM6() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetMISR_ISEM7(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetMISR_ISEM7() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetMISR_ISEM8(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetMISR_ISEM8() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetMISR_ISEM9(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetMISR_ISEM9() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetMISR_ISEM10(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetMISR_ISEM10() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetMISR_ISEM11(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetMISR_ISEM11() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetMISR_ISEM12(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetMISR_ISEM12() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetMISR_ISEM13(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetMISR_ISEM13() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetMISR_ISEM14(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetMISR_ISEM14() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetMISR_ISEM15(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetMISR_ISEM15() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x8000) >> 15
}
func (o *HSEM_Type) SetMISR_ISEM16(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x10000)|value<<16)
}
func (o *HSEM_Type) GetMISR_ISEM16() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x10000) >> 16
}
func (o *HSEM_Type) SetMISR_ISEM17(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x20000)|value<<17)
}
func (o *HSEM_Type) GetMISR_ISEM17() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x20000) >> 17
}
func (o *HSEM_Type) SetMISR_ISEM18(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x40000)|value<<18)
}
func (o *HSEM_Type) GetMISR_ISEM18() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x40000) >> 18
}
func (o *HSEM_Type) SetMISR_ISEM19(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x80000)|value<<19)
}
func (o *HSEM_Type) GetMISR_ISEM19() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x80000) >> 19
}
func (o *HSEM_Type) SetMISR_ISEM20(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x100000)|value<<20)
}
func (o *HSEM_Type) GetMISR_ISEM20() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x100000) >> 20
}
func (o *HSEM_Type) SetMISR_ISEM21(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x200000)|value<<21)
}
func (o *HSEM_Type) GetMISR_ISEM21() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x200000) >> 21
}
func (o *HSEM_Type) SetMISR_ISEM22(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x400000)|value<<22)
}
func (o *HSEM_Type) GetMISR_ISEM22() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x400000) >> 22
}
func (o *HSEM_Type) SetMISR_ISEM23(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x800000)|value<<23)
}
func (o *HSEM_Type) GetMISR_ISEM23() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x800000) >> 23
}
func (o *HSEM_Type) SetMISR_ISEM24(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSEM_Type) GetMISR_ISEM24() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x1000000) >> 24
}
func (o *HSEM_Type) SetMISR_ISEM25(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSEM_Type) GetMISR_ISEM25() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2000000) >> 25
}
func (o *HSEM_Type) SetMISR_ISEM26(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSEM_Type) GetMISR_ISEM26() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x4000000) >> 26
}
func (o *HSEM_Type) SetMISR_ISEM27(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSEM_Type) GetMISR_ISEM27() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x8000000) >> 27
}
func (o *HSEM_Type) SetMISR_ISEM28(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSEM_Type) GetMISR_ISEM28() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x10000000) >> 28
}
func (o *HSEM_Type) SetMISR_ISEM29(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSEM_Type) GetMISR_ISEM29() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x20000000) >> 29
}
func (o *HSEM_Type) SetMISR_ISEM30(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSEM_Type) GetMISR_ISEM30() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x40000000) >> 30
}
func (o *HSEM_Type) SetMISR_ISEM31(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetMISR_ISEM31() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x80000000) >> 31
}

// HSEM.CR: HSEM Clear register
func (o *HSEM_Type) SetCR_MASTERID(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetCR_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSEM_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xffff0000) >> 16
}

// HSEM.KEYR: HSEM Interrupt clear register
func (o *HSEM_Type) SetKEYR_KEY(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, volatile.LoadUint32(&o.KEYR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSEM_Type) GetKEYR_KEY() uint32 {
	return (volatile.LoadUint32(&o.KEYR.Reg) & 0xffff0000) >> 16
}

// I2C
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Access: No wait states, except if a write access occurs while a write access to this register is ongoing. In this case, wait states are inserted in the second write access until the previous one is completed. The latency of the second write access can be up to 2 x PCLK1 + 6 x I2CCLK.
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetCR1_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Access: No wait states, except if a write access occurs while a write access to this register is ongoing. In this case, wait states are inserted in the second write access until the previous one is completed. The latency of the second write access can be up to 2 x PCLK1 + 6 x I2CCLK.
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}

// I2C.OAR1: Access: No wait states, except if a write access occurs while a write access to this register is ongoing. In this case, wait states are inserted in the second write access until the previous one is completed. The latency of the second write access can be up to 2 x PCLK1 + 6 x I2CCLK.
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}

// I2C.OAR2: Access: No wait states, except if a write access occurs while a write access to this register is ongoing. In this case, wait states are inserted in the second write access until the previous one is completed. The latency of the second write access can be up to 2 x PCLK1 + 6 x I2CCLK.
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Access: No wait states
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Access: No wait states, except if a write access occurs while a write access to this register is ongoing. In this case, wait states are inserted in the second write access until the previous one is completed. The latency of the second write access can be up to 2 x PCLK1 + 6 x I2CCLK.
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Access: No wait states
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}

// I2C.ICR: Access: No wait states
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}

// I2C.PECR: Access: No wait states
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Access: No wait states
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Access: No wait states
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// GPIO
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}

// GPIO.LCKR: This register is used to lock the configuration of the port bits when a correct write sequence is applied to bit 16 (LCKK). The value of bits [15:0] is used to lock the configuration of the GPIO. During the write sequence, the value of LCKR[15:0] must not change. When the LOCK sequence has been applied on a port bit, the value of this port bit can no longer be modified until the next MCU reset or peripheral reset.A specific write sequence is used to write to the GPIOx_LCKR register. Only word access (32-bit long) is allowed during this locking sequence.Each lock bit freezes a specific configuration register (control and alternate function registers).
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFR0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFR0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}
func (o *GPIO_Type) SetAFRL_AFR1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFR1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFR2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFR2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFR3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFR3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFR4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFR4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFR5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFR5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFR6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFR6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFR7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFR7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFR8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFR8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}
func (o *GPIO_Type) SetAFRH_AFR9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFR9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFR10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFR10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFR11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFR11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFR12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFR12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFR13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFR13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFR14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFR14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFR15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFR15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}

// JPEG
type JPEG_Type struct {
	CONFR0  volatile.Register32 // 0x0
	CONFR1  volatile.Register32 // 0x4
	CONFR2  volatile.Register32 // 0x8
	CONFR3  volatile.Register32 // 0xC
	CONFRN1 volatile.Register32 // 0x10
	CONFRN2 volatile.Register32 // 0x14
	CONFRN3 volatile.Register32 // 0x18
	CONFRN4 volatile.Register32 // 0x1C
	_       [16]byte
	CR      volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
	CFR     volatile.Register32 // 0x38
	_       [4]byte
	DIR     volatile.Register32 // 0x40
	DOR     volatile.Register32 // 0x44
}

// JPEG.CONFR0: JPEG codec control register
func (o *JPEG_Type) SetCONFR0_START(value uint32) {
	volatile.StoreUint32(&o.CONFR0.Reg, volatile.LoadUint32(&o.CONFR0.Reg)&^(0x1)|value)
}
func (o *JPEG_Type) GetCONFR0_START() uint32 {
	return volatile.LoadUint32(&o.CONFR0.Reg) & 0x1
}

// JPEG.CONFR1: JPEG codec configuration register 1
func (o *JPEG_Type) SetCONFR1_NF(value uint32) {
	volatile.StoreUint32(&o.CONFR1.Reg, volatile.LoadUint32(&o.CONFR1.Reg)&^(0x3)|value)
}
func (o *JPEG_Type) GetCONFR1_NF() uint32 {
	return volatile.LoadUint32(&o.CONFR1.Reg) & 0x3
}
func (o *JPEG_Type) SetCONFR1_DE(value uint32) {
	volatile.StoreUint32(&o.CONFR1.Reg, volatile.LoadUint32(&o.CONFR1.Reg)&^(0x8)|value<<3)
}
func (o *JPEG_Type) GetCONFR1_DE() uint32 {
	return (volatile.LoadUint32(&o.CONFR1.Reg) & 0x8) >> 3
}
func (o *JPEG_Type) SetCONFR1_COLORSPACE(value uint32) {
	volatile.StoreUint32(&o.CONFR1.Reg, volatile.LoadUint32(&o.CONFR1.Reg)&^(0x30)|value<<4)
}
func (o *JPEG_Type) GetCONFR1_COLORSPACE() uint32 {
	return (volatile.LoadUint32(&o.CONFR1.Reg) & 0x30) >> 4
}
func (o *JPEG_Type) SetCONFR1_NS(value uint32) {
	volatile.StoreUint32(&o.CONFR1.Reg, volatile.LoadUint32(&o.CONFR1.Reg)&^(0xc0)|value<<6)
}
func (o *JPEG_Type) GetCONFR1_NS() uint32 {
	return (volatile.LoadUint32(&o.CONFR1.Reg) & 0xc0) >> 6
}
func (o *JPEG_Type) SetCONFR1_HDR(value uint32) {
	volatile.StoreUint32(&o.CONFR1.Reg, volatile.LoadUint32(&o.CONFR1.Reg)&^(0x100)|value<<8)
}
func (o *JPEG_Type) GetCONFR1_HDR() uint32 {
	return (volatile.LoadUint32(&o.CONFR1.Reg) & 0x100) >> 8
}
func (o *JPEG_Type) SetCONFR1_YSIZE(value uint32) {
	volatile.StoreUint32(&o.CONFR1.Reg, volatile.LoadUint32(&o.CONFR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *JPEG_Type) GetCONFR1_YSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONFR1.Reg) & 0xffff0000) >> 16
}

// JPEG.CONFR2: JPEG codec configuration register 2
func (o *JPEG_Type) SetCONFR2_NMCU(value uint32) {
	volatile.StoreUint32(&o.CONFR2.Reg, volatile.LoadUint32(&o.CONFR2.Reg)&^(0x3ffffff)|value)
}
func (o *JPEG_Type) GetCONFR2_NMCU() uint32 {
	return volatile.LoadUint32(&o.CONFR2.Reg) & 0x3ffffff
}

// JPEG.CONFR3: JPEG codec configuration register 3
func (o *JPEG_Type) SetCONFR3_XSIZE(value uint32) {
	volatile.StoreUint32(&o.CONFR3.Reg, volatile.LoadUint32(&o.CONFR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *JPEG_Type) GetCONFR3_XSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONFR3.Reg) & 0xffff0000) >> 16
}

// JPEG.CONFRN1: JPEG codec configuration register 4-7
func (o *JPEG_Type) SetCONFRN1_HD(value uint32) {
	volatile.StoreUint32(&o.CONFRN1.Reg, volatile.LoadUint32(&o.CONFRN1.Reg)&^(0x1)|value)
}
func (o *JPEG_Type) GetCONFRN1_HD() uint32 {
	return volatile.LoadUint32(&o.CONFRN1.Reg) & 0x1
}
func (o *JPEG_Type) SetCONFRN1_HA(value uint32) {
	volatile.StoreUint32(&o.CONFRN1.Reg, volatile.LoadUint32(&o.CONFRN1.Reg)&^(0x2)|value<<1)
}
func (o *JPEG_Type) GetCONFRN1_HA() uint32 {
	return (volatile.LoadUint32(&o.CONFRN1.Reg) & 0x2) >> 1
}
func (o *JPEG_Type) SetCONFRN1_QT(value uint32) {
	volatile.StoreUint32(&o.CONFRN1.Reg, volatile.LoadUint32(&o.CONFRN1.Reg)&^(0xc)|value<<2)
}
func (o *JPEG_Type) GetCONFRN1_QT() uint32 {
	return (volatile.LoadUint32(&o.CONFRN1.Reg) & 0xc) >> 2
}
func (o *JPEG_Type) SetCONFRN1_NB(value uint32) {
	volatile.StoreUint32(&o.CONFRN1.Reg, volatile.LoadUint32(&o.CONFRN1.Reg)&^(0xf0)|value<<4)
}
func (o *JPEG_Type) GetCONFRN1_NB() uint32 {
	return (volatile.LoadUint32(&o.CONFRN1.Reg) & 0xf0) >> 4
}
func (o *JPEG_Type) SetCONFRN1_VSF(value uint32) {
	volatile.StoreUint32(&o.CONFRN1.Reg, volatile.LoadUint32(&o.CONFRN1.Reg)&^(0xf00)|value<<8)
}
func (o *JPEG_Type) GetCONFRN1_VSF() uint32 {
	return (volatile.LoadUint32(&o.CONFRN1.Reg) & 0xf00) >> 8
}
func (o *JPEG_Type) SetCONFRN1_HSF(value uint32) {
	volatile.StoreUint32(&o.CONFRN1.Reg, volatile.LoadUint32(&o.CONFRN1.Reg)&^(0xf000)|value<<12)
}
func (o *JPEG_Type) GetCONFRN1_HSF() uint32 {
	return (volatile.LoadUint32(&o.CONFRN1.Reg) & 0xf000) >> 12
}

// JPEG.CONFRN2: JPEG codec configuration register 4-7
func (o *JPEG_Type) SetCONFRN2_HD(value uint32) {
	volatile.StoreUint32(&o.CONFRN2.Reg, volatile.LoadUint32(&o.CONFRN2.Reg)&^(0x1)|value)
}
func (o *JPEG_Type) GetCONFRN2_HD() uint32 {
	return volatile.LoadUint32(&o.CONFRN2.Reg) & 0x1
}
func (o *JPEG_Type) SetCONFRN2_HA(value uint32) {
	volatile.StoreUint32(&o.CONFRN2.Reg, volatile.LoadUint32(&o.CONFRN2.Reg)&^(0x2)|value<<1)
}
func (o *JPEG_Type) GetCONFRN2_HA() uint32 {
	return (volatile.LoadUint32(&o.CONFRN2.Reg) & 0x2) >> 1
}
func (o *JPEG_Type) SetCONFRN2_QT(value uint32) {
	volatile.StoreUint32(&o.CONFRN2.Reg, volatile.LoadUint32(&o.CONFRN2.Reg)&^(0xc)|value<<2)
}
func (o *JPEG_Type) GetCONFRN2_QT() uint32 {
	return (volatile.LoadUint32(&o.CONFRN2.Reg) & 0xc) >> 2
}
func (o *JPEG_Type) SetCONFRN2_NB(value uint32) {
	volatile.StoreUint32(&o.CONFRN2.Reg, volatile.LoadUint32(&o.CONFRN2.Reg)&^(0xf0)|value<<4)
}
func (o *JPEG_Type) GetCONFRN2_NB() uint32 {
	return (volatile.LoadUint32(&o.CONFRN2.Reg) & 0xf0) >> 4
}
func (o *JPEG_Type) SetCONFRN2_VSF(value uint32) {
	volatile.StoreUint32(&o.CONFRN2.Reg, volatile.LoadUint32(&o.CONFRN2.Reg)&^(0xf00)|value<<8)
}
func (o *JPEG_Type) GetCONFRN2_VSF() uint32 {
	return (volatile.LoadUint32(&o.CONFRN2.Reg) & 0xf00) >> 8
}
func (o *JPEG_Type) SetCONFRN2_HSF(value uint32) {
	volatile.StoreUint32(&o.CONFRN2.Reg, volatile.LoadUint32(&o.CONFRN2.Reg)&^(0xf000)|value<<12)
}
func (o *JPEG_Type) GetCONFRN2_HSF() uint32 {
	return (volatile.LoadUint32(&o.CONFRN2.Reg) & 0xf000) >> 12
}

// JPEG.CONFRN3: JPEG codec configuration register 4-7
func (o *JPEG_Type) SetCONFRN3_HD(value uint32) {
	volatile.StoreUint32(&o.CONFRN3.Reg, volatile.LoadUint32(&o.CONFRN3.Reg)&^(0x1)|value)
}
func (o *JPEG_Type) GetCONFRN3_HD() uint32 {
	return volatile.LoadUint32(&o.CONFRN3.Reg) & 0x1
}
func (o *JPEG_Type) SetCONFRN3_HA(value uint32) {
	volatile.StoreUint32(&o.CONFRN3.Reg, volatile.LoadUint32(&o.CONFRN3.Reg)&^(0x2)|value<<1)
}
func (o *JPEG_Type) GetCONFRN3_HA() uint32 {
	return (volatile.LoadUint32(&o.CONFRN3.Reg) & 0x2) >> 1
}
func (o *JPEG_Type) SetCONFRN3_QT(value uint32) {
	volatile.StoreUint32(&o.CONFRN3.Reg, volatile.LoadUint32(&o.CONFRN3.Reg)&^(0xc)|value<<2)
}
func (o *JPEG_Type) GetCONFRN3_QT() uint32 {
	return (volatile.LoadUint32(&o.CONFRN3.Reg) & 0xc) >> 2
}
func (o *JPEG_Type) SetCONFRN3_NB(value uint32) {
	volatile.StoreUint32(&o.CONFRN3.Reg, volatile.LoadUint32(&o.CONFRN3.Reg)&^(0xf0)|value<<4)
}
func (o *JPEG_Type) GetCONFRN3_NB() uint32 {
	return (volatile.LoadUint32(&o.CONFRN3.Reg) & 0xf0) >> 4
}
func (o *JPEG_Type) SetCONFRN3_VSF(value uint32) {
	volatile.StoreUint32(&o.CONFRN3.Reg, volatile.LoadUint32(&o.CONFRN3.Reg)&^(0xf00)|value<<8)
}
func (o *JPEG_Type) GetCONFRN3_VSF() uint32 {
	return (volatile.LoadUint32(&o.CONFRN3.Reg) & 0xf00) >> 8
}
func (o *JPEG_Type) SetCONFRN3_HSF(value uint32) {
	volatile.StoreUint32(&o.CONFRN3.Reg, volatile.LoadUint32(&o.CONFRN3.Reg)&^(0xf000)|value<<12)
}
func (o *JPEG_Type) GetCONFRN3_HSF() uint32 {
	return (volatile.LoadUint32(&o.CONFRN3.Reg) & 0xf000) >> 12
}

// JPEG.CONFRN4: JPEG codec configuration register 4-7
func (o *JPEG_Type) SetCONFRN4_HD(value uint32) {
	volatile.StoreUint32(&o.CONFRN4.Reg, volatile.LoadUint32(&o.CONFRN4.Reg)&^(0x1)|value)
}
func (o *JPEG_Type) GetCONFRN4_HD() uint32 {
	return volatile.LoadUint32(&o.CONFRN4.Reg) & 0x1
}
func (o *JPEG_Type) SetCONFRN4_HA(value uint32) {
	volatile.StoreUint32(&o.CONFRN4.Reg, volatile.LoadUint32(&o.CONFRN4.Reg)&^(0x2)|value<<1)
}
func (o *JPEG_Type) GetCONFRN4_HA() uint32 {
	return (volatile.LoadUint32(&o.CONFRN4.Reg) & 0x2) >> 1
}
func (o *JPEG_Type) SetCONFRN4_QT(value uint32) {
	volatile.StoreUint32(&o.CONFRN4.Reg, volatile.LoadUint32(&o.CONFRN4.Reg)&^(0xc)|value<<2)
}
func (o *JPEG_Type) GetCONFRN4_QT() uint32 {
	return (volatile.LoadUint32(&o.CONFRN4.Reg) & 0xc) >> 2
}
func (o *JPEG_Type) SetCONFRN4_NB(value uint32) {
	volatile.StoreUint32(&o.CONFRN4.Reg, volatile.LoadUint32(&o.CONFRN4.Reg)&^(0xf0)|value<<4)
}
func (o *JPEG_Type) GetCONFRN4_NB() uint32 {
	return (volatile.LoadUint32(&o.CONFRN4.Reg) & 0xf0) >> 4
}
func (o *JPEG_Type) SetCONFRN4_VSF(value uint32) {
	volatile.StoreUint32(&o.CONFRN4.Reg, volatile.LoadUint32(&o.CONFRN4.Reg)&^(0xf00)|value<<8)
}
func (o *JPEG_Type) GetCONFRN4_VSF() uint32 {
	return (volatile.LoadUint32(&o.CONFRN4.Reg) & 0xf00) >> 8
}
func (o *JPEG_Type) SetCONFRN4_HSF(value uint32) {
	volatile.StoreUint32(&o.CONFRN4.Reg, volatile.LoadUint32(&o.CONFRN4.Reg)&^(0xf000)|value<<12)
}
func (o *JPEG_Type) GetCONFRN4_HSF() uint32 {
	return (volatile.LoadUint32(&o.CONFRN4.Reg) & 0xf000) >> 12
}

// JPEG.CR: JPEG control register
func (o *JPEG_Type) SetCR_JCEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *JPEG_Type) GetCR_JCEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *JPEG_Type) SetCR_IFTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *JPEG_Type) GetCR_IFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *JPEG_Type) SetCR_IFNFIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *JPEG_Type) GetCR_IFNFIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *JPEG_Type) SetCR_OFTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *JPEG_Type) GetCR_OFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *JPEG_Type) SetCR_OFNEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *JPEG_Type) GetCR_OFNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *JPEG_Type) SetCR_EOCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *JPEG_Type) GetCR_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *JPEG_Type) SetCR_HPDIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *JPEG_Type) GetCR_HPDIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *JPEG_Type) SetCR_IDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *JPEG_Type) GetCR_IDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *JPEG_Type) SetCR_ODMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *JPEG_Type) GetCR_ODMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *JPEG_Type) SetCR_IFF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *JPEG_Type) GetCR_IFF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *JPEG_Type) SetCR_OFF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *JPEG_Type) GetCR_OFF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}

// JPEG.SR: JPEG status register
func (o *JPEG_Type) SetSR_IFTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *JPEG_Type) GetSR_IFTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *JPEG_Type) SetSR_IFNFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *JPEG_Type) GetSR_IFNFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *JPEG_Type) SetSR_OFTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *JPEG_Type) GetSR_OFTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *JPEG_Type) SetSR_OFNEF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *JPEG_Type) GetSR_OFNEF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *JPEG_Type) SetSR_EOCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *JPEG_Type) GetSR_EOCF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *JPEG_Type) SetSR_HPDF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *JPEG_Type) GetSR_HPDF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *JPEG_Type) SetSR_COF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *JPEG_Type) GetSR_COF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}

// JPEG.CFR: JPEG clear flag register
func (o *JPEG_Type) SetCFR_CEOCF(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x20)|value<<5)
}
func (o *JPEG_Type) GetCFR_CEOCF() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x20) >> 5
}
func (o *JPEG_Type) SetCFR_CHPDF(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x40)|value<<6)
}
func (o *JPEG_Type) GetCFR_CHPDF() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x40) >> 6
}

// JPEG.DIR: JPEG data input register
func (o *JPEG_Type) SetDIR(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, value)
}
func (o *JPEG_Type) GetDIR() uint32 {
	return volatile.LoadUint32(&o.DIR.Reg)
}

// JPEG.DOR: JPEG data output register
func (o *JPEG_Type) SetDOR(value uint32) {
	volatile.StoreUint32(&o.DOR.Reg, value)
}
func (o *JPEG_Type) GetDOR() uint32 {
	return volatile.LoadUint32(&o.DOR.Reg)
}

// MDMA
type MDMA_Type struct {
	GISR0 volatile.Register32 // 0x0
	_     [60]byte
	CH    [16]MDMA_CH_Type // 0x40
}

// MDMA.GISR0: MDMA Global Interrupt/Status Register
func (o *MDMA_Type) SetGISR0_GIF0(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x1)|value)
}
func (o *MDMA_Type) GetGISR0_GIF0() uint32 {
	return volatile.LoadUint32(&o.GISR0.Reg) & 0x1
}
func (o *MDMA_Type) SetGISR0_GIF1(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x2)|value<<1)
}
func (o *MDMA_Type) GetGISR0_GIF1() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x2) >> 1
}
func (o *MDMA_Type) SetGISR0_GIF2(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x4)|value<<2)
}
func (o *MDMA_Type) GetGISR0_GIF2() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x4) >> 2
}
func (o *MDMA_Type) SetGISR0_GIF3(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x8)|value<<3)
}
func (o *MDMA_Type) GetGISR0_GIF3() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x8) >> 3
}
func (o *MDMA_Type) SetGISR0_GIF4(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x10)|value<<4)
}
func (o *MDMA_Type) GetGISR0_GIF4() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x10) >> 4
}
func (o *MDMA_Type) SetGISR0_GIF5(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x20)|value<<5)
}
func (o *MDMA_Type) GetGISR0_GIF5() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x20) >> 5
}
func (o *MDMA_Type) SetGISR0_GIF6(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x40)|value<<6)
}
func (o *MDMA_Type) GetGISR0_GIF6() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x40) >> 6
}
func (o *MDMA_Type) SetGISR0_GIF7(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x80)|value<<7)
}
func (o *MDMA_Type) GetGISR0_GIF7() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x80) >> 7
}
func (o *MDMA_Type) SetGISR0_GIF8(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x100)|value<<8)
}
func (o *MDMA_Type) GetGISR0_GIF8() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x100) >> 8
}
func (o *MDMA_Type) SetGISR0_GIF9(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x200)|value<<9)
}
func (o *MDMA_Type) GetGISR0_GIF9() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x200) >> 9
}
func (o *MDMA_Type) SetGISR0_GIF10(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x400)|value<<10)
}
func (o *MDMA_Type) GetGISR0_GIF10() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x400) >> 10
}
func (o *MDMA_Type) SetGISR0_GIF11(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x800)|value<<11)
}
func (o *MDMA_Type) GetGISR0_GIF11() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x800) >> 11
}
func (o *MDMA_Type) SetGISR0_GIF12(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x1000)|value<<12)
}
func (o *MDMA_Type) GetGISR0_GIF12() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x1000) >> 12
}
func (o *MDMA_Type) SetGISR0_GIF13(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x2000)|value<<13)
}
func (o *MDMA_Type) GetGISR0_GIF13() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x2000) >> 13
}
func (o *MDMA_Type) SetGISR0_GIF14(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x4000)|value<<14)
}
func (o *MDMA_Type) GetGISR0_GIF14() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x4000) >> 14
}
func (o *MDMA_Type) SetGISR0_GIF15(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x8000)|value<<15)
}
func (o *MDMA_Type) GetGISR0_GIF15() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x8000) >> 15
}

type MDMA_CH_Type struct {
	ISR   volatile.Register32 // 0x40
	IFCR  volatile.Register32 // 0x44
	ESR   volatile.Register32 // 0x48
	CR    volatile.Register32 // 0x4C
	TCR   volatile.Register32 // 0x50
	BNDTR volatile.Register32 // 0x54
	SAR   volatile.Register32 // 0x58
	DAR   volatile.Register32 // 0x5C
	BRUR  volatile.Register32 // 0x60
	LAR   volatile.Register32 // 0x64
	TBR   volatile.Register32 // 0x68
	_     [4]byte
	MAR   volatile.Register32 // 0x70
	MDR   volatile.Register32 // 0x74
	_     [8]byte
}

// MDMA_CH.ISR: MDMA channel x interrupt/status register
func (o *MDMA_CH_Type) SetISR_TEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *MDMA_CH_Type) GetISR_TEIF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *MDMA_CH_Type) SetISR_CTCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *MDMA_CH_Type) GetISR_CTCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *MDMA_CH_Type) SetISR_BRTIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *MDMA_CH_Type) GetISR_BRTIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *MDMA_CH_Type) SetISR_BTIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *MDMA_CH_Type) GetISR_BTIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *MDMA_CH_Type) SetISR_TCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *MDMA_CH_Type) GetISR_TCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *MDMA_CH_Type) SetISR_CRQA(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *MDMA_CH_Type) GetISR_CRQA() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}

// MDMA_CH.IFCR: MDMA channel x interrupt flag clear register
func (o *MDMA_CH_Type) SetIFCR_CTEIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *MDMA_CH_Type) GetIFCR_CTEIF() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}
func (o *MDMA_CH_Type) SetIFCR_CCTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *MDMA_CH_Type) GetIFCR_CCTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *MDMA_CH_Type) SetIFCR_CBRTIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *MDMA_CH_Type) GetIFCR_CBRTIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *MDMA_CH_Type) SetIFCR_CBTIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *MDMA_CH_Type) GetIFCR_CBTIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *MDMA_CH_Type) SetIFCR_CLTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *MDMA_CH_Type) GetIFCR_CLTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}

// MDMA_CH.ESR: MDMA Channel x error status register
func (o *MDMA_CH_Type) SetESR_TEA(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x7f)|value)
}
func (o *MDMA_CH_Type) GetESR_TEA() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x7f
}
func (o *MDMA_CH_Type) SetESR_TED(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80)|value<<7)
}
func (o *MDMA_CH_Type) GetESR_TED() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80) >> 7
}
func (o *MDMA_CH_Type) SetESR_TELD(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100)|value<<8)
}
func (o *MDMA_CH_Type) GetESR_TELD() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100) >> 8
}
func (o *MDMA_CH_Type) SetESR_TEMD(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200)|value<<9)
}
func (o *MDMA_CH_Type) GetESR_TEMD() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200) >> 9
}
func (o *MDMA_CH_Type) SetESR_ASE(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400)|value<<10)
}
func (o *MDMA_CH_Type) GetESR_ASE() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400) >> 10
}
func (o *MDMA_CH_Type) SetESR_BSE(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800)|value<<11)
}
func (o *MDMA_CH_Type) GetESR_BSE() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800) >> 11
}

// MDMA_CH.CR: This register is used to control the concerned channel.
func (o *MDMA_CH_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *MDMA_CH_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *MDMA_CH_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *MDMA_CH_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *MDMA_CH_Type) SetCR_CTCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *MDMA_CH_Type) GetCR_CTCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *MDMA_CH_Type) SetCR_BRTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *MDMA_CH_Type) GetCR_BRTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *MDMA_CH_Type) SetCR_BTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *MDMA_CH_Type) GetCR_BTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *MDMA_CH_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *MDMA_CH_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *MDMA_CH_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *MDMA_CH_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *MDMA_CH_Type) SetCR_BEX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *MDMA_CH_Type) GetCR_BEX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *MDMA_CH_Type) SetCR_HEX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *MDMA_CH_Type) GetCR_HEX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *MDMA_CH_Type) SetCR_WEX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *MDMA_CH_Type) GetCR_WEX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *MDMA_CH_Type) SetCR_SWRQ(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *MDMA_CH_Type) GetCR_SWRQ() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}

// MDMA_CH.TCR: This register is used to configure the concerned channel.
func (o *MDMA_CH_Type) SetTCR_SINC(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x3)|value)
}
func (o *MDMA_CH_Type) GetTCR_SINC() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x3
}
func (o *MDMA_CH_Type) SetTCR_DINC(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xc)|value<<2)
}
func (o *MDMA_CH_Type) GetTCR_DINC() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xc) >> 2
}
func (o *MDMA_CH_Type) SetTCR_SSIZE(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x30)|value<<4)
}
func (o *MDMA_CH_Type) GetTCR_SSIZE() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x30) >> 4
}
func (o *MDMA_CH_Type) SetTCR_DSIZE(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xc0)|value<<6)
}
func (o *MDMA_CH_Type) GetTCR_DSIZE() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xc0) >> 6
}
func (o *MDMA_CH_Type) SetTCR_SINCOS(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x300)|value<<8)
}
func (o *MDMA_CH_Type) GetTCR_SINCOS() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x300) >> 8
}
func (o *MDMA_CH_Type) SetTCR_DINCOS(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xc00)|value<<10)
}
func (o *MDMA_CH_Type) GetTCR_DINCOS() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xc00) >> 10
}
func (o *MDMA_CH_Type) SetTCR_SBURST(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x7000)|value<<12)
}
func (o *MDMA_CH_Type) GetTCR_SBURST() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x7000) >> 12
}
func (o *MDMA_CH_Type) SetTCR_DBURST(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x38000)|value<<15)
}
func (o *MDMA_CH_Type) GetTCR_DBURST() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x38000) >> 15
}
func (o *MDMA_CH_Type) SetTCR_TLEN(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1fc0000)|value<<18)
}
func (o *MDMA_CH_Type) GetTCR_TLEN() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x1fc0000) >> 18
}
func (o *MDMA_CH_Type) SetTCR_PKE(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x2000000)|value<<25)
}
func (o *MDMA_CH_Type) GetTCR_PKE() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x2000000) >> 25
}
func (o *MDMA_CH_Type) SetTCR_PAM(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xc000000)|value<<26)
}
func (o *MDMA_CH_Type) GetTCR_PAM() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xc000000) >> 26
}
func (o *MDMA_CH_Type) SetTCR_TRGM(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x30000000)|value<<28)
}
func (o *MDMA_CH_Type) GetTCR_TRGM() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x30000000) >> 28
}
func (o *MDMA_CH_Type) SetTCR_SWRM(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x40000000)|value<<30)
}
func (o *MDMA_CH_Type) GetTCR_SWRM() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x40000000) >> 30
}
func (o *MDMA_CH_Type) SetTCR_BWM(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x80000000)|value<<31)
}
func (o *MDMA_CH_Type) GetTCR_BWM() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x80000000) >> 31
}

// MDMA_CH.BNDTR: MDMA Channel x block number of data register
func (o *MDMA_CH_Type) SetBNDTR_BNDT(value uint32) {
	volatile.StoreUint32(&o.BNDTR.Reg, volatile.LoadUint32(&o.BNDTR.Reg)&^(0x1ffff)|value)
}
func (o *MDMA_CH_Type) GetBNDTR_BNDT() uint32 {
	return volatile.LoadUint32(&o.BNDTR.Reg) & 0x1ffff
}
func (o *MDMA_CH_Type) SetBNDTR_BRSUM(value uint32) {
	volatile.StoreUint32(&o.BNDTR.Reg, volatile.LoadUint32(&o.BNDTR.Reg)&^(0x40000)|value<<18)
}
func (o *MDMA_CH_Type) GetBNDTR_BRSUM() uint32 {
	return (volatile.LoadUint32(&o.BNDTR.Reg) & 0x40000) >> 18
}
func (o *MDMA_CH_Type) SetBNDTR_BRDUM(value uint32) {
	volatile.StoreUint32(&o.BNDTR.Reg, volatile.LoadUint32(&o.BNDTR.Reg)&^(0x80000)|value<<19)
}
func (o *MDMA_CH_Type) GetBNDTR_BRDUM() uint32 {
	return (volatile.LoadUint32(&o.BNDTR.Reg) & 0x80000) >> 19
}
func (o *MDMA_CH_Type) SetBNDTR_BRC(value uint32) {
	volatile.StoreUint32(&o.BNDTR.Reg, volatile.LoadUint32(&o.BNDTR.Reg)&^(0xfff00000)|value<<20)
}
func (o *MDMA_CH_Type) GetBNDTR_BRC() uint32 {
	return (volatile.LoadUint32(&o.BNDTR.Reg) & 0xfff00000) >> 20
}

// MDMA_CH.SAR: MDMA channel x source address register
func (o *MDMA_CH_Type) SetSAR(value uint32) {
	volatile.StoreUint32(&o.SAR.Reg, value)
}
func (o *MDMA_CH_Type) GetSAR() uint32 {
	return volatile.LoadUint32(&o.SAR.Reg)
}

// MDMA_CH.DAR: MDMA channel x destination address register
func (o *MDMA_CH_Type) SetDAR(value uint32) {
	volatile.StoreUint32(&o.DAR.Reg, value)
}
func (o *MDMA_CH_Type) GetDAR() uint32 {
	return volatile.LoadUint32(&o.DAR.Reg)
}

// MDMA_CH.BRUR: MDMA channel x Block Repeat address Update register
func (o *MDMA_CH_Type) SetBRUR_SUV(value uint32) {
	volatile.StoreUint32(&o.BRUR.Reg, volatile.LoadUint32(&o.BRUR.Reg)&^(0xffff)|value)
}
func (o *MDMA_CH_Type) GetBRUR_SUV() uint32 {
	return volatile.LoadUint32(&o.BRUR.Reg) & 0xffff
}
func (o *MDMA_CH_Type) SetBRUR_DUV(value uint32) {
	volatile.StoreUint32(&o.BRUR.Reg, volatile.LoadUint32(&o.BRUR.Reg)&^(0xffff0000)|value<<16)
}
func (o *MDMA_CH_Type) GetBRUR_DUV() uint32 {
	return (volatile.LoadUint32(&o.BRUR.Reg) & 0xffff0000) >> 16
}

// MDMA_CH.LAR: MDMA channel x Link Address register
func (o *MDMA_CH_Type) SetLAR(value uint32) {
	volatile.StoreUint32(&o.LAR.Reg, value)
}
func (o *MDMA_CH_Type) GetLAR() uint32 {
	return volatile.LoadUint32(&o.LAR.Reg)
}

// MDMA_CH.TBR: MDMA channel x Trigger and Bus selection Register
func (o *MDMA_CH_Type) SetTBR_TSEL(value uint32) {
	volatile.StoreUint32(&o.TBR.Reg, volatile.LoadUint32(&o.TBR.Reg)&^(0x3f)|value)
}
func (o *MDMA_CH_Type) GetTBR_TSEL() uint32 {
	return volatile.LoadUint32(&o.TBR.Reg) & 0x3f
}
func (o *MDMA_CH_Type) SetTBR_SBUS(value uint32) {
	volatile.StoreUint32(&o.TBR.Reg, volatile.LoadUint32(&o.TBR.Reg)&^(0x10000)|value<<16)
}
func (o *MDMA_CH_Type) GetTBR_SBUS() uint32 {
	return (volatile.LoadUint32(&o.TBR.Reg) & 0x10000) >> 16
}
func (o *MDMA_CH_Type) SetTBR_DBUS(value uint32) {
	volatile.StoreUint32(&o.TBR.Reg, volatile.LoadUint32(&o.TBR.Reg)&^(0x20000)|value<<17)
}
func (o *MDMA_CH_Type) GetTBR_DBUS() uint32 {
	return (volatile.LoadUint32(&o.TBR.Reg) & 0x20000) >> 17
}

// MDMA_CH.MAR: MDMA channel x Mask address register
func (o *MDMA_CH_Type) SetMAR(value uint32) {
	volatile.StoreUint32(&o.MAR.Reg, value)
}
func (o *MDMA_CH_Type) GetMAR() uint32 {
	return volatile.LoadUint32(&o.MAR.Reg)
}

// MDMA_CH.MDR: MDMA channel x Mask Data register
func (o *MDMA_CH_Type) SetMDR(value uint32) {
	volatile.StoreUint32(&o.MDR.Reg, value)
}
func (o *MDMA_CH_Type) GetMDR() uint32 {
	return volatile.LoadUint32(&o.MDR.Reg)
}

// QUADSPI
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// QUADSPI.CR: QUADSPI control register
func (o *QUADSPI_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *QUADSPI_Type) SetCR_ABORT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetCR_ABORT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetCR_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetCR_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetCR_TCEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetCR_TCEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetCR_SSHIFT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetCR_SSHIFT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetCR_DFM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *QUADSPI_Type) GetCR_DFM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *QUADSPI_Type) SetCR_FSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *QUADSPI_Type) GetCR_FSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *QUADSPI_Type) SetCR_FTHRES(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1f00)|value<<8)
}
func (o *QUADSPI_Type) GetCR_FTHRES() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1f00) >> 8
}
func (o *QUADSPI_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *QUADSPI_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *QUADSPI_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *QUADSPI_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *QUADSPI_Type) SetCR_FTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *QUADSPI_Type) GetCR_FTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *QUADSPI_Type) SetCR_SMIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *QUADSPI_Type) GetCR_SMIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *QUADSPI_Type) SetCR_TOIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *QUADSPI_Type) GetCR_TOIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *QUADSPI_Type) SetCR_APMS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *QUADSPI_Type) GetCR_APMS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *QUADSPI_Type) SetCR_PMM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *QUADSPI_Type) GetCR_PMM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *QUADSPI_Type) SetCR_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *QUADSPI_Type) GetCR_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}

// QUADSPI.DCR: QUADSPI device configuration register
func (o *QUADSPI_Type) SetDCR_CKMODE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetDCR_CKMODE() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1
}
func (o *QUADSPI_Type) SetDCR_CSHT(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x700)|value<<8)
}
func (o *QUADSPI_Type) GetDCR_CSHT() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x700) >> 8
}
func (o *QUADSPI_Type) SetDCR_FSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f0000)|value<<16)
}
func (o *QUADSPI_Type) GetDCR_FSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f0000) >> 16
}

// QUADSPI.SR: QUADSPI status register
func (o *QUADSPI_Type) SetSR_TEF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetSR_TEF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *QUADSPI_Type) SetSR_TCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetSR_FTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetSR_FTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetSR_SMF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetSR_SMF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetSR_TOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetSR_TOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *QUADSPI_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *QUADSPI_Type) SetSR_FLEVEL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x3f00)|value<<8)
}
func (o *QUADSPI_Type) GetSR_FLEVEL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x3f00) >> 8
}

// QUADSPI.FCR: QUADSPI flag clear register
func (o *QUADSPI_Type) SetFCR_CTEF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetFCR_CTEF() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x1
}
func (o *QUADSPI_Type) SetFCR_CTCF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetFCR_CTCF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetFCR_CSMF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetFCR_CSMF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetFCR_CTOF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetFCR_CTOF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x10) >> 4
}

// QUADSPI.DLR: QUADSPI data length register
func (o *QUADSPI_Type) SetDLR(value uint32) {
	volatile.StoreUint32(&o.DLR.Reg, value)
}
func (o *QUADSPI_Type) GetDLR() uint32 {
	return volatile.LoadUint32(&o.DLR.Reg)
}

// QUADSPI.CCR: QUADSPI communication configuration register
func (o *QUADSPI_Type) SetCCR_INSTRUCTION(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xff)|value)
}
func (o *QUADSPI_Type) GetCCR_INSTRUCTION() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0xff
}
func (o *QUADSPI_Type) SetCCR_IMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x300)|value<<8)
}
func (o *QUADSPI_Type) GetCCR_IMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x300) >> 8
}
func (o *QUADSPI_Type) SetCCR_ADMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc00)|value<<10)
}
func (o *QUADSPI_Type) GetCCR_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc00) >> 10
}
func (o *QUADSPI_Type) SetCCR_ADSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000)|value<<12)
}
func (o *QUADSPI_Type) GetCCR_ADSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000) >> 12
}
func (o *QUADSPI_Type) SetCCR_ABMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000)|value<<14)
}
func (o *QUADSPI_Type) GetCCR_ABMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000) >> 14
}
func (o *QUADSPI_Type) SetCCR_ABSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x30000)|value<<16)
}
func (o *QUADSPI_Type) GetCCR_ABSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x30000) >> 16
}
func (o *QUADSPI_Type) SetCCR_DCYC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x7c0000)|value<<18)
}
func (o *QUADSPI_Type) GetCCR_DCYC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x7c0000) >> 18
}
func (o *QUADSPI_Type) SetCCR_DMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000000)|value<<24)
}
func (o *QUADSPI_Type) GetCCR_DMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000000) >> 24
}
func (o *QUADSPI_Type) SetCCR_FMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000000)|value<<26)
}
func (o *QUADSPI_Type) GetCCR_FMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000000) >> 26
}
func (o *QUADSPI_Type) SetCCR_SIOO(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10000000)|value<<28)
}
func (o *QUADSPI_Type) GetCCR_SIOO() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10000000) >> 28
}
func (o *QUADSPI_Type) SetCCR_DHHC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x40000000)|value<<30)
}
func (o *QUADSPI_Type) GetCCR_DHHC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x40000000) >> 30
}
func (o *QUADSPI_Type) SetCCR_DDRM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80000000)|value<<31)
}
func (o *QUADSPI_Type) GetCCR_DDRM() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80000000) >> 31
}

// QUADSPI.AR: QUADSPI address register
func (o *QUADSPI_Type) SetAR(value uint32) {
	volatile.StoreUint32(&o.AR.Reg, value)
}
func (o *QUADSPI_Type) GetAR() uint32 {
	return volatile.LoadUint32(&o.AR.Reg)
}

// QUADSPI.ABR: QUADSPI alternate bytes registers
func (o *QUADSPI_Type) SetABR(value uint32) {
	volatile.StoreUint32(&o.ABR.Reg, value)
}
func (o *QUADSPI_Type) GetABR() uint32 {
	return volatile.LoadUint32(&o.ABR.Reg)
}

// QUADSPI.DR: QUADSPI data register
func (o *QUADSPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *QUADSPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// QUADSPI.PSMKR: QUADSPI polling status mask register
func (o *QUADSPI_Type) SetPSMKR(value uint32) {
	volatile.StoreUint32(&o.PSMKR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMKR() uint32 {
	return volatile.LoadUint32(&o.PSMKR.Reg)
}

// QUADSPI.PSMAR: QUADSPI polling status match register
func (o *QUADSPI_Type) SetPSMAR(value uint32) {
	volatile.StoreUint32(&o.PSMAR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMAR() uint32 {
	return volatile.LoadUint32(&o.PSMAR.Reg)
}

// QUADSPI.PIR: QUADSPI polling interval register
func (o *QUADSPI_Type) SetPIR_INTERVAL(value uint32) {
	volatile.StoreUint32(&o.PIR.Reg, volatile.LoadUint32(&o.PIR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetPIR_INTERVAL() uint32 {
	return volatile.LoadUint32(&o.PIR.Reg) & 0xffff
}

// QUADSPI.LPTR: QUADSPI low-power timeout register
func (o *QUADSPI_Type) SetLPTR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LPTR.Reg, volatile.LoadUint32(&o.LPTR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetLPTR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.LPTR.Reg) & 0xffff
}

// RNG
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// RNG.CR: RNG control register
func (o *RNG_Type) SetCR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetCR_IE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_IE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_CED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetCR_CED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}

// RNG.SR: RNG status register
func (o *RNG_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_DRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RNG_Type) SetSR_CECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_CECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_SECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_SECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_CEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetSR_CEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetSR_SEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *RNG_Type) GetSR_SEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}

// RNG.DR: The RNG_DR register is a read-only register that delivers a 32-bit random value when read. The content of this register is valid when DRDY= 1, even if RNGEN=0.
func (o *RNG_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *RNG_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// RTC
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// RTC.TR: The RTC_TR is the calendar time shadow register. This register must be written in initialization mode only. Refer to Calendar initialization and configuration on page9 and Reading the calendar on page10.This register is write protected. The write access procedure is described in RTC register write protection on page9.
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}

// RTC.DR: The RTC_DR is the calendar date shadow register. This register must be written in initialization mode only. Refer to Calendar initialization and configuration on page9 and Reading the calendar on page10.This register is write protected. The write access procedure is described in RTC register write protection on page9.
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}

// RTC.CR: RTC control register
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_ITSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetCR_ITSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// RTC.ISR: This register is write protected (except for RTC_ISR[13:8] bits). The write access procedure is described in RTC register write protection on page9.
func (o *RTC_Type) SetISR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetISR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *RTC_Type) SetISR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetISR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetISR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetISR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetISR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetISR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetISR_INITS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetISR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetISR_RSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetISR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetISR_INITF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetISR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetISR_INIT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetISR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetISR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetISR_ALRAF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetISR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetISR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetISR_WUTF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetISR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetISR_TSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetISR_TSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetISR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetISR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetISR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetISR_TAMP1F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetISR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetISR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetISR_TAMP3F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetISR_TAMP3F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetISR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetISR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetISR_ITSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetISR_ITSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}

// RTC.PRER: This register must be written in initialization mode only. The initialization must be performed in two separate write accesses. Refer to Calendar initialization and configuration on page9.This register is write protected. The write access procedure is described in RTC register write protection on page9.
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}

// RTC.WUTR: This register can be written only when WUTWF is set to 1 in RTC_ISR.This register is write protected. The write access procedure is described in RTC register write protection on page9.
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.ALRMAR: This register can be written only when ALRAWF is set to 1 in RTC_ISR, or in initialization mode.This register is write protected. The write access procedure is described in RTC register write protection on page9.
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}

// RTC.ALRMBR: This register can be written only when ALRBWF is set to 1 in RTC_ISR, or in initialization mode.This register is write protected. The write access procedure is described in RTC register write protection on page9.
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}

// RTC.WPR: RTC write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.SSR: RTC sub second register
func (o *RTC_Type) SetSSR_SS(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, volatile.LoadUint32(&o.SSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetSSR_SS() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg) & 0xffff
}

// RTC.SHIFTR: This register is write protected. The write access procedure is described in RTC register write protection on page9.
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}

// RTC.TSTR: The content of this register is valid only when TSF is set to 1 in RTC_ISR. It is cleared when TSF bit is reset.
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}

// RTC.TSDR: The content of this register is valid only when TSF is set to 1 in RTC_ISR. It is cleared when TSF bit is reset.
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}

// RTC.TSSSR: The content of this register is valid only when RTC_ISR/TSF is set. It is cleared when the RTC_ISR/TSF bit is reset.
func (o *RTC_Type) SetTSSSR_SS(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, volatile.LoadUint32(&o.TSSSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTSSSR_SS() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg) & 0xffff
}

// RTC.CALR: This register is write protected. The write access procedure is described in RTC register write protection on page9.
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}

// RTC.TAMPCR: RTC tamper and alternate function configuration register
func (o *RTC_Type) SetTAMPCR_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTAMPCR_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1
}
func (o *RTC_Type) SetTAMPCR_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetTAMPCR_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetTAMPCR_TAMPIE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetTAMPCR_TAMPIE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetTAMPCR_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetTAMPCR_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetTAMPCR_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetTAMPCR_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetTAMPCR_TAMP3E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetTAMPCR_TAMP3E() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetTAMPCR_TAMP3TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetTAMPCR_TAMP3TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetTAMPCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetTAMPCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetTAMPCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x700)|value<<8)
}
func (o *RTC_Type) GetTAMPCR_TAMPFREQ() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x700) >> 8
}
func (o *RTC_Type) SetTAMPCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1800)|value<<11)
}
func (o *RTC_Type) GetTAMPCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1800) >> 11
}
func (o *RTC_Type) SetTAMPCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x6000)|value<<13)
}
func (o *RTC_Type) GetTAMPCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x6000) >> 13
}
func (o *RTC_Type) SetTAMPCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetTAMPCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetTAMPCR_TAMP1IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetTAMPCR_TAMP1IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetTAMPCR_TAMP1NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetTAMPCR_TAMP1NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetTAMPCR_TAMP1MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetTAMPCR_TAMP1MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetTAMPCR_TAMP2IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetTAMPCR_TAMP2IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetTAMPCR_TAMP2NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetTAMPCR_TAMP2NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetTAMPCR_TAMP2MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_Type) GetTAMPCR_TAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x200000) >> 21
}
func (o *RTC_Type) SetTAMPCR_TAMP3IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTAMPCR_TAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTAMPCR_TAMP3NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetTAMPCR_TAMP3NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetTAMPCR_TAMP3MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetTAMPCR_TAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1000000) >> 24
}

// RTC.ALRMASSR: This register can be written only when ALRAE is reset in RTC_CR register, or in initialization mode.This register is write protected. The write access procedure is described in RTC register write protection on page9
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0xf000000) >> 24
}

// RTC.ALRMBSSR: This register can be written only when ALRBE is reset in RTC_CR register, or in initialization mode.This register is write protected.The write access procedure is described in Section: RTC register write protection.
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0xf000000) >> 24
}

// RTC.OR: RTC option register
func (o *RTC_Type) SetOR_RTC_ALARM_TYPE(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetOR_RTC_ALARM_TYPE() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x1
}
func (o *RTC_Type) SetOR_RTC_OUT_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetOR_RTC_OUT_RMP() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x2) >> 1
}

// RTC.BKP0R: RTC backup registers
func (o *RTC_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *RTC_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// RTC.BKP1R: RTC backup registers
func (o *RTC_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *RTC_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// RTC.BKP2R: RTC backup registers
func (o *RTC_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *RTC_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// RTC.BKP3R: RTC backup registers
func (o *RTC_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *RTC_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// RTC.BKP4R: RTC backup registers
func (o *RTC_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *RTC_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// RTC.BKP5R: RTC backup registers
func (o *RTC_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *RTC_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// RTC.BKP6R: RTC backup registers
func (o *RTC_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *RTC_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// RTC.BKP7R: RTC backup registers
func (o *RTC_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *RTC_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// RTC.BKP8R: RTC backup registers
func (o *RTC_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *RTC_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// RTC.BKP9R: RTC backup registers
func (o *RTC_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *RTC_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// RTC.BKP10R: RTC backup registers
func (o *RTC_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *RTC_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// RTC.BKP11R: RTC backup registers
func (o *RTC_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *RTC_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// RTC.BKP12R: RTC backup registers
func (o *RTC_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *RTC_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// RTC.BKP13R: RTC backup registers
func (o *RTC_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *RTC_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// RTC.BKP14R: RTC backup registers
func (o *RTC_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *RTC_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// RTC.BKP15R: RTC backup registers
func (o *RTC_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *RTC_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// RTC.BKP16R: RTC backup registers
func (o *RTC_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *RTC_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// RTC.BKP17R: RTC backup registers
func (o *RTC_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *RTC_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// RTC.BKP18R: RTC backup registers
func (o *RTC_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *RTC_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// RTC.BKP19R: RTC backup registers
func (o *RTC_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *RTC_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// RTC.BKP20R: RTC backup registers
func (o *RTC_Type) SetBKP20R(value uint32) {
	volatile.StoreUint32(&o.BKP20R.Reg, value)
}
func (o *RTC_Type) GetBKP20R() uint32 {
	return volatile.LoadUint32(&o.BKP20R.Reg)
}

// RTC.BKP21R: RTC backup registers
func (o *RTC_Type) SetBKP21R(value uint32) {
	volatile.StoreUint32(&o.BKP21R.Reg, value)
}
func (o *RTC_Type) GetBKP21R() uint32 {
	return volatile.LoadUint32(&o.BKP21R.Reg)
}

// RTC.BKP22R: RTC backup registers
func (o *RTC_Type) SetBKP22R(value uint32) {
	volatile.StoreUint32(&o.BKP22R.Reg, value)
}
func (o *RTC_Type) GetBKP22R() uint32 {
	return volatile.LoadUint32(&o.BKP22R.Reg)
}

// RTC.BKP23R: RTC backup registers
func (o *RTC_Type) SetBKP23R(value uint32) {
	volatile.StoreUint32(&o.BKP23R.Reg, value)
}
func (o *RTC_Type) GetBKP23R() uint32 {
	return volatile.LoadUint32(&o.BKP23R.Reg)
}

// RTC.BKP24R: RTC backup registers
func (o *RTC_Type) SetBKP24R(value uint32) {
	volatile.StoreUint32(&o.BKP24R.Reg, value)
}
func (o *RTC_Type) GetBKP24R() uint32 {
	return volatile.LoadUint32(&o.BKP24R.Reg)
}

// RTC.BKP25R: RTC backup registers
func (o *RTC_Type) SetBKP25R(value uint32) {
	volatile.StoreUint32(&o.BKP25R.Reg, value)
}
func (o *RTC_Type) GetBKP25R() uint32 {
	return volatile.LoadUint32(&o.BKP25R.Reg)
}

// RTC.BKP26R: RTC backup registers
func (o *RTC_Type) SetBKP26R(value uint32) {
	volatile.StoreUint32(&o.BKP26R.Reg, value)
}
func (o *RTC_Type) GetBKP26R() uint32 {
	return volatile.LoadUint32(&o.BKP26R.Reg)
}

// RTC.BKP27R: RTC backup registers
func (o *RTC_Type) SetBKP27R(value uint32) {
	volatile.StoreUint32(&o.BKP27R.Reg, value)
}
func (o *RTC_Type) GetBKP27R() uint32 {
	return volatile.LoadUint32(&o.BKP27R.Reg)
}

// RTC.BKP28R: RTC backup registers
func (o *RTC_Type) SetBKP28R(value uint32) {
	volatile.StoreUint32(&o.BKP28R.Reg, value)
}
func (o *RTC_Type) GetBKP28R() uint32 {
	return volatile.LoadUint32(&o.BKP28R.Reg)
}

// RTC.BKP29R: RTC backup registers
func (o *RTC_Type) SetBKP29R(value uint32) {
	volatile.StoreUint32(&o.BKP29R.Reg, value)
}
func (o *RTC_Type) GetBKP29R() uint32 {
	return volatile.LoadUint32(&o.BKP29R.Reg)
}

// RTC.BKP30R: RTC backup registers
func (o *RTC_Type) SetBKP30R(value uint32) {
	volatile.StoreUint32(&o.BKP30R.Reg, value)
}
func (o *RTC_Type) GetBKP30R() uint32 {
	return volatile.LoadUint32(&o.BKP30R.Reg)
}

// RTC.BKP31R: RTC backup registers
func (o *RTC_Type) SetBKP31R(value uint32) {
	volatile.StoreUint32(&o.BKP31R.Reg, value)
}
func (o *RTC_Type) GetBKP31R() uint32 {
	return volatile.LoadUint32(&o.BKP31R.Reg)
}

// SAI
type SAI_Type struct {
	GCR    volatile.Register32 // 0x0
	CH     [2]SAI_CH_Type      // 0x4
	PDMCR  volatile.Register32 // 0x44
	PDMDLY volatile.Register32 // 0x48
}

// SAI.GCR: Global configuration register
func (o *SAI_Type) SetGCR_SYNCOUT(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x30)|value<<4)
}
func (o *SAI_Type) GetGCR_SYNCOUT() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x30) >> 4
}
func (o *SAI_Type) SetGCR_SYNCIN(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x3)|value)
}
func (o *SAI_Type) GetGCR_SYNCIN() uint32 {
	return volatile.LoadUint32(&o.GCR.Reg) & 0x3
}

// SAI.PDMCR: PDM control register
func (o *SAI_Type) SetPDMCR_PDMEN(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x1)|value)
}
func (o *SAI_Type) GetPDMCR_PDMEN() uint32 {
	return volatile.LoadUint32(&o.PDMCR.Reg) & 0x1
}
func (o *SAI_Type) SetPDMCR_MICNBR(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x30)|value<<4)
}
func (o *SAI_Type) GetPDMCR_MICNBR() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x30) >> 4
}
func (o *SAI_Type) SetPDMCR_CKEN1(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x100)|value<<8)
}
func (o *SAI_Type) GetPDMCR_CKEN1() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x100) >> 8
}
func (o *SAI_Type) SetPDMCR_CKEN2(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x200)|value<<9)
}
func (o *SAI_Type) GetPDMCR_CKEN2() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x200) >> 9
}
func (o *SAI_Type) SetPDMCR_CKEN3(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x400)|value<<10)
}
func (o *SAI_Type) GetPDMCR_CKEN3() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x400) >> 10
}
func (o *SAI_Type) SetPDMCR_CKEN4(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x800)|value<<11)
}
func (o *SAI_Type) GetPDMCR_CKEN4() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x800) >> 11
}

// SAI.PDMDLY: PDM delay register
func (o *SAI_Type) SetPDMDLY_DLYM1L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x7)|value)
}
func (o *SAI_Type) GetPDMDLY_DLYM1L() uint32 {
	return volatile.LoadUint32(&o.PDMDLY.Reg) & 0x7
}
func (o *SAI_Type) SetPDMDLY_DLYM1R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x70)|value<<4)
}
func (o *SAI_Type) GetPDMDLY_DLYM1R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x70) >> 4
}
func (o *SAI_Type) SetPDMDLY_DLYM2L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x700)|value<<8)
}
func (o *SAI_Type) GetPDMDLY_DLYM2L() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x700) >> 8
}
func (o *SAI_Type) SetPDMDLY_DLYM2R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x7000)|value<<12)
}
func (o *SAI_Type) GetPDMDLY_DLYM2R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x7000) >> 12
}
func (o *SAI_Type) SetPDMDLY_DLYM3L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x70000)|value<<16)
}
func (o *SAI_Type) GetPDMDLY_DLYM3L() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x70000) >> 16
}
func (o *SAI_Type) SetPDMDLY_DLYM3R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x700000)|value<<20)
}
func (o *SAI_Type) GetPDMDLY_DLYM3R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x700000) >> 20
}
func (o *SAI_Type) SetPDMDLY_DLYM4L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x7000000)|value<<24)
}
func (o *SAI_Type) GetPDMDLY_DLYM4L() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x7000000) >> 24
}
func (o *SAI_Type) SetPDMDLY_DLYM4R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x70000000)|value<<28)
}
func (o *SAI_Type) GetPDMDLY_DLYM4R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x70000000) >> 28
}

type SAI_CH_Type struct {
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	FRCR  volatile.Register32 // 0xC
	SLOTR volatile.Register32 // 0x10
	IM    volatile.Register32 // 0x14
	SR    volatile.Register32 // 0x18
	CLRFR volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
}

// SAI_CH.CR1: Configuration register 1
func (o *SAI_CH_Type) SetCR1_MODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3)|value)
}
func (o *SAI_CH_Type) GetCR1_MODE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x3
}
func (o *SAI_CH_Type) SetCR1_PRTCFG(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc)|value<<2)
}
func (o *SAI_CH_Type) GetCR1_PRTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc) >> 2
}
func (o *SAI_CH_Type) SetCR1_DS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe0)|value<<5)
}
func (o *SAI_CH_Type) GetCR1_DS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe0) >> 5
}
func (o *SAI_CH_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SAI_CH_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SAI_CH_Type) SetCR1_CKSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SAI_CH_Type) GetCR1_CKSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SAI_CH_Type) SetCR1_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc00)|value<<10)
}
func (o *SAI_CH_Type) GetCR1_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc00) >> 10
}
func (o *SAI_CH_Type) SetCR1_MONO(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SAI_CH_Type) GetCR1_MONO() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SAI_CH_Type) SetCR1_OUTDRIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR1_OUTDRIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR1_SAIEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetCR1_SAIEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetCR1_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetCR1_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetCR1_NOMCK(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *SAI_CH_Type) GetCR1_NOMCK() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *SAI_CH_Type) SetCR1_MCKDIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3f00000)|value<<20)
}
func (o *SAI_CH_Type) GetCR1_MCKDIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3f00000) >> 20
}
func (o *SAI_CH_Type) SetCR1_OSR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *SAI_CH_Type) GetCR1_OSR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *SAI_CH_Type) SetCR1_NODIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *SAI_CH_Type) GetCR1_NODIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}

// SAI_CH.CR2: Configuration register 2
func (o *SAI_CH_Type) SetCR2_FTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x7)|value)
}
func (o *SAI_CH_Type) GetCR2_FTH() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x7
}
func (o *SAI_CH_Type) SetCR2_FFLUSH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetCR2_FFLUSH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetCR2_TRIS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCR2_TRIS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCR2_MUTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCR2_MUTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCR2_MUTEVAL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCR2_MUTEVAL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetCR2_MUTECNT(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1f80)|value<<7)
}
func (o *SAI_CH_Type) GetCR2_MUTECNT() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1f80) >> 7
}
func (o *SAI_CH_Type) SetCR2_CPL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR2_CPL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR2_COMP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xc000)|value<<14)
}
func (o *SAI_CH_Type) GetCR2_COMP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xc000) >> 14
}

// SAI_CH.FRCR: This register has no meaning in AC97 and SPDIF audio protocol
func (o *SAI_CH_Type) SetFRCR_FRL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0xff)|value)
}
func (o *SAI_CH_Type) GetFRCR_FRL() uint32 {
	return volatile.LoadUint32(&o.FRCR.Reg) & 0xff
}
func (o *SAI_CH_Type) SetFRCR_FSALL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x7f00)|value<<8)
}
func (o *SAI_CH_Type) GetFRCR_FSALL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x7f00) >> 8
}
func (o *SAI_CH_Type) SetFRCR_FSDEF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetFRCR_FSDEF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetFRCR_FSPOL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetFRCR_FSPOL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetFRCR_FSOFF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x40000)|value<<18)
}
func (o *SAI_CH_Type) GetFRCR_FSOFF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x40000) >> 18
}

// SAI_CH.SLOTR: This register has no meaning in AC97 and SPDIF audio protocol
func (o *SAI_CH_Type) SetSLOTR_FBOFF(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0x1f)|value)
}
func (o *SAI_CH_Type) GetSLOTR_FBOFF() uint32 {
	return volatile.LoadUint32(&o.SLOTR.Reg) & 0x1f
}
func (o *SAI_CH_Type) SetSLOTR_SLOTSZ(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xc0)|value<<6)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTSZ() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xc0) >> 6
}
func (o *SAI_CH_Type) SetSLOTR_NBSLOT(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xf00)|value<<8)
}
func (o *SAI_CH_Type) GetSLOTR_NBSLOT() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xf00) >> 8
}
func (o *SAI_CH_Type) SetSLOTR_SLOTEN(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTEN() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xffff0000) >> 16
}

// SAI_CH.IM: Interrupt mask register 2
func (o *SAI_CH_Type) SetIM_OVRUDRIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetIM_OVRUDRIE() uint32 {
	return volatile.LoadUint32(&o.IM.Reg) & 0x1
}
func (o *SAI_CH_Type) SetIM_MUTEDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetIM_MUTEDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetIM_WCKCFGIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetIM_WCKCFGIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetIM_FREQIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetIM_FREQIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetIM_CNRDYIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetIM_CNRDYIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetIM_AFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetIM_AFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetIM_LFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetIM_LFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x40) >> 6
}

// SAI_CH.SR: Status register
func (o *SAI_CH_Type) SetSR_OVRUDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetSR_OVRUDR() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SAI_CH_Type) SetSR_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetSR_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetSR_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetSR_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetSR_FREQ(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetSR_FREQ() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetSR_CNRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetSR_CNRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetSR_AFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetSR_AFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetSR_LFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetSR_LFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetSR_FLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000)|value<<16)
}
func (o *SAI_CH_Type) GetSR_FLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000) >> 16
}

// SAI_CH.CLRFR: Clear flag register
func (o *SAI_CH_Type) SetCLRFR_COVRUDR(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetCLRFR_COVRUDR() uint32 {
	return volatile.LoadUint32(&o.CLRFR.Reg) & 0x1
}
func (o *SAI_CH_Type) SetCLRFR_CMUTEDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetCLRFR_CMUTEDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetCLRFR_CWCKCFG(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetCLRFR_CWCKCFG() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetCLRFR_CCNRDY(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCLRFR_CCNRDY() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCLRFR_CAFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCLRFR_CAFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCLRFR_CLFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCLRFR_CLFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x40) >> 6
}

// SAI_CH.DR: Data register
func (o *SAI_CH_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *SAI_CH_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// SDMMC1
type SDMMC_Type struct {
	POWER      volatile.Register32 // 0x0
	CLKCR      volatile.Register32 // 0x4
	ARGR       volatile.Register32 // 0x8
	CMDR       volatile.Register32 // 0xC
	RESPCMDR   volatile.Register32 // 0x10
	RESP1R     volatile.Register32 // 0x14
	RESP2R     volatile.Register32 // 0x18
	RESP3R     volatile.Register32 // 0x1C
	RESP4R     volatile.Register32 // 0x20
	DTIMER     volatile.Register32 // 0x24
	DLENR      volatile.Register32 // 0x28
	DCTRL      volatile.Register32 // 0x2C
	DCNTR      volatile.Register32 // 0x30
	STAR       volatile.Register32 // 0x34
	ICR        volatile.Register32 // 0x38
	MASKR      volatile.Register32 // 0x3C
	ACKTIMER   volatile.Register32 // 0x40
	_          [12]byte
	IDMACTRLR  volatile.Register32 // 0x50
	IDMABSIZER volatile.Register32 // 0x54
	IDMABASE0R volatile.Register32 // 0x58
	IDMABASE1R volatile.Register32 // 0x5C
	_          [32]byte
	FIFOR      volatile.Register32 // 0x80
	_          [880]byte
	VER        volatile.Register32 // 0x3F4
	ID         volatile.Register32 // 0x3F8
}

// SDMMC.POWER: SDMMC power control register
func (o *SDMMC_Type) SetPOWER_PWRCTRL(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x3)|value)
}
func (o *SDMMC_Type) GetPOWER_PWRCTRL() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x3
}
func (o *SDMMC_Type) SetPOWER_VSWITCH(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetPOWER_VSWITCH() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetPOWER_VSWITCHEN(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetPOWER_VSWITCHEN() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetPOWER_DIRPOL(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetPOWER_DIRPOL() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x10) >> 4
}

// SDMMC.CLKCR: The SDMMC_CLKCR register controls the SDMMC_CK output clock, the SDMMC_RX_CLK receive clock, and the bus width.
func (o *SDMMC_Type) SetCLKCR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x3ff)|value)
}
func (o *SDMMC_Type) GetCLKCR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.CLKCR.Reg) & 0x3ff
}
func (o *SDMMC_Type) SetCLKCR_PWRSAV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetCLKCR_PWRSAV() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetCLKCR_WIDBUS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0xc000)|value<<14)
}
func (o *SDMMC_Type) GetCLKCR_WIDBUS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0xc000) >> 14
}
func (o *SDMMC_Type) SetCLKCR_NEGEDGE(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetCLKCR_NEGEDGE() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetCLKCR_HWFC_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x20000)|value<<17)
}
func (o *SDMMC_Type) GetCLKCR_HWFC_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x20000) >> 17
}
func (o *SDMMC_Type) SetCLKCR_DDR(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x40000)|value<<18)
}
func (o *SDMMC_Type) GetCLKCR_DDR() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x40000) >> 18
}
func (o *SDMMC_Type) SetCLKCR_BUSSPEED(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x80000)|value<<19)
}
func (o *SDMMC_Type) GetCLKCR_BUSSPEED() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x80000) >> 19
}
func (o *SDMMC_Type) SetCLKCR_SELCLKRX(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x300000)|value<<20)
}
func (o *SDMMC_Type) GetCLKCR_SELCLKRX() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x300000) >> 20
}

// SDMMC.ARGR: The SDMMC_ARGR register contains a 32-bit command argument, which is sent to a card as part of a command message.
func (o *SDMMC_Type) SetARGR(value uint32) {
	volatile.StoreUint32(&o.ARGR.Reg, value)
}
func (o *SDMMC_Type) GetARGR() uint32 {
	return volatile.LoadUint32(&o.ARGR.Reg)
}

// SDMMC.CMDR: The SDMMC_CMDR register contains the command index and command type bits. The command index is sent to a card as part of a command message. The command type bits control the command path state machine (CPSM).
func (o *SDMMC_Type) SetCMDR_CMDINDEX(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3f)|value)
}
func (o *SDMMC_Type) GetCMDR_CMDINDEX() uint32 {
	return volatile.LoadUint32(&o.CMDR.Reg) & 0x3f
}
func (o *SDMMC_Type) SetCMDR_CMDTRANS(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetCMDR_CMDTRANS() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetCMDR_CMDSTOP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetCMDR_CMDSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetCMDR_WAITRESP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x300)|value<<8)
}
func (o *SDMMC_Type) GetCMDR_WAITRESP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x300) >> 8
}
func (o *SDMMC_Type) SetCMDR_WAITINT(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetCMDR_WAITINT() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetCMDR_WAITPEND(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetCMDR_WAITPEND() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetCMDR_CPSMEN(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetCMDR_CPSMEN() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetCMDR_DTHOLD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetCMDR_DTHOLD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetCMDR_BOOTMODE(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetCMDR_BOOTMODE() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetCMDR_BOOTEN(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x8000)|value<<15)
}
func (o *SDMMC_Type) GetCMDR_BOOTEN() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x8000) >> 15
}
func (o *SDMMC_Type) SetCMDR_CMDSUSPEND(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetCMDR_CMDSUSPEND() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x10000) >> 16
}

// SDMMC.RESPCMDR: SDMMC command response register
func (o *SDMMC_Type) SetRESPCMDR_RESPCMD(value uint32) {
	volatile.StoreUint32(&o.RESPCMDR.Reg, volatile.LoadUint32(&o.RESPCMDR.Reg)&^(0x3f)|value)
}
func (o *SDMMC_Type) GetRESPCMDR_RESPCMD() uint32 {
	return volatile.LoadUint32(&o.RESPCMDR.Reg) & 0x3f
}

// SDMMC.RESP1R: The SDMMC_RESP1/2/3/4R registers contain the status of a card, which is part of the received response.
func (o *SDMMC_Type) SetRESP1R(value uint32) {
	volatile.StoreUint32(&o.RESP1R.Reg, value)
}
func (o *SDMMC_Type) GetRESP1R() uint32 {
	return volatile.LoadUint32(&o.RESP1R.Reg)
}

// SDMMC.RESP2R: The SDMMC_RESP1/2/3/4R registers contain the status of a card, which is part of the received response.
func (o *SDMMC_Type) SetRESP2R(value uint32) {
	volatile.StoreUint32(&o.RESP2R.Reg, value)
}
func (o *SDMMC_Type) GetRESP2R() uint32 {
	return volatile.LoadUint32(&o.RESP2R.Reg)
}

// SDMMC.RESP3R: The SDMMC_RESP1/2/3/4R registers contain the status of a card, which is part of the received response.
func (o *SDMMC_Type) SetRESP3R(value uint32) {
	volatile.StoreUint32(&o.RESP3R.Reg, value)
}
func (o *SDMMC_Type) GetRESP3R() uint32 {
	return volatile.LoadUint32(&o.RESP3R.Reg)
}

// SDMMC.RESP4R: The SDMMC_RESP1/2/3/4R registers contain the status of a card, which is part of the received response.
func (o *SDMMC_Type) SetRESP4R(value uint32) {
	volatile.StoreUint32(&o.RESP4R.Reg, value)
}
func (o *SDMMC_Type) GetRESP4R() uint32 {
	return volatile.LoadUint32(&o.RESP4R.Reg)
}

// SDMMC.DTIMER: The SDMMC_DTIMER register contains the data timeout period, in card bus clock periods. A counter loads the value from the SDMMC_DTIMER register, and starts decrementing when the data path state machine (DPSM) enters the Wait_R or Busy state. If the timer reaches 0 while the DPSM is in either of these states, the timeout status flag is set.
func (o *SDMMC_Type) SetDTIMER(value uint32) {
	volatile.StoreUint32(&o.DTIMER.Reg, value)
}
func (o *SDMMC_Type) GetDTIMER() uint32 {
	return volatile.LoadUint32(&o.DTIMER.Reg)
}

// SDMMC.DLENR: The SDMMC_DLENR register contains the number of data bytes to be transferred. The value is loaded into the data counter when data transfer starts.
func (o *SDMMC_Type) SetDLENR_DATALENGTH(value uint32) {
	volatile.StoreUint32(&o.DLENR.Reg, volatile.LoadUint32(&o.DLENR.Reg)&^(0x1ffffff)|value)
}
func (o *SDMMC_Type) GetDLENR_DATALENGTH() uint32 {
	return volatile.LoadUint32(&o.DLENR.Reg) & 0x1ffffff
}

// SDMMC.DCTRL: The SDMMC_DCTRL register control the data path state machine (DPSM).
func (o *SDMMC_Type) SetDCTRL_DTEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetDCTRL_DTEN() uint32 {
	return volatile.LoadUint32(&o.DCTRL.Reg) & 0x1
}
func (o *SDMMC_Type) SetDCTRL_DTDIR(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetDCTRL_DTDIR() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetDCTRL_DTMODE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0xc)|value<<2)
}
func (o *SDMMC_Type) GetDCTRL_DTMODE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0xc) >> 2
}
func (o *SDMMC_Type) SetDCTRL_DBLOCKSIZE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0xf0)|value<<4)
}
func (o *SDMMC_Type) GetDCTRL_DBLOCKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0xf0) >> 4
}
func (o *SDMMC_Type) SetDCTRL_RWSTART(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetDCTRL_RWSTART() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetDCTRL_RWSTOP(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetDCTRL_RWSTOP() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetDCTRL_RWMOD(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetDCTRL_RWMOD() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetDCTRL_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetDCTRL_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetDCTRL_BOOTACKEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetDCTRL_BOOTACKEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetDCTRL_FIFORST(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetDCTRL_FIFORST() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x2000) >> 13
}

// SDMMC.DCNTR: The SDMMC_DCNTR register loads the value from the data length register (see SDMMC_DLENR) when the DPSM moves from the Idle state to the Wait_R or Wait_S state. As data is transferred, the counter decrements the value until it reaches 0. The DPSM then moves to the Idle state and when there has been no error, the data status end flag (DATAEND) is set.
func (o *SDMMC_Type) SetDCNTR_DATACOUNT(value uint32) {
	volatile.StoreUint32(&o.DCNTR.Reg, volatile.LoadUint32(&o.DCNTR.Reg)&^(0x1ffffff)|value)
}
func (o *SDMMC_Type) GetDCNTR_DATACOUNT() uint32 {
	return volatile.LoadUint32(&o.DCNTR.Reg) & 0x1ffffff
}

// SDMMC.STAR: The SDMMC_STAR register is a read-only register. It contains two types of flag:Static flags (bits [29,21,11:0]): these bits remain asserted until they are cleared by writing to the SDMMC interrupt Clear register (see SDMMC_ICR)Dynamic flags (bits [20:12]): these bits change state depending on the state of the underlying logic (for example, FIFO full and empty flags are asserted and de-asserted as data while written to the FIFO)
func (o *SDMMC_Type) SetSTAR_CCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetSTAR_CCRCFAIL() uint32 {
	return volatile.LoadUint32(&o.STAR.Reg) & 0x1
}
func (o *SDMMC_Type) SetSTAR_DCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetSTAR_DCRCFAIL() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetSTAR_CTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetSTAR_CTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetSTAR_DTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetSTAR_DTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetSTAR_TXUNDERR(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetSTAR_TXUNDERR() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetSTAR_RXOVERR(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetSTAR_RXOVERR() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetSTAR_CMDREND(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetSTAR_CMDREND() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetSTAR_CMDSENT(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetSTAR_CMDSENT() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetSTAR_DATAEND(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetSTAR_DATAEND() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetSTAR_DHOLD(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetSTAR_DHOLD() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetSTAR_DBCKEND(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetSTAR_DBCKEND() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetSTAR_DABORT(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetSTAR_DABORT() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetSTAR_DPSMACT(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetSTAR_DPSMACT() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetSTAR_CPSMACT(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetSTAR_CPSMACT() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetSTAR_TXFIFOHE(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetSTAR_TXFIFOHE() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetSTAR_RXFIFOHF(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x8000)|value<<15)
}
func (o *SDMMC_Type) GetSTAR_RXFIFOHF() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x8000) >> 15
}
func (o *SDMMC_Type) SetSTAR_TXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetSTAR_TXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetSTAR_RXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x20000)|value<<17)
}
func (o *SDMMC_Type) GetSTAR_RXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x20000) >> 17
}
func (o *SDMMC_Type) SetSTAR_TXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x40000)|value<<18)
}
func (o *SDMMC_Type) GetSTAR_TXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x40000) >> 18
}
func (o *SDMMC_Type) SetSTAR_RXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x80000)|value<<19)
}
func (o *SDMMC_Type) GetSTAR_RXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x80000) >> 19
}
func (o *SDMMC_Type) SetSTAR_BUSYD0(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x100000)|value<<20)
}
func (o *SDMMC_Type) GetSTAR_BUSYD0() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x100000) >> 20
}
func (o *SDMMC_Type) SetSTAR_BUSYD0END(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x200000)|value<<21)
}
func (o *SDMMC_Type) GetSTAR_BUSYD0END() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x200000) >> 21
}
func (o *SDMMC_Type) SetSTAR_SDIOIT(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x400000)|value<<22)
}
func (o *SDMMC_Type) GetSTAR_SDIOIT() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x400000) >> 22
}
func (o *SDMMC_Type) SetSTAR_ACKFAIL(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x800000)|value<<23)
}
func (o *SDMMC_Type) GetSTAR_ACKFAIL() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x800000) >> 23
}
func (o *SDMMC_Type) SetSTAR_ACKTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x1000000)|value<<24)
}
func (o *SDMMC_Type) GetSTAR_ACKTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x1000000) >> 24
}
func (o *SDMMC_Type) SetSTAR_VSWEND(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x2000000)|value<<25)
}
func (o *SDMMC_Type) GetSTAR_VSWEND() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x2000000) >> 25
}
func (o *SDMMC_Type) SetSTAR_CKSTOP(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x4000000)|value<<26)
}
func (o *SDMMC_Type) GetSTAR_CKSTOP() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x4000000) >> 26
}
func (o *SDMMC_Type) SetSTAR_IDMATE(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x8000000)|value<<27)
}
func (o *SDMMC_Type) GetSTAR_IDMATE() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x8000000) >> 27
}
func (o *SDMMC_Type) SetSTAR_IDMABTC(value uint32) {
	volatile.StoreUint32(&o.STAR.Reg, volatile.LoadUint32(&o.STAR.Reg)&^(0x10000000)|value<<28)
}
func (o *SDMMC_Type) GetSTAR_IDMABTC() uint32 {
	return (volatile.LoadUint32(&o.STAR.Reg) & 0x10000000) >> 28
}

// SDMMC.ICR: The SDMMC_ICR register is a write-only register. Writing a bit with 1 clears the corresponding bit in the SDMMC_STAR status register.
func (o *SDMMC_Type) SetICR_CCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetICR_CCRCFAILC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *SDMMC_Type) SetICR_DCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetICR_DCRCFAILC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetICR_CTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetICR_CTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetICR_DTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetICR_DTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetICR_TXUNDERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetICR_TXUNDERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetICR_RXOVERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetICR_RXOVERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetICR_CMDRENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetICR_CMDRENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetICR_CMDSENTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetICR_CMDSENTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetICR_DATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetICR_DATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetICR_DHOLDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetICR_DHOLDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetICR_DBCKENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetICR_DBCKENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetICR_DABORTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetICR_DABORTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetICR_BUSYD0ENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200000)|value<<21)
}
func (o *SDMMC_Type) GetICR_BUSYD0ENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200000) >> 21
}
func (o *SDMMC_Type) SetICR_SDIOITC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400000)|value<<22)
}
func (o *SDMMC_Type) GetICR_SDIOITC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400000) >> 22
}
func (o *SDMMC_Type) SetICR_ACKFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800000)|value<<23)
}
func (o *SDMMC_Type) GetICR_ACKFAILC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800000) >> 23
}
func (o *SDMMC_Type) SetICR_ACKTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000000)|value<<24)
}
func (o *SDMMC_Type) GetICR_ACKTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000000) >> 24
}
func (o *SDMMC_Type) SetICR_VSWENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000000)|value<<25)
}
func (o *SDMMC_Type) GetICR_VSWENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000000) >> 25
}
func (o *SDMMC_Type) SetICR_CKSTOPC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4000000)|value<<26)
}
func (o *SDMMC_Type) GetICR_CKSTOPC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4000000) >> 26
}
func (o *SDMMC_Type) SetICR_IDMATEC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8000000)|value<<27)
}
func (o *SDMMC_Type) GetICR_IDMATEC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8000000) >> 27
}
func (o *SDMMC_Type) SetICR_IDMABTCC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10000000)|value<<28)
}
func (o *SDMMC_Type) GetICR_IDMABTCC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10000000) >> 28
}

// SDMMC.MASKR: The interrupt mask register determines which status flags generate an interrupt request by setting the corresponding bit to 1.
func (o *SDMMC_Type) SetMASKR_CCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetMASKR_CCRCFAILIE() uint32 {
	return volatile.LoadUint32(&o.MASKR.Reg) & 0x1
}
func (o *SDMMC_Type) SetMASKR_DCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetMASKR_DCRCFAILIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetMASKR_CTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetMASKR_CTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetMASKR_DTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetMASKR_DTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetMASKR_TXUNDERRIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetMASKR_TXUNDERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetMASKR_RXOVERRIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetMASKR_RXOVERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetMASKR_CMDRENDIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetMASKR_CMDRENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetMASKR_CMDSENTIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetMASKR_CMDSENTIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetMASKR_DATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetMASKR_DATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetMASKR_DHOLDIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetMASKR_DHOLDIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetMASKR_DBCKENDIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetMASKR_DBCKENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetMASKR_DABORTIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetMASKR_DABORTIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetMASKR_TXFIFOHEIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetMASKR_TXFIFOHEIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetMASKR_RXFIFOHFIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x8000)|value<<15)
}
func (o *SDMMC_Type) GetMASKR_RXFIFOHFIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x8000) >> 15
}
func (o *SDMMC_Type) SetMASKR_RXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x20000)|value<<17)
}
func (o *SDMMC_Type) GetMASKR_RXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x20000) >> 17
}
func (o *SDMMC_Type) SetMASKR_TXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x40000)|value<<18)
}
func (o *SDMMC_Type) GetMASKR_TXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x40000) >> 18
}
func (o *SDMMC_Type) SetMASKR_BUSYD0ENDIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x200000)|value<<21)
}
func (o *SDMMC_Type) GetMASKR_BUSYD0ENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x200000) >> 21
}
func (o *SDMMC_Type) SetMASKR_SDIOITIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x400000)|value<<22)
}
func (o *SDMMC_Type) GetMASKR_SDIOITIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x400000) >> 22
}
func (o *SDMMC_Type) SetMASKR_ACKFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x800000)|value<<23)
}
func (o *SDMMC_Type) GetMASKR_ACKFAILIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x800000) >> 23
}
func (o *SDMMC_Type) SetMASKR_ACKTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x1000000)|value<<24)
}
func (o *SDMMC_Type) GetMASKR_ACKTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x1000000) >> 24
}
func (o *SDMMC_Type) SetMASKR_VSWENDIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x2000000)|value<<25)
}
func (o *SDMMC_Type) GetMASKR_VSWENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x2000000) >> 25
}
func (o *SDMMC_Type) SetMASKR_CKSTOPIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x4000000)|value<<26)
}
func (o *SDMMC_Type) GetMASKR_CKSTOPIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x4000000) >> 26
}
func (o *SDMMC_Type) SetMASKR_IDMABTCIE(value uint32) {
	volatile.StoreUint32(&o.MASKR.Reg, volatile.LoadUint32(&o.MASKR.Reg)&^(0x10000000)|value<<28)
}
func (o *SDMMC_Type) GetMASKR_IDMABTCIE() uint32 {
	return (volatile.LoadUint32(&o.MASKR.Reg) & 0x10000000) >> 28
}

// SDMMC.ACKTIMER: The SDMMC_ACKTIMER register contains the acknowledgment timeout period, in SDMMC_CK bus clock periods. A counter loads the value from the SDMMC_ACKTIMER register, and starts decrementing when the data path state machine (DPSM) enters the Wait_Ack state. If the timer reaches 0 while the DPSM is in this states, the acknowledgment timeout status flag is set.
func (o *SDMMC_Type) SetACKTIMER_ACKTIME(value uint32) {
	volatile.StoreUint32(&o.ACKTIMER.Reg, volatile.LoadUint32(&o.ACKTIMER.Reg)&^(0x1ffffff)|value)
}
func (o *SDMMC_Type) GetACKTIMER_ACKTIME() uint32 {
	return volatile.LoadUint32(&o.ACKTIMER.Reg) & 0x1ffffff
}

// SDMMC.IDMACTRLR: The receive and transmit FIFOs can be read or written as 32-bit wide registers. The FIFOs contain 32 entries on 32 sequential addresses. This allows the CPU to use its load and store multiple operands to read from/write to the FIFO.
func (o *SDMMC_Type) SetIDMACTRLR_IDMAEN(value uint32) {
	volatile.StoreUint32(&o.IDMACTRLR.Reg, volatile.LoadUint32(&o.IDMACTRLR.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetIDMACTRLR_IDMAEN() uint32 {
	return volatile.LoadUint32(&o.IDMACTRLR.Reg) & 0x1
}
func (o *SDMMC_Type) SetIDMACTRLR_IDMABMODE(value uint32) {
	volatile.StoreUint32(&o.IDMACTRLR.Reg, volatile.LoadUint32(&o.IDMACTRLR.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetIDMACTRLR_IDMABMODE() uint32 {
	return (volatile.LoadUint32(&o.IDMACTRLR.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetIDMACTRLR_IDMABACT(value uint32) {
	volatile.StoreUint32(&o.IDMACTRLR.Reg, volatile.LoadUint32(&o.IDMACTRLR.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetIDMACTRLR_IDMABACT() uint32 {
	return (volatile.LoadUint32(&o.IDMACTRLR.Reg) & 0x4) >> 2
}

// SDMMC.IDMABSIZER: The SDMMC_IDMABSIZER register contains the buffers size when in double buffer configuration.
func (o *SDMMC_Type) SetIDMABSIZER_IDMABNDT(value uint32) {
	volatile.StoreUint32(&o.IDMABSIZER.Reg, volatile.LoadUint32(&o.IDMABSIZER.Reg)&^(0x1fe0)|value<<5)
}
func (o *SDMMC_Type) GetIDMABSIZER_IDMABNDT() uint32 {
	return (volatile.LoadUint32(&o.IDMABSIZER.Reg) & 0x1fe0) >> 5
}

// SDMMC.IDMABASE0R: The SDMMC_IDMABASE0R register contains the memory buffer base address in single buffer configuration and the buffer 0 base address in double buffer configuration.
func (o *SDMMC_Type) SetIDMABASE0R(value uint32) {
	volatile.StoreUint32(&o.IDMABASE0R.Reg, value)
}
func (o *SDMMC_Type) GetIDMABASE0R() uint32 {
	return volatile.LoadUint32(&o.IDMABASE0R.Reg)
}

// SDMMC.IDMABASE1R: The SDMMC_IDMABASE1R register contains the double buffer configuration second buffer memory base address.
func (o *SDMMC_Type) SetIDMABASE1R(value uint32) {
	volatile.StoreUint32(&o.IDMABASE1R.Reg, value)
}
func (o *SDMMC_Type) GetIDMABASE1R() uint32 {
	return volatile.LoadUint32(&o.IDMABASE1R.Reg)
}

// SDMMC.FIFOR: The receive and transmit FIFOs can be only read or written as word (32-bit) wide registers. The FIFOs contain 16 entries on sequential addresses. This allows the CPU to use its load and store multiple operands to read from/write to the FIFO.When accessing SDMMC_FIFOR with half word or byte access an AHB bus fault is generated.
func (o *SDMMC_Type) SetFIFOR(value uint32) {
	volatile.StoreUint32(&o.FIFOR.Reg, value)
}
func (o *SDMMC_Type) GetFIFOR() uint32 {
	return volatile.LoadUint32(&o.FIFOR.Reg)
}

// SDMMC.VER: SDMMC IP version register
func (o *SDMMC_Type) SetVER_MINREV(value uint32) {
	volatile.StoreUint32(&o.VER.Reg, volatile.LoadUint32(&o.VER.Reg)&^(0xf)|value)
}
func (o *SDMMC_Type) GetVER_MINREV() uint32 {
	return volatile.LoadUint32(&o.VER.Reg) & 0xf
}
func (o *SDMMC_Type) SetVER_MAJREV(value uint32) {
	volatile.StoreUint32(&o.VER.Reg, volatile.LoadUint32(&o.VER.Reg)&^(0xf0)|value<<4)
}
func (o *SDMMC_Type) GetVER_MAJREV() uint32 {
	return (volatile.LoadUint32(&o.VER.Reg) & 0xf0) >> 4
}

// SDMMC.ID: SDMMC IP identification register
func (o *SDMMC_Type) SetID(value uint32) {
	volatile.StoreUint32(&o.ID.Reg, value)
}
func (o *SDMMC_Type) GetID() uint32 {
	return volatile.LoadUint32(&o.ID.Reg)
}

// VREFBUF
type VREFBUF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// VREFBUF.CSR: VREFBUF control and status register
func (o *VREFBUF_Type) SetCSR_ENVR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *VREFBUF_Type) GetCSR_ENVR() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *VREFBUF_Type) SetCSR_HIZ(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *VREFBUF_Type) GetCSR_HIZ() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *VREFBUF_Type) SetCSR_VRR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *VREFBUF_Type) GetCSR_VRR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *VREFBUF_Type) SetCSR_VRS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x70)|value<<4)
}
func (o *VREFBUF_Type) GetCSR_VRS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x70) >> 4
}

// VREFBUF.CCR: VREFBUF calibration control register
func (o *VREFBUF_Type) SetCCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3f)|value)
}
func (o *VREFBUF_Type) GetCCR_TRIM() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x3f
}

// IWDG
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_WVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *IWDG_Type) GetSR_WVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}

// IWDG.WINR: Window register
func (o *IWDG_Type) SetWINR_WIN(value uint32) {
	volatile.StoreUint32(&o.WINR.Reg, volatile.LoadUint32(&o.WINR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetWINR_WIN() uint32 {
	return volatile.LoadUint32(&o.WINR.Reg) & 0xfff
}

// WWDG
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x3800)|value<<11)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x3800) >> 11
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// PWR
type PWR_Type struct {
	CR1     volatile.Register32 // 0x0
	CSR1    volatile.Register32 // 0x4
	CR2     volatile.Register32 // 0x8
	CR3     volatile.Register32 // 0xC
	CPUCR   volatile.Register32 // 0x10
	_       [4]byte
	D3CR    volatile.Register32 // 0x18
	_       [4]byte
	WKUPCR  volatile.Register32 // 0x20
	WKUPFR  volatile.Register32 // 0x24
	WKUPEPR volatile.Register32 // 0x28
}

// PWR.CR1: PWR control register 1
func (o *PWR_Type) SetCR1_LPDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR1_LPDS() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *PWR_Type) SetCR1_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR1_PVDE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR1_PLS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe0)|value<<5)
}
func (o *PWR_Type) GetCR1_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe0) >> 5
}
func (o *PWR_Type) SetCR1_DBP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR1_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR1_FLPS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR1_FLPS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR1_SVOS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc000)|value<<14)
}
func (o *PWR_Type) GetCR1_SVOS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc000) >> 14
}
func (o *PWR_Type) SetCR1_AVDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWR_Type) GetCR1_AVDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *PWR_Type) SetCR1_ALS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60000)|value<<17)
}
func (o *PWR_Type) GetCR1_ALS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60000) >> 17
}

// PWR.CSR1: PWR control status register 1
func (o *PWR_Type) SetCSR1_PVDO(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCSR1_PVDO() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCSR1_ACTVOSRDY(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCSR1_ACTVOSRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetCSR1_ACTVOS(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0xc000)|value<<14)
}
func (o *PWR_Type) GetCSR1_ACTVOS() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0xc000) >> 14
}
func (o *PWR_Type) SetCSR1_AVDO(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWR_Type) GetCSR1_AVDO() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x10000) >> 16
}

// PWR.CR2: This register is not reset by wakeup from Standby mode, RESET signal and VDD POR. It is only reset by VSW POR and VSWRST reset. This register shall not be accessed when VSWRST bit in RCC_BDCR register resets the VSW domain.After reset, PWR_CR2 register is write-protected. Prior to modifying its content, the DBP bit in PWR_CR1 register must be set to disable the write protection.
func (o *PWR_Type) SetCR2_BREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR2_BREN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *PWR_Type) SetCR2_MONEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR2_MONEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR2_BRRDY(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWR_Type) GetCR2_BRRDY() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *PWR_Type) SetCR2_VBATL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWR_Type) GetCR2_VBATL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100000) >> 20
}
func (o *PWR_Type) SetCR2_VBATH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWR_Type) GetCR2_VBATH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200000) >> 21
}
func (o *PWR_Type) SetCR2_TEMPL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWR_Type) GetCR2_TEMPL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400000) >> 22
}
func (o *PWR_Type) SetCR2_TEMPH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWR_Type) GetCR2_TEMPH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}

// PWR.CR3: Reset only by POR only, not reset by wakeup from Standby mode and RESET pad. The lower byte of this register is written once after POR and shall be written before changing VOS level or ck_sys clock frequency. No limitation applies to the upper bytes.Programming data corresponding to an invalid combination of SDLEVEL, SDEXTHP, SDEN, LDOEN and BYPASS bits (see Table9) will be ignored: data will not be written, the written-once mechanism will lock the register and any further write access will be ignored. The default supply configuration will be kept and the ACTVOSRDY bit in PWR control status register 1 (PWR_CSR1) will go on indicating invalid voltage levels. The system shall be power cycled before writing a new value.
func (o *PWR_Type) SetCR3_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR3_BYPASS() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}
func (o *PWR_Type) SetCR3_LDOEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR3_LDOEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR3_SCUEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR3_SCUEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR3_VBE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR3_VBE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR3_VBRS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR3_VBRS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR3_USB33DEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000000)|value<<24)
}
func (o *PWR_Type) GetCR3_USB33DEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000000) >> 24
}
func (o *PWR_Type) SetCR3_USBREGEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000000)|value<<25)
}
func (o *PWR_Type) GetCR3_USBREGEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000000) >> 25
}
func (o *PWR_Type) SetCR3_USB33RDY(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000000)|value<<26)
}
func (o *PWR_Type) GetCR3_USB33RDY() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000000) >> 26
}

// PWR.CPUCR: This register allows controlling CPU1 power.
func (o *PWR_Type) SetCPUCR_PDDS_D1(value uint32) {
	volatile.StoreUint32(&o.CPUCR.Reg, volatile.LoadUint32(&o.CPUCR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCPUCR_PDDS_D1() uint32 {
	return volatile.LoadUint32(&o.CPUCR.Reg) & 0x1
}
func (o *PWR_Type) SetCPUCR_PDDS_D2(value uint32) {
	volatile.StoreUint32(&o.CPUCR.Reg, volatile.LoadUint32(&o.CPUCR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCPUCR_PDDS_D2() uint32 {
	return (volatile.LoadUint32(&o.CPUCR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCPUCR_PDDS_D3(value uint32) {
	volatile.StoreUint32(&o.CPUCR.Reg, volatile.LoadUint32(&o.CPUCR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCPUCR_PDDS_D3() uint32 {
	return (volatile.LoadUint32(&o.CPUCR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCPUCR_STOPF(value uint32) {
	volatile.StoreUint32(&o.CPUCR.Reg, volatile.LoadUint32(&o.CPUCR.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCPUCR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.CPUCR.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCPUCR_SBF(value uint32) {
	volatile.StoreUint32(&o.CPUCR.Reg, volatile.LoadUint32(&o.CPUCR.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetCPUCR_SBF() uint32 {
	return (volatile.LoadUint32(&o.CPUCR.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetCPUCR_SBF_D1(value uint32) {
	volatile.StoreUint32(&o.CPUCR.Reg, volatile.LoadUint32(&o.CPUCR.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetCPUCR_SBF_D1() uint32 {
	return (volatile.LoadUint32(&o.CPUCR.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetCPUCR_SBF_D2(value uint32) {
	volatile.StoreUint32(&o.CPUCR.Reg, volatile.LoadUint32(&o.CPUCR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCPUCR_SBF_D2() uint32 {
	return (volatile.LoadUint32(&o.CPUCR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCPUCR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CPUCR.Reg, volatile.LoadUint32(&o.CPUCR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCPUCR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CPUCR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCPUCR_RUN_D3(value uint32) {
	volatile.StoreUint32(&o.CPUCR.Reg, volatile.LoadUint32(&o.CPUCR.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCPUCR_RUN_D3() uint32 {
	return (volatile.LoadUint32(&o.CPUCR.Reg) & 0x800) >> 11
}

// PWR.D3CR: This register allows controlling D3 domain power.Following reset VOSRDY will be read 1 by software
func (o *PWR_Type) SetD3CR_VOSRDY(value uint32) {
	volatile.StoreUint32(&o.D3CR.Reg, volatile.LoadUint32(&o.D3CR.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetD3CR_VOSRDY() uint32 {
	return (volatile.LoadUint32(&o.D3CR.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetD3CR_VOS(value uint32) {
	volatile.StoreUint32(&o.D3CR.Reg, volatile.LoadUint32(&o.D3CR.Reg)&^(0xc000)|value<<14)
}
func (o *PWR_Type) GetD3CR_VOS() uint32 {
	return (volatile.LoadUint32(&o.D3CR.Reg) & 0xc000) >> 14
}

// PWR.WKUPCR: reset only by system reset, not reset by wakeup from Standby mode5 wait states are required when writing this register (when clearing a WKUPF bit in PWR_WKUPFR, the AHB write access will complete after the WKUPF has been cleared).
func (o *PWR_Type) SetWKUPCR_WKUPC(value uint32) {
	volatile.StoreUint32(&o.WKUPCR.Reg, volatile.LoadUint32(&o.WKUPCR.Reg)&^(0x3f)|value)
}
func (o *PWR_Type) GetWKUPCR_WKUPC() uint32 {
	return volatile.LoadUint32(&o.WKUPCR.Reg) & 0x3f
}

// PWR.WKUPFR: reset only by system reset, not reset by wakeup from Standby mode
func (o *PWR_Type) SetWKUPFR_WKUPF1(value uint32) {
	volatile.StoreUint32(&o.WKUPFR.Reg, volatile.LoadUint32(&o.WKUPFR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetWKUPFR_WKUPF1() uint32 {
	return volatile.LoadUint32(&o.WKUPFR.Reg) & 0x1
}
func (o *PWR_Type) SetWKUPFR_WKUPF2(value uint32) {
	volatile.StoreUint32(&o.WKUPFR.Reg, volatile.LoadUint32(&o.WKUPFR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetWKUPFR_WKUPF2() uint32 {
	return (volatile.LoadUint32(&o.WKUPFR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetWKUPFR_WKUPF3(value uint32) {
	volatile.StoreUint32(&o.WKUPFR.Reg, volatile.LoadUint32(&o.WKUPFR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetWKUPFR_WKUPF3() uint32 {
	return (volatile.LoadUint32(&o.WKUPFR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetWKUPFR_WKUPF4(value uint32) {
	volatile.StoreUint32(&o.WKUPFR.Reg, volatile.LoadUint32(&o.WKUPFR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetWKUPFR_WKUPF4() uint32 {
	return (volatile.LoadUint32(&o.WKUPFR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetWKUPFR_WKUPF5(value uint32) {
	volatile.StoreUint32(&o.WKUPFR.Reg, volatile.LoadUint32(&o.WKUPFR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetWKUPFR_WKUPF5() uint32 {
	return (volatile.LoadUint32(&o.WKUPFR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetWKUPFR_WKUPF6(value uint32) {
	volatile.StoreUint32(&o.WKUPFR.Reg, volatile.LoadUint32(&o.WKUPFR.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetWKUPFR_WKUPF6() uint32 {
	return (volatile.LoadUint32(&o.WKUPFR.Reg) & 0x20) >> 5
}

// PWR.WKUPEPR: Reset only by system reset, not reset by wakeup from Standby mode
func (o *PWR_Type) SetWKUPEPR_WKUPEN1(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetWKUPEPR_WKUPEN1() uint32 {
	return volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x1
}
func (o *PWR_Type) SetWKUPEPR_WKUPEN2(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetWKUPEPR_WKUPEN2() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetWKUPEPR_WKUPEN3(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetWKUPEPR_WKUPEN3() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetWKUPEPR_WKUPEN4(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetWKUPEPR_WKUPEN4() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetWKUPEPR_WKUPEN5(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetWKUPEPR_WKUPEN5() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetWKUPEPR_WKUPEN6(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetWKUPEPR_WKUPEN6() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetWKUPEPR_WKUPP1(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetWKUPEPR_WKUPP1() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetWKUPEPR_WKUPP2(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetWKUPEPR_WKUPP2() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetWKUPEPR_WKUPP3(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetWKUPEPR_WKUPP3() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetWKUPEPR_WKUPP4(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetWKUPEPR_WKUPP4() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetWKUPEPR_WKUPP5(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetWKUPEPR_WKUPP5() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetWKUPEPR_WKUPP6(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetWKUPEPR_WKUPP6() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetWKUPEPR_WKUPPUPD1(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x30000)|value<<16)
}
func (o *PWR_Type) GetWKUPEPR_WKUPPUPD1() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x30000) >> 16
}
func (o *PWR_Type) SetWKUPEPR_WKUPPUPD2(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0xc0000)|value<<18)
}
func (o *PWR_Type) GetWKUPEPR_WKUPPUPD2() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0xc0000) >> 18
}
func (o *PWR_Type) SetWKUPEPR_WKUPPUPD3(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x300000)|value<<20)
}
func (o *PWR_Type) GetWKUPEPR_WKUPPUPD3() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x300000) >> 20
}
func (o *PWR_Type) SetWKUPEPR_WKUPPUPD4(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0xc00000)|value<<22)
}
func (o *PWR_Type) GetWKUPEPR_WKUPPUPD4() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0xc00000) >> 22
}
func (o *PWR_Type) SetWKUPEPR_WKUPPUPD5(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0x3000000)|value<<24)
}
func (o *PWR_Type) GetWKUPEPR_WKUPPUPD5() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0x3000000) >> 24
}
func (o *PWR_Type) SetWKUPEPR_WKUPPUPD6(value uint32) {
	volatile.StoreUint32(&o.WKUPEPR.Reg, volatile.LoadUint32(&o.WKUPEPR.Reg)&^(0xc000000)|value<<26)
}
func (o *PWR_Type) GetWKUPEPR_WKUPPUPD6() uint32 {
	return (volatile.LoadUint32(&o.WKUPEPR.Reg) & 0xc000000) >> 26
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	CFG1    volatile.Register32 // 0x8
	CFG2    volatile.Register32 // 0xC
	IER     volatile.Register32 // 0x10
	SR      volatile.Register32 // 0x14
	IFCR    volatile.Register32 // 0x18
	_       [4]byte
	TXDR    volatile.Register32 // 0x20
	_       [12]byte
	RXDR    volatile.Register32 // 0x30
	_       [12]byte
	CRCPOLY volatile.Register32 // 0x40
	TXCRC   volatile.Register32 // 0x44
	RXCRC   volatile.Register32 // 0x48
	UDRDR   volatile.Register32 // 0x4C
	I2SCFGR volatile.Register32 // 0x50
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_IOLOCK(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetCR1_IOLOCK() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *SPI_Type) SetCR1_TCRCINI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_TCRCINI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_RCRCINI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_RCRCINI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRC33_17(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRC33_17() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_HDDIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_HDDIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_CSUSP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_CSUSP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_CSTART(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_CSTART() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_MASRX(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_MASRX() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_TSER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetCR2_TSER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xffff0000) >> 16
}
func (o *SPI_Type) SetCR2_TSIZE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCR2_TSIZE() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0xffff
}

// SPI.CFG1: configuration register 1
func (o *SPI_Type) SetCFG1_MBR(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x70000000)|value<<28)
}
func (o *SPI_Type) GetCFG1_MBR() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x70000000) >> 28
}
func (o *SPI_Type) SetCFG1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x400000)|value<<22)
}
func (o *SPI_Type) GetCFG1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x400000) >> 22
}
func (o *SPI_Type) SetCFG1_CRCSIZE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1f0000)|value<<16)
}
func (o *SPI_Type) GetCFG1_CRCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x1f0000) >> 16
}
func (o *SPI_Type) SetCFG1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCFG1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCFG1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCFG1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCFG1_UDRDET(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1800)|value<<11)
}
func (o *SPI_Type) GetCFG1_UDRDET() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x1800) >> 11
}
func (o *SPI_Type) SetCFG1_UDRCFG(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x600)|value<<9)
}
func (o *SPI_Type) GetCFG1_UDRCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x600) >> 9
}
func (o *SPI_Type) SetCFG1_FTHLV(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1e0)|value<<5)
}
func (o *SPI_Type) GetCFG1_FTHLV() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x1e0) >> 5
}
func (o *SPI_Type) SetCFG1_DSIZE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1f)|value)
}
func (o *SPI_Type) GetCFG1_DSIZE() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0x1f
}

// SPI.CFG2: configuration register 2
func (o *SPI_Type) SetCFG2_AFCNTR(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetCFG2_AFCNTR() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x80000000) >> 31
}
func (o *SPI_Type) SetCFG2_SSOM(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI_Type) GetCFG2_SSOM() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x40000000) >> 30
}
func (o *SPI_Type) SetCFG2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x20000000)|value<<29)
}
func (o *SPI_Type) GetCFG2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x20000000) >> 29
}
func (o *SPI_Type) SetCFG2_SSIOP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI_Type) GetCFG2_SSIOP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10000000) >> 28
}
func (o *SPI_Type) SetCFG2_SSM(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetCFG2_SSM() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetCFG2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetCFG2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetCFG2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCFG2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetCFG2_LSBFRST(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x800000)|value<<23)
}
func (o *SPI_Type) GetCFG2_LSBFRST() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x800000) >> 23
}
func (o *SPI_Type) SetCFG2_MASTER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x400000)|value<<22)
}
func (o *SPI_Type) GetCFG2_MASTER() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x400000) >> 22
}
func (o *SPI_Type) SetCFG2_SP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x380000)|value<<19)
}
func (o *SPI_Type) GetCFG2_SP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x380000) >> 19
}
func (o *SPI_Type) SetCFG2_COMM(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x60000)|value<<17)
}
func (o *SPI_Type) GetCFG2_COMM() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x60000) >> 17
}
func (o *SPI_Type) SetCFG2_IOSWP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCFG2_IOSWP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCFG2_MIDI(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCFG2_MIDI() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCFG2_MSSI(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetCFG2_MSSI() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0xf
}

// SPI.IER: Interrupt Enable Register
func (o *SPI_Type) SetIER_TSERFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIER_TSERFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetIER_MODFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIER_MODFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIER_TIFREIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIER_TIFREIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIER_CRCEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIER_CRCEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIER_OVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetIER_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetIER_UDRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetIER_UDRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetIER_TXTFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetIER_TXTFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetIER_EOTIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIER_EOTIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIER_DXPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIER_DXPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIER_TXPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIER_TXPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIER_RXPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIER_RXPIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_CTSIZE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetSR_CTSIZE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xffff0000) >> 16
}
func (o *SPI_Type) SetSR_RXWNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetSR_RXWNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetSR_RXPLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x6000)|value<<13)
}
func (o *SPI_Type) GetSR_RXPLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x6000) >> 13
}
func (o *SPI_Type) SetSR_TXC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetSR_TXC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetSR_SUSP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetSR_SUSP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetSR_TSERF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetSR_TSERF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetSR_TIFRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_TIFRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_CRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_CRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_TXTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_TXTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_EOT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_EOT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_DXP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_DXP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_TXP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_RXP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// SPI.IFCR: Interrupt/Status Flags Clear Register
func (o *SPI_Type) SetIFCR_SUSPC(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetIFCR_SUSPC() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetIFCR_TSERFC(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIFCR_TSERFC() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetIFCR_MODFC(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIFCR_MODFC() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIFCR_TIFREC(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIFCR_TIFREC() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIFCR_CRCEC(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIFCR_CRCEC() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIFCR_OVRC(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetIFCR_OVRC() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetIFCR_UDRC(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetIFCR_UDRC() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetIFCR_TXTFC(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetIFCR_TXTFC() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetIFCR_EOTC(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIFCR_EOTC() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}

// SPI.TXDR: Transmit Data Register
func (o *SPI_Type) SetTXDR(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, value)
}
func (o *SPI_Type) GetTXDR() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg)
}

// SPI.RXDR: Receive Data Register
func (o *SPI_Type) SetRXDR(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, value)
}
func (o *SPI_Type) GetRXDR() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg)
}

// SPI.CRCPOLY: Polynomial Register
func (o *SPI_Type) SetCRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPOLY.Reg, value)
}
func (o *SPI_Type) GetCRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPOLY.Reg)
}

// SPI.TXCRC: Transmitter CRC Register
func (o *SPI_Type) SetTXCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRC.Reg, value)
}
func (o *SPI_Type) GetTXCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRC.Reg)
}

// SPI.RXCRC: Receiver CRC Register
func (o *SPI_Type) SetRXCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRC.Reg, value)
}
func (o *SPI_Type) GetRXCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRC.Reg)
}

// SPI.UDRDR: Underrun Data Register
func (o *SPI_Type) SetUDRDR(value uint32) {
	volatile.StoreUint32(&o.UDRDR.Reg, value)
}
func (o *SPI_Type) GetUDRDR() uint32 {
	return volatile.LoadUint32(&o.UDRDR.Reg)
}

// SPI.I2SCFGR: configuration register
func (o *SPI_Type) SetI2SCFGR_MCKOE(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetI2SCFGR_MCKOE() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetI2SCFGR_ODD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetI2SCFGR_ODD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetI2SCFGR_I2SDIV(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0xff0000)|value<<16)
}
func (o *SPI_Type) GetI2SCFGR_I2SDIV() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0xff0000) >> 16
}
func (o *SPI_Type) SetI2SCFGR_DATFMT(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetI2SCFGR_DATFMT() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetI2SCFGR_WSINV(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetI2SCFGR_WSINV() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetI2SCFGR_FIXCH(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetI2SCFGR_FIXCH() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetI2SCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetI2SCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetI2SCFGR_CHLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetI2SCFGR_CHLEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetI2SCFGR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetI2SCFGR_DATLEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetI2SCFGR_PCMSYNC(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetI2SCFGR_PCMSYNC() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetI2SCFGR_I2SSTD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x30)|value<<4)
}
func (o *SPI_Type) GetI2SCFGR_I2SSTD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x30) >> 4
}
func (o *SPI_Type) SetI2SCFGR_I2SCFG(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0xe)|value<<1)
}
func (o *SPI_Type) GetI2SCFGR_I2SCFG() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0xe) >> 1
}
func (o *SPI_Type) SetI2SCFGR_I2SMOD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetI2SCFGR_I2SMOD() uint32 {
	return volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1
}

// LCD-TFT Controller
type LTDC_Type struct {
	_     [8]byte
	SSCR  volatile.Register32 // 0x8
	BPCR  volatile.Register32 // 0xC
	AWCR  volatile.Register32 // 0x10
	TWCR  volatile.Register32 // 0x14
	GCR   volatile.Register32 // 0x18
	_     [8]byte
	SRCR  volatile.Register32 // 0x24
	_     [4]byte
	BCCR  volatile.Register32 // 0x2C
	_     [4]byte
	IER   volatile.Register32 // 0x34
	ISR   volatile.Register32 // 0x38
	ICR   volatile.Register32 // 0x3C
	LIPCR volatile.Register32 // 0x40
	CPSR  volatile.Register32 // 0x44
	CDSR  volatile.Register32 // 0x48
	_     [56]byte
	LAYER [2]LTDC_LAYER_Type // 0x84
}

// LTDC.SSCR: Synchronization Size Configuration Register
func (o *LTDC_Type) SetSSCR_HSW(value uint32) {
	volatile.StoreUint32(&o.SSCR.Reg, volatile.LoadUint32(&o.SSCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetSSCR_HSW() uint32 {
	return (volatile.LoadUint32(&o.SSCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetSSCR_VSH(value uint32) {
	volatile.StoreUint32(&o.SSCR.Reg, volatile.LoadUint32(&o.SSCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetSSCR_VSH() uint32 {
	return volatile.LoadUint32(&o.SSCR.Reg) & 0x7ff
}

// LTDC.BPCR: Back Porch Configuration Register
func (o *LTDC_Type) SetBPCR_AHBP(value uint32) {
	volatile.StoreUint32(&o.BPCR.Reg, volatile.LoadUint32(&o.BPCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetBPCR_AHBP() uint32 {
	return (volatile.LoadUint32(&o.BPCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetBPCR_AVBP(value uint32) {
	volatile.StoreUint32(&o.BPCR.Reg, volatile.LoadUint32(&o.BPCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetBPCR_AVBP() uint32 {
	return volatile.LoadUint32(&o.BPCR.Reg) & 0x7ff
}

// LTDC.AWCR: Active Width Configuration Register
func (o *LTDC_Type) SetAWCR_AAW(value uint32) {
	volatile.StoreUint32(&o.AWCR.Reg, volatile.LoadUint32(&o.AWCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetAWCR_AAW() uint32 {
	return (volatile.LoadUint32(&o.AWCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetAWCR_AAH(value uint32) {
	volatile.StoreUint32(&o.AWCR.Reg, volatile.LoadUint32(&o.AWCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetAWCR_AAH() uint32 {
	return volatile.LoadUint32(&o.AWCR.Reg) & 0x7ff
}

// LTDC.TWCR: Total Width Configuration Register
func (o *LTDC_Type) SetTWCR_TOTALW(value uint32) {
	volatile.StoreUint32(&o.TWCR.Reg, volatile.LoadUint32(&o.TWCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetTWCR_TOTALW() uint32 {
	return (volatile.LoadUint32(&o.TWCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetTWCR_TOTALH(value uint32) {
	volatile.StoreUint32(&o.TWCR.Reg, volatile.LoadUint32(&o.TWCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetTWCR_TOTALH() uint32 {
	return volatile.LoadUint32(&o.TWCR.Reg) & 0x7ff
}

// LTDC.GCR: Global Control Register
func (o *LTDC_Type) SetGCR_HSPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x80000000)|value<<31)
}
func (o *LTDC_Type) GetGCR_HSPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x80000000) >> 31
}
func (o *LTDC_Type) SetGCR_VSPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x40000000)|value<<30)
}
func (o *LTDC_Type) GetGCR_VSPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x40000000) >> 30
}
func (o *LTDC_Type) SetGCR_DEPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x20000000)|value<<29)
}
func (o *LTDC_Type) GetGCR_DEPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x20000000) >> 29
}
func (o *LTDC_Type) SetGCR_PCPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x10000000)|value<<28)
}
func (o *LTDC_Type) GetGCR_PCPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x10000000) >> 28
}
func (o *LTDC_Type) SetGCR_DEN(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x10000)|value<<16)
}
func (o *LTDC_Type) GetGCR_DEN() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x10000) >> 16
}
func (o *LTDC_Type) SetGCR_DRW(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x7000)|value<<12)
}
func (o *LTDC_Type) GetGCR_DRW() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x7000) >> 12
}
func (o *LTDC_Type) SetGCR_DGW(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x700)|value<<8)
}
func (o *LTDC_Type) GetGCR_DGW() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x700) >> 8
}
func (o *LTDC_Type) SetGCR_DBW(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x70)|value<<4)
}
func (o *LTDC_Type) GetGCR_DBW() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x70) >> 4
}
func (o *LTDC_Type) SetGCR_LTDCEN(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetGCR_LTDCEN() uint32 {
	return volatile.LoadUint32(&o.GCR.Reg) & 0x1
}

// LTDC.SRCR: Shadow Reload Configuration Register
func (o *LTDC_Type) SetSRCR_VBR(value uint32) {
	volatile.StoreUint32(&o.SRCR.Reg, volatile.LoadUint32(&o.SRCR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetSRCR_VBR() uint32 {
	return (volatile.LoadUint32(&o.SRCR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetSRCR_IMR(value uint32) {
	volatile.StoreUint32(&o.SRCR.Reg, volatile.LoadUint32(&o.SRCR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetSRCR_IMR() uint32 {
	return volatile.LoadUint32(&o.SRCR.Reg) & 0x1
}

// LTDC.BCCR: Background Color Configuration Register
func (o *LTDC_Type) SetBCCR_BCBLUE(value uint32) {
	volatile.StoreUint32(&o.BCCR.Reg, volatile.LoadUint32(&o.BCCR.Reg)&^(0xff)|value)
}
func (o *LTDC_Type) GetBCCR_BCBLUE() uint32 {
	return volatile.LoadUint32(&o.BCCR.Reg) & 0xff
}
func (o *LTDC_Type) SetBCCR_BCGREEN(value uint32) {
	volatile.StoreUint32(&o.BCCR.Reg, volatile.LoadUint32(&o.BCCR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_Type) GetBCCR_BCGREEN() uint32 {
	return (volatile.LoadUint32(&o.BCCR.Reg) & 0xff00) >> 8
}
func (o *LTDC_Type) SetBCCR_BCRED(value uint32) {
	volatile.StoreUint32(&o.BCCR.Reg, volatile.LoadUint32(&o.BCCR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_Type) GetBCCR_BCRED() uint32 {
	return (volatile.LoadUint32(&o.BCCR.Reg) & 0xff0000) >> 16
}

// LTDC.IER: Interrupt Enable Register
func (o *LTDC_Type) SetIER_RRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetIER_RRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetIER_TERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetIER_TERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetIER_FUIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetIER_FUIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetIER_LIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetIER_LIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LTDC.ISR: Interrupt Status Register
func (o *LTDC_Type) SetISR_RRIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetISR_RRIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetISR_TERRIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetISR_TERRIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetISR_FUIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetISR_FUIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetISR_LIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetISR_LIF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LTDC.ICR: Interrupt Clear Register
func (o *LTDC_Type) SetICR_CRRIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetICR_CRRIF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetICR_CTERRIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetICR_CTERRIF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetICR_CFUIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetICR_CFUIF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetICR_CLIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetICR_CLIF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LTDC.LIPCR: Line Interrupt Position Configuration Register
func (o *LTDC_Type) SetLIPCR_LIPOS(value uint32) {
	volatile.StoreUint32(&o.LIPCR.Reg, volatile.LoadUint32(&o.LIPCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetLIPCR_LIPOS() uint32 {
	return volatile.LoadUint32(&o.LIPCR.Reg) & 0x7ff
}

// LTDC.CPSR: Current Position Status Register
func (o *LTDC_Type) SetCPSR_CXPOS(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xffff0000)|value<<16)
}
func (o *LTDC_Type) GetCPSR_CXPOS() uint32 {
	return (volatile.LoadUint32(&o.CPSR.Reg) & 0xffff0000) >> 16
}
func (o *LTDC_Type) SetCPSR_CYPOS(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xffff)|value)
}
func (o *LTDC_Type) GetCPSR_CYPOS() uint32 {
	return volatile.LoadUint32(&o.CPSR.Reg) & 0xffff
}

// LTDC.CDSR: Current Display Status Register
func (o *LTDC_Type) SetCDSR_HSYNCS(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetCDSR_HSYNCS() uint32 {
	return (volatile.LoadUint32(&o.CDSR.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetCDSR_VSYNCS(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetCDSR_VSYNCS() uint32 {
	return (volatile.LoadUint32(&o.CDSR.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetCDSR_HDES(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetCDSR_HDES() uint32 {
	return (volatile.LoadUint32(&o.CDSR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetCDSR_VDES(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetCDSR_VDES() uint32 {
	return volatile.LoadUint32(&o.CDSR.Reg) & 0x1
}

type LTDC_LAYER_Type struct {
	CR     volatile.Register32 // 0x84
	WHPCR  volatile.Register32 // 0x88
	WVPCR  volatile.Register32 // 0x8C
	CKCR   volatile.Register32 // 0x90
	PFCR   volatile.Register32 // 0x94
	CACR   volatile.Register32 // 0x98
	DCCR   volatile.Register32 // 0x9C
	BFCR   volatile.Register32 // 0xA0
	_      [8]byte
	CFBAR  volatile.Register32 // 0xAC
	CFBLR  volatile.Register32 // 0xB0
	CFBLNR volatile.Register32 // 0xB4
	_      [12]byte
	CLUTWR volatile.Register32 // 0xC4
	_      [60]byte
}

// LTDC_LAYER.CR: Layerx Control Register
func (o *LTDC_LAYER_Type) SetCR_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *LTDC_LAYER_Type) GetCR_CLUTEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *LTDC_LAYER_Type) SetCR_COLKEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_LAYER_Type) GetCR_COLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LTDC_LAYER_Type) SetCR_LEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LTDC_LAYER_Type) GetCR_LEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// LTDC_LAYER.WHPCR: Layerx Window Horizontal Position Configuration Register
func (o *LTDC_LAYER_Type) SetWHPCR_WHSPPOS(value uint32) {
	volatile.StoreUint32(&o.WHPCR.Reg, volatile.LoadUint32(&o.WHPCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetWHPCR_WHSPPOS() uint32 {
	return (volatile.LoadUint32(&o.WHPCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetWHPCR_WHSTPOS(value uint32) {
	volatile.StoreUint32(&o.WHPCR.Reg, volatile.LoadUint32(&o.WHPCR.Reg)&^(0xfff)|value)
}
func (o *LTDC_LAYER_Type) GetWHPCR_WHSTPOS() uint32 {
	return volatile.LoadUint32(&o.WHPCR.Reg) & 0xfff
}

// LTDC_LAYER.WVPCR: Layerx Window Vertical Position Configuration Register
func (o *LTDC_LAYER_Type) SetWVPCR_WVSPPOS(value uint32) {
	volatile.StoreUint32(&o.WVPCR.Reg, volatile.LoadUint32(&o.WVPCR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetWVPCR_WVSPPOS() uint32 {
	return (volatile.LoadUint32(&o.WVPCR.Reg) & 0x7ff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetWVPCR_WVSTPOS(value uint32) {
	volatile.StoreUint32(&o.WVPCR.Reg, volatile.LoadUint32(&o.WVPCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_LAYER_Type) GetWVPCR_WVSTPOS() uint32 {
	return volatile.LoadUint32(&o.WVPCR.Reg) & 0x7ff
}

// LTDC_LAYER.CKCR: Layerx Color Keying Configuration Register
func (o *LTDC_LAYER_Type) SetCKCR_CKRED(value uint32) {
	volatile.StoreUint32(&o.CKCR.Reg, volatile.LoadUint32(&o.CKCR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetCKCR_CKRED() uint32 {
	return (volatile.LoadUint32(&o.CKCR.Reg) & 0xff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetCKCR_CKGREEN(value uint32) {
	volatile.StoreUint32(&o.CKCR.Reg, volatile.LoadUint32(&o.CKCR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_LAYER_Type) GetCKCR_CKGREEN() uint32 {
	return (volatile.LoadUint32(&o.CKCR.Reg) & 0xff00) >> 8
}
func (o *LTDC_LAYER_Type) SetCKCR_CKBLUE(value uint32) {
	volatile.StoreUint32(&o.CKCR.Reg, volatile.LoadUint32(&o.CKCR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetCKCR_CKBLUE() uint32 {
	return volatile.LoadUint32(&o.CKCR.Reg) & 0xff
}

// LTDC_LAYER.PFCR: Layerx Pixel Format Configuration Register
func (o *LTDC_LAYER_Type) SetPFCR_PF(value uint32) {
	volatile.StoreUint32(&o.PFCR.Reg, volatile.LoadUint32(&o.PFCR.Reg)&^(0x7)|value)
}
func (o *LTDC_LAYER_Type) GetPFCR_PF() uint32 {
	return volatile.LoadUint32(&o.PFCR.Reg) & 0x7
}

// LTDC_LAYER.CACR: Layerx Constant Alpha Configuration Register
func (o *LTDC_LAYER_Type) SetCACR_CONSTA(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetCACR_CONSTA() uint32 {
	return volatile.LoadUint32(&o.CACR.Reg) & 0xff
}

// LTDC_LAYER.DCCR: Layerx Default Color Configuration Register
func (o *LTDC_LAYER_Type) SetDCCR_DCALPHA(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff000000)|value<<24)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCALPHA() uint32 {
	return (volatile.LoadUint32(&o.DCCR.Reg) & 0xff000000) >> 24
}
func (o *LTDC_LAYER_Type) SetDCCR_DCRED(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCRED() uint32 {
	return (volatile.LoadUint32(&o.DCCR.Reg) & 0xff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetDCCR_DCGREEN(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCGREEN() uint32 {
	return (volatile.LoadUint32(&o.DCCR.Reg) & 0xff00) >> 8
}
func (o *LTDC_LAYER_Type) SetDCCR_DCBLUE(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCBLUE() uint32 {
	return volatile.LoadUint32(&o.DCCR.Reg) & 0xff
}

// LTDC_LAYER.BFCR: Layerx Blending Factors Configuration Register
func (o *LTDC_LAYER_Type) SetBFCR_BF1(value uint32) {
	volatile.StoreUint32(&o.BFCR.Reg, volatile.LoadUint32(&o.BFCR.Reg)&^(0x700)|value<<8)
}
func (o *LTDC_LAYER_Type) GetBFCR_BF1() uint32 {
	return (volatile.LoadUint32(&o.BFCR.Reg) & 0x700) >> 8
}
func (o *LTDC_LAYER_Type) SetBFCR_BF2(value uint32) {
	volatile.StoreUint32(&o.BFCR.Reg, volatile.LoadUint32(&o.BFCR.Reg)&^(0x7)|value)
}
func (o *LTDC_LAYER_Type) GetBFCR_BF2() uint32 {
	return volatile.LoadUint32(&o.BFCR.Reg) & 0x7
}

// LTDC_LAYER.CFBAR: Layerx Color Frame Buffer Address Register
func (o *LTDC_LAYER_Type) SetCFBAR(value uint32) {
	volatile.StoreUint32(&o.CFBAR.Reg, value)
}
func (o *LTDC_LAYER_Type) GetCFBAR() uint32 {
	return volatile.LoadUint32(&o.CFBAR.Reg)
}

// LTDC_LAYER.CFBLR: Layerx Color Frame Buffer Length Register
func (o *LTDC_LAYER_Type) SetCFBLR_CFBP(value uint32) {
	volatile.StoreUint32(&o.CFBLR.Reg, volatile.LoadUint32(&o.CFBLR.Reg)&^(0x1fff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetCFBLR_CFBP() uint32 {
	return (volatile.LoadUint32(&o.CFBLR.Reg) & 0x1fff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetCFBLR_CFBLL(value uint32) {
	volatile.StoreUint32(&o.CFBLR.Reg, volatile.LoadUint32(&o.CFBLR.Reg)&^(0x1fff)|value)
}
func (o *LTDC_LAYER_Type) GetCFBLR_CFBLL() uint32 {
	return volatile.LoadUint32(&o.CFBLR.Reg) & 0x1fff
}

// LTDC_LAYER.CFBLNR: Layerx ColorFrame Buffer Line Number Register
func (o *LTDC_LAYER_Type) SetCFBLNR_CFBLNBR(value uint32) {
	volatile.StoreUint32(&o.CFBLNR.Reg, volatile.LoadUint32(&o.CFBLNR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_LAYER_Type) GetCFBLNR_CFBLNBR() uint32 {
	return volatile.LoadUint32(&o.CFBLNR.Reg) & 0x7ff
}

// LTDC_LAYER.CLUTWR: Layerx CLUT Write Register
func (o *LTDC_LAYER_Type) SetCLUTWR_CLUTADD(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff000000)|value<<24)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_CLUTADD() uint32 {
	return (volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff000000) >> 24
}
func (o *LTDC_LAYER_Type) SetCLUTWR_RED(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_RED() uint32 {
	return (volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetCLUTWR_GREEN(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff00) >> 8
}
func (o *LTDC_LAYER_Type) SetCLUTWR_BLUE(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_BLUE() uint32 {
	return volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff
}

// Receiver Interface
type SPDIFRX_Type struct {
	CR    volatile.Register32 // 0x0
	IMR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	IFCR  volatile.Register32 // 0xC
	DR_00 volatile.Register32 // 0x10
	CSR   volatile.Register32 // 0x14
	DIR   volatile.Register32 // 0x18
	_     [984]byte
	VERR  volatile.Register32 // 0x3F4
	IDR   volatile.Register32 // 0x3F8
	SIDR  volatile.Register32 // 0x3FC
}

// SPDIFRX.CR: Control register
func (o *SPDIFRX_Type) SetCR_SPDIFRXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3)|value)
}
func (o *SPDIFRX_Type) GetCR_SPDIFRXEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x3
}
func (o *SPDIFRX_Type) SetCR_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *SPDIFRX_Type) GetCR_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *SPDIFRX_Type) SetCR_RXSTEO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *SPDIFRX_Type) GetCR_RXSTEO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *SPDIFRX_Type) SetCR_DRFMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30)|value<<4)
}
func (o *SPDIFRX_Type) GetCR_DRFMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30) >> 4
}
func (o *SPDIFRX_Type) SetCR_PMSK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *SPDIFRX_Type) GetCR_PMSK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *SPDIFRX_Type) SetCR_VMSK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPDIFRX_Type) GetCR_VMSK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPDIFRX_Type) SetCR_CUMSK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SPDIFRX_Type) GetCR_CUMSK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SPDIFRX_Type) SetCR_PTMSK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SPDIFRX_Type) GetCR_PTMSK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SPDIFRX_Type) SetCR_CBDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *SPDIFRX_Type) GetCR_CBDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *SPDIFRX_Type) SetCR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *SPDIFRX_Type) GetCR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *SPDIFRX_Type) SetCR_NBTR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3000)|value<<12)
}
func (o *SPDIFRX_Type) GetCR_NBTR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3000) >> 12
}
func (o *SPDIFRX_Type) SetCR_WFA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *SPDIFRX_Type) GetCR_WFA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *SPDIFRX_Type) SetCR_INSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x70000)|value<<16)
}
func (o *SPDIFRX_Type) GetCR_INSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x70000) >> 16
}
func (o *SPDIFRX_Type) SetCR_CKSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *SPDIFRX_Type) GetCR_CKSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *SPDIFRX_Type) SetCR_CKSBKPEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200000)|value<<21)
}
func (o *SPDIFRX_Type) GetCR_CKSBKPEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200000) >> 21
}

// SPDIFRX.IMR: Interrupt mask register
func (o *SPDIFRX_Type) SetIMR_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SPDIFRX_Type) GetIMR_RXNEIE() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SPDIFRX_Type) SetIMR_CSRNEIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SPDIFRX_Type) GetIMR_CSRNEIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SPDIFRX_Type) SetIMR_PERRIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SPDIFRX_Type) GetIMR_PERRIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SPDIFRX_Type) SetIMR_OVRIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SPDIFRX_Type) GetIMR_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SPDIFRX_Type) SetIMR_SBLKIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SPDIFRX_Type) GetIMR_SBLKIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SPDIFRX_Type) SetIMR_SYNCDIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SPDIFRX_Type) GetIMR_SYNCDIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SPDIFRX_Type) SetIMR_IFEIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *SPDIFRX_Type) GetIMR_IFEIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}

// SPDIFRX.SR: Status register
func (o *SPDIFRX_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPDIFRX_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPDIFRX_Type) SetSR_CSRNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPDIFRX_Type) GetSR_CSRNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPDIFRX_Type) SetSR_PERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPDIFRX_Type) GetSR_PERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPDIFRX_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPDIFRX_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPDIFRX_Type) SetSR_SBD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPDIFRX_Type) GetSR_SBD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPDIFRX_Type) SetSR_SYNCD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPDIFRX_Type) GetSR_SYNCD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPDIFRX_Type) SetSR_FERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPDIFRX_Type) GetSR_FERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPDIFRX_Type) SetSR_SERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPDIFRX_Type) GetSR_SERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPDIFRX_Type) SetSR_TERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPDIFRX_Type) GetSR_TERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPDIFRX_Type) SetSR_WIDTH5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7fff0000)|value<<16)
}
func (o *SPDIFRX_Type) GetSR_WIDTH5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7fff0000) >> 16
}

// SPDIFRX.IFCR: Interrupt Flag Clear register
func (o *SPDIFRX_Type) SetIFCR_PERRCF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *SPDIFRX_Type) GetIFCR_PERRCF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *SPDIFRX_Type) SetIFCR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *SPDIFRX_Type) GetIFCR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *SPDIFRX_Type) SetIFCR_SBDCF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *SPDIFRX_Type) GetIFCR_SBDCF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *SPDIFRX_Type) SetIFCR_SYNCDCF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *SPDIFRX_Type) GetIFCR_SYNCDCF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}

// SPDIFRX.DR_00: Data input register
func (o *SPDIFRX_Type) SetDR_00_DR(value uint32) {
	volatile.StoreUint32(&o.DR_00.Reg, volatile.LoadUint32(&o.DR_00.Reg)&^(0xffffff)|value)
}
func (o *SPDIFRX_Type) GetDR_00_DR() uint32 {
	return volatile.LoadUint32(&o.DR_00.Reg) & 0xffffff
}
func (o *SPDIFRX_Type) SetDR_00_PE(value uint32) {
	volatile.StoreUint32(&o.DR_00.Reg, volatile.LoadUint32(&o.DR_00.Reg)&^(0x1000000)|value<<24)
}
func (o *SPDIFRX_Type) GetDR_00_PE() uint32 {
	return (volatile.LoadUint32(&o.DR_00.Reg) & 0x1000000) >> 24
}
func (o *SPDIFRX_Type) SetDR_00_V(value uint32) {
	volatile.StoreUint32(&o.DR_00.Reg, volatile.LoadUint32(&o.DR_00.Reg)&^(0x2000000)|value<<25)
}
func (o *SPDIFRX_Type) GetDR_00_V() uint32 {
	return (volatile.LoadUint32(&o.DR_00.Reg) & 0x2000000) >> 25
}
func (o *SPDIFRX_Type) SetDR_00_U(value uint32) {
	volatile.StoreUint32(&o.DR_00.Reg, volatile.LoadUint32(&o.DR_00.Reg)&^(0x4000000)|value<<26)
}
func (o *SPDIFRX_Type) GetDR_00_U() uint32 {
	return (volatile.LoadUint32(&o.DR_00.Reg) & 0x4000000) >> 26
}
func (o *SPDIFRX_Type) SetDR_00_C(value uint32) {
	volatile.StoreUint32(&o.DR_00.Reg, volatile.LoadUint32(&o.DR_00.Reg)&^(0x8000000)|value<<27)
}
func (o *SPDIFRX_Type) GetDR_00_C() uint32 {
	return (volatile.LoadUint32(&o.DR_00.Reg) & 0x8000000) >> 27
}
func (o *SPDIFRX_Type) SetDR_00_PT(value uint32) {
	volatile.StoreUint32(&o.DR_00.Reg, volatile.LoadUint32(&o.DR_00.Reg)&^(0x30000000)|value<<28)
}
func (o *SPDIFRX_Type) GetDR_00_PT() uint32 {
	return (volatile.LoadUint32(&o.DR_00.Reg) & 0x30000000) >> 28
}

// SPDIFRX.CSR: Channel Status register
func (o *SPDIFRX_Type) SetCSR_USR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xffff)|value)
}
func (o *SPDIFRX_Type) GetCSR_USR() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0xffff
}
func (o *SPDIFRX_Type) SetCSR_CS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xff0000)|value<<16)
}
func (o *SPDIFRX_Type) GetCSR_CS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0xff0000) >> 16
}
func (o *SPDIFRX_Type) SetCSR_SOB(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPDIFRX_Type) GetCSR_SOB() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}

// SPDIFRX.DIR: Debug Information register
func (o *SPDIFRX_Type) SetDIR_THI(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1fff)|value)
}
func (o *SPDIFRX_Type) GetDIR_THI() uint32 {
	return volatile.LoadUint32(&o.DIR.Reg) & 0x1fff
}
func (o *SPDIFRX_Type) SetDIR_TLO(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1fff0000)|value<<16)
}
func (o *SPDIFRX_Type) GetDIR_TLO() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x1fff0000) >> 16
}

// SPDIFRX.VERR: SPDIFRX version register
func (o *SPDIFRX_Type) SetVERR_MINREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf)|value)
}
func (o *SPDIFRX_Type) GetVERR_MINREV() uint32 {
	return volatile.LoadUint32(&o.VERR.Reg) & 0xf
}
func (o *SPDIFRX_Type) SetVERR_MAJREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf0)|value<<4)
}
func (o *SPDIFRX_Type) GetVERR_MAJREV() uint32 {
	return (volatile.LoadUint32(&o.VERR.Reg) & 0xf0) >> 4
}

// SPDIFRX.IDR: SPDIFRX identification register
func (o *SPDIFRX_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, value)
}
func (o *SPDIFRX_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg)
}

// SPDIFRX.SIDR: SPDIFRX size identification register
func (o *SPDIFRX_Type) SetSIDR(value uint32) {
	volatile.StoreUint32(&o.SIDR.Reg, value)
}
func (o *SPDIFRX_Type) GetSIDR() uint32 {
	return volatile.LoadUint32(&o.SIDR.Reg)
}

// Analog to Digital Converter
type ADC_Type struct {
	ISR      volatile.Register32 // 0x0
	IER      volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	CFGR     volatile.Register32 // 0xC
	CFGR2    volatile.Register32 // 0x10
	SMPR1    volatile.Register32 // 0x14
	SMPR2    volatile.Register32 // 0x18
	PCSEL    volatile.Register32 // 0x1C
	LTR1     volatile.Register32 // 0x20
	HTR1     volatile.Register32 // 0x24
	_        [8]byte
	SQR1     volatile.Register32 // 0x30
	SQR2     volatile.Register32 // 0x34
	SQR3     volatile.Register32 // 0x38
	SQR4     volatile.Register32 // 0x3C
	DR       volatile.Register32 // 0x40
	_        [8]byte
	JSQR     volatile.Register32 // 0x4C
	_        [16]byte
	OFR1     volatile.Register32 // 0x60
	OFR2     volatile.Register32 // 0x64
	OFR3     volatile.Register32 // 0x68
	OFR4     volatile.Register32 // 0x6C
	_        [16]byte
	JDR1     volatile.Register32 // 0x80
	JDR2     volatile.Register32 // 0x84
	JDR3     volatile.Register32 // 0x88
	JDR4     volatile.Register32 // 0x8C
	_        [16]byte
	AWD2CR   volatile.Register32 // 0xA0
	AWD3CR   volatile.Register32 // 0xA4
	_        [8]byte
	LTR2     volatile.Register32 // 0xB0
	HTR2     volatile.Register32 // 0xB4
	LTR3     volatile.Register32 // 0xB8
	HTR3     volatile.Register32 // 0xBC
	DIFSEL   volatile.Register32 // 0xC0
	CALFACT  volatile.Register32 // 0xC4
	CALFACT2 volatile.Register32 // 0xC8
}

// ADC.ISR: ADC interrupt and status register
func (o *ADC_Type) SetISR_JQOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_JQOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_AWD3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_AWD3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_AWD2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_AWD2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_AWD1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_AWD1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_JEOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_JEOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_JEOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_JEOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOSMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOSMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_ADRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_ADRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// ADC.IER: ADC interrupt enable register
func (o *ADC_Type) SetIER_JQOVFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_JQOVFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_AWD3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_AWD3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_AWD2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_AWD2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_AWD1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_AWD1IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_JEOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_JEOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_OVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOSMPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOSMPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_ADRDYIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_ADRDYIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// ADC.CR: ADC control register
func (o *ADC_Type) SetCR_ADCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCR_ADCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetCR_ADCALDIF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCR_ADCALDIF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCR_DEEPPWD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetCR_DEEPPWD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetCR_ADVREGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetCR_ADVREGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetCR_LINCALRDYW6(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetCR_LINCALRDYW6() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetCR_LINCALRDYW5(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetCR_LINCALRDYW5() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetCR_LINCALRDYW4(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCR_LINCALRDYW4() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCR_LINCALRDYW3(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCR_LINCALRDYW3() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCR_LINCALRDYW2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCR_LINCALRDYW2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCR_LINCALRDYW1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR_LINCALRDYW1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR_ADCALLIN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCR_ADCALLIN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCR_BOOST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *ADC_Type) GetCR_BOOST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *ADC_Type) SetCR_JADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCR_JADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCR_ADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCR_ADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCR_JADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCR_JADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCR_ADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR_ADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCR_ADDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_ADDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_ADEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_ADEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// ADC.CFGR: ADC configuration register 1
func (o *ADC_Type) SetCFGR_JQDIS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCFGR_JQDIS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetCFGR_AWD1CH(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetCFGR_AWD1CH() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetCFGR_JAUTO(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCFGR_JAUTO() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCFGR_JAWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCFGR_JAWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCFGR_AWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCFGR_AWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCFGR_AWD1SGL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCFGR_AWD1SGL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCFGR_JQM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCFGR_JQM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCFGR_JDISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetCFGR_JDISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetCFGR_DISCNUM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe0000)|value<<17)
}
func (o *ADC_Type) GetCFGR_DISCNUM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe0000) >> 17
}
func (o *ADC_Type) SetCFGR_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCFGR_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCFGR_AUTDLY(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCFGR_AUTDLY() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCFGR_CONT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCFGR_CONT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCFGR_OVRMOD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCFGR_OVRMOD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCFGR_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetCFGR_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetCFGR_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetCFGR_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetCFGR_RES(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1c)|value<<2)
}
func (o *ADC_Type) GetCFGR_RES() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1c) >> 2
}
func (o *ADC_Type) SetCFGR_DMNGT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetCFGR_DMNGT() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}

// ADC.CFGR2: ADC configuration register 2
func (o *ADC_Type) SetCFGR2_ROVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR2_ROVSE() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}
func (o *ADC_Type) SetCFGR2_JOVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCFGR2_JOVSE() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCFGR2_OVSS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1e0)|value<<5)
}
func (o *ADC_Type) GetCFGR2_OVSS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1e0) >> 5
}
func (o *ADC_Type) SetCFGR2_TROVS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCFGR2_TROVS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCFGR2_ROVSM(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCFGR2_ROVSM() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCFGR2_RSHIFT1(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCFGR2_RSHIFT1() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCFGR2_RSHIFT2(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCFGR2_RSHIFT2() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCFGR2_RSHIFT3(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCFGR2_RSHIFT3() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCFGR2_RSHIFT4(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCFGR2_RSHIFT4() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCFGR2_OSVR(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x3ff0000)|value<<16)
}
func (o *ADC_Type) GetCFGR2_OSVR() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x3ff0000) >> 16
}
func (o *ADC_Type) SetCFGR2_LSHIFT(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetCFGR2_LSHIFT() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0xf0000000) >> 28
}

// ADC.SMPR1: ADC sampling time register 1
func (o *ADC_Type) SetSMPR1_SMP9(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetSMPR1_SMP9() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000000) >> 27
}
func (o *ADC_Type) SetSMPR1_SMP8(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR1_SMP8() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR1_SMP7(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR1_SMP7() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR1_SMP6(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR1_SMP6() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR1_SMP5(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR1_SMP5() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR1_SMP4(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR1_SMP4() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR1_SMP3(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR1_SMP3() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR1_SMP2(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR1_SMP2() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR1_SMP1(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR1_SMP1() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR1_SMP0(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR1_SMP0() uint32 {
	return volatile.LoadUint32(&o.SMPR1.Reg) & 0x7
}

// ADC.SMPR2: ADC sampling time register 2
func (o *ADC_Type) SetSMPR2_SMP19(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetSMPR2_SMP19() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000000) >> 27
}
func (o *ADC_Type) SetSMPR2_SMP18(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR2_SMP18() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR2_SMP17(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR2_SMP17() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR2_SMP16(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR2_SMP16() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR2_SMP15(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR2_SMP15() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR2_SMP14(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR2_SMP14() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR2_SMP13(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR2_SMP13() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR2_SMP12(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR2_SMP12() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR2_SMP11(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR2_SMP11() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR2_SMP10(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR2_SMP10() uint32 {
	return volatile.LoadUint32(&o.SMPR2.Reg) & 0x7
}

// ADC.PCSEL: ADC pre channel selection register
func (o *ADC_Type) SetPCSEL(value uint32) {
	volatile.StoreUint32(&o.PCSEL.Reg, volatile.LoadUint32(&o.PCSEL.Reg)&^(0xfffff)|value)
}
func (o *ADC_Type) GetPCSEL() uint32 {
	return volatile.LoadUint32(&o.PCSEL.Reg) & 0xfffff
}

// ADC.LTR1: ADC analog watchdog 1 threshold register
func (o *ADC_Type) SetLTR1(value uint32) {
	volatile.StoreUint32(&o.LTR1.Reg, volatile.LoadUint32(&o.LTR1.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetLTR1() uint32 {
	return volatile.LoadUint32(&o.LTR1.Reg) & 0x3ffffff
}

// ADC.HTR1: ADC analog watchdog 2 threshold register
func (o *ADC_Type) SetHTR1(value uint32) {
	volatile.StoreUint32(&o.HTR1.Reg, volatile.LoadUint32(&o.HTR1.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetHTR1() uint32 {
	return volatile.LoadUint32(&o.HTR1.Reg) & 0x3ffffff
}

// ADC.SQR1: ADC group regular sequencer ranks register 1
func (o *ADC_Type) SetSQR1_SQ4(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR1_SQ4() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR1_SQ3(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR1_SQ3() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR1_SQ2(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR1_SQ2() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR1_SQ1(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR1_SQ1() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR1_L(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSQR1_L() uint32 {
	return volatile.LoadUint32(&o.SQR1.Reg) & 0xf
}

// ADC.SQR2: ADC group regular sequencer ranks register 2
func (o *ADC_Type) SetSQR2_SQ9(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR2_SQ9() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR2_SQ8(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR2_SQ8() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR2_SQ7(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR2_SQ7() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR2_SQ6(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR2_SQ6() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR2_SQ5(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR2_SQ5() uint32 {
	return volatile.LoadUint32(&o.SQR2.Reg) & 0x1f
}

// ADC.SQR3: ADC group regular sequencer ranks register 3
func (o *ADC_Type) SetSQR3_SQ14(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR3_SQ14() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR3_SQ13(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR3_SQ13() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR3_SQ12(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR3_SQ12() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR3_SQ11(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR3_SQ11() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR3_SQ10(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR3_SQ10() uint32 {
	return volatile.LoadUint32(&o.SQR3.Reg) & 0x1f
}

// ADC.SQR4: ADC group regular sequencer ranks register 4
func (o *ADC_Type) SetSQR4_SQ16(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR4_SQ16() uint32 {
	return (volatile.LoadUint32(&o.SQR4.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR4_SQ15(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR4_SQ15() uint32 {
	return volatile.LoadUint32(&o.SQR4.Reg) & 0x1f
}

// ADC.DR: ADC group regular conversion data register
func (o *ADC_Type) SetDR_RDATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_RDATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// ADC.JSQR: ADC group injected sequencer register
func (o *ADC_Type) SetJSQR_JSQ4(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xf8000000)|value<<27)
}
func (o *ADC_Type) GetJSQR_JSQ4() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xf8000000) >> 27
}
func (o *ADC_Type) SetJSQR_JSQ3(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3e00000)|value<<21)
}
func (o *ADC_Type) GetJSQR_JSQ3() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3e00000) >> 21
}
func (o *ADC_Type) SetJSQR_JSQ2(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetJSQR_JSQ2() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetJSQR_JSQ1(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3e00)|value<<9)
}
func (o *ADC_Type) GetJSQR_JSQ1() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3e00) >> 9
}
func (o *ADC_Type) SetJSQR_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x180)|value<<7)
}
func (o *ADC_Type) GetJSQR_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x180) >> 7
}
func (o *ADC_Type) SetJSQR_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c)|value<<2)
}
func (o *ADC_Type) GetJSQR_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c) >> 2
}
func (o *ADC_Type) SetJSQR_JL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetJSQR_JL() uint32 {
	return volatile.LoadUint32(&o.JSQR.Reg) & 0x3
}

// ADC.OFR1: ADC offset number 1 register
func (o *ADC_Type) SetOFR1_SSATE(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR1_SSATE() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR1_OFFSET1_CH(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR1_OFFSET1_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR1_OFFSET1(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetOFR1_OFFSET1() uint32 {
	return volatile.LoadUint32(&o.OFR1.Reg) & 0x3ffffff
}

// ADC.OFR2: ADC offset number 2 register
func (o *ADC_Type) SetOFR2_SSATE(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR2_SSATE() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR2_OFFSET2_CH(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR2_OFFSET2_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR2_OFFSET2(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetOFR2_OFFSET2() uint32 {
	return volatile.LoadUint32(&o.OFR2.Reg) & 0x3ffffff
}

// ADC.OFR3: ADC offset number 3 register
func (o *ADC_Type) SetOFR3_SSATE(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR3_SSATE() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR3_OFFSET3_CH(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR3_OFFSET3_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR3_OFFSET3(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetOFR3_OFFSET3() uint32 {
	return volatile.LoadUint32(&o.OFR3.Reg) & 0x3ffffff
}

// ADC.OFR4: ADC offset number 4 register
func (o *ADC_Type) SetOFR4_SSATE(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR4_SSATE() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR4_OFFSET4_CH(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR4_OFFSET4_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR4_OFFSET4(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetOFR4_OFFSET4() uint32 {
	return volatile.LoadUint32(&o.OFR4.Reg) & 0x3ffffff
}

// ADC.JDR1: ADC group injected sequencer rank 1 register
func (o *ADC_Type) SetJDR1(value uint32) {
	volatile.StoreUint32(&o.JDR1.Reg, value)
}
func (o *ADC_Type) GetJDR1() uint32 {
	return volatile.LoadUint32(&o.JDR1.Reg)
}

// ADC.JDR2: ADC group injected sequencer rank 2 register
func (o *ADC_Type) SetJDR2(value uint32) {
	volatile.StoreUint32(&o.JDR2.Reg, value)
}
func (o *ADC_Type) GetJDR2() uint32 {
	return volatile.LoadUint32(&o.JDR2.Reg)
}

// ADC.JDR3: ADC group injected sequencer rank 3 register
func (o *ADC_Type) SetJDR3(value uint32) {
	volatile.StoreUint32(&o.JDR3.Reg, value)
}
func (o *ADC_Type) GetJDR3() uint32 {
	return volatile.LoadUint32(&o.JDR3.Reg)
}

// ADC.JDR4: ADC group injected sequencer rank 4 register
func (o *ADC_Type) SetJDR4(value uint32) {
	volatile.StoreUint32(&o.JDR4.Reg, value)
}
func (o *ADC_Type) GetJDR4() uint32 {
	return volatile.LoadUint32(&o.JDR4.Reg)
}

// ADC.AWD2CR: ADC analog watchdog 2 configuration register
func (o *ADC_Type) SetAWD2CR_AWD2CH0(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH0() uint32 {
	return volatile.LoadUint32(&o.AWD2CR.Reg) & 0x1
}
func (o *ADC_Type) SetAWD2CR_AWD2CH1(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH1() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetAWD2CR_AWD2CH2(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH2() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetAWD2CR_AWD2CH3(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH3() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetAWD2CR_AWD2CH4(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH4() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetAWD2CR_AWD2CH5(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH5() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetAWD2CR_AWD2CH6(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH6() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetAWD2CR_AWD2CH7(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH7() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetAWD2CR_AWD2CH8(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH8() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetAWD2CR_AWD2CH9(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH9() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetAWD2CR_AWD2CH10(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH10() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetAWD2CR_AWD2CH11(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH11() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetAWD2CR_AWD2CH12(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH12() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetAWD2CR_AWD2CH13(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH13() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetAWD2CR_AWD2CH14(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH14() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetAWD2CR_AWD2CH15(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH15() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetAWD2CR_AWD2CH16(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH16() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetAWD2CR_AWD2CH17(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH17() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetAWD2CR_AWD2CH18(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH18() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetAWD2CR_AWD2CH19(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH19() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x80000) >> 19
}

// ADC.AWD3CR: ADC analog watchdog 3 configuration register
func (o *ADC_Type) SetAWD3CR_AWD3CH0(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH0() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetAWD3CR_AWD3CH1(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH1() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetAWD3CR_AWD3CH2(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH2() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetAWD3CR_AWD3CH3(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH3() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetAWD3CR_AWD3CH4(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH4() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetAWD3CR_AWD3CH5(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH5() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetAWD3CR_AWD3CH6(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH6() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetAWD3CR_AWD3CH7(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH7() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetAWD3CR_AWD3CH8(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH8() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetAWD3CR_AWD3CH9(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH9() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetAWD3CR_AWD3CH10(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH10() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetAWD3CR_AWD3CH11(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH11() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetAWD3CR_AWD3CH12(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH12() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetAWD3CR_AWD3CH13(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH13() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetAWD3CR_AWD3CH14(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH14() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetAWD3CR_AWD3CH15(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH15() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetAWD3CR_AWD3CH16(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH16() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetAWD3CR_AWD3CH17(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH17() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetAWD3CR_AWD3CH18(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH18() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetAWD3CR_AWD3CH19(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH19() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x100000) >> 20
}

// ADC.LTR2: ADC watchdog lower threshold register 2
func (o *ADC_Type) SetLTR2(value uint32) {
	volatile.StoreUint32(&o.LTR2.Reg, volatile.LoadUint32(&o.LTR2.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetLTR2() uint32 {
	return volatile.LoadUint32(&o.LTR2.Reg) & 0x3ffffff
}

// ADC.HTR2: ADC watchdog higher threshold register 2
func (o *ADC_Type) SetHTR2(value uint32) {
	volatile.StoreUint32(&o.HTR2.Reg, volatile.LoadUint32(&o.HTR2.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetHTR2() uint32 {
	return volatile.LoadUint32(&o.HTR2.Reg) & 0x3ffffff
}

// ADC.LTR3: ADC watchdog lower threshold register 3
func (o *ADC_Type) SetLTR3(value uint32) {
	volatile.StoreUint32(&o.LTR3.Reg, volatile.LoadUint32(&o.LTR3.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetLTR3() uint32 {
	return volatile.LoadUint32(&o.LTR3.Reg) & 0x3ffffff
}

// ADC.HTR3: ADC watchdog higher threshold register 3
func (o *ADC_Type) SetHTR3(value uint32) {
	volatile.StoreUint32(&o.HTR3.Reg, volatile.LoadUint32(&o.HTR3.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetHTR3() uint32 {
	return volatile.LoadUint32(&o.HTR3.Reg) & 0x3ffffff
}

// ADC.DIFSEL: ADC channel differential or single-ended mode selection register
func (o *ADC_Type) SetDIFSEL_DIFSEL0(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL0() uint32 {
	return volatile.LoadUint32(&o.DIFSEL.Reg) & 0x1
}
func (o *ADC_Type) SetDIFSEL_DIFSEL1(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL1() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetDIFSEL_DIFSEL2(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL2() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetDIFSEL_DIFSEL3(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL3() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetDIFSEL_DIFSEL4(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL4() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetDIFSEL_DIFSEL5(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL5() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetDIFSEL_DIFSEL6(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL6() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetDIFSEL_DIFSEL7(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL7() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetDIFSEL_DIFSEL8(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL8() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetDIFSEL_DIFSEL9(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL9() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetDIFSEL_DIFSEL10(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL10() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetDIFSEL_DIFSEL11(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL11() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetDIFSEL_DIFSEL12(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL12() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetDIFSEL_DIFSEL13(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL13() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetDIFSEL_DIFSEL14(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL14() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetDIFSEL_DIFSEL15(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL15() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetDIFSEL_DIFSEL16(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL16() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetDIFSEL_DIFSEL17(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL17() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetDIFSEL_DIFSEL18(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL18() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetDIFSEL_DIFSEL19(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL19() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x80000) >> 19
}

// ADC.CALFACT: ADC calibration factors register
func (o *ADC_Type) SetCALFACT_CALFACT_D(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7ff0000)|value<<16)
}
func (o *ADC_Type) GetCALFACT_CALFACT_D() uint32 {
	return (volatile.LoadUint32(&o.CALFACT.Reg) & 0x7ff0000) >> 16
}
func (o *ADC_Type) SetCALFACT_CALFACT_S(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7ff)|value)
}
func (o *ADC_Type) GetCALFACT_CALFACT_S() uint32 {
	return volatile.LoadUint32(&o.CALFACT.Reg) & 0x7ff
}

// ADC.CALFACT2: ADC Calibration Factor register 2
func (o *ADC_Type) SetCALFACT2_LINCALFACT(value uint32) {
	volatile.StoreUint32(&o.CALFACT2.Reg, volatile.LoadUint32(&o.CALFACT2.Reg)&^(0x3fffffff)|value)
}
func (o *ADC_Type) GetCALFACT2_LINCALFACT() uint32 {
	return volatile.LoadUint32(&o.CALFACT2.Reg) & 0x3fffffff
}

// Cryptographic processor
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent Data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg)
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *CRC_Type) SetCR_POLYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *CRC_Type) GetCR_POLYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *CRC_Type) SetCR_REV_IN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *CRC_Type) GetCR_REV_IN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *CRC_Type) SetCR_REV_OUT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCR_REV_OUT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// CRC.INIT: Initial CRC value
func (o *CRC_Type) SetINIT(value uint32) {
	volatile.StoreUint32(&o.INIT.Reg, value)
}
func (o *CRC_Type) GetINIT() uint32 {
	return volatile.LoadUint32(&o.INIT.Reg)
}

// CRC.POL: CRC polynomial
func (o *CRC_Type) SetPOL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, value)
}
func (o *CRC_Type) GetPOL() uint32 {
	return volatile.LoadUint32(&o.POL.Reg)
}

// Reset and clock control
type RCC_Type struct {
	CR            volatile.Register32 // 0x0
	HSICFGR       volatile.Register32 // 0x4
	CRRCR         volatile.Register32 // 0x8
	CSICFGR       volatile.Register32 // 0xC
	CFGR          volatile.Register32 // 0x10
	_             [4]byte
	D1CFGR        volatile.Register32 // 0x18
	D2CFGR        volatile.Register32 // 0x1C
	D3CFGR        volatile.Register32 // 0x20
	_             [4]byte
	PLLCKSELR     volatile.Register32 // 0x28
	PLLCFGR       volatile.Register32 // 0x2C
	PLL1DIVR      volatile.Register32 // 0x30
	PLL1FRACR     volatile.Register32 // 0x34
	PLL2DIVR      volatile.Register32 // 0x38
	PLL2FRACR     volatile.Register32 // 0x3C
	PLL3DIVR      volatile.Register32 // 0x40
	PLL3FRACR     volatile.Register32 // 0x44
	_             [4]byte
	D1CCIPR       volatile.Register32 // 0x4C
	D2CCIP1R      volatile.Register32 // 0x50
	D2CCIP2R      volatile.Register32 // 0x54
	D3CCIPR       volatile.Register32 // 0x58
	_             [4]byte
	CIER          volatile.Register32 // 0x60
	CIFR          volatile.Register32 // 0x64
	CICR          volatile.Register32 // 0x68
	_             [4]byte
	BDCR          volatile.Register32 // 0x70
	CSR           volatile.Register32 // 0x74
	_             [4]byte
	AHB3RSTR      volatile.Register32 // 0x7C
	AHB1RSTR      volatile.Register32 // 0x80
	AHB2RSTR      volatile.Register32 // 0x84
	AHB4RSTR      volatile.Register32 // 0x88
	APB3RSTR      volatile.Register32 // 0x8C
	APB1LRSTR     volatile.Register32 // 0x90
	APB1HRSTR     volatile.Register32 // 0x94
	APB2RSTR      volatile.Register32 // 0x98
	APB4RSTR      volatile.Register32 // 0x9C
	GCR           volatile.Register32 // 0xA0
	_             [4]byte
	D3AMR         volatile.Register32 // 0xA8
	_             [36]byte
	RSR           volatile.Register32 // 0xD0
	AHB3ENR       volatile.Register32 // 0xD4
	AHB1ENR       volatile.Register32 // 0xD8
	AHB2ENR       volatile.Register32 // 0xDC
	AHB4ENR       volatile.Register32 // 0xE0
	APB3ENR       volatile.Register32 // 0xE4
	APB1LENR      volatile.Register32 // 0xE8
	APB1HENR      volatile.Register32 // 0xEC
	APB2ENR       volatile.Register32 // 0xF0
	APB4ENR       volatile.Register32 // 0xF4
	_             [4]byte
	AHB3LPENR     volatile.Register32 // 0xFC
	AHB1LPENR     volatile.Register32 // 0x100
	AHB2LPENR     volatile.Register32 // 0x104
	AHB4LPENR     volatile.Register32 // 0x108
	APB3LPENR     volatile.Register32 // 0x10C
	APB1LLPENR    volatile.Register32 // 0x110
	APB1HLPENR    volatile.Register32 // 0x114
	APB2LPENR     volatile.Register32 // 0x118
	APB4LPENR     volatile.Register32 // 0x11C
	_             [16]byte
	C1_RSR        volatile.Register32 // 0x130
	C1_AHB3ENR    volatile.Register32 // 0x134
	C1_AHB1ENR    volatile.Register32 // 0x138
	C1_AHB2ENR    volatile.Register32 // 0x13C
	C1_AHB4ENR    volatile.Register32 // 0x140
	C1_APB3ENR    volatile.Register32 // 0x144
	C1_APB1LENR   volatile.Register32 // 0x148
	C1_APB1HENR   volatile.Register32 // 0x14C
	C1_APB2ENR    volatile.Register32 // 0x150
	C1_APB4ENR    volatile.Register32 // 0x154
	_             [4]byte
	C1_AHB3LPENR  volatile.Register32 // 0x15C
	C1_AHB1LPENR  volatile.Register32 // 0x160
	C1_AHB2LPENR  volatile.Register32 // 0x164
	C1_AHB4LPENR  volatile.Register32 // 0x168
	C1_APB3LPENR  volatile.Register32 // 0x16C
	C1_APB1LLPENR volatile.Register32 // 0x170
	C1_APB1HLPENR volatile.Register32 // 0x174
	C1_APB2LPENR  volatile.Register32 // 0x178
	C1_APB4LPENR  volatile.Register32 // 0x17C
}

// RCC.CR: clock control register
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RCC_Type) SetCR_HSIKERON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCR_HSIKERON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCR_HSIDIV(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *RCC_Type) GetCR_HSIDIV() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *RCC_Type) SetCR_HSIDIVF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCR_HSIDIVF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCR_CSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCR_CSION() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCR_CSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCR_CSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCR_CSIKERON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCR_CSIKERON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCR_HSI48ON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetCR_HSI48ON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetCR_HSI48RDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetCR_HSI48RDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetCR_D1CKRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetCR_D1CKRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetCR_D2CKRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetCR_D2CKRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_HSECSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_HSECSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_PLL1ON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLL1ON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_PLL1RDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLL1RDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCR_PLL2ON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCR_PLL2ON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCR_PLL2RDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCR_PLL2RDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCR_PLL3ON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCR_PLL3ON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCR_PLL3RDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCR_PLL3RDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}

// RCC.HSICFGR: RCC HSI configuration register
func (o *RCC_Type) SetHSICFGR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.HSICFGR.Reg, volatile.LoadUint32(&o.HSICFGR.Reg)&^(0x7f000000)|value<<24)
}
func (o *RCC_Type) GetHSICFGR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.HSICFGR.Reg) & 0x7f000000) >> 24
}
func (o *RCC_Type) SetHSICFGR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.HSICFGR.Reg, volatile.LoadUint32(&o.HSICFGR.Reg)&^(0xfff)|value)
}
func (o *RCC_Type) GetHSICFGR_HSICAL() uint32 {
	return volatile.LoadUint32(&o.HSICFGR.Reg) & 0xfff
}

// RCC.CRRCR: RCC Clock Recovery RC Register
func (o *RCC_Type) SetCRRCR_HSI48CAL(value uint32) {
	volatile.StoreUint32(&o.CRRCR.Reg, volatile.LoadUint32(&o.CRRCR.Reg)&^(0x3ff)|value)
}
func (o *RCC_Type) GetCRRCR_HSI48CAL() uint32 {
	return volatile.LoadUint32(&o.CRRCR.Reg) & 0x3ff
}

// RCC.CSICFGR: RCC CSI configuration register
func (o *RCC_Type) SetCSICFGR_CSITRIM(value uint32) {
	volatile.StoreUint32(&o.CSICFGR.Reg, volatile.LoadUint32(&o.CSICFGR.Reg)&^(0x3f000000)|value<<24)
}
func (o *RCC_Type) GetCSICFGR_CSITRIM() uint32 {
	return (volatile.LoadUint32(&o.CSICFGR.Reg) & 0x3f000000) >> 24
}
func (o *RCC_Type) SetCSICFGR_CSICAL(value uint32) {
	volatile.StoreUint32(&o.CSICFGR.Reg, volatile.LoadUint32(&o.CSICFGR.Reg)&^(0x1ff)|value)
}
func (o *RCC_Type) GetCSICFGR_CSICAL() uint32 {
	return volatile.LoadUint32(&o.CSICFGR.Reg) & 0x1ff
}

// RCC.CFGR: RCC Clock Configuration Register
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x7
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x38)|value<<3)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x38) >> 3
}
func (o *RCC_Type) SetCFGR_STOPWUCK(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCFGR_STOPWUCK() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCFGR_STOPKERWUCK(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCFGR_STOPKERWUCK() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCFGR_RTCPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3f00)|value<<8)
}
func (o *RCC_Type) GetCFGR_RTCPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3f00) >> 8
}
func (o *RCC_Type) SetCFGR_HRTIMSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetCFGR_HRTIMSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetCFGR_TIMPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetCFGR_TIMPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetCFGR_MCO1PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3c0000)|value<<18)
}
func (o *RCC_Type) GetCFGR_MCO1PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3c0000) >> 18
}
func (o *RCC_Type) SetCFGR_MCO1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1c00000)|value<<22)
}
func (o *RCC_Type) GetCFGR_MCO1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1c00000) >> 22
}
func (o *RCC_Type) SetCFGR_MCO2PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1e000000)|value<<25)
}
func (o *RCC_Type) GetCFGR_MCO2PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1e000000) >> 25
}
func (o *RCC_Type) SetCFGR_MCO2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe0000000)|value<<29)
}
func (o *RCC_Type) GetCFGR_MCO2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe0000000) >> 29
}

// RCC.D1CFGR: RCC Domain 1 Clock Configuration Register
func (o *RCC_Type) SetD1CFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.D1CFGR.Reg, volatile.LoadUint32(&o.D1CFGR.Reg)&^(0xf)|value)
}
func (o *RCC_Type) GetD1CFGR_HPRE() uint32 {
	return volatile.LoadUint32(&o.D1CFGR.Reg) & 0xf
}
func (o *RCC_Type) SetD1CFGR_D1PPRE(value uint32) {
	volatile.StoreUint32(&o.D1CFGR.Reg, volatile.LoadUint32(&o.D1CFGR.Reg)&^(0x70)|value<<4)
}
func (o *RCC_Type) GetD1CFGR_D1PPRE() uint32 {
	return (volatile.LoadUint32(&o.D1CFGR.Reg) & 0x70) >> 4
}
func (o *RCC_Type) SetD1CFGR_D1CPRE(value uint32) {
	volatile.StoreUint32(&o.D1CFGR.Reg, volatile.LoadUint32(&o.D1CFGR.Reg)&^(0xf00)|value<<8)
}
func (o *RCC_Type) GetD1CFGR_D1CPRE() uint32 {
	return (volatile.LoadUint32(&o.D1CFGR.Reg) & 0xf00) >> 8
}

// RCC.D2CFGR: RCC Domain 2 Clock Configuration Register
func (o *RCC_Type) SetD2CFGR_D2PPRE1(value uint32) {
	volatile.StoreUint32(&o.D2CFGR.Reg, volatile.LoadUint32(&o.D2CFGR.Reg)&^(0x70)|value<<4)
}
func (o *RCC_Type) GetD2CFGR_D2PPRE1() uint32 {
	return (volatile.LoadUint32(&o.D2CFGR.Reg) & 0x70) >> 4
}
func (o *RCC_Type) SetD2CFGR_D2PPRE2(value uint32) {
	volatile.StoreUint32(&o.D2CFGR.Reg, volatile.LoadUint32(&o.D2CFGR.Reg)&^(0x700)|value<<8)
}
func (o *RCC_Type) GetD2CFGR_D2PPRE2() uint32 {
	return (volatile.LoadUint32(&o.D2CFGR.Reg) & 0x700) >> 8
}

// RCC.D3CFGR: RCC Domain 3 Clock Configuration Register
func (o *RCC_Type) SetD3CFGR_D3PPRE(value uint32) {
	volatile.StoreUint32(&o.D3CFGR.Reg, volatile.LoadUint32(&o.D3CFGR.Reg)&^(0x70)|value<<4)
}
func (o *RCC_Type) GetD3CFGR_D3PPRE() uint32 {
	return (volatile.LoadUint32(&o.D3CFGR.Reg) & 0x70) >> 4
}

// RCC.PLLCKSELR: RCC PLLs Clock Source Selection Register
func (o *RCC_Type) SetPLLCKSELR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.PLLCKSELR.Reg, volatile.LoadUint32(&o.PLLCKSELR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetPLLCKSELR_PLLSRC() uint32 {
	return volatile.LoadUint32(&o.PLLCKSELR.Reg) & 0x3
}
func (o *RCC_Type) SetPLLCKSELR_DIVM1(value uint32) {
	volatile.StoreUint32(&o.PLLCKSELR.Reg, volatile.LoadUint32(&o.PLLCKSELR.Reg)&^(0x3f0)|value<<4)
}
func (o *RCC_Type) GetPLLCKSELR_DIVM1() uint32 {
	return (volatile.LoadUint32(&o.PLLCKSELR.Reg) & 0x3f0) >> 4
}
func (o *RCC_Type) SetPLLCKSELR_DIVM2(value uint32) {
	volatile.StoreUint32(&o.PLLCKSELR.Reg, volatile.LoadUint32(&o.PLLCKSELR.Reg)&^(0x3f000)|value<<12)
}
func (o *RCC_Type) GetPLLCKSELR_DIVM2() uint32 {
	return (volatile.LoadUint32(&o.PLLCKSELR.Reg) & 0x3f000) >> 12
}
func (o *RCC_Type) SetPLLCKSELR_DIVM3(value uint32) {
	volatile.StoreUint32(&o.PLLCKSELR.Reg, volatile.LoadUint32(&o.PLLCKSELR.Reg)&^(0x3f00000)|value<<20)
}
func (o *RCC_Type) GetPLLCKSELR_DIVM3() uint32 {
	return (volatile.LoadUint32(&o.PLLCKSELR.Reg) & 0x3f00000) >> 20
}

// RCC.PLLCFGR: RCC PLLs Configuration Register
func (o *RCC_Type) SetPLLCFGR_PLL1FRACEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetPLLCFGR_PLL1FRACEN() uint32 {
	return volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x1
}
func (o *RCC_Type) SetPLLCFGR_PLL1VCOSEL(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetPLLCFGR_PLL1VCOSEL() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetPLLCFGR_PLL1RGE(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetPLLCFGR_PLL1RGE() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetPLLCFGR_PLL2FRACEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetPLLCFGR_PLL2FRACEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetPLLCFGR_PLL2VCOSEL(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetPLLCFGR_PLL2VCOSEL() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetPLLCFGR_PLL2RGE(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xc0)|value<<6)
}
func (o *RCC_Type) GetPLLCFGR_PLL2RGE() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xc0) >> 6
}
func (o *RCC_Type) SetPLLCFGR_PLL3FRACEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetPLLCFGR_PLL3FRACEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetPLLCFGR_PLL3VCOSEL(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetPLLCFGR_PLL3VCOSEL() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetPLLCFGR_PLL3RGE(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xc00)|value<<10)
}
func (o *RCC_Type) GetPLLCFGR_PLL3RGE() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xc00) >> 10
}
func (o *RCC_Type) SetPLLCFGR_DIVP1EN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetPLLCFGR_DIVP1EN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetPLLCFGR_DIVQ1EN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetPLLCFGR_DIVQ1EN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetPLLCFGR_DIVR1EN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetPLLCFGR_DIVR1EN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetPLLCFGR_DIVP2EN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetPLLCFGR_DIVP2EN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetPLLCFGR_DIVQ2EN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetPLLCFGR_DIVQ2EN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetPLLCFGR_DIVR2EN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetPLLCFGR_DIVR2EN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetPLLCFGR_DIVP3EN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetPLLCFGR_DIVP3EN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetPLLCFGR_DIVQ3EN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetPLLCFGR_DIVQ3EN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetPLLCFGR_DIVR3EN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetPLLCFGR_DIVR3EN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x1000000) >> 24
}

// RCC.PLL1DIVR: RCC PLL1 Dividers Configuration Register
func (o *RCC_Type) SetPLL1DIVR_DIVN1(value uint32) {
	volatile.StoreUint32(&o.PLL1DIVR.Reg, volatile.LoadUint32(&o.PLL1DIVR.Reg)&^(0x1ff)|value)
}
func (o *RCC_Type) GetPLL1DIVR_DIVN1() uint32 {
	return volatile.LoadUint32(&o.PLL1DIVR.Reg) & 0x1ff
}
func (o *RCC_Type) SetPLL1DIVR_DIVP1(value uint32) {
	volatile.StoreUint32(&o.PLL1DIVR.Reg, volatile.LoadUint32(&o.PLL1DIVR.Reg)&^(0xfe00)|value<<9)
}
func (o *RCC_Type) GetPLL1DIVR_DIVP1() uint32 {
	return (volatile.LoadUint32(&o.PLL1DIVR.Reg) & 0xfe00) >> 9
}
func (o *RCC_Type) SetPLL1DIVR_DIVQ1(value uint32) {
	volatile.StoreUint32(&o.PLL1DIVR.Reg, volatile.LoadUint32(&o.PLL1DIVR.Reg)&^(0x7f0000)|value<<16)
}
func (o *RCC_Type) GetPLL1DIVR_DIVQ1() uint32 {
	return (volatile.LoadUint32(&o.PLL1DIVR.Reg) & 0x7f0000) >> 16
}
func (o *RCC_Type) SetPLL1DIVR_DIVR1(value uint32) {
	volatile.StoreUint32(&o.PLL1DIVR.Reg, volatile.LoadUint32(&o.PLL1DIVR.Reg)&^(0x7f000000)|value<<24)
}
func (o *RCC_Type) GetPLL1DIVR_DIVR1() uint32 {
	return (volatile.LoadUint32(&o.PLL1DIVR.Reg) & 0x7f000000) >> 24
}

// RCC.PLL1FRACR: RCC PLL1 Fractional Divider Register
func (o *RCC_Type) SetPLL1FRACR_FRACN1(value uint32) {
	volatile.StoreUint32(&o.PLL1FRACR.Reg, volatile.LoadUint32(&o.PLL1FRACR.Reg)&^(0xfff8)|value<<3)
}
func (o *RCC_Type) GetPLL1FRACR_FRACN1() uint32 {
	return (volatile.LoadUint32(&o.PLL1FRACR.Reg) & 0xfff8) >> 3
}

// RCC.PLL2DIVR: RCC PLL2 Dividers Configuration Register
func (o *RCC_Type) SetPLL2DIVR_DIVN2(value uint32) {
	volatile.StoreUint32(&o.PLL2DIVR.Reg, volatile.LoadUint32(&o.PLL2DIVR.Reg)&^(0x1ff)|value)
}
func (o *RCC_Type) GetPLL2DIVR_DIVN2() uint32 {
	return volatile.LoadUint32(&o.PLL2DIVR.Reg) & 0x1ff
}
func (o *RCC_Type) SetPLL2DIVR_DIVP2(value uint32) {
	volatile.StoreUint32(&o.PLL2DIVR.Reg, volatile.LoadUint32(&o.PLL2DIVR.Reg)&^(0xfe00)|value<<9)
}
func (o *RCC_Type) GetPLL2DIVR_DIVP2() uint32 {
	return (volatile.LoadUint32(&o.PLL2DIVR.Reg) & 0xfe00) >> 9
}
func (o *RCC_Type) SetPLL2DIVR_DIVQ2(value uint32) {
	volatile.StoreUint32(&o.PLL2DIVR.Reg, volatile.LoadUint32(&o.PLL2DIVR.Reg)&^(0x7f0000)|value<<16)
}
func (o *RCC_Type) GetPLL2DIVR_DIVQ2() uint32 {
	return (volatile.LoadUint32(&o.PLL2DIVR.Reg) & 0x7f0000) >> 16
}
func (o *RCC_Type) SetPLL2DIVR_DIVR2(value uint32) {
	volatile.StoreUint32(&o.PLL2DIVR.Reg, volatile.LoadUint32(&o.PLL2DIVR.Reg)&^(0x7f000000)|value<<24)
}
func (o *RCC_Type) GetPLL2DIVR_DIVR2() uint32 {
	return (volatile.LoadUint32(&o.PLL2DIVR.Reg) & 0x7f000000) >> 24
}

// RCC.PLL2FRACR: RCC PLL2 Fractional Divider Register
func (o *RCC_Type) SetPLL2FRACR_FRACN2(value uint32) {
	volatile.StoreUint32(&o.PLL2FRACR.Reg, volatile.LoadUint32(&o.PLL2FRACR.Reg)&^(0xfff8)|value<<3)
}
func (o *RCC_Type) GetPLL2FRACR_FRACN2() uint32 {
	return (volatile.LoadUint32(&o.PLL2FRACR.Reg) & 0xfff8) >> 3
}

// RCC.PLL3DIVR: RCC PLL3 Dividers Configuration Register
func (o *RCC_Type) SetPLL3DIVR_DIVN3(value uint32) {
	volatile.StoreUint32(&o.PLL3DIVR.Reg, volatile.LoadUint32(&o.PLL3DIVR.Reg)&^(0x1ff)|value)
}
func (o *RCC_Type) GetPLL3DIVR_DIVN3() uint32 {
	return volatile.LoadUint32(&o.PLL3DIVR.Reg) & 0x1ff
}
func (o *RCC_Type) SetPLL3DIVR_DIVP3(value uint32) {
	volatile.StoreUint32(&o.PLL3DIVR.Reg, volatile.LoadUint32(&o.PLL3DIVR.Reg)&^(0xfe00)|value<<9)
}
func (o *RCC_Type) GetPLL3DIVR_DIVP3() uint32 {
	return (volatile.LoadUint32(&o.PLL3DIVR.Reg) & 0xfe00) >> 9
}
func (o *RCC_Type) SetPLL3DIVR_DIVQ3(value uint32) {
	volatile.StoreUint32(&o.PLL3DIVR.Reg, volatile.LoadUint32(&o.PLL3DIVR.Reg)&^(0x7f0000)|value<<16)
}
func (o *RCC_Type) GetPLL3DIVR_DIVQ3() uint32 {
	return (volatile.LoadUint32(&o.PLL3DIVR.Reg) & 0x7f0000) >> 16
}
func (o *RCC_Type) SetPLL3DIVR_DIVR3(value uint32) {
	volatile.StoreUint32(&o.PLL3DIVR.Reg, volatile.LoadUint32(&o.PLL3DIVR.Reg)&^(0x7f000000)|value<<24)
}
func (o *RCC_Type) GetPLL3DIVR_DIVR3() uint32 {
	return (volatile.LoadUint32(&o.PLL3DIVR.Reg) & 0x7f000000) >> 24
}

// RCC.PLL3FRACR: RCC PLL3 Fractional Divider Register
func (o *RCC_Type) SetPLL3FRACR_FRACN3(value uint32) {
	volatile.StoreUint32(&o.PLL3FRACR.Reg, volatile.LoadUint32(&o.PLL3FRACR.Reg)&^(0xfff8)|value<<3)
}
func (o *RCC_Type) GetPLL3FRACR_FRACN3() uint32 {
	return (volatile.LoadUint32(&o.PLL3FRACR.Reg) & 0xfff8) >> 3
}

// RCC.D1CCIPR: RCC Domain 1 Kernel Clock Configuration Register
func (o *RCC_Type) SetD1CCIPR_FMCSEL(value uint32) {
	volatile.StoreUint32(&o.D1CCIPR.Reg, volatile.LoadUint32(&o.D1CCIPR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetD1CCIPR_FMCSEL() uint32 {
	return volatile.LoadUint32(&o.D1CCIPR.Reg) & 0x3
}
func (o *RCC_Type) SetD1CCIPR_QSPISEL(value uint32) {
	volatile.StoreUint32(&o.D1CCIPR.Reg, volatile.LoadUint32(&o.D1CCIPR.Reg)&^(0x30)|value<<4)
}
func (o *RCC_Type) GetD1CCIPR_QSPISEL() uint32 {
	return (volatile.LoadUint32(&o.D1CCIPR.Reg) & 0x30) >> 4
}
func (o *RCC_Type) SetD1CCIPR_SDMMCSEL(value uint32) {
	volatile.StoreUint32(&o.D1CCIPR.Reg, volatile.LoadUint32(&o.D1CCIPR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetD1CCIPR_SDMMCSEL() uint32 {
	return (volatile.LoadUint32(&o.D1CCIPR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetD1CCIPR_CKPERSEL(value uint32) {
	volatile.StoreUint32(&o.D1CCIPR.Reg, volatile.LoadUint32(&o.D1CCIPR.Reg)&^(0x30000000)|value<<28)
}
func (o *RCC_Type) GetD1CCIPR_CKPERSEL() uint32 {
	return (volatile.LoadUint32(&o.D1CCIPR.Reg) & 0x30000000) >> 28
}

// RCC.D2CCIP1R: RCC Domain 2 Kernel Clock Configuration Register
func (o *RCC_Type) SetD2CCIP1R_SAI1SEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP1R.Reg, volatile.LoadUint32(&o.D2CCIP1R.Reg)&^(0x7)|value)
}
func (o *RCC_Type) GetD2CCIP1R_SAI1SEL() uint32 {
	return volatile.LoadUint32(&o.D2CCIP1R.Reg) & 0x7
}
func (o *RCC_Type) SetD2CCIP1R_SAI23SEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP1R.Reg, volatile.LoadUint32(&o.D2CCIP1R.Reg)&^(0x1c0)|value<<6)
}
func (o *RCC_Type) GetD2CCIP1R_SAI23SEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP1R.Reg) & 0x1c0) >> 6
}
func (o *RCC_Type) SetD2CCIP1R_SPI123SEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP1R.Reg, volatile.LoadUint32(&o.D2CCIP1R.Reg)&^(0x7000)|value<<12)
}
func (o *RCC_Type) GetD2CCIP1R_SPI123SEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP1R.Reg) & 0x7000) >> 12
}
func (o *RCC_Type) SetD2CCIP1R_SPI45SEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP1R.Reg, volatile.LoadUint32(&o.D2CCIP1R.Reg)&^(0x70000)|value<<16)
}
func (o *RCC_Type) GetD2CCIP1R_SPI45SEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP1R.Reg) & 0x70000) >> 16
}
func (o *RCC_Type) SetD2CCIP1R_SPDIFSEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP1R.Reg, volatile.LoadUint32(&o.D2CCIP1R.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetD2CCIP1R_SPDIFSEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP1R.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetD2CCIP1R_DFSDM1SEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP1R.Reg, volatile.LoadUint32(&o.D2CCIP1R.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetD2CCIP1R_DFSDM1SEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP1R.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetD2CCIP1R_FDCANSEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP1R.Reg, volatile.LoadUint32(&o.D2CCIP1R.Reg)&^(0x30000000)|value<<28)
}
func (o *RCC_Type) GetD2CCIP1R_FDCANSEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP1R.Reg) & 0x30000000) >> 28
}
func (o *RCC_Type) SetD2CCIP1R_SWPSEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP1R.Reg, volatile.LoadUint32(&o.D2CCIP1R.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetD2CCIP1R_SWPSEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP1R.Reg) & 0x80000000) >> 31
}

// RCC.D2CCIP2R: RCC Domain 2 Kernel Clock Configuration Register
func (o *RCC_Type) SetD2CCIP2R_USART234578SEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP2R.Reg, volatile.LoadUint32(&o.D2CCIP2R.Reg)&^(0x7)|value)
}
func (o *RCC_Type) GetD2CCIP2R_USART234578SEL() uint32 {
	return volatile.LoadUint32(&o.D2CCIP2R.Reg) & 0x7
}
func (o *RCC_Type) SetD2CCIP2R_USART16SEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP2R.Reg, volatile.LoadUint32(&o.D2CCIP2R.Reg)&^(0x38)|value<<3)
}
func (o *RCC_Type) GetD2CCIP2R_USART16SEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP2R.Reg) & 0x38) >> 3
}
func (o *RCC_Type) SetD2CCIP2R_RNGSEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP2R.Reg, volatile.LoadUint32(&o.D2CCIP2R.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetD2CCIP2R_RNGSEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP2R.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetD2CCIP2R_I2C123SEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP2R.Reg, volatile.LoadUint32(&o.D2CCIP2R.Reg)&^(0x3000)|value<<12)
}
func (o *RCC_Type) GetD2CCIP2R_I2C123SEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP2R.Reg) & 0x3000) >> 12
}
func (o *RCC_Type) SetD2CCIP2R_USBSEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP2R.Reg, volatile.LoadUint32(&o.D2CCIP2R.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetD2CCIP2R_USBSEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP2R.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetD2CCIP2R_CECSEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP2R.Reg, volatile.LoadUint32(&o.D2CCIP2R.Reg)&^(0xc00000)|value<<22)
}
func (o *RCC_Type) GetD2CCIP2R_CECSEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP2R.Reg) & 0xc00000) >> 22
}
func (o *RCC_Type) SetD2CCIP2R_LPTIM1SEL(value uint32) {
	volatile.StoreUint32(&o.D2CCIP2R.Reg, volatile.LoadUint32(&o.D2CCIP2R.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetD2CCIP2R_LPTIM1SEL() uint32 {
	return (volatile.LoadUint32(&o.D2CCIP2R.Reg) & 0x70000000) >> 28
}

// RCC.D3CCIPR: RCC Domain 3 Kernel Clock Configuration Register
func (o *RCC_Type) SetD3CCIPR_LPUART1SEL(value uint32) {
	volatile.StoreUint32(&o.D3CCIPR.Reg, volatile.LoadUint32(&o.D3CCIPR.Reg)&^(0x7)|value)
}
func (o *RCC_Type) GetD3CCIPR_LPUART1SEL() uint32 {
	return volatile.LoadUint32(&o.D3CCIPR.Reg) & 0x7
}
func (o *RCC_Type) SetD3CCIPR_I2C4SEL(value uint32) {
	volatile.StoreUint32(&o.D3CCIPR.Reg, volatile.LoadUint32(&o.D3CCIPR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetD3CCIPR_I2C4SEL() uint32 {
	return (volatile.LoadUint32(&o.D3CCIPR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetD3CCIPR_LPTIM2SEL(value uint32) {
	volatile.StoreUint32(&o.D3CCIPR.Reg, volatile.LoadUint32(&o.D3CCIPR.Reg)&^(0x1c00)|value<<10)
}
func (o *RCC_Type) GetD3CCIPR_LPTIM2SEL() uint32 {
	return (volatile.LoadUint32(&o.D3CCIPR.Reg) & 0x1c00) >> 10
}
func (o *RCC_Type) SetD3CCIPR_LPTIM345SEL(value uint32) {
	volatile.StoreUint32(&o.D3CCIPR.Reg, volatile.LoadUint32(&o.D3CCIPR.Reg)&^(0xe000)|value<<13)
}
func (o *RCC_Type) GetD3CCIPR_LPTIM345SEL() uint32 {
	return (volatile.LoadUint32(&o.D3CCIPR.Reg) & 0xe000) >> 13
}
func (o *RCC_Type) SetD3CCIPR_ADCSEL(value uint32) {
	volatile.StoreUint32(&o.D3CCIPR.Reg, volatile.LoadUint32(&o.D3CCIPR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetD3CCIPR_ADCSEL() uint32 {
	return (volatile.LoadUint32(&o.D3CCIPR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetD3CCIPR_SAI4ASEL(value uint32) {
	volatile.StoreUint32(&o.D3CCIPR.Reg, volatile.LoadUint32(&o.D3CCIPR.Reg)&^(0xe00000)|value<<21)
}
func (o *RCC_Type) GetD3CCIPR_SAI4ASEL() uint32 {
	return (volatile.LoadUint32(&o.D3CCIPR.Reg) & 0xe00000) >> 21
}
func (o *RCC_Type) SetD3CCIPR_SAI4BSEL(value uint32) {
	volatile.StoreUint32(&o.D3CCIPR.Reg, volatile.LoadUint32(&o.D3CCIPR.Reg)&^(0x7000000)|value<<24)
}
func (o *RCC_Type) GetD3CCIPR_SAI4BSEL() uint32 {
	return (volatile.LoadUint32(&o.D3CCIPR.Reg) & 0x7000000) >> 24
}
func (o *RCC_Type) SetD3CCIPR_SPI6SEL(value uint32) {
	volatile.StoreUint32(&o.D3CCIPR.Reg, volatile.LoadUint32(&o.D3CCIPR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetD3CCIPR_SPI6SEL() uint32 {
	return (volatile.LoadUint32(&o.D3CCIPR.Reg) & 0x70000000) >> 28
}

// RCC.CIER: RCC Clock Source Interrupt Enable Register
func (o *RCC_Type) SetCIER_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIER_LSIRDYIE() uint32 {
	return volatile.LoadUint32(&o.CIER.Reg) & 0x1
}
func (o *RCC_Type) SetCIER_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIER_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIER_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIER_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIER_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIER_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIER_CSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIER_CSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIER_HSI48RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIER_HSI48RDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIER_PLL1RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCIER_PLL1RDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCIER_PLL2RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCIER_PLL2RDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCIER_PLL3RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIER_PLL3RDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIER_LSECSSIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIER_LSECSSIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x200) >> 9
}

// RCC.CIFR: RCC Clock Source Interrupt Flag Register
func (o *RCC_Type) SetCIFR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIFR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIFR.Reg) & 0x1
}
func (o *RCC_Type) SetCIFR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIFR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIFR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIFR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIFR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIFR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIFR_CSIRDY(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIFR_CSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIFR_HSI48RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIFR_HSI48RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIFR_PLL1RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCIFR_PLL1RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCIFR_PLL2RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCIFR_PLL2RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCIFR_PLL3RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIFR_PLL3RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIFR_LSECSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIFR_LSECSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIFR_HSECSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIFR_HSECSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x400) >> 10
}

// RCC.CICR: RCC Clock Source Interrupt Clear Register
func (o *RCC_Type) SetCICR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCICR_LSIRDYC() uint32 {
	return volatile.LoadUint32(&o.CICR.Reg) & 0x1
}
func (o *RCC_Type) SetCICR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCICR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCICR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCICR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCICR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCICR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCICR_HSE_ready_Interrupt_Clear(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCICR_HSE_ready_Interrupt_Clear() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCICR_HSI48RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCICR_HSI48RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCICR_PLL1RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCICR_PLL1RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCICR_PLL2RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCICR_PLL2RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCICR_PLL3RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCICR_PLL3RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCICR_LSECSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCICR_LSECSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCICR_HSECSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCICR_HSECSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x400) >> 10
}

// RCC.BDCR: RCC Backup Domain Control Register
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSEDRV(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x18)|value<<3)
}
func (o *RCC_Type) GetBDCR_LSEDRV() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x18) >> 3
}
func (o *RCC_Type) SetBDCR_LSECSSON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetBDCR_LSECSSON() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetBDCR_LSECSSD(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetBDCR_LSECSSD() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}

// RCC.CSR: RCC Clock Control and Status Register
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}

// RCC.AHB3RSTR: RCC AHB3 Reset Register
func (o *RCC_Type) SetAHB3RSTR_MDMARST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3RSTR_MDMARST() uint32 {
	return volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3RSTR_DMA2DRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB3RSTR_DMA2DRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB3RSTR_JPGDECRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB3RSTR_JPGDECRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB3RSTR_FMCRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB3RSTR_FMCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB3RSTR_QSPIRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAHB3RSTR_QSPIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAHB3RSTR_SDMMC1RST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB3RSTR_SDMMC1RST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB3RSTR_CPURST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAHB3RSTR_CPURST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x80000000) >> 31
}

// RCC.AHB1RSTR: RCC AHB1 Peripheral Reset Register
func (o *RCC_Type) SetAHB1RSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1RSTR_DMA1RST() uint32 {
	return volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1RSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1RSTR_ADC12RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1RSTR_ADC12RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1RSTR_ETH1MACRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAHB1RSTR_ETH1MACRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAHB1RSTR_USB1OTGRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB1RSTR_USB1OTGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB1RSTR_USB2OTGRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAHB1RSTR_USB2OTGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x8000000) >> 27
}

// RCC.AHB2RSTR: RCC AHB2 Peripheral Reset Register
func (o *RCC_Type) SetAHB2RSTR_CAMITFRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2RSTR_CAMITFRST() uint32 {
	return volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB2RSTR_CRYPTRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2RSTR_CRYPTRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2RSTR_HASHRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2RSTR_HASHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2RSTR_RNGRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2RSTR_RNGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2RSTR_SDMMC2RST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB2RSTR_SDMMC2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x200) >> 9
}

// RCC.AHB4RSTR: RCC AHB4 Peripheral Reset Register
func (o *RCC_Type) SetAHB4RSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB4RSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB4RSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB4RSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB4RSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB4RSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB4RSTR_GPIODRST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB4RSTR_GPIODRST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB4RSTR_GPIOERST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB4RSTR_GPIOERST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB4RSTR_GPIOFRST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB4RSTR_GPIOFRST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB4RSTR_GPIOGRST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB4RSTR_GPIOGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB4RSTR_GPIOHRST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB4RSTR_GPIOHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB4RSTR_GPIOIRST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB4RSTR_GPIOIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB4RSTR_GPIOJRST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB4RSTR_GPIOJRST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB4RSTR_GPIOKRST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAHB4RSTR_GPIOKRST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAHB4RSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB4RSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB4RSTR_BDMARST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB4RSTR_BDMARST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB4RSTR_ADC3RST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHB4RSTR_ADC3RST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHB4RSTR_HSEMRST(value uint32) {
	volatile.StoreUint32(&o.AHB4RSTR.Reg, volatile.LoadUint32(&o.AHB4RSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB4RSTR_HSEMRST() uint32 {
	return (volatile.LoadUint32(&o.AHB4RSTR.Reg) & 0x2000000) >> 25
}

// RCC.APB3RSTR: RCC APB3 Peripheral Reset Register
func (o *RCC_Type) SetAPB3RSTR_LTDCRST(value uint32) {
	volatile.StoreUint32(&o.APB3RSTR.Reg, volatile.LoadUint32(&o.APB3RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB3RSTR_LTDCRST() uint32 {
	return (volatile.LoadUint32(&o.APB3RSTR.Reg) & 0x8) >> 3
}

// RCC.APB1LRSTR: RCC APB1 Peripheral Reset Register
func (o *RCC_Type) SetAPB1LRSTR_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1LRSTR_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1LRSTR_TIM3RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1LRSTR_TIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1LRSTR_TIM4RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1LRSTR_TIM4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1LRSTR_TIM5RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1LRSTR_TIM5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1LRSTR_TIM6RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1LRSTR_TIM6RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1LRSTR_TIM7RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1LRSTR_TIM7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1LRSTR_TIM12RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1LRSTR_TIM12RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1LRSTR_TIM13RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1LRSTR_TIM13RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1LRSTR_TIM14RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1LRSTR_TIM14RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1LRSTR_LPTIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1LRSTR_LPTIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1LRSTR_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1LRSTR_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1LRSTR_SPI3RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1LRSTR_SPI3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1LRSTR_SPDIFRXRST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB1LRSTR_SPDIFRXRST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB1LRSTR_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1LRSTR_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1LRSTR_USART3RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1LRSTR_USART3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1LRSTR_UART4RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1LRSTR_UART4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1LRSTR_UART5RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1LRSTR_UART5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1LRSTR_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1LRSTR_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1LRSTR_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1LRSTR_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1LRSTR_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1LRSTR_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1LRSTR_CECRST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPB1LRSTR_CECRST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPB1LRSTR_DAC12RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1LRSTR_DAC12RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1LRSTR_UART7RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1LRSTR_UART7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1LRSTR_UART8RST(value uint32) {
	volatile.StoreUint32(&o.APB1LRSTR.Reg, volatile.LoadUint32(&o.APB1LRSTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1LRSTR_UART8RST() uint32 {
	return (volatile.LoadUint32(&o.APB1LRSTR.Reg) & 0x80000000) >> 31
}

// RCC.APB1HRSTR: RCC APB1 Peripheral Reset Register
func (o *RCC_Type) SetAPB1HRSTR_CRSRST(value uint32) {
	volatile.StoreUint32(&o.APB1HRSTR.Reg, volatile.LoadUint32(&o.APB1HRSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1HRSTR_CRSRST() uint32 {
	return (volatile.LoadUint32(&o.APB1HRSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1HRSTR_SWPRST(value uint32) {
	volatile.StoreUint32(&o.APB1HRSTR.Reg, volatile.LoadUint32(&o.APB1HRSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1HRSTR_SWPRST() uint32 {
	return (volatile.LoadUint32(&o.APB1HRSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1HRSTR_OPAMPRST(value uint32) {
	volatile.StoreUint32(&o.APB1HRSTR.Reg, volatile.LoadUint32(&o.APB1HRSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1HRSTR_OPAMPRST() uint32 {
	return (volatile.LoadUint32(&o.APB1HRSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1HRSTR_MDIOSRST(value uint32) {
	volatile.StoreUint32(&o.APB1HRSTR.Reg, volatile.LoadUint32(&o.APB1HRSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1HRSTR_MDIOSRST() uint32 {
	return (volatile.LoadUint32(&o.APB1HRSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1HRSTR_FDCANRST(value uint32) {
	volatile.StoreUint32(&o.APB1HRSTR.Reg, volatile.LoadUint32(&o.APB1HRSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1HRSTR_FDCANRST() uint32 {
	return (volatile.LoadUint32(&o.APB1HRSTR.Reg) & 0x100) >> 8
}

// RCC.APB2RSTR: RCC APB2 Peripheral Reset Register
func (o *RCC_Type) SetAPB2RSTR_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2RSTR_TIM1RST() uint32 {
	return volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2RSTR_TIM8RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2RSTR_TIM8RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2RSTR_USART6RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2RSTR_USART6RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2RSTR_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2RSTR_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2RSTR_SPI4RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2RSTR_SPI4RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2RSTR_TIM15RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2RSTR_TIM15RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2RSTR_TIM16RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2RSTR_TIM16RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2RSTR_TIM17RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2RSTR_TIM17RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2RSTR_SPI5RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2RSTR_SPI5RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2RSTR_SAI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2RSTR_SAI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2RSTR_SAI2RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB2RSTR_SAI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB2RSTR_SAI3RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB2RSTR_SAI3RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB2RSTR_DFSDM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB2RSTR_DFSDM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB2RSTR_HRTIMRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB2RSTR_HRTIMRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000000) >> 29
}

// RCC.APB4RSTR: RCC APB4 Peripheral Reset Register
func (o *RCC_Type) SetAPB4RSTR_SYSCFGRST(value uint32) {
	volatile.StoreUint32(&o.APB4RSTR.Reg, volatile.LoadUint32(&o.APB4RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB4RSTR_SYSCFGRST() uint32 {
	return (volatile.LoadUint32(&o.APB4RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB4RSTR_LPUART1RST(value uint32) {
	volatile.StoreUint32(&o.APB4RSTR.Reg, volatile.LoadUint32(&o.APB4RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB4RSTR_LPUART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB4RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB4RSTR_SPI6RST(value uint32) {
	volatile.StoreUint32(&o.APB4RSTR.Reg, volatile.LoadUint32(&o.APB4RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB4RSTR_SPI6RST() uint32 {
	return (volatile.LoadUint32(&o.APB4RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB4RSTR_I2C4RST(value uint32) {
	volatile.StoreUint32(&o.APB4RSTR.Reg, volatile.LoadUint32(&o.APB4RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB4RSTR_I2C4RST() uint32 {
	return (volatile.LoadUint32(&o.APB4RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB4RSTR_LPTIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB4RSTR.Reg, volatile.LoadUint32(&o.APB4RSTR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB4RSTR_LPTIM2RST() uint32 {
	return (volatile.LoadUint32(&o.APB4RSTR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB4RSTR_LPTIM3RST(value uint32) {
	volatile.StoreUint32(&o.APB4RSTR.Reg, volatile.LoadUint32(&o.APB4RSTR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB4RSTR_LPTIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APB4RSTR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB4RSTR_LPTIM4RST(value uint32) {
	volatile.StoreUint32(&o.APB4RSTR.Reg, volatile.LoadUint32(&o.APB4RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB4RSTR_LPTIM4RST() uint32 {
	return (volatile.LoadUint32(&o.APB4RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB4RSTR_LPTIM5RST(value uint32) {
	volatile.StoreUint32(&o.APB4RSTR.Reg, volatile.LoadUint32(&o.APB4RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB4RSTR_LPTIM5RST() uint32 {
	return (volatile.LoadUint32(&o.APB4RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB4RSTR_COMP12RST(value uint32) {
	volatile.StoreUint32(&o.APB4RSTR.Reg, volatile.LoadUint32(&o.APB4RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB4RSTR_COMP12RST() uint32 {
	return (volatile.LoadUint32(&o.APB4RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB4RSTR_VREFRST(value uint32) {
	volatile.StoreUint32(&o.APB4RSTR.Reg, volatile.LoadUint32(&o.APB4RSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB4RSTR_VREFRST() uint32 {
	return (volatile.LoadUint32(&o.APB4RSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB4RSTR_SAI4RST(value uint32) {
	volatile.StoreUint32(&o.APB4RSTR.Reg, volatile.LoadUint32(&o.APB4RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB4RSTR_SAI4RST() uint32 {
	return (volatile.LoadUint32(&o.APB4RSTR.Reg) & 0x200000) >> 21
}

// RCC.GCR: RCC Global Control Register
func (o *RCC_Type) SetGCR_WW1RSC(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetGCR_WW1RSC() uint32 {
	return volatile.LoadUint32(&o.GCR.Reg) & 0x1
}

// RCC.D3AMR: RCC D3 Autonomous mode Register
func (o *RCC_Type) SetD3AMR_BDMAAMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetD3AMR_BDMAAMEN() uint32 {
	return volatile.LoadUint32(&o.D3AMR.Reg) & 0x1
}
func (o *RCC_Type) SetD3AMR_LPUART1AMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetD3AMR_LPUART1AMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetD3AMR_SPI6AMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetD3AMR_SPI6AMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetD3AMR_I2C4AMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetD3AMR_I2C4AMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetD3AMR_LPTIM2AMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetD3AMR_LPTIM2AMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetD3AMR_LPTIM3AMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetD3AMR_LPTIM3AMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetD3AMR_LPTIM4AMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetD3AMR_LPTIM4AMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetD3AMR_LPTIM5AMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetD3AMR_LPTIM5AMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetD3AMR_COMP12AMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetD3AMR_COMP12AMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetD3AMR_VREFAMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetD3AMR_VREFAMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetD3AMR_RTCAMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetD3AMR_RTCAMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetD3AMR_CRCAMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetD3AMR_CRCAMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetD3AMR_SAI4AMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetD3AMR_SAI4AMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetD3AMR_ADC3AMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetD3AMR_ADC3AMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetD3AMR_BKPRAMAMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetD3AMR_BKPRAMAMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetD3AMR_SRAM4AMEN(value uint32) {
	volatile.StoreUint32(&o.D3AMR.Reg, volatile.LoadUint32(&o.D3AMR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetD3AMR_SRAM4AMEN() uint32 {
	return (volatile.LoadUint32(&o.D3AMR.Reg) & 0x20000000) >> 29
}

// RCC.RSR: RCC Reset Status Register
func (o *RCC_Type) SetRSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetRSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetRSR_CPURSTF(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetRSR_CPURSTF() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetRSR_D1RSTF(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetRSR_D1RSTF() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetRSR_D2RSTF(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetRSR_D2RSTF() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetRSR_BORRSTF(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetRSR_BORRSTF() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetRSR_PINRSTF(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetRSR_PINRSTF() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetRSR_PORRSTF(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetRSR_PORRSTF() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetRSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetRSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetRSR_IWDG1RSTF(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetRSR_IWDG1RSTF() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetRSR_WWDG1RSTF(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetRSR_WWDG1RSTF() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetRSR_LPWRRSTF(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetRSR_LPWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x40000000) >> 30
}

// RCC.AHB3ENR: RCC AHB3 Clock Register
func (o *RCC_Type) SetAHB3ENR_MDMAEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3ENR_MDMAEN() uint32 {
	return volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3ENR_DMA2DEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB3ENR_DMA2DEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB3ENR_JPGDECEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB3ENR_JPGDECEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB3ENR_FMCEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB3ENR_FMCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB3ENR_QSPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAHB3ENR_QSPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAHB3ENR_SDMMC1EN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB3ENR_SDMMC1EN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x10000) >> 16
}

// RCC.AHB1ENR: RCC AHB1 Clock Register
func (o *RCC_Type) SetAHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1ENR_DMA1EN() uint32 {
	return volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1ENR_ADC12EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1ENR_ADC12EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1ENR_ETH1MACEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAHB1ENR_ETH1MACEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAHB1ENR_ETH1TXEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1ENR_ETH1TXEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1ENR_ETH1RXEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB1ENR_ETH1RXEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB1ENR_USB2OTGHSULPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB1ENR_USB2OTGHSULPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB1ENR_USB1OTGEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB1ENR_USB1OTGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB1ENR_USB1ULPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAHB1ENR_USB1ULPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAHB1ENR_USB2OTGEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAHB1ENR_USB2OTGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAHB1ENR_USB2ULPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAHB1ENR_USB2ULPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10000000) >> 28
}

// RCC.AHB2ENR: RCC AHB2 Clock Register
func (o *RCC_Type) SetAHB2ENR_DCMIEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2ENR_DCMIEN() uint32 {
	return volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB2ENR_CRYPTEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2ENR_CRYPTEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2ENR_HASHEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2ENR_HASHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2ENR_SDMMC2EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB2ENR_SDMMC2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB2ENR_SRAM1EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB2ENR_SRAM1EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB2ENR_SRAM2EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAHB2ENR_SRAM2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAHB2ENR_SRAM3EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAHB2ENR_SRAM3EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x80000000) >> 31
}

// RCC.AHB4ENR: RCC AHB4 Clock Register
func (o *RCC_Type) SetAHB4ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB4ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB4ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB4ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB4ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB4ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB4ENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB4ENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB4ENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB4ENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB4ENR_GPIOFEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB4ENR_GPIOFEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB4ENR_GPIOGEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB4ENR_GPIOGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB4ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB4ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB4ENR_GPIOIEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB4ENR_GPIOIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB4ENR_GPIOJEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB4ENR_GPIOJEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB4ENR_GPIOKEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAHB4ENR_GPIOKEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAHB4ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB4ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB4ENR_BDMAEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB4ENR_BDMAEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB4ENR_ADC3EN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHB4ENR_ADC3EN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHB4ENR_HSEMEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB4ENR_HSEMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB4ENR_BKPRAMEN(value uint32) {
	volatile.StoreUint32(&o.AHB4ENR.Reg, volatile.LoadUint32(&o.AHB4ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAHB4ENR_BKPRAMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4ENR.Reg) & 0x10000000) >> 28
}

// RCC.APB3ENR: RCC APB3 Clock Register
func (o *RCC_Type) SetAPB3ENR_LTDCEN(value uint32) {
	volatile.StoreUint32(&o.APB3ENR.Reg, volatile.LoadUint32(&o.APB3ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB3ENR_LTDCEN() uint32 {
	return (volatile.LoadUint32(&o.APB3ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB3ENR_WWDG1EN(value uint32) {
	volatile.StoreUint32(&o.APB3ENR.Reg, volatile.LoadUint32(&o.APB3ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB3ENR_WWDG1EN() uint32 {
	return (volatile.LoadUint32(&o.APB3ENR.Reg) & 0x40) >> 6
}

// RCC.APB1LENR: RCC APB1 Clock Register
func (o *RCC_Type) SetAPB1LENR_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1LENR_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1LENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1LENR_TIM3EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1LENR_TIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1LENR_TIM4EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1LENR_TIM4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1LENR_TIM5EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1LENR_TIM5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1LENR_TIM6EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1LENR_TIM6EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1LENR_TIM7EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1LENR_TIM7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1LENR_TIM12EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1LENR_TIM12EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1LENR_TIM13EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1LENR_TIM13EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1LENR_TIM14EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1LENR_TIM14EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1LENR_LPTIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1LENR_LPTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1LENR_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1LENR_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1LENR_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1LENR_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1LENR_SPDIFRXEN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB1LENR_SPDIFRXEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB1LENR_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1LENR_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1LENR_USART3EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1LENR_USART3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1LENR_UART4EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1LENR_UART4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1LENR_UART5EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1LENR_UART5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1LENR_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1LENR_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1LENR_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1LENR_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1LENR_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1LENR_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1LENR_CECEN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPB1LENR_CECEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPB1LENR_DAC12EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1LENR_DAC12EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1LENR_UART7EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1LENR_UART7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1LENR_UART8EN(value uint32) {
	volatile.StoreUint32(&o.APB1LENR.Reg, volatile.LoadUint32(&o.APB1LENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1LENR_UART8EN() uint32 {
	return (volatile.LoadUint32(&o.APB1LENR.Reg) & 0x80000000) >> 31
}

// RCC.APB1HENR: RCC APB1 Clock Register
func (o *RCC_Type) SetAPB1HENR_CRSEN(value uint32) {
	volatile.StoreUint32(&o.APB1HENR.Reg, volatile.LoadUint32(&o.APB1HENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1HENR_CRSEN() uint32 {
	return (volatile.LoadUint32(&o.APB1HENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1HENR_SWPEN(value uint32) {
	volatile.StoreUint32(&o.APB1HENR.Reg, volatile.LoadUint32(&o.APB1HENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1HENR_SWPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1HENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1HENR_OPAMPEN(value uint32) {
	volatile.StoreUint32(&o.APB1HENR.Reg, volatile.LoadUint32(&o.APB1HENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1HENR_OPAMPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1HENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1HENR_MDIOSEN(value uint32) {
	volatile.StoreUint32(&o.APB1HENR.Reg, volatile.LoadUint32(&o.APB1HENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1HENR_MDIOSEN() uint32 {
	return (volatile.LoadUint32(&o.APB1HENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1HENR_FDCANEN(value uint32) {
	volatile.StoreUint32(&o.APB1HENR.Reg, volatile.LoadUint32(&o.APB1HENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1HENR_FDCANEN() uint32 {
	return (volatile.LoadUint32(&o.APB1HENR.Reg) & 0x100) >> 8
}

// RCC.APB2ENR: RCC APB2 Clock Register
func (o *RCC_Type) SetAPB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2ENR_TIM1EN() uint32 {
	return volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2ENR_TIM8EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2ENR_TIM8EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2ENR_USART6EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2ENR_USART6EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2ENR_SPI4EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2ENR_SPI4EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2ENR_TIM16EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2ENR_TIM16EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2ENR_TIM15EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2ENR_TIM15EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2ENR_TIM17EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2ENR_TIM17EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2ENR_SPI5EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2ENR_SPI5EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2ENR_SAI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2ENR_SAI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2ENR_SAI2EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB2ENR_SAI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB2ENR_SAI3EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB2ENR_SAI3EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB2ENR_DFSDM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB2ENR_DFSDM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB2ENR_HRTIMEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB2ENR_HRTIMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000000) >> 29
}

// RCC.APB4ENR: RCC APB4 Clock Register
func (o *RCC_Type) SetAPB4ENR_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB4ENR_SYSCFGEN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB4ENR_LPUART1EN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB4ENR_LPUART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB4ENR_SPI6EN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB4ENR_SPI6EN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB4ENR_I2C4EN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB4ENR_I2C4EN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB4ENR_LPTIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB4ENR_LPTIM2EN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB4ENR_LPTIM3EN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB4ENR_LPTIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB4ENR_LPTIM4EN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB4ENR_LPTIM4EN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB4ENR_LPTIM5EN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB4ENR_LPTIM5EN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB4ENR_COMP12EN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB4ENR_COMP12EN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB4ENR_VREFEN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB4ENR_VREFEN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB4ENR_RTCAPBEN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB4ENR_RTCAPBEN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB4ENR_SAI4EN(value uint32) {
	volatile.StoreUint32(&o.APB4ENR.Reg, volatile.LoadUint32(&o.APB4ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB4ENR_SAI4EN() uint32 {
	return (volatile.LoadUint32(&o.APB4ENR.Reg) & 0x200000) >> 21
}

// RCC.AHB3LPENR: RCC AHB3 Sleep Clock Register
func (o *RCC_Type) SetAHB3LPENR_MDMALPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3LPENR_MDMALPEN() uint32 {
	return volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3LPENR_DMA2DLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB3LPENR_DMA2DLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB3LPENR_JPGDECLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB3LPENR_JPGDECLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB3LPENR_FLASHLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB3LPENR_FLASHLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB3LPENR_FMCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB3LPENR_FMCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB3LPENR_QSPILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAHB3LPENR_QSPILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAHB3LPENR_SDMMC1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB3LPENR_SDMMC1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB3LPENR_D1DTCM1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAHB3LPENR_D1DTCM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAHB3LPENR_DTCM2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB3LPENR_DTCM2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB3LPENR_ITCMLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAHB3LPENR_ITCMLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAHB3LPENR_AXISRAMLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAHB3LPENR_AXISRAMLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x80000000) >> 31
}

// RCC.AHB1LPENR: RCC AHB1 Sleep Clock Register
func (o *RCC_Type) SetAHB1LPENR_DMA1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1LPENR_DMA1LPEN() uint32 {
	return volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1LPENR_DMA2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1LPENR_DMA2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1LPENR_ADC12LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1LPENR_ADC12LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1LPENR_ETH1MACLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAHB1LPENR_ETH1MACLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAHB1LPENR_ETH1TXLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1LPENR_ETH1TXLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1LPENR_ETH1RXLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB1LPENR_ETH1RXLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB1LPENR_USB1OTGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB1LPENR_USB1OTGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB1LPENR_USB1OTGHSULPILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAHB1LPENR_USB1OTGHSULPILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAHB1LPENR_USB2OTGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAHB1LPENR_USB2OTGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAHB1LPENR_USB2OTGHSULPILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAHB1LPENR_USB2OTGHSULPILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10000000) >> 28
}

// RCC.AHB2LPENR: RCC AHB2 Sleep Clock Register
func (o *RCC_Type) SetAHB2LPENR_DCMILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2LPENR_DCMILPEN() uint32 {
	return volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB2LPENR_CRYPTLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2LPENR_CRYPTLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2LPENR_HASHLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2LPENR_HASHLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2LPENR_SDMMC2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB2LPENR_SDMMC2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB2LPENR_RNGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2LPENR_RNGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2LPENR_SRAM1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB2LPENR_SRAM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB2LPENR_SRAM2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAHB2LPENR_SRAM2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAHB2LPENR_SRAM3LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAHB2LPENR_SRAM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x80000000) >> 31
}

// RCC.AHB4LPENR: RCC AHB4 Sleep Clock Register
func (o *RCC_Type) SetAHB4LPENR_GPIOALPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB4LPENR_GPIOALPEN() uint32 {
	return volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB4LPENR_GPIOBLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB4LPENR_GPIOBLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB4LPENR_GPIOCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB4LPENR_GPIOCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB4LPENR_GPIODLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB4LPENR_GPIODLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB4LPENR_GPIOELPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB4LPENR_GPIOELPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB4LPENR_GPIOFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB4LPENR_GPIOFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB4LPENR_GPIOGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB4LPENR_GPIOGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB4LPENR_GPIOHLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB4LPENR_GPIOHLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB4LPENR_GPIOILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB4LPENR_GPIOILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB4LPENR_GPIOJLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB4LPENR_GPIOJLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB4LPENR_GPIOKLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAHB4LPENR_GPIOKLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAHB4LPENR_CRCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB4LPENR_CRCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB4LPENR_BDMALPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB4LPENR_BDMALPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB4LPENR_ADC3LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHB4LPENR_ADC3LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHB4LPENR_BKPRAMLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAHB4LPENR_BKPRAMLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAHB4LPENR_SRAM4LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB4LPENR.Reg, volatile.LoadUint32(&o.AHB4LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB4LPENR_SRAM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB4LPENR.Reg) & 0x20000000) >> 29
}

// RCC.APB3LPENR: RCC APB3 Sleep Clock Register
func (o *RCC_Type) SetAPB3LPENR_LTDCLPEN(value uint32) {
	volatile.StoreUint32(&o.APB3LPENR.Reg, volatile.LoadUint32(&o.APB3LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB3LPENR_LTDCLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB3LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB3LPENR_WWDG1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB3LPENR.Reg, volatile.LoadUint32(&o.APB3LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB3LPENR_WWDG1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB3LPENR.Reg) & 0x40) >> 6
}

// RCC.APB1LLPENR: RCC APB1 Low Sleep Clock Register
func (o *RCC_Type) SetAPB1LLPENR_TIM2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1LLPENR_TIM2LPEN() uint32 {
	return volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1LLPENR_TIM3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1LLPENR_TIM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1LLPENR_TIM4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1LLPENR_TIM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1LLPENR_TIM5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1LLPENR_TIM5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1LLPENR_TIM6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1LLPENR_TIM6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1LLPENR_TIM7LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1LLPENR_TIM7LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1LLPENR_TIM12LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1LLPENR_TIM12LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1LLPENR_TIM13LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1LLPENR_TIM13LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1LLPENR_TIM14LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1LLPENR_TIM14LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1LLPENR_LPTIM1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1LLPENR_LPTIM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1LLPENR_SPI2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1LLPENR_SPI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1LLPENR_SPI3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1LLPENR_SPI3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1LLPENR_SPDIFRXLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB1LLPENR_SPDIFRXLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB1LLPENR_USART2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1LLPENR_USART2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1LLPENR_USART3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1LLPENR_USART3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1LLPENR_UART4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1LLPENR_UART4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1LLPENR_UART5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1LLPENR_UART5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1LLPENR_I2C1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1LLPENR_I2C1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1LLPENR_I2C2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1LLPENR_I2C2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1LLPENR_I2C3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1LLPENR_I2C3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1LLPENR_CECLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPB1LLPENR_CECLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPB1LLPENR_DAC12LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1LLPENR_DAC12LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1LLPENR_UART7LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1LLPENR_UART7LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1LLPENR_UART8LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LLPENR.Reg, volatile.LoadUint32(&o.APB1LLPENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1LLPENR_UART8LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LLPENR.Reg) & 0x80000000) >> 31
}

// RCC.APB1HLPENR: RCC APB1 High Sleep Clock Register
func (o *RCC_Type) SetAPB1HLPENR_CRSLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1HLPENR.Reg, volatile.LoadUint32(&o.APB1HLPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1HLPENR_CRSLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1HLPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1HLPENR_SWPLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1HLPENR.Reg, volatile.LoadUint32(&o.APB1HLPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1HLPENR_SWPLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1HLPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1HLPENR_OPAMPLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1HLPENR.Reg, volatile.LoadUint32(&o.APB1HLPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1HLPENR_OPAMPLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1HLPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1HLPENR_MDIOSLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1HLPENR.Reg, volatile.LoadUint32(&o.APB1HLPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1HLPENR_MDIOSLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1HLPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1HLPENR_FDCANLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1HLPENR.Reg, volatile.LoadUint32(&o.APB1HLPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1HLPENR_FDCANLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1HLPENR.Reg) & 0x100) >> 8
}

// RCC.APB2LPENR: RCC APB2 Sleep Clock Register
func (o *RCC_Type) SetAPB2LPENR_TIM1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2LPENR_TIM1LPEN() uint32 {
	return volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2LPENR_TIM8LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2LPENR_TIM8LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2LPENR_USART1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2LPENR_USART1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2LPENR_USART6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2LPENR_USART6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2LPENR_SPI1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2LPENR_SPI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2LPENR_SPI4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2LPENR_SPI4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2LPENR_TIM15LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2LPENR_TIM15LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2LPENR_TIM16LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2LPENR_TIM16LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2LPENR_TIM17LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2LPENR_TIM17LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2LPENR_SPI5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2LPENR_SPI5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2LPENR_SAI1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2LPENR_SAI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2LPENR_SAI2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB2LPENR_SAI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB2LPENR_SAI3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB2LPENR_SAI3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB2LPENR_DFSDM1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB2LPENR_DFSDM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB2LPENR_HRTIMLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB2LPENR_HRTIMLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20000000) >> 29
}

// RCC.APB4LPENR: RCC APB4 Sleep Clock Register
func (o *RCC_Type) SetAPB4LPENR_SYSCFGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB4LPENR_SYSCFGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB4LPENR_LPUART1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB4LPENR_LPUART1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB4LPENR_SPI6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB4LPENR_SPI6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB4LPENR_I2C4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB4LPENR_I2C4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB4LPENR_LPTIM2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB4LPENR_LPTIM2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB4LPENR_LPTIM3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB4LPENR_LPTIM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB4LPENR_LPTIM4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB4LPENR_LPTIM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB4LPENR_LPTIM5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB4LPENR_LPTIM5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB4LPENR_COMP12LPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB4LPENR_COMP12LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB4LPENR_VREFLPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB4LPENR_VREFLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB4LPENR_RTCAPBLPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB4LPENR_RTCAPBLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB4LPENR_SAI4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB4LPENR.Reg, volatile.LoadUint32(&o.APB4LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB4LPENR_SAI4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB4LPENR.Reg) & 0x200000) >> 21
}

// RCC.C1_RSR: RCC Reset Status Register
func (o *RCC_Type) SetC1_RSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.C1_RSR.Reg, volatile.LoadUint32(&o.C1_RSR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC1_RSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.C1_RSR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC1_RSR_CPURSTF(value uint32) {
	volatile.StoreUint32(&o.C1_RSR.Reg, volatile.LoadUint32(&o.C1_RSR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC1_RSR_CPURSTF() uint32 {
	return (volatile.LoadUint32(&o.C1_RSR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC1_RSR_D1RSTF(value uint32) {
	volatile.StoreUint32(&o.C1_RSR.Reg, volatile.LoadUint32(&o.C1_RSR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetC1_RSR_D1RSTF() uint32 {
	return (volatile.LoadUint32(&o.C1_RSR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetC1_RSR_D2RSTF(value uint32) {
	volatile.StoreUint32(&o.C1_RSR.Reg, volatile.LoadUint32(&o.C1_RSR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetC1_RSR_D2RSTF() uint32 {
	return (volatile.LoadUint32(&o.C1_RSR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetC1_RSR_BORRSTF(value uint32) {
	volatile.StoreUint32(&o.C1_RSR.Reg, volatile.LoadUint32(&o.C1_RSR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC1_RSR_BORRSTF() uint32 {
	return (volatile.LoadUint32(&o.C1_RSR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetC1_RSR_PINRSTF(value uint32) {
	volatile.StoreUint32(&o.C1_RSR.Reg, volatile.LoadUint32(&o.C1_RSR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetC1_RSR_PINRSTF() uint32 {
	return (volatile.LoadUint32(&o.C1_RSR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetC1_RSR_PORRSTF(value uint32) {
	volatile.StoreUint32(&o.C1_RSR.Reg, volatile.LoadUint32(&o.C1_RSR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetC1_RSR_PORRSTF() uint32 {
	return (volatile.LoadUint32(&o.C1_RSR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetC1_RSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.C1_RSR.Reg, volatile.LoadUint32(&o.C1_RSR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetC1_RSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.C1_RSR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetC1_RSR_IWDG1RSTF(value uint32) {
	volatile.StoreUint32(&o.C1_RSR.Reg, volatile.LoadUint32(&o.C1_RSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetC1_RSR_IWDG1RSTF() uint32 {
	return (volatile.LoadUint32(&o.C1_RSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetC1_RSR_WWDG1RSTF(value uint32) {
	volatile.StoreUint32(&o.C1_RSR.Reg, volatile.LoadUint32(&o.C1_RSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetC1_RSR_WWDG1RSTF() uint32 {
	return (volatile.LoadUint32(&o.C1_RSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetC1_RSR_LPWRRSTF(value uint32) {
	volatile.StoreUint32(&o.C1_RSR.Reg, volatile.LoadUint32(&o.C1_RSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetC1_RSR_LPWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.C1_RSR.Reg) & 0x40000000) >> 30
}

// RCC.C1_AHB3ENR: RCC AHB3 Clock Register
func (o *RCC_Type) SetC1_AHB3ENR_MDMAEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3ENR.Reg, volatile.LoadUint32(&o.C1_AHB3ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_AHB3ENR_MDMAEN() uint32 {
	return volatile.LoadUint32(&o.C1_AHB3ENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_AHB3ENR_DMA2DEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3ENR.Reg, volatile.LoadUint32(&o.C1_AHB3ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_AHB3ENR_DMA2DEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_AHB3ENR_JPGDECEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3ENR.Reg, volatile.LoadUint32(&o.C1_AHB3ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_AHB3ENR_JPGDECEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_AHB3ENR_FMCEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3ENR.Reg, volatile.LoadUint32(&o.C1_AHB3ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC1_AHB3ENR_FMCEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC1_AHB3ENR_QSPIEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3ENR.Reg, volatile.LoadUint32(&o.C1_AHB3ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC1_AHB3ENR_QSPIEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC1_AHB3ENR_SDMMC1EN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3ENR.Reg, volatile.LoadUint32(&o.C1_AHB3ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC1_AHB3ENR_SDMMC1EN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3ENR.Reg) & 0x10000) >> 16
}

// RCC.C1_AHB1ENR: RCC AHB1 Clock Register
func (o *RCC_Type) SetC1_AHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1ENR.Reg, volatile.LoadUint32(&o.C1_AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_AHB1ENR_DMA1EN() uint32 {
	return volatile.LoadUint32(&o.C1_AHB1ENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_AHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1ENR.Reg, volatile.LoadUint32(&o.C1_AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_AHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_AHB1ENR_ADC12EN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1ENR.Reg, volatile.LoadUint32(&o.C1_AHB1ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_AHB1ENR_ADC12EN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_AHB1ENR_ETH1MACEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1ENR.Reg, volatile.LoadUint32(&o.C1_AHB1ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetC1_AHB1ENR_ETH1MACEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetC1_AHB1ENR_ETH1TXEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1ENR.Reg, volatile.LoadUint32(&o.C1_AHB1ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC1_AHB1ENR_ETH1TXEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC1_AHB1ENR_ETH1RXEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1ENR.Reg, volatile.LoadUint32(&o.C1_AHB1ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC1_AHB1ENR_ETH1RXEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC1_AHB1ENR_USB1OTGEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1ENR.Reg, volatile.LoadUint32(&o.C1_AHB1ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetC1_AHB1ENR_USB1OTGEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetC1_AHB1ENR_USB1ULPIEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1ENR.Reg, volatile.LoadUint32(&o.C1_AHB1ENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetC1_AHB1ENR_USB1ULPIEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1ENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetC1_AHB1ENR_USB2OTGEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1ENR.Reg, volatile.LoadUint32(&o.C1_AHB1ENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetC1_AHB1ENR_USB2OTGEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1ENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetC1_AHB1ENR_USB2ULPIEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1ENR.Reg, volatile.LoadUint32(&o.C1_AHB1ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetC1_AHB1ENR_USB2ULPIEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1ENR.Reg) & 0x10000000) >> 28
}

// RCC.C1_AHB2ENR: RCC AHB2 Clock Register
func (o *RCC_Type) SetC1_AHB2ENR_DCMIEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2ENR.Reg, volatile.LoadUint32(&o.C1_AHB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_AHB2ENR_DCMIEN() uint32 {
	return volatile.LoadUint32(&o.C1_AHB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_AHB2ENR_CRYPTEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2ENR.Reg, volatile.LoadUint32(&o.C1_AHB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_AHB2ENR_CRYPTEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_AHB2ENR_HASHEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2ENR.Reg, volatile.LoadUint32(&o.C1_AHB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_AHB2ENR_HASHEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_AHB2ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2ENR.Reg, volatile.LoadUint32(&o.C1_AHB2ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetC1_AHB2ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetC1_AHB2ENR_SDMMC2EN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2ENR.Reg, volatile.LoadUint32(&o.C1_AHB2ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC1_AHB2ENR_SDMMC2EN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC1_AHB2ENR_SRAM1EN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2ENR.Reg, volatile.LoadUint32(&o.C1_AHB2ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetC1_AHB2ENR_SRAM1EN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2ENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetC1_AHB2ENR_SRAM2EN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2ENR.Reg, volatile.LoadUint32(&o.C1_AHB2ENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetC1_AHB2ENR_SRAM2EN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2ENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetC1_AHB2ENR_SRAM3EN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2ENR.Reg, volatile.LoadUint32(&o.C1_AHB2ENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetC1_AHB2ENR_SRAM3EN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2ENR.Reg) & 0x80000000) >> 31
}

// RCC.C1_AHB4ENR: RCC AHB4 Clock Register
func (o *RCC_Type) SetC1_AHB4ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_AHB4ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_AHB4ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_AHB4ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_AHB4ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC1_AHB4ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC1_AHB4ENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetC1_AHB4ENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetC1_AHB4ENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_AHB4ENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_AHB4ENR_GPIOFEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_AHB4ENR_GPIOFEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_AHB4ENR_GPIOGEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetC1_AHB4ENR_GPIOGEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetC1_AHB4ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetC1_AHB4ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetC1_AHB4ENR_GPIOIEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetC1_AHB4ENR_GPIOIEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetC1_AHB4ENR_GPIOJEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC1_AHB4ENR_GPIOJEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC1_AHB4ENR_GPIOKEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetC1_AHB4ENR_GPIOKEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetC1_AHB4ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetC1_AHB4ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetC1_AHB4ENR_BDMAEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC1_AHB4ENR_BDMAEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetC1_AHB4ENR_ADC3EN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetC1_AHB4ENR_ADC3EN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetC1_AHB4ENR_HSEMEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetC1_AHB4ENR_HSEMEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetC1_AHB4ENR_BKPRAMEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4ENR.Reg, volatile.LoadUint32(&o.C1_AHB4ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetC1_AHB4ENR_BKPRAMEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4ENR.Reg) & 0x10000000) >> 28
}

// RCC.C1_APB3ENR: RCC APB3 Clock Register
func (o *RCC_Type) SetC1_APB3ENR_LTDCEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB3ENR.Reg, volatile.LoadUint32(&o.C1_APB3ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetC1_APB3ENR_LTDCEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB3ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetC1_APB3ENR_WWDG1EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB3ENR.Reg, volatile.LoadUint32(&o.C1_APB3ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetC1_APB3ENR_WWDG1EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB3ENR.Reg) & 0x40) >> 6
}

// RCC.C1_APB1LENR: RCC APB1 Clock Register
func (o *RCC_Type) SetC1_APB1LENR_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_APB1LENR_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_APB1LENR_TIM3EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_APB1LENR_TIM3EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_APB1LENR_TIM4EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC1_APB1LENR_TIM4EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC1_APB1LENR_TIM5EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetC1_APB1LENR_TIM5EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetC1_APB1LENR_TIM6EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_APB1LENR_TIM6EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_APB1LENR_TIM7EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_APB1LENR_TIM7EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_APB1LENR_TIM12EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetC1_APB1LENR_TIM12EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetC1_APB1LENR_TIM13EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetC1_APB1LENR_TIM13EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetC1_APB1LENR_TIM14EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetC1_APB1LENR_TIM14EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetC1_APB1LENR_LPTIM1EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC1_APB1LENR_LPTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC1_APB1LENR_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC1_APB1LENR_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC1_APB1LENR_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetC1_APB1LENR_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetC1_APB1LENR_SPDIFRXEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC1_APB1LENR_SPDIFRXEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC1_APB1LENR_USART2EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC1_APB1LENR_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC1_APB1LENR_USART3EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC1_APB1LENR_USART3EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC1_APB1LENR_UART4EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetC1_APB1LENR_UART4EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetC1_APB1LENR_UART5EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetC1_APB1LENR_UART5EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetC1_APB1LENR_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC1_APB1LENR_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetC1_APB1LENR_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetC1_APB1LENR_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetC1_APB1LENR_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetC1_APB1LENR_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetC1_APB1LENR_CECEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetC1_APB1LENR_CECEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetC1_APB1LENR_DAC12EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetC1_APB1LENR_DAC12EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetC1_APB1LENR_UART7EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetC1_APB1LENR_UART7EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetC1_APB1LENR_UART8EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LENR.Reg, volatile.LoadUint32(&o.C1_APB1LENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetC1_APB1LENR_UART8EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LENR.Reg) & 0x80000000) >> 31
}

// RCC.C1_APB1HENR: RCC APB1 Clock Register
func (o *RCC_Type) SetC1_APB1HENR_CRSEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1HENR.Reg, volatile.LoadUint32(&o.C1_APB1HENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_APB1HENR_CRSEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1HENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_APB1HENR_SWPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1HENR.Reg, volatile.LoadUint32(&o.C1_APB1HENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC1_APB1HENR_SWPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1HENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC1_APB1HENR_OPAMPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1HENR.Reg, volatile.LoadUint32(&o.C1_APB1HENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_APB1HENR_OPAMPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1HENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_APB1HENR_MDIOSEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1HENR.Reg, volatile.LoadUint32(&o.C1_APB1HENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_APB1HENR_MDIOSEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1HENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_APB1HENR_FDCANEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1HENR.Reg, volatile.LoadUint32(&o.C1_APB1HENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetC1_APB1HENR_FDCANEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1HENR.Reg) & 0x100) >> 8
}

// RCC.C1_APB2ENR: RCC APB2 Clock Register
func (o *RCC_Type) SetC1_APB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_APB2ENR_TIM1EN() uint32 {
	return volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_APB2ENR_TIM8EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_APB2ENR_TIM8EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_APB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_APB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_APB2ENR_USART6EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_APB2ENR_USART6EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_APB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC1_APB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC1_APB2ENR_SPI4EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetC1_APB2ENR_SPI4EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetC1_APB2ENR_TIM16EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC1_APB2ENR_TIM16EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC1_APB2ENR_TIM15EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC1_APB2ENR_TIM15EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC1_APB2ENR_TIM17EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC1_APB2ENR_TIM17EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC1_APB2ENR_SPI5EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetC1_APB2ENR_SPI5EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetC1_APB2ENR_SAI1EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetC1_APB2ENR_SAI1EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetC1_APB2ENR_SAI2EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetC1_APB2ENR_SAI2EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetC1_APB2ENR_SAI3EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetC1_APB2ENR_SAI3EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetC1_APB2ENR_DFSDM1EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetC1_APB2ENR_DFSDM1EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetC1_APB2ENR_HRTIMEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2ENR.Reg, volatile.LoadUint32(&o.C1_APB2ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetC1_APB2ENR_HRTIMEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2ENR.Reg) & 0x20000000) >> 29
}

// RCC.C1_APB4ENR: RCC APB4 Clock Register
func (o *RCC_Type) SetC1_APB4ENR_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_APB4ENR_SYSCFGEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_APB4ENR_LPUART1EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetC1_APB4ENR_LPUART1EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetC1_APB4ENR_SPI6EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_APB4ENR_SPI6EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_APB4ENR_I2C4EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetC1_APB4ENR_I2C4EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetC1_APB4ENR_LPTIM2EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC1_APB4ENR_LPTIM2EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC1_APB4ENR_LPTIM3EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetC1_APB4ENR_LPTIM3EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetC1_APB4ENR_LPTIM4EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetC1_APB4ENR_LPTIM4EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetC1_APB4ENR_LPTIM5EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC1_APB4ENR_LPTIM5EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC1_APB4ENR_COMP12EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC1_APB4ENR_COMP12EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC1_APB4ENR_VREFEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetC1_APB4ENR_VREFEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetC1_APB4ENR_RTCAPBEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC1_APB4ENR_RTCAPBEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC1_APB4ENR_SAI4EN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4ENR.Reg, volatile.LoadUint32(&o.C1_APB4ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC1_APB4ENR_SAI4EN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4ENR.Reg) & 0x200000) >> 21
}

// RCC.C1_AHB3LPENR: RCC AHB3 Sleep Clock Register
func (o *RCC_Type) SetC1_AHB3LPENR_MDMALPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3LPENR.Reg, volatile.LoadUint32(&o.C1_AHB3LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_AHB3LPENR_MDMALPEN() uint32 {
	return volatile.LoadUint32(&o.C1_AHB3LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_AHB3LPENR_DMA2DLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3LPENR.Reg, volatile.LoadUint32(&o.C1_AHB3LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_AHB3LPENR_DMA2DLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_AHB3LPENR_JPGDECLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3LPENR.Reg, volatile.LoadUint32(&o.C1_AHB3LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_AHB3LPENR_JPGDECLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_AHB3LPENR_FLASHPREN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3LPENR.Reg, volatile.LoadUint32(&o.C1_AHB3LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetC1_AHB3LPENR_FLASHPREN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetC1_AHB3LPENR_FMCLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3LPENR.Reg, volatile.LoadUint32(&o.C1_AHB3LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC1_AHB3LPENR_FMCLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC1_AHB3LPENR_QSPILPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3LPENR.Reg, volatile.LoadUint32(&o.C1_AHB3LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC1_AHB3LPENR_QSPILPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC1_AHB3LPENR_SDMMC1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3LPENR.Reg, volatile.LoadUint32(&o.C1_AHB3LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC1_AHB3LPENR_SDMMC1LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC1_AHB3LPENR_D1DTCM1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3LPENR.Reg, volatile.LoadUint32(&o.C1_AHB3LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetC1_AHB3LPENR_D1DTCM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetC1_AHB3LPENR_DTCM2LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3LPENR.Reg, volatile.LoadUint32(&o.C1_AHB3LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetC1_AHB3LPENR_DTCM2LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetC1_AHB3LPENR_ITCMLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3LPENR.Reg, volatile.LoadUint32(&o.C1_AHB3LPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetC1_AHB3LPENR_ITCMLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3LPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetC1_AHB3LPENR_AXISRAMLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB3LPENR.Reg, volatile.LoadUint32(&o.C1_AHB3LPENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetC1_AHB3LPENR_AXISRAMLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB3LPENR.Reg) & 0x80000000) >> 31
}

// RCC.C1_AHB1LPENR: RCC AHB1 Sleep Clock Register
func (o *RCC_Type) SetC1_AHB1LPENR_DMA1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1LPENR.Reg, volatile.LoadUint32(&o.C1_AHB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_AHB1LPENR_DMA1LPEN() uint32 {
	return volatile.LoadUint32(&o.C1_AHB1LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_AHB1LPENR_DMA2LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1LPENR.Reg, volatile.LoadUint32(&o.C1_AHB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_AHB1LPENR_DMA2LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_AHB1LPENR_ADC12LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1LPENR.Reg, volatile.LoadUint32(&o.C1_AHB1LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_AHB1LPENR_ADC12LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_AHB1LPENR_ETH1MACLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1LPENR.Reg, volatile.LoadUint32(&o.C1_AHB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetC1_AHB1LPENR_ETH1MACLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetC1_AHB1LPENR_ETH1TXLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1LPENR.Reg, volatile.LoadUint32(&o.C1_AHB1LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC1_AHB1LPENR_ETH1TXLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC1_AHB1LPENR_ETH1RXLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1LPENR.Reg, volatile.LoadUint32(&o.C1_AHB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC1_AHB1LPENR_ETH1RXLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC1_AHB1LPENR_USB1OTGLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1LPENR.Reg, volatile.LoadUint32(&o.C1_AHB1LPENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetC1_AHB1LPENR_USB1OTGLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1LPENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetC1_AHB1LPENR_USB1ULPILPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1LPENR.Reg, volatile.LoadUint32(&o.C1_AHB1LPENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetC1_AHB1LPENR_USB1ULPILPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1LPENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetC1_AHB1LPENR_USB2OTGLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1LPENR.Reg, volatile.LoadUint32(&o.C1_AHB1LPENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetC1_AHB1LPENR_USB2OTGLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1LPENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetC1_AHB1LPENR_USB2ULPILPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB1LPENR.Reg, volatile.LoadUint32(&o.C1_AHB1LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetC1_AHB1LPENR_USB2ULPILPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB1LPENR.Reg) & 0x10000000) >> 28
}

// RCC.C1_AHB2LPENR: RCC AHB2 Sleep Clock Register
func (o *RCC_Type) SetC1_AHB2LPENR_DCMILPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2LPENR.Reg, volatile.LoadUint32(&o.C1_AHB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_AHB2LPENR_DCMILPEN() uint32 {
	return volatile.LoadUint32(&o.C1_AHB2LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_AHB2LPENR_CRYPTLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2LPENR.Reg, volatile.LoadUint32(&o.C1_AHB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_AHB2LPENR_CRYPTLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_AHB2LPENR_HASHLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2LPENR.Reg, volatile.LoadUint32(&o.C1_AHB2LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_AHB2LPENR_HASHLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_AHB2LPENR_SDMMC2LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2LPENR.Reg, volatile.LoadUint32(&o.C1_AHB2LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC1_AHB2LPENR_SDMMC2LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC1_AHB2LPENR_RNGLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2LPENR.Reg, volatile.LoadUint32(&o.C1_AHB2LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetC1_AHB2LPENR_RNGLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetC1_AHB2LPENR_SRAM1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2LPENR.Reg, volatile.LoadUint32(&o.C1_AHB2LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetC1_AHB2LPENR_SRAM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetC1_AHB2LPENR_SRAM2LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2LPENR.Reg, volatile.LoadUint32(&o.C1_AHB2LPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetC1_AHB2LPENR_SRAM2LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2LPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetC1_AHB2LPENR_SRAM3LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB2LPENR.Reg, volatile.LoadUint32(&o.C1_AHB2LPENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetC1_AHB2LPENR_SRAM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB2LPENR.Reg) & 0x80000000) >> 31
}

// RCC.C1_AHB4LPENR: RCC AHB4 Sleep Clock Register
func (o *RCC_Type) SetC1_AHB4LPENR_GPIOALPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_AHB4LPENR_GPIOALPEN() uint32 {
	return volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_AHB4LPENR_GPIOBLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_AHB4LPENR_GPIOBLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_AHB4LPENR_GPIOCLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC1_AHB4LPENR_GPIOCLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC1_AHB4LPENR_GPIODLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetC1_AHB4LPENR_GPIODLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetC1_AHB4LPENR_GPIOELPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_AHB4LPENR_GPIOELPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_AHB4LPENR_GPIOFLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_AHB4LPENR_GPIOFLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_AHB4LPENR_GPIOGLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetC1_AHB4LPENR_GPIOGLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetC1_AHB4LPENR_GPIOHLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetC1_AHB4LPENR_GPIOHLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetC1_AHB4LPENR_GPIOILPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetC1_AHB4LPENR_GPIOILPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetC1_AHB4LPENR_GPIOJLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC1_AHB4LPENR_GPIOJLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC1_AHB4LPENR_GPIOKLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetC1_AHB4LPENR_GPIOKLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetC1_AHB4LPENR_CRCLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetC1_AHB4LPENR_CRCLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetC1_AHB4LPENR_BDMALPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC1_AHB4LPENR_BDMALPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetC1_AHB4LPENR_ADC3LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetC1_AHB4LPENR_ADC3LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetC1_AHB4LPENR_BKPRAMLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetC1_AHB4LPENR_BKPRAMLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetC1_AHB4LPENR_SRAM4LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_AHB4LPENR.Reg, volatile.LoadUint32(&o.C1_AHB4LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetC1_AHB4LPENR_SRAM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_AHB4LPENR.Reg) & 0x20000000) >> 29
}

// RCC.C1_APB3LPENR: RCC APB3 Sleep Clock Register
func (o *RCC_Type) SetC1_APB3LPENR_LTDCLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB3LPENR.Reg, volatile.LoadUint32(&o.C1_APB3LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetC1_APB3LPENR_LTDCLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB3LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetC1_APB3LPENR_WWDG1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB3LPENR.Reg, volatile.LoadUint32(&o.C1_APB3LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetC1_APB3LPENR_WWDG1LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB3LPENR.Reg) & 0x40) >> 6
}

// RCC.C1_APB1LLPENR: RCC APB1 Low Sleep Clock Register
func (o *RCC_Type) SetC1_APB1LLPENR_TIM2LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_APB1LLPENR_TIM2LPEN() uint32 {
	return volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_APB1LLPENR_TIM3LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_APB1LLPENR_TIM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_APB1LLPENR_TIM4LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC1_APB1LLPENR_TIM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC1_APB1LLPENR_TIM5LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetC1_APB1LLPENR_TIM5LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetC1_APB1LLPENR_TIM6LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_APB1LLPENR_TIM6LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_APB1LLPENR_TIM7LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_APB1LLPENR_TIM7LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_APB1LLPENR_TIM12LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetC1_APB1LLPENR_TIM12LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetC1_APB1LLPENR_TIM13LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetC1_APB1LLPENR_TIM13LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetC1_APB1LLPENR_TIM14LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetC1_APB1LLPENR_TIM14LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetC1_APB1LLPENR_LPTIM1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC1_APB1LLPENR_LPTIM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC1_APB1LLPENR_SPI2LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC1_APB1LLPENR_SPI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC1_APB1LLPENR_SPI3LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetC1_APB1LLPENR_SPI3LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetC1_APB1LLPENR_SPDIFRXLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC1_APB1LLPENR_SPDIFRXLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC1_APB1LLPENR_USART2LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC1_APB1LLPENR_USART2LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC1_APB1LLPENR_USART3LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC1_APB1LLPENR_USART3LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC1_APB1LLPENR_UART4LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetC1_APB1LLPENR_UART4LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetC1_APB1LLPENR_UART5LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetC1_APB1LLPENR_UART5LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetC1_APB1LLPENR_I2C1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC1_APB1LLPENR_I2C1LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetC1_APB1LLPENR_I2C2LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetC1_APB1LLPENR_I2C2LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetC1_APB1LLPENR_I2C3LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetC1_APB1LLPENR_I2C3LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetC1_APB1LLPENR_CECLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetC1_APB1LLPENR_CECLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetC1_APB1LLPENR_DAC12LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetC1_APB1LLPENR_DAC12LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetC1_APB1LLPENR_UART7LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetC1_APB1LLPENR_UART7LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetC1_APB1LLPENR_UART8LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1LLPENR.Reg, volatile.LoadUint32(&o.C1_APB1LLPENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetC1_APB1LLPENR_UART8LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1LLPENR.Reg) & 0x80000000) >> 31
}

// RCC.C1_APB1HLPENR: RCC APB1 High Sleep Clock Register
func (o *RCC_Type) SetC1_APB1HLPENR_CRSLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1HLPENR.Reg, volatile.LoadUint32(&o.C1_APB1HLPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_APB1HLPENR_CRSLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1HLPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_APB1HLPENR_SWPLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1HLPENR.Reg, volatile.LoadUint32(&o.C1_APB1HLPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC1_APB1HLPENR_SWPLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1HLPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC1_APB1HLPENR_OPAMPLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1HLPENR.Reg, volatile.LoadUint32(&o.C1_APB1HLPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_APB1HLPENR_OPAMPLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1HLPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_APB1HLPENR_MDIOSLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1HLPENR.Reg, volatile.LoadUint32(&o.C1_APB1HLPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_APB1HLPENR_MDIOSLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1HLPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_APB1HLPENR_FDCANLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB1HLPENR.Reg, volatile.LoadUint32(&o.C1_APB1HLPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetC1_APB1HLPENR_FDCANLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB1HLPENR.Reg) & 0x100) >> 8
}

// RCC.C1_APB2LPENR: RCC APB2 Sleep Clock Register
func (o *RCC_Type) SetC1_APB2LPENR_TIM1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC1_APB2LPENR_TIM1LPEN() uint32 {
	return volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetC1_APB2LPENR_TIM8LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_APB2LPENR_TIM8LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_APB2LPENR_USART1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC1_APB2LPENR_USART1LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC1_APB2LPENR_USART6LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_APB2LPENR_USART6LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_APB2LPENR_SPI1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC1_APB2LPENR_SPI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC1_APB2LPENR_SPI4LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetC1_APB2LPENR_SPI4LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetC1_APB2LPENR_TIM15LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC1_APB2LPENR_TIM15LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC1_APB2LPENR_TIM16LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC1_APB2LPENR_TIM16LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC1_APB2LPENR_TIM17LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC1_APB2LPENR_TIM17LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC1_APB2LPENR_SPI5LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetC1_APB2LPENR_SPI5LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetC1_APB2LPENR_SAI1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetC1_APB2LPENR_SAI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetC1_APB2LPENR_SAI2LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetC1_APB2LPENR_SAI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetC1_APB2LPENR_SAI3LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetC1_APB2LPENR_SAI3LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetC1_APB2LPENR_DFSDM1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetC1_APB2LPENR_DFSDM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetC1_APB2LPENR_HRTIMLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB2LPENR.Reg, volatile.LoadUint32(&o.C1_APB2LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetC1_APB2LPENR_HRTIMLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB2LPENR.Reg) & 0x20000000) >> 29
}

// RCC.C1_APB4LPENR: RCC APB4 Sleep Clock Register
func (o *RCC_Type) SetC1_APB4LPENR_SYSCFGLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC1_APB4LPENR_SYSCFGLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC1_APB4LPENR_LPUART1LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetC1_APB4LPENR_LPUART1LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetC1_APB4LPENR_SPI6LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC1_APB4LPENR_SPI6LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC1_APB4LPENR_I2C4LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetC1_APB4LPENR_I2C4LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetC1_APB4LPENR_LPTIM2LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC1_APB4LPENR_LPTIM2LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC1_APB4LPENR_LPTIM3LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetC1_APB4LPENR_LPTIM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetC1_APB4LPENR_LPTIM4LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetC1_APB4LPENR_LPTIM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetC1_APB4LPENR_LPTIM5LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC1_APB4LPENR_LPTIM5LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC1_APB4LPENR_COMP12LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC1_APB4LPENR_COMP12LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC1_APB4LPENR_VREFLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetC1_APB4LPENR_VREFLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetC1_APB4LPENR_RTCAPBLPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC1_APB4LPENR_RTCAPBLPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC1_APB4LPENR_SAI4LPEN(value uint32) {
	volatile.StoreUint32(&o.C1_APB4LPENR.Reg, volatile.LoadUint32(&o.C1_APB4LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC1_APB4LPENR_SAI4LPEN() uint32 {
	return (volatile.LoadUint32(&o.C1_APB4LPENR.Reg) & 0x200000) >> 21
}

// Low power timer
type LPTIM_Type struct {
	ISR   volatile.Register32 // 0x0
	ICR   volatile.Register32 // 0x4
	IER   volatile.Register32 // 0x8
	CFGR  volatile.Register32 // 0xC
	CR    volatile.Register32 // 0x10
	CMP   volatile.Register32 // 0x14
	ARR   volatile.Register32 // 0x18
	CNT   volatile.Register32 // 0x1C
	_     [4]byte
	CFGR2 volatile.Register32 // 0x24
}

// LPTIM.ISR: Interrupt and Status Register
func (o *LPTIM_Type) SetISR_DOWN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetISR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetISR_UP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetISR_UP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetISR_ARROK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetISR_ARROK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetISR_CMPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetISR_CMPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetISR_EXTTRIG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetISR_EXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetISR_ARRM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetISR_ARRM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetISR_CMPM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetISR_CMPM() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LPTIM.ICR: Interrupt Clear Register
func (o *LPTIM_Type) SetICR_DOWNCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetICR_DOWNCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetICR_UPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetICR_UPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetICR_ARROKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetICR_ARROKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetICR_CMPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetICR_CMPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetICR_EXTTRIGCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetICR_EXTTRIGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetICR_ARRMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetICR_ARRMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetICR_CMPMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetICR_CMPMCF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LPTIM.IER: Interrupt Enable Register
func (o *LPTIM_Type) SetIER_DOWNIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetIER_DOWNIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetIER_UPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetIER_UPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetIER_ARROKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetIER_ARROKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetIER_CMPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetIER_CMPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetIER_EXTTRIGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetIER_EXTTRIGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetIER_ARRMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetIER_ARRMIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetIER_CMPMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetIER_CMPMIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LPTIM.CFGR: Configuration Register
func (o *LPTIM_Type) SetCFGR_ENC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPTIM_Type) GetCFGR_ENC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *LPTIM_Type) SetCFGR_COUNTMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *LPTIM_Type) GetCFGR_COUNTMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *LPTIM_Type) SetCFGR_PRELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *LPTIM_Type) GetCFGR_PRELOAD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *LPTIM_Type) SetCFGR_WAVPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *LPTIM_Type) GetCFGR_WAVPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *LPTIM_Type) SetCFGR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *LPTIM_Type) GetCFGR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *LPTIM_Type) SetCFGR_TIMOUT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000)|value<<19)
}
func (o *LPTIM_Type) GetCFGR_TIMOUT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000) >> 19
}
func (o *LPTIM_Type) SetCFGR_TRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x60000)|value<<17)
}
func (o *LPTIM_Type) GetCFGR_TRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x60000) >> 17
}
func (o *LPTIM_Type) SetCFGR_TRIGSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *LPTIM_Type) GetCFGR_TRIGSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *LPTIM_Type) SetCFGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe00)|value<<9)
}
func (o *LPTIM_Type) GetCFGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe00) >> 9
}
func (o *LPTIM_Type) SetCFGR_TRGFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0)|value<<6)
}
func (o *LPTIM_Type) GetCFGR_TRGFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0) >> 6
}
func (o *LPTIM_Type) SetCFGR_CKFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *LPTIM_Type) GetCFGR_CKFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *LPTIM_Type) SetCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x6)|value<<1)
}
func (o *LPTIM_Type) GetCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x6) >> 1
}
func (o *LPTIM_Type) SetCFGR_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCFGR_CKSEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// LPTIM.CR: Control Register
func (o *LPTIM_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *LPTIM_Type) SetCR_SNGSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetCR_SNGSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetCR_CNTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetCR_CNTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetCR_COUNTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetCR_COUNTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetCR_RSTARE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetCR_RSTARE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}

// LPTIM.CMP: Compare Register
func (o *LPTIM_Type) SetCMP(value uint32) {
	volatile.StoreUint32(&o.CMP.Reg, volatile.LoadUint32(&o.CMP.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCMP() uint32 {
	return volatile.LoadUint32(&o.CMP.Reg) & 0xffff
}

// LPTIM.ARR: Autoreload Register
func (o *LPTIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// LPTIM.CNT: Counter Register
func (o *LPTIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// LPTIM.CFGR2: LPTIM configuration register 2
func (o *LPTIM_Type) SetCFGR2_IN1SEL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x3)|value)
}
func (o *LPTIM_Type) GetCFGR2_IN1SEL() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x3
}
func (o *LPTIM_Type) SetCFGR2_IN2SEL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x30)|value<<4)
}
func (o *LPTIM_Type) GetCFGR2_IN2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x30) >> 4
}

// LPUART1
type LPUART_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	BRR   volatile.Register32 // 0xC
	GTPR  volatile.Register32 // 0x10
	RTOR  volatile.Register32 // 0x14
	RQR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	RDR   volatile.Register32 // 0x24
	TDR   volatile.Register32 // 0x28
	PRESC volatile.Register32 // 0x2C
}

// LPUART.CR1: Control register 1
func (o *LPUART_Type) SetCR1_RXFFIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000000)|value<<31)
}
func (o *LPUART_Type) GetCR1_RXFFIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000000) >> 31
}
func (o *LPUART_Type) SetCR1_TXFEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *LPUART_Type) GetCR1_TXFEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000000) >> 30
}
func (o *LPUART_Type) SetCR1_FIFOEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *LPUART_Type) GetCR1_FIFOEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000000) >> 29
}
func (o *LPUART_Type) SetCR1_M1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000000)|value<<28)
}
func (o *LPUART_Type) GetCR1_M1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000000) >> 28
}
func (o *LPUART_Type) SetCR1_DEAT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3e00000)|value<<21)
}
func (o *LPUART_Type) GetCR1_DEAT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3e00000) >> 21
}
func (o *LPUART_Type) SetCR1_DEDT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f0000)|value<<16)
}
func (o *LPUART_Type) GetCR1_DEDT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1f0000) >> 16
}
func (o *LPUART_Type) SetCR1_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART_Type) GetCR1_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *LPUART_Type) SetCR1_MME(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *LPUART_Type) GetCR1_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *LPUART_Type) SetCR1_M0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *LPUART_Type) GetCR1_M0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *LPUART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *LPUART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *LPUART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *LPUART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *LPUART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *LPUART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *LPUART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *LPUART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *LPUART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *LPUART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *LPUART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetCR1_UESM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetCR1_UESM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetCR1_UE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// LPUART.CR2: Control register 2
func (o *LPUART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff000000)|value<<24)
}
func (o *LPUART_Type) GetCR2_ADD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff000000) >> 24
}
func (o *LPUART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *LPUART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *LPUART_Type) SetCR2_DATAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART_Type) GetCR2_DATAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *LPUART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *LPUART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *LPUART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *LPUART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *LPUART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *LPUART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}

// LPUART.CR3: Control register 3
func (o *LPUART_Type) SetCR3_TXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000000)|value<<29)
}
func (o *LPUART_Type) GetCR3_TXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000000) >> 29
}
func (o *LPUART_Type) SetCR3_RXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10000000)|value<<28)
}
func (o *LPUART_Type) GetCR3_RXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10000000) >> 28
}
func (o *LPUART_Type) SetCR3_RXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe000000)|value<<25)
}
func (o *LPUART_Type) GetCR3_RXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe000000) >> 25
}
func (o *LPUART_Type) SetCR3_TXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART_Type) GetCR3_TXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800000) >> 23
}
func (o *LPUART_Type) SetCR3_WUFIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400000)|value<<22)
}
func (o *LPUART_Type) GetCR3_WUFIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400000) >> 22
}
func (o *LPUART_Type) SetCR3_WUS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300000)|value<<20)
}
func (o *LPUART_Type) GetCR3_WUS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300000) >> 20
}
func (o *LPUART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *LPUART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *LPUART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *LPUART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *LPUART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *LPUART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *LPUART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *LPUART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *LPUART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *LPUART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *LPUART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *LPUART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *LPUART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// LPUART.BRR: Baud rate register
func (o *LPUART_Type) SetBRR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xfffff)|value)
}
func (o *LPUART_Type) GetBRR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xfffff
}

// LPUART.GTPR: Guard time and prescaler register
func (o *LPUART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *LPUART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *LPUART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *LPUART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// LPUART.RTOR: Receiver timeout register
func (o *LPUART_Type) SetRTOR_BLEN(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xff000000)|value<<24)
}
func (o *LPUART_Type) GetRTOR_BLEN() uint32 {
	return (volatile.LoadUint32(&o.RTOR.Reg) & 0xff000000) >> 24
}
func (o *LPUART_Type) SetRTOR_RTO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffffff)|value)
}
func (o *LPUART_Type) GetRTOR_RTO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffffff
}

// LPUART.RQR: Request register
func (o *LPUART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetRQR_ABRRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetRQR_ABRRQ() uint32 {
	return volatile.LoadUint32(&o.RQR.Reg) & 0x1
}

// LPUART.ISR: Interrupt & status register
func (o *LPUART_Type) SetISR_TXFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *LPUART_Type) GetISR_TXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *LPUART_Type) SetISR_RXFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *LPUART_Type) GetISR_RXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *LPUART_Type) SetISR_RXFF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPUART_Type) GetISR_RXFF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *LPUART_Type) SetISR_TXFE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART_Type) GetISR_TXFE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *LPUART_Type) SetISR_REACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *LPUART_Type) GetISR_REACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *LPUART_Type) SetISR_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *LPUART_Type) GetISR_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *LPUART_Type) SetISR_WUF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *LPUART_Type) GetISR_WUF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *LPUART_Type) SetISR_RWU(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *LPUART_Type) GetISR_RWU() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *LPUART_Type) SetISR_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART_Type) GetISR_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *LPUART_Type) SetISR_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART_Type) GetISR_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *LPUART_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *LPUART_Type) SetISR_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *LPUART_Type) GetISR_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *LPUART_Type) SetISR_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetISR_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *LPUART_Type) GetISR_TXE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *LPUART_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPUART_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPUART_Type) SetISR_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetISR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetISR_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetISR_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetISR_NE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetISR_NE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetISR_FE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetISR_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetISR_PE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetISR_PE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LPUART.ICR: Interrupt flag clear register
func (o *LPUART_Type) SetICR_WUCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *LPUART_Type) GetICR_WUCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}
func (o *LPUART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *LPUART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetICR_NCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetICR_NCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LPUART.RDR: Receive data register
func (o *LPUART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *LPUART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// LPUART.TDR: Transmit data register
func (o *LPUART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *LPUART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// LPUART.PRESC: Prescaler register
func (o *LPUART_Type) SetPRESC_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESC.Reg, volatile.LoadUint32(&o.PRESC.Reg)&^(0xf)|value)
}
func (o *LPUART_Type) GetPRESC_PRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESC.Reg) & 0xf
}

// System configuration controller
type SYSCFG_Type struct {
	_       [4]byte
	PMCR    volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [8]byte
	CCCSR   volatile.Register32 // 0x20
	CCVR    volatile.Register32 // 0x24
	CCCR    volatile.Register32 // 0x28
	PWRCR   volatile.Register32 // 0x2C
	_       [244]byte
	PKGR    volatile.Register32 // 0x124
	_       [472]byte
	UR0     volatile.Register32 // 0x300
	_       [4]byte
	UR2     volatile.Register32 // 0x308
	UR3     volatile.Register32 // 0x30C
	UR4     volatile.Register32 // 0x310
	UR5     volatile.Register32 // 0x314
	UR6     volatile.Register32 // 0x318
	UR7     volatile.Register32 // 0x31C
	UR8     volatile.Register32 // 0x320
	UR9     volatile.Register32 // 0x324
	UR10    volatile.Register32 // 0x328
	UR11    volatile.Register32 // 0x32C
	UR12    volatile.Register32 // 0x330
	UR13    volatile.Register32 // 0x334
	UR14    volatile.Register32 // 0x338
	UR15    volatile.Register32 // 0x33C
	UR16    volatile.Register32 // 0x340
	UR17    volatile.Register32 // 0x344
}

// SYSCFG.PMCR: peripheral mode configuration register
func (o *SYSCFG_Type) SetPMCR_I2C1FMP(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetPMCR_I2C1FMP() uint32 {
	return volatile.LoadUint32(&o.PMCR.Reg) & 0x1
}
func (o *SYSCFG_Type) SetPMCR_I2C2FMP(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetPMCR_I2C2FMP() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetPMCR_I2C3FMP(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetPMCR_I2C3FMP() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetPMCR_I2C4FMP(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetPMCR_I2C4FMP() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetPMCR_PB6FMP(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetPMCR_PB6FMP() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetPMCR_PB7FMP(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetPMCR_PB7FMP() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetPMCR_PB8FMP(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetPMCR_PB8FMP() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetPMCR_PB9FMP(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x80)|value<<7)
}
func (o *SYSCFG_Type) GetPMCR_PB9FMP() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x80) >> 7
}
func (o *SYSCFG_Type) SetPMCR_BOOSTE(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetPMCR_BOOSTE() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetPMCR_BOOSTVDDSEL(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x200)|value<<9)
}
func (o *SYSCFG_Type) GetPMCR_BOOSTVDDSEL() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x200) >> 9
}
func (o *SYSCFG_Type) SetPMCR_EPIS(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0xe00000)|value<<21)
}
func (o *SYSCFG_Type) GetPMCR_EPIS() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0xe00000) >> 21
}
func (o *SYSCFG_Type) SetPMCR_PA0SO(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCFG_Type) GetPMCR_PA0SO() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x1000000) >> 24
}
func (o *SYSCFG_Type) SetPMCR_PA1SO(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCFG_Type) GetPMCR_PA1SO() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x2000000) >> 25
}
func (o *SYSCFG_Type) SetPMCR_PC2SO(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCFG_Type) GetPMCR_PC2SO() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x4000000) >> 26
}
func (o *SYSCFG_Type) SetPMCR_PC3SO(value uint32) {
	volatile.StoreUint32(&o.PMCR.Reg, volatile.LoadUint32(&o.PMCR.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCFG_Type) GetPMCR_PC3SO() uint32 {
	return (volatile.LoadUint32(&o.PMCR.Reg) & 0x8000000) >> 27
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf
}

// SYSCFG.CCCSR: compensation cell control/status register
func (o *SYSCFG_Type) SetCCCSR_EN(value uint32) {
	volatile.StoreUint32(&o.CCCSR.Reg, volatile.LoadUint32(&o.CCCSR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCCCSR_EN() uint32 {
	return volatile.LoadUint32(&o.CCCSR.Reg) & 0x1
}
func (o *SYSCFG_Type) SetCCCSR_CS(value uint32) {
	volatile.StoreUint32(&o.CCCSR.Reg, volatile.LoadUint32(&o.CCCSR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetCCCSR_CS() uint32 {
	return (volatile.LoadUint32(&o.CCCSR.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetCCCSR_READY(value uint32) {
	volatile.StoreUint32(&o.CCCSR.Reg, volatile.LoadUint32(&o.CCCSR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCCCSR_READY() uint32 {
	return (volatile.LoadUint32(&o.CCCSR.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetCCCSR_HSLV(value uint32) {
	volatile.StoreUint32(&o.CCCSR.Reg, volatile.LoadUint32(&o.CCCSR.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetCCCSR_HSLV() uint32 {
	return (volatile.LoadUint32(&o.CCCSR.Reg) & 0x10000) >> 16
}

// SYSCFG.CCVR: SYSCFG compensation cell value register
func (o *SYSCFG_Type) SetCCVR_NCV(value uint32) {
	volatile.StoreUint32(&o.CCVR.Reg, volatile.LoadUint32(&o.CCVR.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetCCVR_NCV() uint32 {
	return volatile.LoadUint32(&o.CCVR.Reg) & 0xf
}
func (o *SYSCFG_Type) SetCCVR_PCV(value uint32) {
	volatile.StoreUint32(&o.CCVR.Reg, volatile.LoadUint32(&o.CCVR.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetCCVR_PCV() uint32 {
	return (volatile.LoadUint32(&o.CCVR.Reg) & 0xf0) >> 4
}

// SYSCFG.CCCR: SYSCFG compensation cell code register
func (o *SYSCFG_Type) SetCCCR_NCC(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetCCCR_NCC() uint32 {
	return volatile.LoadUint32(&o.CCCR.Reg) & 0xf
}
func (o *SYSCFG_Type) SetCCCR_PCC(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetCCCR_PCC() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0xf0) >> 4
}

// SYSCFG.PWRCR: SYSCFG power control register
func (o *SYSCFG_Type) SetPWRCR_ODEN(value uint32) {
	volatile.StoreUint32(&o.PWRCR.Reg, volatile.LoadUint32(&o.PWRCR.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetPWRCR_ODEN() uint32 {
	return volatile.LoadUint32(&o.PWRCR.Reg) & 0xf
}

// SYSCFG.PKGR: SYSCFG package register
func (o *SYSCFG_Type) SetPKGR_PKG(value uint32) {
	volatile.StoreUint32(&o.PKGR.Reg, volatile.LoadUint32(&o.PKGR.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetPKGR_PKG() uint32 {
	return volatile.LoadUint32(&o.PKGR.Reg) & 0xf
}

// SYSCFG.UR0: SYSCFG user register 0
func (o *SYSCFG_Type) SetUR0_BKS(value uint32) {
	volatile.StoreUint32(&o.UR0.Reg, volatile.LoadUint32(&o.UR0.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetUR0_BKS() uint32 {
	return volatile.LoadUint32(&o.UR0.Reg) & 0x1
}
func (o *SYSCFG_Type) SetUR0_RDP(value uint32) {
	volatile.StoreUint32(&o.UR0.Reg, volatile.LoadUint32(&o.UR0.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSCFG_Type) GetUR0_RDP() uint32 {
	return (volatile.LoadUint32(&o.UR0.Reg) & 0xff0000) >> 16
}

// SYSCFG.UR2: SYSCFG user register 2
func (o *SYSCFG_Type) SetUR2_BORH(value uint32) {
	volatile.StoreUint32(&o.UR2.Reg, volatile.LoadUint32(&o.UR2.Reg)&^(0x3)|value)
}
func (o *SYSCFG_Type) GetUR2_BORH() uint32 {
	return volatile.LoadUint32(&o.UR2.Reg) & 0x3
}
func (o *SYSCFG_Type) SetUR2_BOOT_ADD0(value uint32) {
	volatile.StoreUint32(&o.UR2.Reg, volatile.LoadUint32(&o.UR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSCFG_Type) GetUR2_BOOT_ADD0() uint32 {
	return (volatile.LoadUint32(&o.UR2.Reg) & 0xffff0000) >> 16
}

// SYSCFG.UR3: SYSCFG user register 3
func (o *SYSCFG_Type) SetUR3_BOOT_ADD1(value uint32) {
	volatile.StoreUint32(&o.UR3.Reg, volatile.LoadUint32(&o.UR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSCFG_Type) GetUR3_BOOT_ADD1() uint32 {
	return (volatile.LoadUint32(&o.UR3.Reg) & 0xffff0000) >> 16
}

// SYSCFG.UR4: SYSCFG user register 4
func (o *SYSCFG_Type) SetUR4_MEPAD_1(value uint32) {
	volatile.StoreUint32(&o.UR4.Reg, volatile.LoadUint32(&o.UR4.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetUR4_MEPAD_1() uint32 {
	return (volatile.LoadUint32(&o.UR4.Reg) & 0x10000) >> 16
}

// SYSCFG.UR5: SYSCFG user register 5
func (o *SYSCFG_Type) SetUR5_MESAD_1(value uint32) {
	volatile.StoreUint32(&o.UR5.Reg, volatile.LoadUint32(&o.UR5.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetUR5_MESAD_1() uint32 {
	return volatile.LoadUint32(&o.UR5.Reg) & 0x1
}
func (o *SYSCFG_Type) SetUR5_WRPN_1(value uint32) {
	volatile.StoreUint32(&o.UR5.Reg, volatile.LoadUint32(&o.UR5.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSCFG_Type) GetUR5_WRPN_1() uint32 {
	return (volatile.LoadUint32(&o.UR5.Reg) & 0xff0000) >> 16
}

// SYSCFG.UR6: SYSCFG user register 6
func (o *SYSCFG_Type) SetUR6_PA_BEG_1(value uint32) {
	volatile.StoreUint32(&o.UR6.Reg, volatile.LoadUint32(&o.UR6.Reg)&^(0xfff)|value)
}
func (o *SYSCFG_Type) GetUR6_PA_BEG_1() uint32 {
	return volatile.LoadUint32(&o.UR6.Reg) & 0xfff
}
func (o *SYSCFG_Type) SetUR6_PA_END_1(value uint32) {
	volatile.StoreUint32(&o.UR6.Reg, volatile.LoadUint32(&o.UR6.Reg)&^(0xfff0000)|value<<16)
}
func (o *SYSCFG_Type) GetUR6_PA_END_1() uint32 {
	return (volatile.LoadUint32(&o.UR6.Reg) & 0xfff0000) >> 16
}

// SYSCFG.UR7: SYSCFG user register 7
func (o *SYSCFG_Type) SetUR7_SA_BEG_1(value uint32) {
	volatile.StoreUint32(&o.UR7.Reg, volatile.LoadUint32(&o.UR7.Reg)&^(0xfff)|value)
}
func (o *SYSCFG_Type) GetUR7_SA_BEG_1() uint32 {
	return volatile.LoadUint32(&o.UR7.Reg) & 0xfff
}
func (o *SYSCFG_Type) SetUR7_SA_END_1(value uint32) {
	volatile.StoreUint32(&o.UR7.Reg, volatile.LoadUint32(&o.UR7.Reg)&^(0xfff0000)|value<<16)
}
func (o *SYSCFG_Type) GetUR7_SA_END_1() uint32 {
	return (volatile.LoadUint32(&o.UR7.Reg) & 0xfff0000) >> 16
}

// SYSCFG.UR8: SYSCFG user register 8
func (o *SYSCFG_Type) SetUR8_MEPAD_2(value uint32) {
	volatile.StoreUint32(&o.UR8.Reg, volatile.LoadUint32(&o.UR8.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetUR8_MEPAD_2() uint32 {
	return volatile.LoadUint32(&o.UR8.Reg) & 0x1
}
func (o *SYSCFG_Type) SetUR8_MESAD_2(value uint32) {
	volatile.StoreUint32(&o.UR8.Reg, volatile.LoadUint32(&o.UR8.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetUR8_MESAD_2() uint32 {
	return (volatile.LoadUint32(&o.UR8.Reg) & 0x10000) >> 16
}

// SYSCFG.UR9: SYSCFG user register 9
func (o *SYSCFG_Type) SetUR9_WRPN_2(value uint32) {
	volatile.StoreUint32(&o.UR9.Reg, volatile.LoadUint32(&o.UR9.Reg)&^(0xff)|value)
}
func (o *SYSCFG_Type) GetUR9_WRPN_2() uint32 {
	return volatile.LoadUint32(&o.UR9.Reg) & 0xff
}
func (o *SYSCFG_Type) SetUR9_PA_BEG_2(value uint32) {
	volatile.StoreUint32(&o.UR9.Reg, volatile.LoadUint32(&o.UR9.Reg)&^(0xfff0000)|value<<16)
}
func (o *SYSCFG_Type) GetUR9_PA_BEG_2() uint32 {
	return (volatile.LoadUint32(&o.UR9.Reg) & 0xfff0000) >> 16
}

// SYSCFG.UR10: SYSCFG user register 10
func (o *SYSCFG_Type) SetUR10_PA_END_2(value uint32) {
	volatile.StoreUint32(&o.UR10.Reg, volatile.LoadUint32(&o.UR10.Reg)&^(0xfff)|value)
}
func (o *SYSCFG_Type) GetUR10_PA_END_2() uint32 {
	return volatile.LoadUint32(&o.UR10.Reg) & 0xfff
}
func (o *SYSCFG_Type) SetUR10_SA_BEG_2(value uint32) {
	volatile.StoreUint32(&o.UR10.Reg, volatile.LoadUint32(&o.UR10.Reg)&^(0xfff0000)|value<<16)
}
func (o *SYSCFG_Type) GetUR10_SA_BEG_2() uint32 {
	return (volatile.LoadUint32(&o.UR10.Reg) & 0xfff0000) >> 16
}

// SYSCFG.UR11: SYSCFG user register 11
func (o *SYSCFG_Type) SetUR11_SA_END_2(value uint32) {
	volatile.StoreUint32(&o.UR11.Reg, volatile.LoadUint32(&o.UR11.Reg)&^(0xfff)|value)
}
func (o *SYSCFG_Type) GetUR11_SA_END_2() uint32 {
	return volatile.LoadUint32(&o.UR11.Reg) & 0xfff
}
func (o *SYSCFG_Type) SetUR11_IWDG1M(value uint32) {
	volatile.StoreUint32(&o.UR11.Reg, volatile.LoadUint32(&o.UR11.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetUR11_IWDG1M() uint32 {
	return (volatile.LoadUint32(&o.UR11.Reg) & 0x10000) >> 16
}

// SYSCFG.UR12: SYSCFG user register 12
func (o *SYSCFG_Type) SetUR12_SECURE(value uint32) {
	volatile.StoreUint32(&o.UR12.Reg, volatile.LoadUint32(&o.UR12.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetUR12_SECURE() uint32 {
	return (volatile.LoadUint32(&o.UR12.Reg) & 0x10000) >> 16
}

// SYSCFG.UR13: SYSCFG user register 13
func (o *SYSCFG_Type) SetUR13_SDRS(value uint32) {
	volatile.StoreUint32(&o.UR13.Reg, volatile.LoadUint32(&o.UR13.Reg)&^(0x3)|value)
}
func (o *SYSCFG_Type) GetUR13_SDRS() uint32 {
	return volatile.LoadUint32(&o.UR13.Reg) & 0x3
}
func (o *SYSCFG_Type) SetUR13_D1SBRST(value uint32) {
	volatile.StoreUint32(&o.UR13.Reg, volatile.LoadUint32(&o.UR13.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetUR13_D1SBRST() uint32 {
	return (volatile.LoadUint32(&o.UR13.Reg) & 0x10000) >> 16
}

// SYSCFG.UR14: SYSCFG user register 14
func (o *SYSCFG_Type) SetUR14_D1STPRST(value uint32) {
	volatile.StoreUint32(&o.UR14.Reg, volatile.LoadUint32(&o.UR14.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetUR14_D1STPRST() uint32 {
	return volatile.LoadUint32(&o.UR14.Reg) & 0x1
}

// SYSCFG.UR15: SYSCFG user register 15
func (o *SYSCFG_Type) SetUR15_FZIWDGSTB(value uint32) {
	volatile.StoreUint32(&o.UR15.Reg, volatile.LoadUint32(&o.UR15.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetUR15_FZIWDGSTB() uint32 {
	return (volatile.LoadUint32(&o.UR15.Reg) & 0x10000) >> 16
}

// SYSCFG.UR16: SYSCFG user register 16
func (o *SYSCFG_Type) SetUR16_FZIWDGSTP(value uint32) {
	volatile.StoreUint32(&o.UR16.Reg, volatile.LoadUint32(&o.UR16.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetUR16_FZIWDGSTP() uint32 {
	return volatile.LoadUint32(&o.UR16.Reg) & 0x1
}
func (o *SYSCFG_Type) SetUR16_PKP(value uint32) {
	volatile.StoreUint32(&o.UR16.Reg, volatile.LoadUint32(&o.UR16.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetUR16_PKP() uint32 {
	return (volatile.LoadUint32(&o.UR16.Reg) & 0x10000) >> 16
}

// SYSCFG.UR17: SYSCFG user register 17
func (o *SYSCFG_Type) SetUR17_IO_HSLV(value uint32) {
	volatile.StoreUint32(&o.UR17.Reg, volatile.LoadUint32(&o.UR17.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetUR17_IO_HSLV() uint32 {
	return volatile.LoadUint32(&o.UR17.Reg) & 0x1
}

// External interrupt/event controller
type EXTI_Type struct {
	RTSR1   volatile.Register32 // 0x0
	FTSR1   volatile.Register32 // 0x4
	SWIER1  volatile.Register32 // 0x8
	D3PMR1  volatile.Register32 // 0xC
	D3PCR1L volatile.Register32 // 0x10
	D3PCR1H volatile.Register32 // 0x14
	_       [8]byte
	RTSR2   volatile.Register32 // 0x20
	FTSR2   volatile.Register32 // 0x24
	SWIER2  volatile.Register32 // 0x28
	D3PMR2  volatile.Register32 // 0x2C
	D3PCR2L volatile.Register32 // 0x30
	D3PCR2H volatile.Register32 // 0x34
	_       [8]byte
	RTSR3   volatile.Register32 // 0x40
	FTSR3   volatile.Register32 // 0x44
	SWIER3  volatile.Register32 // 0x48
	D3PMR3  volatile.Register32 // 0x4C
	_       [4]byte
	D3PCR3H volatile.Register32 // 0x54
	_       [40]byte
	CPUIMR1 volatile.Register32 // 0x80
	CPUEMR1 volatile.Register32 // 0x84
	CPUPR1  volatile.Register32 // 0x88
	_       [4]byte
	CPUIMR2 volatile.Register32 // 0x90
	CPUEMR2 volatile.Register32 // 0x94
	CPUPR2  volatile.Register32 // 0x98
	_       [4]byte
	CPUIMR3 volatile.Register32 // 0xA0
	CPUEMR3 volatile.Register32 // 0xA4
	CPUPR3  volatile.Register32 // 0xA8
}

// EXTI.RTSR1: EXTI rising trigger selection register
func (o *EXTI_Type) SetRTSR1_TR0(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR1_TR0() uint32 {
	return volatile.LoadUint32(&o.RTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR1_TR1(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR1_TR1() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR1_TR2(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR1_TR2() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR1_TR3(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR1_TR3() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR1_TR4(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR1_TR4() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR1_TR5(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR1_TR5() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR1_TR6(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR1_TR6() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR1_TR7(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR1_TR7() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR1_TR8(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR1_TR8() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR1_TR9(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR1_TR9() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR1_TR10(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR1_TR10() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR1_TR11(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR1_TR11() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR1_TR12(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR1_TR12() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR1_TR13(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR1_TR13() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR1_TR14(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR1_TR14() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR1_TR15(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR1_TR15() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR1_TR16(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR1_TR16() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR1_TR17(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR1_TR17() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR1_TR18(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR1_TR18() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR1_TR19(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR1_TR19() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR1_TR20(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR1_TR20() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR1_TR21(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR1_TR21() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200000) >> 21
}

// EXTI.FTSR1: EXTI falling trigger selection register
func (o *EXTI_Type) SetFTSR1_TR0(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR1_TR0() uint32 {
	return volatile.LoadUint32(&o.FTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR1_TR1(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR1_TR1() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR1_TR2(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR1_TR2() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR1_TR3(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR1_TR3() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR1_TR4(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR1_TR4() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR1_TR5(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR1_TR5() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR1_TR6(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR1_TR6() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR1_TR7(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR1_TR7() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR1_TR8(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR1_TR8() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR1_TR9(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR1_TR9() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR1_TR10(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR1_TR10() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR1_TR11(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR1_TR11() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR1_TR12(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR1_TR12() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR1_TR13(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR1_TR13() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR1_TR14(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR1_TR14() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR1_TR15(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR1_TR15() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR1_TR16(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR1_TR16() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR1_TR17(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR1_TR17() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR1_TR18(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR1_TR18() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR1_TR19(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR1_TR19() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR1_TR20(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR1_TR20() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR1_TR21(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR1_TR21() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200000) >> 21
}

// EXTI.SWIER1: EXTI software interrupt event register
func (o *EXTI_Type) SetSWIER1_SWIER0(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER1_SWIER0() uint32 {
	return volatile.LoadUint32(&o.SWIER1.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER1(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER1() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER1_SWIER2(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER1_SWIER2() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER1_SWIER3(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER1_SWIER3() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER1_SWIER4(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER1_SWIER4() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER1_SWIER5(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER1_SWIER5() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER1_SWIER6(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER1_SWIER6() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER1_SWIER7(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER1_SWIER7() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER1_SWIER8(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER1_SWIER8() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER1_SWIER9(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER1_SWIER9() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER1_SWIER10(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER1_SWIER10() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER1_SWIER11(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER1_SWIER11() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER1_SWIER12(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER1_SWIER12() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER1_SWIER13(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER1_SWIER13() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER1_SWIER14(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER1_SWIER14() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER1_SWIER15(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER1_SWIER15() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER1_SWIER16(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER1_SWIER16() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER1_SWIER17(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER1_SWIER17() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER1_SWIER18(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER1_SWIER18() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER1_SWIER19(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER1_SWIER19() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER1_SWIER20(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER1_SWIER20() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER1_SWIER21(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER1_SWIER21() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200000) >> 21
}

// EXTI.D3PMR1: EXTI D3 pending mask register
func (o *EXTI_Type) SetD3PMR1_MR0(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetD3PMR1_MR0() uint32 {
	return volatile.LoadUint32(&o.D3PMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetD3PMR1_MR1(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetD3PMR1_MR1() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetD3PMR1_MR2(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetD3PMR1_MR2() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetD3PMR1_MR3(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetD3PMR1_MR3() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetD3PMR1_MR4(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetD3PMR1_MR4() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetD3PMR1_MR5(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetD3PMR1_MR5() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetD3PMR1_MR6(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetD3PMR1_MR6() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetD3PMR1_MR7(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetD3PMR1_MR7() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetD3PMR1_MR8(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetD3PMR1_MR8() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetD3PMR1_MR9(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetD3PMR1_MR9() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetD3PMR1_MR10(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetD3PMR1_MR10() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetD3PMR1_MR11(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetD3PMR1_MR11() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetD3PMR1_MR12(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetD3PMR1_MR12() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetD3PMR1_MR13(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetD3PMR1_MR13() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetD3PMR1_MR14(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetD3PMR1_MR14() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetD3PMR1_MR15(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetD3PMR1_MR15() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetD3PMR1_MR19(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetD3PMR1_MR19() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetD3PMR1_MR20(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetD3PMR1_MR20() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetD3PMR1_MR21(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetD3PMR1_MR21() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetD3PMR1_MR25(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetD3PMR1_MR25() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x2000000) >> 25
}

// EXTI.D3PCR1L: EXTI D3 pending clear selection register low
func (o *EXTI_Type) SetD3PCR1L_PCS0(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x3)|value)
}
func (o *EXTI_Type) GetD3PCR1L_PCS0() uint32 {
	return volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x3
}
func (o *EXTI_Type) SetD3PCR1L_PCS1(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc)|value<<2)
}
func (o *EXTI_Type) GetD3PCR1L_PCS1() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc) >> 2
}
func (o *EXTI_Type) SetD3PCR1L_PCS2(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x30)|value<<4)
}
func (o *EXTI_Type) GetD3PCR1L_PCS2() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x30) >> 4
}
func (o *EXTI_Type) SetD3PCR1L_PCS3(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc0)|value<<6)
}
func (o *EXTI_Type) GetD3PCR1L_PCS3() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc0) >> 6
}
func (o *EXTI_Type) SetD3PCR1L_PCS4(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetD3PCR1L_PCS4() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x300) >> 8
}
func (o *EXTI_Type) SetD3PCR1L_PCS5(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc00)|value<<10)
}
func (o *EXTI_Type) GetD3PCR1L_PCS5() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc00) >> 10
}
func (o *EXTI_Type) SetD3PCR1L_PCS6(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x3000)|value<<12)
}
func (o *EXTI_Type) GetD3PCR1L_PCS6() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x3000) >> 12
}
func (o *EXTI_Type) SetD3PCR1L_PCS7(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc000)|value<<14)
}
func (o *EXTI_Type) GetD3PCR1L_PCS7() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc000) >> 14
}
func (o *EXTI_Type) SetD3PCR1L_PCS8(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x30000)|value<<16)
}
func (o *EXTI_Type) GetD3PCR1L_PCS8() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x30000) >> 16
}
func (o *EXTI_Type) SetD3PCR1L_PCS9(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc0000)|value<<18)
}
func (o *EXTI_Type) GetD3PCR1L_PCS9() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc0000) >> 18
}
func (o *EXTI_Type) SetD3PCR1L_PCS10(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x300000)|value<<20)
}
func (o *EXTI_Type) GetD3PCR1L_PCS10() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x300000) >> 20
}
func (o *EXTI_Type) SetD3PCR1L_PCS11(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc00000)|value<<22)
}
func (o *EXTI_Type) GetD3PCR1L_PCS11() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc00000) >> 22
}
func (o *EXTI_Type) SetD3PCR1L_PCS12(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x3000000)|value<<24)
}
func (o *EXTI_Type) GetD3PCR1L_PCS12() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x3000000) >> 24
}
func (o *EXTI_Type) SetD3PCR1L_PCS13(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc000000)|value<<26)
}
func (o *EXTI_Type) GetD3PCR1L_PCS13() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc000000) >> 26
}
func (o *EXTI_Type) SetD3PCR1L_PCS14(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x30000000)|value<<28)
}
func (o *EXTI_Type) GetD3PCR1L_PCS14() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x30000000) >> 28
}
func (o *EXTI_Type) SetD3PCR1L_PCS15(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc0000000)|value<<30)
}
func (o *EXTI_Type) GetD3PCR1L_PCS15() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc0000000) >> 30
}

// EXTI.D3PCR1H: EXTI D3 pending clear selection register high
func (o *EXTI_Type) SetD3PCR1H_PCS19(value uint32) {
	volatile.StoreUint32(&o.D3PCR1H.Reg, volatile.LoadUint32(&o.D3PCR1H.Reg)&^(0xc0)|value<<6)
}
func (o *EXTI_Type) GetD3PCR1H_PCS19() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1H.Reg) & 0xc0) >> 6
}
func (o *EXTI_Type) SetD3PCR1H_PCS20(value uint32) {
	volatile.StoreUint32(&o.D3PCR1H.Reg, volatile.LoadUint32(&o.D3PCR1H.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetD3PCR1H_PCS20() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1H.Reg) & 0x300) >> 8
}
func (o *EXTI_Type) SetD3PCR1H_PCS21(value uint32) {
	volatile.StoreUint32(&o.D3PCR1H.Reg, volatile.LoadUint32(&o.D3PCR1H.Reg)&^(0xc00)|value<<10)
}
func (o *EXTI_Type) GetD3PCR1H_PCS21() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1H.Reg) & 0xc00) >> 10
}
func (o *EXTI_Type) SetD3PCR1H_PCS25(value uint32) {
	volatile.StoreUint32(&o.D3PCR1H.Reg, volatile.LoadUint32(&o.D3PCR1H.Reg)&^(0xc0000)|value<<18)
}
func (o *EXTI_Type) GetD3PCR1H_PCS25() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1H.Reg) & 0xc0000) >> 18
}

// EXTI.RTSR2: EXTI rising trigger selection register
func (o *EXTI_Type) SetRTSR2_TR49(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR2_TR49() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR2_TR51(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR2_TR51() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x80000) >> 19
}

// EXTI.FTSR2: EXTI falling trigger selection register
func (o *EXTI_Type) SetFTSR2_TR49(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR2_TR49() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR2_TR51(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR2_TR51() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x80000) >> 19
}

// EXTI.SWIER2: EXTI software interrupt event register
func (o *EXTI_Type) SetSWIER2_SWIER49(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER2_SWIER49() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER2_SWIER51(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER2_SWIER51() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x80000) >> 19
}

// EXTI.D3PMR2: EXTI D3 pending mask register
func (o *EXTI_Type) SetD3PMR2_MR34(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetD3PMR2_MR34() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetD3PMR2_MR35(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetD3PMR2_MR35() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetD3PMR2_MR41(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetD3PMR2_MR41() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetD3PMR2_MR48(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetD3PMR2_MR48() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetD3PMR2_MR49(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetD3PMR2_MR49() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetD3PMR2_MR50(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetD3PMR2_MR50() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetD3PMR2_MR51(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetD3PMR2_MR51() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetD3PMR2_MR52(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetD3PMR2_MR52() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetD3PMR2_MR53(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetD3PMR2_MR53() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x200000) >> 21
}

// EXTI.D3PCR2L: EXTI D3 pending clear selection register low
func (o *EXTI_Type) SetD3PCR2L_PCS35(value uint32) {
	volatile.StoreUint32(&o.D3PCR2L.Reg, volatile.LoadUint32(&o.D3PCR2L.Reg)&^(0xc0)|value<<6)
}
func (o *EXTI_Type) GetD3PCR2L_PCS35() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2L.Reg) & 0xc0) >> 6
}
func (o *EXTI_Type) SetD3PCR2L_PCS34(value uint32) {
	volatile.StoreUint32(&o.D3PCR2L.Reg, volatile.LoadUint32(&o.D3PCR2L.Reg)&^(0x30)|value<<4)
}
func (o *EXTI_Type) GetD3PCR2L_PCS34() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2L.Reg) & 0x30) >> 4
}
func (o *EXTI_Type) SetD3PCR2L_PCS41(value uint32) {
	volatile.StoreUint32(&o.D3PCR2L.Reg, volatile.LoadUint32(&o.D3PCR2L.Reg)&^(0xc0000)|value<<18)
}
func (o *EXTI_Type) GetD3PCR2L_PCS41() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2L.Reg) & 0xc0000) >> 18
}

// EXTI.D3PCR2H: EXTI D3 pending clear selection register high
func (o *EXTI_Type) SetD3PCR2H_PCS48(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0x3)|value)
}
func (o *EXTI_Type) GetD3PCR2H_PCS48() uint32 {
	return volatile.LoadUint32(&o.D3PCR2H.Reg) & 0x3
}
func (o *EXTI_Type) SetD3PCR2H_PCS49(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0xc)|value<<2)
}
func (o *EXTI_Type) GetD3PCR2H_PCS49() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2H.Reg) & 0xc) >> 2
}
func (o *EXTI_Type) SetD3PCR2H_PCS50(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0x30)|value<<4)
}
func (o *EXTI_Type) GetD3PCR2H_PCS50() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2H.Reg) & 0x30) >> 4
}
func (o *EXTI_Type) SetD3PCR2H_PCS51(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0xc0)|value<<6)
}
func (o *EXTI_Type) GetD3PCR2H_PCS51() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2H.Reg) & 0xc0) >> 6
}
func (o *EXTI_Type) SetD3PCR2H_PCS52(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetD3PCR2H_PCS52() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2H.Reg) & 0x300) >> 8
}
func (o *EXTI_Type) SetD3PCR2H_PCS53(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0xc00)|value<<10)
}
func (o *EXTI_Type) GetD3PCR2H_PCS53() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2H.Reg) & 0xc00) >> 10
}

// EXTI.RTSR3: EXTI rising trigger selection register
func (o *EXTI_Type) SetRTSR3_TR82(value uint32) {
	volatile.StoreUint32(&o.RTSR3.Reg, volatile.LoadUint32(&o.RTSR3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR3_TR82() uint32 {
	return (volatile.LoadUint32(&o.RTSR3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR3_TR84(value uint32) {
	volatile.StoreUint32(&o.RTSR3.Reg, volatile.LoadUint32(&o.RTSR3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR3_TR84() uint32 {
	return (volatile.LoadUint32(&o.RTSR3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR3_TR85(value uint32) {
	volatile.StoreUint32(&o.RTSR3.Reg, volatile.LoadUint32(&o.RTSR3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR3_TR85() uint32 {
	return (volatile.LoadUint32(&o.RTSR3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR3_TR86(value uint32) {
	volatile.StoreUint32(&o.RTSR3.Reg, volatile.LoadUint32(&o.RTSR3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR3_TR86() uint32 {
	return (volatile.LoadUint32(&o.RTSR3.Reg) & 0x400000) >> 22
}

// EXTI.FTSR3: EXTI falling trigger selection register
func (o *EXTI_Type) SetFTSR3_TR82(value uint32) {
	volatile.StoreUint32(&o.FTSR3.Reg, volatile.LoadUint32(&o.FTSR3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR3_TR82() uint32 {
	return (volatile.LoadUint32(&o.FTSR3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR3_TR84(value uint32) {
	volatile.StoreUint32(&o.FTSR3.Reg, volatile.LoadUint32(&o.FTSR3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR3_TR84() uint32 {
	return (volatile.LoadUint32(&o.FTSR3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR3_TR85(value uint32) {
	volatile.StoreUint32(&o.FTSR3.Reg, volatile.LoadUint32(&o.FTSR3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR3_TR85() uint32 {
	return (volatile.LoadUint32(&o.FTSR3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR3_TR86(value uint32) {
	volatile.StoreUint32(&o.FTSR3.Reg, volatile.LoadUint32(&o.FTSR3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR3_TR86() uint32 {
	return (volatile.LoadUint32(&o.FTSR3.Reg) & 0x400000) >> 22
}

// EXTI.SWIER3: EXTI software interrupt event register
func (o *EXTI_Type) SetSWIER3_SWIER82(value uint32) {
	volatile.StoreUint32(&o.SWIER3.Reg, volatile.LoadUint32(&o.SWIER3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER3_SWIER82() uint32 {
	return (volatile.LoadUint32(&o.SWIER3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER3_SWIER84(value uint32) {
	volatile.StoreUint32(&o.SWIER3.Reg, volatile.LoadUint32(&o.SWIER3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER3_SWIER84() uint32 {
	return (volatile.LoadUint32(&o.SWIER3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER3_SWIER85(value uint32) {
	volatile.StoreUint32(&o.SWIER3.Reg, volatile.LoadUint32(&o.SWIER3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER3_SWIER85() uint32 {
	return (volatile.LoadUint32(&o.SWIER3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER3_SWIER86(value uint32) {
	volatile.StoreUint32(&o.SWIER3.Reg, volatile.LoadUint32(&o.SWIER3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER3_SWIER86() uint32 {
	return (volatile.LoadUint32(&o.SWIER3.Reg) & 0x400000) >> 22
}

// EXTI.D3PMR3: EXTI D3 pending mask register
func (o *EXTI_Type) SetD3PMR3_MR88(value uint32) {
	volatile.StoreUint32(&o.D3PMR3.Reg, volatile.LoadUint32(&o.D3PMR3.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetD3PMR3_MR88() uint32 {
	return (volatile.LoadUint32(&o.D3PMR3.Reg) & 0x1000000) >> 24
}

// EXTI.D3PCR3H: EXTI D3 pending clear selection register high
func (o *EXTI_Type) SetD3PCR3H_PCS88(value uint32) {
	volatile.StoreUint32(&o.D3PCR3H.Reg, volatile.LoadUint32(&o.D3PCR3H.Reg)&^(0xc0000)|value<<18)
}
func (o *EXTI_Type) GetD3PCR3H_PCS88() uint32 {
	return (volatile.LoadUint32(&o.D3PCR3H.Reg) & 0xc0000) >> 18
}

// EXTI.CPUIMR1: EXTI interrupt mask register
func (o *EXTI_Type) SetCPUIMR1_MR0(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUIMR1_MR0() uint32 {
	return volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUIMR1_MR1(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUIMR1_MR1() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUIMR1_MR2(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUIMR1_MR2() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUIMR1_MR3(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUIMR1_MR3() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUIMR1_MR4(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUIMR1_MR4() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUIMR1_MR5(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUIMR1_MR5() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUIMR1_MR6(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUIMR1_MR6() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUIMR1_MR7(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUIMR1_MR7() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUIMR1_MR8(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUIMR1_MR8() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUIMR1_MR9(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUIMR1_MR9() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUIMR1_MR10(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUIMR1_MR10() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUIMR1_MR11(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUIMR1_MR11() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUIMR1_MR12(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUIMR1_MR12() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUIMR1_MR13(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetCPUIMR1_MR13() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetCPUIMR1_MR14(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUIMR1_MR14() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUIMR1_MR15(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUIMR1_MR15() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUIMR1_MR16(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUIMR1_MR16() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUIMR1_MR17(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUIMR1_MR17() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUIMR1_MR18(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUIMR1_MR18() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUIMR1_MR19(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUIMR1_MR19() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetCPUIMR1_MR20(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUIMR1_MR20() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUIMR1_MR21(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUIMR1_MR21() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUIMR1_MR22(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUIMR1_MR22() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUIMR1_MR23(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUIMR1_MR23() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUIMR1_MR24(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUIMR1_MR24() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetCPUIMR1_MR25(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetCPUIMR1_MR25() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetCPUIMR1_MR26(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetCPUIMR1_MR26() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetCPUIMR1_MR27(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetCPUIMR1_MR27() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetCPUIMR1_MR28(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetCPUIMR1_MR28() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetCPUIMR1_MR29(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetCPUIMR1_MR29() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetCPUIMR1_MR30(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetCPUIMR1_MR30() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetCPUIMR1_MR31(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetCPUIMR1_MR31() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x80000000) >> 31
}

// EXTI.CPUEMR1: EXTI event mask register
func (o *EXTI_Type) SetCPUEMR1_MR0(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUEMR1_MR0() uint32 {
	return volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUEMR1_MR1(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUEMR1_MR1() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUEMR1_MR2(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUEMR1_MR2() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUEMR1_MR3(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUEMR1_MR3() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUEMR1_MR4(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUEMR1_MR4() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUEMR1_MR5(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUEMR1_MR5() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUEMR1_MR6(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUEMR1_MR6() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUEMR1_MR7(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUEMR1_MR7() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUEMR1_MR8(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUEMR1_MR8() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUEMR1_MR9(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUEMR1_MR9() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUEMR1_MR10(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUEMR1_MR10() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUEMR1_MR11(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUEMR1_MR11() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUEMR1_MR12(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUEMR1_MR12() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUEMR1_MR13(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetCPUEMR1_MR13() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetCPUEMR1_MR14(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUEMR1_MR14() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUEMR1_MR15(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUEMR1_MR15() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUEMR1_MR16(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUEMR1_MR16() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUEMR1_MR17(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUEMR1_MR17() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUEMR1_MR18(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUEMR1_MR18() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUEMR1_MR19(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUEMR1_MR19() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetCPUEMR1_MR20(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUEMR1_MR20() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUEMR1_MR21(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUEMR1_MR21() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUEMR1_MR22(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUEMR1_MR22() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUEMR1_MR23(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUEMR1_MR23() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUEMR1_MR24(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUEMR1_MR24() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetCPUEMR1_MR25(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetCPUEMR1_MR25() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetCPUEMR1_MR26(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetCPUEMR1_MR26() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetCPUEMR1_MR27(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetCPUEMR1_MR27() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetCPUEMR1_MR28(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetCPUEMR1_MR28() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetCPUEMR1_MR29(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetCPUEMR1_MR29() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetCPUEMR1_MR30(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetCPUEMR1_MR30() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetCPUEMR1_MR31(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetCPUEMR1_MR31() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x80000000) >> 31
}

// EXTI.CPUPR1: EXTI pending register
func (o *EXTI_Type) SetCPUPR1_PR0(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUPR1_PR0() uint32 {
	return volatile.LoadUint32(&o.CPUPR1.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUPR1_PR1(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUPR1_PR1() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUPR1_PR2(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUPR1_PR2() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUPR1_PR3(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUPR1_PR3() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUPR1_PR4(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUPR1_PR4() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUPR1_PR5(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUPR1_PR5() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUPR1_PR6(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUPR1_PR6() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUPR1_PR7(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUPR1_PR7() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUPR1_PR8(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUPR1_PR8() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUPR1_PR9(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUPR1_PR9() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUPR1_PR10(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUPR1_PR10() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUPR1_PR11(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUPR1_PR11() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUPR1_PR12(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUPR1_PR12() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUPR1_PR13(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetCPUPR1_PR13() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetCPUPR1_PR14(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUPR1_PR14() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUPR1_PR15(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUPR1_PR15() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUPR1_PR16(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUPR1_PR16() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUPR1_PR17(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUPR1_PR17() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUPR1_PR18(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUPR1_PR18() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUPR1_PR19(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUPR1_PR19() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetCPUPR1_PR20(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUPR1_PR20() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUPR1_PR21(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUPR1_PR21() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x200000) >> 21
}

// EXTI.CPUIMR2: EXTI interrupt mask register
func (o *EXTI_Type) SetCPUIMR2_MR0(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUIMR2_MR0() uint32 {
	return volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUIMR2_MR1(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUIMR2_MR1() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUIMR2_MR2(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUIMR2_MR2() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUIMR2_MR3(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUIMR2_MR3() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUIMR2_MR4(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUIMR2_MR4() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUIMR2_MR5(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUIMR2_MR5() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUIMR2_MR6(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUIMR2_MR6() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUIMR2_MR7(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUIMR2_MR7() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUIMR2_MR8(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUIMR2_MR8() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUIMR2_MR9(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUIMR2_MR9() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUIMR2_MR10(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUIMR2_MR10() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUIMR2_MR11(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUIMR2_MR11() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUIMR2_MR12(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUIMR2_MR12() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUIMR2_MR14(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUIMR2_MR14() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUIMR2_MR15(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUIMR2_MR15() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUIMR2_MR16(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUIMR2_MR16() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUIMR2_MR17(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUIMR2_MR17() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUIMR2_MR18(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUIMR2_MR18() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUIMR2_MR19(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUIMR2_MR19() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetCPUIMR2_MR20(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUIMR2_MR20() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUIMR2_MR21(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUIMR2_MR21() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUIMR2_MR22(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUIMR2_MR22() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUIMR2_MR23(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUIMR2_MR23() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUIMR2_MR24(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUIMR2_MR24() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetCPUIMR2_MR25(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetCPUIMR2_MR25() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetCPUIMR2_MR26(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetCPUIMR2_MR26() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetCPUIMR2_MR27(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetCPUIMR2_MR27() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetCPUIMR2_MR28(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetCPUIMR2_MR28() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetCPUIMR2_MR29(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetCPUIMR2_MR29() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetCPUIMR2_MR30(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetCPUIMR2_MR30() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetCPUIMR2_MR31(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetCPUIMR2_MR31() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x80000000) >> 31
}

// EXTI.CPUEMR2: EXTI event mask register
func (o *EXTI_Type) SetCPUEMR2_MR32(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUEMR2_MR32() uint32 {
	return volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUEMR2_MR33(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUEMR2_MR33() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUEMR2_MR34(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUEMR2_MR34() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUEMR2_MR35(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUEMR2_MR35() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUEMR2_MR36(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUEMR2_MR36() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUEMR2_MR37(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUEMR2_MR37() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUEMR2_MR38(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUEMR2_MR38() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUEMR2_MR39(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUEMR2_MR39() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUEMR2_MR40(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUEMR2_MR40() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUEMR2_MR41(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUEMR2_MR41() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUEMR2_MR42(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUEMR2_MR42() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUEMR2_MR43(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUEMR2_MR43() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUEMR2_MR44(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUEMR2_MR44() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUEMR2_MR46(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUEMR2_MR46() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUEMR2_MR47(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUEMR2_MR47() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUEMR2_MR48(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUEMR2_MR48() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUEMR2_MR49(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUEMR2_MR49() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUEMR2_MR50(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUEMR2_MR50() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUEMR2_MR51(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUEMR2_MR51() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetCPUEMR2_MR52(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUEMR2_MR52() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUEMR2_MR53(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUEMR2_MR53() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUEMR2_MR54(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUEMR2_MR54() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUEMR2_MR55(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUEMR2_MR55() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUEMR2_MR56(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUEMR2_MR56() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetCPUEMR2_MR57(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetCPUEMR2_MR57() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetCPUEMR2_MR58(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetCPUEMR2_MR58() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetCPUEMR2_MR59(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetCPUEMR2_MR59() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetCPUEMR2_MR60(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetCPUEMR2_MR60() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetCPUEMR2_MR61(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetCPUEMR2_MR61() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetCPUEMR2_MR62(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetCPUEMR2_MR62() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetCPUEMR2_MR63(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetCPUEMR2_MR63() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x80000000) >> 31
}

// EXTI.CPUPR2: EXTI pending register
func (o *EXTI_Type) SetCPUPR2_PR49(value uint32) {
	volatile.StoreUint32(&o.CPUPR2.Reg, volatile.LoadUint32(&o.CPUPR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUPR2_PR49() uint32 {
	return (volatile.LoadUint32(&o.CPUPR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUPR2_PR51(value uint32) {
	volatile.StoreUint32(&o.CPUPR2.Reg, volatile.LoadUint32(&o.CPUPR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUPR2_PR51() uint32 {
	return (volatile.LoadUint32(&o.CPUPR2.Reg) & 0x80000) >> 19
}

// EXTI.CPUIMR3: EXTI interrupt mask register
func (o *EXTI_Type) SetCPUIMR3_MR64(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUIMR3_MR64() uint32 {
	return volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUIMR3_MR65(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUIMR3_MR65() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUIMR3_MR66(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUIMR3_MR66() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUIMR3_MR67(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUIMR3_MR67() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUIMR3_MR68(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUIMR3_MR68() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUIMR3_MR69(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUIMR3_MR69() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUIMR3_MR70(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUIMR3_MR70() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUIMR3_MR71(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUIMR3_MR71() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUIMR3_MR72(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUIMR3_MR72() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUIMR3_MR73(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUIMR3_MR73() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUIMR3_MR74(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUIMR3_MR74() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUIMR3_MR75(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUIMR3_MR75() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUIMR3_MR76(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUIMR3_MR76() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUIMR3_MR77(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetCPUIMR3_MR77() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetCPUIMR3_MR78(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUIMR3_MR78() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUIMR3_MR79(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUIMR3_MR79() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUIMR3_MR80(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUIMR3_MR80() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUIMR3_MR82(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUIMR3_MR82() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUIMR3_MR84(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUIMR3_MR84() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUIMR3_MR85(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUIMR3_MR85() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUIMR3_MR86(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUIMR3_MR86() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUIMR3_MR87(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUIMR3_MR87() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUIMR3_MR88(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUIMR3_MR88() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x1000000) >> 24
}

// EXTI.CPUEMR3: EXTI event mask register
func (o *EXTI_Type) SetCPUEMR3_MR64(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUEMR3_MR64() uint32 {
	return volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUEMR3_MR65(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUEMR3_MR65() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUEMR3_MR66(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUEMR3_MR66() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUEMR3_MR67(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUEMR3_MR67() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUEMR3_MR68(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUEMR3_MR68() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUEMR3_MR69(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUEMR3_MR69() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUEMR3_MR70(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUEMR3_MR70() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUEMR3_MR71(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUEMR3_MR71() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUEMR3_MR72(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUEMR3_MR72() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUEMR3_MR73(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUEMR3_MR73() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUEMR3_MR74(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUEMR3_MR74() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUEMR3_MR75(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUEMR3_MR75() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUEMR3_MR76(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUEMR3_MR76() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUEMR3_MR77(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetCPUEMR3_MR77() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetCPUEMR3_MR78(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUEMR3_MR78() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUEMR3_MR79(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUEMR3_MR79() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUEMR3_MR80(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUEMR3_MR80() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUEMR3_MR82(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUEMR3_MR82() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUEMR3_MR84(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUEMR3_MR84() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUEMR3_MR85(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUEMR3_MR85() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUEMR3_MR86(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUEMR3_MR86() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUEMR3_MR87(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUEMR3_MR87() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUEMR3_MR88(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUEMR3_MR88() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x1000000) >> 24
}

// EXTI.CPUPR3: EXTI pending register
func (o *EXTI_Type) SetCPUPR3_PR82(value uint32) {
	volatile.StoreUint32(&o.CPUPR3.Reg, volatile.LoadUint32(&o.CPUPR3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUPR3_PR82() uint32 {
	return (volatile.LoadUint32(&o.CPUPR3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUPR3_PR84(value uint32) {
	volatile.StoreUint32(&o.CPUPR3.Reg, volatile.LoadUint32(&o.CPUPR3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUPR3_PR84() uint32 {
	return (volatile.LoadUint32(&o.CPUPR3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUPR3_PR85(value uint32) {
	volatile.StoreUint32(&o.CPUPR3.Reg, volatile.LoadUint32(&o.CPUPR3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUPR3_PR85() uint32 {
	return (volatile.LoadUint32(&o.CPUPR3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUPR3_PR86(value uint32) {
	volatile.StoreUint32(&o.CPUPR3.Reg, volatile.LoadUint32(&o.CPUPR3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUPR3_PR86() uint32 {
	return (volatile.LoadUint32(&o.CPUPR3.Reg) & 0x400000) >> 22
}

// DELAY_Block_SDMMC1
type DLYB_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
}

// DLYB.CR: DLYB control register
func (o *DLYB_Type) SetCR_DEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DLYB_Type) GetCR_DEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DLYB_Type) SetCR_SEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DLYB_Type) GetCR_SEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}

// DLYB.CFGR: DLYB configuration register
func (o *DLYB_Type) SetCFGR_SEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf)|value)
}
func (o *DLYB_Type) GetCFGR_SEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0xf
}
func (o *DLYB_Type) SetCFGR_UNIT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7f00)|value<<8)
}
func (o *DLYB_Type) GetCFGR_UNIT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7f00) >> 8
}
func (o *DLYB_Type) SetCFGR_LNG(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xfff0000)|value<<16)
}
func (o *DLYB_Type) GetCFGR_LNG() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xfff0000) >> 16
}
func (o *DLYB_Type) SetCFGR_LNGF(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *DLYB_Type) GetCFGR_LNGF() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}

// Flash
type FLASH_Type struct {
	ACR  volatile.Register32 // 0x0
	BANK [2]FLASH_BANK_Type  // 0x4
}

// FLASH.ACR: Access control register
func (o *FLASH_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x7)|value)
}
func (o *FLASH_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x7
}
func (o *FLASH_Type) SetACR_WRHIGHFREQ(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x30)|value<<4)
}
func (o *FLASH_Type) GetACR_WRHIGHFREQ() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x30) >> 4
}

type FLASH_BANK_Type struct {
	KEYR      volatile.Register32 // 0x4
	_         [4]byte
	CR        volatile.Register32 // 0xC
	SR        volatile.Register32 // 0x10
	CCR       volatile.Register32 // 0x14
	_         [16]byte
	PRAR_CUR  volatile.Register32 // 0x28
	PRAR_PRG  volatile.Register32 // 0x2C
	SCAR_CUR  volatile.Register32 // 0x30
	SCAR_PRG  volatile.Register32 // 0x34
	WPSN_CURR volatile.Register32 // 0x38
	WPSN_PRGR volatile.Register32 // 0x3C
	_         [16]byte
	CRCCR     volatile.Register32 // 0x50
	CRCSADDR  volatile.Register32 // 0x54
	CRCEADDR  volatile.Register32 // 0x58
	_         [4]byte
	FAR       volatile.Register32 // 0x60
	_         [160]byte
}

// FLASH_BANK.KEYR: FLASH key register for bank 1
func (o *FLASH_BANK_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *FLASH_BANK_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// FLASH_BANK.CR: FLASH control register for bank 1
func (o *FLASH_BANK_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *FLASH_BANK_Type) GetCR_LOCK() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *FLASH_BANK_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_BANK_Type) GetCR_PG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *FLASH_BANK_Type) SetCR_SER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *FLASH_BANK_Type) GetCR_SER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *FLASH_BANK_Type) SetCR_BER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *FLASH_BANK_Type) GetCR_BER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *FLASH_BANK_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30)|value<<4)
}
func (o *FLASH_BANK_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30) >> 4
}
func (o *FLASH_BANK_Type) SetCR_FW(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_BANK_Type) GetCR_FW() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *FLASH_BANK_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_BANK_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *FLASH_BANK_Type) SetCR_SNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x700)|value<<8)
}
func (o *FLASH_BANK_Type) GetCR_SNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x700) >> 8
}
func (o *FLASH_BANK_Type) SetCR_CRC_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *FLASH_BANK_Type) GetCR_CRC_EN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *FLASH_BANK_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_BANK_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *FLASH_BANK_Type) SetCR_WRPERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *FLASH_BANK_Type) GetCR_WRPERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *FLASH_BANK_Type) SetCR_PGSERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *FLASH_BANK_Type) GetCR_PGSERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *FLASH_BANK_Type) SetCR_STRBERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *FLASH_BANK_Type) GetCR_STRBERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *FLASH_BANK_Type) SetCR_INCERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200000)|value<<21)
}
func (o *FLASH_BANK_Type) GetCR_INCERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200000) >> 21
}
func (o *FLASH_BANK_Type) SetCR_OPERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *FLASH_BANK_Type) GetCR_OPERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *FLASH_BANK_Type) SetCR_RDPERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *FLASH_BANK_Type) GetCR_RDPERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *FLASH_BANK_Type) SetCR_RDSERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *FLASH_BANK_Type) GetCR_RDSERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *FLASH_BANK_Type) SetCR_SNECCERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *FLASH_BANK_Type) GetCR_SNECCERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *FLASH_BANK_Type) SetCR_DBECCERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASH_BANK_Type) GetCR_DBECCERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *FLASH_BANK_Type) SetCR_CRCENDIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *FLASH_BANK_Type) GetCR_CRCENDIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}

// FLASH_BANK.SR: FLASH status register for bank 1
func (o *FLASH_BANK_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FLASH_BANK_Type) GetSR_BSY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *FLASH_BANK_Type) SetSR_WBNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_BANK_Type) GetSR_WBNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FLASH_BANK_Type) SetSR_QW(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *FLASH_BANK_Type) GetSR_QW() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *FLASH_BANK_Type) SetSR_CRC_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *FLASH_BANK_Type) GetSR_CRC_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *FLASH_BANK_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_BANK_Type) GetSR_EOP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *FLASH_BANK_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *FLASH_BANK_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *FLASH_BANK_Type) SetSR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *FLASH_BANK_Type) GetSR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *FLASH_BANK_Type) SetSR_STRBERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *FLASH_BANK_Type) GetSR_STRBERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *FLASH_BANK_Type) SetSR_INCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *FLASH_BANK_Type) GetSR_INCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *FLASH_BANK_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *FLASH_BANK_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *FLASH_BANK_Type) SetSR_RDPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *FLASH_BANK_Type) GetSR_RDPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *FLASH_BANK_Type) SetSR_RDSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *FLASH_BANK_Type) GetSR_RDSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *FLASH_BANK_Type) SetSR_SNECCERR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *FLASH_BANK_Type) GetSR_SNECCERR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *FLASH_BANK_Type) SetSR_DBECCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASH_BANK_Type) GetSR_DBECCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *FLASH_BANK_Type) SetSR_CRCEND(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *FLASH_BANK_Type) GetSR_CRCEND() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}

// FLASH_BANK.CCR: FLASH clear control register for bank 1
func (o *FLASH_BANK_Type) SetCCR_CLR_EOP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_EOP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10000) >> 16
}
func (o *FLASH_BANK_Type) SetCCR_CLR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x20000)|value<<17)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x20000) >> 17
}
func (o *FLASH_BANK_Type) SetCCR_CLR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x40000)|value<<18)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x40000) >> 18
}
func (o *FLASH_BANK_Type) SetCCR_CLR_STRBERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80000)|value<<19)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_STRBERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80000) >> 19
}
func (o *FLASH_BANK_Type) SetCCR_CLR_INCERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200000)|value<<21)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_INCERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200000) >> 21
}
func (o *FLASH_BANK_Type) SetCCR_CLR_OPERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x400000)|value<<22)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x400000) >> 22
}
func (o *FLASH_BANK_Type) SetCCR_CLR_RDPERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x800000)|value<<23)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_RDPERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x800000) >> 23
}
func (o *FLASH_BANK_Type) SetCCR_CLR_RDSERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1000000)|value<<24)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_RDSERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x1000000) >> 24
}
func (o *FLASH_BANK_Type) SetCCR_CLR_SNECCERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2000000)|value<<25)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_SNECCERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2000000) >> 25
}
func (o *FLASH_BANK_Type) SetCCR_CLR_DBECCERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_DBECCERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4000000) >> 26
}
func (o *FLASH_BANK_Type) SetCCR_CLR_CRCEND(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8000000)|value<<27)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_CRCEND() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8000000) >> 27
}

// FLASH_BANK.PRAR_CUR: FLASH protection address for bank 1
func (o *FLASH_BANK_Type) SetPRAR_CUR_PROT_AREA_START(value uint32) {
	volatile.StoreUint32(&o.PRAR_CUR.Reg, volatile.LoadUint32(&o.PRAR_CUR.Reg)&^(0xfff)|value)
}
func (o *FLASH_BANK_Type) GetPRAR_CUR_PROT_AREA_START() uint32 {
	return volatile.LoadUint32(&o.PRAR_CUR.Reg) & 0xfff
}
func (o *FLASH_BANK_Type) SetPRAR_CUR_PROT_AREA_END(value uint32) {
	volatile.StoreUint32(&o.PRAR_CUR.Reg, volatile.LoadUint32(&o.PRAR_CUR.Reg)&^(0xfff0000)|value<<16)
}
func (o *FLASH_BANK_Type) GetPRAR_CUR_PROT_AREA_END() uint32 {
	return (volatile.LoadUint32(&o.PRAR_CUR.Reg) & 0xfff0000) >> 16
}
func (o *FLASH_BANK_Type) SetPRAR_CUR_DMEP(value uint32) {
	volatile.StoreUint32(&o.PRAR_CUR.Reg, volatile.LoadUint32(&o.PRAR_CUR.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_BANK_Type) GetPRAR_CUR_DMEP() uint32 {
	return (volatile.LoadUint32(&o.PRAR_CUR.Reg) & 0x80000000) >> 31
}

// FLASH_BANK.PRAR_PRG: FLASH protection address for bank 1
func (o *FLASH_BANK_Type) SetPRAR_PRG_PROT_AREA_START(value uint32) {
	volatile.StoreUint32(&o.PRAR_PRG.Reg, volatile.LoadUint32(&o.PRAR_PRG.Reg)&^(0xfff)|value)
}
func (o *FLASH_BANK_Type) GetPRAR_PRG_PROT_AREA_START() uint32 {
	return volatile.LoadUint32(&o.PRAR_PRG.Reg) & 0xfff
}
func (o *FLASH_BANK_Type) SetPRAR_PRG_PROT_AREA_END(value uint32) {
	volatile.StoreUint32(&o.PRAR_PRG.Reg, volatile.LoadUint32(&o.PRAR_PRG.Reg)&^(0xfff0000)|value<<16)
}
func (o *FLASH_BANK_Type) GetPRAR_PRG_PROT_AREA_END() uint32 {
	return (volatile.LoadUint32(&o.PRAR_PRG.Reg) & 0xfff0000) >> 16
}
func (o *FLASH_BANK_Type) SetPRAR_PRG_DMEP(value uint32) {
	volatile.StoreUint32(&o.PRAR_PRG.Reg, volatile.LoadUint32(&o.PRAR_PRG.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_BANK_Type) GetPRAR_PRG_DMEP() uint32 {
	return (volatile.LoadUint32(&o.PRAR_PRG.Reg) & 0x80000000) >> 31
}

// FLASH_BANK.SCAR_CUR: FLASH secure address for bank 1
func (o *FLASH_BANK_Type) SetSCAR_CUR_SEC_AREA_START(value uint32) {
	volatile.StoreUint32(&o.SCAR_CUR.Reg, volatile.LoadUint32(&o.SCAR_CUR.Reg)&^(0xfff)|value)
}
func (o *FLASH_BANK_Type) GetSCAR_CUR_SEC_AREA_START() uint32 {
	return volatile.LoadUint32(&o.SCAR_CUR.Reg) & 0xfff
}
func (o *FLASH_BANK_Type) SetSCAR_CUR_SEC_AREA_END(value uint32) {
	volatile.StoreUint32(&o.SCAR_CUR.Reg, volatile.LoadUint32(&o.SCAR_CUR.Reg)&^(0xfff0000)|value<<16)
}
func (o *FLASH_BANK_Type) GetSCAR_CUR_SEC_AREA_END() uint32 {
	return (volatile.LoadUint32(&o.SCAR_CUR.Reg) & 0xfff0000) >> 16
}
func (o *FLASH_BANK_Type) SetSCAR_CUR_DMES(value uint32) {
	volatile.StoreUint32(&o.SCAR_CUR.Reg, volatile.LoadUint32(&o.SCAR_CUR.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_BANK_Type) GetSCAR_CUR_DMES() uint32 {
	return (volatile.LoadUint32(&o.SCAR_CUR.Reg) & 0x80000000) >> 31
}

// FLASH_BANK.SCAR_PRG: FLASH secure address for bank 1
func (o *FLASH_BANK_Type) SetSCAR_PRG_SEC_AREA_START(value uint32) {
	volatile.StoreUint32(&o.SCAR_PRG.Reg, volatile.LoadUint32(&o.SCAR_PRG.Reg)&^(0xfff)|value)
}
func (o *FLASH_BANK_Type) GetSCAR_PRG_SEC_AREA_START() uint32 {
	return volatile.LoadUint32(&o.SCAR_PRG.Reg) & 0xfff
}
func (o *FLASH_BANK_Type) SetSCAR_PRG_SEC_AREA_END(value uint32) {
	volatile.StoreUint32(&o.SCAR_PRG.Reg, volatile.LoadUint32(&o.SCAR_PRG.Reg)&^(0xfff0000)|value<<16)
}
func (o *FLASH_BANK_Type) GetSCAR_PRG_SEC_AREA_END() uint32 {
	return (volatile.LoadUint32(&o.SCAR_PRG.Reg) & 0xfff0000) >> 16
}
func (o *FLASH_BANK_Type) SetSCAR_PRG_DMES(value uint32) {
	volatile.StoreUint32(&o.SCAR_PRG.Reg, volatile.LoadUint32(&o.SCAR_PRG.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_BANK_Type) GetSCAR_PRG_DMES() uint32 {
	return (volatile.LoadUint32(&o.SCAR_PRG.Reg) & 0x80000000) >> 31
}

// FLASH_BANK.WPSN_CURR: FLASH write sector protection for bank 1
func (o *FLASH_BANK_Type) SetWPSN_CURR_WRPSn(value uint32) {
	volatile.StoreUint32(&o.WPSN_CURR.Reg, volatile.LoadUint32(&o.WPSN_CURR.Reg)&^(0xff)|value)
}
func (o *FLASH_BANK_Type) GetWPSN_CURR_WRPSn() uint32 {
	return volatile.LoadUint32(&o.WPSN_CURR.Reg) & 0xff
}

// FLASH_BANK.WPSN_PRGR: FLASH write sector protection for bank 1
func (o *FLASH_BANK_Type) SetWPSN_PRGR_WRPSn(value uint32) {
	volatile.StoreUint32(&o.WPSN_PRGR.Reg, volatile.LoadUint32(&o.WPSN_PRGR.Reg)&^(0xff)|value)
}
func (o *FLASH_BANK_Type) GetWPSN_PRGR_WRPSn() uint32 {
	return volatile.LoadUint32(&o.WPSN_PRGR.Reg) & 0xff
}

// FLASH_BANK.CRCCR: FLASH CRC control register for bank 1
func (o *FLASH_BANK_Type) SetCRCCR_CRC_SECT(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x7)|value)
}
func (o *FLASH_BANK_Type) GetCRCCR_CRC_SECT() uint32 {
	return volatile.LoadUint32(&o.CRCCR.Reg) & 0x7
}
func (o *FLASH_BANK_Type) SetCRCCR_ALL_BANK(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_BANK_Type) GetCRCCR_ALL_BANK() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x80) >> 7
}
func (o *FLASH_BANK_Type) SetCRCCR_CRC_BY_SECT(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x100)|value<<8)
}
func (o *FLASH_BANK_Type) GetCRCCR_CRC_BY_SECT() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x100) >> 8
}
func (o *FLASH_BANK_Type) SetCRCCR_ADD_SECT(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x200)|value<<9)
}
func (o *FLASH_BANK_Type) GetCRCCR_ADD_SECT() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x200) >> 9
}
func (o *FLASH_BANK_Type) SetCRCCR_CLEAN_SECT(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x400)|value<<10)
}
func (o *FLASH_BANK_Type) GetCRCCR_CLEAN_SECT() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x400) >> 10
}
func (o *FLASH_BANK_Type) SetCRCCR_START_CRC(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_BANK_Type) GetCRCCR_START_CRC() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x10000) >> 16
}
func (o *FLASH_BANK_Type) SetCRCCR_CLEAN_CRC(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x20000)|value<<17)
}
func (o *FLASH_BANK_Type) GetCRCCR_CLEAN_CRC() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x20000) >> 17
}
func (o *FLASH_BANK_Type) SetCRCCR_CRC_BURST(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x300000)|value<<20)
}
func (o *FLASH_BANK_Type) GetCRCCR_CRC_BURST() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x300000) >> 20
}

// FLASH_BANK.CRCSADDR: FLASH CRC start address register for bank 1
func (o *FLASH_BANK_Type) SetCRCSADDR(value uint32) {
	volatile.StoreUint32(&o.CRCSADDR.Reg, value)
}
func (o *FLASH_BANK_Type) GetCRCSADDR() uint32 {
	return volatile.LoadUint32(&o.CRCSADDR.Reg)
}

// FLASH_BANK.CRCEADDR: FLASH CRC end address register for bank 1
func (o *FLASH_BANK_Type) SetCRCEADDR(value uint32) {
	volatile.StoreUint32(&o.CRCEADDR.Reg, value)
}
func (o *FLASH_BANK_Type) GetCRCEADDR() uint32 {
	return volatile.LoadUint32(&o.CRCEADDR.Reg)
}

// FLASH_BANK.FAR: FLASH ECC fail address for bank 1
func (o *FLASH_BANK_Type) SetFAR_FAIL_ECC_ADDR(value uint32) {
	volatile.StoreUint32(&o.FAR.Reg, volatile.LoadUint32(&o.FAR.Reg)&^(0x7fff)|value)
}
func (o *FLASH_BANK_Type) GetFAR_FAIL_ECC_ADDR() uint32 {
	return volatile.LoadUint32(&o.FAR.Reg) & 0x7fff
}

// AXI interconnect registers
type AXI_Type struct {
	_                   [8144]byte
	PERIPH_ID_4         volatile.Register32 // 0x1FD0
	_                   [12]byte
	PERIPH_ID_0         volatile.Register32 // 0x1FE0
	PERIPH_ID_1         volatile.Register32 // 0x1FE4
	PERIPH_ID_2         volatile.Register32 // 0x1FE8
	PERIPH_ID_3         volatile.Register32 // 0x1FEC
	COMP_ID_0           volatile.Register32 // 0x1FF0
	COMP_ID_1           volatile.Register32 // 0x1FF4
	COMP_ID_2           volatile.Register32 // 0x1FF8
	COMP_ID_3           volatile.Register32 // 0x1FFC
	_                   [8]byte
	TARG1_FN_MOD_ISS_BM volatile.Register32 // 0x2008
	_                   [24]byte
	TARG1_FN_MOD2       volatile.Register32 // 0x2024
	_                   [4]byte
	TARG1_FN_MOD_LB     volatile.Register32 // 0x202C
	_                   [216]byte
	TARG1_FN_MOD        volatile.Register32 // 0x2108
	_                   [3836]byte
	TARG2_FN_MOD_ISS_BM volatile.Register32 // 0x3008
	_                   [24]byte
	TARG2_FN_MOD2       volatile.Register32 // 0x3024
	_                   [4]byte
	TARG2_FN_MOD_LB     volatile.Register32 // 0x302C
	_                   [216]byte
	TARG2_FN_MOD        volatile.Register32 // 0x3108
	_                   [3836]byte
	TARG3_FN_MOD_ISS_BM volatile.Register32 // 0x4008
	_                   [4092]byte
	TARG4_FN_MOD_ISS_BM volatile.Register32 // 0x5008
	_                   [4092]byte
	TARG5_FN_MOD_ISS_BM volatile.Register32 // 0x6008
	_                   [4092]byte
	TARG6_FN_MOD_ISS_BM volatile.Register32 // 0x7008
	_                   [4096]byte
	TARG7_FN_MOD_ISS_BM volatile.Register32 // 0x800C
	_                   [20]byte
	TARG7_FN_MOD2       volatile.Register32 // 0x8024
	_                   [224]byte
	TARG7_FN_MOD        volatile.Register32 // 0x8108
	_                   [237336]byte
	INI1_FN_MOD2        volatile.Register32 // 0x42024
	INI1_FN_MOD_AHB     volatile.Register32 // 0x42028
	_                   [212]byte
	INI1_READ_QOS       volatile.Register32 // 0x42100
	INI1_WRITE_QOS      volatile.Register32 // 0x42104
	INI1_FN_MOD         volatile.Register32 // 0x42108
	_                   [4084]byte
	INI2_READ_QOS       volatile.Register32 // 0x43100
	INI2_WRITE_QOS      volatile.Register32 // 0x43104
	INI2_FN_MOD         volatile.Register32 // 0x43108
	_                   [3864]byte
	INI3_FN_MOD2        volatile.Register32 // 0x44024
	INI3_FN_MOD_AHB     volatile.Register32 // 0x44028
	_                   [212]byte
	INI3_READ_QOS       volatile.Register32 // 0x44100
	INI3_WRITE_QOS      volatile.Register32 // 0x44104
	INI3_FN_MOD         volatile.Register32 // 0x44108
	_                   [4084]byte
	INI4_READ_QOS       volatile.Register32 // 0x45100
	INI4_WRITE_QOS      volatile.Register32 // 0x45104
	INI4_FN_MOD         volatile.Register32 // 0x45108
	_                   [4084]byte
	INI5_READ_QOS       volatile.Register32 // 0x46100
	INI5_WRITE_QOS      volatile.Register32 // 0x46104
	INI5_FN_MOD         volatile.Register32 // 0x46108
	_                   [4084]byte
	INI6_READ_QOS       volatile.Register32 // 0x47100
	INI6_WRITE_QOS      volatile.Register32 // 0x47104
	INI6_FN_MOD         volatile.Register32 // 0x47108
}

// AXI.PERIPH_ID_4: AXI interconnect - peripheral ID4 register
func (o *AXI_Type) SetPERIPH_ID_4_JEP106CON(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_4.Reg, volatile.LoadUint32(&o.PERIPH_ID_4.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetPERIPH_ID_4_JEP106CON() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID_4.Reg) & 0xf
}
func (o *AXI_Type) SetPERIPH_ID_4_KCOUNT4(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_4.Reg, volatile.LoadUint32(&o.PERIPH_ID_4.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_Type) GetPERIPH_ID_4_KCOUNT4() uint32 {
	return (volatile.LoadUint32(&o.PERIPH_ID_4.Reg) & 0xf0) >> 4
}

// AXI.PERIPH_ID_0: AXI interconnect - peripheral ID0 register
func (o *AXI_Type) SetPERIPH_ID_0_PARTNUM(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_0.Reg, volatile.LoadUint32(&o.PERIPH_ID_0.Reg)&^(0xff)|value)
}
func (o *AXI_Type) GetPERIPH_ID_0_PARTNUM() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID_0.Reg) & 0xff
}

// AXI.PERIPH_ID_1: AXI interconnect - peripheral ID1 register
func (o *AXI_Type) SetPERIPH_ID_1_PARTNUM(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_1.Reg, volatile.LoadUint32(&o.PERIPH_ID_1.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetPERIPH_ID_1_PARTNUM() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID_1.Reg) & 0xf
}
func (o *AXI_Type) SetPERIPH_ID_1_JEP106I(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_1.Reg, volatile.LoadUint32(&o.PERIPH_ID_1.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_Type) GetPERIPH_ID_1_JEP106I() uint32 {
	return (volatile.LoadUint32(&o.PERIPH_ID_1.Reg) & 0xf0) >> 4
}

// AXI.PERIPH_ID_2: AXI interconnect - peripheral ID2 register
func (o *AXI_Type) SetPERIPH_ID_2_JEP106ID(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_2.Reg, volatile.LoadUint32(&o.PERIPH_ID_2.Reg)&^(0x7)|value)
}
func (o *AXI_Type) GetPERIPH_ID_2_JEP106ID() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID_2.Reg) & 0x7
}
func (o *AXI_Type) SetPERIPH_ID_2_JEDEC(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_2.Reg, volatile.LoadUint32(&o.PERIPH_ID_2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_Type) GetPERIPH_ID_2_JEDEC() uint32 {
	return (volatile.LoadUint32(&o.PERIPH_ID_2.Reg) & 0x8) >> 3
}
func (o *AXI_Type) SetPERIPH_ID_2_REVISION(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_2.Reg, volatile.LoadUint32(&o.PERIPH_ID_2.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_Type) GetPERIPH_ID_2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.PERIPH_ID_2.Reg) & 0xf0) >> 4
}

// AXI.PERIPH_ID_3: AXI interconnect - peripheral ID3 register
func (o *AXI_Type) SetPERIPH_ID_3_CUST_MOD_NUM(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_3.Reg, volatile.LoadUint32(&o.PERIPH_ID_3.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetPERIPH_ID_3_CUST_MOD_NUM() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID_3.Reg) & 0xf
}
func (o *AXI_Type) SetPERIPH_ID_3_REV_AND(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_3.Reg, volatile.LoadUint32(&o.PERIPH_ID_3.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_Type) GetPERIPH_ID_3_REV_AND() uint32 {
	return (volatile.LoadUint32(&o.PERIPH_ID_3.Reg) & 0xf0) >> 4
}

// AXI.COMP_ID_0: AXI interconnect - component ID0 register
func (o *AXI_Type) SetCOMP_ID_0_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.COMP_ID_0.Reg, volatile.LoadUint32(&o.COMP_ID_0.Reg)&^(0xff)|value)
}
func (o *AXI_Type) GetCOMP_ID_0_PREAMBLE() uint32 {
	return volatile.LoadUint32(&o.COMP_ID_0.Reg) & 0xff
}

// AXI.COMP_ID_1: AXI interconnect - component ID1 register
func (o *AXI_Type) SetCOMP_ID_1_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.COMP_ID_1.Reg, volatile.LoadUint32(&o.COMP_ID_1.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetCOMP_ID_1_PREAMBLE() uint32 {
	return volatile.LoadUint32(&o.COMP_ID_1.Reg) & 0xf
}
func (o *AXI_Type) SetCOMP_ID_1_CLASS(value uint32) {
	volatile.StoreUint32(&o.COMP_ID_1.Reg, volatile.LoadUint32(&o.COMP_ID_1.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_Type) GetCOMP_ID_1_CLASS() uint32 {
	return (volatile.LoadUint32(&o.COMP_ID_1.Reg) & 0xf0) >> 4
}

// AXI.COMP_ID_2: AXI interconnect - component ID2 register
func (o *AXI_Type) SetCOMP_ID_2_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.COMP_ID_2.Reg, volatile.LoadUint32(&o.COMP_ID_2.Reg)&^(0xff)|value)
}
func (o *AXI_Type) GetCOMP_ID_2_PREAMBLE() uint32 {
	return volatile.LoadUint32(&o.COMP_ID_2.Reg) & 0xff
}

// AXI.COMP_ID_3: AXI interconnect - component ID3 register
func (o *AXI_Type) SetCOMP_ID_3_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.COMP_ID_3.Reg, volatile.LoadUint32(&o.COMP_ID_3.Reg)&^(0xff)|value)
}
func (o *AXI_Type) GetCOMP_ID_3_PREAMBLE() uint32 {
	return volatile.LoadUint32(&o.COMP_ID_3.Reg) & 0xff
}

// AXI.TARG1_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG1_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG1_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG1_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG1_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG1_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG1_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG1_FN_MOD2: AXI interconnect - TARG x bus matrix functionality 2 register
func (o *AXI_Type) SetTARG1_FN_MOD2_BYPASS_MERGE(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD2.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD2.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG1_FN_MOD2_BYPASS_MERGE() uint32 {
	return volatile.LoadUint32(&o.TARG1_FN_MOD2.Reg) & 0x1
}

// AXI.TARG1_FN_MOD_LB: AXI interconnect - TARG x long burst functionality modification
func (o *AXI_Type) SetTARG1_FN_MOD_LB_FN_MOD_LB(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD_LB.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD_LB.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG1_FN_MOD_LB_FN_MOD_LB() uint32 {
	return volatile.LoadUint32(&o.TARG1_FN_MOD_LB.Reg) & 0x1
}

// AXI.TARG1_FN_MOD: AXI interconnect - TARG x long burst functionality modification
func (o *AXI_Type) SetTARG1_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG1_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG1_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetTARG1_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG1_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG1_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.TARG2_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG2_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG2_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG2_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG2_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG2_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG2_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG2_FN_MOD2: AXI interconnect - TARG x bus matrix functionality 2 register
func (o *AXI_Type) SetTARG2_FN_MOD2_BYPASS_MERGE(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD2.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD2.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG2_FN_MOD2_BYPASS_MERGE() uint32 {
	return volatile.LoadUint32(&o.TARG2_FN_MOD2.Reg) & 0x1
}

// AXI.TARG2_FN_MOD_LB: AXI interconnect - TARG x long burst functionality modification
func (o *AXI_Type) SetTARG2_FN_MOD_LB_FN_MOD_LB(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD_LB.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD_LB.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG2_FN_MOD_LB_FN_MOD_LB() uint32 {
	return volatile.LoadUint32(&o.TARG2_FN_MOD_LB.Reg) & 0x1
}

// AXI.TARG2_FN_MOD: AXI interconnect - TARG x long burst functionality modification
func (o *AXI_Type) SetTARG2_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG2_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG2_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetTARG2_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG2_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG2_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.TARG3_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG3_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG3_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG3_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG3_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG3_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG3_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG3_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG3_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG3_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG3_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG4_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG4_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG4_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG4_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG4_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG4_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG4_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG4_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG4_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG4_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG4_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG5_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG5_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG5_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG5_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG5_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG5_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG5_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG5_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG5_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG5_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG5_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG6_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG6_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG6_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG6_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG6_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG6_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG6_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG6_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG6_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG6_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG6_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG7_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG7_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG7_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG7_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG7_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG7_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG7_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG7_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG7_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG7_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG7_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG7_FN_MOD2: AXI interconnect - TARG x bus matrix functionality 2 register
func (o *AXI_Type) SetTARG7_FN_MOD2_BYPASS_MERGE(value uint32) {
	volatile.StoreUint32(&o.TARG7_FN_MOD2.Reg, volatile.LoadUint32(&o.TARG7_FN_MOD2.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG7_FN_MOD2_BYPASS_MERGE() uint32 {
	return volatile.LoadUint32(&o.TARG7_FN_MOD2.Reg) & 0x1
}

// AXI.TARG7_FN_MOD: AXI interconnect - TARG x long burst functionality modification
func (o *AXI_Type) SetTARG7_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG7_FN_MOD.Reg, volatile.LoadUint32(&o.TARG7_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG7_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG7_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetTARG7_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG7_FN_MOD.Reg, volatile.LoadUint32(&o.TARG7_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG7_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG7_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI1_FN_MOD2: AXI interconnect - INI x functionality modification 2 register
func (o *AXI_Type) SetINI1_FN_MOD2_BYPASS_MERGE(value uint32) {
	volatile.StoreUint32(&o.INI1_FN_MOD2.Reg, volatile.LoadUint32(&o.INI1_FN_MOD2.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI1_FN_MOD2_BYPASS_MERGE() uint32 {
	return volatile.LoadUint32(&o.INI1_FN_MOD2.Reg) & 0x1
}

// AXI.INI1_FN_MOD_AHB: AXI interconnect - INI x AHB functionality modification register
func (o *AXI_Type) SetINI1_FN_MOD_AHB_RD_INC_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI1_FN_MOD_AHB.Reg, volatile.LoadUint32(&o.INI1_FN_MOD_AHB.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI1_FN_MOD_AHB_RD_INC_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI1_FN_MOD_AHB.Reg) & 0x1
}
func (o *AXI_Type) SetINI1_FN_MOD_AHB_WR_INC_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI1_FN_MOD_AHB.Reg, volatile.LoadUint32(&o.INI1_FN_MOD_AHB.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI1_FN_MOD_AHB_WR_INC_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI1_FN_MOD_AHB.Reg) & 0x2) >> 1
}

// AXI.INI1_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI1_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI1_READ_QOS.Reg, volatile.LoadUint32(&o.INI1_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI1_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI1_READ_QOS.Reg) & 0xf
}

// AXI.INI1_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI1_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI1_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI1_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI1_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI1_WRITE_QOS.Reg) & 0xf
}

// AXI.INI1_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI1_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI1_FN_MOD.Reg, volatile.LoadUint32(&o.INI1_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI1_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI1_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI1_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI1_FN_MOD.Reg, volatile.LoadUint32(&o.INI1_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI1_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI1_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI2_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI2_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI2_READ_QOS.Reg, volatile.LoadUint32(&o.INI2_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI2_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI2_READ_QOS.Reg) & 0xf
}

// AXI.INI2_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI2_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI2_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI2_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI2_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI2_WRITE_QOS.Reg) & 0xf
}

// AXI.INI2_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI2_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI2_FN_MOD.Reg, volatile.LoadUint32(&o.INI2_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI2_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI2_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI2_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI2_FN_MOD.Reg, volatile.LoadUint32(&o.INI2_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI2_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI2_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI3_FN_MOD2: AXI interconnect - INI x functionality modification 2 register
func (o *AXI_Type) SetINI3_FN_MOD2_BYPASS_MERGE(value uint32) {
	volatile.StoreUint32(&o.INI3_FN_MOD2.Reg, volatile.LoadUint32(&o.INI3_FN_MOD2.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI3_FN_MOD2_BYPASS_MERGE() uint32 {
	return volatile.LoadUint32(&o.INI3_FN_MOD2.Reg) & 0x1
}

// AXI.INI3_FN_MOD_AHB: AXI interconnect - INI x AHB functionality modification register
func (o *AXI_Type) SetINI3_FN_MOD_AHB_RD_INC_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI3_FN_MOD_AHB.Reg, volatile.LoadUint32(&o.INI3_FN_MOD_AHB.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI3_FN_MOD_AHB_RD_INC_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI3_FN_MOD_AHB.Reg) & 0x1
}
func (o *AXI_Type) SetINI3_FN_MOD_AHB_WR_INC_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI3_FN_MOD_AHB.Reg, volatile.LoadUint32(&o.INI3_FN_MOD_AHB.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI3_FN_MOD_AHB_WR_INC_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI3_FN_MOD_AHB.Reg) & 0x2) >> 1
}

// AXI.INI3_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI3_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI3_READ_QOS.Reg, volatile.LoadUint32(&o.INI3_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI3_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI3_READ_QOS.Reg) & 0xf
}

// AXI.INI3_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI3_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI3_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI3_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI3_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI3_WRITE_QOS.Reg) & 0xf
}

// AXI.INI3_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI3_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI3_FN_MOD.Reg, volatile.LoadUint32(&o.INI3_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI3_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI3_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI3_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI3_FN_MOD.Reg, volatile.LoadUint32(&o.INI3_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI3_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI3_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI4_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI4_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI4_READ_QOS.Reg, volatile.LoadUint32(&o.INI4_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI4_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI4_READ_QOS.Reg) & 0xf
}

// AXI.INI4_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI4_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI4_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI4_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI4_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI4_WRITE_QOS.Reg) & 0xf
}

// AXI.INI4_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI4_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI4_FN_MOD.Reg, volatile.LoadUint32(&o.INI4_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI4_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI4_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI4_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI4_FN_MOD.Reg, volatile.LoadUint32(&o.INI4_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI4_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI4_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI5_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI5_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI5_READ_QOS.Reg, volatile.LoadUint32(&o.INI5_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI5_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI5_READ_QOS.Reg) & 0xf
}

// AXI.INI5_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI5_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI5_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI5_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI5_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI5_WRITE_QOS.Reg) & 0xf
}

// AXI.INI5_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI5_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI5_FN_MOD.Reg, volatile.LoadUint32(&o.INI5_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI5_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI5_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI5_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI5_FN_MOD.Reg, volatile.LoadUint32(&o.INI5_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI5_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI5_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI6_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI6_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI6_READ_QOS.Reg, volatile.LoadUint32(&o.INI6_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI6_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI6_READ_QOS.Reg) & 0xf
}

// AXI.INI6_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI6_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI6_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI6_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI6_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI6_WRITE_QOS.Reg) & 0xf
}

// AXI.INI6_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI6_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI6_FN_MOD.Reg, volatile.LoadUint32(&o.INI6_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI6_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI6_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI6_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI6_FN_MOD.Reg, volatile.LoadUint32(&o.INI6_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI6_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI6_FN_MOD.Reg) & 0x2) >> 1
}

// Digital camera interface
type DCMI_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	RIS    volatile.Register32 // 0x8
	IER    volatile.Register32 // 0xC
	MIS    volatile.Register32 // 0x10
	ICR    volatile.Register32 // 0x14
	ESCR   volatile.Register32 // 0x18
	ESUR   volatile.Register32 // 0x1C
	CWSTRT volatile.Register32 // 0x20
	CWSIZE volatile.Register32 // 0x24
	DR     volatile.Register32 // 0x28
}

// DCMI.CR: control register 1
func (o *DCMI_Type) SetCR_OELS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *DCMI_Type) GetCR_OELS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *DCMI_Type) SetCR_LSM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *DCMI_Type) GetCR_LSM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *DCMI_Type) SetCR_OEBS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DCMI_Type) GetCR_OEBS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DCMI_Type) SetCR_BSM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DCMI_Type) GetCR_BSM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}
func (o *DCMI_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DCMI_Type) GetCR_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *DCMI_Type) SetCR_EDM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *DCMI_Type) GetCR_EDM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *DCMI_Type) SetCR_FCRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *DCMI_Type) GetCR_FCRC() uint32 {
	