/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute.standard;

import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.SetOfIntegerSyntax;

public final class PageRanges
extends SetOfIntegerSyntax
implements DocAttribute,
PrintRequestAttribute,
PrintJobAttribute {
    private static final long serialVersionUID = 8639895197656148392L;

    public PageRanges(int[][] members) {
        super(members);
        if (members == null) {
            throw new NullPointerException("members is null");
        }
        this.myPageRanges();
    }

    public PageRanges(String members) {
        super(members);
        if (members == null) {
            throw new NullPointerException("members is null");
        }
        this.myPageRanges();
    }

    private void myPageRanges() {
        int[][] myMembers = this.getMembers();
        int n = myMembers.length;
        if (n == 0) {
            throw new IllegalArgumentException("members is zero-length");
        }
        for (int i = 0; i < n; ++i) {
            if (myMembers[i][0] >= 1) continue;
            throw new IllegalArgumentException("Page value < 1 specified");
        }
    }

    public PageRanges(int member) {
        super(member);
        if (member < 1) {
            throw new IllegalArgumentException("Page value < 1 specified");
        }
    }

    public PageRanges(int lowerBound, int upperBound) {
        super(lowerBound, upperBound);
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("Null range specified");
        }
        if (lowerBound < 1) {
            throw new IllegalArgumentException("Page value < 1 specified");
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof PageRanges;
    }

    @Override
    public final Class<? extends Attribute> getCategory() {
        return PageRanges.class;
    }

    @Override
    public final String getName() {
        return "page-ranges";
    }
}

