/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_uz_Cyrl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "\u0414\u0443\u043d\u0451" },
            { "002", "\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "003", "\u0428\u0438\u043c\u043e\u043b\u0438\u0439 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "005", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "009", "\u041e\u043a\u0435\u0430\u043d\u0438\u044f" },
            { "011", "\u0492\u0430\u0440\u0431\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "013", "\u041c\u0430\u0440\u043a\u0430\u0437\u0438\u0439 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "014", "\u0428\u0430\u0440\u049b\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "015", "\u0428\u0438\u043c\u043e\u043b\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "017", "\u041c\u0430\u0440\u043a\u0430\u0437\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "018", "\u0416\u0430\u043d\u0443\u0431\u0438-\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "019", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "021", "\u0428\u0438\u043c\u043e\u043b\u0438-\u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "029", "\u041a\u0430\u0440\u0438\u0431 \u04b3\u0430\u0432\u0437\u0430\u0441\u0438" },
            { "030", "\u0428\u0430\u0440\u049b\u0438\u0439 \u041e\u0441\u0438\u0451" },
            { "034", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u041e\u0441\u0438\u0451" },
            { "035", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439-\u0428\u0430\u0440\u049b\u0438\u0439 \u041e\u0441\u0438\u0451" },
            { "039", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0438\u044f" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438\u044f" },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f \u043c\u0438\u043d\u0442\u0430\u049b\u0430\u0441\u0438" },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f" },
            { "142", "\u041e\u0441\u0438\u0451" },
            { "143", "\u041c\u0430\u0440\u043a\u0430\u0437\u0438\u0439 \u041e\u0441\u0438\u0451" },
            { "145", "\u0492\u0430\u0440\u0431\u0438\u0439 \u041e\u0441\u0438\u0451" },
            { "150", "\u0415\u0432\u0440\u043e\u043f\u0430" },
            { "151", "\u0428\u0430\u0440\u049b\u0438\u0439 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "154", "\u0428\u0438\u043c\u043e\u043b\u0438\u0439 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "155", "\u0492\u0430\u0440\u0431\u0438\u0439 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "419", "\u041b\u043e\u0442\u0438\u043d \u0410\u043c\u0435\u0440\u0438\u043a\u0430\u0441\u0438" },
            { "AC", "\u041c\u0435\u044a\u0440\u043e\u0436 \u043e\u0440\u043e\u043b\u0438" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u0411\u0438\u0440\u043b\u0430\u0448\u0433\u0430\u043d \u0410\u0440\u0430\u0431 \u0410\u043c\u0438\u0440\u043b\u0438\u043a\u043b\u0430\u0440\u0438" },
            { "AF", "\u0410\u0444\u0493\u043e\u043d\u0438\u0441\u0442\u043e\u043d" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0432\u0430 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u044c\u044f" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438\u044f" },
            { "AM", "\u0410\u0440\u043c\u0430\u043d\u0438\u0441\u0442\u043e\u043d" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0434\u0430" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0421\u0430\u043c\u043e\u0430\u0441\u0438" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "AZ", "\u041e\u0437\u0430\u0440\u0431\u0430\u0439\u0436\u043e\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438\u044f \u0432\u0430 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0438\u044f" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430-\u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f" },
            { "BH", "\u0411\u0430\u04b3\u0440\u0430\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u0435\u043b\u0435\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0430" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438\u044f" },
            { "BQ", "\u0411\u043e\u043d\u0435\u0439\u0440, \u0421\u0438\u043d\u0442-\u042d\u0441\u0442\u0430\u0442\u0438\u0443\u0441 \u0432\u0430 \u0421\u0430\u0431\u0430" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c\u0430 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0411\u0443\u0432\u0435 \u043e\u0440\u043e\u043b\u0438" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u043d\u0430" },
            { "BY", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u043b\u0438\u043d\u0433) \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e-\u041a\u0438\u043d\u0448\u0430\u0441\u0430" },
            { "CF", "\u041c\u0430\u0440\u043a\u0430\u0437\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u0438" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f" },
            { "CI", "\u041a\u043e\u0442-\u0434\u2019\u0418\u0432\u0443\u0430\u0440" },
            { "CK", "\u041a\u0443\u043a \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u0425\u0438\u0442\u043e\u0439" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u044f" },
            { "CP", "\u041a\u043b\u0438\u043f\u043f\u0435\u0440\u0442\u043e\u043d \u043e\u0440\u043e\u043b\u0438" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u0420\u043e\u0436\u0434\u0435\u0441\u0442\u0432\u043e \u043e\u0440\u043e\u043b\u0438" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "CZ", "\u0427\u0435\u0445\u0438\u044f" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e-\u0413\u0430\u0440\u0441\u0438\u044f" },
            { "DJ", "\u0416\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438\u044f" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "DO", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u0438" },
            { "DZ", "\u0416\u0430\u0437\u043e\u0438\u0440" },
            { "EA", "\u0421\u044d\u0443\u0442\u0430 \u0432\u0430 \u041c\u0435\u043b\u0438\u043b\u043b\u0430" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0438\u044f" },
            { "EG", "\u041c\u0438\u0441\u0440" },
            { "EH", "\u0492\u0430\u0440\u0431\u0438\u0439 \u0421\u0430\u04b3\u0440\u043e\u0438 \u041a\u0430\u0431\u0438\u0440" },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0435\u044f" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438\u044f" },
            { "ET", "\u042d\u0444\u0438\u043e\u043f\u0438\u044f" },
            { "EU", "\u0415\u0432\u0440\u043e\u043f\u0430 \u0418\u0442\u0442\u0438\u0444\u043e\u049b\u0438" },
            { "FI", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f" },
            { "FJ", "\u0424\u0438\u0436\u0438" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u0438\u044f" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "GB", "\u0411\u0443\u044e\u043a \u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u0440\u0443\u0437\u0438\u044f" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u0413\u0432\u0438\u0430\u043d\u0430\u0441\u0438" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438\u044f" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u044f" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0435" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b \u0413\u0432\u0438\u043d\u0435\u044f" },
            { "GR", "\u0413\u0440\u0435\u0446\u0438\u044f" },
            { "GS", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0413\u0435\u043e\u0440\u0433\u0438\u044f \u0432\u0430 \u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0421\u0435\u043d\u0434\u0432\u0438\u0447 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u044f-\u0411\u0438\u0441\u0430\u0443" },
            { "GY", "\u0413\u0430\u044f\u043d\u0430" },
            { "HK", "\u0413\u043e\u043d\u043a\u043e\u043d\u0433 (\u0425\u0438\u0442\u043e\u0439 \u041c\u041c\u04b2)" },
            { "HM", "\u0425\u0435\u0440\u0434 \u0432\u0430 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u0434 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u044f" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "HU", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "IL", "\u0418\u0441\u0440\u043e\u0438\u043b" },
            { "IM", "\u041c\u044d\u043d \u043e\u0440\u043e\u043b\u0438" },
            { "IN", "\u04b2\u0438\u043d\u0434\u0438\u0441\u0442\u043e\u043d" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f\u043d\u0438\u043d\u0433 \u04b2\u0438\u043d\u0434 \u043e\u043a\u0435\u0430\u043d\u0438\u0434\u0430\u0433\u0438 \u04b3\u0443\u0434\u0443\u0434\u0438" },
            { "IQ", "\u0418\u0440\u043e\u049b" },
            { "IR", "\u042d\u0440\u043e\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438\u044f" },
            { "JE", "\u0416\u0435\u0440\u0441\u0438" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "JO", "\u0418\u043e\u0440\u0434\u0430\u043d\u0438\u044f" },
            { "JP", "\u042f\u043f\u043e\u043d\u0438\u044f" },
            { "KE", "\u041a\u0435\u043d\u0438\u044f" },
            { "KG", "\u049a\u0438\u0440\u0493\u0438\u0437\u0438\u0441\u0442\u043e\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0432\u0430 \u041d\u0435\u0432\u0438\u0441" },
            { "KP", "\u0428\u0438\u043c\u043e\u043b\u0438\u0439 \u041a\u043e\u0440\u0435\u044f" },
            { "KR", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u041a\u043e\u0440\u0435\u044f" },
            { "KW", "\u049a\u0443\u0432\u0430\u0439\u0442" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "KZ", "\u049a\u043e\u0437\u043e\u0493\u0438\u0441\u0442\u043e\u043d" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438\u044f" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438\u044f" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438\u044f" },
            { "LY", "\u041b\u0438\u0432\u0438\u044f" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u0430\u0448" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u043e\u0432\u0430" },
            { "ME", "\u0427\u0435\u0440\u043d\u043e\u0433\u043e\u0440\u0438\u044f" },
            { "MF", "\u0421\u0435\u043d\u0442-\u041c\u0430\u0440\u0442\u0438\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "MK", "\u0428\u0438\u043c\u043e\u043b\u0438\u0439 \u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u044f" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MM", "\u041c\u044c\u044f\u043d\u043c\u0430 (\u0411\u0438\u0440\u043c\u0430)" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u044f" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e (\u0425\u0438\u0442\u043e\u0439 \u041c\u041c\u04b2)" },
            { "MP", "\u0428\u0438\u043c\u043e\u043b\u0438\u0439 \u041c\u0430\u0440\u0438\u0430\u043d\u043d\u0430 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0438\u0432 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u044f" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438\u044f" },
            { "NC", "\u042f\u043d\u0433\u0438 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438\u044f" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438\u044f" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u044d" },
            { "NZ", "\u042f\u043d\u0433\u0438 \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "OM", "\u0423\u043c\u043c\u043e\u043d" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f\u0441\u0438" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 - \u042f\u043d\u0433\u0438 \u0413\u0432\u0438\u043d\u0435\u044f" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "PK", "\u041f\u043e\u043a\u0438\u0441\u0442\u043e\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448\u0430" },
            { "PM", "\u0421\u0435\u043d\u0442-\u041f\u044c\u0435\u0440 \u0432\u0430 \u041c\u0438\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "PS", "\u0424\u0430\u043b\u0430\u0441\u0442\u0438\u043d \u04b3\u0443\u0434\u0443\u0434\u0438" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u044f" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "QA", "\u049a\u0430\u0442\u0430\u0440" },
            { "QO", "\u0401\u043d\u0434\u043e\u0448 \u041e\u043a\u0435\u0430\u043d\u0438\u044f" },
            { "RE", "\u0420\u0435\u044e\u043d\u0438\u043e\u043d" },
            { "RO", "\u0420\u0443\u043c\u0438\u043d\u0438\u044f" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438\u044f" },
            { "RU", "\u0420\u043e\u0441\u0441\u0438\u044f" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0421\u0430\u0443\u0434\u0438\u044f \u0410\u0440\u0430\u0431\u0438\u0441\u0442\u043e\u043d\u0438" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "SE", "\u0428\u0432\u0435\u0446\u0438\u044f" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u041c\u0443\u049b\u0430\u0434\u0434\u0430\u0441 \u0415\u043b\u0435\u043d\u0430 \u043e\u0440\u043e\u043b\u0438" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u044f" },
            { "SJ", "\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0432\u0430 \u042f\u043d-\u041c\u0430\u0439\u0435\u043d" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a\u0438\u044f" },
            { "SL", "\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "SS", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0432\u0430 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "SV", "\u0421\u0430\u043b\u0432\u0430\u0434\u043e\u0440" },
            { "SX", "\u0421\u0438\u043d\u0442-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u0443\u0440\u0438\u044f" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434" },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d-\u0434\u0430-\u041a\u0443\u043d\u044f" },
            { "TC", "\u0422\u0443\u0440\u043a\u0441 \u0432\u0430 \u041a\u0430\u0439\u043a\u043e\u0441 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "TD", "\u0427\u0430\u0434" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u0436\u0430\u043d\u0443\u0431\u0438\u0439 \u04b3\u0443\u0434\u0443\u0434\u043b\u0430\u0440\u0438" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0438\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u043e\u0436\u0438\u043a\u0438\u0441\u0442\u043e\u043d" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0422\u0438\u043c\u043e\u0440-\u041b\u0435\u0441\u0442\u0435" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0430\u043d\u0438\u0441\u0442\u043e\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u0443\u0440\u043a\u0438\u044f" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0432\u0430 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d\u0430" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "UM", "\u0410\u049a\u0428 \u0451\u043d\u0434\u043e\u0448 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "US", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u049a\u045e\u0448\u043c\u0430 \u0428\u0442\u0430\u0442\u043b\u0430\u0440\u0438" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "UZ", "\u040e\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u043e\u043d" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0432\u0430 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f \u0412\u0438\u0440\u0433\u0438\u043d \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "VI", "\u0410\u049a\u0428 \u0412\u0438\u0440\u0433\u0438\u043d \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "VN", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u0432\u0430 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "YE", "\u042f\u043c\u0430\u043d" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "ZA", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u0438" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438\u044f" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u041d\u043e\u043c\u0430\u044a\u043b\u0443\u043c \u043c\u0438\u043d\u0442\u0430\u049b\u0430" },
            { "aa", "\u0430\u0444\u0430\u0440\u0447\u0430" },
            { "ab", "\u0430\u0431\u0445\u0430\u0437\u0447\u0430" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441" },
            { "ak", "\u0430\u043a\u0430\u043d\u0447\u0430" },
            { "am", "\u0430\u043c\u0445\u0430\u0440\u0447\u0430" },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d" },
            { "ar", "\u0430\u0440\u0430\u0431\u0447\u0430" },
            { "as", "\u0430\u0441\u0441\u043e\u043c\u0447\u0430" },
            { "av", "\u0430\u0432\u0430\u0440\u0447\u0430" },
            { "ay", "\u0430\u0439\u043c\u0430\u0440\u0430" },
            { "az", "\u043e\u0437\u0430\u0440\u0431\u0430\u0439\u0436\u043e\u043d\u0447\u0430" },
            { "ba", "\u0431\u043e\u0448\u049b\u0438\u0440\u0434\u0447\u0430" },
            { "be", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u0447\u0430" },
            { "bg", "\u0431\u043e\u043b\u0433\u0430\u0440\u0447\u0430" },
            { "bi", "\u0431\u0438\u0441\u043b\u0430\u043c\u0430" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0447\u0430" },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b\u0447\u0430" },
            { "bo", "\u0442\u0438\u0431\u0435\u0442\u0447\u0430" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d\u0447\u0430" },
            { "bs", "\u0431\u043e\u0441\u043d\u0438\u0439\u0447\u0430" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u043e\u043d\u0447\u0430" },
            { "ce", "\u0447\u0435\u0447\u0435\u043d \u0442\u0438\u043b\u0438" },
            { "ch", "\u0447\u0430\u043c\u043e\u0440\u0440\u043e" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a\u0430\u043d\u0447\u0430" },
            { "cs", "\u0447\u0435\u0445\u0447\u0430" },
            { "cu", "\u0441\u043b\u0430\u0432\u044f\u043d\u0447\u0430 (\u0447\u0435\u0440\u043a\u043e\u0432)" },
            { "cv", "\u0447\u0443\u0432\u0430\u0448 \u0442\u0438\u043b\u0438" },
            { "cy", "\u0443\u044d\u043b\u0441\u0447\u0430" },
            { "da", "\u0434\u0430\u0442\u0447\u0430" },
            { "de", "\u043d\u0435\u043c\u0438\u0441\u0447\u0430" },
            { "dv", "\u0434\u0438\u0432\u0435\u0445\u0438" },
            { "dz", "\u0434\u0437\u043e\u043d\u0433\u043a\u0430" },
            { "ee", "\u044d\u0432\u0435\u0447\u0430" },
            { "el", "\u0433\u0440\u0435\u043a\u0447\u0430" },
            { "en", "\u0438\u043d\u0433\u043b\u0438\u0437\u0447\u0430" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "es", "\u0438\u0441\u043f\u0430\u043d\u0447\u0430" },
            { "et", "\u044d\u0441\u0442\u043e\u043d\u0447\u0430" },
            { "eu", "\u0431\u0430\u0441\u043a\u0447\u0430" },
            { "fa", "\u0444\u043e\u0440\u0441\u0438\u0439" },
            { "ff", "\u0444\u0443\u043b\u0430\u04b3" },
            { "fi", "\u0444\u0438\u043d\u0447\u0430" },
            { "fj", "\u0444\u0438\u0436\u0438\u0447\u0430" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440\u0447\u0430" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0447\u0430" },
            { "fy", "\u0493\u0430\u0440\u0431\u0438\u0439 \u0444\u0440\u0438\u0437\u0447\u0430" },
            { "ga", "\u0438\u0440\u043b\u0430\u043d\u0434\u0447\u0430" },
            { "gd", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434\u0447\u0430 \u0433\u0430\u0435\u043b\u0438\u043a" },
            { "gl", "\u0433\u0430\u043b\u0438\u0446\u0438\u0439\u0447\u0430" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "gu", "\u0433\u0443\u0436\u0430\u0440\u043e\u0442\u0447\u0430" },
            { "gv", "\u043c\u044d\u043d\u0447\u0430" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "he", "\u0438\u0431\u0440\u043e\u043d\u0438\u0439" },
            { "hi", "\u04b3\u0438\u043d\u0434\u0438" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442\u0447\u0430" },
            { "ht", "\u0433\u0430\u0438\u0442\u044f\u043d\u0447\u0430" },
            { "hu", "\u0432\u0435\u043d\u0433\u0435\u0440\u0447\u0430" },
            { "hy", "\u0430\u0440\u043c\u0430\u043d\u0447\u0430" },
            { "hz", "\u0433\u0435\u0440\u0435\u0440\u043e" },
            { "ia", "\u0438\u043d\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0432\u0430" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0447\u0430" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "io", "\u0438\u0434\u043e" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434\u0447\u0430" },
            { "it", "\u0438\u0442\u0430\u043b\u044f\u043d\u0447\u0430" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "ja", "\u044f\u043f\u043e\u043d\u0447\u0430" },
            { "jv", "\u044f\u0432\u0430\u043d\u0447\u0430" },
            { "ka", "\u0433\u0440\u0443\u0437\u0438\u043d\u0447\u0430" },
            { "ki", "\u043a\u0438\u043a\u0443\u044e" },
            { "kk", "\u049b\u043e\u0437\u043e\u049b\u0447\u0430" },
            { "kl", "\u0433\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0447\u0430" },
            { "km", "\u0445\u043c\u0435\u0440\u0447\u0430" },
            { "kn", "\u043a\u0430\u043d\u043d\u0430\u0434\u0430" },
            { "ko", "\u043a\u043e\u0440\u0435\u0439\u0441\u0447\u0430" },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0438" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440\u0447\u0430" },
            { "ku", "\u043a\u0443\u0440\u0434\u0447\u0430" },
            { "kw", "\u043a\u043e\u0440\u043d\u0447\u0430" },
            { "ky", "\u049b\u0438\u0440\u0493\u0438\u0437\u0447\u0430" },
            { "la", "\u043b\u043e\u0442\u0438\u043d\u0447\u0430" },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0447\u0430" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430\u0447\u0430" },
            { "ln", "\u043b\u0438\u043d\u0433\u0430\u043b\u0447\u0430" },
            { "lo", "\u043b\u0430\u043e\u0441\u0447\u0430" },
            { "lt", "\u043b\u0438\u0442\u0432\u0430\u0447\u0430" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "lv", "\u043b\u0430\u0442\u0438\u0448\u0447\u0430" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0438\u0439\u0447\u0430" },
            { "mh", "\u043c\u0430\u0440\u0448\u0430\u043b\u043b \u0442\u0438\u043b\u0438" },
            { "mi", "\u043c\u0430\u043e\u0440\u0438" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0447\u0430" },
            { "ml", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c" },
            { "mn", "\u043c\u045e\u0493\u0443\u043b\u0447\u0430" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0445\u0438" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439 \u0442\u0438\u043b" },
            { "mt", "\u043c\u0430\u043b\u0442\u0430\u0447\u0430" },
            { "my", "\u0431\u0438\u0440\u043c\u0430\u043d\u0447\u0430" },
            { "nb", "\u043d\u043e\u0440\u0432\u0435\u0433\u0447\u0430 \u0431\u043e\u043a\u043c\u0430\u043b" },
            { "nd", "\u0448\u0438\u043c\u043e\u043b\u0438\u0439 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u0447\u0430" },
            { "nl", "\u0433\u043e\u043b\u043b\u0430\u043d\u0434\u0447\u0430" },
            { "nn", "\u043d\u043e\u0440\u0432\u0435\u0433\u0447\u0430 \u043d\u044e\u043d\u043e\u0440\u0441\u043a" },
            { "nr", "\u0436\u0430\u043d\u0443\u0431\u0438\u0439 \u043d\u0434\u0435\u0431\u0435\u043b\u0447\u0430" },
            { "ny", "\u0447\u0435\u0432\u0430" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d\u0447\u0430" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "or", "\u043e\u0434\u0438\u044f" },
            { "pa", "\u043f\u0430\u043d\u0436\u043e\u0431\u0447\u0430" },
            { "pl", "\u043f\u043e\u043b\u044f\u043a\u0447\u0430" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0447\u0430" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "rm", "\u0440\u043e\u043c\u0430\u043d\u0448\u0447\u0430" },
            { "rn", "\u0440\u0443\u043d\u0434\u0438" },
            { "ro", "\u0440\u0443\u043c\u0438\u043d\u0447\u0430" },
            { "ru", "\u0440\u0443\u0441\u0447\u0430" },
            { "rw", "\u043a\u0438\u043d\u044f\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "sd", "\u0441\u0438\u043d\u0434\u04b3\u0438" },
            { "se", "\u0448\u0438\u043c\u043e\u043b\u0438\u0439 \u0441\u0430\u0430\u043c\u0447\u0430" },
            { "sg", "\u0441\u0430\u043d\u0433\u043e" },
            { "si", "\u0441\u0438\u043d\u0433\u0430\u043b\u0447\u0430" },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u043a\u0447\u0430" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d\u0447\u0430" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438\u0447\u0430" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u0447\u0430" },
            { "sr", "\u0441\u0435\u0440\u0431\u0447\u0430" },
            { "ss", "\u0441\u0432\u0430\u0442\u0438" },
            { "su", "\u0441\u0443\u043d\u0434\u0430\u043d\u0447\u0430" },
            { "sv", "\u0448\u0432\u0435\u0434\u0447\u0430" },
            { "sw", "\u0441\u0443\u0430\u0445\u0438\u043b\u0438" },
            { "ta", "\u0442\u0430\u043c\u0438\u043b\u0447\u0430" },
            { "te", "\u0442\u0435\u043b\u0443\u0433\u0443" },
            { "tg", "\u0442\u043e\u0436\u0438\u043a\u0447\u0430" },
            { "th", "\u0442\u0430\u0439\u0447\u0430" },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d\u044f\u0447\u0430" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0430\u043d\u0447\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430\u043d\u0447\u0430" },
            { "tr", "\u0442\u0443\u0440\u043a\u0447\u0430" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440\u0447\u0430" },
            { "ug", "\u0443\u0439\u0493\u0443\u0440\u0447\u0430" },
            { "uk", "\u0443\u043a\u0440\u0430\u0438\u043d\u0447\u0430" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "uz", "\u045e\u0437\u0431\u0435\u043a\u0447\u0430" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "vi", "\u0432\u0435\u0442\u043d\u0430\u043c\u0447\u0430" },
            { "vo", "\u0432\u043e\u043b\u0430\u043f\u044e\u043a" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444\u0447\u0430" },
            { "xh", "\u0445\u043e\u0441\u0430" },
            { "yi", "\u0438\u0434\u0434\u0438\u0448" },
            { "yo", "\u0439\u043e\u0440\u0443\u0431\u0430" },
            { "zh", "\u0445\u0438\u0442\u043e\u0439\u0447\u0430" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "ace", "\u0430\u0447\u0438\u043d" },
            { "ada", "\u0430\u0434\u0430\u043d\u0433\u043c\u044d" },
            { "ady", "\u0430\u0434\u0438\u0433\u0435\u0439" },
            { "agq", "\u0430\u0433\u0435\u043c\u0447\u0430" },
            { "ain", "\u0430\u0439\u043d\u0443" },
            { "ale", "\u0430\u043b\u0435\u0443\u0442" },
            { "anp", "\u0430\u043d\u0433\u0438\u043a\u0430" },
            { "arn", "\u043c\u0430\u043f\u0443\u0434\u0443\u043d\u0433\u0443\u043d" },
            { "arp", "\u0430\u0440\u0430\u043f\u0430\u0445\u043e" },
            { "asa", "\u0430\u0441\u0443\u0447\u0430" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u0438\u0439\u0447\u0430" },
            { "awa", "\u0430\u0432\u0430\u0434\u0445\u0438" },
            { "ban", "\u0431\u0430\u043b\u0438\u0447\u0430" },
            { "bas", "\u0431\u0430\u0441\u0430\u0430" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "bez", "\u0431\u0435\u043d\u0430\u0447\u0430" },
            { "bho", "\u0431\u0445\u043e\u0436\u043f\u0443\u0440\u0438" },
            { "bin", "\u0431\u0438\u043d\u0438" },
            { "brx", "\u0431\u043e\u0434\u043e\u0447\u0430" },
            { "bug", "\u0431\u0443\u0433\u0438\u0439\u0447\u0430" },
            { "byn", "\u0431\u043b\u0438\u043d\u0447\u0430" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u0447\u0430" },
            { "cgg", "\u0447\u0438\u0433\u0430\u0447\u0430" },
            { "chk", "\u0447\u0443\u0443\u043a\u0447\u0430" },
            { "chm", "\u043c\u0430\u0440\u0438" },
            { "cho", "\u0447\u043e\u043a\u0442\u0430\u0432\u0447\u0430" },
            { "chr", "\u0447\u0435\u0440\u043e\u043a\u0438" },
            { "chy", "\u0448\u0430\u0439\u0435\u043d\u043d" },
            { "ckb", "\u0441\u043e\u0440\u0430\u043d\u0438-\u043a\u0443\u0440\u0434\u0447\u0430" },
            { "dak", "\u0434\u0430\u043a\u043e\u0442\u0447\u0430" },
            { "dar", "\u0434\u0430\u0440\u0433\u0438\u043d\u0447\u0430" },
            { "dav", "\u0442\u0430\u0438\u0442\u0430\u0447\u0430" },
            { "dgr", "\u0434\u043e\u0433\u0440\u0438\u0431" },
            { "dje", "\u0437\u0430\u0440\u043c\u0430" },
            { "dsb", "\u049b\u0443\u0439\u0438-\u0441\u043e\u0440\u0431\u0447\u0430" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430\u0447\u0430" },
            { "dyo", "\u0434\u0438\u043e\u043b\u0430-\u0444\u043e\u0433\u043d\u0438" },
            { "dzg", "\u0434\u0430\u0437\u0430\u0433\u0430" },
            { "ebu", "\u044d\u043c\u0431\u0443\u0447\u0430" },
            { "efi", "\u044d\u0444\u0438\u043a" },
            { "eka", "\u044d\u043a\u0430\u0436\u0443\u043a" },
            { "ewo", "\u044d\u0432\u043e\u043d\u0434\u043e\u043d\u0447\u0430" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u0438\u043d\u0447\u0430" },
            { "fon", "\u0444\u043e\u043d" },
            { "fur", "\u0444\u0440\u0438\u0443\u043b\u0447\u0430" },
            { "gaa", "\u0433\u0430" },
            { "gez", "\u0433\u0435\u044d\u0437" },
            { "gil", "\u0433\u0438\u043b\u0431\u0435\u0440\u0442\u0447\u0430" },
            { "gor", "\u0433\u043e\u0440\u043e\u043d\u0442\u0430\u043b\u043e" },
            { "gsw", "\u043d\u0435\u043c\u0438\u0441\u0447\u0430 (\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f)" },
            { "guz", "\u0433\u0443\u0441\u0438\u0438" },
            { "gwi", "\u0433\u0432\u0438\u0447\u0438\u043d" },
            { "haw", "\u0433\u0430\u0432\u0430\u0439\u0447\u0430" },
            { "hil", "\u0445\u0438\u043b\u0438\u0433\u0430\u0439\u043d\u043e\u043d" },
            { "hmn", "\u0445\u043c\u043e\u043d\u0433\u0447\u0430" },
            { "hsb", "\u044e\u049b\u043e\u0440\u0438 \u0441\u043e\u0440\u0431\u0447\u0430" },
            { "hup", "\u0445\u0443\u043f\u0430 \u0442\u0438\u043b\u0438" },
            { "iba", "\u0438\u0431\u0430\u043d \u0442\u0438\u043b\u0438" },
            { "ibb", "\u0438\u0431\u0438\u0431\u043e" },
            { "ilo", "\u0438\u043b\u043e\u043a\u043e" },
            { "inh", "\u0438\u043d\u0433\u0443\u0448\u0447\u0430" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u0435 \u0442\u0438\u043b\u0438" },
            { "kab", "\u043a\u0430\u0431\u0438\u043b\u0447\u0430" },
            { "kaj", "\u043a\u0430\u0436\u0438" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430\u0447\u0430" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u0435\u0447\u0430" },
            { "kea", "\u043a\u0430\u0431\u0443\u0432\u0435\u0440\u0434\u0438\u0430\u043d\u0443" },
            { "khq", "\u043a\u043e\u0439\u0440\u0430-\u0447\u0438\u0438\u043d\u0438" },
            { "kkj", "\u043a\u0430\u043a\u043e" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u0436\u0438\u043d\u0447\u0430" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0447\u0430" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b\u0430" },
            { "ksf", "\u0431\u0430\u0444\u0438\u044f\u0447\u0430" },
            { "ksh", "\u043a\u0451\u043b\u043d\u0447\u0430" },
            { "lag", "\u043b\u0430\u043d\u0433\u0438\u0447\u0430" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0430\u0447\u0430\u043b\u0430\u043a\u043e\u0442\u0430\u0447\u0430" },
            { "lrc", "\u0448\u0438\u043c\u043e\u043b\u0438\u0439 \u043b\u0443\u0440\u0438" },
            { "lus", "\u043b\u0443\u0448\u0430\u0439" },
            { "luy", "\u043b\u0443\u04b3\u044f" },
            { "mas", "\u043c\u0430\u0441\u0430\u0439\u0447\u0430" },
            { "mdf", "\u043c\u043e\u043a\u0448\u0430 \u0442\u0438\u043b\u0438" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "mer", "\u043c\u0435\u0440\u0443\u0447\u0430" },
            { "mfe", "\u043c\u043e\u0440\u0438\u0441\u044c\u0435\u043d" },
            { "mgh", "\u043c\u0430\u0445\u0443\u0432\u0430-\u043c\u0438\u0442\u0442\u043e" },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "mic", "\u043c\u0438\u043a\u043c\u0430\u043a" },
            { "min", "\u043c\u0438\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u0443" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0447\u0430" },
            { "moh", "\u043c\u043e\u0433\u0430\u0432\u043a" },
            { "mos", "\u043c\u043e\u0441\u0441\u0438" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "mul", "\u0431\u0438\u0440 \u043d\u0435\u0447\u0442\u0430 \u0442\u0438\u043b" },
            { "mus", "\u043a\u0440\u0438\u043a\u0447\u0430" },
            { "mwl", "\u043c\u0438\u0440\u0430\u043d\u0434\u0435\u0441" },
            { "myv", "\u044d\u0440\u0437\u044f\u043d\u0447\u0430" },
            { "mzn", "\u043c\u0430\u0437\u0430\u043d\u0434\u0435\u0440\u0430\u043d" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "niu", "\u043d\u0438\u0443\u044d\u0447\u0430" },
            { "nmg", "\u043a\u0432\u0430\u0441\u0438\u043e" },
            { "nnh", "\u043d\u0433\u0438\u0435\u043c\u0431\u0443\u043d" },
            { "nqo", "\u043d\u043a\u043e" },
            { "nus", "\u043d\u0443\u044d\u0440\u0447\u0430" },
            { "nyn", "\u043d\u044f\u043d\u043a\u043e\u043b\u0435" },
            { "pap", "\u043f\u0430\u043f\u0438\u044f\u043c\u0435\u043d\u0442\u043e" },
            { "quc", "\u043a\u0438\u0447\u044d" },
            { "rof", "\u0440\u043e\u043c\u0431\u043e\u0447\u0430" },
            { "rup", "\u0430\u0440\u0443\u043c\u0438\u043d" },
            { "rwk", "\u0440\u0443\u0430\u043d\u0434\u0430 \u0442\u0438\u043b\u0438" },
            { "sah", "\u0441\u0430\u0445\u0430" },
            { "saq", "\u0441\u0430\u043c\u0431\u0443\u0440\u0443\u0447\u0430" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u0438" },
            { "sbp", "\u0441\u0430\u043d\u0433\u0443\u0447\u0430" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "ses", "\u043a\u043e\u0439\u0440\u0430\u0431\u043e\u0440\u043e-\u0441\u0435\u043d\u043d\u0438" },
            { "shi", "\u0442\u0430\u0448\u0435\u043b\u0445\u0438\u0442" },
            { "sma", "\u0436\u0430\u043d\u0443\u0431\u0438\u0439 \u0441\u0430\u0430\u043c\u0447\u0430" },
            { "smj", "\u043b\u0443\u043b\u0435-\u0441\u0430\u0430\u043c\u0447\u0430" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438-\u0441\u0430\u0430\u043c\u0447\u0430" },
            { "sms", "\u0441\u043a\u043e\u043b\u0442-\u0441\u0430\u0430\u043c\u0447\u0430" },
            { "ssy", "\u0441\u0430\u04b3\u043e\u0447\u0430" },
            { "swb", "\u043a\u043e\u043c\u043e\u0440\u0447\u0430" },
            { "syr", "\u0441\u0443\u0440\u0438\u044f\u0447\u0430" },
            { "teo", "\u0442\u0435\u0441\u043e" },
            { "tig", "\u0442\u0438\u0433\u0440\u0435" },
            { "twq", "\u0442\u0430\u0441\u0430\u0432\u0430\u043a" },
            { "tzm", "\u043c\u0430\u0440\u043a\u0430\u0437\u0438\u0439 \u0430\u0442\u043b\u0430\u0441 \u0442\u0430\u043c\u0430\u0437\u0438\u0433\u0445\u0442" },
            { "und", "\u043d\u043e\u043c\u0430\u044a\u043b\u0443\u043c \u0442\u0438\u043b" },
            { "vai", "\u0432\u0430\u0438" },
            { "vun", "\u0432\u0443\u043d\u0436\u043e" },
            { "wae", "\u0432\u0430\u043b\u0441\u0435\u0440\u0447\u0430" },
            { "wal", "\u0432\u043e\u043b\u044f\u0442\u0442\u0430" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "yav", "\u044f\u043d\u0433\u0431\u0435\u043d" },
            { "yue", "\u043a\u0430\u043d\u0442\u043e\u043d\u0447\u0430" },
            { "zgh", "\u0442\u0430\u043c\u0430\u0437\u0438\u0433\u0445\u0442" },
            { "zxx", "\u0422\u0438\u043b \u0442\u0430\u0440\u043a\u0438\u0431\u0438 \u0439\u045e\u049b" },
            { "Arab", "\u0410\u0440\u0430\u0431" },
            { "Armn", "\u0410\u0440\u043c\u0430\u043d" },
            { "Beng", "\u0411\u0435\u043d\u0433\u0430\u043b\u0438" },
            { "Bopo", "\u0411\u043e\u043f\u043e\u043c\u043e\u0444\u043e" },
            { "Brai", "\u0411\u0440\u0430\u0438\u043b\u043b\u0435" },
            { "Cyrl", "\u041a\u0438\u0440\u0438\u043b" },
            { "Deva", "\u0414\u0435\u0432\u0430\u043d\u0433\u0430\u0440\u0438" },
            { "Ethi", "\u04b2\u0430\u0431\u0430\u0448" },
            { "Geor", "\u0413\u0440\u0443\u0437\u0438\u043d" },
            { "Grek", "\u042e\u043d\u043e\u043d" },
            { "Gujr", "\u0413\u0443\u0436\u0430\u0440\u0430\u0442\u0438" },
            { "Guru", "\u0413\u0443\u0440\u043c\u0443\u0445\u0438" },
            { "Hang", "\u0425\u0430\u043d\u0433\u0443\u043b" },
            { "Hani", "\u0425\u0430\u043d" },
            { "Hans", "\u0421\u043e\u0434\u0434\u0430\u043b\u0430\u0448\u0442\u0438\u0440\u0438\u043b\u0433\u0430\u043d" },
            { "Hant", "\u0410\u043d\u044a\u0430\u043d\u0430\u0432\u0438\u0439" },
            { "Hebr", "\u0418\u0431\u0440\u043e\u043d\u0438\u0439" },
            { "Hira", "\u0425\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "Jpan", "\u042f\u043f\u043e\u043d" },
            { "Kana", "\u041a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "Khmr", "\u0425\u043c\u0435\u0440" },
            { "Knda", "\u041a\u0430\u043d\u043d\u0430\u0434\u0430" },
            { "Kore", "\u041a\u043e\u0440\u0435\u0439\u0441" },
            { "Laoo", "\u041b\u0430\u043e" },
            { "Latn", "\u041b\u043e\u0442\u0438\u043d" },
            { "Mlym", "\u041c\u0430\u043b\u0430\u0439\u0430\u043b\u0430\u043c" },
            { "Mong", "\u041c\u045e\u0493\u0443\u043b\u0447\u0430" },
            { "Mymr", "\u041c\u044c\u044f\u043d\u043c\u0430" },
            { "Orya", "\u041e\u0440\u0438\u044f" },
            { "Sinh", "\u0421\u0438\u043d\u0445\u0430\u043b\u0430" },
            { "Taml", "\u0422\u0430\u043c\u0438\u043b" },
            { "Telu", "\u0422\u0435\u043b\u0443\u0433\u0443" },
            { "Thaa", "\u0422\u0430\u0430\u043d\u0430" },
            { "Thai", "\u0422\u0430\u0439" },
            { "Tibt", "\u0422\u0438\u0431\u0435\u0442" },
            { "Zsym", "\u0420\u0430\u043c\u0437\u043b\u0430\u0440" },
            { "Zxxx", "\u0401\u0437\u0438\u043b\u043c\u0430\u0433\u0430\u043d" },
            { "Zyyy", "\u0423\u043c\u0443\u043c\u0438\u0439" },
            { "Zzzz", "\u041d\u043e\u043c\u0430\u044a\u043b\u0443\u043c \u0448\u0440\u0438\u0444\u0442" },
            { "en_GB", "\u0438\u043d\u0433\u043b\u0438\u0437\u0447\u0430 (\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f)" },
            { "en_US", "\u0438\u043d\u0433\u043b\u0438\u0437\u0447\u0430 (\u0410\u043c\u0435\u0440\u0438\u043a\u0430)" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434\u0447\u0430" },
            { "sw_CD", "\u043a\u043e\u043d\u0433\u043e-\u0441\u0443\u0430\u0445\u0438\u043b\u0438" },
            { "ar_001", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0430\u0440\u0430\u0431\u0447\u0430" },
            { "key.ca", "\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "key.co", "\u0421\u0430\u0440\u0430\u043b\u0430\u0448 \u0442\u0430\u0440\u0442\u0438\u0431\u0438" },
            { "key.cu", "\u0412\u0430\u043b\u044e\u0442\u0430" },
            { "key.nu", "\u0420\u0430\u049b\u0430\u043c\u043b\u0430\u0440" },
            { "zh_Hans", "\u0441\u043e\u0434\u0434\u0430\u043b\u0430\u0448\u0442\u0438\u0440\u0438\u043b\u0433\u0430\u043d \u0445\u0438\u0442\u043e\u0439\u0447\u0430" },
            { "zh_Hant", "\u0430\u043d\u044a\u0430\u043d\u0430\u0432\u0438\u0439 \u0445\u0438\u0442\u043e\u0439\u0447\u0430" },
            { "type.nu.arab", "\u0410\u0440\u0430\u0431-\u04b3\u0438\u043d\u0434 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.armn", "\u0410\u0440\u043c\u0430\u043d \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.beng", "\u0411\u0435\u043d\u0433\u0430\u043b\u0438 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.deva", "\u0414\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.ethi", "\u04b2\u0430\u0431\u0430\u0448 \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.geor", "\u0413\u0440\u0443\u0437\u0438\u043d \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.grek", "\u0413\u0440\u0435\u043a \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.gujr", "\u0413\u0443\u0436\u0430\u0440\u0430\u0442\u0438 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.guru", "\u0413\u0443\u0440\u043c\u0443\u0445\u0438 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.hans", "\u0421\u043e\u0434\u0434\u0430\u043b\u0430\u0448\u0442\u0438\u0440\u0438\u043b\u0433\u0430\u043d \u0425\u0438\u0442\u043e\u0439 \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.hant", "\u0410\u043d\u044a\u0430\u043d\u0430\u0432\u0438\u0439 \u0425\u0438\u0442\u043e\u0439 \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.hebr", "\u0418\u0431\u0440\u043e\u043d\u0438\u0439 \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.jpan", "\u042f\u043f\u043e\u043d\u0438\u044f \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.khmr", "\u0425\u043c\u0435\u0440 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.knda", "\u041a\u0430\u043d\u043d\u0430\u0434\u0430 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.laoo", "\u041b\u0430\u043e \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.latn", "\u0492\u0430\u0440\u0431 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.mlym", "\u041c\u0430\u043b\u0430\u0439\u0430\u043b\u0430\u043c \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.mymr", "\u041c\u044c\u044f\u043d\u043c\u0430 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.orya", "\u041e\u0440\u0438\u044f \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.taml", "\u0410\u043d\u044a\u0430\u043d\u0430\u0432\u0438\u0439 \u0422\u0430\u043c\u0438\u043b \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.telu", "\u0422\u0435\u043b\u0443\u0433\u0443 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.thai", "\u0422\u0430\u0439 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.tibt", "\u0422\u0438\u0431\u0435\u0442 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.co.ducet", "\u0421\u0443\u043a\u0443\u0442 \u0431\u045e\u0439\u0438\u0447\u0430 \u0441\u0430\u0440\u0430\u043b\u0430\u0448 \u0442\u0430\u0440\u0442\u0438\u0431\u0438" },
            { "type.nu.roman", "\u0420\u0438\u043c \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.co.search", "\u0423\u043c\u0443\u043c\u0438\u0439 \u049b\u0438\u0434\u0438\u0440\u0438\u0448" },
            { "type.nu.arabext", "\u041a\u0435\u043d\u0433\u0430\u0439\u0442\u0438\u0440\u0438\u043b\u0433\u0430\u043d \u0430\u0440\u0430\u0431-\u04b3\u0438\u043d\u0434 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.armnlow", "\u0410\u0440\u043c\u0430\u043d \u043a\u0438\u0447\u0438\u043a \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.greklow", "\u0413\u0440\u0435\u043a \u043a\u0438\u0447\u0438\u043a \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.hanidec", "\u0425\u0438\u0442\u043e\u0439 \u045e\u043d\u043b\u0438\u043a \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.hansfin", "\u0421\u043e\u0434\u0434\u0430\u043b\u0430\u0448\u0442\u0438\u0440\u0438\u043b\u0433\u0430\u043d \u0425\u0438\u0442\u043e\u0439 \u043c\u043e\u043b\u0438\u044f \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.hantfin", "\u0410\u043d\u044a\u0430\u043d\u0430\u0432\u0438\u0439 \u0425\u0438\u0442\u043e\u0439 \u043c\u043e\u043b\u0438\u044f \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.jpanfin", "\u042f\u043f\u043e\u043d\u0438\u044f \u043c\u043e\u043b\u0438\u044f \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.tamldec", "\u0422\u0430\u043c\u0438\u043b \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.co.standard", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0441\u0430\u0440\u0430\u043b\u0430\u0448 \u0442\u0430\u0440\u0442\u0438\u0431\u0438" },
            { "type.nu.fullwide", "\u0422\u045e\u043b\u0438\u049b \u043a\u0435\u043d\u0433\u043b\u0438\u043a\u0434\u0430\u0433\u0438 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440" },
            { "type.nu.romanlow", "\u0420\u0438\u043c \u043a\u0438\u0447\u0438\u043a \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.ca.gregorian", "\u0413\u0440\u0438\u0433\u043e\u0440\u0438\u0430\u043d \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u0438" },
        };
        return data;
    }
}
