/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import javajs.util.BS;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.adapter.writers.XtlWriter;
import org.jmol.api.JmolWriter;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.viewer.Viewer;

public class CIFWriter
extends XtlWriter
implements JmolWriter {
    private Viewer vwr;
    private OC oc;
    private boolean isP1;
    private static final P3 fset0 = P3.new3(555.0f, 555.0f, 1.0f);

    @Override
    public void set(Viewer viewer, OC oc, Object[] data) {
        this.vwr = viewer;
        this.oc = oc == null ? this.vwr.getOutputChannel(null, null) : oc;
        this.isP1 = data != null && data.length > 0 && "P1".equals(data[0]);
    }

    @Override
    public String write(BS bs) {
        block20: {
            if (bs == null) {
                bs = this.vwr.bsA();
            }
            try {
                int n;
                String hmName;
                String hallName;
                String ita;
                BS bsOut;
                BS modelAU;
                T3 fset;
                P3 offset;
                boolean fractionalOffset;
                short mi = this.vwr.ms.at[bs.nextSetBit((int)0)].mi;
                SymmetryInterface uc = this.vwr.getCurrentUnitCell();
                boolean bl = this.haveUnitCell = uc != null;
                if (!this.haveUnitCell) {
                    uc = this.vwr.getSymTemp().setUnitCell(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f}, false);
                }
                boolean bl2 = fractionalOffset = (offset = uc.getFractionalOffset()) != null && (offset.x != (float)((int)offset.x) || offset.y != (float)((int)offset.y) || offset.z != (float)((int)offset.z));
                boolean haveCustom = fractionalOffset || (fset = uc.getUnitCellMultiplier()) != null && (fset.z == 1.0f ? !fset.equals(fset0) : fset.z != 0.0f);
                SymmetryInterface ucm = uc.getUnitCellMultiplied();
                this.isP1 = this.isP1 || ucm != uc || fractionalOffset || uc.getSpaceGroupOperationCount() < 2;
                uc = ucm;
                BS bS = !this.haveUnitCell ? bs : (modelAU = this.isP1 ? uc.removeDuplicates(this.vwr.ms, bs, false) : this.vwr.ms.am[mi].bsAsymmetricUnit);
                if (modelAU == null) {
                    bsOut = bs;
                } else {
                    bsOut = new BS();
                    bsOut.or(modelAU);
                    bsOut.and(bs);
                }
                this.vwr.setErrorMessage(null, " (" + bsOut.cardinality() + " atoms)");
                if (bsOut.isEmpty()) {
                    return "";
                }
                SB sb = new SB();
                sb.append("## CIF file created by Jmol " + Viewer.getJmolVersion());
                if (haveCustom) {
                    sb.append(PT.rep("\n" + uc.getUnitCellInfo(false), "\n", "\n##Jmol_orig "));
                }
                sb.append("\ndata_global");
                float[] params = uc.getUnitCellAsArray(false);
                this.appendKey(sb, "_cell_length_a").appendF(params[0]);
                this.appendKey(sb, "_cell_length_b").appendF(params[1]);
                this.appendKey(sb, "_cell_length_c").appendF(params[2]);
                this.appendKey(sb, "_cell_angle_alpha").appendF(params[3]);
                this.appendKey(sb, "_cell_angle_beta").appendF(params[4]);
                this.appendKey(sb, "_cell_angle_gamma").appendF(params[5]);
                sb.append("\n");
                if (this.isP1) {
                    ita = "1";
                    hallName = "P 1";
                    hmName = "P1";
                    n = 0;
                } else {
                    uc.getSpaceGroupInfo(this.vwr.ms, null, mi, true, null);
                    ita = uc.getSpaceGroupNameType("ITA");
                    hallName = uc.getSpaceGroupNameType("Hall");
                    hmName = uc.getSpaceGroupNameType("HM");
                    n = uc.getSpaceGroupOperationCount();
                }
                this.appendKey(sb, "_space_group_IT_number").append(ita == null ? "?" : ita.toString());
                this.appendKey(sb, "_space_group_name_Hall").append(hallName == null || hallName.equals("?") ? "?" : "'" + hallName + "'");
                this.appendKey(sb, "_space_group_name_H-M_alt").append(hmName == null ? "?" : "'" + hmName + "'");
                sb.append("\n\nloop_\n_space_group_symop_id\n_space_group_symop_operation_xyz");
                if (n == 0) {
                    sb.append("\n1 x,y,z");
                } else {
                    for (int i = 0; i < n; ++i) {
                        sb.append("\n").appendI(i + 1).append("\t").append(uc.getSpaceGroupXyz(i, false).replaceAll(" ", ""));
                    }
                }
                Atom[] atoms = this.vwr.ms.at;
                String elements = "";
                int sbLength = sb.length();
                sb.append("\n\nloop_\n_atom_site_label\n_atom_site_type_symbol\n_atom_site_fract_x\n_atom_site_fract_y\n_atom_site_fract_z");
                if (!this.haveUnitCell) {
                    sb.append("\n_atom_site_Cartn_x\n_atom_site_Cartn_y\n_atom_site_Cartn_z");
                }
                sb.append("\n");
                SB jmol_atom = new SB();
                jmol_atom.append("\n\nloop_\n_jmol_atom_index\n_jmol_atom_name\n_jmol_atom_site_label\n");
                int nAtoms = 0;
                P3 p = new P3();
                int[] elemNums = new int[130];
                int i = bsOut.nextSetBit(0);
                while (i >= 0) {
                    Atom a = atoms[i];
                    p.setT(a);
                    if (this.haveUnitCell) {
                        uc.toFractional(p, !this.isP1);
                    }
                    ++nAtoms;
                    String name = a.getAtomName();
                    String sym = a.getElementSymbol();
                    int elemno = a.getElementNumber();
                    String key = sym + "\n";
                    if (elements.indexOf(key) < 0) {
                        elements = elements + key;
                    }
                    int n2 = elemno;
                    int n3 = elemNums[n2] + 1;
                    elemNums[n2] = n3;
                    String label = sym + n3;
                    sb.append(PT.formatS(label, 5, 0, true, false)).append(" ").append(PT.formatS(sym, 3, 0, true, false)).append(this.clean(p.x)).append(this.clean(p.y)).append(this.clean(p.z));
                    if (!this.haveUnitCell) {
                        sb.append(this.clean(a.x)).append(this.clean(a.y)).append(this.clean(a.z));
                    }
                    sb.append("\n");
                    jmol_atom.append(PT.formatS("" + a.getIndex(), 3, 0, false, false)).append(" ");
                    this.writeChecked(jmol_atom, name);
                    jmol_atom.append(" ").append(PT.formatS(label, 5, 0, false, false)).append("\n");
                    i = bsOut.nextSetBit(i + 1);
                }
                if (nAtoms > 0) {
                    sb.append("\nloop_\n_atom_type_symbol\n").append(elements).append("\n");
                    sb.appendSB(jmol_atom);
                } else {
                    sb.setLength(sbLength);
                }
                sb.append("\n# ").appendI(nAtoms).append(" atoms\n");
                this.oc.append(sb.toString());
            }
            catch (Exception e) {
                if (Viewer.isJS) break block20;
                e.printStackTrace();
            }
        }
        return this.toString();
    }

    private boolean writeChecked(SB output, String val) {
        if (val == null || val.length() == 0) {
            output.append(". ");
            return false;
        }
        boolean escape = val.charAt(0) == '_';
        String escapeCharStart = "'";
        String escapeCharEnd = "' ";
        boolean hasWhitespace = false;
        boolean hasSingle = false;
        boolean hasDouble = false;
        block6: for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': {
                    hasWhitespace = true;
                    continue block6;
                }
                case '\n': {
                    this.writeMultiline(output, val);
                    return true;
                }
                case '\"': {
                    if (hasSingle) {
                        this.writeMultiline(output, val);
                        return true;
                    }
                    hasDouble = true;
                    escape = true;
                    escapeCharStart = "'";
                    escapeCharEnd = "' ";
                    continue block6;
                }
                case '\'': {
                    if (hasDouble) {
                        this.writeMultiline(output, val);
                        return true;
                    }
                    escape = true;
                    hasSingle = true;
                    escapeCharStart = "\"";
                    escapeCharEnd = "\" ";
                }
            }
        }
        char fst = val.charAt(0);
        if (!escape && (fst == '#' || fst == '$' || fst == ';' || fst == '[' || fst == ']' || hasWhitespace)) {
            escapeCharStart = "'";
            escapeCharEnd = "' ";
            escape = true;
        }
        if (escape) {
            output.append(escapeCharStart).append(val).append(escapeCharEnd);
        } else {
            output.append(val).append(" ");
        }
        return false;
    }

    private void writeMultiline(SB output, String val) {
        output.append("\n;").append(val).append("\n;\n");
    }

    private SB appendKey(SB sb, String key) {
        return sb.append("\n").append(PT.formatS(key, 27, 0, true, false));
    }

    public String toString() {
        return this.oc == null ? "" : this.oc.toString();
    }
}

