classdefs = {
"InterchangeObject"     : ("0d010101-0101-0100-060e-2b3402060101", None, False, {
    "ObjClass"              : ("06010104-0101-0000-060e-2b3401010102", 0x0101, "05010100-0000-0000-060e-2b3401040101", False, False),
    "Generation"            : ("05200701-0800-0000-060e-2b3401010102", 0x0102, "01030100-0000-0000-060e-2b3401040101", True, False),
    }
),
"Component"             : ("0d010101-0101-0200-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", False, {
    "DataDefinition"        : ("04070100-0000-0000-060e-2b3401010102", 0x0201, "05010300-0000-0000-060e-2b3401040101", False, False),
    "Length"                : ("07020201-0103-0000-060e-2b3401010102", 0x0202, "01012002-0000-0000-060e-2b3401040101", True, False),
    "KLVData"               : ("03010210-0400-0000-060e-2b3401010102", 0x0203, "05060900-0000-0000-060e-2b3401040101", True, False),
    "UserComments"          : ("03020102-1600-0000-060e-2b3401010107", 0x0204, "05060800-0000-0000-060e-2b3401040101", True, False),
    "Attributes"            : ("03010210-0800-0000-060e-2b3401010107", 0x0205, "05060800-0000-0000-060e-2b3401040101", True, False),
    }
),
"Segment"               : ("0d010101-0101-0300-060e-2b3402060101", "0d010101-0101-0200-060e-2b3402060101", False, {
    }
),
"EdgeCode"              : ("0d010101-0101-0400-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", True, {
    "Start"                 : ("01040901-0000-0000-060e-2b3401010102", 0x0401, "01012001-0000-0000-060e-2b3401040101", False, False),
    "FilmKind"              : ("04100103-0109-0000-060e-2b3401010102", 0x0402, "0201010d-0000-0000-060e-2b3401040101", False, False),
    "CodeFormat"            : ("04100103-0102-0000-060e-2b3401010101", 0x0403, "0201010c-0000-0000-060e-2b3401040101", False, False),
    "Header"                : ("01030201-0200-0000-060e-2b3401010102", 0x0404, "04100100-0000-0000-060e-2b3401040101", True, False),
    }
),
"EssenceGroup"          : ("0d010101-0101-0500-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", True, {
    "Choices"               : ("06010104-0601-0000-060e-2b3401010102", 0x0501, "05060700-0000-0000-060e-2b3401040101", False, False),
    "StillFrame"            : ("06010104-0208-0000-060e-2b3401010102", 0x0502, "05020800-0000-0000-060e-2b3401040101", True, False),
    }
),
"Event"                 : ("0d010101-0101-0600-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", False, {
    "Position"              : ("07020103-0303-0000-060e-2b3401010102", 0x0601, "01012001-0000-0000-060e-2b3401040101", False, False),
    "Comment"               : ("05300404-0100-0000-060e-2b3401010102", 0x0602, "01100200-0000-0000-060e-2b3401040101", True, False),
    }
),
"GPITrigger"            : ("0d010101-0101-0700-060e-2b3402060101", "0d010101-0101-0600-060e-2b3402060101", True, {
    "ActiveState"           : ("05300401-0000-0000-060e-2b3401010101", 0x0801, "01040100-0000-0000-060e-2b3401040101", False, False),
    }
),
"CommentMarker"         : ("0d010101-0101-0800-060e-2b3402060101", "0d010101-0101-0600-060e-2b3402060101", True, {
    "Annotation"            : ("06010104-020a-0000-060e-2b3401010102", 0x0901, "05020800-0000-0000-060e-2b3401040101", True, False),
    }
),
"Filler"                : ("0d010101-0101-0900-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", True, {
    }
),
"OperationGroup"        : ("0d010101-0101-0a00-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", True, {
    "Operation"             : ("05300506-0000-0000-060e-2b3401010102", 0x0b01, "05010700-0000-0000-060e-2b3401040101", False, False),
    "InputSegments"         : ("06010104-0602-0000-060e-2b3401010102", 0x0b02, "05060600-0000-0000-060e-2b3401040101", True, False),
    "Parameters"            : ("06010104-060a-0000-060e-2b3401010102", 0x0b03, "05060a00-0000-0000-060e-2b3401040101", True, False),
    "BypassOverride"        : ("0530050c-0000-0000-060e-2b3401010102", 0x0b04, "01010300-0000-0000-060e-2b3401040101", True, False),
    "Rendering"             : ("06010104-0206-0000-060e-2b3401010102", 0x0b05, "05020800-0000-0000-060e-2b3401040101", True, False),
    }
),
"NestedScope"           : ("0d010101-0101-0b00-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", True, {
    "Slots"                 : ("06010104-0607-0000-060e-2b3401010102", 0x0c01, "05060600-0000-0000-060e-2b3401040101", False, False),
    }
),
"Pulldown"              : ("0d010101-0101-0c00-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", True, {
    "InputSegment"          : ("06010104-0207-0000-060e-2b3401010102", 0x0d01, "05020600-0000-0000-060e-2b3401040101", False, False),
    "PulldownKind"          : ("05401001-0200-0000-060e-2b3401010102", 0x0d02, "0201010b-0000-0000-060e-2b3401040101", False, False),
    "PulldownDirection"     : ("05401001-0100-0000-060e-2b3401010102", 0x0d03, "0201010a-0000-0000-060e-2b3401040101", False, False),
    "PhaseFrame"            : ("05401001-0300-0000-060e-2b3401010102", 0x0d04, "01012300-0000-0000-060e-2b3401040101", False, False),
    }
),
"ScopeReference"        : ("0d010101-0101-0d00-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", True, {
    "RelativeScope"         : ("06010103-0300-0000-060e-2b3401010102", 0x0e01, "01010300-0000-0000-060e-2b3401040101", False, False),
    "RelativeSlot"          : ("06010103-0400-0000-060e-2b3401010102", 0x0e02, "01010300-0000-0000-060e-2b3401040101", False, False),
    }
),
"Selector"              : ("0d010101-0101-0e00-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", True, {
    "Selected"              : ("06010104-0209-0000-060e-2b3401010102", 0x0f01, "05020600-0000-0000-060e-2b3401040101", False, False),
    "Alternates"            : ("06010104-0608-0000-060e-2b3401010102", 0x0f02, "05060600-0000-0000-060e-2b3401040101", True, False),
    }
),
"Sequence"              : ("0d010101-0101-0f00-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", True, {
    "Components"            : ("06010104-0609-0000-060e-2b3401010102", 0x1001, "05060100-0000-0000-060e-2b3401040101", False, False),
    }
),
"SourceReference"       : ("0d010101-0101-1000-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", False, {
    "SourceID"              : ("06010103-0100-0000-060e-2b3401010102", 0x1101, "01030200-0000-0000-060e-2b3401040101", True, False),
    "SourceMobSlotID"       : ("06010103-0200-0000-060e-2b3401010102", 0x1102, "01010300-0000-0000-060e-2b3401040101", False, False),
    "ChannelIDs"            : ("06010103-0700-0000-060e-2b3401010107", 0x1103, "04010900-0000-0000-060e-2b3401040101", True, False),
    "MonoSourceSlotIDs"     : ("06010103-0800-0000-060e-2b3401010108", 0x1104, "04010900-0000-0000-060e-2b3401040101", True, False),
    }
),
"SourceClip"            : ("0d010101-0101-1100-060e-2b3402060101", "0d010101-0101-1000-060e-2b3402060101", True, {
    "StartTime"             : ("07020103-0104-0000-060e-2b3401010102", 0x1201, "01012001-0000-0000-060e-2b3401040101", True, False),
    "FadeInLength"          : ("07020201-0105-0200-060e-2b3401010102", 0x1202, "01012002-0000-0000-060e-2b3401040101", True, False),
    "FadeInType"            : ("05300501-0000-0000-060e-2b3401010101", 0x1203, "02010107-0000-0000-060e-2b3401040101", True, False),
    "FadeOutLength"         : ("07020201-0105-0300-060e-2b3401010102", 0x1204, "01012002-0000-0000-060e-2b3401040101", True, False),
    "FadeOutType"           : ("05300502-0000-0000-060e-2b3401010101", 0x1205, "02010107-0000-0000-060e-2b3401040101", True, False),
    }
),
"TextClip"              : ("0d010101-0101-1200-060e-2b3402060101", "0d010101-0101-1000-060e-2b3402060101", False, {
    }
),
"HTMLClip"              : ("0d010101-0101-1300-060e-2b3402060101", "0d010101-0101-1200-060e-2b3402060101", True, {
    "BeginAnchor"           : ("05300601-0100-0000-060e-2b3401010102", 0x1401, "01100200-0000-0000-060e-2b3401040101", True, False),
    "EndAnchor"             : ("05300602-0100-0000-060e-2b3401010102", 0x1402, "01100200-0000-0000-060e-2b3401040101", True, False),
    }
),
"Timecode"              : ("0d010101-0101-1400-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", True, {
    "Start"                 : ("07020103-0105-0000-060e-2b3401010102", 0x1501, "01012001-0000-0000-060e-2b3401040101", False, False),
    "FPS"                   : ("04040101-0206-0000-060e-2b3401010102", 0x1502, "01010200-0000-0000-060e-2b3401040101", False, False),
    "Drop"                  : ("04040101-0500-0000-060e-2b3401010101", 0x1503, "01040100-0000-0000-060e-2b3401040101", False, False),
    }
),
"TimecodeStream"        : ("0d010101-0101-1500-060e-2b3402060101", "0d010101-0101-0300-060e-2b3402060101", False, {
    "SampleRate"            : ("04040101-0201-0000-060e-2b3401010102", 0x1601, "03010100-0000-0000-060e-2b3401040101", False, False),
    "Source"                : ("04070300-0000-0000-060e-2b3401010102", 0x1602, "04100200-0000-0000-060e-2b3401040101", False, False),
    "SourceType"            : ("04040201-0000-0000-060e-2b3401010101", 0x1603, "02010109-0000-0000-060e-2b3401040101", False, False),
    }
),
"TimecodeStream12M"     : ("0d010101-0101-1600-060e-2b3402060101", "0d010101-0101-1500-060e-2b3402060101", True, {
    "IncludeSync"           : ("04040101-0400-0000-060e-2b3401010101", 0x1701, "01040100-0000-0000-060e-2b3401040101", False, False),
    }
),
"Transition"            : ("0d010101-0101-1700-060e-2b3402060101", "0d010101-0101-0200-060e-2b3402060101", True, {
    "OperationGroup"        : ("06010104-0205-0000-060e-2b3401010102", 0x1801, "05020500-0000-0000-060e-2b3401040101", False, False),
    "CutPoint"              : ("07020103-0106-0000-060e-2b3401010102", 0x1802, "01012001-0000-0000-060e-2b3401040101", False, False),
    }
),
"ContentStorage"        : ("0d010101-0101-1800-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", True, {
    "Mobs"                  : ("06010104-0501-0000-060e-2b3401010102", 0x1901, "05050700-0000-0000-060e-2b3401040101", False, False),
    "EssenceData"           : ("06010104-0502-0000-060e-2b3401010102", 0x1902, "05050500-0000-0000-060e-2b3401040101", True, False),
    }
),
"ControlPoint"          : ("0d010101-0101-1900-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", True, {
    "Value"                 : ("0530050d-0000-0000-060e-2b3401010102", 0x1a02, "04100300-0000-0000-060e-2b3401040101", False, False),
    "Time"                  : ("07020103-1002-0100-060e-2b3401010102", 0x1a03, "03010100-0000-0000-060e-2b3401040101", False, False),
    "EditHint"              : ("05300508-0000-0000-060e-2b3401010102", 0x1a04, "02010106-0000-0000-060e-2b3401040101", True, False),
    }
),
"DefinitionObject"      : ("0d010101-0101-1a00-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", False, {
    "Identification"        : ("01011503-0000-0000-060e-2b3401010102", 0x1b01, "01030100-0000-0000-060e-2b3401040101", False, True),
    "Name"                  : ("01070102-0301-0000-060e-2b3401010102", 0x1b02, "01100200-0000-0000-060e-2b3401040101", False, False),
    "Description"           : ("03020301-0201-0000-060e-2b3401010102", 0x1b03, "01100200-0000-0000-060e-2b3401040101", True, False),
    }
),
"DataDefinition"        : ("0d010101-0101-1b00-060e-2b3402060101", "0d010101-0101-1a00-060e-2b3402060101", True, {
    }
),
"OperationDefinition"   : ("0d010101-0101-1c00-060e-2b3402060101", "0d010101-0101-1a00-060e-2b3402060101", True, {
    "DataDefinition"        : ("05300509-0000-0000-060e-2b3401010102", 0x1e01, "05010300-0000-0000-060e-2b3401040101", False, False),
    "IsTimeWarp"            : ("05300503-0000-0000-060e-2b3401010101", 0x1e02, "01040100-0000-0000-060e-2b3401040101", True, False),
    "DegradeTo"             : ("06010104-0401-0000-060e-2b3401010102", 0x1e03, "05040100-0000-0000-060e-2b3401040101", True, False),
    "OperationCategory"     : ("0530050a-0000-0000-060e-2b3401010102", 0x1e06, "02020101-0000-0000-060e-2b3401040101", True, False),
    "NumberInputs"          : ("05300504-0000-0000-060e-2b3401010101", 0x1e07, "01010700-0000-0000-060e-2b3401040101", False, False),
    "Bypass"                : ("05300505-0000-0000-060e-2b3401010101", 0x1e08, "01010300-0000-0000-060e-2b3401040101", True, False),
    "ParametersDefined"     : ("06010104-0302-0000-060e-2b3401010102", 0x1e09, "05030e00-0000-0000-060e-2b3401040101", True, False),
    }
),
"ParameterDefinition"   : ("0d010101-0101-1d00-060e-2b3402060101", "0d010101-0101-1a00-060e-2b3402060101", True, {
    "Type"                  : ("06010104-0106-0000-060e-2b3401010102", 0x1f01, "05010900-0000-0000-060e-2b3401040101", False, False),
    "DisplayUnits"          : ("0530050b-0100-0000-060e-2b3401010102", 0x1f03, "01100200-0000-0000-060e-2b3401040101", True, False),
    }
),
"PluginDefinition"      : ("0d010101-0101-1e00-060e-2b3402060101", "0d010101-0101-1a00-060e-2b3402060101", True, {
    "PluginCategory"        : ("05200901-0000-0000-060e-2b3401010102", 0x2203, "02020103-0000-0000-060e-2b3401040101", False, False),
    "VersionNumber"         : ("03030301-0300-0000-060e-2b3401010102", 0x2204, "03010300-0000-0000-060e-2b3401040101", False, False),
    "VersionString"         : ("03030301-0201-0000-060e-2b3401010102", 0x2205, "01100200-0000-0000-060e-2b3401040101", True, False),
    "Manufacturer"          : ("010a0101-0101-0000-060e-2b3401010102", 0x2206, "01100200-0000-0000-060e-2b3401040101", True, False),
    "ManufacturerInfo"      : ("06010104-020b-0000-060e-2b3401010102", 0x2207, "05020400-0000-0000-060e-2b3401040101", True, False),
    "ManufacturerID"        : ("010a0101-0300-0000-060e-2b3401010102", 0x2208, "01030100-0000-0000-060e-2b3401040101", True, False),
    "Platform"              : ("05200902-0000-0000-060e-2b3401010102", 0x2209, "01030100-0000-0000-060e-2b3401040101", True, False),
    "MinPlatformVersion"    : ("05200903-0000-0000-060e-2b3401010102", 0x220a, "03010300-0000-0000-060e-2b3401040101", True, False),
    "MaxPlatformVersion"    : ("05200904-0000-0000-060e-2b3401010102", 0x220b, "03010300-0000-0000-060e-2b3401040101", True, False),
    "Engine"                : ("05200905-0000-0000-060e-2b3401010102", 0x220c, "01030100-0000-0000-060e-2b3401040101", True, False),
    "MinEngineVersion"      : ("05200906-0000-0000-060e-2b3401010102", 0x220d, "03010300-0000-0000-060e-2b3401040101", True, False),
    "MaxEngineVersion"      : ("05200907-0000-0000-060e-2b3401010102", 0x220e, "03010300-0000-0000-060e-2b3401040101", True, False),
    "PluginAPI"             : ("05200908-0000-0000-060e-2b3401010102", 0x220f, "01030100-0000-0000-060e-2b3401040101", True, False),
    "MinPluginAPI"          : ("05200909-0000-0000-060e-2b3401010102", 0x2210, "03010300-0000-0000-060e-2b3401040101", True, False),
    "MaxPluginAPI"          : ("0520090a-0000-0000-060e-2b3401010102", 0x2211, "03010300-0000-0000-060e-2b3401040101", True, False),
    "SoftwareOnly"          : ("0520090b-0000-0000-060e-2b3401010102", 0x2212, "01040100-0000-0000-060e-2b3401040101", True, False),
    "Accelerator"           : ("0520090c-0000-0000-060e-2b3401010102", 0x2213, "01040100-0000-0000-060e-2b3401040101", True, False),
    "Locators"              : ("0520090d-0000-0000-060e-2b3401010102", 0x2214, "05060400-0000-0000-060e-2b3401040101", True, False),
    "Authentication"        : ("0520090e-0000-0000-060e-2b3401010102", 0x2215, "01040100-0000-0000-060e-2b3401040101", True, False),
    "DefinitionObject"      : ("0520090f-0000-0000-060e-2b3401010102", 0x2216, "01030100-0000-0000-060e-2b3401040101", True, False),
    }
),
"CodecDefinition"       : ("0d010101-0101-1f00-060e-2b3402060101", "0d010101-0101-1a00-060e-2b3402060101", True, {
    "FileDescriptorClass"   : ("06010104-0107-0000-060e-2b3401010102", 0x2301, "05010100-0000-0000-060e-2b3401040101", False, False),
    "DataDefinitions"       : ("06010104-0301-0000-060e-2b3401010102", 0x2302, "05040300-0000-0000-060e-2b3401040101", False, False),
    }
),
"ContainerDefinition"   : ("0d010101-0101-2000-060e-2b3402060101", "0d010101-0101-1a00-060e-2b3402060101", True, {
    "EssenceIsIdentified"   : ("03010201-0300-0000-060e-2b3401010101", 0x2401, "01040100-0000-0000-060e-2b3401040101", True, False),
    }
),
"InterpolationDefinition" : ("0d010101-0101-2100-060e-2b3402060101", "0d010101-0101-1a00-060e-2b3402060101", True, {
    }
),
"Dictionary"            : ("0d010101-0101-2200-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", True, {
    "OperationDefinitions"  : ("06010104-0503-0000-060e-2b3401010102", 0x2603, "05050800-0000-0000-060e-2b3401040101", True, False),
    "ParameterDefinitions"  : ("06010104-0504-0000-060e-2b3401010102", 0x2604, "05050900-0000-0000-060e-2b3401040101", True, False),
    "DataDefinitions"       : ("06010104-0505-0000-060e-2b3401010102", 0x2605, "05050400-0000-0000-060e-2b3401040101", True, False),
    "PluginDefinitions"     : ("06010104-0506-0000-060e-2b3401010102", 0x2606, "05050a00-0000-0000-060e-2b3401040101", True, False),
    "CodecDefinitions"      : ("06010104-0507-0000-060e-2b3401010102", 0x2607, "05050200-0000-0000-060e-2b3401040101", True, False),
    "ContainerDefinitions"  : ("06010104-0508-0000-060e-2b3401010102", 0x2608, "05050300-0000-0000-060e-2b3401040101", True, False),
    "InterpolationDefinitions": ("06010104-0509-0000-060e-2b3401010102", 0x2609, "05050600-0000-0000-060e-2b3401040101", True, False),
    "KLVDataDefinitions"    : ("06010104-050a-0000-060e-2b3401010107", 0x260a, "05050d00-0000-0000-060e-2b3401040101", True, False),
    "TaggedValueDefinitions": ("06010104-050b-0000-060e-2b3401010107", 0x260b, "05050e00-0000-0000-060e-2b3401040101", True, False),
    }
),
"EssenceData"           : ("0d010101-0101-2300-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", True, {
    "MobID"                 : ("06010106-0100-0000-060e-2b3401010102", 0x2701, "01030200-0000-0000-060e-2b3401040101", False, True),
    "Data"                  : ("04070200-0000-0000-060e-2b3401010102", 0x2702, "04100200-0000-0000-060e-2b3401040101", False, False),
    "SampleIndex"           : ("06010102-0100-0000-060e-2b3401010102", 0x2b01, "04100200-0000-0000-060e-2b3401040101", True, False),
    }
),
"EssenceDescriptor"     : ("0d010101-0101-2400-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", False, {
    "Locator"               : ("06010104-0603-0000-060e-2b3401010102", 0x2f01, "05060400-0000-0000-060e-2b3401040101", True, False),
    "SubDescriptors"        : ("06010104-0610-0000-060e-2b3401010109", None, "05060e00-0000-0000-060e-2b3401040101", True, False),
    }
),
"FileDescriptor"        : ("0d010101-0101-2500-060e-2b3402060101", "0d010101-0101-2400-060e-2b3402060101", False, {
    "SampleRate"            : ("04060101-0000-0000-060e-2b3401010101", 0x3001, "03010100-0000-0000-060e-2b3401040101", False, False),
    "Length"                : ("04060102-0000-0000-060e-2b3401010101", 0x3002, "01012002-0000-0000-060e-2b3401040101", False, False),
    "ContainerFormat"       : ("06010104-0102-0000-060e-2b3401010102", 0x3004, "05010200-0000-0000-060e-2b3401040101", True, False),
    "CodecDefinition"       : ("06010104-0103-0000-060e-2b3401010102", 0x3005, "05010b00-0000-0000-060e-2b3401040101", True, False),
    "LinkedSlotID"          : ("06010103-0500-0000-060e-2b3401010105", 0x3006, "01010300-0000-0000-060e-2b3401040101", True, False),
    }
),
"AIFCDescriptor"        : ("0d010101-0101-2600-060e-2b3402060101", "0d010101-0101-2500-060e-2b3402060101", True, {
    "Summary"               : ("03030302-0200-0000-060e-2b3401010102", 0x3101, "04100100-0000-0000-060e-2b3401040101", False, False),
    }
),
"DigitalImageDescriptor" : ("0d010101-0101-2700-060e-2b3402060101", "0d010101-0101-2500-060e-2b3402060101", False, {
    "Compression"           : ("04010601-0000-0000-060e-2b3401010102", 0x3201, "01030100-0000-0000-060e-2b3401040101", True, False),
    "StoredHeight"          : ("04010502-0100-0000-060e-2b3401010101", 0x3202, "01010300-0000-0000-060e-2b3401040101", False, False),
    "StoredWidth"           : ("04010502-0200-0000-060e-2b3401010101", 0x3203, "01010300-0000-0000-060e-2b3401040101", False, False),
    "SampledHeight"         : ("04010501-0700-0000-060e-2b3401010101", 0x3204, "01010300-0000-0000-060e-2b3401040101", True, False),
    "SampledWidth"          : ("04010501-0800-0000-060e-2b3401010101", 0x3205, "01010300-0000-0000-060e-2b3401040101", True, False),
    "SampledXOffset"        : ("04010501-0900-0000-060e-2b3401010101", 0x3206, "01010700-0000-0000-060e-2b3401040101", True, False),
    "SampledYOffset"        : ("04010501-0a00-0000-060e-2b3401010101", 0x3207, "01010700-0000-0000-060e-2b3401040101", True, False),
    "DisplayHeight"         : ("04010501-0b00-0000-060e-2b3401010101", 0x3208, "01010300-0000-0000-060e-2b3401040101", True, False),
    "DisplayWidth"          : ("04010501-0c00-0000-060e-2b3401010101", 0x3209, "01010300-0000-0000-060e-2b3401040101", True, False),
    "DisplayXOffset"        : ("04010501-0d00-0000-060e-2b3401010101", 0x320a, "01010700-0000-0000-060e-2b3401040101", True, False),
    "DisplayYOffset"        : ("04010501-0e00-0000-060e-2b3401010101", 0x320b, "01010700-0000-0000-060e-2b3401040101", True, False),
    "FrameLayout"           : ("04010301-0400-0000-060e-2b3401010101", 0x320c, "02010108-0000-0000-060e-2b3401040101", False, False),
    "VideoLineMap"          : ("04010302-0500-0000-060e-2b3401010102", 0x320d, "04010300-0000-0000-060e-2b3401040101", False, False),
    "ImageAspectRatio"      : ("04010101-0100-0000-060e-2b3401010101", 0x320e, "03010100-0000-0000-060e-2b3401040101", False, False),
    "AlphaTransparency"     : ("05200102-0000-0000-060e-2b3401010102", 0x320f, "02010120-0000-0000-060e-2b3401040101", True, False),
    "TransferCharacteristic": ("04010201-0101-0200-060e-2b3401010102", 0x3210, "02020102-0000-0000-060e-2b3401040101", True, False),
    "ColorPrimaries"        : ("04010201-0106-0100-060e-2b3401010109", 0x3219, "02020105-0000-0000-060e-2b3401040101", True, False),
    "CodingEquations"       : ("04010201-0103-0100-060e-2b3401010102", 0x321a, "02020106-0000-0000-060e-2b3401040101", True, False),
    "ImageAlignmentFactor"  : ("04180101-0000-0000-060e-2b3401010102", 0x3211, "01010300-0000-0000-060e-2b3401040101", True, False),
    "FieldDominance"        : ("04010301-0600-0000-060e-2b3401010102", 0x3212, "02010121-0000-0000-060e-2b3401040101", True, False),
    "FieldStartOffset"      : ("04180102-0000-0000-060e-2b3401010102", 0x3213, "01010300-0000-0000-060e-2b3401040101", True, False),
    "FieldEndOffset"        : ("04180103-0000-0000-060e-2b3401010102", 0x3214, "01010300-0000-0000-060e-2b3401040101", True, False),
    "SignalStandard"        : ("04050113-0000-0000-060e-2b3401010105", 0x3215, "02010127-0000-0000-060e-2b3401040101", True, False),
    "StoredF2Offset"        : ("04010302-0800-0000-060e-2b3401010105", 0x3216, "01010700-0000-0000-060e-2b3401040101", True, False),
    "DisplayF2Offset"       : ("04010302-0700-0000-060e-2b3401010105", 0x3217, "01010700-0000-0000-060e-2b3401040101", True, False),
    "ActiveFormatDescriptor": ("04010302-0900-0000-060e-2b3401010105", 0x3218, "01010100-0000-0000-060e-2b3401040101", True, False),
    }
),
"CDCIDescriptor"        : ("0d010101-0101-2800-060e-2b3402060101", "0d010101-0101-2700-060e-2b3402060101", True, {
    "ComponentWidth"        : ("04010503-0a00-0000-060e-2b3401010102", 0x3301, "01010300-0000-0000-060e-2b3401040101", False, False),
    "HorizontalSubsampling" : ("04010501-0500-0000-060e-2b3401010101", 0x3302, "01010300-0000-0000-060e-2b3401040101", False, False),
    "ColorSiting"           : ("04010501-0600-0000-060e-2b3401010101", 0x3303, "02010105-0000-0000-060e-2b3401040101", True, False),
    "BlackReferenceLevel"   : ("04010503-0300-0000-060e-2b3401010101", 0x3304, "01010300-0000-0000-060e-2b3401040101", True, False),
    "WhiteReferenceLevel"   : ("04010503-0400-0000-060e-2b3401010101", 0x3305, "01010300-0000-0000-060e-2b3401040101", True, False),
    "ColorRange"            : ("04010503-0500-0000-060e-2b3401010102", 0x3306, "01010300-0000-0000-060e-2b3401040101", True, False),
    "PaddingBits"           : ("04180104-0000-0000-060e-2b3401010102", 0x3307, "01010600-0000-0000-060e-2b3401040101", True, False),
    "VerticalSubsampling"   : ("04010501-1000-0000-060e-2b3401010102", 0x3308, "01010300-0000-0000-060e-2b3401040101", True, False),
    "AlphaSamplingWidth"    : ("04010503-0700-0000-060e-2b3401010102", 0x3309, "01010300-0000-0000-060e-2b3401040101", True, False),
    "ReversedByteOrder"     : ("03010201-0a00-0000-060e-2b3401010105", 0x330b, "01040100-0000-0000-060e-2b3401040101", True, False),
    }
),
"RGBADescriptor"        : ("0d010101-0101-2900-060e-2b3402060101", "0d010101-0101-2700-060e-2b3402060101", True, {
    "PixelLayout"           : ("04010503-0600-0000-060e-2b3401010102", 0x3401, "04020100-0000-0000-060e-2b3401040101", False, False),
    "Palette"               : ("04010503-0800-0000-060e-2b3401010102", 0x3403, "04100100-0000-0000-060e-2b3401040101", True, False),
    "PaletteLayout"         : ("04010503-0900-0000-060e-2b3401010102", 0x3404, "04020100-0000-0000-060e-2b3401040101", True, False),
    "ScanningDirection"     : ("04010404-0100-0000-060e-2b3401010105", 0x3405, "02010128-0000-0000-060e-2b3401040101", True, False),
    "ComponentMaxRef"       : ("04010503-0b00-0000-060e-2b3401010105", 0x3406, "01010300-0000-0000-060e-2b3401040101", True, False),
    "ComponentMinRef"       : ("04010503-0c00-0000-060e-2b3401010105", 0x3407, "01010300-0000-0000-060e-2b3401040101", True, False),
    "AlphaMaxRef"           : ("04010503-0d00-0000-060e-2b3401010105", 0x3408, "01010300-0000-0000-060e-2b3401040101", True, False),
    "AlphaMinRef"           : ("04010503-0e00-0000-060e-2b3401010105", 0x3409, "01010300-0000-0000-060e-2b3401040101", True, False),
    }
),
"HTMLDescriptor"        : ("0d010101-0101-2a00-060e-2b3402060101", "0d010101-0101-2500-060e-2b3402060101", True, {
    }
),
"TIFFDescriptor"        : ("0d010101-0101-2b00-060e-2b3402060101", "0d010101-0101-2500-060e-2b3402060101", True, {
    "IsUniform"             : ("05020103-0101-0000-060e-2b3401010102", 0x3701, "01040100-0000-0000-060e-2b3401040101", False, False),
    "IsContiguous"          : ("06080201-0000-0000-060e-2b3401010101", 0x3702, "01040100-0000-0000-060e-2b3401040101", False, False),
    "LeadingLines"          : ("04010302-0300-0000-060e-2b3401010101", 0x3703, "01010700-0000-0000-060e-2b3401040101", True, False),
    "TrailingLines"         : ("04010302-0400-0000-060e-2b3401010101", 0x3704, "01010700-0000-0000-060e-2b3401040101", True, False),
    "JPEGTableID"           : ("05020103-0102-0000-060e-2b3401010102", 0x3705, "01012003-0000-0000-060e-2b3401040101", True, False),
    "Summary"               : ("03030302-0300-0000-060e-2b3401010102", 0x3706, "04100100-0000-0000-060e-2b3401040101", False, False),
    }
),
"WAVEDescriptor"        : ("0d010101-0101-2c00-060e-2b3402060101", "0d010101-0101-2500-060e-2b3402060101", True, {
    "Summary"               : ("03030302-0100-0000-060e-2b3401010102", 0x3801, "04100100-0000-0000-060e-2b3401040101", False, False),
    }
),
"FilmDescriptor"        : ("0d010101-0101-2d00-060e-2b3402060101", "0d010101-0101-2400-060e-2b3402060101", True, {
    "FilmFormat"            : ("04100103-0108-0000-060e-2b3401010102", 0x3901, "0201010d-0000-0000-060e-2b3401040101", True, False),
    "FrameRate"             : ("04010802-0300-0000-060e-2b3401010102", 0x3902, "01010300-0000-0000-060e-2b3401040101", True, False),
    "PerforationsPerFrame"  : ("04100103-0103-0000-060e-2b3401010102", 0x3903, "01010100-0000-0000-060e-2b3401040101", True, False),
    "FilmAspectRatio"       : ("04100103-0203-0000-060e-2b3401010102", 0x3904, "03010100-0000-0000-060e-2b3401040101", True, False),
    "Manufacturer"          : ("04100103-0106-0100-060e-2b3401010102", 0x3905, "01100200-0000-0000-060e-2b3401040101", True, False),
    "Model"                 : ("04100103-0105-0100-060e-2b3401010102", 0x3906, "01100200-0000-0000-060e-2b3401040101", True, False),
    "FilmGaugeFormat"       : ("04100103-0104-0100-060e-2b3401010102", 0x3907, "01100200-0000-0000-060e-2b3401040101", True, False),
    "FilmBatchNumber"       : ("04100103-0107-0100-060e-2b3401010102", 0x3908, "01100200-0000-0000-060e-2b3401040101", True, False),
    }
),
"TapeDescriptor"        : ("0d010101-0101-2e00-060e-2b3402060101", "0d010101-0101-2400-060e-2b3402060101", True, {
    "FormFactor"            : ("04100101-0101-0000-060e-2b3401010102", 0x3a01, "02010104-0000-0000-060e-2b3401040101", True, False),
    "VideoSignal"           : ("04010401-0100-0000-060e-2b3401010102", 0x3a02, "02010103-0000-0000-060e-2b3401040101", True, False),
    "TapeFormat"            : ("0d010101-0101-0100-060e-2b3401010102", 0x3a03, "02010102-0000-0000-060e-2b3401040101", True, False),
    "Length"                : ("04100101-0300-0000-060e-2b3401010102", 0x3a04, "01010300-0000-0000-060e-2b3401040101", True, False),
    "ManufacturerID"        : ("04100101-0401-0000-060e-2b3401010102", 0x3a05, "01100200-0000-0000-060e-2b3401040101", True, False),
    "Model"                 : ("04100101-0201-0000-060e-2b3401010102", 0x3a06, "01100200-0000-0000-060e-2b3401040101", True, False),
    "TapeBatchNumber"       : ("04100101-0601-0000-060e-2b3401010102", 0x3a07, "01100200-0000-0000-060e-2b3401040101", True, False),
    "TapeStock"             : ("04100101-0501-0000-060e-2b3401010102", 0x3a08, "01100200-0000-0000-060e-2b3401040101", True, False),
    }
),
"Header"                : ("0d010101-0101-2f00-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", True, {
    "ByteOrder"             : ("03010201-0200-0000-060e-2b3401010101", 0x3b01, "01010600-0000-0000-060e-2b3401040101", False, False),
    "LastModified"          : ("07020110-0204-0000-060e-2b3401010102", 0x3b02, "03010700-0000-0000-060e-2b3401040101", False, False),
    "Content"               : ("06010104-0201-0000-060e-2b3401010102", 0x3b03, "05020100-0000-0000-060e-2b3401040101", False, False),
    "Dictionary"            : ("06010104-0202-0000-060e-2b3401010102", 0x3b04, "05020200-0000-0000-060e-2b3401040101", False, False),
    "Version"               : ("03010201-0500-0000-060e-2b3401010102", 0x3b05, "03010300-0000-0000-060e-2b3401040101", False, False),
    "IdentificationList"    : ("06010104-0604-0000-060e-2b3401010102", 0x3b06, "05060300-0000-0000-060e-2b3401040101", False, False),
    "ObjectModelVersion"    : ("03010201-0400-0000-060e-2b3401010102", 0x3b07, "01010300-0000-0000-060e-2b3401040101", True, False),
    "PrimaryMob"            : ("06010104-0108-0000-060e-2b3401010104", 0x3b08, "05010600-0000-0000-060e-2b3401040101", True, False),
    "OperationalPattern"    : ("01020203-0000-0000-060e-2b3401010105", 0x3b09, "01030100-0000-0000-060e-2b3401040101", True, False),
    "EssenceContainers"     : ("01020210-0201-0000-060e-2b3401010105", 0x3b0a, "04030100-0000-0000-060e-2b3401040101", True, False),
    "DescriptiveSchemes"    : ("01020210-0202-0000-060e-2b3401010105", 0x3b0b, "04030100-0000-0000-060e-2b3401040101", True, False),
    }
),
"Identification"        : ("0d010101-0101-3000-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", True, {
    "CompanyName"           : ("05200701-0201-0000-060e-2b3401010102", 0x3c01, "01100200-0000-0000-060e-2b3401040101", False, False),
    "ProductName"           : ("05200701-0301-0000-060e-2b3401010102", 0x3c02, "01100200-0000-0000-060e-2b3401040101", False, False),
    "ProductVersion"        : ("05200701-0400-0000-060e-2b3401010102", 0x3c03, "03010200-0000-0000-060e-2b3401040101", True, False),
    "ProductVersionString"  : ("05200701-0501-0000-060e-2b3401010102", 0x3c04, "01100200-0000-0000-060e-2b3401040101", False, False),
    "ProductID"             : ("05200701-0700-0000-060e-2b3401010102", 0x3c05, "01030100-0000-0000-060e-2b3401040101", False, False),
    "Date"                  : ("07020110-0203-0000-060e-2b3401010102", 0x3c06, "03010700-0000-0000-060e-2b3401040101", False, False),
    "ToolkitVersion"        : ("05200701-0a00-0000-060e-2b3401010102", 0x3c07, "03010200-0000-0000-060e-2b3401040101", True, False),
    "Platform"              : ("05200701-0601-0000-060e-2b3401010102", 0x3c08, "01100200-0000-0000-060e-2b3401040101", True, False),
    "GenerationAUID"        : ("05200701-0100-0000-060e-2b3401010102", 0x3c09, "01030100-0000-0000-060e-2b3401040101", False, False),
    }
),
"Locator"               : ("0d010101-0101-3100-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", False, {
    }
),
"NetworkLocator"        : ("0d010101-0101-3200-060e-2b3402060101", "0d010101-0101-3100-060e-2b3402060101", True, {
    "URLString"             : ("01020101-0100-0000-060e-2b3401010101", 0x4001, "01100200-0000-0000-060e-2b3401040101", False, False),
    }
),
"TextLocator"           : ("0d010101-0101-3300-060e-2b3402060101", "0d010101-0101-3100-060e-2b3402060101", True, {
    "Name"                  : ("01040102-0100-0000-060e-2b3401010102", 0x4101, "01100200-0000-0000-060e-2b3401040101", False, False),
    }
),
"Mob"                   : ("0d010101-0101-3400-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", False, {
    "MobID"                 : ("01011510-0000-0000-060e-2b3401010101", 0x4401, "01030200-0000-0000-060e-2b3401040101", False, True),
    "Name"                  : ("01030302-0100-0000-060e-2b3401010101", 0x4402, "01100200-0000-0000-060e-2b3401040101", True, False),
    "Slots"                 : ("06010104-0605-0000-060e-2b3401010102", 0x4403, "05060500-0000-0000-060e-2b3401040101", False, False),
    "LastModified"          : ("07020110-0205-0000-060e-2b3401010102", 0x4404, "03010700-0000-0000-060e-2b3401040101", False, False),
    "CreationTime"          : ("07020110-0103-0000-060e-2b3401010102", 0x4405, "03010700-0000-0000-060e-2b3401040101", False, False),
    "UserComments"          : ("03020102-0c00-0000-060e-2b3401010102", 0x4406, "05060800-0000-0000-060e-2b3401040101", True, False),
    "KLVData"               : ("03010210-0300-0000-060e-2b3401010102", 0x4407, "05060900-0000-0000-060e-2b3401040101", True, False),
    "Attributes"            : ("03010210-0700-0000-060e-2b3401010107", 0x4409, "05060800-0000-0000-060e-2b3401040101", True, False),
    "UsageCode"             : ("05010108-0000-0000-060e-2b3401010107", 0x4408, "02020104-0000-0000-060e-2b3401040101", True, False),
    }
),
"CompositionMob"        : ("0d010101-0101-3500-060e-2b3402060101", "0d010101-0101-3400-060e-2b3402060101", True, {
    "DefaultFadeLength"     : ("07020201-0105-0100-060e-2b3401010102", 0x4501, "01012002-0000-0000-060e-2b3401040101", True, False),
    "DefFadeType"           : ("05300201-0000-0000-060e-2b3401010101", 0x4502, "02010107-0000-0000-060e-2b3401040101", True, False),
    "DefFadeEditUnit"       : ("05300403-0000-0000-060e-2b3401010102", 0x4503, "03010100-0000-0000-060e-2b3401040101", True, False),
    "Rendering"             : ("06010104-010a-0000-060e-2b3401010108", 0x4504, "01030200-0000-0000-060e-2b3401040101", True, False),
    }
),
"MasterMob"             : ("0d010101-0101-3600-060e-2b3402060101", "0d010101-0101-3400-060e-2b3402060101", True, {
    }
),
"SourceMob"             : ("0d010101-0101-3700-060e-2b3402060101", "0d010101-0101-3400-060e-2b3402060101", True, {
    "EssenceDescription"    : ("06010104-0203-0000-060e-2b3401010102", 0x4701, "05020300-0000-0000-060e-2b3401040101", False, False),
    }
),
"MobSlot"               : ("0d010101-0101-3800-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", False, {
    "SlotID"                : ("01070101-0000-0000-060e-2b3401010102", 0x4801, "01010300-0000-0000-060e-2b3401040101", False, False),
    "SlotName"              : ("01070102-0100-0000-060e-2b3401010102", 0x4802, "01100200-0000-0000-060e-2b3401040101", True, False),
    "Segment"               : ("06010104-0204-0000-060e-2b3401010102", 0x4803, "05020600-0000-0000-060e-2b3401040101", False, False),
    "PhysicalTrackNumber"   : ("01040103-0000-0000-060e-2b3401010102", 0x4804, "01010300-0000-0000-060e-2b3401040101", True, False),
    }
),
"EventMobSlot"          : ("0d010101-0101-3900-060e-2b3402060101", "0d010101-0101-3800-060e-2b3402060101", True, {
    "EditRate"              : ("05300402-0000-0000-060e-2b3401010102", 0x4901, "03010100-0000-0000-060e-2b3401040101", False, False),
    "EventSlotOrigin"       : ("07020103-010b-0000-060e-2b3401010105", 0x4902, "01012001-0000-0000-060e-2b3401040101", True, False),
    }
),
"StaticMobSlot"         : ("0d010101-0101-3a00-060e-2b3402060101", "0d010101-0101-3800-060e-2b3402060101", True, {
    }
),
"TimelineMobSlot"       : ("0d010101-0101-3b00-060e-2b3402060101", "0d010101-0101-3800-060e-2b3402060101", True, {
    "EditRate"              : ("05300405-0000-0000-060e-2b3401010102", 0x4b01, "03010100-0000-0000-060e-2b3401040101", False, False),
    "Origin"                : ("07020103-0103-0000-060e-2b3401010102", 0x4b02, "01012001-0000-0000-060e-2b3401040101", False, False),
    "MarkIn"                : ("07020103-010c-0000-060e-2b3401010107", 0x4b03, "01012001-0000-0000-060e-2b3401040101", True, False),
    "MarkOut"               : ("07020103-0203-0000-060e-2b3401010107", 0x4b04, "01012001-0000-0000-060e-2b3401040101", True, False),
    "UserPos"               : ("07020103-010d-0000-060e-2b3401010107", 0x4b05, "01012001-0000-0000-060e-2b3401040101", True, False),
    }
),
"Parameter"             : ("0d010101-0101-3c00-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", False, {
    "Definition"            : ("06010104-0104-0000-060e-2b3401010102", 0x4c01, "01030100-0000-0000-060e-2b3401040101", False, False),
    }
),
"ConstantValue"         : ("0d010101-0101-3d00-060e-2b3402060101", "0d010101-0101-3c00-060e-2b3402060101", True, {
    "Value"                 : ("05300507-0000-0000-060e-2b3401010102", 0x4d01, "04100300-0000-0000-060e-2b3401040101", False, False),
    }
),
"VaryingValue"          : ("0d010101-0101-3e00-060e-2b3402060101", "0d010101-0101-3c00-060e-2b3402060101", True, {
    "Interpolation"         : ("06010104-0105-0000-060e-2b3401010102", 0x4e01, "05010500-0000-0000-060e-2b3401040101", False, False),
    "PointList"             : ("06010104-0606-0000-060e-2b3401010102", 0x4e02, "05060200-0000-0000-060e-2b3401040101", False, False),
    }
),
"TaggedValue"           : ("0d010101-0101-3f00-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", True, {
    "Name"                  : ("03020102-0901-0000-060e-2b3401010102", 0x5001, "01100200-0000-0000-060e-2b3401040101", False, False),
    "Value"                 : ("03020102-0a01-0000-060e-2b3401010102", 0x5003, "04100300-0000-0000-060e-2b3401040101", False, False),
    }
),
"KLVData"               : ("0d010101-0101-4000-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", True, {
    "Value"                 : ("03010210-0200-0000-060e-2b3401010102", 0x5101, "04100400-0000-0000-060e-2b3401040101", False, False),
    }
),
"DescriptiveMarker"     : ("0d010101-0101-4100-060e-2b3402060101", "0d010101-0101-0800-060e-2b3402060101", True, {
    "DescribedSlots"        : ("01070105-0000-0000-060e-2b3401010104", 0x6102, "04030200-0000-0000-060e-2b3401040101", True, False),
    "Description"           : ("06010104-020c-0000-060e-2b3401010105", 0x6101, "05021f00-0000-0000-060e-2b3401040101", True, False),
    }
),
"SoundDescriptor"       : ("0d010101-0101-4200-060e-2b3402060101", "0d010101-0101-2500-060e-2b3402060101", True, {
    "AudioSamplingRate"     : ("04020301-0101-0000-060e-2b3401010105", 0x3d03, "03010100-0000-0000-060e-2b3401040101", False, False),
    "Locked"                : ("04020301-0400-0000-060e-2b3401010104", 0x3d02, "01040100-0000-0000-060e-2b3401040101", True, False),
    "AudioRefLevel"         : ("04020101-0300-0000-060e-2b3401010101", 0x3d04, "01010500-0000-0000-060e-2b3401040101", True, False),
    "ElectroSpatial"        : ("04020101-0100-0000-060e-2b3401010101", 0x3d05, "02010122-0000-0000-060e-2b3401040101", True, False),
    "Channels"              : ("04020101-0400-0000-060e-2b3401010105", 0x3d07, "01010300-0000-0000-060e-2b3401040101", False, False),
    "QuantizationBits"      : ("04020303-0400-0000-060e-2b3401010104", 0x3d01, "01010300-0000-0000-060e-2b3401040101", False, False),
    "DialNorm"              : ("04020701-0000-0000-060e-2b3401010105", 0x3d0c, "01010500-0000-0000-060e-2b3401040101", True, False),
    "Compression"           : ("04020402-0000-0000-060e-2b3401010102", 0x3d06, "01030100-0000-0000-060e-2b3401040101", True, False),
    }
),
"DataEssenceDescriptor" : ("0d010101-0101-4300-060e-2b3402060101", "0d010101-0101-2500-060e-2b3402060101", True, {
    "DataEssenceCoding"     : ("04030302-0000-0000-060e-2b3401010103", 0x3e01, "01030100-0000-0000-060e-2b3401040101", True, False),
    }
),
"MultipleDescriptor"    : ("0d010101-0101-4400-060e-2b3402060101", "0d010101-0101-2500-060e-2b3402060101", True, {
    "FileDescriptors"       : ("06010104-060b-0000-060e-2b3401010104", 0x3f01, "05060b00-0000-0000-060e-2b3401040101", False, False),
    }
),
"DescriptiveClip"       : ("0d010101-0101-4500-060e-2b3402060101", "0d010101-0101-1100-060e-2b3402060101", True, {
    "DescribedSlotIDs"      : ("01070106-0000-0000-060e-2b3401010105", 0x6103, "04030200-0000-0000-060e-2b3401040101", True, False),
    }
),
"AES3PCMDescriptor"     : ("0d010101-0101-4700-060e-2b3402060101", "0d010101-0101-4800-060e-2b3402060101", True, {
    "Emphasis"              : ("04020501-0600-0000-060e-2b3401010105", 0x3d0d, "02010123-0000-0000-060e-2b3401040101", True, False),
    "BlockStartOffset"      : ("04020302-0300-0000-060e-2b3401010105", 0x3d0f, "01010200-0000-0000-060e-2b3401040101", True, False),
    "AuxBitsMode"           : ("04020501-0100-0000-060e-2b3401010105", 0x3d08, "02010124-0000-0000-060e-2b3401040101", True, False),
    "ChannelStatusMode"     : ("04020501-0200-0000-060e-2b3401010105", 0x3d10, "04010a00-0000-0000-060e-2b3401040101", True, False),
    "FixedChannelStatusData": ("04020501-0300-0000-060e-2b3401010105", 0x3d11, "04010100-0000-0000-060e-2b3401040101", True, False),
    "UserDataMode"          : ("04020501-0400-0000-060e-2b3401010105", 0x3d12, "04010b00-0000-0000-060e-2b3401040101", True, False),
    "FixedUserData"         : ("04020501-0500-0000-060e-2b3401010105", 0x3d13, "04010100-0000-0000-060e-2b3401040101", True, False),
    }
),
"PCMDescriptor"         : ("0d010101-0101-4800-060e-2b3402060101", "0d010101-0101-4200-060e-2b3402060101", True, {
    "BlockAlign"            : ("04020302-0100-0000-060e-2b3401010105", 0x3d0a, "01010200-0000-0000-060e-2b3401040101", False, False),
    "SequenceOffset"        : ("04020302-0200-0000-060e-2b3401010105", 0x3d0b, "01010100-0000-0000-060e-2b3401040101", True, False),
    "AverageBPS"            : ("04020303-0500-0000-060e-2b3401010105", 0x3d09, "01010300-0000-0000-060e-2b3401040101", False, False),
    "ChannelAssignment"     : ("04020101-0500-0000-060e-2b3401010107", 0x3d32, "01030100-0000-0000-060e-2b3401040101", True, False),
    "PeakEnvelopeVersion"   : ("04020301-0600-0000-060e-2b3401010108", 0x3d29, "01010300-0000-0000-060e-2b3401040101", True, False),
    "PeakEnvelopeFormat"    : ("04020301-0700-0000-060e-2b3401010108", 0x3d2a, "01010300-0000-0000-060e-2b3401040101", True, False),
    "PointsPerPeakValue"    : ("04020301-0800-0000-060e-2b3401010108", 0x3d2b, "01010300-0000-0000-060e-2b3401040101", True, False),
    "PeakEnvelopeBlockSize" : ("04020301-0900-0000-060e-2b3401010108", 0x3d2c, "01010300-0000-0000-060e-2b3401040101", True, False),
    "PeakChannels"          : ("04020301-0a00-0000-060e-2b3401010108", 0x3d2d, "01010300-0000-0000-060e-2b3401040101", True, False),
    "PeakFrames"            : ("04020301-0b00-0000-060e-2b3401010108", 0x3d2e, "01010300-0000-0000-060e-2b3401040101", True, False),
    "PeakOfPeaksPosition"   : ("04020301-0c00-0000-060e-2b3401010108", 0x3d2f, "01012001-0000-0000-060e-2b3401040101", True, False),
    "PeakEnvelopeTimestamp" : ("04020301-0d00-0000-060e-2b3401010108", 0x3d30, "03010700-0000-0000-060e-2b3401040101", True, False),
    "PeakEnvelopeData"      : ("04020301-0e00-0000-060e-2b3401010108", 0x3d31, "04100200-0000-0000-060e-2b3401040101", True, False),
    }
),
"PhysicalDescriptor"    : ("0d010101-0101-4900-060e-2b3402060101", "0d010101-0101-2400-060e-2b3402060101", False, {
    }
),
"ImportDescriptor"      : ("0d010101-0101-4a00-060e-2b3402060101", "0d010101-0101-4900-060e-2b3402060101", True, {
    }
),
"RecordingDescriptor"   : ("0d010101-0101-4b00-060e-2b3402060101", "0d010101-0101-4900-060e-2b3402060101", True, {
    }
),
"TaggedValueDefinition" : ("0d010101-0101-4c00-060e-2b3402060101", "0d010101-0101-1a00-060e-2b3402060101", True, {
    }
),
"KLVDataDefinition"     : ("0d010101-0101-4d00-060e-2b3402060101", "0d010101-0101-1a00-060e-2b3402060101", True, {
    "KLVDataType"           : ("06010104-0109-0000-060e-2b3401010107", 0x4d12, "05010900-0000-0000-060e-2b3401040101", True, False),
    }
),
"AuxiliaryDescriptor"   : ("0d010101-0101-4e00-060e-2b3402060101", "0d010101-0101-4900-060e-2b3402060101", True, {
    "MimeType"              : ("04090201-0000-0000-060e-2b3401010107", 0x4e11, "01100200-0000-0000-060e-2b3401040101", False, False),
    "CharSet"               : ("04090300-0000-0000-060e-2b3401010108", 0x4e12, "01100200-0000-0000-060e-2b3401040101", True, False),
    }
),
"RIFFChunk"             : ("0d010101-0101-4f00-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", True, {
    "ChunkID"               : ("04060802-0000-0000-060e-2b3401010108", 0x4f01, "01010300-0000-0000-060e-2b3401040101", False, False),
    "ChunkLength"           : ("04060903-0000-0000-060e-2b3401010108", 0x4f02, "01010300-0000-0000-060e-2b3401040101", False, False),
    "ChunkData"             : ("04070400-0000-0000-060e-2b3401010108", 0x4f03, "04100200-0000-0000-060e-2b3401040101", False, False),
    }
),
"BWFImportDescriptor"   : ("0d010101-0101-5000-060e-2b3402060101", "0d010101-0101-4a00-060e-2b3402060101", True, {
    "QltyFileSecurityReport": ("04020302-0500-0000-060e-2b3401010105", 0x3d15, "01010300-0000-0000-060e-2b3401040101", True, False),
    "QltyFileSecurityWave"  : ("04020302-0600-0000-060e-2b3401010105", 0x3d16, "01010300-0000-0000-060e-2b3401040101", True, False),
    "BextCodingHistory"     : ("04020502-0101-0000-060e-2b3401010105", 0x3d21, "01100200-0000-0000-060e-2b3401040101", True, False),
    "QltyBasicData"         : ("04020502-0201-0000-060e-2b3401010105", 0x3d22, "01100200-0000-0000-060e-2b3401040101", True, False),
    "QltyStartOfModulation" : ("04020502-0301-0000-060e-2b3401010105", 0x3d23, "01100200-0000-0000-060e-2b3401040101", True, False),
    "QltyQualityEvent"      : ("04020502-0401-0000-060e-2b3401010105", 0x3d24, "01100200-0000-0000-060e-2b3401040101", True, False),
    "QltyEndOfModulation"   : ("04020502-0501-0000-060e-2b3401010105", 0x3d25, "01100200-0000-0000-060e-2b3401040101", True, False),
    "QltyQualityParameter"  : ("04020502-0601-0000-060e-2b3401010105", 0x3d26, "01100200-0000-0000-060e-2b3401040101", True, False),
    "QltyOperatorComment"   : ("04020502-0701-0000-060e-2b3401010105", 0x3d27, "01100200-0000-0000-060e-2b3401040101", True, False),
    "QltyCueSheet"          : ("04020502-0801-0000-060e-2b3401010105", 0x3d28, "01100200-0000-0000-060e-2b3401040101", True, False),
    "UnknownBWFChunks"      : ("06010104-060f-0000-060e-2b3401010108", 0x3d33, "05060c00-0000-0000-060e-2b3401040101", True, False),
    }
),
"MPEGVideoDescriptor"   : ("0d010101-0101-5100-060e-2b3402060101", "0d010101-0101-2800-060e-2b3402060101", True, {
    "SingleSequence"        : ("04010602-0102-0000-060e-2b3401010105", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "ConstantBPictureCount" : ("04010602-0103-0000-060e-2b3401010105", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "CodedContentScanning"  : ("04010602-0104-0000-060e-2b3401010105", None, "0201012a-0000-0000-060e-2b3401040101", True, False),
    "LowDelay"              : ("04010602-0105-0000-060e-2b3401010105", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "ClosedGOP"             : ("04010602-0106-0000-060e-2b3401010105", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "IdenticalGOP"          : ("04010602-0107-0000-060e-2b3401010105", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "MaxGOP"                : ("04010602-0108-0000-060e-2b3401010105", None, "01010200-0000-0000-060e-2b3401040101", True, False),
    "MaxBPictureCount"      : ("04010602-0109-0000-060e-2b3401010105", None, "01010200-0000-0000-060e-2b3401040101", True, False),
    "BitRate"               : ("04010602-010b-0000-060e-2b3401010105", None, "01010300-0000-0000-060e-2b3401040101", True, False),
    "ProfileAndLevel"       : ("04010602-010a-0000-060e-2b3401010105", None, "01010100-0000-0000-060e-2b3401040101", True, False),
    }
),
"ClassDefinition"       : ("0d010101-0201-0000-060e-2b3402060101", "0d010101-0224-0000-060e-2b3402060101", True, {
    "ParentClass"           : ("06010107-0100-0000-060e-2b3401010102", 0x0008, "05010100-0000-0000-060e-2b3401040101", False, False),
    "Properties"            : ("06010107-0200-0000-060e-2b3401010102", 0x0009, "05050b00-0000-0000-060e-2b3401040101", True, False),
    "IsConcrete"            : ("06010107-0300-0000-060e-2b3401010102", 0x000a, "01040100-0000-0000-060e-2b3401040101", False, False),
    }
),
"PropertyDefinition"    : ("0d010101-0202-0000-060e-2b3402060101", "0d010101-0224-0000-060e-2b3402060101", True, {
    "Type"                  : ("06010107-0400-0000-060e-2b3401010102", 0x000b, "01030100-0000-0000-060e-2b3401040101", False, False),
    "IsOptional"            : ("03010202-0100-0000-060e-2b3401010102", 0x000c, "01040100-0000-0000-060e-2b3401040101", False, False),
    "LocalIdentification"   : ("06010107-0500-0000-060e-2b3401010102", 0x000d, "01010200-0000-0000-060e-2b3401040101", False, False),
    "IsUniqueIdentifier"    : ("06010107-0600-0000-060e-2b3401010102", 0x000e, "01040100-0000-0000-060e-2b3401040101", True, False),
    }
),
"TypeDefinition"        : ("0d010101-0203-0000-060e-2b3402060101", "0d010101-0224-0000-060e-2b3402060101", False, {
    }
),
"TypeDefinitionInteger" : ("0d010101-0204-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "Size"                  : ("03010203-0100-0000-060e-2b3401010102", 0x000f, "01010100-0000-0000-060e-2b3401040101", False, False),
    "IsSigned"              : ("03010203-0200-0000-060e-2b3401010102", 0x0010, "01040100-0000-0000-060e-2b3401040101", False, False),
    }
),
"TypeDefinitionStrongObjectReference" : ("0d010101-0205-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "ReferencedType"        : ("06010107-0900-0000-060e-2b3401010102", 0x0011, "05010100-0000-0000-060e-2b3401040101", False, False),
    }
),
"TypeDefinitionWeakObjectReference" : ("0d010101-0206-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "ReferencedType"        : ("06010107-0a00-0000-060e-2b3401010102", 0x0012, "05010100-0000-0000-060e-2b3401040101", False, False),
    "TargetSet"             : ("03010203-0b00-0000-060e-2b3401010102", 0x0013, "04010600-0000-0000-060e-2b3401040101", False, False),
    }
),
"TypeDefinitionEnumeration" : ("0d010101-0207-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "ElementType"           : ("06010107-0b00-0000-060e-2b3401010102", 0x0014, "05010900-0000-0000-060e-2b3401040101", False, False),
    "ElementNames"          : ("03010203-0400-0000-060e-2b3401010102", 0x0015, "04010500-0000-0000-060e-2b3401040101", False, False),
    "ElementValues"         : ("03010203-0500-0000-060e-2b3401010102", 0x0016, "04010400-0000-0000-060e-2b3401040101", False, False),
    }
),
"SubDescriptor"         : ("0d010101-0101-5900-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", False, {
    }
),
"JPEG2000SubDescriptor" : ("0d010101-0101-5a00-060e-2b3402060101", "0d010101-0101-5900-060e-2b3402060101", True, {
    "Rsiz"                  : ("04010603-0100-0000-060e-2b340101010a", None, "01010200-0000-0000-060e-2b3401040101", False, False),
    "Xsiz"                  : ("04010603-0200-0000-060e-2b340101010a", None, "01010300-0000-0000-060e-2b3401040101", False, False),
    "Ysiz"                  : ("04010603-0300-0000-060e-2b340101010a", None, "01010300-0000-0000-060e-2b3401040101", False, False),
    "XOsiz"                 : ("04010603-0400-0000-060e-2b340101010a", None, "01010300-0000-0000-060e-2b3401040101", False, False),
    "YOsiz"                 : ("04010603-0500-0000-060e-2b340101010a", None, "01010300-0000-0000-060e-2b3401040101", False, False),
    "XTsiz"                 : ("04010603-0600-0000-060e-2b340101010a", None, "01010300-0000-0000-060e-2b3401040101", False, False),
    "YTsiz"                 : ("04010603-0700-0000-060e-2b340101010a", None, "01010300-0000-0000-060e-2b3401040101", False, False),
    "XTOsiz"                : ("04010603-0800-0000-060e-2b340101010a", None, "01010300-0000-0000-060e-2b3401040101", False, False),
    "YTOsiz"                : ("04010603-0900-0000-060e-2b340101010a", None, "01010300-0000-0000-060e-2b3401040101", False, False),
    "Csiz"                  : ("04010603-0a00-0000-060e-2b340101010a", None, "01010200-0000-0000-060e-2b3401040101", False, False),
    "PictureComponentSizing": ("04010603-0b00-0000-060e-2b340101010a", None, "04010100-0000-0000-060e-2b3401040101", False, False),
    "CodingStyleDefault"    : ("04010603-0c00-0000-060e-2b340101010a", None, "04100100-0000-0000-060e-2b3401040101", True, False),
    "QuantizationDefault"   : ("04010603-0d00-0000-060e-2b340101010a", None, "04100100-0000-0000-060e-2b3401040101", True, False),
    "J2CLayout"             : ("04010603-0e00-0000-060e-2b340101010e", None, "04020100-0000-0000-060e-2b3401040101", True, False),
    }
),
"VBIDataDescriptor"     : ("0d010101-0101-5b00-060e-2b3402060101", "0d010101-0101-4300-060e-2b3402060101", True, {
    }
),
"ANCDataDescriptor"     : ("0d010101-0101-5c00-060e-2b3402060101", "0d010101-0101-4300-060e-2b3402060101", True, {
    }
),
"ContainerConstraintsSubDescriptor" : ("0d010101-0101-6700-060e-2b3402060101", "0d010101-0101-5900-060e-2b3402060101", True, {
    }
),
"MPEG4VisualSubDescriptor" : ("0d010101-0101-6800-060e-2b3402060101", "0d010101-0101-5900-060e-2b3402060101", True, {
    "MPEG4VisualSingleSequence": ("04010602-0202-0000-060e-2b340101010d", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "MPEG4VisualConstantBVOPs": ("04010602-0203-0000-060e-2b340101010d", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "MPEG4VisualCodedContentType": ("04010602-0204-0000-060e-2b340101010d", None, "0201012d-0000-0000-060e-2b3401040101", True, False),
    "MPEG4VisualLowDelay"   : ("04010602-0205-0000-060e-2b340101010d", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "MPEG4VisualClosedGOV"  : ("04010602-0206-0000-060e-2b340101010d", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "MPEG4VisualIdenticalGOV": ("04010602-0207-0000-060e-2b340101010d", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "MPEG4VisualMaxGOV"     : ("04010602-0208-0000-060e-2b340101010d", None, "01010200-0000-0000-060e-2b3401040101", True, False),
    "MPEG4VisualBVOPCount"  : ("04010602-0209-0000-060e-2b340101010d", None, "01010200-0000-0000-060e-2b3401040101", True, False),
    "MPEG4VisualProfileAndLevel": ("04010602-020a-0000-060e-2b340101010d", None, "01010100-0000-0000-060e-2b3401040101", True, False),
    "MPEG4VisualBitRate"    : ("04010602-020b-0000-060e-2b340101010d", None, "01010300-0000-0000-060e-2b3401040101", True, False),
    }
),
"MCALabelSubDescriptor" : ("0d010101-0101-6a00-060e-2b3402060101", "0d010101-0101-5900-060e-2b3402060101", False, {
    "MCALabelDictionaryID"  : ("01030701-0100-0000-060e-2b340101010e", None, "01030100-0000-0000-060e-2b3401040101", False, False),
    "MCALinkID"             : ("01030701-0500-0000-060e-2b340101010e", None, "01030300-0000-0000-060e-2b3401040101", False, False),
    "MCATagSymbol"          : ("01030701-0200-0000-060e-2b340101010e", None, "01100200-0000-0000-060e-2b3401040101", False, False),
    "MCATagName"            : ("01030701-0300-0000-060e-2b340101010e", None, "01100200-0000-0000-060e-2b3401040101", True, False),
    "MCAChannelID"          : ("0103040a-0000-0000-060e-2b340101010e", None, "01010300-0000-0000-060e-2b3401040101", True, False),
    "RFC5646SpokenLanguage" : ("03010102-0315-0000-060e-2b340101010d", None, "01100400-0000-0000-060e-2b3401040101", True, False),
    "MCATitle"              : ("01051000-0000-0000-060e-2b340101010e", None, "01100200-0000-0000-060e-2b3401040101", True, False),
    "MCATitleVersion"       : ("01051100-0000-0000-060e-2b340101010e", None, "01100200-0000-0000-060e-2b3401040101", True, False),
    "MCATitleSubVersion"    : ("01051200-0000-0000-060e-2b340101010e", None, "01100200-0000-0000-060e-2b3401040101", True, False),
    "MCAEpisode"            : ("01051300-0000-0000-060e-2b340101010e", None, "01100200-0000-0000-060e-2b3401040101", True, False),
    "MCAPartitionKind"      : ("01040105-0000-0000-060e-2b340101010e", None, "01100200-0000-0000-060e-2b3401040101", True, False),
    "MCAPartitionNumber"    : ("01040106-0000-0000-060e-2b340101010e", None, "01100200-0000-0000-060e-2b3401040101", True, False),
    "MCAAudioContentKind"   : ("03020102-2000-0000-060e-2b340101010e", None, "01100200-0000-0000-060e-2b3401040101", True, False),
    "MCAAudioElementKind"   : ("03020102-2100-0000-060e-2b340101010e", None, "01100200-0000-0000-060e-2b3401040101", True, False),
    }
),
"AudioChannelLabelSubDescriptor" : ("0d010101-0101-6b00-060e-2b3402060101", "0d010101-0101-6a00-060e-2b3402060101", True, {
    "SoundfieldGroupLinkID" : ("01030701-0600-0000-060e-2b340101010e", None, "01030300-0000-0000-060e-2b3401040101", True, False),
    }
),
"SoundfieldGroupLabelSubDescriptor" : ("0d010101-0101-6c00-060e-2b3402060101", "0d010101-0101-6a00-060e-2b3402060101", True, {
    "GroupOfSoundfieldGroupsLinkID": ("01030701-0400-0000-060e-2b340101010e", None, "04011500-0000-0000-060e-2b3401040101", True, False),
    }
),
"GroupOfSoundfieldGroupsLabelSubDescriptor" : ("0d010101-0101-6d00-060e-2b3402060101", "0d010101-0101-6a00-060e-2b3402060101", True, {
    }
),
"AVCSubDescriptor"      : ("0d010101-0101-6e00-060e-2b3402060101", "0d010101-0101-5900-060e-2b3402060101", True, {
    "AVCConstantBPictureFlag": ("04010606-0103-0000-060e-2b340101010e", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "AVCCodedContentKind"   : ("04010606-0104-0000-060e-2b340101010e", None, "0201012c-0000-0000-060e-2b3401040101", True, False),
    "AVCClosedGOPIndicator" : ("04010606-0106-0000-060e-2b340101010e", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "AVCIdenticalGOPIndicator": ("04010606-0107-0000-060e-2b340101010e", None, "01040100-0000-0000-060e-2b3401040101", True, False),
    "AVCMaximumGOPSize"     : ("04010606-0108-0000-060e-2b340101010e", None, "01010200-0000-0000-060e-2b3401040101", True, False),
    "AVCMaximumBPictureCount": ("04010606-0109-0000-060e-2b340101010e", None, "01010200-0000-0000-060e-2b3401040101", True, False),
    "AVCProfile"            : ("04010606-010a-0000-060e-2b340101010e", None, "01010100-0000-0000-060e-2b3401040101", True, False),
    "AVCMaximumBitRate"     : ("04010606-010b-0000-060e-2b340101010e", None, "01010300-0000-0000-060e-2b3401040101", True, False),
    "AVCProfileConstraint"  : ("04010606-010c-0000-060e-2b340101010e", None, "01010100-0000-0000-060e-2b3401040101", True, False),
    "AVCLevel"              : ("04010606-010d-0000-060e-2b340101010e", None, "01010100-0000-0000-060e-2b3401040101", True, False),
    "AVCDecodingDelay"      : ("04010606-010e-0000-060e-2b340101010e", None, "01010100-0000-0000-060e-2b3401040101", False, False),
    "AVCMaximumRefFrames"   : ("04010606-010f-0000-060e-2b340101010e", None, "01010100-0000-0000-060e-2b3401040101", True, False),
    "AVCSequenceParameterSetFlag": ("04010606-0110-0000-060e-2b340101010e", None, "01010100-0000-0000-060e-2b3401040101", True, False),
    "AVCPictureParameterSetFlag": ("04010606-0111-0000-060e-2b340101010e", None, "01010100-0000-0000-060e-2b3401040101", True, False),
    "AVCAverageBitRate"     : ("04010606-0114-0000-060e-2b340101010e", None, "01010300-0000-0000-060e-2b3401040101", True, False),
    }
),
"MPEGAudioDescriptor"   : ("0d010101-0101-5e00-060e-2b3402060101", "0d010101-0101-4200-060e-2b3402060101", True, {
    "MPEGAudioBitRate"      : ("04020403-0102-0000-060e-2b340101010a", None, "01010300-0000-0000-060e-2b3401040101", True, False),
    }
),
"TypeDefinitionFixedArray" : ("0d010101-0208-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "ElementType"           : ("06010107-0c00-0000-060e-2b3401010102", 0x0017, "05010900-0000-0000-060e-2b3401040101", False, False),
    "ElementCount"          : ("03010203-0300-0000-060e-2b3401010102", 0x0018, "01010300-0000-0000-060e-2b3401040101", False, False),
    }
),
"TypeDefinitionVariableArray" : ("0d010101-0209-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "ElementType"           : ("06010107-0d00-0000-060e-2b3401010102", 0x0019, "05010900-0000-0000-060e-2b3401040101", False, False),
    }
),
"TypeDefinitionSet"     : ("0d010101-020a-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "ElementType"           : ("06010107-0e00-0000-060e-2b3401010102", 0x001a, "05010900-0000-0000-060e-2b3401040101", False, False),
    }
),
"TypeDefinitionString"  : ("0d010101-020b-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "ElementType"           : ("06010107-0f00-0000-060e-2b3401010102", 0x001b, "05010900-0000-0000-060e-2b3401040101", False, False),
    }
),
"TypeDefinitionStream"  : ("0d010101-020c-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    }
),
"TypeDefinitionRecord"  : ("0d010101-020d-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "MemberTypes"           : ("06010107-1100-0000-060e-2b3401010102", 0x001c, "05040200-0000-0000-060e-2b3401040101", False, False),
    "MemberNames"           : ("03010203-0600-0000-060e-2b3401010102", 0x001d, "04010500-0000-0000-060e-2b3401040101", False, False),
    }
),
"TypeDefinitionRename"  : ("0d010101-020e-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "RenamedType"           : ("06010107-1200-0000-060e-2b3401010102", 0x001e, "05010900-0000-0000-060e-2b3401040101", False, False),
    }
),
"TypeDefinitionExtendibleEnumeration" : ("0d010101-0220-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "ElementNames"          : ("03010203-0700-0000-060e-2b3401010102", 0x001f, "04010500-0000-0000-060e-2b3401040101", False, False),
    "ElementValues"         : ("03010203-0800-0000-060e-2b3401010102", 0x0020, "04010600-0000-0000-060e-2b3401040101", False, False),
    }
),
"TypeDefinitionIndirect" : ("0d010101-0221-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    }
),
"TypeDefinitionOpaque"  : ("0d010101-0222-0000-060e-2b3402060101", "0d010101-0221-0000-060e-2b3402060101", True, {
    }
),
"TypeDefinitionCharacter" : ("0d010101-0223-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    }
),
"TypeDefinitionGenericCharacter" : ("0e040101-0000-0000-060e-2b3402060101", "0d010101-0203-0000-060e-2b3402060101", True, {
    "CharacterSize"         : ("0e040101-0101-0111-060e-2b3401010101", None, "01010100-0000-0000-060e-2b3401040101", False, False),
    }
),
"MetaDefinition"        : ("0d010101-0224-0000-060e-2b3402060101", None, False, {
    "Identification"        : ("06010107-1300-0000-060e-2b3401010102", 0x0005, "01030100-0000-0000-060e-2b3401040101", False, True),
    "Name"                  : ("03020401-0201-0000-060e-2b3401010102", 0x0006, "01100200-0000-0000-060e-2b3401040101", False, False),
    "Description"           : ("06010107-1401-0000-060e-2b3401010102", 0x0007, "01100200-0000-0000-060e-2b3401040101", True, False),
    }
),
"MetaDictionary"        : ("0d010101-0225-0000-060e-2b3402060101", None, True, {
    "ClassDefinitions"      : ("06010107-0700-0000-060e-2b3401010102", 0x0003, "05050100-0000-0000-060e-2b3401040101", True, False),
    "TypeDefinitions"       : ("06010107-0800-0000-060e-2b3401010102", 0x0004, "05050c00-0000-0000-060e-2b3401040101", True, False),
    }
),
"DescriptiveObject"     : ("0d010400-0000-0000-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", False, {
    }
),
"DescriptiveFramework"  : ("0d010401-0000-0000-060e-2b3402060101", "0d010101-0101-0100-060e-2b3402060101", False, {
    }
)}

aliases = {
"ClassDef"               : "ClassDefinition",
"CodecDef"               : "CodecDefinition",
"DataDef"                : "DataDefinition",
"DefObject"              : "DefinitionObject",
"Edgecode"               : "EdgeCode",
"OperationDef"           : "OperationDefinition",
"Object"                 : "InterchangeObject",
"ParameterDef"           : "ParameterDefinition",
"InterpolationDef"       : "InterpolationDefinition",
"PropertyDef"            : "PropertyDefinition",
"TypeDef"                : "TypeDefinition",
"TypeDefCharacter"       : "TypeDefinitionCharacter",
"TypeDefEnum"            : "TypeDefinitionEnumeration",
"TypeDefExtEnum"         : "TypeDefinitionExtendibleEnumeration",
"TypeDefFixedArray"      : "TypeDefinitionFixedArray",
"TypeDefInt"             : "TypeDefinitionInteger",
"TypeDefRecord"          : "TypeDefinitionRecord",
"TypeDefRename"          : "TypeDefinitionRename",
"TypeDefSet"             : "TypeDefinitionSet",
"TypeDefStream"          : "TypeDefinitionStream",
"TypeDefString"          : "TypeDefinitionString",
"TypeDefIndirect"        : "TypeDefinitionIndirect",
"TypeDefOpaque"          : "TypeDefinitionOpaque",
"TypeDefStrongObjRef"    : "TypeDefinitionStrongObjectReference",
"TypeDefVariableArray"   : "TypeDefinitionVariableArray",
"TypeDefWeakObjRef"      : "TypeDefinitionWeakObjectReference",
"ContainerDef"           : "ContainerDefinition",
"PluginDef"              : "PluginDefinition",
"AvidTypeDefinitionGenericCharacter" : "TypeDefinitionGenericCharacter",
"TaggedValueDef"         : "TaggedValueDefinition",
"TypeDefGenericCharacter": "TypeDefinitionGenericCharacter",
}
