"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateDataLength = void 0;
var layerr_1 = require("layerr");
var arrayBuffer_1 = require("../compat/arrayBuffer");
var buffer_1 = require("../compat/buffer");
var types_1 = require("../types");
function calculateDataLength(data) {
    if ((0, arrayBuffer_1.isArrayBuffer)(data)) {
        return data.byteLength;
    }
    else if ((0, buffer_1.isBuffer)(data)) {
        return data.length;
    }
    else if (typeof data === "string") {
        return data.length;
    }
    throw new layerr_1.Layerr({
        info: {
            code: types_1.ErrorCode.DataTypeNoLength
        }
    }, "Cannot calculate data length: Invalid type");
}
exports.calculateDataLength = calculateDataLength;
