# Focusrite Scarlett Interface Features by Model

The information here was compiled carefully and is believed accurate
but there might still be mistakes. Please independently confirm before
relying on anything here.

## 6i6 Gen 2

- 6× Hardware Inputs
  - Analogue In 1–2: Mic/Line/Inst In 1–2 (Pad)
  - Analogue In 3–4: Line In 3–4
  - S/PDIF 1–2

- Hardware Input Controls
  - 2× Input Gain knobs for Analogue In 1–2
  - Fixed Input Gain for Analogue In 3–4
  - Phantom Power for Analogue 1–2 linked

- 6× Hardware Outputs
  - Analogue 1: Line 1 Out (Monitor L) + Headphone 1 Left
  - Analogue 2: Line 2 Out (Monitor R) + Headphone 1 Right
  - Analogue 3: Line 3 Out + Headphone 2 Left
  - Analogue 4: Line 4 Out + Headphone 2 Right
  - S/PDIF 1–2

- Hardware Output Controls
  - Monitor volume knob controlling Line 1+2
  - No physical control for Line 3+4 output volume
  - Headphone 1 volume knob controlling Headphone 1 Volume
  - Headphone 2 volume knob controlling Headphone 2 Volume
  - 4× Mute + Line Out Gain controls −127dB to 0dB
    - 1–2 control Line 1–2 Out and Headphone 1
    - 3–4 control Line 3–4 Out and Headphone 2

- Mixer: 18 input (1–18), 10 output (A–J)
  - 18×10 gain controls −80dB to +6dB
  - Each input assignable to any of the assignable outputs

- 6× PCM Inputs (USB device to host)

- 6× PCM Outputs (USB host to device)

- Assignable outputs to the hardware outputs, mixer, and PCM Inputs:
  - Off, Analogue Inputs 1–4, S/PDIF 1–2, Mix A–J, PCM Outputs 1–6

- Sync Status

- Clock Source: Internal or S/PDIF

## 18i8 Gen 2

- 18× Hardware Inputs
  - Analogue 1–2: Mic/Line/Inst In 1–2 (Pad)
  - Analogue 3–4: Mic/Line In 3–4 (Pad)
  - Analogue 5–8: Line In 5–8
  - S/PDIF 1–2
  - ADAT 1–8

- Hardware Input Controls
  - 4× Input Gain knobs for Analogue In 1–4
  - Fixed Input Gain for Analogue In 5–8
  - Phantom Power for Analogue 1–2 linked
  - Phantom Power for Analogue 3–4 linked

- 8× Hardware Outputs
  - Analogue 1: Line 1 Out (Monitor L)
  - Analogue 2: Line 2 Out (Monitor R)
  - Analogue 3: Headphone 1 Left
  - Analogue 4: Headphone 1 Right
  - Analogue 5: Headphone 2 Left
  - Analogue 6: Headphone 2 Right
  - S/PDIF 1–2

- Hardware Output Controls
  - Monitor volume knob controlling Line 1+2
  - Headphone 1 volume knob controlling Headphone 1 Volume
  - Headphone 2 volume knob controlling Headphone 2 Volume
  - 6× Mute + Line Out Gain controls −127dB to 0dB
    - 1–2 control Line 1–2 Out
    - 3–4 control Headphone 1
    - 5–6 control Headphone 2

- Mixer: 20 input (1–20), 10 output (A–J)
  - 20×10 gain controls −80dB to +6dB
  - Each input assignable to any of the assignable outputs

- 20× PCM Inputs (USB device to host)

- 8× PCM Outputs (USB host to device)

- Assignable outputs to the hardware outputs, mixer, and PCM Inputs:
  - Off, Analogue Inputs 1–8, S/PDIF 1–2, ADAT 1–8, Mix A–J, PCM
    Outputs 1–8

- Sync Status

- Clock Source: Internal, S/PDIF, or ADAT

## 18i20 Gen 2

- 18× Hardware Inputs
  - Analogue 1–2: Mic/Line/Inst In 1–2 (Pad)
  - Analogue 3–8: Mic/Line In 3–8
  - S/PDIF 1–2
  - ADAT 1–8

- Hardware Input Controls
  - 8× Input Gain knobs for Analogue In 1–8
  - Phantom Power for Analogue 1–4 linked
  - Phantom Power for Analogue 5–8 linked

- 20× Hardware Outputs
  - Analogue  1: Line  1 Out (Monitor L)
  - Analogue  2: Line  2 Out (Monitor R)
  - Analogue  3: Line  3 Out
  - Analogue  4: Line  4 Out
  - Analogue  5: Line  5 Out
  - Analogue  6: Line  6 Out
  - Analogue  7: Line  7 Out + Headphone 1 Left
  - Analogue  8: Line  8 Out + Headphone 1 Right
  - Analogue  9: Line  9 Out + Headphone 2 Left
  - Analogue 10: Line 10 Out + Headphone 2 Right
  - S/PDIF 1–2
  - ADAT 1–8

- Hardware Output Controls
  - For Analogue 1–8 Outputs:
    - 8× SW/HW Volume Control Switch
    - 8× SW Line Out Gain controls −127dB to 0dB
    - 8× SW Mute
  - Monitor volume knob controlling volume of Analogue 1–8 (selected
    by SW/HW Volume Control Switches)
  - Global Mute and Dim controlling Analogue 1–8 (enabled per-channel
    if SW/HW Volume Control Switch set to HW)
  - 2× Headphone volume knob controlling Headphone volume (applied in
    addition to the SW/HW Volume Control)

- Mixer: 20 input (1–20), 10 output (A–J)
  - 20×10 gain controls −80dB to +6dB
  - Each input assignable to any of the assignable outputs

- 20× PCM Inputs (USB device to host)

- 18× PCM Outputs (USB host to device)

- Assignable outputs to the hardware outputs, mixer, and PCM Inputs:
  - Off, Analogue Inputs 1–8, S/PDIF 1–2, ADAT 1–8, Mix A–J, PCM
    Outputs 1–8

- Sync Status

- Clock Source: Internal, S/PDIF, or ADAT

## Solo Gen 3

- 2× Hardware Inputs
  - Analogue In 1: Mic In (Air, Phantom Power)
  - Analogue In 2: Line/Inst In

- Hardware Input Controls
  - 2× Input Gain knobs for Analogue 1–2
  - Phantom Power Persistence

- 2× Hardware Outputs
  - Analogue Out 1: Line Out Left + Headphone Left
  - Analogue Out 2: Line Out Right + Headphone Right

- Hardware Output Controls
  - Monitor volume knob controls all outputs together

- 2× PCM Inputs (USB device to host)
  - Fixed to Analogue Inputs 1–2

- 2× PCM Outputs (USB host to device)
  - Fixed to Analogue Outputs 1–2

- Direct Monitor:
  - On: mixes Analogue 1+2 Inputs into both Analogue 1+2 Outputs

## 2i2 Gen 3

- 2× Hardware Inputs
  - Analogue In 1–2: Mic/Line/Inst In 1–2 (Air)

- Hardware Input Controls
  - 2× Input Gain knobs for Analogue 1–2
  - Phantom Power for Analogue 1–2 linked
  - Phantom Power Persistence

- 2× Hardware Outputs
  - Analogue Out 1: Line Out Left + Headphone Left
  - Analogue Out 2: Line Out Right + Headphone Right

- Hardware Output Controls
  - Monitor volume knob for Line Out Left and Right
  - Headphone volume knob for Headphone

- 2× PCM Inputs (USB device to host)
  - Fixed to Analogue Inputs 1–2

- 2× PCM Outputs (USB host to device)
  - Fixed to Analogue Outputs 1–2

- Direct Monitor:
  - Mono: mixes both Analogue 1+2 Inputs into both Analogue 1+2
    Outputs
  - Stereo: mixes Analogue 1+2 Inputs into Analogue 1+2 Outputs
    respectively

## 4i4 Gen 3

- 4× Hardware Inputs
  - Analogue In 1–2: Mic/Line/Inst In 1–2 (Air, Pad)
  - Analogue In 3–4: Line In 3–4

- Hardware Input Controls
  - 2× Input Gain knobs for Analogue In 1–2
  - Fixed Input Gain for Analogue In 3–4
  - Phantom Power for Analogue 1–2 linked
  - Phantom Power Persistence

- 4× Hardware Outputs
  - Analogue 1: Line 1 Out (Monitor L)
  - Analogue 2: Line 2 Out (Monitor R)
  - Analogue 3: Line 3 Out + Headphone Left
  - Analogue 4: Line 4 Out + Headphone Right

- Hardware Output Controls
  - Monitor volume knob controlling Line 1+2
  - Headphone volume knob controlling Headphone volume
  - No physical control for Line 3+4 output volume
  - 4× Mute + Line Out Gain controls −127dB to 0dB
    - 1–2 control Line 1–2 Out
    - 3–4 control Line 3–4 Out and Headphone

- Mixer: 8 input (1–8), 6 output (A–F)
  - 8×6 gain controls −80dB to +6dB
  - Each input assignable to any of the assignable outputs

- 6× PCM Inputs (USB device to host)

- 4× PCM Outputs (USB host to device)

- Assignable outputs to the hardware outputs, mixer, and PCM Inputs:
  - Off, Analogue Inputs 1–4, Mix A–F, PCM Outputs 1–4

- Sync Status

## 8i6 Gen 3

- 8× Hardware Inputs
  - Analogue 1–2: Mic/Line/Inst In 1–2 (Air, Pad)
  - Analogue 3–6: Line In 3–6
  - S/PDIF 1–2

- Hardware Input Controls
  - 2× Input Gain knobs for Analogue In 1–2
  - Fixed Input Gain for Analogue In 3–6
  - Phantom Power for Analogue 1–2 linked
  - Phantom Power Persistence

- 6× Hardware Outputs
  - Analogue 1: Line 1 Out (Monitor L) + Headphone 1 Left
  - Analogue 2: Line 2 Out (Monitor R) + Headphone 1 Right
  - Analogue 3: Line 3 Out + Headphone 2 Left
  - Analogue 4: Line 4 Out + Headphone 2 Right
  - S/PDIF 1–2

- Hardware Output Controls
  - Monitor volume knob controlling Line 1+2
  - No physical control for Line 3+4 output volume
  - Headphone 1 volume knob controlling Headphone 1 Volume
  - Headphone 2 volume knob controlling Headphone 2 Volume
  - 4× Line Out Gain controls −127dB to 0dB
    - 1–2 control Line 1–2 Out and Headphone 1
    - 3–4 control Line 3–4 Out and Headphone 2

- Mixer: 8 input (1–8), 8 output (A–H)
  - 8×8 gain controls −80dB to +6dB
  - Each input assignable to any of the assignable outputs

- 10× PCM Inputs (USB device to host)

- 6× PCM Outputs (USB host to device)

- Assignable outputs to the hardware outputs, mixer, and PCM Inputs:
  - Off, Analogue Inputs 1–6, S/PDIF 1–2, Mix A–H, PCM Outputs 1–6

- Sync Status

- Clock Source: Internal or S/PDIF

## 18i8 Gen 3

- 18× Hardware Inputs
  - Analogue 1–2: Mic/Line/Inst In 1–2 (Air, Pad)
  - Analogue 3–4: Mic/Line In 3–4 (Air, Pad)
  - Analogue 5–8: Line In 5–8
  - S/PDIF 1–2
  - ADAT 1–8

- Hardware Input Controls
  - 4× Input Gain knobs for Analogue In 1–4
  - Fixed Input Gain for Analogue In 5–8
  - Phantom Power for Analogue 1–2 linked
  - Phantom Power for Analogue 3–4 linked
  - Phantom Power Persistence

- 10× Hardware Outputs
  - Analogue 1: Line 1 Out (Monitor L)
  - Analogue 2: Line 2 Out (Monitor R)
  - Analogue 3: Line 3 Out (Alt Monitor L)
  - Analogue 4: Line 4 Out (Alt Monitor R)
  - Analogue 5: Headphone 1 Left
  - Analogue 6: Headphone 1 Right
  - Analogue 7: Headphone 2 Left
  - Analogue 8: Headphone 2 Right
  - S/PDIF 1–2

Note: The Headphones outputs are internally Analogue 3–6 and the rear
Line 3/4 outputs (Alt Monitor) are internally Analogue 7/8, but the
driver hides this from you.

- Hardware Output Controls
  - For Analogue 1–8 Outputs:
    - 8× SW/HW Volume Control Switch
    - 8× SW Line Out Gain controls −127dB to 0dB
    - 8× SW Mute
  - Monitor volume knob controlling volume of Analogue 1–8 (selected
    by SW/HW Volume Control Switches)
  - Global mute and dim controlling Analogue 1–8 (enabled per-channel
    if SW/HW Volume Control Switch set to HW)
  - 2× Headphone volume knob controlling Headphone volume (applied in
    addition to the SW/HW Volume Control)

- Mixer: 18 input (1–18), 10 output (A–J)
  - 18×10 gain controls −80dB to +6dB
  - Each input assignable to any of the assignable outputs

- 18× PCM Inputs (USB device to host)

- 8× PCM Outputs (USB host to device)

- Assignable outputs to the hardware outputs, mixer, and PCM Inputs:
  - Off, Analogue Inputs 1–8, S/PDIF 1–2, ADAT 1–8, Mix A–J, PCM
    Outputs 1–20

- Speaker Switching

- Sync Status

- Clock Source: Internal, S/PDIF, or ADAT

## 18i20 Gen 3

- 19× Hardware Inputs
  - Analogue 1–2: Mic/Line/Inst In 1–2 (Air, Pad)
  - Analogue 3–8: Mic/Line In 3–4 (Air, Pad)
  - Analogue 9: Talkback Mic
  - S/PDIF 1–2
  - ADAT 1–8

- Hardware Input Controls
  - 8× Input Gain knobs for Analogue In 1–8
  - Phantom Power for Analogue 1–4 linked
  - Phantom Power for Analogue 5–8 linked
  - Phantom Power Persistence

- 20× Hardware Outputs
  - Analogue  1: Line  1 Out (Monitor L)
  - Analogue  2: Line  2 Out (Monitor R)
  - Analogue  3: Line  3 Out
  - Analogue  4: Line  4 Out
  - Analogue  5: Line  5 Out
  - Analogue  6: Line  6 Out
  - Analogue  7: Line  7 Out + Headphone 1 Left
  - Analogue  8: Line  8 Out + Headphone 1 Right
  - Analogue  9: Line  9 Out + Headphone 2 Left
  - Analogue 10: Line 10 Out + Headphone 2 Right
  - S/PDIF 1–2
  - ADAT 1–8

- Hardware Output Controls
  - For Analogue 1–8 Outputs:
    - 8× SW/HW Volume Control Switch
    - 8× SW Line Out Gain controls −127dB to 0dB
    - 8× SW Mute
  - Monitor volume knob controlling volume of Analogue 1–8 (selected
    by SW/HW Volume Control Switches)
  - Global Mute and Dim controlling Analogue 1–8 (enabled per-channel
    if SW/HW Volume Control Switch set to HW)
  - 2× Headphone volume knob controlling Headphone volume (applied in
    addition to the SW/HW Volume Control)

- Mixer: 25 input (1–25), 12 output (A–L)
  - 25×12 gain controls −80dB to +6dB
  - Each input assignable to any of the assignable outputs

- 20× PCM Inputs (USB device to host)

- 20× PCM Outputs (USB host to device)

- Assignable outputs to the hardware outputs, mixer, and PCM Inputs:
  - Off, Analogue Inputs 1–8, S/PDIF 1–2, ADAT 1–8, Mix A–L, PCM
    Outputs 1–8

- Speaker Switching

- Talkback Mic

- Sync Status

- Clock Source: Internal, S/PDIF, or ADAT
