%% Generated by the Erlang ASN.1 PER (aligned) compiler. Version: 5.0.21
%% Purpose: Encoding and decoding of the types in megaco_per_media_gateway_control_v1.

-module('megaco_per_media_gateway_control_v1').
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("megaco_per_media_gateway_control_v1.hrl").
-asn1_info([{vsn,'5.0.21'},
            {module,'megaco_per_media_gateway_control_v1'},
            {options,[warnings,per,errors,
 {cwd,"/build/erlang/src/otp/lib/megaco/src/binary"},
 {outdir,"/build/erlang/src/otp/lib/megaco/src/binary"},
 noobj,legacy_erlang_types,
 {i,"."},
 {i,"/build/erlang/src/otp/lib/megaco/src/binary"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_Value/1,
enc_TimeNotation/1,
enc_H221NonStandard/1,
enc_NonStandardIdentifier/1,
enc_NonStandardData/1,
enc_StatisticsParameter/1,
enc_StatisticsDescriptor/1,
enc_PackagesItem/1,
enc_PackagesDescriptor/1,
enc_ServiceChangeProfile/1,
enc_ServiceChangeMethod/1,
enc_ServiceChangeResParm/1,
enc_ServiceChangeAddress/1,
enc_ServiceChangeParm/1,
enc_DigitMapValue/1,
enc_DigitMapName/1,
enc_DigitMapDescriptor/1,
enc_ModemType/1,
enc_ModemDescriptor/1,
enc_RequestID/1,
enc_SigParameter/1,
enc_NotifyCompletion/1,
enc_SignalName/1,
enc_SignalType/1,
enc_Signal/1,
enc_SeqSigList/1,
enc_SignalRequest/1,
enc_SignalsDescriptor/1,
enc_EventSpec/1,
enc_EventBufferDescriptor/1,
enc_SecondRequestedActions/1,
enc_SecondRequestedEvent/1,
enc_SecondEventsDescriptor/1,
enc_EventDM/1,
enc_RequestedActions/1,
enc_RequestedEvent/1,
enc_EventsDescriptor/1,
enc_StreamID/1,
enc_MuxType/1,
enc_MuxDescriptor/1,
enc_ServiceState/1,
enc_EventBufferControl/1,
enc_TerminationStateDescriptor/1,
enc_PropertyGroup/1,
enc_LocalRemoteDescriptor/1,
enc_Relation/1,
enc_PkgdName/1,
enc_Name/1,
enc_PropertyParm/1,
enc_StreamMode/1,
enc_LocalControlDescriptor/1,
enc_StreamParms/1,
enc_StreamDescriptor/1,
enc_MediaDescriptor/1,
enc_TerminationIDList/1,
enc_TerminationID/1,
enc_WildcardField/1,
enc_ServiceChangeResult/1,
enc_ServiceChangeReply/1,
enc_ServiceChangeRequest/1,
enc_EventParameter/1,
enc_EventName/1,
enc_ObservedEvent/1,
enc_ObservedEventsDescriptor/1,
enc_NotifyReply/1,
enc_NotifyRequest/1,
enc_AuditDescriptor/1,
enc_AuditReturnParameter/1,
enc_TerminationAudit/1,
enc_AuditResult/1,
enc_AuditReply/1,
enc_AuditRequest/1,
enc_SubtractRequest/1,
enc_AmmsReply/1,
enc_AmmDescriptor/1,
enc_AmmRequest/1,
enc_TopologyRequest/1,
enc_CommandReply/1,
enc_Command/1,
enc_CommandRequest/1,
enc_ContextAttrAuditRequest/1,
enc_ContextRequest/1,
enc_ActionReply/1,
enc_ActionRequest/1,
enc_ContextID/1,
enc_ErrorText/1,
enc_ErrorCode/1,
enc_ErrorDescriptor/1,
enc_TransactionAck/1,
enc_TransactionResponseAck/1,
enc_TransactionReply/1,
enc_TransactionPending/1,
enc_TransactionRequest/1,
enc_TransactionId/1,
enc_Transaction/1,
enc_PathName/1,
enc_IP6Address/1,
enc_IP4Address/1,
enc_DomainName/1,
enc_MId/1,
enc_Message/1,
enc_AuthData/1,
enc_SequenceNum/1,
enc_SecurityParmIndex/1,
enc_AuthenticationHeader/1,
enc_MegacoMessage/1
]).

-export([
dec_Value/1,
dec_TimeNotation/1,
dec_H221NonStandard/1,
dec_NonStandardIdentifier/1,
dec_NonStandardData/1,
dec_StatisticsParameter/1,
dec_StatisticsDescriptor/1,
dec_PackagesItem/1,
dec_PackagesDescriptor/1,
dec_ServiceChangeProfile/1,
dec_ServiceChangeMethod/1,
dec_ServiceChangeResParm/1,
dec_ServiceChangeAddress/1,
dec_ServiceChangeParm/1,
dec_DigitMapValue/1,
dec_DigitMapName/1,
dec_DigitMapDescriptor/1,
dec_ModemType/1,
dec_ModemDescriptor/1,
dec_RequestID/1,
dec_SigParameter/1,
dec_NotifyCompletion/1,
dec_SignalName/1,
dec_SignalType/1,
dec_Signal/1,
dec_SeqSigList/1,
dec_SignalRequest/1,
dec_SignalsDescriptor/1,
dec_EventSpec/1,
dec_EventBufferDescriptor/1,
dec_SecondRequestedActions/1,
dec_SecondRequestedEvent/1,
dec_SecondEventsDescriptor/1,
dec_EventDM/1,
dec_RequestedActions/1,
dec_RequestedEvent/1,
dec_EventsDescriptor/1,
dec_StreamID/1,
dec_MuxType/1,
dec_MuxDescriptor/1,
dec_ServiceState/1,
dec_EventBufferControl/1,
dec_TerminationStateDescriptor/1,
dec_PropertyGroup/1,
dec_LocalRemoteDescriptor/1,
dec_Relation/1,
dec_PkgdName/1,
dec_Name/1,
dec_PropertyParm/1,
dec_StreamMode/1,
dec_LocalControlDescriptor/1,
dec_StreamParms/1,
dec_StreamDescriptor/1,
dec_MediaDescriptor/1,
dec_TerminationIDList/1,
dec_TerminationID/1,
dec_WildcardField/1,
dec_ServiceChangeResult/1,
dec_ServiceChangeReply/1,
dec_ServiceChangeRequest/1,
dec_EventParameter/1,
dec_EventName/1,
dec_ObservedEvent/1,
dec_ObservedEventsDescriptor/1,
dec_NotifyReply/1,
dec_NotifyRequest/1,
dec_AuditDescriptor/1,
dec_AuditReturnParameter/1,
dec_TerminationAudit/1,
dec_AuditResult/1,
dec_AuditReply/1,
dec_AuditRequest/1,
dec_SubtractRequest/1,
dec_AmmsReply/1,
dec_AmmDescriptor/1,
dec_AmmRequest/1,
dec_TopologyRequest/1,
dec_CommandReply/1,
dec_Command/1,
dec_CommandRequest/1,
dec_ContextAttrAuditRequest/1,
dec_ContextRequest/1,
dec_ActionReply/1,
dec_ActionRequest/1,
dec_ContextID/1,
dec_ErrorText/1,
dec_ErrorCode/1,
dec_ErrorDescriptor/1,
dec_TransactionAck/1,
dec_TransactionResponseAck/1,
dec_TransactionReply/1,
dec_TransactionPending/1,
dec_TransactionRequest/1,
dec_TransactionId/1,
dec_Transaction/1,
dec_PathName/1,
dec_IP6Address/1,
dec_IP4Address/1,
dec_DomainName/1,
dec_MId/1,
dec_Message/1,
dec_AuthData/1,
dec_SequenceNum/1,
dec_SecurityParmIndex/1,
dec_AuthenticationHeader/1,
dec_MegacoMessage/1
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> per.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> true.

encode(Type, Data) ->
try complete(encode_disp(Type, Data)) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode(Type, Data) ->
try
   {Result,_Rest} = decode_disp(Type, Data),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('Value', Data) -> enc_Value(Data);
encode_disp('TimeNotation', Data) -> enc_TimeNotation(Data);
encode_disp('H221NonStandard', Data) -> enc_H221NonStandard(Data);
encode_disp('NonStandardIdentifier', Data) -> enc_NonStandardIdentifier(Data);
encode_disp('NonStandardData', Data) -> enc_NonStandardData(Data);
encode_disp('StatisticsParameter', Data) -> enc_StatisticsParameter(Data);
encode_disp('StatisticsDescriptor', Data) -> enc_StatisticsDescriptor(Data);
encode_disp('PackagesItem', Data) -> enc_PackagesItem(Data);
encode_disp('PackagesDescriptor', Data) -> enc_PackagesDescriptor(Data);
encode_disp('ServiceChangeProfile', Data) -> enc_ServiceChangeProfile(Data);
encode_disp('ServiceChangeMethod', Data) -> enc_ServiceChangeMethod(Data);
encode_disp('ServiceChangeResParm', Data) -> enc_ServiceChangeResParm(Data);
encode_disp('ServiceChangeAddress', Data) -> enc_ServiceChangeAddress(Data);
encode_disp('ServiceChangeParm', Data) -> enc_ServiceChangeParm(Data);
encode_disp('DigitMapValue', Data) -> enc_DigitMapValue(Data);
encode_disp('DigitMapName', Data) -> enc_DigitMapName(Data);
encode_disp('DigitMapDescriptor', Data) -> enc_DigitMapDescriptor(Data);
encode_disp('ModemType', Data) -> enc_ModemType(Data);
encode_disp('ModemDescriptor', Data) -> enc_ModemDescriptor(Data);
encode_disp('RequestID', Data) -> enc_RequestID(Data);
encode_disp('SigParameter', Data) -> enc_SigParameter(Data);
encode_disp('NotifyCompletion', Data) -> enc_NotifyCompletion(Data);
encode_disp('SignalName', Data) -> enc_SignalName(Data);
encode_disp('SignalType', Data) -> enc_SignalType(Data);
encode_disp('Signal', Data) -> enc_Signal(Data);
encode_disp('SeqSigList', Data) -> enc_SeqSigList(Data);
encode_disp('SignalRequest', Data) -> enc_SignalRequest(Data);
encode_disp('SignalsDescriptor', Data) -> enc_SignalsDescriptor(Data);
encode_disp('EventSpec', Data) -> enc_EventSpec(Data);
encode_disp('EventBufferDescriptor', Data) -> enc_EventBufferDescriptor(Data);
encode_disp('SecondRequestedActions', Data) -> enc_SecondRequestedActions(Data);
encode_disp('SecondRequestedEvent', Data) -> enc_SecondRequestedEvent(Data);
encode_disp('SecondEventsDescriptor', Data) -> enc_SecondEventsDescriptor(Data);
encode_disp('EventDM', Data) -> enc_EventDM(Data);
encode_disp('RequestedActions', Data) -> enc_RequestedActions(Data);
encode_disp('RequestedEvent', Data) -> enc_RequestedEvent(Data);
encode_disp('EventsDescriptor', Data) -> enc_EventsDescriptor(Data);
encode_disp('StreamID', Data) -> enc_StreamID(Data);
encode_disp('MuxType', Data) -> enc_MuxType(Data);
encode_disp('MuxDescriptor', Data) -> enc_MuxDescriptor(Data);
encode_disp('ServiceState', Data) -> enc_ServiceState(Data);
encode_disp('EventBufferControl', Data) -> enc_EventBufferControl(Data);
encode_disp('TerminationStateDescriptor', Data) -> enc_TerminationStateDescriptor(Data);
encode_disp('PropertyGroup', Data) -> enc_PropertyGroup(Data);
encode_disp('LocalRemoteDescriptor', Data) -> enc_LocalRemoteDescriptor(Data);
encode_disp('Relation', Data) -> enc_Relation(Data);
encode_disp('PkgdName', Data) -> enc_PkgdName(Data);
encode_disp('Name', Data) -> enc_Name(Data);
encode_disp('PropertyParm', Data) -> enc_PropertyParm(Data);
encode_disp('StreamMode', Data) -> enc_StreamMode(Data);
encode_disp('LocalControlDescriptor', Data) -> enc_LocalControlDescriptor(Data);
encode_disp('StreamParms', Data) -> enc_StreamParms(Data);
encode_disp('StreamDescriptor', Data) -> enc_StreamDescriptor(Data);
encode_disp('MediaDescriptor', Data) -> enc_MediaDescriptor(Data);
encode_disp('TerminationIDList', Data) -> enc_TerminationIDList(Data);
encode_disp('TerminationID', Data) -> enc_TerminationID(Data);
encode_disp('WildcardField', Data) -> enc_WildcardField(Data);
encode_disp('ServiceChangeResult', Data) -> enc_ServiceChangeResult(Data);
encode_disp('ServiceChangeReply', Data) -> enc_ServiceChangeReply(Data);
encode_disp('ServiceChangeRequest', Data) -> enc_ServiceChangeRequest(Data);
encode_disp('EventParameter', Data) -> enc_EventParameter(Data);
encode_disp('EventName', Data) -> enc_EventName(Data);
encode_disp('ObservedEvent', Data) -> enc_ObservedEvent(Data);
encode_disp('ObservedEventsDescriptor', Data) -> enc_ObservedEventsDescriptor(Data);
encode_disp('NotifyReply', Data) -> enc_NotifyReply(Data);
encode_disp('NotifyRequest', Data) -> enc_NotifyRequest(Data);
encode_disp('AuditDescriptor', Data) -> enc_AuditDescriptor(Data);
encode_disp('AuditReturnParameter', Data) -> enc_AuditReturnParameter(Data);
encode_disp('TerminationAudit', Data) -> enc_TerminationAudit(Data);
encode_disp('AuditResult', Data) -> enc_AuditResult(Data);
encode_disp('AuditReply', Data) -> enc_AuditReply(Data);
encode_disp('AuditRequest', Data) -> enc_AuditRequest(Data);
encode_disp('SubtractRequest', Data) -> enc_SubtractRequest(Data);
encode_disp('AmmsReply', Data) -> enc_AmmsReply(Data);
encode_disp('AmmDescriptor', Data) -> enc_AmmDescriptor(Data);
encode_disp('AmmRequest', Data) -> enc_AmmRequest(Data);
encode_disp('TopologyRequest', Data) -> enc_TopologyRequest(Data);
encode_disp('CommandReply', Data) -> enc_CommandReply(Data);
encode_disp('Command', Data) -> enc_Command(Data);
encode_disp('CommandRequest', Data) -> enc_CommandRequest(Data);
encode_disp('ContextAttrAuditRequest', Data) -> enc_ContextAttrAuditRequest(Data);
encode_disp('ContextRequest', Data) -> enc_ContextRequest(Data);
encode_disp('ActionReply', Data) -> enc_ActionReply(Data);
encode_disp('ActionRequest', Data) -> enc_ActionRequest(Data);
encode_disp('ContextID', Data) -> enc_ContextID(Data);
encode_disp('ErrorText', Data) -> enc_ErrorText(Data);
encode_disp('ErrorCode', Data) -> enc_ErrorCode(Data);
encode_disp('ErrorDescriptor', Data) -> enc_ErrorDescriptor(Data);
encode_disp('TransactionAck', Data) -> enc_TransactionAck(Data);
encode_disp('TransactionResponseAck', Data) -> enc_TransactionResponseAck(Data);
encode_disp('TransactionReply', Data) -> enc_TransactionReply(Data);
encode_disp('TransactionPending', Data) -> enc_TransactionPending(Data);
encode_disp('TransactionRequest', Data) -> enc_TransactionRequest(Data);
encode_disp('TransactionId', Data) -> enc_TransactionId(Data);
encode_disp('Transaction', Data) -> enc_Transaction(Data);
encode_disp('PathName', Data) -> enc_PathName(Data);
encode_disp('IP6Address', Data) -> enc_IP6Address(Data);
encode_disp('IP4Address', Data) -> enc_IP4Address(Data);
encode_disp('DomainName', Data) -> enc_DomainName(Data);
encode_disp('MId', Data) -> enc_MId(Data);
encode_disp('Message', Data) -> enc_Message(Data);
encode_disp('AuthData', Data) -> enc_AuthData(Data);
encode_disp('SequenceNum', Data) -> enc_SequenceNum(Data);
encode_disp('SecurityParmIndex', Data) -> enc_SecurityParmIndex(Data);
encode_disp('AuthenticationHeader', Data) -> enc_AuthenticationHeader(Data);
encode_disp('MegacoMessage', Data) -> enc_MegacoMessage(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('Value', Data) -> dec_Value(Data);
decode_disp('TimeNotation', Data) -> dec_TimeNotation(Data);
decode_disp('H221NonStandard', Data) -> dec_H221NonStandard(Data);
decode_disp('NonStandardIdentifier', Data) -> dec_NonStandardIdentifier(Data);
decode_disp('NonStandardData', Data) -> dec_NonStandardData(Data);
decode_disp('StatisticsParameter', Data) -> dec_StatisticsParameter(Data);
decode_disp('StatisticsDescriptor', Data) -> dec_StatisticsDescriptor(Data);
decode_disp('PackagesItem', Data) -> dec_PackagesItem(Data);
decode_disp('PackagesDescriptor', Data) -> dec_PackagesDescriptor(Data);
decode_disp('ServiceChangeProfile', Data) -> dec_ServiceChangeProfile(Data);
decode_disp('ServiceChangeMethod', Data) -> dec_ServiceChangeMethod(Data);
decode_disp('ServiceChangeResParm', Data) -> dec_ServiceChangeResParm(Data);
decode_disp('ServiceChangeAddress', Data) -> dec_ServiceChangeAddress(Data);
decode_disp('ServiceChangeParm', Data) -> dec_ServiceChangeParm(Data);
decode_disp('DigitMapValue', Data) -> dec_DigitMapValue(Data);
decode_disp('DigitMapName', Data) -> dec_DigitMapName(Data);
decode_disp('DigitMapDescriptor', Data) -> dec_DigitMapDescriptor(Data);
decode_disp('ModemType', Data) -> dec_ModemType(Data);
decode_disp('ModemDescriptor', Data) -> dec_ModemDescriptor(Data);
decode_disp('RequestID', Data) -> dec_RequestID(Data);
decode_disp('SigParameter', Data) -> dec_SigParameter(Data);
decode_disp('NotifyCompletion', Data) -> dec_NotifyCompletion(Data);
decode_disp('SignalName', Data) -> dec_SignalName(Data);
decode_disp('SignalType', Data) -> dec_SignalType(Data);
decode_disp('Signal', Data) -> dec_Signal(Data);
decode_disp('SeqSigList', Data) -> dec_SeqSigList(Data);
decode_disp('SignalRequest', Data) -> dec_SignalRequest(Data);
decode_disp('SignalsDescriptor', Data) -> dec_SignalsDescriptor(Data);
decode_disp('EventSpec', Data) -> dec_EventSpec(Data);
decode_disp('EventBufferDescriptor', Data) -> dec_EventBufferDescriptor(Data);
decode_disp('SecondRequestedActions', Data) -> dec_SecondRequestedActions(Data);
decode_disp('SecondRequestedEvent', Data) -> dec_SecondRequestedEvent(Data);
decode_disp('SecondEventsDescriptor', Data) -> dec_SecondEventsDescriptor(Data);
decode_disp('EventDM', Data) -> dec_EventDM(Data);
decode_disp('RequestedActions', Data) -> dec_RequestedActions(Data);
decode_disp('RequestedEvent', Data) -> dec_RequestedEvent(Data);
decode_disp('EventsDescriptor', Data) -> dec_EventsDescriptor(Data);
decode_disp('StreamID', Data) -> dec_StreamID(Data);
decode_disp('MuxType', Data) -> dec_MuxType(Data);
decode_disp('MuxDescriptor', Data) -> dec_MuxDescriptor(Data);
decode_disp('ServiceState', Data) -> dec_ServiceState(Data);
decode_disp('EventBufferControl', Data) -> dec_EventBufferControl(Data);
decode_disp('TerminationStateDescriptor', Data) -> dec_TerminationStateDescriptor(Data);
decode_disp('PropertyGroup', Data) -> dec_PropertyGroup(Data);
decode_disp('LocalRemoteDescriptor', Data) -> dec_LocalRemoteDescriptor(Data);
decode_disp('Relation', Data) -> dec_Relation(Data);
decode_disp('PkgdName', Data) -> dec_PkgdName(Data);
decode_disp('Name', Data) -> dec_Name(Data);
decode_disp('PropertyParm', Data) -> dec_PropertyParm(Data);
decode_disp('StreamMode', Data) -> dec_StreamMode(Data);
decode_disp('LocalControlDescriptor', Data) -> dec_LocalControlDescriptor(Data);
decode_disp('StreamParms', Data) -> dec_StreamParms(Data);
decode_disp('StreamDescriptor', Data) -> dec_StreamDescriptor(Data);
decode_disp('MediaDescriptor', Data) -> dec_MediaDescriptor(Data);
decode_disp('TerminationIDList', Data) -> dec_TerminationIDList(Data);
decode_disp('TerminationID', Data) -> dec_TerminationID(Data);
decode_disp('WildcardField', Data) -> dec_WildcardField(Data);
decode_disp('ServiceChangeResult', Data) -> dec_ServiceChangeResult(Data);
decode_disp('ServiceChangeReply', Data) -> dec_ServiceChangeReply(Data);
decode_disp('ServiceChangeRequest', Data) -> dec_ServiceChangeRequest(Data);
decode_disp('EventParameter', Data) -> dec_EventParameter(Data);
decode_disp('EventName', Data) -> dec_EventName(Data);
decode_disp('ObservedEvent', Data) -> dec_ObservedEvent(Data);
decode_disp('ObservedEventsDescriptor', Data) -> dec_ObservedEventsDescriptor(Data);
decode_disp('NotifyReply', Data) -> dec_NotifyReply(Data);
decode_disp('NotifyRequest', Data) -> dec_NotifyRequest(Data);
decode_disp('AuditDescriptor', Data) -> dec_AuditDescriptor(Data);
decode_disp('AuditReturnParameter', Data) -> dec_AuditReturnParameter(Data);
decode_disp('TerminationAudit', Data) -> dec_TerminationAudit(Data);
decode_disp('AuditResult', Data) -> dec_AuditResult(Data);
decode_disp('AuditReply', Data) -> dec_AuditReply(Data);
decode_disp('AuditRequest', Data) -> dec_AuditRequest(Data);
decode_disp('SubtractRequest', Data) -> dec_SubtractRequest(Data);
decode_disp('AmmsReply', Data) -> dec_AmmsReply(Data);
decode_disp('AmmDescriptor', Data) -> dec_AmmDescriptor(Data);
decode_disp('AmmRequest', Data) -> dec_AmmRequest(Data);
decode_disp('TopologyRequest', Data) -> dec_TopologyRequest(Data);
decode_disp('CommandReply', Data) -> dec_CommandReply(Data);
decode_disp('Command', Data) -> dec_Command(Data);
decode_disp('CommandRequest', Data) -> dec_CommandRequest(Data);
decode_disp('ContextAttrAuditRequest', Data) -> dec_ContextAttrAuditRequest(Data);
decode_disp('ContextRequest', Data) -> dec_ContextRequest(Data);
decode_disp('ActionReply', Data) -> dec_ActionReply(Data);
decode_disp('ActionRequest', Data) -> dec_ActionRequest(Data);
decode_disp('ContextID', Data) -> dec_ContextID(Data);
decode_disp('ErrorText', Data) -> dec_ErrorText(Data);
decode_disp('ErrorCode', Data) -> dec_ErrorCode(Data);
decode_disp('ErrorDescriptor', Data) -> dec_ErrorDescriptor(Data);
decode_disp('TransactionAck', Data) -> dec_TransactionAck(Data);
decode_disp('TransactionResponseAck', Data) -> dec_TransactionResponseAck(Data);
decode_disp('TransactionReply', Data) -> dec_TransactionReply(Data);
decode_disp('TransactionPending', Data) -> dec_TransactionPending(Data);
decode_disp('TransactionRequest', Data) -> dec_TransactionRequest(Data);
decode_disp('TransactionId', Data) -> dec_TransactionId(Data);
decode_disp('Transaction', Data) -> dec_Transaction(Data);
decode_disp('PathName', Data) -> dec_PathName(Data);
decode_disp('IP6Address', Data) -> dec_IP6Address(Data);
decode_disp('IP4Address', Data) -> dec_IP4Address(Data);
decode_disp('DomainName', Data) -> dec_DomainName(Data);
decode_disp('MId', Data) -> dec_MId(Data);
decode_disp('Message', Data) -> dec_Message(Data);
decode_disp('AuthData', Data) -> dec_AuthData(Data);
decode_disp('SequenceNum', Data) -> dec_SequenceNum(Data);
decode_disp('SecurityParmIndex', Data) -> dec_SecurityParmIndex(Data);
decode_disp('AuthenticationHeader', Data) -> dec_AuthenticationHeader(Data);
decode_disp('MegacoMessage', Data) -> dec_MegacoMessage(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.
enc_Value(Val) ->
Enc2@len = length(Val),
if Enc2@len < 128 ->
[align,
Enc2@len|[begin
Enc1@bin = iolist_to_binary(Comp),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len < 128 ->
[align,
Enc1@len,
align|Enc1@bin];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>,
align|Enc1@bin];
true ->
[align|encode_fragmented(Enc1@bin, 8)]
end
end || Comp <- Val]];
Enc2@len < 16384 ->
[align,
<<2:2,Enc2@len:14>>|[begin
Enc1@bin = iolist_to_binary(Comp),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len < 128 ->
[align,
Enc1@len,
align|Enc1@bin];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>,
align|Enc1@bin];
true ->
[align|encode_fragmented(Enc1@bin, 8)]
end
end || Comp <- Val]];
true ->
begin
Enc2@fn = fun(Comp) -> begin
Enc1@bin = iolist_to_binary(Comp),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len < 128 ->
[align,
Enc1@len,
align|Enc1@bin];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>,
align|Enc1@bin];
true ->
[align|encode_fragmented(Enc1@bin, 8)]
end
end end,
encode_fragmented_sof(Enc2@fn, Val, Enc2@len)
end
end.



dec_Value(Bytes) ->
dec_components1(Bytes, []).

enc_TimeNotation(Val) ->
[align,
begin
%% attribute date(1) with type IA5String
Enc1@element = element(2, Val),
Enc2@bin = list_to_binary(Enc1@element),
Enc2@len = byte_size(Enc2@bin),
if Enc2@len =:= 8 ->
Enc2@bin
end
end|begin
%% attribute time(2) with type IA5String
Enc3@element = element(3, Val),
Enc4@bin = list_to_binary(Enc3@element),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 8 ->
Enc4@bin
end
end].


dec_TimeNotation(Bytes) ->

%% attribute date(1) with type IA5String
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:8/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end,

%% attribute time(2) with type IA5String
{Term2,Bytes2} = begin
<<V2@V0:8/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end,
Res1 = {'TimeNotation',Term1,Term2},
{Res1,Bytes2}.

enc_H221NonStandard(Val) ->
[begin
%% attribute t35CountryCode1(1) with type INTEGER
Enc2@element = element(2, Val),
if Enc2@element bsr 8 =:= 0 ->
[<<0:1>>,
align,
Enc2@element];
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute t35CountryCode2(2) with type INTEGER
Enc4@element = element(3, Val),
if Enc4@element bsr 8 =:= 0 ->
Enc4@element;
true ->
exit({error,{asn1,{illegal_integer,Enc4@element}}})
end
end,
begin
%% attribute t35Extension(3) with type INTEGER
Enc6@element = element(4, Val),
if Enc6@element bsr 8 =:= 0 ->
Enc6@element;
true ->
exit({error,{asn1,{illegal_integer,Enc6@element}}})
end
end|begin
%% attribute manufacturerCode(4) with type INTEGER
Enc8@element = element(5, Val),
if Enc8@element bsr 16 =:= 0 ->
<<Enc8@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc8@element}}})
end
end].


dec_H221NonStandard(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute t35CountryCode1(1) with type INTEGER
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:1/unsigned-unit:8,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute t35CountryCode2(2) with type INTEGER
{Term2,Bytes3} = begin
<<V3@V0:1/unsigned-unit:8,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end,

%% attribute t35Extension(3) with type INTEGER
{Term3,Bytes4} = begin
<<V4@V0:1/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end,

%% attribute manufacturerCode(4) with type INTEGER
{Term4,Bytes5} = begin
<<V5@V0:2/unsigned-unit:8,V5@Buf1/bitstring>> = Bytes4,
{V5@V0,V5@Buf1}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V6@V0,V6@Buf1} = case Bytes5 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:7,0:1,V6@V7:7,V6@Buf8/bitstring>> when V6@V7 =/= 0 ->
{V6@V7,V6@Buf8};
<<_:7,1:1,0:1,V6@V8:14,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:7,1:1,1:1,V6@V8:6,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
V6@Mul10 = V6@V8 * 16384,
{V6@Mul10,V6@Buf9}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V11:V6@V0/bitstring-unit:1,V6@Buf12/bitstring>> = V6@Buf1,
{V6@V11,V6@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'H221NonStandard',Term1,Term2,Term3,Term4},
{Res1,Bytes7}.

enc_NonStandardIdentifier(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= object ->
begin
Enc2@bin = encode_oid(ChoiceVal),
Enc2@len = byte_size(Enc2@bin),
if Enc2@len < 128 ->
[<<0:1,0:2>>,
align,
Enc2@len|Enc2@bin];
Enc2@len < 16384 ->
[<<0:1,0:2>>,
align,
<<2:2,Enc2@len:14>>|Enc2@bin];
true ->
[<<0:1,0:2>>,
align|encode_fragmented(Enc2@bin, 8)]
end
end;
ChoiceTag =:= h221NonStandard ->
[<<0:1,1:2>>|enc_H221NonStandard(ChoiceVal)];
ChoiceTag =:= experimental ->
begin
Enc5@bin = list_to_binary(ChoiceVal),
Enc5@len = byte_size(Enc5@bin),
if Enc5@len =:= 8 ->
[<<0:1,2:2>>,
align|Enc5@bin]
end
end
end.


dec_NonStandardIdentifier(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@Buf6/bitstring>> ->
{V2@V5,V2@Buf6};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@Buf7/bitstring>> ->
{V2@V6,V2@Buf7};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
V2@Mul8 = V2@V6 * 16384,
{V2@Mul8,V2@Buf7}
end,
<<V2@V9:V2@V0/binary-unit:8,V2@Buf10/bitstring>> = V2@Buf1,
V2@Conv11 = binary_to_list(V2@V9),
{V2@V12,V2@Buf13}  = {decode_oid(V2@Conv11),V2@Buf10},
{V2@V12,V2@Buf13}
end
end,
{{object,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_H221NonStandard(Bytes2)
end,
{{h221NonStandard,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:8/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end
end,
{{experimental,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_NonStandardData(Val) ->
[begin
%% attribute nonStandardIdentifier(1) with type NonStandardIdentifier
Enc1@element = element(2, Val),
enc_NonStandardIdentifier(Enc1@element)
end,
align|begin
%% attribute data(2) with type OCTET STRING
Enc2@element = element(3, Val),
Enc3@bin = iolist_to_binary(Enc2@element),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len < 128 ->
[Enc3@len|Enc3@bin];
Enc3@len < 16384 ->
[<<2:2,Enc3@len:14>>|Enc3@bin];
true ->
encode_fragmented(Enc3@bin, 8)
end
end].


dec_NonStandardData(Bytes) ->

%% attribute nonStandardIdentifier(1) with type NonStandardIdentifier
{Term1,Bytes1} = dec_NonStandardIdentifier(Bytes),

%% attribute data(2) with type OCTET STRING
{Term2,Bytes2} = begin
V1@Pad3 = bit_size(Bytes1) band 7,
{V1@V0,V1@Buf1} = case Bytes1 of
<<_:V1@Pad3,0:1,V1@V5:7,V1@V7:V1@V5/binary-unit:8,V1@Buf8/bitstring>> ->
{V1@V7,V1@Buf8};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@V8:V1@V6/binary-unit:8,V1@Buf9/bitstring>> ->
{V1@V8,V1@Buf9};
<<_:V1@Pad3,1:1,1:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V8,V1@Buf9}  = decode_fragmented(V1@V6, V1@Buf7, 8),
{V1@V8,V1@Buf9}
end,
V1@Conv10 = binary_to_list(V1@V0),
{V1@Conv10,V1@Buf1}
end,
Res1 = {'NonStandardData',Term1,Term2},
{Res1,Bytes2}.

enc_StatisticsParameter(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
%% attribute statName(1) with type OCTET STRING
Enc2@element = element(2, Val),
Enc3@bin = iolist_to_binary(Enc2@element),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len =:= 4 ->
Enc3@bin
end
end|begin
%% attribute statValue(2) with type Value
Enc4@element = element(3, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
true ->
enc_Value(Enc4@element)
end
end].


dec_StatisticsParameter(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute statName(1) with type OCTET STRING
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:4/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv4 = binary_to_list(V2@V0),
{V2@Conv4,V2@Buf1}
end,

%% attribute statValue(2) with type Value
{Term2,Bytes3} = case Opt band 1 of
1 ->
dec_Value(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,
Res1 = {'StatisticsParameter',Term1,Term2},
{Res1,Bytes3}.

enc_StatisticsDescriptor(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_StatisticsParameter(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_StatisticsParameter(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_StatisticsParameter(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_StatisticsDescriptor(Bytes) ->
dec_components2(Bytes, []).

enc_PackagesItem(Val) ->
[begin
%% attribute packageName(1) with type OCTET STRING
Enc2@element = element(2, Val),
Enc3@bin = iolist_to_binary(Enc2@element),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len =:= 2 ->
[<<0:1>>|Enc3@bin]
end
end|begin
%% attribute packageVersion(2) with type INTEGER
Enc4@element = element(3, Val),
if 0 =< Enc4@element, Enc4@element < 100 ->
<<Enc4@element:7>>;
true ->
exit({error,{asn1,{illegal_integer,Enc4@element}}})
end
end].


dec_PackagesItem(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute packageName(1) with type OCTET STRING
{Term1,Bytes2} = begin
<<V2@V0:2/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end,

%% attribute packageVersion(2) with type INTEGER
{Term2,Bytes3} = begin
<<V3@V0:7/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end,

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
Res1 = {'PackagesItem',Term1,Term2},
{Res1,Bytes5}.

enc_PackagesDescriptor(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_PackagesItem(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_PackagesItem(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_PackagesItem(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_PackagesDescriptor(Bytes) ->
dec_components3(Bytes, []).

enc_ServiceChangeProfile(Val) ->
%% attribute profileName(1) with type IA5String
Enc1@element = element(2, Val),
Enc2@bin = list_to_binary(Enc1@element),
Enc2@len = byte_size(Enc2@bin),
Enc2@len@sub = Enc2@len - 1,
if 0 =< Enc2@len@sub, Enc2@len@sub < 67 ->
[<<Enc2@len@sub:7>>,
align|Enc2@bin]
end.


dec_ServiceChangeProfile(Bytes) ->

%% attribute profileName(1) with type IA5String
{Term1,Bytes1} = begin
<<V1@V0:7/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/binary-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
V1@Conv7 = binary_to_list(V1@V3),
{V1@Conv7,V1@Buf4}
end,
Res1 = {'ServiceChangeProfile',Term1},
{Res1,Bytes1}.

enc_ServiceChangeMethod(Val) ->
if Val =:= failover ->
<<0:1,0:3>>;
Val =:= forced ->
<<0:1,1:3>>;
Val =:= graceful ->
<<0:1,2:3>>;
Val =:= restart ->
<<0:1,3:3>>;
Val =:= disconnected ->
<<0:1,4:3>>;
Val =:= handOff ->
<<0:1,5:3>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_ServiceChangeMethod(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:3/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> failover;
1 -> forced;
2 -> graceful;
3 -> restart;
4 -> disconnected;
5 -> handOff;
_ -> exit({error,{asn1,{decode_enumerated,V1@V3}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13};
<<_:V1@Pad9,1:1,1:1,V1@V12:6,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
V1@Mul14 = V1@V12 * 16384,
{V1@Mul14,V1@Buf13}
end,
<<V1@V15:V1@V6/unit:8,V1@Buf16/bitstring>> = V1@Buf7,
{V1@V15,V1@Buf16}
end,
V1@Int17 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int17,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

enc_ServiceChangeResParm(Val) ->
[begin
Enc1@element = element(2, Val),
Enc2@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(4, Val),
Enc4@element = element(5, Val),
if Enc3@element =:= asn1_NOVALUE ->
if Enc4@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc4@element =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc5@element = element(6, Val),
if Enc5@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
%% attribute serviceChangeMgcId(1) with type MId
Enc7@element = element(2, Val),
if Enc7@element =:= asn1_NOVALUE ->
[];
true ->
enc_MId(Enc7@element)
end
end,
begin
%% attribute serviceChangeAddress(2) with type ServiceChangeAddress
Enc9@element = element(3, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
enc_ServiceChangeAddress(Enc9@element)
end
end,
begin
%% attribute serviceChangeVersion(3) with type INTEGER
Enc11@element = element(4, Val),
if Enc11@element =:= asn1_NOVALUE ->
[];
0 =< Enc11@element, Enc11@element < 100 ->
<<Enc11@element:7>>;
true ->
exit({error,{asn1,{illegal_integer,Enc11@element}}})
end
end,
begin
%% attribute serviceChangeProfile(4) with type ServiceChangeProfile
Enc14@element = element(5, Val),
if Enc14@element =:= asn1_NOVALUE ->
[];
true ->
enc_ServiceChangeProfile(Enc14@element)
end
end|begin
%% attribute timeStamp(5) with type TimeNotation
Enc16@element = element(6, Val),
if Enc16@element =:= asn1_NOVALUE ->
[];
true ->
enc_TimeNotation(Enc16@element)
end
end].


dec_ServiceChangeResParm(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:5,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute serviceChangeMgcId(1) with type MId
{Term1,Bytes3} = case (Opt bsr 4) band 1 of
1 ->
dec_MId(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute serviceChangeAddress(2) with type ServiceChangeAddress
{Term2,Bytes4} = case (Opt bsr 3) band 1 of
1 ->
dec_ServiceChangeAddress(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute serviceChangeVersion(3) with type INTEGER
{Term3,Bytes5} = case (Opt bsr 2) band 1 of
1 ->
begin
<<V3@V0:7/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes4,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute serviceChangeProfile(4) with type ServiceChangeProfile
{Term4,Bytes6} = case (Opt bsr 1) band 1 of
1 ->
dec_ServiceChangeProfile(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% attribute timeStamp(5) with type TimeNotation
{Term5,Bytes7} = case Opt band 1 of
1 ->
dec_TimeNotation(Bytes6);
0 ->
{asn1_NOVALUE,Bytes6}
end,

%% Extensions
{Extensions,Bytes8} = case Ext of
0 -> {<<>>,Bytes7};
1 ->
{V4@V0,V4@Buf1} = case Bytes7 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes9= skipextensions(Bytes8, 1, Extensions),
Res1 = {'ServiceChangeResParm',Term1,Term2,Term3,Term4,Term5},
{Res1,Bytes9}.

enc_ServiceChangeAddress(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= portNumber ->
if ChoiceVal bsr 16 =:= 0 ->
[<<0:1,0:3>>,
align|<<ChoiceVal:16>>];
true ->
exit({error,{asn1,{illegal_integer,ChoiceVal}}})
end;
ChoiceTag =:= ip4Address ->
[<<0:1,1:3>>|enc_IP4Address(ChoiceVal)];
ChoiceTag =:= ip6Address ->
[<<0:1,2:3>>|enc_IP6Address(ChoiceVal)];
ChoiceTag =:= domainName ->
[<<0:1,3:3>>|enc_DomainName(ChoiceVal)];
ChoiceTag =:= deviceName ->
begin
Enc7@bin = list_to_binary(ChoiceVal),
Enc7@len = byte_size(Enc7@bin),
Enc7@len@sub = Enc7@len - 1,
if Enc7@len@sub bsr 6 =:= 0 ->
[<<0:1,4:3,Enc7@len@sub:6>>,
align|Enc7@bin]
end
end;
ChoiceTag =:= mtpAddress ->
begin
Enc9@bin = iolist_to_binary(ChoiceVal),
Enc9@len = byte_size(Enc9@bin),
Enc9@len@sub = Enc9@len - 2,
if 0 =< Enc9@len@sub, Enc9@len@sub < 3 ->
[<<0:1,5:3,Enc9@len@sub:2>>,
align|Enc9@bin]
end
end
end.


dec_ServiceChangeAddress(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:3/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
V2@Pad2 = bit_size(Bytes2) band 7,
<<_:V2@Pad2,V2@V0:2/unsigned-unit:8,V2@Buf1/bitstring>> = Bytes2,
{V2@V0,V2@Buf1}
end
end,
{{portNumber,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_IP4Address(Bytes2)
end,
{{ip4Address,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_IP6Address(Bytes2)
end,
{{ip6Address,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_DomainName(Bytes2)
end,
{{domainName,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
begin
<<V3@V0:6/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 1,
V3@Pad5 = bit_size(V3@Buf1) band 7,
<<_:V3@Pad5,V3@V3:V3@Add2/binary-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
V3@Conv7 = binary_to_list(V3@V3),
{V3@Conv7,V3@Buf4}
end
end,
{{deviceName,Val},NewBytes};
5 ->
{Val,NewBytes} = begin
begin
<<V4@V0:2/unsigned-unit:1,V4@Buf1/bitstring>> = Bytes2,
V4@Add2 = V4@V0 + 2,
V4@Pad5 = bit_size(V4@Buf1) band 7,
<<_:V4@Pad5,V4@V3:V4@Add2/binary-unit:8,V4@Buf4/bitstring>> = V4@Buf1,
V4@Conv7 = binary_to_list(V4@V3),
{V4@Conv7,V4@Buf4}
end
end,
{{mtpAddress,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_ServiceChangeParm(Val) ->
[begin
Enc1@element = element(3, Val),
Enc2@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(5, Val),
Enc4@element = element(7, Val),
if Enc3@element =:= asn1_NOVALUE ->
if Enc4@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc4@element =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc5@element = element(8, Val),
Enc6@element = element(9, Val),
if Enc5@element =:= asn1_NOVALUE ->
if Enc6@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc6@element =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc7@element = element(10, Val),
if Enc7@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
%% attribute serviceChangeMethod(1) with type ENUMERATED
Enc9@element = element(2, Val),
if Enc9@element =:= failover ->
<<0:1,0:3>>;
Enc9@element =:= forced ->
<<0:1,1:3>>;
Enc9@element =:= graceful ->
<<0:1,2:3>>;
Enc9@element =:= restart ->
<<0:1,3:3>>;
Enc9@element =:= disconnected ->
<<0:1,4:3>>;
Enc9@element =:= handOff ->
<<0:1,5:3>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc9@element}}})
end
end,
begin
%% attribute serviceChangeAddress(2) with type ServiceChangeAddress
Enc11@element = element(3, Val),
if Enc11@element =:= asn1_NOVALUE ->
[];
true ->
enc_ServiceChangeAddress(Enc11@element)
end
end,
begin
%% attribute serviceChangeVersion(3) with type INTEGER
Enc13@element = element(4, Val),
if Enc13@element =:= asn1_NOVALUE ->
[];
0 =< Enc13@element, Enc13@element < 100 ->
<<Enc13@element:7>>;
true ->
exit({error,{asn1,{illegal_integer,Enc13@element}}})
end
end,
begin
%% attribute serviceChangeProfile(4) with type ServiceChangeProfile
Enc16@element = element(5, Val),
if Enc16@element =:= asn1_NOVALUE ->
[];
true ->
enc_ServiceChangeProfile(Enc16@element)
end
end,
begin
%% attribute serviceChangeReason(5) with type Value
Enc18@element = element(6, Val),
enc_Value(Enc18@element)
end,
begin
%% attribute serviceChangeDelay(6) with type INTEGER
Enc19@element = element(7, Val),
if Enc19@element =:= asn1_NOVALUE ->
[];
Enc19@element bsr 32 =:= 0 ->
begin
Enc19@element@bin = binary:encode_unsigned(Enc19@element),
Enc19@element@bin_size0 = byte_size(Enc19@element@bin),
Enc19@element@bin_size = Enc19@element@bin_size0 - 1,
[<<Enc19@element@bin_size:2>>,
align|Enc19@element@bin]
end;
true ->
exit({error,{asn1,{illegal_integer,Enc19@element}}})
end
end,
begin
%% attribute serviceChangeMgcId(7) with type MId
Enc22@element = element(8, Val),
if Enc22@element =:= asn1_NOVALUE ->
[];
true ->
enc_MId(Enc22@element)
end
end,
begin
%% attribute timeStamp(8) with type TimeNotation
Enc24@element = element(9, Val),
if Enc24@element =:= asn1_NOVALUE ->
[];
true ->
enc_TimeNotation(Enc24@element)
end
end|begin
%% attribute nonStandardData(9) with type NonStandardData
Enc26@element = element(10, Val),
if Enc26@element =:= asn1_NOVALUE ->
[];
true ->
enc_NonStandardData(Enc26@element)
end
end].


dec_ServiceChangeParm(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:7,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute serviceChangeMethod(1) with type ENUMERATED
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:3/unsigned-unit:1,V3@Buf4/bitstring>> ->
V3@Int5 = case V3@V3 of
0 -> failover;
1 -> forced;
2 -> graceful;
3 -> restart;
4 -> disconnected;
5 -> handOff;
_ -> exit({error,{asn1,{decode_enumerated,V3@V3}}})
end,
{V3@Int5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<0:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V6,V3@Buf7};
<<1:1,V3@Buf5/bitstring>> ->
V3@Pad9 = bit_size(V3@Buf5) band 7,
{V3@V6,V3@Buf7} = case V3@Buf5 of
<<_:V3@Pad9,0:1,V3@V11:7,V3@Buf12/bitstring>> when V3@V11 =/= 0 ->
{V3@V11,V3@Buf12};
<<_:V3@Pad9,1:1,0:1,V3@V12:14,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
{V3@V12,V3@Buf13};
<<_:V3@Pad9,1:1,1:1,V3@V12:6,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
V3@Mul14 = V3@V12 * 16384,
{V3@Mul14,V3@Buf13}
end,
<<V3@V15:V3@V6/unit:8,V3@Buf16/bitstring>> = V3@Buf7,
{V3@V15,V3@Buf16}
end,
V3@Int17 = case V3@V3 of
_ -> {asn1_enum,V3@V3}
end,
{V3@Int17,V3@Buf4}
end,
{V3@V0,V3@Buf1}
end,

%% attribute serviceChangeAddress(2) with type ServiceChangeAddress
{Term2,Bytes4} = case (Opt bsr 6) band 1 of
1 ->
dec_ServiceChangeAddress(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute serviceChangeVersion(3) with type INTEGER
{Term3,Bytes5} = case (Opt bsr 5) band 1 of
1 ->
begin
<<V4@V0:7/unsigned-unit:1,V4@Buf1/bitstring>> = Bytes4,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute serviceChangeProfile(4) with type ServiceChangeProfile
{Term4,Bytes6} = case (Opt bsr 4) band 1 of
1 ->
dec_ServiceChangeProfile(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% attribute serviceChangeReason(5) with type Value
{Term5,Bytes7} = dec_Value(Bytes6),

%% attribute serviceChangeDelay(6) with type INTEGER
{Term6,Bytes8} = case (Opt bsr 3) band 1 of
1 ->
begin
<<V5@V0:2/unsigned-unit:1,V5@Buf1/bitstring>> = Bytes7,
V5@Add2 = V5@V0 + 1,
V5@Pad5 = bit_size(V5@Buf1) band 7,
<<_:V5@Pad5,V5@V3:V5@Add2/unsigned-unit:8,V5@Buf4/bitstring>> = V5@Buf1,
{V5@V3,V5@Buf4}
end;
0 ->
{asn1_NOVALUE,Bytes7}
end,

%% attribute serviceChangeMgcId(7) with type MId
{Term7,Bytes9} = case (Opt bsr 2) band 1 of
1 ->
dec_MId(Bytes8);
0 ->
{asn1_NOVALUE,Bytes8}
end,

%% attribute timeStamp(8) with type TimeNotation
{Term8,Bytes10} = case (Opt bsr 1) band 1 of
1 ->
dec_TimeNotation(Bytes9);
0 ->
{asn1_NOVALUE,Bytes9}
end,

%% attribute nonStandardData(9) with type NonStandardData
{Term9,Bytes11} = case Opt band 1 of
1 ->
dec_NonStandardData(Bytes10);
0 ->
{asn1_NOVALUE,Bytes10}
end,

%% Extensions
{Extensions,Bytes12} = case Ext of
0 -> {<<>>,Bytes11};
1 ->
{V6@V0,V6@Buf1} = case Bytes11 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
V6@Mul11 = V6@V9 * 16384,
{V6@Mul11,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V12:V6@V0/bitstring-unit:1,V6@Buf13/bitstring>> = V6@Buf1,
{V6@V12,V6@Buf13}
end,
Bytes13= skipextensions(Bytes12, 1, Extensions),
Res1 = {'ServiceChangeParm',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9},
{Res1,Bytes13}.

enc_DigitMapValue(Val) ->
[begin
Enc1@element = element(2, Val),
Enc2@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(4, Val),
if Enc3@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
%% attribute startTimer(1) with type INTEGER
Enc5@element = element(2, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
0 =< Enc5@element, Enc5@element < 100 ->
<<Enc5@element:7>>;
true ->
exit({error,{asn1,{illegal_integer,Enc5@element}}})
end
end,
begin
%% attribute shortTimer(2) with type INTEGER
Enc8@element = element(3, Val),
if Enc8@element =:= asn1_NOVALUE ->
[];
0 =< Enc8@element, Enc8@element < 100 ->
<<Enc8@element:7>>;
true ->
exit({error,{asn1,{illegal_integer,Enc8@element}}})
end
end,
begin
%% attribute longTimer(3) with type INTEGER
Enc11@element = element(4, Val),
if Enc11@element =:= asn1_NOVALUE ->
[];
0 =< Enc11@element, Enc11@element < 100 ->
<<Enc11@element:7>>;
true ->
exit({error,{asn1,{illegal_integer,Enc11@element}}})
end
end,
align|begin
%% attribute digitMapBody(4) with type IA5String
Enc14@element = element(5, Val),
Enc15@bin = list_to_binary(Enc14@element),
Enc15@len = byte_size(Enc15@bin),
if Enc15@len < 128 ->
[Enc15@len|Enc15@bin];
Enc15@len < 16384 ->
[<<2:2,Enc15@len:14>>|Enc15@bin];
true ->
encode_fragmented(Enc15@bin, 8)
end
end].


dec_DigitMapValue(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute startTimer(1) with type INTEGER
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
begin
<<V3@V0:7/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute shortTimer(2) with type INTEGER
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
<<V4@V0:7/unsigned-unit:1,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute longTimer(3) with type INTEGER
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
<<V5@V0:7/unsigned-unit:1,V5@Buf1/bitstring>> = Bytes4,
{V5@V0,V5@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute digitMapBody(4) with type IA5String
{Term4,Bytes6} = begin
V6@Pad3 = bit_size(Bytes5) band 7,
{V6@V0,V6@Buf1} = case Bytes5 of
<<_:V6@Pad3,0:1,V6@V5:7,V6@V7:V6@V5/binary-unit:8,V6@Buf8/bitstring>> ->
{V6@V7,V6@Buf8};
<<_:V6@Pad3,1:1,0:1,V6@V6:14,V6@V8:V6@V6/binary-unit:8,V6@Buf9/bitstring>> ->
{V6@V8,V6@Buf9};
<<_:V6@Pad3,1:1,1:1,V6@V6:6,V6@Buf7/bitstring>> ->
{V6@V8,V6@Buf9}  = decode_fragmented(V6@V6, V6@Buf7, 8),
{V6@V8,V6@Buf9}
end,
V6@Conv10 = binary_to_list(V6@V0),
{V6@Conv10,V6@Buf1}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V7@V0,V7@Buf1} = case Bytes6 of
<<0:1,V7@V3:6,V7@Buf4/bitstring>> ->
V7@Add5 = V7@V3 + 1,
{V7@Add5,V7@Buf4};
<<1:1,V7@Buf2/bitstring>> ->
{V7@V3,V7@Buf4} = case V7@Buf2 of
<<_:7,0:1,V7@V7:7,V7@Buf8/bitstring>> when V7@V7 =/= 0 ->
{V7@V7,V7@Buf8};
<<_:7,1:1,0:1,V7@V8:14,V7@Buf9/bitstring>> when V7@V8 =/= 0 ->
{V7@V8,V7@Buf9};
<<_:7,1:1,1:1,V7@V8:6,V7@Buf9/bitstring>> when V7@V8 =/= 0 ->
V7@Mul10 = V7@V8 * 16384,
{V7@Mul10,V7@Buf9}
end,
{V7@V3,V7@Buf4}
end,
<<V7@V11:V7@V0/bitstring-unit:1,V7@Buf12/bitstring>> = V7@Buf1,
{V7@V11,V7@Buf12}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'DigitMapValue',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.

enc_DigitMapName(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 2 ->
Enc1@bin
end.


dec_DigitMapName(Bytes) ->
begin
<<V1@V0:2/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv2 = binary_to_list(V1@V0),
{V1@Conv2,V1@Buf1}
end.

enc_DigitMapDescriptor(Val) ->
[begin
Enc1@element = element(2, Val),
Enc2@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
%% attribute digitMapName(1) with type OCTET STRING
Enc3@element = element(2, Val),
if Enc3@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc4@bin = iolist_to_binary(Enc3@element),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 2 ->
Enc4@bin
end
end
end
end|begin
%% attribute digitMapValue(2) with type DigitMapValue
Enc6@element = element(3, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
true ->
enc_DigitMapValue(Enc6@element)
end
end].


dec_DigitMapDescriptor(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:2,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute digitMapName(1) with type OCTET STRING
{Term1,Bytes2} = case (Opt bsr 1) band 1 of
1 ->
begin
<<V2@V0:2/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes1}
end,

%% attribute digitMapValue(2) with type DigitMapValue
{Term2,Bytes3} = case Opt band 1 of
1 ->
dec_DigitMapValue(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,
Res1 = {'DigitMapDescriptor',Term1,Term2},
{Res1,Bytes3}.

enc_ModemType(Val) ->
if Val =:= v18 ->
<<0:1,0:4>>;
Val =:= v22 ->
<<0:1,1:4>>;
Val =:= v22bis ->
<<0:1,2:4>>;
Val =:= v32 ->
<<0:1,3:4>>;
Val =:= v32bis ->
<<0:1,4:4>>;
Val =:= v34 ->
<<0:1,5:4>>;
Val =:= v90 ->
<<0:1,6:4>>;
Val =:= v91 ->
<<0:1,7:4>>;
Val =:= synchISDN ->
<<0:1,8:4>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_ModemType(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:4/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> v18;
1 -> v22;
2 -> v22bis;
3 -> v32;
4 -> v32bis;
5 -> v34;
6 -> v90;
7 -> v91;
8 -> synchISDN;
_ -> exit({error,{asn1,{decode_enumerated,V1@V3}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13};
<<_:V1@Pad9,1:1,1:1,V1@V12:6,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
V1@Mul14 = V1@V12 * 16384,
{V1@Mul14,V1@Buf13}
end,
<<V1@V15:V1@V6/unit:8,V1@Buf16/bitstring>> = V1@Buf7,
{V1@V15,V1@Buf16}
end,
V1@Int17 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int17,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

enc_ModemDescriptor(Val) ->
[begin
Enc1@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
%% attribute mtl(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_ModemDescriptor_mtl(Enc2@element)
end,
begin
%% attribute mpl(2) with type SEQUENCE OF
Enc3@element = element(3, Val),
enc_ModemDescriptor_mpl(Enc3@element)
end|begin
%% attribute nonStandardData(3) with type NonStandardData
Enc4@element = element(4, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
true ->
enc_NonStandardData(Enc4@element)
end
end].
enc_ModemDescriptor_mtl(Val) ->
Enc2@len = length(Val),
if Enc2@len < 128 ->
[align,
Enc2@len|[if Comp =:= v18 ->
<<0:1,0:4>>;
Comp =:= v22 ->
<<0:1,1:4>>;
Comp =:= v22bis ->
<<0:1,2:4>>;
Comp =:= v32 ->
<<0:1,3:4>>;
Comp =:= v32bis ->
<<0:1,4:4>>;
Comp =:= v34 ->
<<0:1,5:4>>;
Comp =:= v90 ->
<<0:1,6:4>>;
Comp =:= v91 ->
<<0:1,7:4>>;
Comp =:= synchISDN ->
<<0:1,8:4>>;
true ->
exit({error,{asn1,{illegal_enumerated,Comp}}})
end || Comp <- Val]];
Enc2@len < 16384 ->
[align,
<<2:2,Enc2@len:14>>|[if Comp =:= v18 ->
<<0:1,0:4>>;
Comp =:= v22 ->
<<0:1,1:4>>;
Comp =:= v22bis ->
<<0:1,2:4>>;
Comp =:= v32 ->
<<0:1,3:4>>;
Comp =:= v32bis ->
<<0:1,4:4>>;
Comp =:= v34 ->
<<0:1,5:4>>;
Comp =:= v90 ->
<<0:1,6:4>>;
Comp =:= v91 ->
<<0:1,7:4>>;
Comp =:= synchISDN ->
<<0:1,8:4>>;
true ->
exit({error,{asn1,{illegal_enumerated,Comp}}})
end || Comp <- Val]];
true ->
begin
Enc2@fn = fun(Comp) -> if Comp =:= v18 ->
<<0:1,0:4>>;
Comp =:= v22 ->
<<0:1,1:4>>;
Comp =:= v22bis ->
<<0:1,2:4>>;
Comp =:= v32 ->
<<0:1,3:4>>;
Comp =:= v32bis ->
<<0:1,4:4>>;
Comp =:= v34 ->
<<0:1,5:4>>;
Comp =:= v90 ->
<<0:1,6:4>>;
Comp =:= v91 ->
<<0:1,7:4>>;
Comp =:= synchISDN ->
<<0:1,8:4>>;
true ->
exit({error,{asn1,{illegal_enumerated,Comp}}})
end end,
encode_fragmented_sof(Enc2@fn, Val, Enc2@len)
end
end.

enc_ModemDescriptor_mpl(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_PropertyParm(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_PropertyParm(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_PropertyParm(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_ModemDescriptor(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute mtl(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_ModemDescriptor_mtl(Bytes1),

%% attribute mpl(2) with type SEQUENCE OF
{Term2,Bytes3} = dec_ModemDescriptor_mpl(Bytes2),

%% attribute nonStandardData(3) with type NonStandardData
{Term3,Bytes4} = case Opt band 1 of
1 ->
dec_NonStandardData(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,
Res1 = {'ModemDescriptor',Term1,Term2,Term3},
{Res1,Bytes4}.


dec_ModemDescriptor_mtl(Bytes) ->
dec_components4(Bytes, []).


dec_ModemDescriptor_mpl(Bytes) ->
dec_components5(Bytes, []).

enc_RequestID(Val) ->
if Val bsr 32 =:= 0 ->
begin
Val@bin = binary:encode_unsigned(Val),
Val@bin_size0 = byte_size(Val@bin),
Val@bin_size = Val@bin_size0 - 1,
[<<Val@bin_size:2>>,
align|Val@bin]
end;
true ->
exit({error,{asn1,{illegal_integer,Val}}})
end.


dec_RequestID(Bytes) ->
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/unsigned-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
{V1@V3,V1@Buf4}
end.

enc_SigParameter(Val) ->
[begin
Enc1@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute sigParameterName(1) with type OCTET STRING
Enc3@element = element(2, Val),
Enc4@bin = iolist_to_binary(Enc3@element),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 2 ->
Enc4@bin
end
end,
begin
%% attribute value(2) with type Value
Enc5@element = element(3, Val),
enc_Value(Enc5@element)
end|begin
%% attribute extraInfo(3) with type CHOICE
Enc6@element = element(4, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
true ->
enc_SigParameter_extraInfo(Enc6@element)
end
end].
enc_SigParameter_extraInfo(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= relation ->
if ChoiceVal =:= greaterThan ->
<<0:2,0:1,0:2>>;
ChoiceVal =:= smallerThan ->
<<0:2,0:1,1:2>>;
ChoiceVal =:= unequalTo ->
<<0:2,0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,ChoiceVal}}})
end;
ChoiceTag =:= range ->
if ChoiceVal =:= false ->
<<1:2,0:1>>;
ChoiceVal =:= true ->
<<1:2,1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,ChoiceVal}}})
end;
ChoiceTag =:= sublist ->
if ChoiceVal =:= false ->
<<2:2,0:1>>;
ChoiceVal =:= true ->
<<2:2,1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,ChoiceVal}}})
end
end.


dec_SigParameter(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute sigParameterName(1) with type OCTET STRING
{Term1,Bytes3} = begin
<<V3@V0:2/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv2 = binary_to_list(V3@V0),
{V3@Conv2,V3@Buf1}
end,

%% attribute value(2) with type Value
{Term2,Bytes4} = dec_Value(Bytes3),

%% attribute extraInfo(3) with type CHOICE
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_SigParameter_extraInfo(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'SigParameter',Term1,Term2,Term3},
{Res1,Bytes7}.


dec_SigParameter_extraInfo(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
{V2@V0,V2@Buf1} = case Bytes1 of
<<0:1,V2@V3:2/unsigned-unit:1,V2@Buf4/bitstring>> ->
V2@Int5 = case V2@V3 of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
_ -> exit({error,{asn1,{decode_enumerated,V2@V3}}})
end,
{V2@Int5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<0:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V6,V2@Buf7};
<<1:1,V2@Buf5/bitstring>> ->
V2@Pad9 = bit_size(V2@Buf5) band 7,
{V2@V6,V2@Buf7} = case V2@Buf5 of
<<_:V2@Pad9,0:1,V2@V11:7,V2@Buf12/bitstring>> when V2@V11 =/= 0 ->
{V2@V11,V2@Buf12};
<<_:V2@Pad9,1:1,0:1,V2@V12:14,V2@Buf13/bitstring>> when V2@V12 =/= 0 ->
{V2@V12,V2@Buf13};
<<_:V2@Pad9,1:1,1:1,V2@V12:6,V2@Buf13/bitstring>> when V2@V12 =/= 0 ->
V2@Mul14 = V2@V12 * 16384,
{V2@Mul14,V2@Buf13}
end,
<<V2@V15:V2@V6/unit:8,V2@Buf16/bitstring>> = V2@Buf7,
{V2@V15,V2@Buf16}
end,
V2@Int17 = case V2@V3 of
_ -> {asn1_enum,V2@V3}
end,
{V2@Int17,V2@Buf4}
end,
{V2@V0,V2@Buf1}
end
end,
{{relation,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
begin
<<V3@V0:1,V3@Buf1/bitstring>> = Bytes1,
V3@Int2 = case V3@V0 of
0 -> false;
1 -> true
end,
{V3@Int2,V3@Buf1}
end
end,
{{range,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
begin
<<V4@V0:1,V4@Buf1/bitstring>> = Bytes1,
V4@Int2 = case V4@V0 of
0 -> false;
1 -> true
end,
{V4@Int2,V4@Buf1}
end
end,
{{sublist,Val},NewBytes}
end.
enc_NotifyCompletion(Val) ->
Enc1@bs = try bit_string_name2pos_6(Val) of
Enc1@positions ->
bitstring_from_positions(Enc1@positions)
catch throw:invalid ->
to_named_bitstring(Val)
end,
Enc1@bits = bit_size(Enc1@bs),
if Enc1@bits < 128 ->
[align,
Enc1@bits|Enc1@bs];
Enc1@bits < 16384 ->
[align,
<<2:2,Enc1@bits:14>>|Enc1@bs];
true ->
[align|encode_fragmented(Enc1@bs, 1)]
end.


dec_NotifyCompletion(Bytes) ->
begin
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@V7:V1@V5/binary-unit:1,V1@Buf8/bitstring>> ->
{V1@V7,V1@Buf8};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@V8:V1@V6/binary-unit:1,V1@Buf9/bitstring>> ->
{V1@V8,V1@Buf9};
<<_:V1@Pad3,1:1,1:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V8,V1@Buf9}  = decode_fragmented(V1@V6, V1@Buf7, 1),
{V1@V8,V1@Buf9}
end,
{V1@V10,V1@Buf11}  = {decode_named_bit_string(V1@V0, [{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}]),V1@Buf1},
{V1@V10,V1@Buf11}
end.

enc_SignalName(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 4 ->
[align|Enc1@bin]
end.


dec_SignalName(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end.

enc_SignalType(Val) ->
if Val =:= brief ->
<<0:1,0:2>>;
Val =:= onOff ->
<<0:1,1:2>>;
Val =:= timeOut ->
<<0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_SignalType(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:2/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> brief;
1 -> onOff;
2 -> timeOut;
_ -> exit({error,{asn1,{decode_enumerated,V1@V3}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13};
<<_:V1@Pad9,1:1,1:1,V1@V12:6,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
V1@Mul14 = V1@V12 * 16384,
{V1@Mul14,V1@Buf13}
end,
<<V1@V15:V1@V6/unit:8,V1@Buf16/bitstring>> = V1@Buf7,
{V1@V15,V1@Buf16}
end,
V1@Int17 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int17,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

enc_Signal(Val) ->
[begin
Enc1@element = element(3, Val),
Enc2@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(5, Val),
Enc4@element = element(6, Val),
if Enc3@element =:= asn1_NOVALUE ->
if Enc4@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc4@element =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc5@element = element(7, Val),
if Enc5@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
%% attribute signalName(1) with type OCTET STRING
Enc7@element = element(2, Val),
Enc8@bin = iolist_to_binary(Enc7@element),
Enc8@len = byte_size(Enc8@bin),
if Enc8@len =:= 4 ->
Enc8@bin
end
end,
begin
%% attribute streamID(2) with type INTEGER
Enc9@element = element(3, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
Enc9@element bsr 16 =:= 0 ->
<<Enc9@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc9@element}}})
end
end,
begin
%% attribute sigType(3) with type ENUMERATED
Enc12@element = element(4, Val),
if Enc12@element =:= asn1_NOVALUE ->
[];
Enc12@element =:= brief ->
<<0:1,0:2>>;
Enc12@element =:= onOff ->
<<0:1,1:2>>;
Enc12@element =:= timeOut ->
<<0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc12@element}}})
end
end,
begin
%% attribute duration(4) with type INTEGER
Enc15@element = element(5, Val),
if Enc15@element =:= asn1_NOVALUE ->
[];
Enc15@element bsr 16 =:= 0 ->
[align|<<Enc15@element:16>>];
true ->
exit({error,{asn1,{illegal_integer,Enc15@element}}})
end
end,
begin
%% attribute notifyCompletion(5) with type BIT STRING
Enc18@element = element(6, Val),
if Enc18@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc19@bs = try bit_string_name2pos_6(Enc18@element) of
Enc19@positions ->
bitstring_from_positions(Enc19@positions)
catch throw:invalid ->
to_named_bitstring(Enc18@element)
end,
Enc19@bits = bit_size(Enc19@bs),
if Enc19@bits < 128 ->
[align,
Enc19@bits|Enc19@bs];
Enc19@bits < 16384 ->
[align,
<<2:2,Enc19@bits:14>>|Enc19@bs];
true ->
[align|encode_fragmented(Enc19@bs, 1)]
end
end
end
end,
begin
%% attribute keepActive(6) with type BOOLEAN
Enc21@element = element(7, Val),
if Enc21@element =:= asn1_NOVALUE ->
[];
Enc21@element =:= false ->
<<0:1>>;
Enc21@element =:= true ->
<<1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,Enc21@element}}})
end
end|begin
%% attribute sigParList(7) with type SEQUENCE OF
Enc24@element = element(8, Val),
enc_Signal_sigParList(Enc24@element)
end].
enc_Signal_sigParList(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_SigParameter(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_SigParameter(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_SigParameter(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_Signal(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:5,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute signalName(1) with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute streamID(2) with type INTEGER
{Term2,Bytes4} = case (Opt bsr 4) band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute sigType(3) with type ENUMERATED
{Term3,Bytes5} = case (Opt bsr 3) band 1 of
1 ->
begin
{V5@V0,V5@Buf1} = case Bytes4 of
<<0:1,V5@V3:2/unsigned-unit:1,V5@Buf4/bitstring>> ->
V5@Int5 = case V5@V3 of
0 -> brief;
1 -> onOff;
2 -> timeOut;
_ -> exit({error,{asn1,{decode_enumerated,V5@V3}}})
end,
{V5@Int5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<0:1,V5@V6:6,V5@Buf7/bitstring>> ->
{V5@V6,V5@Buf7};
<<1:1,V5@Buf5/bitstring>> ->
V5@Pad9 = bit_size(V5@Buf5) band 7,
{V5@V6,V5@Buf7} = case V5@Buf5 of
<<_:V5@Pad9,0:1,V5@V11:7,V5@Buf12/bitstring>> when V5@V11 =/= 0 ->
{V5@V11,V5@Buf12};
<<_:V5@Pad9,1:1,0:1,V5@V12:14,V5@Buf13/bitstring>> when V5@V12 =/= 0 ->
{V5@V12,V5@Buf13};
<<_:V5@Pad9,1:1,1:1,V5@V12:6,V5@Buf13/bitstring>> when V5@V12 =/= 0 ->
V5@Mul14 = V5@V12 * 16384,
{V5@Mul14,V5@Buf13}
end,
<<V5@V15:V5@V6/unit:8,V5@Buf16/bitstring>> = V5@Buf7,
{V5@V15,V5@Buf16}
end,
V5@Int17 = case V5@V3 of
_ -> {asn1_enum,V5@V3}
end,
{V5@Int17,V5@Buf4}
end,
{V5@V0,V5@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute duration(4) with type INTEGER
{Term4,Bytes6} = case (Opt bsr 2) band 1 of
1 ->
begin
V6@Pad2 = bit_size(Bytes5) band 7,
<<_:V6@Pad2,V6@V0:2/unsigned-unit:8,V6@Buf1/bitstring>> = Bytes5,
{V6@V0,V6@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% attribute notifyCompletion(5) with type BIT STRING
{Term5,Bytes7} = case (Opt bsr 1) band 1 of
1 ->
begin
V7@Pad3 = bit_size(Bytes6) band 7,
{V7@V0,V7@Buf1} = case Bytes6 of
<<_:V7@Pad3,0:1,V7@V5:7,V7@V7:V7@V5/binary-unit:1,V7@Buf8/bitstring>> ->
{V7@V7,V7@Buf8};
<<_:V7@Pad3,1:1,0:1,V7@V6:14,V7@V8:V7@V6/binary-unit:1,V7@Buf9/bitstring>> ->
{V7@V8,V7@Buf9};
<<_:V7@Pad3,1:1,1:1,V7@V6:6,V7@Buf7/bitstring>> ->
{V7@V8,V7@Buf9}  = decode_fragmented(V7@V6, V7@Buf7, 1),
{V7@V8,V7@Buf9}
end,
{V7@V10,V7@Buf11}  = {decode_named_bit_string(V7@V0, [{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}]),V7@Buf1},
{V7@V10,V7@Buf11}
end;
0 ->
{asn1_NOVALUE,Bytes6}
end,

%% attribute keepActive(6) with type BOOLEAN
{Term6,Bytes8} = case Opt band 1 of
1 ->
begin
<<V8@V0:1,V8@Buf1/bitstring>> = Bytes7,
V8@Int2 = case V8@V0 of
0 -> false;
1 -> true
end,
{V8@Int2,V8@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes7}
end,

%% attribute sigParList(7) with type SEQUENCE OF
{Term7,Bytes9} = dec_Signal_sigParList(Bytes8),

%% Extensions
{Extensions,Bytes10} = case Ext of
0 -> {<<>>,Bytes9};
1 ->
{V9@V0,V9@Buf1} = case Bytes9 of
<<0:1,V9@V3:6,V9@Buf4/bitstring>> ->
V9@Add5 = V9@V3 + 1,
{V9@Add5,V9@Buf4};
<<1:1,V9@Buf2/bitstring>> ->
V9@Pad6 = bit_size(V9@Buf2) band 7,
{V9@V3,V9@Buf4} = case V9@Buf2 of
<<_:V9@Pad6,0:1,V9@V8:7,V9@Buf9/bitstring>> when V9@V8 =/= 0 ->
{V9@V8,V9@Buf9};
<<_:V9@Pad6,1:1,0:1,V9@V9:14,V9@Buf10/bitstring>> when V9@V9 =/= 0 ->
{V9@V9,V9@Buf10};
<<_:V9@Pad6,1:1,1:1,V9@V9:6,V9@Buf10/bitstring>> when V9@V9 =/= 0 ->
V9@Mul11 = V9@V9 * 16384,
{V9@Mul11,V9@Buf10}
end,
{V9@V3,V9@Buf4}
end,
<<V9@V12:V9@V0/bitstring-unit:1,V9@Buf13/bitstring>> = V9@Buf1,
{V9@V12,V9@Buf13}
end,
Bytes11= skipextensions(Bytes10, 1, Extensions),
Res1 = {'Signal',Term1,Term2,Term3,Term4,Term5,Term6,Term7},
{Res1,Bytes11}.


dec_Signal_sigParList(Bytes) ->
dec_components7(Bytes, []).

enc_SeqSigList(Val) ->
[align,
begin
%% attribute id(1) with type INTEGER
Enc1@element = element(2, Val),
if Enc1@element bsr 16 =:= 0 ->
<<Enc1@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc1@element}}})
end
end|begin
%% attribute signalList(2) with type SEQUENCE OF
Enc3@element = element(3, Val),
enc_SeqSigList_signalList(Enc3@element)
end].
enc_SeqSigList_signalList(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_Signal(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_Signal(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_Signal(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_SeqSigList(Bytes) ->

%% attribute id(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute signalList(2) with type SEQUENCE OF
{Term2,Bytes2} = dec_SeqSigList_signalList(Bytes1),
Res1 = {'SeqSigList',Term1,Term2},
{Res1,Bytes2}.


dec_SeqSigList_signalList(Bytes) ->
dec_components8(Bytes, []).

enc_SignalRequest(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= signal ->
[<<0:1,0:1>>|enc_Signal(ChoiceVal)];
ChoiceTag =:= seqSigList ->
[<<0:1,1:1>>|enc_SeqSigList(ChoiceVal)]
end.


dec_SignalRequest(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_Signal(Bytes2)
end,
{{signal,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_SeqSigList(Bytes2)
end,
{{seqSigList,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_SignalsDescriptor(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_SignalRequest(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_SignalRequest(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_SignalRequest(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_SignalsDescriptor(Bytes) ->
dec_components9(Bytes, []).

enc_EventSpec(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
align,
begin
%% attribute eventName(1) with type OCTET STRING
Enc3@element = element(2, Val),
Enc4@bin = iolist_to_binary(Enc3@element),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 4 ->
Enc4@bin
end
end,
begin
%% attribute streamID(2) with type INTEGER
Enc5@element = element(3, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
Enc5@element bsr 16 =:= 0 ->
<<Enc5@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc5@element}}})
end
end|begin
%% attribute eventParList(3) with type SEQUENCE OF
Enc8@element = element(4, Val),
enc_EventSpec_eventParList(Enc8@element)
end].
enc_EventSpec_eventParList(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_EventParameter(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_EventParameter(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_EventParameter(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_EventSpec(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute eventName(1) with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute streamID(2) with type INTEGER
{Term2,Bytes4} = case Opt band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute eventParList(3) with type SEQUENCE OF
{Term3,Bytes5} = dec_EventSpec_eventParList(Bytes4),

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V5@V0,V5@Buf1} = case Bytes5 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10};
<<_:V5@Pad6,1:1,1:1,V5@V9:6,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
V5@Mul11 = V5@V9 * 16384,
{V5@Mul11,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V12:V5@V0/bitstring-unit:1,V5@Buf13/bitstring>> = V5@Buf1,
{V5@V12,V5@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'EventSpec',Term1,Term2,Term3},
{Res1,Bytes7}.


dec_EventSpec_eventParList(Bytes) ->
dec_components10(Bytes, []).

enc_EventBufferDescriptor(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_EventSpec(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_EventSpec(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_EventSpec(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_EventBufferDescriptor(Bytes) ->
dec_components11(Bytes, []).

enc_SecondRequestedActions(Val) ->
[begin
Enc1@element = element(2, Val),
Enc2@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(4, Val),
%% attribute keepActive(1) with type BOOLEAN
Enc5@element = element(2, Val),
if Enc3@element =:= asn1_NOVALUE ->
if Enc5@element =:= asn1_NOVALUE ->
<<0:1>>;
Enc5@element =:= false ->
<<0:1,0:1>>;
Enc5@element =:= true ->
<<0:1,1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,Enc5@element}}})
end;
true ->
if Enc5@element =:= asn1_NOVALUE ->
<<1:1>>;
Enc5@element =:= false ->
<<1:1,0:1>>;
Enc5@element =:= true ->
<<1:1,1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,Enc5@element}}})
end
end
end,
begin
%% attribute eventDM(2) with type EventDM
Enc8@element = element(3, Val),
if Enc8@element =:= asn1_NOVALUE ->
[];
true ->
enc_EventDM(Enc8@element)
end
end|begin
%% attribute signalsDescriptor(3) with type SignalsDescriptor
Enc10@element = element(4, Val),
if Enc10@element =:= asn1_NOVALUE ->
[];
true ->
enc_SignalsDescriptor(Enc10@element)
end
end].


dec_SecondRequestedActions(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute keepActive(1) with type BOOLEAN
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
begin
<<V3@V0:1,V3@Buf1/bitstring>> = Bytes2,
V3@Int2 = case V3@V0 of
0 -> false;
1 -> true
end,
{V3@Int2,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute eventDM(2) with type EventDM
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
dec_EventDM(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute signalsDescriptor(3) with type SignalsDescriptor
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_SignalsDescriptor(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'SecondRequestedActions',Term1,Term2,Term3},
{Res1,Bytes7}.

enc_SecondRequestedEvent(Val) ->
[begin
Enc1@element = element(3, Val),
Enc2@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
align,
begin
%% attribute pkgdName(1) with type OCTET STRING
Enc4@element = element(2, Val),
Enc5@bin = iolist_to_binary(Enc4@element),
Enc5@len = byte_size(Enc5@bin),
if Enc5@len =:= 4 ->
Enc5@bin
end
end,
begin
%% attribute streamID(2) with type INTEGER
Enc6@element = element(3, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
Enc6@element bsr 16 =:= 0 ->
<<Enc6@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc6@element}}})
end
end,
begin
%% attribute eventAction(3) with type SecondRequestedActions
Enc9@element = element(4, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
enc_SecondRequestedActions(Enc9@element)
end
end|begin
%% attribute evParList(4) with type SEQUENCE OF
Enc11@element = element(5, Val),
enc_SecondRequestedEvent_evParList(Enc11@element)
end].
enc_SecondRequestedEvent_evParList(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_EventParameter(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_EventParameter(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_EventParameter(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_SecondRequestedEvent(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute pkgdName(1) with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute streamID(2) with type INTEGER
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute eventAction(3) with type SecondRequestedActions
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_SecondRequestedActions(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute evParList(4) with type SEQUENCE OF
{Term4,Bytes6} = dec_SecondRequestedEvent_evParList(Bytes5),

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V5@V0,V5@Buf1} = case Bytes6 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10};
<<_:V5@Pad6,1:1,1:1,V5@V9:6,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
V5@Mul11 = V5@V9 * 16384,
{V5@Mul11,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V12:V5@V0/bitstring-unit:1,V5@Buf13/bitstring>> = V5@Buf1,
{V5@V12,V5@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'SecondRequestedEvent',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.


dec_SecondRequestedEvent_evParList(Bytes) ->
dec_components12(Bytes, []).

enc_SecondEventsDescriptor(Val) ->
[begin
%% attribute requestID(1) with type INTEGER
Enc2@element = element(2, Val),
if Enc2@element bsr 32 =:= 0 ->
[<<0:1>>|begin
Enc2@element@bin = binary:encode_unsigned(Enc2@element),
Enc2@element@bin_size0 = byte_size(Enc2@element@bin),
Enc2@element@bin_size = Enc2@element@bin_size0 - 1,
[<<Enc2@element@bin_size:2>>,
align|Enc2@element@bin]
end];
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end|begin
%% attribute eventList(2) with type SEQUENCE OF
Enc4@element = element(3, Val),
enc_SecondEventsDescriptor_eventList(Enc4@element)
end].
enc_SecondEventsDescriptor_eventList(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_SecondRequestedEvent(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_SecondRequestedEvent(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_SecondRequestedEvent(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_SecondEventsDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute requestID(1) with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% attribute eventList(2) with type SEQUENCE OF
{Term2,Bytes3} = dec_SecondEventsDescriptor_eventList(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V3@V0,V3@Buf1} = case Bytes3 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V12:V3@V0/bitstring-unit:1,V3@Buf13/bitstring>> = V3@Buf1,
{V3@V12,V3@Buf13}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
Res1 = {'SecondEventsDescriptor',Term1,Term2},
{Res1,Bytes5}.


dec_SecondEventsDescriptor_eventList(Bytes) ->
dec_components13(Bytes, []).

enc_EventDM(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= digitMapName ->
begin
Enc2@bin = iolist_to_binary(ChoiceVal),
Enc2@len = byte_size(Enc2@bin),
if Enc2@len =:= 2 ->
[<<0:1>>|Enc2@bin]
end
end;
ChoiceTag =:= digitMapValue ->
[<<1:1>>|enc_DigitMapValue(ChoiceVal)]
end.


dec_EventDM(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
<<V2@V0:2/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end
end,
{{digitMapName,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_DigitMapValue(Bytes1)
end,
{{digitMapValue,Val},NewBytes}
end.
enc_RequestedActions(Val) ->
[begin
Enc1@element = element(2, Val),
Enc2@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(4, Val),
Enc4@element = element(5, Val),
if Enc3@element =:= asn1_NOVALUE ->
if Enc4@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc4@element =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
%% attribute keepActive(1) with type BOOLEAN
Enc6@element = element(2, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
Enc6@element =:= false ->
<<0:1>>;
Enc6@element =:= true ->
<<1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,Enc6@element}}})
end
end,
begin
%% attribute eventDM(2) with type EventDM
Enc9@element = element(3, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
enc_EventDM(Enc9@element)
end
end,
begin
%% attribute secondEvent(3) with type SecondEventsDescriptor
Enc11@element = element(4, Val),
if Enc11@element =:= asn1_NOVALUE ->
[];
true ->
enc_SecondEventsDescriptor(Enc11@element)
end
end|begin
%% attribute signalsDescriptor(4) with type SignalsDescriptor
Enc13@element = element(5, Val),
if Enc13@element =:= asn1_NOVALUE ->
[];
true ->
enc_SignalsDescriptor(Enc13@element)
end
end].


dec_RequestedActions(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:4,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute keepActive(1) with type BOOLEAN
{Term1,Bytes3} = case (Opt bsr 3) band 1 of
1 ->
begin
<<V3@V0:1,V3@Buf1/bitstring>> = Bytes2,
V3@Int2 = case V3@V0 of
0 -> false;
1 -> true
end,
{V3@Int2,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute eventDM(2) with type EventDM
{Term2,Bytes4} = case (Opt bsr 2) band 1 of
1 ->
dec_EventDM(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute secondEvent(3) with type SecondEventsDescriptor
{Term3,Bytes5} = case (Opt bsr 1) band 1 of
1 ->
dec_SecondEventsDescriptor(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute signalsDescriptor(4) with type SignalsDescriptor
{Term4,Bytes6} = case Opt band 1 of
1 ->
dec_SignalsDescriptor(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V4@V0,V4@Buf1} = case Bytes6 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'RequestedActions',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.

enc_RequestedEvent(Val) ->
[begin
Enc1@element = element(3, Val),
Enc2@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
align,
begin
%% attribute pkgdName(1) with type OCTET STRING
Enc4@element = element(2, Val),
Enc5@bin = iolist_to_binary(Enc4@element),
Enc5@len = byte_size(Enc5@bin),
if Enc5@len =:= 4 ->
Enc5@bin
end
end,
begin
%% attribute streamID(2) with type INTEGER
Enc6@element = element(3, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
Enc6@element bsr 16 =:= 0 ->
<<Enc6@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc6@element}}})
end
end,
begin
%% attribute eventAction(3) with type RequestedActions
Enc9@element = element(4, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
enc_RequestedActions(Enc9@element)
end
end|begin
%% attribute evParList(4) with type SEQUENCE OF
Enc11@element = element(5, Val),
enc_RequestedEvent_evParList(Enc11@element)
end].
enc_RequestedEvent_evParList(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_EventParameter(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_EventParameter(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_EventParameter(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_RequestedEvent(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute pkgdName(1) with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute streamID(2) with type INTEGER
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute eventAction(3) with type RequestedActions
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_RequestedActions(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute evParList(4) with type SEQUENCE OF
{Term4,Bytes6} = dec_RequestedEvent_evParList(Bytes5),

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V5@V0,V5@Buf1} = case Bytes6 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10};
<<_:V5@Pad6,1:1,1:1,V5@V9:6,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
V5@Mul11 = V5@V9 * 16384,
{V5@Mul11,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V12:V5@V0/bitstring-unit:1,V5@Buf13/bitstring>> = V5@Buf1,
{V5@V12,V5@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'RequestedEvent',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.


dec_RequestedEvent_evParList(Bytes) ->
dec_components14(Bytes, []).

enc_EventsDescriptor(Val) ->
[begin
%% attribute requestID(1) with type INTEGER
Enc2@element = element(2, Val),
if Enc2@element bsr 32 =:= 0 ->
[<<0:1>>|begin
Enc2@element@bin = binary:encode_unsigned(Enc2@element),
Enc2@element@bin_size0 = byte_size(Enc2@element@bin),
Enc2@element@bin_size = Enc2@element@bin_size0 - 1,
[<<Enc2@element@bin_size:2>>,
align|Enc2@element@bin]
end];
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end|begin
%% attribute eventList(2) with type SEQUENCE OF
Enc4@element = element(3, Val),
enc_EventsDescriptor_eventList(Enc4@element)
end].
enc_EventsDescriptor_eventList(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_RequestedEvent(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_RequestedEvent(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_RequestedEvent(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_EventsDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute requestID(1) with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% attribute eventList(2) with type SEQUENCE OF
{Term2,Bytes3} = dec_EventsDescriptor_eventList(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V3@V0,V3@Buf1} = case Bytes3 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V12:V3@V0/bitstring-unit:1,V3@Buf13/bitstring>> = V3@Buf1,
{V3@V12,V3@Buf13}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
Res1 = {'EventsDescriptor',Term1,Term2},
{Res1,Bytes5}.


dec_EventsDescriptor_eventList(Bytes) ->
dec_components15(Bytes, []).

enc_StreamID(Val) ->
if Val bsr 16 =:= 0 ->
[align|<<Val:16>>];
true ->
exit({error,{asn1,{illegal_integer,Val}}})
end.


dec_StreamID(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end.

enc_MuxType(Val) ->
if Val =:= h221 ->
<<0:1,0:2>>;
Val =:= h223 ->
<<0:1,1:2>>;
Val =:= h226 ->
<<0:1,2:2>>;
Val =:= v76 ->
<<0:1,3:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_MuxType(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:2/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> h221;
1 -> h223;
2 -> h226;
3 -> v76
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13};
<<_:V1@Pad9,1:1,1:1,V1@V12:6,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
V1@Mul14 = V1@V12 * 16384,
{V1@Mul14,V1@Buf13}
end,
<<V1@V15:V1@V6/unit:8,V1@Buf16/bitstring>> = V1@Buf7,
{V1@V15,V1@Buf16}
end,
V1@Int17 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int17,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

enc_MuxDescriptor(Val) ->
[begin
Enc1@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute muxType(1) with type ENUMERATED
Enc3@element = element(2, Val),
if Enc3@element =:= h221 ->
<<0:1,0:2>>;
Enc3@element =:= h223 ->
<<0:1,1:2>>;
Enc3@element =:= h226 ->
<<0:1,2:2>>;
Enc3@element =:= v76 ->
<<0:1,3:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc3@element}}})
end
end,
begin
%% attribute termList(2) with type SEQUENCE OF
Enc5@element = element(3, Val),
enc_MuxDescriptor_termList(Enc5@element)
end|begin
%% attribute nonStandardData(3) with type NonStandardData
Enc6@element = element(4, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
true ->
enc_NonStandardData(Enc6@element)
end
end].
enc_MuxDescriptor_termList(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_TerminationID(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_TerminationID(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_TerminationID(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_MuxDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute muxType(1) with type ENUMERATED
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:2/unsigned-unit:1,V3@Buf4/bitstring>> ->
V3@Int5 = case V3@V3 of
0 -> h221;
1 -> h223;
2 -> h226;
3 -> v76
end,
{V3@Int5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<0:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V6,V3@Buf7};
<<1:1,V3@Buf5/bitstring>> ->
V3@Pad9 = bit_size(V3@Buf5) band 7,
{V3@V6,V3@Buf7} = case V3@Buf5 of
<<_:V3@Pad9,0:1,V3@V11:7,V3@Buf12/bitstring>> when V3@V11 =/= 0 ->
{V3@V11,V3@Buf12};
<<_:V3@Pad9,1:1,0:1,V3@V12:14,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
{V3@V12,V3@Buf13};
<<_:V3@Pad9,1:1,1:1,V3@V12:6,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
V3@Mul14 = V3@V12 * 16384,
{V3@Mul14,V3@Buf13}
end,
<<V3@V15:V3@V6/unit:8,V3@Buf16/bitstring>> = V3@Buf7,
{V3@V15,V3@Buf16}
end,
V3@Int17 = case V3@V3 of
_ -> {asn1_enum,V3@V3}
end,
{V3@Int17,V3@Buf4}
end,
{V3@V0,V3@Buf1}
end,

%% attribute termList(2) with type SEQUENCE OF
{Term2,Bytes4} = dec_MuxDescriptor_termList(Bytes3),

%% attribute nonStandardData(3) with type NonStandardData
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_NonStandardData(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'MuxDescriptor',Term1,Term2,Term3},
{Res1,Bytes7}.


dec_MuxDescriptor_termList(Bytes) ->
dec_components16(Bytes, []).

enc_ServiceState(Val) ->
if Val =:= test ->
<<0:1,0:2>>;
Val =:= outOfSvc ->
<<0:1,1:2>>;
Val =:= inSvc ->
<<0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_ServiceState(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:2/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> test;
1 -> outOfSvc;
2 -> inSvc;
_ -> exit({error,{asn1,{decode_enumerated,V1@V3}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13};
<<_:V1@Pad9,1:1,1:1,V1@V12:6,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
V1@Mul14 = V1@V12 * 16384,
{V1@Mul14,V1@Buf13}
end,
<<V1@V15:V1@V6/unit:8,V1@Buf16/bitstring>> = V1@Buf7,
{V1@V15,V1@Buf16}
end,
V1@Int17 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int17,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

enc_EventBufferControl(Val) ->
if Val =:= off ->
<<0:1,0:1>>;
Val =:= lockStep ->
<<0:1,1:1>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_EventBufferControl(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:1/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> off;
1 -> lockStep
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13};
<<_:V1@Pad9,1:1,1:1,V1@V12:6,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
V1@Mul14 = V1@V12 * 16384,
{V1@Mul14,V1@Buf13}
end,
<<V1@V15:V1@V6/unit:8,V1@Buf16/bitstring>> = V1@Buf7,
{V1@V15,V1@Buf16}
end,
V1@Int17 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int17,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

enc_TerminationStateDescriptor(Val) ->
[begin
Enc1@element = element(3, Val),
Enc2@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
%% attribute propertyParms(1) with type SEQUENCE OF
Enc4@element = element(2, Val),
enc_TerminationStateDescriptor_propertyParms(Enc4@element)
end,
begin
%% attribute eventBufferControl(2) with type ENUMERATED
Enc5@element = element(3, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
Enc5@element =:= off ->
<<0:1,0:1>>;
Enc5@element =:= lockStep ->
<<0:1,1:1>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc5@element}}})
end
end|begin
%% attribute serviceState(3) with type ENUMERATED
Enc8@element = element(4, Val),
if Enc8@element =:= asn1_NOVALUE ->
[];
Enc8@element =:= test ->
<<0:1,0:2>>;
Enc8@element =:= outOfSvc ->
<<0:1,1:2>>;
Enc8@element =:= inSvc ->
<<0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc8@element}}})
end
end].
enc_TerminationStateDescriptor_propertyParms(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_PropertyParm(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_PropertyParm(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_PropertyParm(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_TerminationStateDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute propertyParms(1) with type SEQUENCE OF
{Term1,Bytes3} = dec_TerminationStateDescriptor_propertyParms(Bytes2),

%% attribute eventBufferControl(2) with type ENUMERATED
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
{V3@V0,V3@Buf1} = case Bytes3 of
<<0:1,V3@V3:1/unsigned-unit:1,V3@Buf4/bitstring>> ->
V3@Int5 = case V3@V3 of
0 -> off;
1 -> lockStep
end,
{V3@Int5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<0:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V6,V3@Buf7};
<<1:1,V3@Buf5/bitstring>> ->
V3@Pad9 = bit_size(V3@Buf5) band 7,
{V3@V6,V3@Buf7} = case V3@Buf5 of
<<_:V3@Pad9,0:1,V3@V11:7,V3@Buf12/bitstring>> when V3@V11 =/= 0 ->
{V3@V11,V3@Buf12};
<<_:V3@Pad9,1:1,0:1,V3@V12:14,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
{V3@V12,V3@Buf13};
<<_:V3@Pad9,1:1,1:1,V3@V12:6,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
V3@Mul14 = V3@V12 * 16384,
{V3@Mul14,V3@Buf13}
end,
<<V3@V15:V3@V6/unit:8,V3@Buf16/bitstring>> = V3@Buf7,
{V3@V15,V3@Buf16}
end,
V3@Int17 = case V3@V3 of
_ -> {asn1_enum,V3@V3}
end,
{V3@Int17,V3@Buf4}
end,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute serviceState(3) with type ENUMERATED
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
{V4@V0,V4@Buf1} = case Bytes4 of
<<0:1,V4@V3:2/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Int5 = case V4@V3 of
0 -> test;
1 -> outOfSvc;
2 -> inSvc;
_ -> exit({error,{asn1,{decode_enumerated,V4@V3}}})
end,
{V4@Int5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<0:1,V4@V6:6,V4@Buf7/bitstring>> ->
{V4@V6,V4@Buf7};
<<1:1,V4@Buf5/bitstring>> ->
V4@Pad9 = bit_size(V4@Buf5) band 7,
{V4@V6,V4@Buf7} = case V4@Buf5 of
<<_:V4@Pad9,0:1,V4@V11:7,V4@Buf12/bitstring>> when V4@V11 =/= 0 ->
{V4@V11,V4@Buf12};
<<_:V4@Pad9,1:1,0:1,V4@V12:14,V4@Buf13/bitstring>> when V4@V12 =/= 0 ->
{V4@V12,V4@Buf13};
<<_:V4@Pad9,1:1,1:1,V4@V12:6,V4@Buf13/bitstring>> when V4@V12 =/= 0 ->
V4@Mul14 = V4@V12 * 16384,
{V4@Mul14,V4@Buf13}
end,
<<V4@V15:V4@V6/unit:8,V4@Buf16/bitstring>> = V4@Buf7,
{V4@V15,V4@Buf16}
end,
V4@Int17 = case V4@V3 of
_ -> {asn1_enum,V4@V3}
end,
{V4@Int17,V4@Buf4}
end,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V5@V0,V5@Buf1} = case Bytes5 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10};
<<_:V5@Pad6,1:1,1:1,V5@V9:6,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
V5@Mul11 = V5@V9 * 16384,
{V5@Mul11,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V12:V5@V0/bitstring-unit:1,V5@Buf13/bitstring>> = V5@Buf1,
{V5@V12,V5@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'TerminationStateDescriptor',Term1,Term2,Term3},
{Res1,Bytes7}.


dec_TerminationStateDescriptor_propertyParms(Bytes) ->
dec_components17(Bytes, []).

enc_PropertyGroup(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_PropertyParm(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_PropertyParm(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_PropertyParm(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_PropertyGroup(Bytes) ->
dec_components18(Bytes, []).

enc_LocalRemoteDescriptor(Val) ->
[<<0:1>>|begin
%% attribute propGrps(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_LocalRemoteDescriptor_propGrps(Enc2@element)
end].
enc_LocalRemoteDescriptor_propGrps(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_PropertyGroup(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_PropertyGroup(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_PropertyGroup(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_LocalRemoteDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute propGrps(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_LocalRemoteDescriptor_propGrps(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'LocalRemoteDescriptor',Term1},
{Res1,Bytes4}.


dec_LocalRemoteDescriptor_propGrps(Bytes) ->
dec_components19(Bytes, []).

enc_Relation(Val) ->
if Val =:= greaterThan ->
<<0:1,0:2>>;
Val =:= smallerThan ->
<<0:1,1:2>>;
Val =:= unequalTo ->
<<0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_Relation(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:2/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
_ -> exit({error,{asn1,{decode_enumerated,V1@V3}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13};
<<_:V1@Pad9,1:1,1:1,V1@V12:6,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
V1@Mul14 = V1@V12 * 16384,
{V1@Mul14,V1@Buf13}
end,
<<V1@V15:V1@V6/unit:8,V1@Buf16/bitstring>> = V1@Buf7,
{V1@V15,V1@Buf16}
end,
V1@Int17 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int17,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

enc_PkgdName(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 4 ->
[align|Enc1@bin]
end.


dec_PkgdName(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end.

enc_Name(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 2 ->
Enc1@bin
end.


dec_Name(Bytes) ->
begin
<<V1@V0:2/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv2 = binary_to_list(V1@V0),
{V1@Conv2,V1@Buf1}
end.

enc_PropertyParm(Val) ->
[begin
Enc1@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
align,
begin
%% attribute name(1) with type OCTET STRING
Enc3@element = element(2, Val),
Enc4@bin = iolist_to_binary(Enc3@element),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 4 ->
Enc4@bin
end
end,
begin
%% attribute value(2) with type SEQUENCE OF
Enc5@element = element(3, Val),
enc_PropertyParm_value(Enc5@element)
end|begin
%% attribute extraInfo(3) with type CHOICE
Enc6@element = element(4, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
true ->
enc_PropertyParm_extraInfo(Enc6@element)
end
end].
enc_PropertyParm_value(Val) ->
Enc2@len = length(Val),
if Enc2@len < 128 ->
[align,
Enc2@len|[begin
Enc1@bin = iolist_to_binary(Comp),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len < 128 ->
[align,
Enc1@len,
align|Enc1@bin];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>,
align|Enc1@bin];
true ->
[align|encode_fragmented(Enc1@bin, 8)]
end
end || Comp <- Val]];
Enc2@len < 16384 ->
[align,
<<2:2,Enc2@len:14>>|[begin
Enc1@bin = iolist_to_binary(Comp),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len < 128 ->
[align,
Enc1@len,
align|Enc1@bin];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>,
align|Enc1@bin];
true ->
[align|encode_fragmented(Enc1@bin, 8)]
end
end || Comp <- Val]];
true ->
begin
Enc2@fn = fun(Comp) -> begin
Enc1@bin = iolist_to_binary(Comp),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len < 128 ->
[align,
Enc1@len,
align|Enc1@bin];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>,
align|Enc1@bin];
true ->
[align|encode_fragmented(Enc1@bin, 8)]
end
end end,
encode_fragmented_sof(Enc2@fn, Val, Enc2@len)
end
end.

enc_PropertyParm_extraInfo(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= relation ->
if ChoiceVal =:= greaterThan ->
<<0:2,0:1,0:2>>;
ChoiceVal =:= smallerThan ->
<<0:2,0:1,1:2>>;
ChoiceVal =:= unequalTo ->
<<0:2,0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,ChoiceVal}}})
end;
ChoiceTag =:= range ->
if ChoiceVal =:= false ->
<<1:2,0:1>>;
ChoiceVal =:= true ->
<<1:2,1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,ChoiceVal}}})
end;
ChoiceTag =:= sublist ->
if ChoiceVal =:= false ->
<<2:2,0:1>>;
ChoiceVal =:= true ->
<<2:2,1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,ChoiceVal}}})
end
end.


dec_PropertyParm(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute name(1) with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute value(2) with type SEQUENCE OF
{Term2,Bytes4} = dec_PropertyParm_value(Bytes3),

%% attribute extraInfo(3) with type CHOICE
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_PropertyParm_extraInfo(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'PropertyParm',Term1,Term2,Term3},
{Res1,Bytes7}.


dec_PropertyParm_value(Bytes) ->
dec_components20(Bytes, []).


dec_PropertyParm_extraInfo(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
{V2@V0,V2@Buf1} = case Bytes1 of
<<0:1,V2@V3:2/unsigned-unit:1,V2@Buf4/bitstring>> ->
V2@Int5 = case V2@V3 of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
_ -> exit({error,{asn1,{decode_enumerated,V2@V3}}})
end,
{V2@Int5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<0:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V6,V2@Buf7};
<<1:1,V2@Buf5/bitstring>> ->
V2@Pad9 = bit_size(V2@Buf5) band 7,
{V2@V6,V2@Buf7} = case V2@Buf5 of
<<_:V2@Pad9,0:1,V2@V11:7,V2@Buf12/bitstring>> when V2@V11 =/= 0 ->
{V2@V11,V2@Buf12};
<<_:V2@Pad9,1:1,0:1,V2@V12:14,V2@Buf13/bitstring>> when V2@V12 =/= 0 ->
{V2@V12,V2@Buf13};
<<_:V2@Pad9,1:1,1:1,V2@V12:6,V2@Buf13/bitstring>> when V2@V12 =/= 0 ->
V2@Mul14 = V2@V12 * 16384,
{V2@Mul14,V2@Buf13}
end,
<<V2@V15:V2@V6/unit:8,V2@Buf16/bitstring>> = V2@Buf7,
{V2@V15,V2@Buf16}
end,
V2@Int17 = case V2@V3 of
_ -> {asn1_enum,V2@V3}
end,
{V2@Int17,V2@Buf4}
end,
{V2@V0,V2@Buf1}
end
end,
{{relation,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
begin
<<V3@V0:1,V3@Buf1/bitstring>> = Bytes1,
V3@Int2 = case V3@V0 of
0 -> false;
1 -> true
end,
{V3@Int2,V3@Buf1}
end
end,
{{range,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
begin
<<V4@V0:1,V4@Buf1/bitstring>> = Bytes1,
V4@Int2 = case V4@V0 of
0 -> false;
1 -> true
end,
{V4@Int2,V4@Buf1}
end
end,
{{sublist,Val},NewBytes}
end.
enc_StreamMode(Val) ->
if Val =:= sendOnly ->
<<0:1,0:3>>;
Val =:= recvOnly ->
<<0:1,1:3>>;
Val =:= sendRecv ->
<<0:1,2:3>>;
Val =:= inactive ->
<<0:1,3:3>>;
Val =:= loopBack ->
<<0:1,4:3>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_StreamMode(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:3/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> sendOnly;
1 -> recvOnly;
2 -> sendRecv;
3 -> inactive;
4 -> loopBack;
_ -> exit({error,{asn1,{decode_enumerated,V1@V3}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13};
<<_:V1@Pad9,1:1,1:1,V1@V12:6,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
V1@Mul14 = V1@V12 * 16384,
{V1@Mul14,V1@Buf13}
end,
<<V1@V15:V1@V6/unit:8,V1@Buf16/bitstring>> = V1@Buf7,
{V1@V15,V1@Buf16}
end,
V1@Int17 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int17,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

enc_LocalControlDescriptor(Val) ->
[begin
Enc1@element = element(2, Val),
Enc2@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(4, Val),
if Enc3@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
%% attribute streamMode(1) with type ENUMERATED
Enc5@element = element(2, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
Enc5@element =:= sendOnly ->
<<0:1,0:3>>;
Enc5@element =:= recvOnly ->
<<0:1,1:3>>;
Enc5@element =:= sendRecv ->
<<0:1,2:3>>;
Enc5@element =:= inactive ->
<<0:1,3:3>>;
Enc5@element =:= loopBack ->
<<0:1,4:3>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc5@element}}})
end
end,
begin
%% attribute reserveValue(2) with type BOOLEAN
Enc8@element = element(3, Val),
if Enc8@element =:= asn1_NOVALUE ->
[];
Enc8@element =:= false ->
<<0:1>>;
Enc8@element =:= true ->
<<1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,Enc8@element}}})
end
end,
begin
%% attribute reserveGroup(3) with type BOOLEAN
Enc11@element = element(4, Val),
if Enc11@element =:= asn1_NOVALUE ->
[];
Enc11@element =:= false ->
<<0:1>>;
Enc11@element =:= true ->
<<1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,Enc11@element}}})
end
end|begin
%% attribute propertyParms(4) with type SEQUENCE OF
Enc14@element = element(5, Val),
enc_LocalControlDescriptor_propertyParms(Enc14@element)
end].
enc_LocalControlDescriptor_propertyParms(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_PropertyParm(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_PropertyParm(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_PropertyParm(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_LocalControlDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute streamMode(1) with type ENUMERATED
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:3/unsigned-unit:1,V3@Buf4/bitstring>> ->
V3@Int5 = case V3@V3 of
0 -> sendOnly;
1 -> recvOnly;
2 -> sendRecv;
3 -> inactive;
4 -> loopBack;
_ -> exit({error,{asn1,{decode_enumerated,V3@V3}}})
end,
{V3@Int5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<0:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V6,V3@Buf7};
<<1:1,V3@Buf5/bitstring>> ->
V3@Pad9 = bit_size(V3@Buf5) band 7,
{V3@V6,V3@Buf7} = case V3@Buf5 of
<<_:V3@Pad9,0:1,V3@V11:7,V3@Buf12/bitstring>> when V3@V11 =/= 0 ->
{V3@V11,V3@Buf12};
<<_:V3@Pad9,1:1,0:1,V3@V12:14,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
{V3@V12,V3@Buf13};
<<_:V3@Pad9,1:1,1:1,V3@V12:6,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
V3@Mul14 = V3@V12 * 16384,
{V3@Mul14,V3@Buf13}
end,
<<V3@V15:V3@V6/unit:8,V3@Buf16/bitstring>> = V3@Buf7,
{V3@V15,V3@Buf16}
end,
V3@Int17 = case V3@V3 of
_ -> {asn1_enum,V3@V3}
end,
{V3@Int17,V3@Buf4}
end,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute reserveValue(2) with type BOOLEAN
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
<<V4@V0:1,V4@Buf1/bitstring>> = Bytes3,
V4@Int2 = case V4@V0 of
0 -> false;
1 -> true
end,
{V4@Int2,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute reserveGroup(3) with type BOOLEAN
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
<<V5@V0:1,V5@Buf1/bitstring>> = Bytes4,
V5@Int2 = case V5@V0 of
0 -> false;
1 -> true
end,
{V5@Int2,V5@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute propertyParms(4) with type SEQUENCE OF
{Term4,Bytes6} = dec_LocalControlDescriptor_propertyParms(Bytes5),

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V6@V0,V6@Buf1} = case Bytes6 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
V6@Mul11 = V6@V9 * 16384,
{V6@Mul11,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V12:V6@V0/bitstring-unit:1,V6@Buf13/bitstring>> = V6@Buf1,
{V6@V12,V6@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'LocalControlDescriptor',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.


dec_LocalControlDescriptor_propertyParms(Bytes) ->
dec_components21(Bytes, []).

enc_StreamParms(Val) ->
[begin
Enc1@element = element(2, Val),
Enc2@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(4, Val),
if Enc3@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
%% attribute localControlDescriptor(1) with type LocalControlDescriptor
Enc5@element = element(2, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
true ->
enc_LocalControlDescriptor(Enc5@element)
end
end,
begin
%% attribute localDescriptor(2) with type LocalRemoteDescriptor
Enc7@element = element(3, Val),
if Enc7@element =:= asn1_NOVALUE ->
[];
true ->
enc_LocalRemoteDescriptor(Enc7@element)
end
end|begin
%% attribute remoteDescriptor(3) with type LocalRemoteDescriptor
Enc9@element = element(4, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
enc_LocalRemoteDescriptor(Enc9@element)
end
end].


dec_StreamParms(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute localControlDescriptor(1) with type LocalControlDescriptor
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
dec_LocalControlDescriptor(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute localDescriptor(2) with type LocalRemoteDescriptor
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
dec_LocalRemoteDescriptor(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute remoteDescriptor(3) with type LocalRemoteDescriptor
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_LocalRemoteDescriptor(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V3@V0,V3@Buf1} = case Bytes5 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V12:V3@V0/bitstring-unit:1,V3@Buf13/bitstring>> = V3@Buf1,
{V3@V12,V3@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'StreamParms',Term1,Term2,Term3},
{Res1,Bytes7}.

enc_StreamDescriptor(Val) ->
[align,
begin
%% attribute streamID(1) with type INTEGER
Enc1@element = element(2, Val),
if Enc1@element bsr 16 =:= 0 ->
<<Enc1@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc1@element}}})
end
end|begin
%% attribute streamParms(2) with type StreamParms
Enc3@element = element(3, Val),
enc_StreamParms(Enc3@element)
end].


dec_StreamDescriptor(Bytes) ->

%% attribute streamID(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute streamParms(2) with type StreamParms
{Term2,Bytes2} = dec_StreamParms(Bytes1),
Res1 = {'StreamDescriptor',Term1,Term2},
{Res1,Bytes2}.

enc_MediaDescriptor(Val) ->
[begin
Enc1@element = element(2, Val),
Enc2@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
%% attribute termStateDescr(1) with type TerminationStateDescriptor
Enc4@element = element(2, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
true ->
enc_TerminationStateDescriptor(Enc4@element)
end
end|begin
%% attribute streams(2) with type CHOICE
Enc6@element = element(3, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
true ->
enc_MediaDescriptor_streams(Enc6@element)
end
end].
enc_MediaDescriptor_streams(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= oneStream ->
[<<0:1>>|enc_StreamParms(ChoiceVal)];
ChoiceTag =:= multiStream ->
[<<1:1>>|enc_MediaDescriptor_streams_multiStream(ChoiceVal)]
end.
enc_MediaDescriptor_streams_multiStream(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_StreamDescriptor(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_StreamDescriptor(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_StreamDescriptor(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_MediaDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute termStateDescr(1) with type TerminationStateDescriptor
{Term1,Bytes3} = case (Opt bsr 1) band 1 of
1 ->
dec_TerminationStateDescriptor(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute streams(2) with type CHOICE
{Term2,Bytes4} = case Opt band 1 of
1 ->
dec_MediaDescriptor_streams(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V12:V3@V0/bitstring-unit:1,V3@Buf13/bitstring>> = V3@Buf1,
{V3@V12,V3@Buf13}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
Res1 = {'MediaDescriptor',Term1,Term2},
{Res1,Bytes6}.


dec_MediaDescriptor_streams(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_StreamParms(Bytes1)
end,
{{oneStream,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_MediaDescriptor_streams_multiStream(Bytes1)
end,
{{multiStream,Val},NewBytes}
end.

dec_MediaDescriptor_streams_multiStream(Bytes) ->
dec_components22(Bytes, []).

enc_TerminationIDList(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_TerminationID(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_TerminationID(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_TerminationID(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_TerminationIDList(Bytes) ->
dec_components23(Bytes, []).

enc_TerminationID(Val) ->
[<<0:1>>,
begin
%% attribute wildcard(1) with type SEQUENCE OF
Enc2@element = element(2, Val),
enc_TerminationID_wildcard(Enc2@element)
end|begin
%% attribute id(2) with type OCTET STRING
Enc3@element = element(3, Val),
Enc4@bin = iolist_to_binary(Enc3@element),
Enc4@len = byte_size(Enc4@bin),
Enc4@len@sub = Enc4@len - 1,
if Enc4@len@sub bsr 3 =:= 0 ->
[<<Enc4@len@sub:3>>,
align|Enc4@bin]
end
end].
enc_TerminationID_wildcard(Val) ->
Enc2@len = length(Val),
if Enc2@len < 128 ->
[align,
Enc2@len|[begin
Enc1@bin = iolist_to_binary(Comp),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 1 ->
Enc1@bin
end
end || Comp <- Val]];
Enc2@len < 16384 ->
[align,
<<2:2,Enc2@len:14>>|[begin
Enc1@bin = iolist_to_binary(Comp),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 1 ->
Enc1@bin
end
end || Comp <- Val]];
true ->
begin
Enc2@fn = fun(Comp) -> begin
Enc1@bin = iolist_to_binary(Comp),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 1 ->
Enc1@bin
end
end end,
encode_fragmented_sof(Enc2@fn, Val, Enc2@len)
end
end.



dec_TerminationID(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute wildcard(1) with type SEQUENCE OF
{Term1,Bytes2} = dec_TerminationID_wildcard(Bytes1),

%% attribute id(2) with type OCTET STRING
{Term2,Bytes3} = begin
<<V2@V0:3/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes2,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/binary-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
V2@Conv7 = binary_to_list(V2@V3),
{V2@Conv7,V2@Buf4}
end,

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V3@V0,V3@Buf1} = case Bytes3 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:7,0:1,V3@V7:7,V3@Buf8/bitstring>> when V3@V7 =/= 0 ->
{V3@V7,V3@Buf8};
<<_:7,1:1,0:1,V3@V8:14,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:7,1:1,1:1,V3@V8:6,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
V3@Mul10 = V3@V8 * 16384,
{V3@Mul10,V3@Buf9}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
Res1 = {'TerminationID',Term1,Term2},
{Res1,Bytes5}.


dec_TerminationID_wildcard(Bytes) ->
dec_components24(Bytes, []).

enc_WildcardField(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 1 ->
Enc1@bin
end.


dec_WildcardField(Bytes) ->
begin
<<V1@V0:1/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv2 = binary_to_list(V1@V0),
{V1@Conv2,V1@Buf1}
end.

enc_ServiceChangeResult(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= errorDescriptor ->
[<<0:1>>|enc_ErrorDescriptor(ChoiceVal)];
ChoiceTag =:= serviceChangeResParms ->
[<<1:1>>|enc_ServiceChangeResParm(ChoiceVal)]
end.


dec_ServiceChangeResult(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_ErrorDescriptor(Bytes1)
end,
{{errorDescriptor,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_ServiceChangeResParm(Bytes1)
end,
{{serviceChangeResParms,Val},NewBytes}
end.
enc_ServiceChangeReply(Val) ->
[<<0:1>>,
begin
%% attribute terminationID(1) with type TerminationIDList
Enc2@element = element(2, Val),
enc_TerminationIDList(Enc2@element)
end|begin
%% attribute serviceChangeResult(2) with type ServiceChangeResult
Enc3@element = element(3, Val),
enc_ServiceChangeResult(Enc3@element)
end].


dec_ServiceChangeReply(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute terminationID(1) with type TerminationIDList
{Term1,Bytes2} = dec_TerminationIDList(Bytes1),

%% attribute serviceChangeResult(2) with type ServiceChangeResult
{Term2,Bytes3} = dec_ServiceChangeResult(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V2@V0,V2@Buf1} = case Bytes3 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
Res1 = {'ServiceChangeReply',Term1,Term2},
{Res1,Bytes5}.

enc_ServiceChangeRequest(Val) ->
[<<0:1>>,
begin
%% attribute terminationID(1) with type TerminationIDList
Enc2@element = element(2, Val),
enc_TerminationIDList(Enc2@element)
end|begin
%% attribute serviceChangeParms(2) with type ServiceChangeParm
Enc3@element = element(3, Val),
enc_ServiceChangeParm(Enc3@element)
end].


dec_ServiceChangeRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute terminationID(1) with type TerminationIDList
{Term1,Bytes2} = dec_TerminationIDList(Bytes1),

%% attribute serviceChangeParms(2) with type ServiceChangeParm
{Term2,Bytes3} = dec_ServiceChangeParm(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V2@V0,V2@Buf1} = case Bytes3 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
Res1 = {'ServiceChangeRequest',Term1,Term2},
{Res1,Bytes5}.

enc_EventParameter(Val) ->
[begin
Enc1@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute eventParameterName(1) with type OCTET STRING
Enc3@element = element(2, Val),
Enc4@bin = iolist_to_binary(Enc3@element),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 2 ->
Enc4@bin
end
end,
begin
%% attribute value(2) with type Value
Enc5@element = element(3, Val),
enc_Value(Enc5@element)
end|begin
%% attribute extraInfo(3) with type CHOICE
Enc6@element = element(4, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
true ->
enc_EventParameter_extraInfo(Enc6@element)
end
end].
enc_EventParameter_extraInfo(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= relation ->
if ChoiceVal =:= greaterThan ->
<<0:2,0:1,0:2>>;
ChoiceVal =:= smallerThan ->
<<0:2,0:1,1:2>>;
ChoiceVal =:= unequalTo ->
<<0:2,0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,ChoiceVal}}})
end;
ChoiceTag =:= range ->
if ChoiceVal =:= false ->
<<1:2,0:1>>;
ChoiceVal =:= true ->
<<1:2,1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,ChoiceVal}}})
end;
ChoiceTag =:= sublist ->
if ChoiceVal =:= false ->
<<2:2,0:1>>;
ChoiceVal =:= true ->
<<2:2,1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,ChoiceVal}}})
end
end.


dec_EventParameter(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute eventParameterName(1) with type OCTET STRING
{Term1,Bytes3} = begin
<<V3@V0:2/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv2 = binary_to_list(V3@V0),
{V3@Conv2,V3@Buf1}
end,

%% attribute value(2) with type Value
{Term2,Bytes4} = dec_Value(Bytes3),

%% attribute extraInfo(3) with type CHOICE
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_EventParameter_extraInfo(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'EventParameter',Term1,Term2,Term3},
{Res1,Bytes7}.


dec_EventParameter_extraInfo(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
{V2@V0,V2@Buf1} = case Bytes1 of
<<0:1,V2@V3:2/unsigned-unit:1,V2@Buf4/bitstring>> ->
V2@Int5 = case V2@V3 of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
_ -> exit({error,{asn1,{decode_enumerated,V2@V3}}})
end,
{V2@Int5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<0:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V6,V2@Buf7};
<<1:1,V2@Buf5/bitstring>> ->
V2@Pad9 = bit_size(V2@Buf5) band 7,
{V2@V6,V2@Buf7} = case V2@Buf5 of
<<_:V2@Pad9,0:1,V2@V11:7,V2@Buf12/bitstring>> when V2@V11 =/= 0 ->
{V2@V11,V2@Buf12};
<<_:V2@Pad9,1:1,0:1,V2@V12:14,V2@Buf13/bitstring>> when V2@V12 =/= 0 ->
{V2@V12,V2@Buf13};
<<_:V2@Pad9,1:1,1:1,V2@V12:6,V2@Buf13/bitstring>> when V2@V12 =/= 0 ->
V2@Mul14 = V2@V12 * 16384,
{V2@Mul14,V2@Buf13}
end,
<<V2@V15:V2@V6/unit:8,V2@Buf16/bitstring>> = V2@Buf7,
{V2@V15,V2@Buf16}
end,
V2@Int17 = case V2@V3 of
_ -> {asn1_enum,V2@V3}
end,
{V2@Int17,V2@Buf4}
end,
{V2@V0,V2@Buf1}
end
end,
{{relation,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
begin
<<V3@V0:1,V3@Buf1/bitstring>> = Bytes1,
V3@Int2 = case V3@V0 of
0 -> false;
1 -> true
end,
{V3@Int2,V3@Buf1}
end
end,
{{range,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
begin
<<V4@V0:1,V4@Buf1/bitstring>> = Bytes1,
V4@Int2 = case V4@V0 of
0 -> false;
1 -> true
end,
{V4@Int2,V4@Buf1}
end
end,
{{sublist,Val},NewBytes}
end.
enc_EventName(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 4 ->
[align|Enc1@bin]
end.


dec_EventName(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end.

enc_ObservedEvent(Val) ->
[begin
Enc1@element = element(3, Val),
Enc2@element = element(5, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
align,
begin
%% attribute eventName(1) with type OCTET STRING
Enc4@element = element(2, Val),
Enc5@bin = iolist_to_binary(Enc4@element),
Enc5@len = byte_size(Enc5@bin),
if Enc5@len =:= 4 ->
Enc5@bin
end
end,
begin
%% attribute streamID(2) with type INTEGER
Enc6@element = element(3, Val),
if Enc6@element =:= asn1_NOVALUE ->
[];
Enc6@element bsr 16 =:= 0 ->
<<Enc6@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc6@element}}})
end
end,
begin
%% attribute eventParList(3) with type SEQUENCE OF
Enc9@element = element(4, Val),
enc_ObservedEvent_eventParList(Enc9@element)
end|begin
%% attribute timeNotation(4) with type TimeNotation
Enc10@element = element(5, Val),
if Enc10@element =:= asn1_NOVALUE ->
[];
true ->
enc_TimeNotation(Enc10@element)
end
end].
enc_ObservedEvent_eventParList(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_EventParameter(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_EventParameter(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_EventParameter(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_ObservedEvent(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute eventName(1) with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute streamID(2) with type INTEGER
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute eventParList(3) with type SEQUENCE OF
{Term3,Bytes5} = dec_ObservedEvent_eventParList(Bytes4),

%% attribute timeNotation(4) with type TimeNotation
{Term4,Bytes6} = case Opt band 1 of
1 ->
dec_TimeNotation(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V5@V0,V5@Buf1} = case Bytes6 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10};
<<_:V5@Pad6,1:1,1:1,V5@V9:6,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
V5@Mul11 = V5@V9 * 16384,
{V5@Mul11,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V12:V5@V0/bitstring-unit:1,V5@Buf13/bitstring>> = V5@Buf1,
{V5@V12,V5@Buf13}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
Res1 = {'ObservedEvent',Term1,Term2,Term3,Term4},
{Res1,Bytes8}.


dec_ObservedEvent_eventParList(Bytes) ->
dec_components25(Bytes, []).

enc_ObservedEventsDescriptor(Val) ->
[begin
%% attribute requestId(1) with type INTEGER
Enc1@element = element(2, Val),
if Enc1@element bsr 32 =:= 0 ->
begin
Enc1@element@bin = binary:encode_unsigned(Enc1@element),
Enc1@element@bin_size0 = byte_size(Enc1@element@bin),
Enc1@element@bin_size = Enc1@element@bin_size0 - 1,
[<<Enc1@element@bin_size:2>>,
align|Enc1@element@bin]
end;
true ->
exit({error,{asn1,{illegal_integer,Enc1@element}}})
end
end|begin
%% attribute observedEventLst(2) with type SEQUENCE OF
Enc3@element = element(3, Val),
enc_ObservedEventsDescriptor_observedEventLst(Enc3@element)
end].
enc_ObservedEventsDescriptor_observedEventLst(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_ObservedEvent(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_ObservedEvent(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_ObservedEvent(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_ObservedEventsDescriptor(Bytes) ->

%% attribute requestId(1) with type INTEGER
{Term1,Bytes1} = begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/unsigned-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
{V1@V3,V1@Buf4}
end,

%% attribute observedEventLst(2) with type SEQUENCE OF
{Term2,Bytes2} = dec_ObservedEventsDescriptor_observedEventLst(Bytes1),
Res1 = {'ObservedEventsDescriptor',Term1,Term2},
{Res1,Bytes2}.


dec_ObservedEventsDescriptor_observedEventLst(Bytes) ->
dec_components26(Bytes, []).

enc_NotifyReply(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute terminationID(1) with type TerminationIDList
Enc3@element = element(2, Val),
enc_TerminationIDList(Enc3@element)
end|begin
%% attribute errorDescriptor(2) with type ErrorDescriptor
Enc4@element = element(3, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
true ->
enc_ErrorDescriptor(Enc4@element)
end
end].


dec_NotifyReply(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute terminationID(1) with type TerminationIDList
{Term1,Bytes3} = dec_TerminationIDList(Bytes2),

%% attribute errorDescriptor(2) with type ErrorDescriptor
{Term2,Bytes4} = case Opt band 1 of
1 ->
dec_ErrorDescriptor(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V12:V3@V0/bitstring-unit:1,V3@Buf13/bitstring>> = V3@Buf1,
{V3@V12,V3@Buf13}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
Res1 = {'NotifyReply',Term1,Term2},
{Res1,Bytes6}.

enc_NotifyRequest(Val) ->
[begin
Enc1@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute terminationID(1) with type TerminationIDList
Enc3@element = element(2, Val),
enc_TerminationIDList(Enc3@element)
end,
begin
%% attribute observedEventsDescriptor(2) with type ObservedEventsDescriptor
Enc4@element = element(3, Val),
enc_ObservedEventsDescriptor(Enc4@element)
end|begin
%% attribute errorDescriptor(3) with type ErrorDescriptor
Enc5@element = element(4, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
true ->
enc_ErrorDescriptor(Enc5@element)
end
end].


dec_NotifyRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute terminationID(1) with type TerminationIDList
{Term1,Bytes3} = dec_TerminationIDList(Bytes2),

%% attribute observedEventsDescriptor(2) with type ObservedEventsDescriptor
{Term2,Bytes4} = dec_ObservedEventsDescriptor(Bytes3),

%% attribute errorDescriptor(3) with type ErrorDescriptor
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_ErrorDescriptor(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V3@V0,V3@Buf1} = case Bytes5 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V12:V3@V0/bitstring-unit:1,V3@Buf13/bitstring>> = V3@Buf1,
{V3@V12,V3@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'NotifyRequest',Term1,Term2,Term3},
{Res1,Bytes7}.

enc_AuditDescriptor(Val) ->
[begin
Enc1@element = element(2, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end|begin
%% attribute auditToken(1) with type BIT STRING
Enc3@element = element(2, Val),
if Enc3@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc4@bs = try bit_string_name2pos_27(Enc3@element) of
Enc4@positions ->
bitstring_from_positions(Enc4@positions)
catch throw:invalid ->
to_named_bitstring(Enc3@element)
end,
Enc4@bits = bit_size(Enc4@bs),
if Enc4@bits < 128 ->
[align,
Enc4@bits|Enc4@bs];
Enc4@bits < 16384 ->
[align,
<<2:2,Enc4@bits:14>>|Enc4@bs];
true ->
[align|encode_fragmented(Enc4@bs, 1)]
end
end
end
end].


dec_AuditDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute auditToken(1) with type BIT STRING
{Term1,Bytes3} = case Opt band 1 of
1 ->
begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:1,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:1,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 1),
{V3@V8,V3@Buf9}
end,
{V3@V10,V3@Buf11}  = {decode_named_bit_string(V3@V0, [{muxToken,0},{modemToken,1},{mediaToken,2},{eventsToken,3},{signalsToken,4},{digitMapToken,5},{statsToken,6},{observedEventsToken,7},{packagesToken,8},{eventBufferToken,9}]),V3@Buf1},
{V3@V10,V3@Buf11}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10};
<<_:V4@Pad6,1:1,1:1,V4@V9:6,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
V4@Mul11 = V4@V9 * 16384,
{V4@Mul11,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V12:V4@V0/bitstring-unit:1,V4@Buf13/bitstring>> = V4@Buf1,
{V4@V12,V4@Buf13}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
Res1 = {'AuditDescriptor',Term1},
{Res1,Bytes5}.

enc_AuditReturnParameter(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= errorDescriptor ->
[<<0:1,0:4>>|enc_ErrorDescriptor(ChoiceVal)];
ChoiceTag =:= mediaDescriptor ->
[<<0:1,1:4>>|enc_MediaDescriptor(ChoiceVal)];
ChoiceTag =:= modemDescriptor ->
[<<0:1,2:4>>|enc_ModemDescriptor(ChoiceVal)];
ChoiceTag =:= muxDescriptor ->
[<<0:1,3:4>>|enc_MuxDescriptor(ChoiceVal)];
ChoiceTag =:= eventsDescriptor ->
[<<0:1,4:4>>|enc_EventsDescriptor(ChoiceVal)];
ChoiceTag =:= eventBufferDescriptor ->
[<<0:1,5:4>>|enc_EventBufferDescriptor(ChoiceVal)];
ChoiceTag =:= signalsDescriptor ->
[<<0:1,6:4>>|enc_SignalsDescriptor(ChoiceVal)];
ChoiceTag =:= digitMapDescriptor ->
[<<0:1,7:4>>|enc_DigitMapDescriptor(ChoiceVal)];
ChoiceTag =:= observedEventsDescriptor ->
[<<0:1,8:4>>|enc_ObservedEventsDescriptor(ChoiceVal)];
ChoiceTag =:= statisticsDescriptor ->
[<<0:1,9:4>>|enc_StatisticsDescriptor(ChoiceVal)];
ChoiceTag =:= packagesDescriptor ->
[<<0:1,10:4>>|enc_PackagesDescriptor(ChoiceVal)];
ChoiceTag =:= emptyDescriptors ->
[<<0:1,11:4>>|enc_AuditDescriptor(ChoiceVal)]
end.


dec_AuditReturnParameter(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:4/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_ErrorDescriptor(Bytes2)
end,
{{errorDescriptor,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_MediaDescriptor(Bytes2)
end,
{{mediaDescriptor,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_ModemDescriptor(Bytes2)
end,
{{modemDescriptor,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_MuxDescriptor(Bytes2)
end,
{{muxDescriptor,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
dec_EventsDescriptor(Bytes2)
end,
{{eventsDescriptor,Val},NewBytes};
5 ->
{Val,NewBytes} = begin
dec_EventBufferDescriptor(Bytes2)
end,
{{eventBufferDescriptor,Val},NewBytes};
6 ->
{Val,NewBytes} = begin
dec_SignalsDescriptor(Bytes2)
end,
{{signalsDescriptor,Val},NewBytes};
7 ->
{Val,NewBytes} = begin
dec_DigitMapDescriptor(Bytes2)
end,
{{digitMapDescriptor,Val},NewBytes};
8 ->
{Val,NewBytes} = begin
dec_ObservedEventsDescriptor(Bytes2)
end,
{{observedEventsDescriptor,Val},NewBytes};
9 ->
{Val,NewBytes} = begin
dec_StatisticsDescriptor(Bytes2)
end,
{{statisticsDescriptor,Val},NewBytes};
10 ->
{Val,NewBytes} = begin
dec_PackagesDescriptor(Bytes2)
end,
{{packagesDescriptor,Val},NewBytes};
11 ->
{Val,NewBytes} = begin
dec_AuditDescriptor(Bytes2)
end,
{{emptyDescriptors,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_TerminationAudit(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_AuditReturnParameter(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_AuditReturnParameter(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_AuditReturnParameter(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_TerminationAudit(Bytes) ->
dec_components28(Bytes, []).

enc_AuditResult(Val) ->
[begin
%% attribute terminationID(1) with type TerminationID
Enc1@element = element(2, Val),
enc_TerminationID(Enc1@element)
end|begin
%% attribute terminationAuditResult(2) with type TerminationAudit
Enc2@element = element(3, Val),
enc_TerminationAudit(Enc2@element)
end].


dec_AuditResult(Bytes) ->

%% attribute terminationID(1) with type TerminationID
{Term1,Bytes1} = dec_TerminationID(Bytes),

%% attribute terminationAuditResult(2) with type TerminationAudit
{Term2,Bytes2} = dec_TerminationAudit(Bytes1),
Res1 = {'AuditResult',Term1,Term2},
{Res1,Bytes2}.

enc_AuditReply(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= contextAuditResult ->
[<<0:1,0:2>>|enc_TerminationIDList(ChoiceVal)];
ChoiceTag =:= error ->
[<<0:1,1:2>>|enc_ErrorDescriptor(ChoiceVal)];
ChoiceTag =:= auditResult ->
[<<0:1,2:2>>|enc_AuditResult(ChoiceVal)]
end.


dec_AuditReply(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_TerminationIDList(Bytes2)
end,
{{contextAuditResult,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_ErrorDescriptor(Bytes2)
end,
{{error,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_AuditResult(Bytes2)
end,
{{auditResult,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_AuditRequest(Val) ->
[<<0:1>>,
begin
%% attribute terminationID(1) with type TerminationID
Enc2@element = element(2, Val),
enc_TerminationID(Enc2@element)
end|begin
%% attribute auditDescriptor(2) with type AuditDescriptor
Enc3@element = element(3, Val),
enc_AuditDescriptor(Enc3@element)
end].


dec_AuditRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute terminationID(1) with type TerminationID
{Term1,Bytes2} = dec_TerminationID(Bytes1),

%% attribute auditDescriptor(2) with type AuditDescriptor
{Term2,Bytes3} = dec_AuditDescriptor(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V2@V0,V2@Buf1} = case Bytes3 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
Res1 = {'AuditRequest',Term1,Term2},
{Res1,Bytes5}.

enc_SubtractRequest(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute terminationID(1) with type TerminationIDList
Enc3@element = element(2, Val),
enc_TerminationIDList(Enc3@element)
end|begin
%% attribute auditDescriptor(2) with type AuditDescriptor
Enc4@element = element(3, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
true ->
enc_AuditDescriptor(Enc4@element)
end
end].


dec_SubtractRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute terminationID(1) with type TerminationIDList
{Term1,Bytes3} = dec_TerminationIDList(Bytes2),

%% attribute auditDescriptor(2) with type AuditDescriptor
{Term2,Bytes4} = case Opt band 1 of
1 ->
dec_AuditDescriptor(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V12:V3@V0/bitstring-unit:1,V3@Buf13/bitstring>> = V3@Buf1,
{V3@V12,V3@Buf13}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
Res1 = {'SubtractRequest',Term1,Term2},
{Res1,Bytes6}.

enc_AmmsReply(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute terminationID(1) with type TerminationIDList
Enc3@element = element(2, Val),
enc_TerminationIDList(Enc3@element)
end|begin
%% attribute terminationAudit(2) with type TerminationAudit
Enc4@element = element(3, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
true ->
enc_TerminationAudit(Enc4@element)
end
end].


dec_AmmsReply(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute terminationID(1) with type TerminationIDList
{Term1,Bytes3} = dec_TerminationIDList(Bytes2),

%% attribute terminationAudit(2) with type TerminationAudit
{Term2,Bytes4} = case Opt band 1 of
1 ->
dec_TerminationAudit(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V12:V3@V0/bitstring-unit:1,V3@Buf13/bitstring>> = V3@Buf1,
{V3@V12,V3@Buf13}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
Res1 = {'AmmsReply',Term1,Term2},
{Res1,Bytes6}.

enc_AmmDescriptor(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= mediaDescriptor ->
[<<0:1,0:3>>|enc_MediaDescriptor(ChoiceVal)];
ChoiceTag =:= modemDescriptor ->
[<<0:1,1:3>>|enc_ModemDescriptor(ChoiceVal)];
ChoiceTag =:= muxDescriptor ->
[<<0:1,2:3>>|enc_MuxDescriptor(ChoiceVal)];
ChoiceTag =:= eventsDescriptor ->
[<<0:1,3:3>>|enc_EventsDescriptor(ChoiceVal)];
ChoiceTag =:= eventBufferDescriptor ->
[<<0:1,4:3>>|enc_EventBufferDescriptor(ChoiceVal)];
ChoiceTag =:= signalsDescriptor ->
[<<0:1,5:3>>|enc_SignalsDescriptor(ChoiceVal)];
ChoiceTag =:= digitMapDescriptor ->
[<<0:1,6:3>>|enc_DigitMapDescriptor(ChoiceVal)];
ChoiceTag =:= auditDescriptor ->
[<<0:1,7:3>>|enc_AuditDescriptor(ChoiceVal)]
end.


dec_AmmDescriptor(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:3/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_MediaDescriptor(Bytes2)
end,
{{mediaDescriptor,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_ModemDescriptor(Bytes2)
end,
{{modemDescriptor,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_MuxDescriptor(Bytes2)
end,
{{muxDescriptor,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_EventsDescriptor(Bytes2)
end,
{{eventsDescriptor,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
dec_EventBufferDescriptor(Bytes2)
end,
{{eventBufferDescriptor,Val},NewBytes};
5 ->
{Val,NewBytes} = begin
dec_SignalsDescriptor(Bytes2)
end,
{{signalsDescriptor,Val},NewBytes};
6 ->
{Val,NewBytes} = begin
dec_DigitMapDescriptor(Bytes2)
end,
{{digitMapDescriptor,Val},NewBytes};
7 ->
{Val,NewBytes} = begin
dec_AuditDescriptor(Bytes2)
end,
{{auditDescriptor,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_AmmRequest(Val) ->
[<<0:1>>,
begin
%% attribute terminationID(1) with type TerminationIDList
Enc2@element = element(2, Val),
enc_TerminationIDList(Enc2@element)
end|begin
%% attribute descriptors(2) with type SEQUENCE OF
Enc3@element = element(3, Val),
enc_AmmRequest_descriptors(Enc3@element)
end].
enc_AmmRequest_descriptors(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_AmmDescriptor(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_AmmDescriptor(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_AmmDescriptor(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_AmmRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute terminationID(1) with type TerminationIDList
{Term1,Bytes2} = dec_TerminationIDList(Bytes1),

%% attribute descriptors(2) with type SEQUENCE OF
{Term2,Bytes3} = dec_AmmRequest_descriptors(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V2@V0,V2@Buf1} = case Bytes3 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10};
<<_:V2@Pad6,1:1,1:1,V2@V9:6,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
V2@Mul11 = V2@V9 * 16384,
{V2@Mul11,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V12:V2@V0/bitstring-unit:1,V2@Buf13/bitstring>> = V2@Buf1,
{V2@V12,V2@Buf13}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
Res1 = {'AmmRequest',Term1,Term2},
{Res1,Bytes5}.


dec_AmmRequest_descriptors(Bytes) ->
dec_components29(Bytes, []).

enc_TopologyRequest(Val) ->
[begin
%% attribute terminationFrom(1) with type TerminationID
Enc1@element = element(2, Val),
enc_TerminationID(Enc1@element)
end,
begin
%% attribute terminationTo(2) with type TerminationID
Enc2@element = element(3, Val),
enc_TerminationID(Enc2@element)
end|begin
%% attribute topologyDirection(3) with type ENUMERATED
Enc3@element = element(4, Val),
if Enc3@element =:= bothway ->
<<0:2>>;
Enc3@element =:= isolate ->
<<1:2>>;
Enc3@element =:= oneway ->
<<2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc3@element}}})
end
end].


dec_TopologyRequest(Bytes) ->

%% attribute terminationFrom(1) with type TerminationID
{Term1,Bytes1} = dec_TerminationID(Bytes),

%% attribute terminationTo(2) with type TerminationID
{Term2,Bytes2} = dec_TerminationID(Bytes1),

%% attribute topologyDirection(3) with type ENUMERATED
{Term3,Bytes3} = begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes2,
V1@Int2 = case V1@V0 of
0 -> bothway;
1 -> isolate;
2 -> oneway;
_ -> exit({error,{asn1,{decode_enumerated,V1@V0}}})
end,
{V1@Int2,V1@Buf1}
end,
Res1 = {'TopologyRequest',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_CommandReply(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= addReply ->
[<<0:1,0:3>>|enc_AmmsReply(ChoiceVal)];
ChoiceTag =:= moveReply ->
[<<0:1,1:3>>|enc_AmmsReply(ChoiceVal)];
ChoiceTag =:= modReply ->
[<<0:1,2:3>>|enc_AmmsReply(ChoiceVal)];
ChoiceTag =:= subtractReply ->
[<<0:1,3:3>>|enc_AmmsReply(ChoiceVal)];
ChoiceTag =:= auditCapReply ->
[<<0:1,4:3>>|enc_AuditReply(ChoiceVal)];
ChoiceTag =:= auditValueReply ->
[<<0:1,5:3>>|enc_AuditReply(ChoiceVal)];
ChoiceTag =:= notifyReply ->
[<<0:1,6:3>>|enc_NotifyReply(ChoiceVal)];
ChoiceTag =:= serviceChangeReply ->
[<<0:1,7:3>>|enc_ServiceChangeReply(ChoiceVal)]
end.


dec_CommandReply(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:3/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_AmmsReply(Bytes2)
end,
{{addReply,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_AmmsReply(Bytes2)
end,
{{moveReply,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_AmmsReply(Bytes2)
end,
{{modReply,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_AmmsReply(Bytes2)
end,
{{subtractReply,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
dec_AuditReply(Bytes2)
end,
{{auditCapReply,Val},NewBytes};
5 ->
{Val,NewBytes} = begin
dec_AuditReply(Bytes2)
end,
{{auditValueReply,Val},NewBytes};
6 ->
{Val,NewBytes} = begin
dec_NotifyReply(Bytes2)
end,
{{notifyReply,Val},NewBytes};
7 ->
{Val,NewBytes} = begin
dec_ServiceChangeReply(Bytes2)
end,
{{serviceChangeReply,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_Command(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= addReq ->
[<<0:1,0:3>>|enc_AmmRequest(ChoiceVal)];
ChoiceTag =:= moveReq ->
[<<0:1,1:3>>|enc_AmmRequest(ChoiceVal)];
ChoiceTag =:= modReq ->
[<<0:1,2:3>>|enc_AmmRequest(ChoiceVal)];
ChoiceTag =:= subtractReq ->
[<<0:1,3:3>>|enc_SubtractRequest(ChoiceVal)];
ChoiceTag =:= auditCapRequest ->
[<<0:1,4:3>>|enc_AuditRequest(ChoiceVal)];
ChoiceTag =:= auditValueRequest ->
[<<0:1,5:3>>|enc_AuditRequest(ChoiceVal)];
ChoiceTag =:= notifyReq ->
[<<0:1,6:3>>|enc_NotifyRequest(ChoiceVal)];
ChoiceTag =:= serviceChangeReq ->
[<<0:1,7:3>>|enc_ServiceChangeRequest(ChoiceVal)]
end.


dec_Command(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:3/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_AmmRequest(Bytes2)
end,
{{addReq,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_AmmRequest(Bytes2)
end,
{{moveReq,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_AmmRequest(Bytes2)
end,
{{modReq,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_SubtractRequest(Bytes2)
end,
{{subtractReq,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
dec_AuditRequest(Bytes2)
end,
{{auditCapRequest,Val},NewBytes};
5 ->
{Val,NewBytes} = begin
dec_AuditRequest(Bytes2)
end,
{{auditValueRequest,Val},NewBytes};
6 ->
{Val,NewBytes} = begin
dec_NotifyRequest(Bytes2)
end,
{{notifyReq,Val},NewBytes};
7 ->
{Val,NewBytes} = begin
dec_ServiceChangeRequest(Bytes2)
end,
{{serviceChangeReq,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_CommandRequest(Val) ->
[begin
Enc1@element = element(3, Val),
Enc2@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
%% attribute command(1) with type Command
Enc4@element = element(2, Val),
enc_Command(Enc4@element)
end,
begin
%% attribute optional(2) with type NULL
Enc5@element = element(3, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
true ->
[]
end
end|begin
%% attribute wildcardReturn(3) with type NULL
Enc7@element = element(4, Val),
if Enc7@element =:= asn1_NOVALUE ->
[];
true ->
[]
end
end].


dec_CommandRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute command(1) with type Command
{Term1,Bytes3} = dec_Command(Bytes2),

%% attribute optional(2) with type NULL
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
ignore,
{'NULL',Bytes3}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute wildcardReturn(3) with type NULL
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
ignore,
{'NULL',Bytes4}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V5@V0,V5@Buf1} = case Bytes5 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10};
<<_:V5@Pad6,1:1,1:1,V5@V9:6,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
V5@Mul11 = V5@V9 * 16384,
{V5@Mul11,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V12:V5@V0/bitstring-unit:1,V5@Buf13/bitstring>> = V5@Buf1,
{V5@V12,V5@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'CommandRequest',Term1,Term2,Term3},
{Res1,Bytes7}.

enc_ContextAttrAuditRequest(Val) ->
[begin
Enc1@element = element(2, Val),
Enc2@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(4, Val),
%% attribute topology(1) with type NULL
Enc5@element = element(2, Val),
if Enc3@element =:= asn1_NOVALUE ->
if Enc5@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<0:1>>
end;
true ->
if Enc5@element =:= asn1_NOVALUE ->
<<1:1>>;
true ->
<<1:1>>
end
end
end,
begin
%% attribute emergency(2) with type NULL
Enc7@element = element(3, Val),
if Enc7@element =:= asn1_NOVALUE ->
[];
true ->
[]
end
end|begin
%% attribute priority(3) with type NULL
Enc9@element = element(4, Val),
if Enc9@element =:= asn1_NOVALUE ->
[];
true ->
[]
end
end].


dec_ContextAttrAuditRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute topology(1) with type NULL
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
begin
ignore,
{'NULL',Bytes2}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute emergency(2) with type NULL
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
ignore,
{'NULL',Bytes3}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute priority(3) with type NULL
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
ignore,
{'NULL',Bytes4}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V6@V0,V6@Buf1} = case Bytes5 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10};
<<_:V6@Pad6,1:1,1:1,V6@V9:6,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
V6@Mul11 = V6@V9 * 16384,
{V6@Mul11,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V12:V6@V0/bitstring-unit:1,V6@Buf13/bitstring>> = V6@Buf1,
{V6@V12,V6@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'ContextAttrAuditRequest',Term1,Term2,Term3},
{Res1,Bytes7}.

enc_ContextRequest(Val) ->
[begin
Enc1@element = element(2, Val),
Enc2@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@element = element(4, Val),
if Enc3@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
%% attribute priority(1) with type INTEGER
Enc5@element = element(2, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
Enc5@element bsr 4 =:= 0 ->
<<Enc5@element:4>>;
true ->
exit({error,{asn1,{illegal_integer,Enc5@element}}})
end
end,
begin
%% attribute emergency(2) with type BOOLEAN
Enc8@element = element(3, Val),
if Enc8@element =:= asn1_NOVALUE ->
[];
Enc8@element =:= false ->
<<0:1>>;
Enc8@element =:= true ->
<<1:1>>;
true ->
exit({error,{asn1,{illegal_boolean,Enc8@element}}})
end
end|begin
%% attribute topologyReq(3) with type SEQUENCE OF
Enc11@element = element(4, Val),
if Enc11@element =:= asn1_NOVALUE ->
[];
true ->
enc_ContextRequest_topologyReq(Enc11@element)
end
end].
enc_ContextRequest_topologyReq(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_TopologyRequest(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_TopologyRequest(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_TopologyRequest(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_ContextRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute priority(1) with type INTEGER
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
begin
<<V3@V0:4/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute emergency(2) with type BOOLEAN
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
<<V4@V0:1,V4@Buf1/bitstring>> = Bytes3,
V4@Int2 = case V4@V0 of
0 -> false;
1 -> true
end,
{V4@Int2,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute topologyReq(3) with type SEQUENCE OF
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_ContextRequest_topologyReq(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V5@V0,V5@Buf1} = case Bytes5 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10};
<<_:V5@Pad6,1:1,1:1,V5@V9:6,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
V5@Mul11 = V5@V9 * 16384,
{V5@Mul11,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V12:V5@V0/bitstring-unit:1,V5@Buf13/bitstring>> = V5@Buf1,
{V5@V12,V5@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'ContextRequest',Term1,Term2,Term3},
{Res1,Bytes7}.


dec_ContextRequest_topologyReq(Bytes) ->
dec_components30(Bytes, []).

enc_ActionReply(Val) ->
[begin
Enc1@element = element(3, Val),
Enc2@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
%% attribute contextId(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 32 =:= 0 ->
begin
Enc3@element@bin = binary:encode_unsigned(Enc3@element),
Enc3@element@bin_size0 = byte_size(Enc3@element@bin),
Enc3@element@bin_size = Enc3@element@bin_size0 - 1,
[<<Enc3@element@bin_size:2>>,
align|Enc3@element@bin]
end;
true ->
exit({error,{asn1,{illegal_integer,Enc3@element}}})
end
end,
begin
%% attribute errorDescriptor(2) with type ErrorDescriptor
Enc5@element = element(3, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
true ->
enc_ErrorDescriptor(Enc5@element)
end
end,
begin
%% attribute contextReply(3) with type ContextRequest
Enc7@element = element(4, Val),
if Enc7@element =:= asn1_NOVALUE ->
[];
true ->
enc_ContextRequest(Enc7@element)
end
end|begin
%% attribute commandReply(4) with type SEQUENCE OF
Enc9@element = element(5, Val),
enc_ActionReply_commandReply(Enc9@element)
end].
enc_ActionReply_commandReply(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_CommandReply(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_CommandReply(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_CommandReply(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_ActionReply(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:2,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute contextId(1) with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% attribute errorDescriptor(2) with type ErrorDescriptor
{Term2,Bytes3} = case (Opt bsr 1) band 1 of
1 ->
dec_ErrorDescriptor(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute contextReply(3) with type ContextRequest
{Term3,Bytes4} = case Opt band 1 of
1 ->
dec_ContextRequest(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute commandReply(4) with type SEQUENCE OF
{Term4,Bytes5} = dec_ActionReply_commandReply(Bytes4),
Res1 = {'ActionReply',Term1,Term2,Term3,Term4},
{Res1,Bytes5}.


dec_ActionReply_commandReply(Bytes) ->
dec_components31(Bytes, []).

enc_ActionRequest(Val) ->
[begin
Enc1@element = element(3, Val),
Enc2@element = element(4, Val),
if Enc1@element =:= asn1_NOVALUE ->
if Enc2@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc2@element =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
%% attribute contextId(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 32 =:= 0 ->
begin
Enc3@element@bin = binary:encode_unsigned(Enc3@element),
Enc3@element@bin_size0 = byte_size(Enc3@element@bin),
Enc3@element@bin_size = Enc3@element@bin_size0 - 1,
[<<Enc3@element@bin_size:2>>,
align|Enc3@element@bin]
end;
true ->
exit({error,{asn1,{illegal_integer,Enc3@element}}})
end
end,
begin
%% attribute contextRequest(2) with type ContextRequest
Enc5@element = element(3, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
true ->
enc_ContextRequest(Enc5@element)
end
end,
begin
%% attribute contextAttrAuditReq(3) with type ContextAttrAuditRequest
Enc7@element = element(4, Val),
if Enc7@element =:= asn1_NOVALUE ->
[];
true ->
enc_ContextAttrAuditRequest(Enc7@element)
end
end|begin
%% attribute commandRequests(4) with type SEQUENCE OF
Enc9@element = element(5, Val),
enc_ActionRequest_commandRequests(Enc9@element)
end].
enc_ActionRequest_commandRequests(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_CommandRequest(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_CommandRequest(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_CommandRequest(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_ActionRequest(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:2,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute contextId(1) with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% attribute contextRequest(2) with type ContextRequest
{Term2,Bytes3} = case (Opt bsr 1) band 1 of
1 ->
dec_ContextRequest(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute contextAttrAuditReq(3) with type ContextAttrAuditRequest
{Term3,Bytes4} = case Opt band 1 of
1 ->
dec_ContextAttrAuditRequest(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute commandRequests(4) with type SEQUENCE OF
{Term4,Bytes5} = dec_ActionRequest_commandRequests(Bytes4),
Res1 = {'ActionRequest',Term1,Term2,Term3,Term4},
{Res1,Bytes5}.


dec_ActionRequest_commandRequests(Bytes) ->
dec_components32(Bytes, []).

enc_ContextID(Val) ->
if Val bsr 32 =:= 0 ->
begin
Val@bin = binary:encode_unsigned(Val),
Val@bin_size0 = byte_size(Val@bin),
Val@bin_size = Val@bin_size0 - 1,
[<<Val@bin_size:2>>,
align|Val@bin]
end;
true ->
exit({error,{asn1,{illegal_integer,Val}}})
end.


dec_ContextID(Bytes) ->
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/unsigned-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
{V1@V3,V1@Buf4}
end.

enc_ErrorText(Val) ->
Enc1@bin = list_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len < 128 ->
[align,
Enc1@len|Enc1@bin];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|Enc1@bin];
true ->
[align|encode_fragmented(Enc1@bin, 8)]
end.


dec_ErrorText(Bytes) ->
begin
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@V7:V1@V5/binary-unit:8,V1@Buf8/bitstring>> ->
{V1@V7,V1@Buf8};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@V8:V1@V6/binary-unit:8,V1@Buf9/bitstring>> ->
{V1@V8,V1@Buf9};
<<_:V1@Pad3,1:1,1:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V8,V1@Buf9}  = decode_fragmented(V1@V6, V1@Buf7, 8),
{V1@V8,V1@Buf9}
end,
V1@Conv10 = binary_to_list(V1@V0),
{V1@Conv10,V1@Buf1}
end.

enc_ErrorCode(Val) ->
if Val bsr 16 =:= 0 ->
[align|<<Val:16>>];
true ->
exit({error,{asn1,{illegal_integer,Val}}})
end.


dec_ErrorCode(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end.

enc_ErrorDescriptor(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
%% attribute errorCode(1) with type INTEGER
Enc2@element = element(2, Val),
if Enc2@element bsr 16 =:= 0 ->
<<Enc2@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end|begin
%% attribute errorText(2) with type IA5String
Enc4@element = element(3, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
true ->
begin
Enc5@bin = list_to_binary(Enc4@element),
Enc5@len = byte_size(Enc5@bin),
if Enc5@len < 128 ->
[Enc5@len|Enc5@bin];
Enc5@len < 16384 ->
[<<2:2,Enc5@len:14>>|Enc5@bin];
true ->
encode_fragmented(Enc5@bin, 8)
end
end
end
end].


dec_ErrorDescriptor(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute errorCode(1) with type INTEGER
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:2/unsigned-unit:8,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute errorText(2) with type IA5String
{Term2,Bytes3} = case Opt band 1 of
1 ->
begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
V3@Conv10 = binary_to_list(V3@V0),
{V3@Conv10,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,
Res1 = {'ErrorDescriptor',Term1,Term2},
{Res1,Bytes3}.

enc_TransactionAck(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
%% attribute firstAck(1) with type INTEGER
Enc2@element = element(2, Val),
if Enc2@element bsr 32 =:= 0 ->
begin
Enc2@element@bin = binary:encode_unsigned(Enc2@element),
Enc2@element@bin_size0 = byte_size(Enc2@element@bin),
Enc2@element@bin_size = Enc2@element@bin_size0 - 1,
[<<Enc2@element@bin_size:2>>,
align|Enc2@element@bin]
end;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end|begin
%% attribute lastAck(2) with type INTEGER
Enc4@element = element(3, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
Enc4@element bsr 32 =:= 0 ->
begin
Enc4@element@bin = binary:encode_unsigned(Enc4@element),
Enc4@element@bin_size0 = byte_size(Enc4@element@bin),
Enc4@element@bin_size = Enc4@element@bin_size0 - 1,
[<<Enc4@element@bin_size:2,0:6>>|Enc4@element@bin]
end;
true ->
exit({error,{asn1,{illegal_integer,Enc4@element}}})
end
end].


dec_TransactionAck(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute firstAck(1) with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% attribute lastAck(2) with type INTEGER
{Term2,Bytes3} = case Opt band 1 of
1 ->
begin
<<V3@V0:2/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 1,
V3@Pad5 = bit_size(V3@Buf1) band 7,
<<_:V3@Pad5,V3@V3:V3@Add2/unsigned-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
{V3@V3,V3@Buf4}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,
Res1 = {'TransactionAck',Term1,Term2},
{Res1,Bytes3}.

enc_TransactionResponseAck(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_TransactionAck(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_TransactionAck(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_TransactionAck(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_TransactionResponseAck(Bytes) ->
dec_components33(Bytes, []).

enc_TransactionReply(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
%% attribute transactionId(1) with type INTEGER
Enc3@element = element(2, Val),
if Enc3@element bsr 32 =:= 0 ->
begin
Enc3@element@bin = binary:encode_unsigned(Enc3@element),
Enc3@element@bin_size0 = byte_size(Enc3@element@bin),
Enc3@element@bin_size = Enc3@element@bin_size0 - 1,
[<<Enc3@element@bin_size:2>>,
align|Enc3@element@bin]
end;
true ->
exit({error,{asn1,{illegal_integer,Enc3@element}}})
end
end,
begin
%% attribute immAckRequired(2) with type NULL
Enc5@element = element(3, Val),
if Enc5@element =:= asn1_NOVALUE ->
[];
true ->
[]
end
end|begin
%% attribute transactionResult(3) with type CHOICE
Enc7@element = element(4, Val),
enc_TransactionReply_transactionResult(Enc7@element)
end].
enc_TransactionReply_transactionResult(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= transactionError ->
[<<0:1>>|enc_ErrorDescriptor(ChoiceVal)];
ChoiceTag =:= actionReplies ->
[<<1:1>>|enc_TransactionReply_transactionResult_actionReplies(ChoiceVal)]
end.
enc_TransactionReply_transactionResult_actionReplies(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_ActionReply(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_ActionReply(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_ActionReply(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_TransactionReply(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute transactionId(1) with type INTEGER
{Term1,Bytes3} = begin
<<V3@V0:2/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 1,
V3@Pad5 = bit_size(V3@Buf1) band 7,
<<_:V3@Pad5,V3@V3:V3@Add2/unsigned-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
{V3@V3,V3@Buf4}
end,

%% attribute immAckRequired(2) with type NULL
{Term2,Bytes4} = case Opt band 1 of
1 ->
begin
ignore,
{'NULL',Bytes3}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute transactionResult(3) with type CHOICE
{Term3,Bytes5} = dec_TransactionReply_transactionResult(Bytes4),

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V5@V0,V5@Buf1} = case Bytes5 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10};
<<_:V5@Pad6,1:1,1:1,V5@V9:6,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
V5@Mul11 = V5@V9 * 16384,
{V5@Mul11,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V12:V5@V0/bitstring-unit:1,V5@Buf13/bitstring>> = V5@Buf1,
{V5@V12,V5@Buf13}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
Res1 = {'TransactionReply',Term1,Term2,Term3},
{Res1,Bytes7}.


dec_TransactionReply_transactionResult(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_ErrorDescriptor(Bytes1)
end,
{{transactionError,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_TransactionReply_transactionResult_actionReplies(Bytes1)
end,
{{actionReplies,Val},NewBytes}
end.

dec_TransactionReply_transactionResult_actionReplies(Bytes) ->
dec_components34(Bytes, []).

enc_TransactionPending(Val) ->
%% attribute transactionId(1) with type INTEGER
Enc2@element = element(2, Val),
if Enc2@element bsr 32 =:= 0 ->
[<<0:1>>|begin
Enc2@element@bin = binary:encode_unsigned(Enc2@element),
Enc2@element@bin_size0 = byte_size(Enc2@element@bin),
Enc2@element@bin_size = Enc2@element@bin_size0 - 1,
[<<Enc2@element@bin_size:2>>,
align|Enc2@element@bin]
end];
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end.


dec_TransactionPending(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute transactionId(1) with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:7,0:1,V3@V7:7,V3@Buf8/bitstring>> when V3@V7 =/= 0 ->
{V3@V7,V3@Buf8};
<<_:7,1:1,0:1,V3@V8:14,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:7,1:1,1:1,V3@V8:6,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
V3@Mul10 = V3@V8 * 16384,
{V3@Mul10,V3@Buf9}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
Res1 = {'TransactionPending',Term1},
{Res1,Bytes4}.

enc_TransactionRequest(Val) ->
[begin
%% attribute transactionId(1) with type INTEGER
Enc2@element = element(2, Val),
if Enc2@element bsr 32 =:= 0 ->
[<<0:1>>|begin
Enc2@element@bin = binary:encode_unsigned(Enc2@element),
Enc2@element@bin_size0 = byte_size(Enc2@element@bin),
Enc2@element@bin_size = Enc2@element@bin_size0 - 1,
[<<Enc2@element@bin_size:2>>,
align|Enc2@element@bin]
end];
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end|begin
%% attribute actions(2) with type SEQUENCE OF
Enc4@element = element(3, Val),
enc_TransactionRequest_actions(Enc4@element)
end].
enc_TransactionRequest_actions(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_ActionRequest(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_ActionRequest(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_ActionRequest(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_TransactionRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute transactionId(1) with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% attribute actions(2) with type SEQUENCE OF
{Term2,Bytes3} = dec_TransactionRequest_actions(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V3@V0,V3@Buf1} = case Bytes3 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V12:V3@V0/bitstring-unit:1,V3@Buf13/bitstring>> = V3@Buf1,
{V3@V12,V3@Buf13}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
Res1 = {'TransactionRequest',Term1,Term2},
{Res1,Bytes5}.


dec_TransactionRequest_actions(Bytes) ->
dec_components35(Bytes, []).

enc_TransactionId(Val) ->
if Val bsr 32 =:= 0 ->
begin
Val@bin = binary:encode_unsigned(Val),
Val@bin_size0 = byte_size(Val@bin),
Val@bin_size = Val@bin_size0 - 1,
[<<Val@bin_size:2>>,
align|Val@bin]
end;
true ->
exit({error,{asn1,{illegal_integer,Val}}})
end.


dec_TransactionId(Bytes) ->
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/unsigned-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
{V1@V3,V1@Buf4}
end.

enc_Transaction(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= transactionRequest ->
[<<0:1,0:2>>|enc_TransactionRequest(ChoiceVal)];
ChoiceTag =:= transactionPending ->
[<<0:1,1:2>>|enc_TransactionPending(ChoiceVal)];
ChoiceTag =:= transactionReply ->
[<<0:1,2:2>>|enc_TransactionReply(ChoiceVal)];
ChoiceTag =:= transactionResponseAck ->
[<<0:1,3:2>>|enc_TransactionResponseAck(ChoiceVal)]
end.


dec_Transaction(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_TransactionRequest(Bytes2)
end,
{{transactionRequest,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_TransactionPending(Bytes2)
end,
{{transactionPending,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_TransactionReply(Bytes2)
end,
{{transactionReply,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_TransactionResponseAck(Bytes2)
end,
{{transactionResponseAck,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_PathName(Val) ->
Enc1@bin = list_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 6 =:= 0 ->
[<<Enc1@len@sub:6>>,
align|Enc1@bin]
end.


dec_PathName(Bytes) ->
begin
<<V1@V0:6/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/binary-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
V1@Conv7 = binary_to_list(V1@V3),
{V1@Conv7,V1@Buf4}
end.

enc_IP6Address(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
%% attribute address(1) with type OCTET STRING
Enc2@element = element(2, Val),
Enc3@bin = iolist_to_binary(Enc2@element),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len =:= 16 ->
Enc3@bin
end
end|begin
%% attribute portNumber(2) with type INTEGER
Enc4@element = element(3, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
Enc4@element bsr 16 =:= 0 ->
<<Enc4@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc4@element}}})
end
end].


dec_IP6Address(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute address(1) with type OCTET STRING
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:16/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv4 = binary_to_list(V2@V0),
{V2@Conv4,V2@Buf1}
end,

%% attribute portNumber(2) with type INTEGER
{Term2,Bytes3} = case Opt band 1 of
1 ->
begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:2/unsigned-unit:8,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,
Res1 = {'IP6Address',Term1,Term2},
{Res1,Bytes3}.

enc_IP4Address(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
%% attribute address(1) with type OCTET STRING
Enc2@element = element(2, Val),
Enc3@bin = iolist_to_binary(Enc2@element),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len =:= 4 ->
Enc3@bin
end
end|begin
%% attribute portNumber(2) with type INTEGER
Enc4@element = element(3, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
Enc4@element bsr 16 =:= 0 ->
<<Enc4@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc4@element}}})
end
end].


dec_IP4Address(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute address(1) with type OCTET STRING
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:4/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv4 = binary_to_list(V2@V0),
{V2@Conv4,V2@Buf1}
end,

%% attribute portNumber(2) with type INTEGER
{Term2,Bytes3} = case Opt band 1 of
1 ->
begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:2/unsigned-unit:8,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,
Res1 = {'IP4Address',Term1,Term2},
{Res1,Bytes3}.

enc_DomainName(Val) ->
[begin
Enc1@element = element(3, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
%% attribute name(1) with type IA5String
Enc2@element = element(2, Val),
Enc3@bin = list_to_binary(Enc2@element),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len < 128 ->
[Enc3@len|Enc3@bin];
Enc3@len < 16384 ->
[<<2:2,Enc3@len:14>>|Enc3@bin];
true ->
encode_fragmented(Enc3@bin, 8)
end
end|begin
%% attribute portNumber(2) with type INTEGER
Enc4@element = element(3, Val),
if Enc4@element =:= asn1_NOVALUE ->
[];
Enc4@element bsr 16 =:= 0 ->
<<Enc4@element:16>>;
true ->
exit({error,{asn1,{illegal_integer,Enc4@element}}})
end
end].


dec_DomainName(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute name(1) with type IA5String
{Term1,Bytes2} = begin
V2@Pad3 = bit_size(Bytes1) band 7,
{V2@V0,V2@Buf1} = case Bytes1 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end,
V2@Conv10 = binary_to_list(V2@V0),
{V2@Conv10,V2@Buf1}
end,

%% attribute portNumber(2) with type INTEGER
{Term2,Bytes3} = case Opt band 1 of
1 ->
begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:2/unsigned-unit:8,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,
Res1 = {'DomainName',Term1,Term2},
{Res1,Bytes3}.

enc_MId(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= ip4Address ->
[<<0:1,0:3>>|enc_IP4Address(ChoiceVal)];
ChoiceTag =:= ip6Address ->
[<<0:1,1:3>>|enc_IP6Address(ChoiceVal)];
ChoiceTag =:= domainName ->
[<<0:1,2:3>>|enc_DomainName(ChoiceVal)];
ChoiceTag =:= deviceName ->
begin
Enc5@bin = list_to_binary(ChoiceVal),
Enc5@len = byte_size(Enc5@bin),
Enc5@len@sub = Enc5@len - 1,
if Enc5@len@sub bsr 6 =:= 0 ->
[<<0:1,3:3,Enc5@len@sub:6>>,
align|Enc5@bin]
end
end;
ChoiceTag =:= mtpAddress ->
begin
Enc7@bin = iolist_to_binary(ChoiceVal),
Enc7@len = byte_size(Enc7@bin),
Enc7@len@sub = Enc7@len - 2,
if 0 =< Enc7@len@sub, Enc7@len@sub < 3 ->
[<<0:1,4:3,Enc7@len@sub:2>>,
align|Enc7@bin]
end
end
end.


dec_MId(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:3/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_IP4Address(Bytes2)
end,
{{ip4Address,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_IP6Address(Bytes2)
end,
{{ip6Address,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_DomainName(Bytes2)
end,
{{domainName,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
begin
<<V2@V0:6/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes2,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/binary-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
V2@Conv7 = binary_to_list(V2@V3),
{V2@Conv7,V2@Buf4}
end
end,
{{deviceName,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
begin
<<V3@V0:2/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 2,
V3@Pad5 = bit_size(V3@Buf1) band 7,
<<_:V3@Pad5,V3@V3:V3@Add2/binary-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
V3@Conv7 = binary_to_list(V3@V3),
{V3@Conv7,V3@Buf4}
end
end,
{{mtpAddress,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_Message(Val) ->
[begin
%% attribute version(1) with type INTEGER
Enc2@element = element(2, Val),
if 0 =< Enc2@element, Enc2@element < 100 ->
<<0:1,Enc2@element:7>>;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute mId(2) with type MId
Enc4@element = element(3, Val),
enc_MId(Enc4@element)
end|begin
%% attribute messageBody(3) with type CHOICE
Enc5@element = element(4, Val),
enc_Message_messageBody(Enc5@element)
end].
enc_Message_messageBody(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= messageError ->
[<<0:1>>|enc_ErrorDescriptor(ChoiceVal)];
ChoiceTag =:= transactions ->
[<<1:1>>|enc_Message_messageBody_transactions(ChoiceVal)]
end.
enc_Message_messageBody_transactions(Val) ->
Enc1@len = length(Val),
if Enc1@len < 128 ->
[align,
Enc1@len|[enc_Transaction(Comp) || Comp <- Val]];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|[enc_Transaction(Comp) || Comp <- Val]];
true ->
begin
Enc1@fn = fun(Comp) -> enc_Transaction(Comp) end,
encode_fragmented_sof(Enc1@fn, Val, Enc1@len)
end
end.



dec_Message(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute version(1) with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:7/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute mId(2) with type MId
{Term2,Bytes3} = dec_MId(Bytes2),

%% attribute messageBody(3) with type CHOICE
{Term3,Bytes4} = dec_Message_messageBody(Bytes3),

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10};
<<_:V3@Pad6,1:1,1:1,V3@V9:6,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
V3@Mul11 = V3@V9 * 16384,
{V3@Mul11,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V12:V3@V0/bitstring-unit:1,V3@Buf13/bitstring>> = V3@Buf1,
{V3@V12,V3@Buf13}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
Res1 = {'Message',Term1,Term2,Term3},
{Res1,Bytes6}.


dec_Message_messageBody(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_ErrorDescriptor(Bytes1)
end,
{{messageError,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_Message_messageBody_transactions(Bytes1)
end,
{{transactions,Val},NewBytes}
end.

dec_Message_messageBody_transactions(Bytes) ->
dec_components36(Bytes, []).

enc_AuthData(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
Enc1@len@sub = Enc1@len - 12,
if 0 =< Enc1@len@sub, Enc1@len@sub < 21 ->
[<<Enc1@len@sub:5>>,
align|Enc1@bin]
end.


dec_AuthData(Bytes) ->
begin
<<V1@V0:5/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 12,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/binary-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
V1@Conv7 = binary_to_list(V1@V3),
{V1@Conv7,V1@Buf4}
end.

enc_SequenceNum(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 4 ->
[align|Enc1@bin]
end.


dec_SequenceNum(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end.

enc_SecurityParmIndex(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 4 ->
[align|Enc1@bin]
end.


dec_SecurityParmIndex(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end.

enc_AuthenticationHeader(Val) ->
[align,
begin
%% attribute secParmIndex(1) with type OCTET STRING
Enc1@element = element(2, Val),
Enc2@bin = iolist_to_binary(Enc1@element),
Enc2@len = byte_size(Enc2@bin),
if Enc2@len =:= 4 ->
Enc2@bin
end
end,
begin
%% attribute seqNum(2) with type OCTET STRING
Enc3@element = element(3, Val),
Enc4@bin = iolist_to_binary(Enc3@element),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 4 ->
Enc4@bin
end
end|begin
%% attribute ad(3) with type OCTET STRING
Enc5@element = element(4, Val),
Enc6@bin = iolist_to_binary(Enc5@element),
Enc6@len = byte_size(Enc6@bin),
Enc6@len@sub = Enc6@len - 12,
if 0 =< Enc6@len@sub, Enc6@len@sub < 21 ->
[<<Enc6@len@sub:5,0:3>>|Enc6@bin]
end
end].


dec_AuthenticationHeader(Bytes) ->

%% attribute secParmIndex(1) with type OCTET STRING
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end,

%% attribute seqNum(2) with type OCTET STRING
{Term2,Bytes2} = begin
<<V2@V0:4/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end,

%% attribute ad(3) with type OCTET STRING
{Term3,Bytes3} = begin
<<V3@V0:5/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 12,
<<_:3,V3@V3:V3@Add2/binary-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
V3@Conv6 = binary_to_list(V3@V3),
{V3@Conv6,V3@Buf4}
end,
Res1 = {'AuthenticationHeader',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_MegacoMessage(Val) ->
[begin
Enc1@element = element(2, Val),
if Enc1@element =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
%% attribute authHeader(1) with type AuthenticationHeader
Enc2@element = element(2, Val),
if Enc2@element =:= asn1_NOVALUE ->
[];
true ->
enc_AuthenticationHeader(Enc2@element)
end
end|begin
%% attribute mess(2) with type Message
Enc4@element = element(3, Val),
enc_Message(Enc4@element)
end].


dec_MegacoMessage(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute authHeader(1) with type AuthenticationHeader
{Term1,Bytes2} = case Opt band 1 of
1 ->
dec_AuthenticationHeader(Bytes1);
0 ->
{asn1_NOVALUE,Bytes1}
end,

%% attribute mess(2) with type Message
{Term2,Bytes3} = dec_Message(Bytes2),
Res1 = {'MegacoMessage',Term1,Term2},
{Res1,Bytes3}.


%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    complete(element(1, Arg)),
    ok.

bit_string_name2pos_27([muxToken | T]) ->
    [0 | bit_string_name2pos_27(T)];
bit_string_name2pos_27([modemToken | T]) ->
    [1 | bit_string_name2pos_27(T)];
bit_string_name2pos_27([mediaToken | T]) ->
    [2 | bit_string_name2pos_27(T)];
bit_string_name2pos_27([eventsToken | T]) ->
    [3 | bit_string_name2pos_27(T)];
bit_string_name2pos_27([signalsToken | T]) ->
    [4 | bit_string_name2pos_27(T)];
bit_string_name2pos_27([digitMapToken | T]) ->
    [5 | bit_string_name2pos_27(T)];
bit_string_name2pos_27([statsToken | T]) ->
    [6 | bit_string_name2pos_27(T)];
bit_string_name2pos_27([observedEventsToken | T]) ->
    [7 | bit_string_name2pos_27(T)];
bit_string_name2pos_27([packagesToken | T]) ->
    [8 | bit_string_name2pos_27(T)];
bit_string_name2pos_27([eventBufferToken | T]) ->
    [9 | bit_string_name2pos_27(T)];
bit_string_name2pos_27([{bit, Pos} | T]) when is_integer(Pos) ->
    [Pos | bit_string_name2pos_27(T)];
bit_string_name2pos_27([]) ->
    [];
bit_string_name2pos_27(_) ->
    throw(invalid).

bit_string_name2pos_6([onTimeOut | T]) ->
    [0 | bit_string_name2pos_6(T)];
bit_string_name2pos_6([onInterruptByEvent | T]) ->
    [1 | bit_string_name2pos_6(T)];
bit_string_name2pos_6([onInterruptByNewSignalDescr | T]) ->
    [2 | bit_string_name2pos_6(T)];
bit_string_name2pos_6([otherReason | T]) ->
    [3 | bit_string_name2pos_6(T)];
bit_string_name2pos_6([{bit, Pos} | T]) when is_integer(Pos) ->
    [Pos | bit_string_name2pos_6(T)];
bit_string_name2pos_6([]) ->
    [];
bit_string_name2pos_6(_) ->
    throw(invalid).

dec_components1(Bytes, Acc) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<_:V1@Pad3,1:1,1:1,V1@V6:6,V1@Buf7/bitstring>> ->
V1@Mul8 = V1@V6 * 16384,
{V1@Mul8,V1@Buf7}
end,
{Acc1,Buf1} = dec_fragment37(V1@V0, V1@Buf1, Acc),
if V1@V0 >= 16384 ->
dec_components1(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components10(Bytes, Acc) ->
%% Length with constraint no
V2@Pad3 = bit_size(Bytes) band 7,
{V2@V0,V2@Buf1} = case Bytes of
<<_:V2@Pad3,0:1,V2@V5:7,V2@Buf6/bitstring>> ->
{V2@V5,V2@Buf6};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@Buf7/bitstring>> ->
{V2@V6,V2@Buf7};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
V2@Mul8 = V2@V6 * 16384,
{V2@Mul8,V2@Buf7}
end,
{Acc1,Buf1} = dec_fragment38(V2@V0, V2@Buf1, Acc),
if V2@V0 >= 16384 ->
dec_components10(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components11(Bytes, Acc) ->
%% Length with constraint no
V3@Pad3 = bit_size(Bytes) band 7,
{V3@V0,V3@Buf1} = case Bytes of
<<_:V3@Pad3,0:1,V3@V5:7,V3@Buf6/bitstring>> ->
{V3@V5,V3@Buf6};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@Buf7/bitstring>> ->
{V3@V6,V3@Buf7};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
V3@Mul8 = V3@V6 * 16384,
{V3@Mul8,V3@Buf7}
end,
{Acc1,Buf1} = dec_fragment39(V3@V0, V3@Buf1, Acc),
if V3@V0 >= 16384 ->
dec_components11(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components12(Bytes, Acc) ->
%% Length with constraint no
V4@Pad3 = bit_size(Bytes) band 7,
{V4@V0,V4@Buf1} = case Bytes of
<<_:V4@Pad3,0:1,V4@V5:7,V4@Buf6/bitstring>> ->
{V4@V5,V4@Buf6};
<<_:V4@Pad3,1:1,0:1,V4@V6:14,V4@Buf7/bitstring>> ->
{V4@V6,V4@Buf7};
<<_:V4@Pad3,1:1,1:1,V4@V6:6,V4@Buf7/bitstring>> ->
V4@Mul8 = V4@V6 * 16384,
{V4@Mul8,V4@Buf7}
end,
{Acc1,Buf1} = dec_fragment40(V4@V0, V4@Buf1, Acc),
if V4@V0 >= 16384 ->
dec_components12(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components13(Bytes, Acc) ->
%% Length with constraint no
V5@Pad3 = bit_size(Bytes) band 7,
{V5@V0,V5@Buf1} = case Bytes of
<<_:V5@Pad3,0:1,V5@V5:7,V5@Buf6/bitstring>> ->
{V5@V5,V5@Buf6};
<<_:V5@Pad3,1:1,0:1,V5@V6:14,V5@Buf7/bitstring>> ->
{V5@V6,V5@Buf7};
<<_:V5@Pad3,1:1,1:1,V5@V6:6,V5@Buf7/bitstring>> ->
V5@Mul8 = V5@V6 * 16384,
{V5@Mul8,V5@Buf7}
end,
{Acc1,Buf1} = dec_fragment41(V5@V0, V5@Buf1, Acc),
if V5@V0 >= 16384 ->
dec_components13(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components14(Bytes, Acc) ->
%% Length with constraint no
V6@Pad3 = bit_size(Bytes) band 7,
{V6@V0,V6@Buf1} = case Bytes of
<<_:V6@Pad3,0:1,V6@V5:7,V6@Buf6/bitstring>> ->
{V6@V5,V6@Buf6};
<<_:V6@Pad3,1:1,0:1,V6@V6:14,V6@Buf7/bitstring>> ->
{V6@V6,V6@Buf7};
<<_:V6@Pad3,1:1,1:1,V6@V6:6,V6@Buf7/bitstring>> ->
V6@Mul8 = V6@V6 * 16384,
{V6@Mul8,V6@Buf7}
end,
{Acc1,Buf1} = dec_fragment42(V6@V0, V6@Buf1, Acc),
if V6@V0 >= 16384 ->
dec_components14(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components15(Bytes, Acc) ->
%% Length with constraint no
V7@Pad3 = bit_size(Bytes) band 7,
{V7@V0,V7@Buf1} = case Bytes of
<<_:V7@Pad3,0:1,V7@V5:7,V7@Buf6/bitstring>> ->
{V7@V5,V7@Buf6};
<<_:V7@Pad3,1:1,0:1,V7@V6:14,V7@Buf7/bitstring>> ->
{V7@V6,V7@Buf7};
<<_:V7@Pad3,1:1,1:1,V7@V6:6,V7@Buf7/bitstring>> ->
V7@Mul8 = V7@V6 * 16384,
{V7@Mul8,V7@Buf7}
end,
{Acc1,Buf1} = dec_fragment43(V7@V0, V7@Buf1, Acc),
if V7@V0 >= 16384 ->
dec_components15(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components16(Bytes, Acc) ->
%% Length with constraint no
V8@Pad3 = bit_size(Bytes) band 7,
{V8@V0,V8@Buf1} = case Bytes of
<<_:V8@Pad3,0:1,V8@V5:7,V8@Buf6/bitstring>> ->
{V8@V5,V8@Buf6};
<<_:V8@Pad3,1:1,0:1,V8@V6:14,V8@Buf7/bitstring>> ->
{V8@V6,V8@Buf7};
<<_:V8@Pad3,1:1,1:1,V8@V6:6,V8@Buf7/bitstring>> ->
V8@Mul8 = V8@V6 * 16384,
{V8@Mul8,V8@Buf7}
end,
{Acc1,Buf1} = dec_fragment44(V8@V0, V8@Buf1, Acc),
if V8@V0 >= 16384 ->
dec_components16(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components17(Bytes, Acc) ->
%% Length with constraint no
V9@Pad3 = bit_size(Bytes) band 7,
{V9@V0,V9@Buf1} = case Bytes of
<<_:V9@Pad3,0:1,V9@V5:7,V9@Buf6/bitstring>> ->
{V9@V5,V9@Buf6};
<<_:V9@Pad3,1:1,0:1,V9@V6:14,V9@Buf7/bitstring>> ->
{V9@V6,V9@Buf7};
<<_:V9@Pad3,1:1,1:1,V9@V6:6,V9@Buf7/bitstring>> ->
V9@Mul8 = V9@V6 * 16384,
{V9@Mul8,V9@Buf7}
end,
{Acc1,Buf1} = dec_fragment45(V9@V0, V9@Buf1, Acc),
if V9@V0 >= 16384 ->
dec_components17(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components18(Bytes, Acc) ->
%% Length with constraint no
V10@Pad3 = bit_size(Bytes) band 7,
{V10@V0,V10@Buf1} = case Bytes of
<<_:V10@Pad3,0:1,V10@V5:7,V10@Buf6/bitstring>> ->
{V10@V5,V10@Buf6};
<<_:V10@Pad3,1:1,0:1,V10@V6:14,V10@Buf7/bitstring>> ->
{V10@V6,V10@Buf7};
<<_:V10@Pad3,1:1,1:1,V10@V6:6,V10@Buf7/bitstring>> ->
V10@Mul8 = V10@V6 * 16384,
{V10@Mul8,V10@Buf7}
end,
{Acc1,Buf1} = dec_fragment46(V10@V0, V10@Buf1, Acc),
if V10@V0 >= 16384 ->
dec_components18(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components19(Bytes, Acc) ->
%% Length with constraint no
V11@Pad3 = bit_size(Bytes) band 7,
{V11@V0,V11@Buf1} = case Bytes of
<<_:V11@Pad3,0:1,V11@V5:7,V11@Buf6/bitstring>> ->
{V11@V5,V11@Buf6};
<<_:V11@Pad3,1:1,0:1,V11@V6:14,V11@Buf7/bitstring>> ->
{V11@V6,V11@Buf7};
<<_:V11@Pad3,1:1,1:1,V11@V6:6,V11@Buf7/bitstring>> ->
V11@Mul8 = V11@V6 * 16384,
{V11@Mul8,V11@Buf7}
end,
{Acc1,Buf1} = dec_fragment47(V11@V0, V11@Buf1, Acc),
if V11@V0 >= 16384 ->
dec_components19(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components2(Bytes, Acc) ->
%% Length with constraint no
V12@Pad3 = bit_size(Bytes) band 7,
{V12@V0,V12@Buf1} = case Bytes of
<<_:V12@Pad3,0:1,V12@V5:7,V12@Buf6/bitstring>> ->
{V12@V5,V12@Buf6};
<<_:V12@Pad3,1:1,0:1,V12@V6:14,V12@Buf7/bitstring>> ->
{V12@V6,V12@Buf7};
<<_:V12@Pad3,1:1,1:1,V12@V6:6,V12@Buf7/bitstring>> ->
V12@Mul8 = V12@V6 * 16384,
{V12@Mul8,V12@Buf7}
end,
{Acc1,Buf1} = dec_fragment48(V12@V0, V12@Buf1, Acc),
if V12@V0 >= 16384 ->
dec_components2(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components20(Bytes, Acc) ->
%% Length with constraint no
V13@Pad3 = bit_size(Bytes) band 7,
{V13@V0,V13@Buf1} = case Bytes of
<<_:V13@Pad3,0:1,V13@V5:7,V13@Buf6/bitstring>> ->
{V13@V5,V13@Buf6};
<<_:V13@Pad3,1:1,0:1,V13@V6:14,V13@Buf7/bitstring>> ->
{V13@V6,V13@Buf7};
<<_:V13@Pad3,1:1,1:1,V13@V6:6,V13@Buf7/bitstring>> ->
V13@Mul8 = V13@V6 * 16384,
{V13@Mul8,V13@Buf7}
end,
{Acc1,Buf1} = dec_fragment49(V13@V0, V13@Buf1, Acc),
if V13@V0 >= 16384 ->
dec_components20(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components21(Bytes, Acc) ->
%% Length with constraint no
V14@Pad3 = bit_size(Bytes) band 7,
{V14@V0,V14@Buf1} = case Bytes of
<<_:V14@Pad3,0:1,V14@V5:7,V14@Buf6/bitstring>> ->
{V14@V5,V14@Buf6};
<<_:V14@Pad3,1:1,0:1,V14@V6:14,V14@Buf7/bitstring>> ->
{V14@V6,V14@Buf7};
<<_:V14@Pad3,1:1,1:1,V14@V6:6,V14@Buf7/bitstring>> ->
V14@Mul8 = V14@V6 * 16384,
{V14@Mul8,V14@Buf7}
end,
{Acc1,Buf1} = dec_fragment50(V14@V0, V14@Buf1, Acc),
if V14@V0 >= 16384 ->
dec_components21(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components22(Bytes, Acc) ->
%% Length with constraint no
V15@Pad3 = bit_size(Bytes) band 7,
{V15@V0,V15@Buf1} = case Bytes of
<<_:V15@Pad3,0:1,V15@V5:7,V15@Buf6/bitstring>> ->
{V15@V5,V15@Buf6};
<<_:V15@Pad3,1:1,0:1,V15@V6:14,V15@Buf7/bitstring>> ->
{V15@V6,V15@Buf7};
<<_:V15@Pad3,1:1,1:1,V15@V6:6,V15@Buf7/bitstring>> ->
V15@Mul8 = V15@V6 * 16384,
{V15@Mul8,V15@Buf7}
end,
{Acc1,Buf1} = dec_fragment51(V15@V0, V15@Buf1, Acc),
if V15@V0 >= 16384 ->
dec_components22(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components23(Bytes, Acc) ->
%% Length with constraint no
V16@Pad3 = bit_size(Bytes) band 7,
{V16@V0,V16@Buf1} = case Bytes of
<<_:V16@Pad3,0:1,V16@V5:7,V16@Buf6/bitstring>> ->
{V16@V5,V16@Buf6};
<<_:V16@Pad3,1:1,0:1,V16@V6:14,V16@Buf7/bitstring>> ->
{V16@V6,V16@Buf7};
<<_:V16@Pad3,1:1,1:1,V16@V6:6,V16@Buf7/bitstring>> ->
V16@Mul8 = V16@V6 * 16384,
{V16@Mul8,V16@Buf7}
end,
{Acc1,Buf1} = dec_fragment52(V16@V0, V16@Buf1, Acc),
if V16@V0 >= 16384 ->
dec_components23(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components24(Bytes, Acc) ->
%% Length with constraint no
V17@Pad3 = bit_size(Bytes) band 7,
{V17@V0,V17@Buf1} = case Bytes of
<<_:V17@Pad3,0:1,V17@V5:7,V17@Buf6/bitstring>> ->
{V17@V5,V17@Buf6};
<<_:V17@Pad3,1:1,0:1,V17@V6:14,V17@Buf7/bitstring>> ->
{V17@V6,V17@Buf7};
<<_:V17@Pad3,1:1,1:1,V17@V6:6,V17@Buf7/bitstring>> ->
V17@Mul8 = V17@V6 * 16384,
{V17@Mul8,V17@Buf7}
end,
{Acc1,Buf1} = dec_fragment53(V17@V0, V17@Buf1, Acc),
if V17@V0 >= 16384 ->
dec_components24(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components25(Bytes, Acc) ->
%% Length with constraint no
V18@Pad3 = bit_size(Bytes) band 7,
{V18@V0,V18@Buf1} = case Bytes of
<<_:V18@Pad3,0:1,V18@V5:7,V18@Buf6/bitstring>> ->
{V18@V5,V18@Buf6};
<<_:V18@Pad3,1:1,0:1,V18@V6:14,V18@Buf7/bitstring>> ->
{V18@V6,V18@Buf7};
<<_:V18@Pad3,1:1,1:1,V18@V6:6,V18@Buf7/bitstring>> ->
V18@Mul8 = V18@V6 * 16384,
{V18@Mul8,V18@Buf7}
end,
{Acc1,Buf1} = dec_fragment54(V18@V0, V18@Buf1, Acc),
if V18@V0 >= 16384 ->
dec_components25(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components26(Bytes, Acc) ->
%% Length with constraint no
V19@Pad3 = bit_size(Bytes) band 7,
{V19@V0,V19@Buf1} = case Bytes of
<<_:V19@Pad3,0:1,V19@V5:7,V19@Buf6/bitstring>> ->
{V19@V5,V19@Buf6};
<<_:V19@Pad3,1:1,0:1,V19@V6:14,V19@Buf7/bitstring>> ->
{V19@V6,V19@Buf7};
<<_:V19@Pad3,1:1,1:1,V19@V6:6,V19@Buf7/bitstring>> ->
V19@Mul8 = V19@V6 * 16384,
{V19@Mul8,V19@Buf7}
end,
{Acc1,Buf1} = dec_fragment55(V19@V0, V19@Buf1, Acc),
if V19@V0 >= 16384 ->
dec_components26(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components28(Bytes, Acc) ->
%% Length with constraint no
V20@Pad3 = bit_size(Bytes) band 7,
{V20@V0,V20@Buf1} = case Bytes of
<<_:V20@Pad3,0:1,V20@V5:7,V20@Buf6/bitstring>> ->
{V20@V5,V20@Buf6};
<<_:V20@Pad3,1:1,0:1,V20@V6:14,V20@Buf7/bitstring>> ->
{V20@V6,V20@Buf7};
<<_:V20@Pad3,1:1,1:1,V20@V6:6,V20@Buf7/bitstring>> ->
V20@Mul8 = V20@V6 * 16384,
{V20@Mul8,V20@Buf7}
end,
{Acc1,Buf1} = dec_fragment56(V20@V0, V20@Buf1, Acc),
if V20@V0 >= 16384 ->
dec_components28(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components29(Bytes, Acc) ->
%% Length with constraint no
V21@Pad3 = bit_size(Bytes) band 7,
{V21@V0,V21@Buf1} = case Bytes of
<<_:V21@Pad3,0:1,V21@V5:7,V21@Buf6/bitstring>> ->
{V21@V5,V21@Buf6};
<<_:V21@Pad3,1:1,0:1,V21@V6:14,V21@Buf7/bitstring>> ->
{V21@V6,V21@Buf7};
<<_:V21@Pad3,1:1,1:1,V21@V6:6,V21@Buf7/bitstring>> ->
V21@Mul8 = V21@V6 * 16384,
{V21@Mul8,V21@Buf7}
end,
{Acc1,Buf1} = dec_fragment57(V21@V0, V21@Buf1, Acc),
if V21@V0 >= 16384 ->
dec_components29(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components3(Bytes, Acc) ->
%% Length with constraint no
V22@Pad3 = bit_size(Bytes) band 7,
{V22@V0,V22@Buf1} = case Bytes of
<<_:V22@Pad3,0:1,V22@V5:7,V22@Buf6/bitstring>> ->
{V22@V5,V22@Buf6};
<<_:V22@Pad3,1:1,0:1,V22@V6:14,V22@Buf7/bitstring>> ->
{V22@V6,V22@Buf7};
<<_:V22@Pad3,1:1,1:1,V22@V6:6,V22@Buf7/bitstring>> ->
V22@Mul8 = V22@V6 * 16384,
{V22@Mul8,V22@Buf7}
end,
{Acc1,Buf1} = dec_fragment58(V22@V0, V22@Buf1, Acc),
if V22@V0 >= 16384 ->
dec_components3(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components30(Bytes, Acc) ->
%% Length with constraint no
V23@Pad3 = bit_size(Bytes) band 7,
{V23@V0,V23@Buf1} = case Bytes of
<<_:V23@Pad3,0:1,V23@V5:7,V23@Buf6/bitstring>> ->
{V23@V5,V23@Buf6};
<<_:V23@Pad3,1:1,0:1,V23@V6:14,V23@Buf7/bitstring>> ->
{V23@V6,V23@Buf7};
<<_:V23@Pad3,1:1,1:1,V23@V6:6,V23@Buf7/bitstring>> ->
V23@Mul8 = V23@V6 * 16384,
{V23@Mul8,V23@Buf7}
end,
{Acc1,Buf1} = dec_fragment59(V23@V0, V23@Buf1, Acc),
if V23@V0 >= 16384 ->
dec_components30(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components31(Bytes, Acc) ->
%% Length with constraint no
V24@Pad3 = bit_size(Bytes) band 7,
{V24@V0,V24@Buf1} = case Bytes of
<<_:V24@Pad3,0:1,V24@V5:7,V24@Buf6/bitstring>> ->
{V24@V5,V24@Buf6};
<<_:V24@Pad3,1:1,0:1,V24@V6:14,V24@Buf7/bitstring>> ->
{V24@V6,V24@Buf7};
<<_:V24@Pad3,1:1,1:1,V24@V6:6,V24@Buf7/bitstring>> ->
V24@Mul8 = V24@V6 * 16384,
{V24@Mul8,V24@Buf7}
end,
{Acc1,Buf1} = dec_fragment60(V24@V0, V24@Buf1, Acc),
if V24@V0 >= 16384 ->
dec_components31(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components32(Bytes, Acc) ->
%% Length with constraint no
V25@Pad3 = bit_size(Bytes) band 7,
{V25@V0,V25@Buf1} = case Bytes of
<<_:V25@Pad3,0:1,V25@V5:7,V25@Buf6/bitstring>> ->
{V25@V5,V25@Buf6};
<<_:V25@Pad3,1:1,0:1,V25@V6:14,V25@Buf7/bitstring>> ->
{V25@V6,V25@Buf7};
<<_:V25@Pad3,1:1,1:1,V25@V6:6,V25@Buf7/bitstring>> ->
V25@Mul8 = V25@V6 * 16384,
{V25@Mul8,V25@Buf7}
end,
{Acc1,Buf1} = dec_fragment61(V25@V0, V25@Buf1, Acc),
if V25@V0 >= 16384 ->
dec_components32(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components33(Bytes, Acc) ->
%% Length with constraint no
V26@Pad3 = bit_size(Bytes) band 7,
{V26@V0,V26@Buf1} = case Bytes of
<<_:V26@Pad3,0:1,V26@V5:7,V26@Buf6/bitstring>> ->
{V26@V5,V26@Buf6};
<<_:V26@Pad3,1:1,0:1,V26@V6:14,V26@Buf7/bitstring>> ->
{V26@V6,V26@Buf7};
<<_:V26@Pad3,1:1,1:1,V26@V6:6,V26@Buf7/bitstring>> ->
V26@Mul8 = V26@V6 * 16384,
{V26@Mul8,V26@Buf7}
end,
{Acc1,Buf1} = dec_fragment62(V26@V0, V26@Buf1, Acc),
if V26@V0 >= 16384 ->
dec_components33(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components34(Bytes, Acc) ->
%% Length with constraint no
V27@Pad3 = bit_size(Bytes) band 7,
{V27@V0,V27@Buf1} = case Bytes of
<<_:V27@Pad3,0:1,V27@V5:7,V27@Buf6/bitstring>> ->
{V27@V5,V27@Buf6};
<<_:V27@Pad3,1:1,0:1,V27@V6:14,V27@Buf7/bitstring>> ->
{V27@V6,V27@Buf7};
<<_:V27@Pad3,1:1,1:1,V27@V6:6,V27@Buf7/bitstring>> ->
V27@Mul8 = V27@V6 * 16384,
{V27@Mul8,V27@Buf7}
end,
{Acc1,Buf1} = dec_fragment63(V27@V0, V27@Buf1, Acc),
if V27@V0 >= 16384 ->
dec_components34(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components35(Bytes, Acc) ->
%% Length with constraint no
V28@Pad3 = bit_size(Bytes) band 7,
{V28@V0,V28@Buf1} = case Bytes of
<<_:V28@Pad3,0:1,V28@V5:7,V28@Buf6/bitstring>> ->
{V28@V5,V28@Buf6};
<<_:V28@Pad3,1:1,0:1,V28@V6:14,V28@Buf7/bitstring>> ->
{V28@V6,V28@Buf7};
<<_:V28@Pad3,1:1,1:1,V28@V6:6,V28@Buf7/bitstring>> ->
V28@Mul8 = V28@V6 * 16384,
{V28@Mul8,V28@Buf7}
end,
{Acc1,Buf1} = dec_fragment64(V28@V0, V28@Buf1, Acc),
if V28@V0 >= 16384 ->
dec_components35(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components36(Bytes, Acc) ->
%% Length with constraint no
V29@Pad3 = bit_size(Bytes) band 7,
{V29@V0,V29@Buf1} = case Bytes of
<<_:V29@Pad3,0:1,V29@V5:7,V29@Buf6/bitstring>> ->
{V29@V5,V29@Buf6};
<<_:V29@Pad3,1:1,0:1,V29@V6:14,V29@Buf7/bitstring>> ->
{V29@V6,V29@Buf7};
<<_:V29@Pad3,1:1,1:1,V29@V6:6,V29@Buf7/bitstring>> ->
V29@Mul8 = V29@V6 * 16384,
{V29@Mul8,V29@Buf7}
end,
{Acc1,Buf1} = dec_fragment65(V29@V0, V29@Buf1, Acc),
if V29@V0 >= 16384 ->
dec_components36(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components4(Bytes, Acc) ->
%% Length with constraint no
V30@Pad3 = bit_size(Bytes) band 7,
{V30@V0,V30@Buf1} = case Bytes of
<<_:V30@Pad3,0:1,V30@V5:7,V30@Buf6/bitstring>> ->
{V30@V5,V30@Buf6};
<<_:V30@Pad3,1:1,0:1,V30@V6:14,V30@Buf7/bitstring>> ->
{V30@V6,V30@Buf7};
<<_:V30@Pad3,1:1,1:1,V30@V6:6,V30@Buf7/bitstring>> ->
V30@Mul8 = V30@V6 * 16384,
{V30@Mul8,V30@Buf7}
end,
{Acc1,Buf1} = dec_fragment66(V30@V0, V30@Buf1, Acc),
if V30@V0 >= 16384 ->
dec_components4(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components5(Bytes, Acc) ->
%% Length with constraint no
V31@Pad3 = bit_size(Bytes) band 7,
{V31@V0,V31@Buf1} = case Bytes of
<<_:V31@Pad3,0:1,V31@V5:7,V31@Buf6/bitstring>> ->
{V31@V5,V31@Buf6};
<<_:V31@Pad3,1:1,0:1,V31@V6:14,V31@Buf7/bitstring>> ->
{V31@V6,V31@Buf7};
<<_:V31@Pad3,1:1,1:1,V31@V6:6,V31@Buf7/bitstring>> ->
V31@Mul8 = V31@V6 * 16384,
{V31@Mul8,V31@Buf7}
end,
{Acc1,Buf1} = dec_fragment67(V31@V0, V31@Buf1, Acc),
if V31@V0 >= 16384 ->
dec_components5(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components7(Bytes, Acc) ->
%% Length with constraint no
V32@Pad3 = bit_size(Bytes) band 7,
{V32@V0,V32@Buf1} = case Bytes of
<<_:V32@Pad3,0:1,V32@V5:7,V32@Buf6/bitstring>> ->
{V32@V5,V32@Buf6};
<<_:V32@Pad3,1:1,0:1,V32@V6:14,V32@Buf7/bitstring>> ->
{V32@V6,V32@Buf7};
<<_:V32@Pad3,1:1,1:1,V32@V6:6,V32@Buf7/bitstring>> ->
V32@Mul8 = V32@V6 * 16384,
{V32@Mul8,V32@Buf7}
end,
{Acc1,Buf1} = dec_fragment68(V32@V0, V32@Buf1, Acc),
if V32@V0 >= 16384 ->
dec_components7(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components8(Bytes, Acc) ->
%% Length with constraint no
V33@Pad3 = bit_size(Bytes) band 7,
{V33@V0,V33@Buf1} = case Bytes of
<<_:V33@Pad3,0:1,V33@V5:7,V33@Buf6/bitstring>> ->
{V33@V5,V33@Buf6};
<<_:V33@Pad3,1:1,0:1,V33@V6:14,V33@Buf7/bitstring>> ->
{V33@V6,V33@Buf7};
<<_:V33@Pad3,1:1,1:1,V33@V6:6,V33@Buf7/bitstring>> ->
V33@Mul8 = V33@V6 * 16384,
{V33@Mul8,V33@Buf7}
end,
{Acc1,Buf1} = dec_fragment69(V33@V0, V33@Buf1, Acc),
if V33@V0 >= 16384 ->
dec_components8(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_components9(Bytes, Acc) ->
%% Length with constraint no
V34@Pad3 = bit_size(Bytes) band 7,
{V34@V0,V34@Buf1} = case Bytes of
<<_:V34@Pad3,0:1,V34@V5:7,V34@Buf6/bitstring>> ->
{V34@V5,V34@Buf6};
<<_:V34@Pad3,1:1,0:1,V34@V6:14,V34@Buf7/bitstring>> ->
{V34@V6,V34@Buf7};
<<_:V34@Pad3,1:1,1:1,V34@V6:6,V34@Buf7/bitstring>> ->
V34@Mul8 = V34@V6 * 16384,
{V34@Mul8,V34@Buf7}
end,
{Acc1,Buf1} = dec_fragment70(V34@V0, V34@Buf1, Acc),
if V34@V0 >= 16384 ->
dec_components9(Buf1, Acc1);
true ->
{lists:reverse(Acc1),Buf1}
end.

dec_fragment37(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment37(Num, Bytes, Acc) ->
{Term,Remain} = begin
V35@Pad3 = bit_size(Bytes) band 7,
{V35@V0,V35@Buf1} = case Bytes of
<<_:V35@Pad3,0:1,V35@V5:7,V35@V7:V35@V5/binary-unit:8,V35@Buf8/bitstring>> ->
{V35@V7,V35@Buf8};
<<_:V35@Pad3,1:1,0:1,V35@V6:14,V35@V8:V35@V6/binary-unit:8,V35@Buf9/bitstring>> ->
{V35@V8,V35@Buf9};
<<_:V35@Pad3,1:1,1:1,V35@V6:6,V35@Buf7/bitstring>> ->
{V35@V8,V35@Buf9}  = decode_fragmented(V35@V6, V35@Buf7, 8),
{V35@V8,V35@Buf9}
end,
V35@Conv10 = binary_to_list(V35@V0),
{V35@Conv10,V35@Buf1}
end,
dec_fragment37(Num-1, Remain, [Term|Acc]).

dec_fragment38(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment38(Num, Bytes, Acc) ->
{Term,Remain} = dec_EventParameter(Bytes),
dec_fragment38(Num-1, Remain, [Term|Acc]).

dec_fragment39(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment39(Num, Bytes, Acc) ->
{Term,Remain} = dec_EventSpec(Bytes),
dec_fragment39(Num-1, Remain, [Term|Acc]).

dec_fragment40(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment40(Num, Bytes, Acc) ->
{Term,Remain} = dec_EventParameter(Bytes),
dec_fragment40(Num-1, Remain, [Term|Acc]).

dec_fragment41(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment41(Num, Bytes, Acc) ->
{Term,Remain} = dec_SecondRequestedEvent(Bytes),
dec_fragment41(Num-1, Remain, [Term|Acc]).

dec_fragment42(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment42(Num, Bytes, Acc) ->
{Term,Remain} = dec_EventParameter(Bytes),
dec_fragment42(Num-1, Remain, [Term|Acc]).

dec_fragment43(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment43(Num, Bytes, Acc) ->
{Term,Remain} = dec_RequestedEvent(Bytes),
dec_fragment43(Num-1, Remain, [Term|Acc]).

dec_fragment44(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment44(Num, Bytes, Acc) ->
{Term,Remain} = dec_TerminationID(Bytes),
dec_fragment44(Num-1, Remain, [Term|Acc]).

dec_fragment45(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment45(Num, Bytes, Acc) ->
{Term,Remain} = dec_PropertyParm(Bytes),
dec_fragment45(Num-1, Remain, [Term|Acc]).

dec_fragment46(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment46(Num, Bytes, Acc) ->
{Term,Remain} = dec_PropertyParm(Bytes),
dec_fragment46(Num-1, Remain, [Term|Acc]).

dec_fragment47(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment47(Num, Bytes, Acc) ->
{Term,Remain} = dec_PropertyGroup(Bytes),
dec_fragment47(Num-1, Remain, [Term|Acc]).

dec_fragment48(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment48(Num, Bytes, Acc) ->
{Term,Remain} = dec_StatisticsParameter(Bytes),
dec_fragment48(Num-1, Remain, [Term|Acc]).

dec_fragment49(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment49(Num, Bytes, Acc) ->
{Term,Remain} = begin
V36@Pad3 = bit_size(Bytes) band 7,
{V36@V0,V36@Buf1} = case Bytes of
<<_:V36@Pad3,0:1,V36@V5:7,V36@V7:V36@V5/binary-unit:8,V36@Buf8/bitstring>> ->
{V36@V7,V36@Buf8};
<<_:V36@Pad3,1:1,0:1,V36@V6:14,V36@V8:V36@V6/binary-unit:8,V36@Buf9/bitstring>> ->
{V36@V8,V36@Buf9};
<<_:V36@Pad3,1:1,1:1,V36@V6:6,V36@Buf7/bitstring>> ->
{V36@V8,V36@Buf9}  = decode_fragmented(V36@V6, V36@Buf7, 8),
{V36@V8,V36@Buf9}
end,
V36@Conv10 = binary_to_list(V36@V0),
{V36@Conv10,V36@Buf1}
end,
dec_fragment49(Num-1, Remain, [Term|Acc]).

dec_fragment50(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment50(Num, Bytes, Acc) ->
{Term,Remain} = dec_PropertyParm(Bytes),
dec_fragment50(Num-1, Remain, [Term|Acc]).

dec_fragment51(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment51(Num, Bytes, Acc) ->
{Term,Remain} = dec_StreamDescriptor(Bytes),
dec_fragment51(Num-1, Remain, [Term|Acc]).

dec_fragment52(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment52(Num, Bytes, Acc) ->
{Term,Remain} = dec_TerminationID(Bytes),
dec_fragment52(Num-1, Remain, [Term|Acc]).

dec_fragment53(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment53(Num, Bytes, Acc) ->
{Term,Remain} = begin
<<V37@V0:1/binary-unit:8,V37@Buf1/bitstring>> = Bytes,
V37@Conv2 = binary_to_list(V37@V0),
{V37@Conv2,V37@Buf1}
end,
dec_fragment53(Num-1, Remain, [Term|Acc]).

dec_fragment54(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment54(Num, Bytes, Acc) ->
{Term,Remain} = dec_EventParameter(Bytes),
dec_fragment54(Num-1, Remain, [Term|Acc]).

dec_fragment55(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment55(Num, Bytes, Acc) ->
{Term,Remain} = dec_ObservedEvent(Bytes),
dec_fragment55(Num-1, Remain, [Term|Acc]).

dec_fragment56(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment56(Num, Bytes, Acc) ->
{Term,Remain} = dec_AuditReturnParameter(Bytes),
dec_fragment56(Num-1, Remain, [Term|Acc]).

dec_fragment57(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment57(Num, Bytes, Acc) ->
{Term,Remain} = dec_AmmDescriptor(Bytes),
dec_fragment57(Num-1, Remain, [Term|Acc]).

dec_fragment58(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment58(Num, Bytes, Acc) ->
{Term,Remain} = dec_PackagesItem(Bytes),
dec_fragment58(Num-1, Remain, [Term|Acc]).

dec_fragment59(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment59(Num, Bytes, Acc) ->
{Term,Remain} = dec_TopologyRequest(Bytes),
dec_fragment59(Num-1, Remain, [Term|Acc]).

dec_fragment60(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment60(Num, Bytes, Acc) ->
{Term,Remain} = dec_CommandReply(Bytes),
dec_fragment60(Num-1, Remain, [Term|Acc]).

dec_fragment61(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment61(Num, Bytes, Acc) ->
{Term,Remain} = dec_CommandRequest(Bytes),
dec_fragment61(Num-1, Remain, [Term|Acc]).

dec_fragment62(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment62(Num, Bytes, Acc) ->
{Term,Remain} = dec_TransactionAck(Bytes),
dec_fragment62(Num-1, Remain, [Term|Acc]).

dec_fragment63(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment63(Num, Bytes, Acc) ->
{Term,Remain} = dec_ActionReply(Bytes),
dec_fragment63(Num-1, Remain, [Term|Acc]).

dec_fragment64(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment64(Num, Bytes, Acc) ->
{Term,Remain} = dec_ActionRequest(Bytes),
dec_fragment64(Num-1, Remain, [Term|Acc]).

dec_fragment65(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment65(Num, Bytes, Acc) ->
{Term,Remain} = dec_Transaction(Bytes),
dec_fragment65(Num-1, Remain, [Term|Acc]).

dec_fragment66(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment66(Num, Bytes, Acc) ->
{Term,Remain} = begin
{V38@V0,V38@Buf1} = case Bytes of
<<0:1,V38@V3:4/unsigned-unit:1,V38@Buf4/bitstring>> ->
V38@Int5 = case V38@V3 of
0 -> v18;
1 -> v22;
2 -> v22bis;
3 -> v32;
4 -> v32bis;
5 -> v34;
6 -> v90;
7 -> v91;
8 -> synchISDN;
_ -> exit({error,{asn1,{decode_enumerated,V38@V3}}})
end,
{V38@Int5,V38@Buf4};
<<1:1,V38@Buf2/bitstring>> ->
{V38@V3,V38@Buf4} = case V38@Buf2 of
<<0:1,V38@V6:6,V38@Buf7/bitstring>> ->
{V38@V6,V38@Buf7};
<<1:1,V38@Buf5/bitstring>> ->
V38@Pad9 = bit_size(V38@Buf5) band 7,
{V38@V6,V38@Buf7} = case V38@Buf5 of
<<_:V38@Pad9,0:1,V38@V11:7,V38@Buf12/bitstring>> when V38@V11 =/= 0 ->
{V38@V11,V38@Buf12};
<<_:V38@Pad9,1:1,0:1,V38@V12:14,V38@Buf13/bitstring>> when V38@V12 =/= 0 ->
{V38@V12,V38@Buf13};
<<_:V38@Pad9,1:1,1:1,V38@V12:6,V38@Buf13/bitstring>> when V38@V12 =/= 0 ->
V38@Mul14 = V38@V12 * 16384,
{V38@Mul14,V38@Buf13}
end,
<<V38@V15:V38@V6/unit:8,V38@Buf16/bitstring>> = V38@Buf7,
{V38@V15,V38@Buf16}
end,
V38@Int17 = case V38@V3 of
_ -> {asn1_enum,V38@V3}
end,
{V38@Int17,V38@Buf4}
end,
{V38@V0,V38@Buf1}
end,
dec_fragment66(Num-1, Remain, [Term|Acc]).

dec_fragment67(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment67(Num, Bytes, Acc) ->
{Term,Remain} = dec_PropertyParm(Bytes),
dec_fragment67(Num-1, Remain, [Term|Acc]).

dec_fragment68(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment68(Num, Bytes, Acc) ->
{Term,Remain} = dec_SigParameter(Bytes),
dec_fragment68(Num-1, Remain, [Term|Acc]).

dec_fragment69(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment69(Num, Bytes, Acc) ->
{Term,Remain} = dec_Signal(Bytes),
dec_fragment69(Num-1, Remain, [Term|Acc]).

dec_fragment70(0, Bytes, Acc) ->
{Acc,Bytes};
dec_fragment70(Num, Bytes, Acc) ->
{Term,Remain} = dec_SignalRequest(Bytes),
dec_fragment70(Num-1, Remain, [Term|Acc]).

align(Bin) when is_binary(Bin) ->
    Bin;
align(BitStr) when is_bitstring(BitStr) ->
    AlignBits = bit_size(BitStr) rem 8,
    <<_:AlignBits,Rest/binary>> = BitStr,
    Rest.

bitstring_from_positions([]) ->
    <<>>;
bitstring_from_positions([_ | _] = L0) ->
    L1 = lists:sort(L0),
    L = diff(L1, -1),
    << 
      <<1:(N + 0)>> ||
          N <- L
    >>.

bs_drop_trailing_zeroes(Bs) ->
    bs_drop_trailing_zeroes(Bs, bit_size(Bs)).

bs_drop_trailing_zeroes(Bs, 0) ->
    Bs;
bs_drop_trailing_zeroes(Bs0, Sz0) when Sz0 < 8 ->
    <<Byte:Sz0>> = Bs0,
    Sz = Sz0 - ntz(Byte),
    <<Bs:Sz/bits,_/bits>> = Bs0,
    Bs;
bs_drop_trailing_zeroes(Bs0, Sz0) ->
    Sz1 = Sz0 - 8,
    <<Bs1:Sz1/bits,Byte:8>> = Bs0,
    case ntz(Byte) of
        8 ->
            bs_drop_trailing_zeroes(Bs1, Sz1);
        Ntz ->
            Sz = Sz0 - Ntz,
            <<Bs:Sz/bits,_:Ntz/bits>> = Bs0,
            Bs
    end.

complete(L0) ->
    L = complete(L0, []),
    case list_to_bitstring(L) of
        <<>> ->
            <<0>>;
        Bin ->
            Bin
    end.

complete([], Bits, []) ->
    case Bits band 7 of
        0 ->
            [];
        N ->
            [<<0:(8 - N)>>]
    end;
complete([], Bits, [H | More]) ->
    complete(H, Bits, More);
complete([align | T], Bits, More) ->
    case Bits band 7 of
        0 ->
            complete(T, More);
        1 ->
            [<<0:7>> | complete(T, More)];
        2 ->
            [<<0:6>> | complete(T, More)];
        3 ->
            [<<0:5>> | complete(T, More)];
        4 ->
            [<<0:4>> | complete(T, More)];
        5 ->
            [<<0:3>> | complete(T, More)];
        6 ->
            [<<0:2>> | complete(T, More)];
        7 ->
            [<<0:1>> | complete(T, More)]
    end;
complete([[] | T], Bits, More) ->
    complete(T, Bits, More);
complete([[_ | _] = H], Bits, More) ->
    complete(H, Bits, More);
complete([[_ | _] = H | T], Bits, More) ->
    complete(H, Bits, [T | More]);
complete([H | T], Bits, More) when is_integer(H); is_binary(H) ->
    [H | complete(T, Bits, More)];
complete([H | T], Bits, More) ->
    [H | complete(T, Bits + bit_size(H), More)];
complete(Bin, Bits, More) when is_binary(Bin) ->
    [Bin | complete([], Bits, More)];
complete(Bin, Bits, More) ->
    [Bin | complete([], Bits + bit_size(Bin), More)].

complete([], []) ->
    [];
complete([], [H | More]) ->
    complete(H, More);
complete([align | T], More) ->
    complete(T, More);
complete([[] | T], More) ->
    complete(T, More);
complete([[_ | _] = H], More) ->
    complete(H, More);
complete([[_ | _] = H | T], More) ->
    complete(H, [T | More]);
complete([H | T], More) when is_integer(H); is_binary(H) ->
    [H | complete(T, More)];
complete([H | T], More) ->
    [H | complete(T, bit_size(H), More)];
complete(Bin, More) when is_binary(Bin) ->
    [Bin | complete([], More)];
complete(Bin, More) ->
    [Bin | complete([], bit_size(Bin), More)].

dec_subidentifiers([H | T], Av, Al) when H >= 128 ->
    dec_subidentifiers(T, Av bsl 7 bor H band 127, Al);
dec_subidentifiers([H | T], Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 bor H | Al]);
dec_subidentifiers([], _Av, Al) ->
    lists:reverse(Al).

decode_fragmented(SegSz0, Buf0, Unit) ->
    SegSz = SegSz0 * Unit * 16384,
    <<Res:SegSz/bitstring,Buf/bitstring>> = Buf0,
    decode_fragmented_1(Buf, Unit, Res).

decode_fragmented_1(<<0:1,N:7,Buf0/bitstring>>, Unit, Res) ->
    Sz = N * Unit,
    <<S:Sz/bitstring,Buf/bitstring>> = Buf0,
    {<<Res/bitstring,S/bitstring>>, Buf};
decode_fragmented_1(<<1:1,0:1,N:14,Buf0/bitstring>>, Unit, Res) ->
    Sz = N * Unit,
    <<S:Sz/bitstring,Buf/bitstring>> = Buf0,
    {<<Res/bitstring,S/bitstring>>, Buf};
decode_fragmented_1(<<1:1,1:1,SegSz0:6,Buf0/bitstring>>, Unit, Res0) ->
    SegSz = SegSz0 * Unit * 16384,
    <<Frag:SegSz/bitstring,Buf/bitstring>> = Buf0,
    Res = <<Res0/bitstring,Frag/bitstring>>,
    decode_fragmented_1(Buf, Unit, Res).

decode_length(Buffer) ->
    case align(Buffer) of
        <<0:1,Oct:7,Rest/binary>> ->
            {Oct, Rest};
        <<2:2,Val:14,Rest/binary>> ->
            {Val, Rest};
        <<3:2,_Val:14,_Rest/binary>> ->
            exit({error, {asn1, {decode_length, {nyi, above_16k}}}})
    end.

decode_named_bit_string(Val, NNL) ->
    Bits =
        [ 
         B ||
             <<B:1>> <= Val
        ],
    decode_named_bit_string_1(0, Bits, NNL, []).

decode_named_bit_string_1(Pos, [0 | Bt], Names, Acc) ->
    decode_named_bit_string_1(Pos + 1, Bt, Names, Acc);
decode_named_bit_string_1(Pos, [1 | Bt], Names, Acc) ->
    case lists:keyfind(Pos, 2, Names) of
        {Name, _} ->
            decode_named_bit_string_1(Pos + 1, Bt, Names, [Name | Acc]);
        false ->
            decode_named_bit_string_1(Pos + 1,
                                      Bt, Names,
                                      [{bit, Pos} | Acc])
    end;
decode_named_bit_string_1(_Pos, [], _Names, Acc) ->
    lists:reverse(Acc).

decode_oid(Octets) ->
    [First | Rest] = dec_subidentifiers(Octets, 0, []),
    Idlist =
        if
            First < 40 ->
                [0, First | Rest];
            First < 80 ->
                [1, First - 40 | Rest];
            true ->
                [2, First - 80 | Rest]
        end,
    list_to_tuple(Idlist).

diff([H | T], Prev) ->
    [H - Prev | diff(T, H)];
diff([], _) ->
    [].

e_o_e(Num) when Num < 128 ->
    Num bor 128;
e_o_e(Num) ->
    [e_o_e(Num bsr 7), Num band 127 bor 128].

e_object_element(Num) when Num < 128 ->
    [Num];
e_object_element(Num) ->
    [e_o_e(Num bsr 7), Num band 127].

e_object_elements([], Acc) ->
    lists:reverse(Acc);
e_object_elements([H | T], Acc) ->
    e_object_elements(T, [e_object_element(H) | Acc]).

e_object_identifier([E1, E2 | Tail])
    when E1 >= 0, E1 < 2, E2 < 40; E1 =:= 2 ->
    Head = 40 * E1 + E2,
    e_object_elements([Head | Tail], []);
e_object_identifier([_, _ | _Tail] = Oid) ->
    exit({error, {asn1, {illegal_value, Oid}}}).

encode_components(Cs, _Encoder, 0, Acc) ->
    {Cs, lists:reverse(Acc)};
encode_components([C | Cs], Encoder, Size, Acc) ->
    B = Encoder(C),
    encode_components(Cs, Encoder, Size - 1, [B | Acc]).

encode_fragmented(Bin, Unit) ->
    encode_fragmented_1(Bin, Unit, 4).

encode_fragmented_1(Bin, Unit, N) ->
    SegSz = Unit * N * 16384,
    case Bin of
        <<B:SegSz/bitstring,T/bitstring>> ->
            [<<3:2,N:6>>, B | encode_fragmented_1(T, Unit, N)];
        _ when N > 1 ->
            encode_fragmented_1(Bin, Unit, N - 1);
        _ ->
            case bit_size(Bin) div Unit of
                Len when Len < 128 ->
                    [Len, Bin];
                Len when Len < 16384 ->
                    [<<2:2,Len:14>>, Bin]
            end
    end.

encode_fragmented_sof(Fun, Comps, Len) ->
    encode_fragmented_sof_1(Fun, Comps, Len, 4).

encode_fragmented_sof_1(Encoder, Comps0, Len0, N) ->
    SegSz = N * 16384,
    if
        Len0 >= SegSz ->
            {Comps, B} = encode_components(Comps0, Encoder, SegSz, []),
            Len = Len0 - SegSz,
            [align,
             <<3:2,N:6>>,
             B |
             encode_fragmented_sof_1(Encoder, Comps, Len, N)];
        N > 1 ->
            encode_fragmented_sof_1(Encoder, Comps0, Len0, N - 1);
        Len0 < 128 ->
            {[], B} = encode_components(Comps0, Encoder, Len0, []),
            [align, Len0 | B];
        Len0 < 16384 ->
            {[], B} = encode_components(Comps0, Encoder, Len0, []),
            [align, <<2:2,Len0:14>> | B]
    end.

encode_oid(Val) when is_tuple(Val) ->
    encode_oid(tuple_to_list(Val));
encode_oid(Val) ->
    iolist_to_binary(e_object_identifier(Val)).

int_to_bitlist(0) ->
    [];
int_to_bitlist(Int) ->
    [Int band 1 | int_to_bitlist(Int bsr 1)].

ntz(Byte) ->
    T = {8, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2,
         0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0,
         1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1,
         0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0,
         2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3,
         0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0,
         1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1,
         0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0,
         3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2,
         0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0,
         1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1,
         0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0,
         2, 0, 1, 0},
    element(Byte + 1, T).

skipextensions(Bytes0, Nr, ExtensionBitstr)
    when is_bitstring(ExtensionBitstr) ->
    Prev = Nr - 1,
    case ExtensionBitstr of
        <<_:Prev,1:1,_/bitstring>> ->
            {Len, Bytes1} = decode_length(Bytes0),
            <<_:Len/binary,Bytes2/bitstring>> = Bytes1,
            skipextensions(Bytes2, Nr + 1, ExtensionBitstr);
        <<_:Prev,0:1,_/bitstring>> ->
            skipextensions(Bytes0, Nr + 1, ExtensionBitstr);
        _ ->
            Bytes0
    end.

to_bitstring({0, Bs}) when is_binary(Bs) ->
    Bs;
to_bitstring({Unused, Bs0}) when is_binary(Bs0) ->
    Sz = bit_size(Bs0) - Unused,
    <<Bs:Sz/bits,_/bits>> = Bs0,
    Bs;
to_bitstring(Bs) when is_bitstring(Bs) ->
    Bs;
to_bitstring(Int) when is_integer(Int), Int >= 0 ->
    L = int_to_bitlist(Int),
    << 
      <<B:1>> ||
          B <- L
    >>;
to_bitstring(L) when is_list(L) ->
    << 
      <<B:1>> ||
          B <- L
    >>.

to_named_bitstring(Val) ->
    Bs = to_bitstring(Val),
    bs_drop_trailing_zeroes(Bs).
