/* vnc-connection.c generated by valac 0.56.3, the Vala compiler
 * generated from vnc-connection.vala, do not modify */

/* vnc-connection.vala
 *
 * Copyright (C) Red Hat, Inc
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Felipe Borges <felipeborges@gnome.org>
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gtk-vnc.h>
#include <glib/gi18n-lib.h>
#include <gvnc.h>
#include <gdk/gdk.h>
#include <gvncpulse.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONNECTIONS_TYPE_CONNECTION (connections_connection_get_type ())
#define CONNECTIONS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnection))
#define CONNECTIONS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))
#define CONNECTIONS_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))

typedef struct _ConnectionsConnection ConnectionsConnection;
typedef struct _ConnectionsConnectionClass ConnectionsConnectionClass;
typedef struct _ConnectionsConnectionPrivate ConnectionsConnectionPrivate;

#define CONNECTIONS_TYPE_VNC_CONNECTION (connections_vnc_connection_get_type ())
#define CONNECTIONS_VNC_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnection))
#define CONNECTIONS_VNC_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnectionClass))
#define CONNECTIONS_IS_VNC_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_VNC_CONNECTION))
#define CONNECTIONS_IS_VNC_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_VNC_CONNECTION))
#define CONNECTIONS_VNC_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnectionClass))

typedef struct _ConnectionsVncConnection ConnectionsVncConnection;
typedef struct _ConnectionsVncConnectionClass ConnectionsVncConnectionClass;
typedef struct _ConnectionsVncConnectionPrivate ConnectionsVncConnectionPrivate;
enum  {
	CONNECTIONS_VNC_CONNECTION_0_PROPERTY,
	CONNECTIONS_VNC_CONNECTION_WIDGET_PROPERTY,
	CONNECTIONS_VNC_CONNECTION_THUMBNAIL_PROPERTY,
	CONNECTIONS_VNC_CONNECTION_SCALING_PROPERTY,
	CONNECTIONS_VNC_CONNECTION_VIEW_ONLY_PROPERTY,
	CONNECTIONS_VNC_CONNECTION_SHOW_LOCAL_POINTER_PROPERTY,
	CONNECTIONS_VNC_CONNECTION_ENABLE_AUDIO_PROPERTY,
	CONNECTIONS_VNC_CONNECTION_PORT_PROPERTY,
	CONNECTIONS_VNC_CONNECTION_BANDWIDTH_PROPERTY,
	CONNECTIONS_VNC_CONNECTION_SCALE_MODE_PROPERTY,
	CONNECTIONS_VNC_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define CONNECTIONS_TYPE_APPLICATION (connections_application_get_type ())
#define CONNECTIONS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_APPLICATION, ConnectionsApplication))
#define CONNECTIONS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_APPLICATION, ConnectionsApplicationClass))
#define CONNECTIONS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_APPLICATION))
#define CONNECTIONS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_APPLICATION))
#define CONNECTIONS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_APPLICATION, ConnectionsApplicationClass))

typedef struct _ConnectionsApplication ConnectionsApplication;
typedef struct _ConnectionsApplicationClass ConnectionsApplicationClass;

#define CONNECTIONS_TYPE_WINDOW (connections_window_get_type ())
#define CONNECTIONS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_WINDOW, ConnectionsWindow))
#define CONNECTIONS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_WINDOW, ConnectionsWindowClass))
#define CONNECTIONS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_WINDOW))
#define CONNECTIONS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_WINDOW))
#define CONNECTIONS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_WINDOW, ConnectionsWindowClass))

typedef struct _ConnectionsWindow ConnectionsWindow;
typedef struct _ConnectionsWindowClass ConnectionsWindowClass;
#define __vala_VncAudioFormat_free0(var) ((var == NULL) ? NULL : (var = (_vala_VncAudioFormat_free (var), NULL)))

struct _ConnectionsConnection {
	GObject parent_instance;
	ConnectionsConnectionPrivate * priv;
	gchar* uuid;
	gboolean connected;
	gboolean need_password;
	gboolean need_username;
};

struct _ConnectionsConnectionClass {
	GObjectClass parent_class;
	void (*send_keys) (ConnectionsConnection* self, guint* keys, gint keys_length1);
	void (*connect_it) (ConnectionsConnection* self);
	void (*disconnect_it) (ConnectionsConnection* self);
	void (*dispose_display) (ConnectionsConnection* self);
	GtkWidget* (*get_widget) (ConnectionsConnection* self);
	void (*set_widget) (ConnectionsConnection* self, GtkWidget* value);
	gboolean (*get_scaling) (ConnectionsConnection* self);
	void (*set_scaling) (ConnectionsConnection* self, gboolean value);
	gint (*get_port) (ConnectionsConnection* self);
	void (*set_port) (ConnectionsConnection* self, gint value);
	GdkPixbuf* (*get_thumbnail) (ConnectionsConnection* self);
	void (*set_thumbnail) (ConnectionsConnection* self, GdkPixbuf* value);
};

struct _ConnectionsVncConnection {
	ConnectionsConnection parent_instance;
	ConnectionsVncConnectionPrivate * priv;
};

struct _ConnectionsVncConnectionClass {
	ConnectionsConnectionClass parent_class;
};

struct _ConnectionsVncConnectionPrivate {
	GtkWindow* sidecar_vnc_window;
	GtkClipboard* clipboard;
	VncDisplay* display;
	gboolean _enable_audio;
	gint _port;
	gchar* _bandwidth;
	gchar* _scale_mode;
};

static gint ConnectionsVncConnection_private_offset;
static gpointer connections_vnc_connection_parent_class = NULL;
VALA_EXTERN ConnectionsApplication* connections_application_application;

VALA_EXTERN GType connections_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsConnection, g_object_unref)
VALA_EXTERN GType connections_vnc_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsVncConnection, g_object_unref)
VALA_EXTERN void connections_connection_connect_it (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_disconnect_it (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_dispose_display (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_send_keys (ConnectionsConnection* self,
                                       guint* keys,
                                       gint keys_length1);
VALA_EXTERN GtkWidget* connections_connection_get_widget (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_widget (ConnectionsConnection* self,
                                        GtkWidget* value);
VALA_EXTERN GdkPixbuf* connections_connection_get_thumbnail (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_thumbnail (ConnectionsConnection* self,
                                           GdkPixbuf* value);
VALA_EXTERN gboolean connections_connection_get_scaling (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_scaling (ConnectionsConnection* self,
                                         gboolean value);
VALA_EXTERN gint connections_connection_get_port (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_port (ConnectionsConnection* self,
                                      gint value);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_new (const gchar* uuid);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_construct (GType object_type,
                                                                const gchar* uuid);
VALA_EXTERN ConnectionsConnection* connections_connection_construct (GType object_type);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_new_from_uri (const gchar* uri);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_construct_from_uri (GType object_type,
                                                                         const gchar* uri);
VALA_EXTERN void connections_connection_set_uri (ConnectionsConnection* self,
                                     const gchar* value);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_new_from_vnc_file (const gchar* file_path);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_construct_from_vnc_file (GType object_type,
                                                                              const gchar* file_path);
VALA_EXTERN void connections_connection_set_host (ConnectionsConnection* self,
                                      const gchar* value);
VALA_EXTERN void connections_connection_set_username (ConnectionsConnection* self,
                                          const gchar* value);
VALA_EXTERN void connections_connection_set_password (ConnectionsConnection* self,
                                          const gchar* value);
static void connections_vnc_connection_real_connect_it (ConnectionsConnection* base);
VALA_EXTERN const gchar* connections_connection_get_username (ConnectionsConnection* self);
VALA_EXTERN const gchar* connections_connection_get_password (ConnectionsConnection* self);
VALA_EXTERN const gchar* connections_connection_get_host (ConnectionsConnection* self);
static void connections_vnc_connection_real_disconnect_it (ConnectionsConnection* base);
static void connections_vnc_connection_real_dispose_display (ConnectionsConnection* base);
static void connections_vnc_connection_real_send_keys (ConnectionsConnection* base,
                                                guint* keyvals,
                                                gint keyvals_length1);
static void connections_vnc_connection_on_vnc_auth_credential_cb (ConnectionsVncConnection* self,
                                                           GValueArray* creds);
VALA_EXTERN void connections_connection_handle_auth (ConnectionsConnection* self);
static void connections_vnc_connection_on_vnc_auth_failure_cb (ConnectionsVncConnection* self,
                                                        const gchar* reason);
VALA_EXTERN void connections_connection_auth_failed (ConnectionsConnection* self,
                                         const gchar* reason);
static void connections_vnc_connection_on_vnc_server_cut_text_cb (ConnectionsVncConnection* self,
                                                           const gchar* message);
VALA_EXTERN gboolean connections_vnc_connection_get_view_only (ConnectionsVncConnection* self);
static void connections_vnc_connection_on_owner_change_cb (ConnectionsVncConnection* self);
VALA_EXTERN void connections_vnc_connection_scale (ConnectionsVncConnection* self);
VALA_EXTERN const gchar* connections_vnc_connection_get_scale_mode (ConnectionsVncConnection* self);
static void connections_vnc_connection_scale_to_original_size (ConnectionsVncConnection* self);
static void connections_vnc_connection_scale_to_fit_window (ConnectionsVncConnection* self);
VALA_EXTERN void connections_vnc_connection_set_view_only (ConnectionsVncConnection* self,
                                               gboolean value);
VALA_EXTERN gboolean connections_vnc_connection_get_show_local_pointer (ConnectionsVncConnection* self);
VALA_EXTERN void connections_vnc_connection_set_show_local_pointer (ConnectionsVncConnection* self,
                                                        gboolean value);
VALA_EXTERN gboolean connections_vnc_connection_get_enable_audio (ConnectionsVncConnection* self);
VALA_EXTERN void connections_vnc_connection_set_enable_audio (ConnectionsVncConnection* self,
                                                  gboolean value);
VALA_EXTERN const gchar* connections_vnc_connection_get_bandwidth (ConnectionsVncConnection* self);
VALA_EXTERN void connections_vnc_connection_set_bandwidth (ConnectionsVncConnection* self,
                                               const gchar* value);
VALA_EXTERN void connections_vnc_connection_set_scale_mode (ConnectionsVncConnection* self,
                                                const gchar* value);
static GObject * connections_vnc_connection_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
VALA_EXTERN GType connections_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsApplication, g_object_unref)
VALA_EXTERN GType connections_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsWindow, g_object_unref)
VALA_EXTERN ConnectionsWindow* connections_application_get_main_window (ConnectionsApplication* self);
VALA_EXTERN void connections_connection_on_connection_error_cb (ConnectionsConnection* self,
                                                    const gchar* reason);
static void _connections_connection_on_connection_error_cb_vnc_display_vnc_error (VncDisplay* _sender,
                                                                           const gchar* object,
                                                                           gpointer self);
static void _connections_vnc_connection___lambda16_ (ConnectionsVncConnection* self);
static void __connections_vnc_connection___lambda16__vnc_display_vnc_initialized (VncDisplay* _sender,
                                                                           gpointer self);
static void _connections_vnc_connection_on_vnc_auth_credential_cb_vnc_display_vnc_auth_credential (VncDisplay* _sender,
                                                                                            GValueArray* credList,
                                                                                            gpointer self);
static void _connections_vnc_connection_on_vnc_auth_failure_cb_vnc_display_vnc_auth_failure (VncDisplay* _sender,
                                                                                      const gchar* object,
                                                                                      gpointer self);
static void _connections_vnc_connection_scale_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                 GtkAllocation* allocation,
                                                                 gpointer self);
static void _connections_vnc_connection_on_vnc_server_cut_text_cb_vnc_display_vnc_server_cut_text (VncDisplay* _sender,
                                                                                            const gchar* object,
                                                                                            gpointer self);
static void _connections_vnc_connection_on_owner_change_cb_gtk_clipboard_owner_change (GtkClipboard* _sender,
                                                                                GdkEventOwnerChange* event,
                                                                                gpointer self);
static void _connections_vnc_connection_scale_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _vala_VncAudioFormat_free (VncAudioFormat* self);
static void connections_vnc_connection_finalize (GObject * obj);
static GType connections_vnc_connection_get_type_once (void);
static void _vala_connections_vnc_connection_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_connections_vnc_connection_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
connections_vnc_connection_get_instance_private (ConnectionsVncConnection* self)
{
	return G_STRUCT_MEMBER_P (self, ConnectionsVncConnection_private_offset);
}

ConnectionsVncConnection*
connections_vnc_connection_construct (GType object_type,
                                      const gchar* uuid)
{
	ConnectionsVncConnection * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (ConnectionsVncConnection*) connections_connection_construct (object_type);
	_tmp0_ = g_strdup (uuid);
	_g_free0 (((ConnectionsConnection*) self)->uuid);
	((ConnectionsConnection*) self)->uuid = _tmp0_;
	return self;
}

ConnectionsVncConnection*
connections_vnc_connection_new (const gchar* uuid)
{
	return connections_vnc_connection_construct (CONNECTIONS_TYPE_VNC_CONNECTION, uuid);
}

ConnectionsVncConnection*
connections_vnc_connection_construct_from_uri (GType object_type,
                                               const gchar* uri)
{
	ConnectionsVncConnection * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (ConnectionsVncConnection*) connections_connection_construct (object_type);
	_tmp0_ = g_uuid_string_random ();
	_g_free0 (((ConnectionsConnection*) self)->uuid);
	((ConnectionsConnection*) self)->uuid = _tmp0_;
	connections_connection_set_uri ((ConnectionsConnection*) self, uri);
	return self;
}

ConnectionsVncConnection*
connections_vnc_connection_new_from_uri (const gchar* uri)
{
	return connections_vnc_connection_construct_from_uri (CONNECTIONS_TYPE_VNC_CONNECTION, uri);
}

ConnectionsVncConnection*
connections_vnc_connection_construct_from_vnc_file (GType object_type,
                                                    const gchar* file_path)
{
	ConnectionsVncConnection * self = NULL;
	GKeyFile* key_file = NULL;
	GKeyFile* _tmp0_;
	gchar* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (file_path != NULL, NULL);
	self = (ConnectionsVncConnection*) connections_connection_construct (object_type);
	_tmp0_ = g_key_file_new ();
	key_file = _tmp0_;
	{
		GKeyFile* _tmp1_;
		_tmp1_ = key_file;
		g_key_file_load_from_file (_tmp1_, file_path, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("vnc-connection.vala:148: %s", _ ("Couldn’t parse the file"));
		_g_key_file_unref0 (key_file);
		return self;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		gchar* _tmp2_ = NULL;
		GKeyFile* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = key_file;
		_tmp4_ = g_key_file_get_string (_tmp3_, "Connection", "Host", &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		connections_connection_set_host ((ConnectionsConnection*) self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		gchar* _tmp5_;
		gchar* _tmp6_;
		g_clear_error (&_inner_error0_);
		_tmp5_ = g_strdup_printf ("VNC File is missing key “%s”", "Host");
		_tmp6_ = _tmp5_;
		g_info ("vnc-connection.vala:156: %s", _ (_tmp6_));
		_g_free0 (_tmp6_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		gint _tmp7_ = 0;
		GKeyFile* _tmp8_;
		_tmp8_ = key_file;
		_tmp7_ = g_key_file_get_integer (_tmp8_, "Connection", "Port", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		connections_connection_set_port ((ConnectionsConnection*) self, _tmp7_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		gchar* _tmp9_;
		gchar* _tmp10_;
		g_clear_error (&_inner_error0_);
		_tmp9_ = g_strdup_printf ("VNC File is missing key “%s”", "Port");
		_tmp10_ = _tmp9_;
		g_info ("vnc-connection.vala:161: %s", _ (_tmp10_));
		_g_free0 (_tmp10_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		gchar* _tmp11_ = NULL;
		GKeyFile* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = key_file;
		_tmp13_ = g_key_file_get_string (_tmp12_, "Connection", "Username", &_inner_error0_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
		connections_connection_set_username ((ConnectionsConnection*) self, _tmp11_);
		_g_free0 (_tmp11_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		gchar* _tmp14_;
		gchar* _tmp15_;
		g_clear_error (&_inner_error0_);
		_tmp14_ = g_strdup_printf ("VNC File is missing key “%s”", "Username");
		_tmp15_ = _tmp14_;
		g_info ("vnc-connection.vala:166: %s", _ (_tmp15_));
		_g_free0 (_tmp15_);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		gchar* _tmp16_ = NULL;
		GKeyFile* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = key_file;
		_tmp18_ = g_key_file_get_string (_tmp17_, "Connection", "Password ", &_inner_error0_);
		_tmp16_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
		connections_connection_set_password ((ConnectionsConnection*) self, _tmp16_);
		_g_free0 (_tmp16_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		gchar* _tmp19_;
		gchar* _tmp20_;
		g_clear_error (&_inner_error0_);
		_tmp19_ = g_strdup_printf ("VNC File is missing key “%s”", "Password");
		_tmp20_ = _tmp19_;
		g_info ("vnc-connection.vala:171: %s", _ (_tmp20_));
		_g_free0 (_tmp20_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp21_ = g_uuid_string_random ();
	_g_free0 (((ConnectionsConnection*) self)->uuid);
	((ConnectionsConnection*) self)->uuid = _tmp21_;
	_g_key_file_unref0 (key_file);
	return self;
}

ConnectionsVncConnection*
connections_vnc_connection_new_from_vnc_file (const gchar* file_path)
{
	return connections_vnc_connection_construct_from_vnc_file (CONNECTIONS_TYPE_VNC_CONNECTION, file_path);
}

static void
connections_vnc_connection_real_connect_it (ConnectionsConnection* base)
{
	ConnectionsVncConnection * self;
	VncDisplay* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	VncDisplay* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	VncDisplay* _tmp6_;
	VncDisplay* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	self = (ConnectionsVncConnection*) base;
	if (((ConnectionsConnection*) self)->connected) {
		g_signal_emit_by_name ((ConnectionsConnection*) self, "show");
		return;
	}
	((ConnectionsConnection*) self)->connected = TRUE;
	_tmp0_ = self->priv->display;
	_tmp1_ = connections_connection_get_username ((ConnectionsConnection*) self);
	_tmp2_ = _tmp1_;
	vnc_display_set_credential (_tmp0_, (gint) VNC_DISPLAY_CREDENTIAL_USERNAME, _tmp2_);
	_tmp3_ = self->priv->display;
	_tmp4_ = connections_connection_get_password ((ConnectionsConnection*) self);
	_tmp5_ = _tmp4_;
	vnc_display_set_credential (_tmp3_, (gint) VNC_DISPLAY_CREDENTIAL_PASSWORD, _tmp5_);
	_tmp6_ = self->priv->display;
	vnc_display_set_credential (_tmp6_, (gint) VNC_DISPLAY_CREDENTIAL_CLIENTNAME, "connections");
	_tmp7_ = self->priv->display;
	_tmp8_ = connections_connection_get_host ((ConnectionsConnection*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = connections_connection_get_port ((ConnectionsConnection*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
	_tmp13_ = _tmp12_;
	vnc_display_open_host (_tmp7_, _tmp9_, _tmp13_);
	_g_free0 (_tmp13_);
}

static void
connections_vnc_connection_real_disconnect_it (ConnectionsConnection* base)
{
	ConnectionsVncConnection * self;
	VncDisplay* _tmp0_;
	self = (ConnectionsVncConnection*) base;
	_tmp0_ = self->priv->display;
	if (vnc_display_is_open (_tmp0_)) {
		VncDisplay* _tmp1_;
		_tmp1_ = self->priv->display;
		vnc_display_close (_tmp1_);
	}
	((ConnectionsConnection*) self)->connected = FALSE;
}

static void
connections_vnc_connection_real_dispose_display (ConnectionsConnection* base)
{
	ConnectionsVncConnection * self;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp2_;
	VncDisplay* _tmp3_;
	VncDisplay* _tmp4_;
	self = (ConnectionsVncConnection*) base;
	_tmp0_ = self->priv->sidecar_vnc_window;
	if (_tmp0_ == NULL) {
		GtkWindow* _tmp1_;
		_tmp1_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->sidecar_vnc_window);
		self->priv->sidecar_vnc_window = _tmp1_;
	}
	_tmp2_ = self->priv->sidecar_vnc_window;
	_tmp3_ = self->priv->display;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->display;
	gtk_widget_realize ((GtkWidget*) _tmp4_);
}

static void
connections_vnc_connection_real_send_keys (ConnectionsConnection* base,
                                           guint* keyvals,
                                           gint keyvals_length1)
{
	ConnectionsVncConnection * self;
	VncDisplay* _tmp0_;
	self = (ConnectionsVncConnection*) base;
	_tmp0_ = self->priv->display;
	vnc_display_send_keys (_tmp0_, keyvals, (gint) keyvals_length1);
}

static void
connections_vnc_connection_on_vnc_auth_credential_cb (ConnectionsVncConnection* self,
                                                      GValueArray* creds)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (creds != NULL);
	{
		GValueArray* cred_collection = NULL;
		guint cred_index = 0U;
		cred_collection = creds;
		for (cred_index = 0; cred_index < cred_collection->n_values; cred_index = cred_index + 1) {
			GValue cred = {0};
			cred = *g_value_array_get_nth (cred_collection, cred_index);
			{
				VncDisplayCredential credential = 0;
				GValue _tmp0_;
				_tmp0_ = cred;
				credential = g_value_get_enum (&_tmp0_);
				switch (credential) {
					case VNC_DISPLAY_CREDENTIAL_USERNAME:
					{
						((ConnectionsConnection*) self)->need_username = TRUE;
						connections_connection_handle_auth ((ConnectionsConnection*) self);
						break;
					}
					case VNC_DISPLAY_CREDENTIAL_PASSWORD:
					{
						((ConnectionsConnection*) self)->need_password = TRUE;
						connections_connection_handle_auth ((ConnectionsConnection*) self);
						break;
					}
					case VNC_DISPLAY_CREDENTIAL_CLIENTNAME:
					{
						break;
					}
					default:
					{
						GEnumValue* _tmp1_;
						gchar* _tmp2_;
						gchar* _tmp3_;
						_tmp1_ = g_enum_get_value (g_type_class_ref (vnc_display_credential_get_type ()), credential);
						_tmp2_ = g_strdup_printf ("Unsupported credential: %s", (_tmp1_ != NULL) ? _tmp1_->value_name : NULL);
						_tmp3_ = _tmp2_;
						g_debug ("vnc-connection.vala:238: %s", _tmp3_);
						_g_free0 (_tmp3_);
						break;
					}
				}
			}
		}
	}
	connections_connection_disconnect_it ((ConnectionsConnection*) self);
	((ConnectionsConnection*) self)->connected = FALSE;
}

static void
connections_vnc_connection_on_vnc_auth_failure_cb (ConnectionsVncConnection* self,
                                                   const gchar* reason)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (reason != NULL);
	g_debug ("vnc-connection.vala:248: Failed to authenticate %s", reason);
	connections_connection_auth_failed ((ConnectionsConnection*) self, reason);
}

static void
connections_vnc_connection_on_vnc_server_cut_text_cb (ConnectionsVncConnection* self,
                                                      const gchar* message)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkClipboard* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkClipboard* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = connections_vnc_connection_get_view_only (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->clipboard;
	_tmp3_ = strlen (message);
	_tmp4_ = _tmp3_;
	gtk_clipboard_set_text (_tmp2_, message, _tmp4_);
	_tmp5_ = self->priv->clipboard;
	gtk_clipboard_store (_tmp5_);
}

static void
connections_vnc_connection_on_owner_change_cb (ConnectionsVncConnection* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* message = NULL;
	GtkClipboard* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	if (!((ConnectionsConnection*) self)->connected) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = connections_vnc_connection_get_view_only (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->clipboard;
	_tmp4_ = gtk_clipboard_wait_for_text (_tmp3_);
	message = _tmp4_;
	_tmp5_ = message;
	if (_tmp5_ != NULL) {
		VncDisplay* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->display;
		_tmp7_ = message;
		vnc_display_client_cut_text (_tmp6_, _tmp7_);
	}
	_g_free0 (message);
}

void
connections_vnc_connection_scale (ConnectionsVncConnection* self)
{
	VncDisplay* _tmp0_;
	VncDisplay* _tmp1_;
	VncDisplay* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	if (!vnc_display_is_open (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->display;
	_tmp2_ = self->priv->display;
	g_object_set ((GtkWidget*) _tmp2_, "expand", FALSE, NULL);
	vnc_display_set_scaling (_tmp1_, FALSE);
	_tmp3_ = self->priv->_scale_mode;
	if (g_strcmp0 (_tmp3_, "original") == 0) {
		connections_vnc_connection_scale_to_original_size (self);
	} else {
		connections_vnc_connection_scale_to_fit_window (self);
	}
}

static void
connections_vnc_connection_scale_to_fit_window (ConnectionsVncConnection* self)
{
	VncDisplay* _tmp0_;
	VncDisplay* _tmp1_;
	VncDisplay* _tmp2_;
	VncDisplay* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = self->priv->display;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	vnc_display_set_scaling (_tmp0_, TRUE);
	_tmp2_ = self->priv->display;
	_tmp3_ = self->priv->display;
	g_object_set ((GtkWidget*) _tmp3_, "height-request", 0, NULL);
	g_object_set ((GtkWidget*) _tmp2_, "width-request", 0, NULL);
}

static void
connections_vnc_connection_scale_to_original_size (ConnectionsVncConnection* self)
{
	VncDisplay* _tmp0_;
	VncDisplay* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	VncDisplay* _tmp4_;
	VncDisplay* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = self->priv->display;
	_tmp2_ = vnc_display_get_width (_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set ((GtkWidget*) _tmp0_, "width-request", _tmp3_, NULL);
	_tmp4_ = self->priv->display;
	_tmp5_ = self->priv->display;
	_tmp6_ = vnc_display_get_height (_tmp5_);
	_tmp7_ = _tmp6_;
	g_object_set ((GtkWidget*) _tmp4_, "height-request", _tmp7_, NULL);
}

static GtkWidget*
connections_vnc_connection_real_get_widget (ConnectionsConnection* base)
{
	GtkWidget* result;
	ConnectionsVncConnection* self;
	GtkWindow* _tmp0_;
	GtkWidget* _tmp1_;
	VncDisplay* _tmp4_;
	self = (ConnectionsVncConnection*) base;
	_tmp0_ = self->priv->sidecar_vnc_window;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	if (_tmp1_ != NULL) {
		GtkWindow* _tmp2_;
		VncDisplay* _tmp3_;
		_tmp2_ = self->priv->sidecar_vnc_window;
		_tmp3_ = self->priv->display;
		gtk_container_remove ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	}
	_tmp4_ = self->priv->display;
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp4_) : NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
connections_vnc_connection_real_set_widget (ConnectionsConnection* base,
                                            GtkWidget* value)
{
	ConnectionsVncConnection* self;
	VncDisplay* _tmp0_;
	self = (ConnectionsVncConnection*) base;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (value, vnc_display_get_type ()) ? ((VncDisplay*) value) : NULL);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_WIDGET_PROPERTY]);
}

static GdkPixbuf*
connections_vnc_connection_real_get_thumbnail (ConnectionsConnection* base)
{
	GdkPixbuf* result;
	ConnectionsVncConnection* self;
	VncDisplay* _tmp0_;
	GdkPixbuf* _tmp1_;
	self = (ConnectionsVncConnection*) base;
	_tmp0_ = self->priv->display;
	_tmp1_ = vnc_display_get_pixbuf (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
connections_vnc_connection_real_set_thumbnail (ConnectionsConnection* base,
                                               GdkPixbuf* value)
{
	ConnectionsVncConnection* self;
	self = (ConnectionsVncConnection*) base;
	return;
}

static gboolean
connections_vnc_connection_real_get_scaling (ConnectionsConnection* base)
{
	gboolean result;
	ConnectionsVncConnection* self;
	VncDisplay* _tmp0_;
	self = (ConnectionsVncConnection*) base;
	_tmp0_ = self->priv->display;
	result = vnc_display_get_scaling (_tmp0_);
	return result;
}

static void
connections_vnc_connection_real_set_scaling (ConnectionsConnection* base,
                                             gboolean value)
{
	ConnectionsVncConnection* self;
	VncDisplay* _tmp0_;
	self = (ConnectionsVncConnection*) base;
	_tmp0_ = self->priv->display;
	vnc_display_set_scaling (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_SCALING_PROPERTY]);
}

gboolean
connections_vnc_connection_get_view_only (ConnectionsVncConnection* self)
{
	gboolean result;
	VncDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->display;
	result = vnc_display_get_read_only (_tmp0_);
	return result;
}

void
connections_vnc_connection_set_view_only (ConnectionsVncConnection* self,
                                          gboolean value)
{
	VncDisplay* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	vnc_display_set_read_only (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_VIEW_ONLY_PROPERTY]);
}

gboolean
connections_vnc_connection_get_show_local_pointer (ConnectionsVncConnection* self)
{
	gboolean result;
	VncDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->display;
	result = vnc_display_get_pointer_local (_tmp0_);
	return result;
}

void
connections_vnc_connection_set_show_local_pointer (ConnectionsVncConnection* self,
                                                   gboolean value)
{
	VncDisplay* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	vnc_display_set_pointer_local (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_SHOW_LOCAL_POINTER_PROPERTY]);
}

gboolean
connections_vnc_connection_get_enable_audio (ConnectionsVncConnection* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_audio;
	return result;
}

void
connections_vnc_connection_set_enable_audio (ConnectionsVncConnection* self,
                                             gboolean value)
{
	VncConnection* connection = NULL;
	VncDisplay* _tmp0_;
	VncConnection* _tmp1_;
	VncConnection* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = vnc_display_get_connection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	connection = _tmp2_;
	self->priv->_enable_audio = value;
	if (self->priv->_enable_audio) {
		VncConnection* _tmp3_;
		_tmp3_ = connection;
		vnc_connection_audio_enable (_tmp3_);
	} else {
		VncConnection* _tmp4_;
		_tmp4_ = connection;
		vnc_connection_audio_disable (_tmp4_);
	}
	_g_object_unref0 (connection);
	g_object_notify_by_pspec ((GObject *) self, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_ENABLE_AUDIO_PROPERTY]);
}

static gint
connections_vnc_connection_real_get_port (ConnectionsConnection* base)
{
	gint result;
	ConnectionsVncConnection* self;
	self = (ConnectionsVncConnection*) base;
	result = self->priv->_port;
	return result;
}

static void
connections_vnc_connection_real_set_port (ConnectionsConnection* base,
                                          gint value)
{
	ConnectionsVncConnection* self;
	gint old_value;
	self = (ConnectionsVncConnection*) base;
	old_value = connections_vnc_connection_real_get_port (base);
	if (old_value != value) {
		self->priv->_port = value;
		g_object_notify_by_pspec ((GObject *) self, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_PORT_PROPERTY]);
	}
}

const gchar*
connections_vnc_connection_get_bandwidth (ConnectionsVncConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_bandwidth;
	result = _tmp0_;
	return result;
}

void
connections_vnc_connection_set_bandwidth (ConnectionsVncConnection* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = connections_vnc_connection_get_bandwidth (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_bandwidth);
		self->priv->_bandwidth = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_BANDWIDTH_PROPERTY]);
	}
}

const gchar*
connections_vnc_connection_get_scale_mode (ConnectionsVncConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scale_mode;
	result = _tmp0_;
	return result;
}

void
connections_vnc_connection_set_scale_mode (ConnectionsVncConnection* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = connections_vnc_connection_get_scale_mode (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_scale_mode);
		self->priv->_scale_mode = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_SCALE_MODE_PROPERTY]);
	}
}

static void
_connections_connection_on_connection_error_cb_vnc_display_vnc_error (VncDisplay* _sender,
                                                                      const gchar* object,
                                                                      gpointer self)
{
	connections_connection_on_connection_error_cb ((ConnectionsConnection*) self, object);
}

static void
_connections_vnc_connection___lambda16_ (ConnectionsVncConnection* self)
{
	g_signal_emit_by_name ((ConnectionsConnection*) self, "show");
}

static void
__connections_vnc_connection___lambda16__vnc_display_vnc_initialized (VncDisplay* _sender,
                                                                      gpointer self)
{
	_connections_vnc_connection___lambda16_ ((ConnectionsVncConnection*) self);
}

static void
_connections_vnc_connection_on_vnc_auth_credential_cb_vnc_display_vnc_auth_credential (VncDisplay* _sender,
                                                                                       GValueArray* credList,
                                                                                       gpointer self)
{
	connections_vnc_connection_on_vnc_auth_credential_cb ((ConnectionsVncConnection*) self, credList);
}

static void
_connections_vnc_connection_on_vnc_auth_failure_cb_vnc_display_vnc_auth_failure (VncDisplay* _sender,
                                                                                 const gchar* object,
                                                                                 gpointer self)
{
	connections_vnc_connection_on_vnc_auth_failure_cb ((ConnectionsVncConnection*) self, object);
}

static void
_connections_vnc_connection_scale_gtk_widget_size_allocate (GtkWidget* _sender,
                                                            GtkAllocation* allocation,
                                                            gpointer self)
{
	connections_vnc_connection_scale ((ConnectionsVncConnection*) self);
}

static void
_connections_vnc_connection_on_vnc_server_cut_text_cb_vnc_display_vnc_server_cut_text (VncDisplay* _sender,
                                                                                       const gchar* object,
                                                                                       gpointer self)
{
	connections_vnc_connection_on_vnc_server_cut_text_cb ((ConnectionsVncConnection*) self, object);
}

static void
_connections_vnc_connection_on_owner_change_cb_gtk_clipboard_owner_change (GtkClipboard* _sender,
                                                                           GdkEventOwnerChange* event,
                                                                           gpointer self)
{
	connections_vnc_connection_on_owner_change_cb ((ConnectionsVncConnection*) self);
}

static void
_connections_vnc_connection_scale_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	connections_vnc_connection_scale ((ConnectionsVncConnection*) self);
}

static void
_vala_VncAudioFormat_free (VncAudioFormat* self)
{
	g_boxed_free (vnc_audio_format_get_type (), self);
}

static GObject *
connections_vnc_connection_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ConnectionsVncConnection * self;
	VncDisplay* _tmp0_;
	VncDisplay* _tmp1_;
	VncDisplay* _tmp2_;
	VncDisplay* _tmp3_;
	ConnectionsApplication* _tmp4_;
	ConnectionsWindow* _tmp5_;
	ConnectionsWindow* _tmp6_;
	GdkDisplay* _tmp7_;
	GtkClipboard* _tmp8_;
	GtkClipboard* _tmp9_;
	VncDisplay* _tmp10_;
	VncDisplay* _tmp11_;
	VncDisplay* _tmp12_;
	VncDisplay* _tmp13_;
	VncDisplay* _tmp14_;
	VncDisplay* _tmp15_;
	GtkClipboard* _tmp16_;
	VncConnection* connection = NULL;
	VncDisplay* _tmp17_;
	VncConnection* _tmp18_;
	VncConnection* _tmp19_;
	VncConnection* _tmp20_;
	VncAudioFormat* _tmp21_ = NULL;
	VncAudioFormat* _tmp22_;
	VncConnection* _tmp23_;
	VncAudioPulse* _tmp24_;
	VncAudioPulse* _tmp25_;
	VncConnection* _tmp26_;
	parent_class = G_OBJECT_CLASS (connections_vnc_connection_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnection);
	_tmp0_ = (VncDisplay*) vnc_display_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp0_;
	_tmp1_ = self->priv->display;
	vnc_display_set_keyboard_grab (_tmp1_, TRUE);
	_tmp2_ = self->priv->display;
	vnc_display_set_pointer_grab (_tmp2_, TRUE);
	_tmp3_ = self->priv->display;
	vnc_display_set_force_size (_tmp3_, FALSE);
	connections_connection_dispose_display ((ConnectionsConnection*) self);
	_tmp4_ = connections_application_application;
	_tmp5_ = connections_application_get_main_window (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gtk_widget_get_display ((GtkWidget*) _tmp6_);
	_tmp8_ = gtk_clipboard_get_default (_tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->clipboard);
	self->priv->clipboard = _tmp9_;
	_tmp10_ = self->priv->display;
	g_signal_connect_object (_tmp10_, "vnc-error", (GCallback) _connections_connection_on_connection_error_cb_vnc_display_vnc_error, (ConnectionsConnection*) self, 0);
	_tmp11_ = self->priv->display;
	g_signal_connect_object (_tmp11_, "vnc-initialized", (GCallback) __connections_vnc_connection___lambda16__vnc_display_vnc_initialized, self, 0);
	_tmp12_ = self->priv->display;
	g_signal_connect_object (_tmp12_, "vnc-auth-credential", (GCallback) _connections_vnc_connection_on_vnc_auth_credential_cb_vnc_display_vnc_auth_credential, self, 0);
	_tmp13_ = self->priv->display;
	g_signal_connect_object (_tmp13_, "vnc-auth-failure", (GCallback) _connections_vnc_connection_on_vnc_auth_failure_cb_vnc_display_vnc_auth_failure, self, 0);
	_tmp14_ = self->priv->display;
	g_signal_connect_object ((GtkWidget*) _tmp14_, "size-allocate", (GCallback) _connections_vnc_connection_scale_gtk_widget_size_allocate, self, 0);
	_tmp15_ = self->priv->display;
	g_signal_connect_object (_tmp15_, "vnc-server-cut-text", (GCallback) _connections_vnc_connection_on_vnc_server_cut_text_cb_vnc_display_vnc_server_cut_text, self, 0);
	_tmp16_ = self->priv->clipboard;
	g_signal_connect_object (_tmp16_, "owner-change", (GCallback) _connections_vnc_connection_on_owner_change_cb_gtk_clipboard_owner_change, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::scale-mode", (GCallback) _connections_vnc_connection_scale_g_object_notify, self, 0);
	_tmp17_ = self->priv->display;
	_tmp18_ = vnc_display_get_connection (_tmp17_);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	connection = _tmp19_;
	_tmp20_ = connection;
	_tmp21_ = vnc_audio_format_new ();
	_tmp21_->frequency = (guint32) 44100;
	_tmp21_->nchannels = (guint8) 2;
	_tmp22_ = _tmp21_;
	vnc_connection_set_audio_format (_tmp20_, _tmp22_);
	__vala_VncAudioFormat_free0 (_tmp22_);
	_tmp23_ = connection;
	_tmp24_ = vnc_audio_pulse_new ();
	_tmp25_ = _tmp24_;
	vnc_connection_set_audio (_tmp23_, (VncAudio*) _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = connection;
	vnc_connection_audio_enable (_tmp26_);
	_g_object_unref0 (connection);
	return obj;
}

static void
connections_vnc_connection_class_init (ConnectionsVncConnectionClass * klass,
                                       gpointer klass_data)
{
	connections_vnc_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConnectionsVncConnection_private_offset);
	((ConnectionsConnectionClass *) klass)->connect_it = (void (*) (ConnectionsConnection*)) connections_vnc_connection_real_connect_it;
	((ConnectionsConnectionClass *) klass)->disconnect_it = (void (*) (ConnectionsConnection*)) connections_vnc_connection_real_disconnect_it;
	((ConnectionsConnectionClass *) klass)->dispose_display = (void (*) (ConnectionsConnection*)) connections_vnc_connection_real_dispose_display;
	((ConnectionsConnectionClass *) klass)->send_keys = (void (*) (ConnectionsConnection*, guint*, gint)) connections_vnc_connection_real_send_keys;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_widget = connections_vnc_connection_real_get_widget;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_widget = connections_vnc_connection_real_set_widget;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_thumbnail = connections_vnc_connection_real_get_thumbnail;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_thumbnail = connections_vnc_connection_real_set_thumbnail;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_scaling = connections_vnc_connection_real_get_scaling;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_scaling = connections_vnc_connection_real_set_scaling;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_port = connections_vnc_connection_real_get_port;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_port = connections_vnc_connection_real_set_port;
	G_OBJECT_CLASS (klass)->get_property = _vala_connections_vnc_connection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_connections_vnc_connection_set_property;
	G_OBJECT_CLASS (klass)->constructor = connections_vnc_connection_constructor;
	G_OBJECT_CLASS (klass)->finalize = connections_vnc_connection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_VNC_CONNECTION_WIDGET_PROPERTY, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_VNC_CONNECTION_THUMBNAIL_PROPERTY, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_THUMBNAIL_PROPERTY] = g_param_spec_object ("thumbnail", "thumbnail", "thumbnail", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_VNC_CONNECTION_SCALING_PROPERTY, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_SCALING_PROPERTY] = g_param_spec_boolean ("scaling", "scaling", "scaling", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_VNC_CONNECTION_VIEW_ONLY_PROPERTY, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_VIEW_ONLY_PROPERTY] = g_param_spec_boolean ("view-only", "view-only", "view-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_VNC_CONNECTION_SHOW_LOCAL_POINTER_PROPERTY, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_SHOW_LOCAL_POINTER_PROPERTY] = g_param_spec_boolean ("show-local-pointer", "show-local-pointer", "show-local-pointer", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_VNC_CONNECTION_ENABLE_AUDIO_PROPERTY, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_ENABLE_AUDIO_PROPERTY] = g_param_spec_boolean ("enable-audio", "enable-audio", "enable-audio", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_VNC_CONNECTION_PORT_PROPERTY, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_PORT_PROPERTY] = g_param_spec_int ("port", "port", "port", G_MININT, G_MAXINT, 5900, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_VNC_CONNECTION_BANDWIDTH_PROPERTY, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_BANDWIDTH_PROPERTY] = g_param_spec_string ("bandwidth", "bandwidth", "bandwidth", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_VNC_CONNECTION_SCALE_MODE_PROPERTY, connections_vnc_connection_properties[CONNECTIONS_VNC_CONNECTION_SCALE_MODE_PROPERTY] = g_param_spec_string ("scale-mode", "scale-mode", "scale-mode", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
connections_vnc_connection_instance_init (ConnectionsVncConnection * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = connections_vnc_connection_get_instance_private (self);
	self->priv->_enable_audio = TRUE;
	self->priv->_port = 5900;
	_tmp0_ = g_strdup ("hight-quality");
	self->priv->_bandwidth = _tmp0_;
	_tmp1_ = g_strdup ("fit-window");
	self->priv->_scale_mode = _tmp1_;
}

static void
connections_vnc_connection_finalize (GObject * obj)
{
	ConnectionsVncConnection * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnection);
	_tmp0_ = connections_connection_get_widget ((ConnectionsConnection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_widget_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("vnc-connection.vala:178: Closing connection with %s", _tmp3_);
	connections_connection_disconnect_it ((ConnectionsConnection*) self);
	_g_object_unref0 (self->priv->sidecar_vnc_window);
	_g_object_unref0 (self->priv->clipboard);
	_g_object_unref0 (self->priv->display);
	_g_free0 (self->priv->_bandwidth);
	_g_free0 (self->priv->_scale_mode);
	G_OBJECT_CLASS (connections_vnc_connection_parent_class)->finalize (obj);
}

static GType
connections_vnc_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConnectionsVncConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) connections_vnc_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConnectionsVncConnection), 0, (GInstanceInitFunc) connections_vnc_connection_instance_init, NULL };
	GType connections_vnc_connection_type_id;
	connections_vnc_connection_type_id = g_type_register_static (CONNECTIONS_TYPE_CONNECTION, "ConnectionsVncConnection", &g_define_type_info, 0);
	ConnectionsVncConnection_private_offset = g_type_add_instance_private (connections_vnc_connection_type_id, sizeof (ConnectionsVncConnectionPrivate));
	return connections_vnc_connection_type_id;
}

GType
connections_vnc_connection_get_type (void)
{
	static volatile gsize connections_vnc_connection_type_id__once = 0;
	if (g_once_init_enter (&connections_vnc_connection_type_id__once)) {
		GType connections_vnc_connection_type_id;
		connections_vnc_connection_type_id = connections_vnc_connection_get_type_once ();
		g_once_init_leave (&connections_vnc_connection_type_id__once, connections_vnc_connection_type_id);
	}
	return connections_vnc_connection_type_id__once;
}

static void
_vala_connections_vnc_connection_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	ConnectionsVncConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnection);
	switch (property_id) {
		case CONNECTIONS_VNC_CONNECTION_WIDGET_PROPERTY:
		g_value_set_object (value, connections_connection_get_widget ((ConnectionsConnection*) self));
		break;
		case CONNECTIONS_VNC_CONNECTION_THUMBNAIL_PROPERTY:
		g_value_take_object (value, connections_connection_get_thumbnail ((ConnectionsConnection*) self));
		break;
		case CONNECTIONS_VNC_CONNECTION_SCALING_PROPERTY:
		g_value_set_boolean (value, connections_connection_get_scaling ((ConnectionsConnection*) self));
		break;
		case CONNECTIONS_VNC_CONNECTION_VIEW_ONLY_PROPERTY:
		g_value_set_boolean (value, connections_vnc_connection_get_view_only (self));
		break;
		case CONNECTIONS_VNC_CONNECTION_SHOW_LOCAL_POINTER_PROPERTY:
		g_value_set_boolean (value, connections_vnc_connection_get_show_local_pointer (self));
		break;
		case CONNECTIONS_VNC_CONNECTION_ENABLE_AUDIO_PROPERTY:
		g_value_set_boolean (value, connections_vnc_connection_get_enable_audio (self));
		break;
		case CONNECTIONS_VNC_CONNECTION_PORT_PROPERTY:
		g_value_set_int (value, connections_connection_get_port ((ConnectionsConnection*) self));
		break;
		case CONNECTIONS_VNC_CONNECTION_BANDWIDTH_PROPERTY:
		g_value_set_string (value, connections_vnc_connection_get_bandwidth (self));
		break;
		case CONNECTIONS_VNC_CONNECTION_SCALE_MODE_PROPERTY:
		g_value_set_string (value, connections_vnc_connection_get_scale_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_connections_vnc_connection_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	ConnectionsVncConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnection);
	switch (property_id) {
		case CONNECTIONS_VNC_CONNECTION_WIDGET_PROPERTY:
		connections_connection_set_widget ((ConnectionsConnection*) self, g_value_get_object (value));
		break;
		case CONNECTIONS_VNC_CONNECTION_THUMBNAIL_PROPERTY:
		connections_connection_set_thumbnail ((ConnectionsConnection*) self, g_value_get_object (value));
		break;
		case CONNECTIONS_VNC_CONNECTION_SCALING_PROPERTY:
		connections_connection_set_scaling ((ConnectionsConnection*) self, g_value_get_boolean (value));
		break;
		case CONNECTIONS_VNC_CONNECTION_VIEW_ONLY_PROPERTY:
		connections_vnc_connection_set_view_only (self, g_value_get_boolean (value));
		break;
		case CONNECTIONS_VNC_CONNECTION_SHOW_LOCAL_POINTER_PROPERTY:
		connections_vnc_connection_set_show_local_pointer (self, g_value_get_boolean (value));
		break;
		case CONNECTIONS_VNC_CONNECTION_ENABLE_AUDIO_PROPERTY:
		connections_vnc_connection_set_enable_audio (self, g_value_get_boolean (value));
		break;
		case CONNECTIONS_VNC_CONNECTION_PORT_PROPERTY:
		connections_connection_set_port ((ConnectionsConnection*) self, g_value_get_int (value));
		break;
		case CONNECTIONS_VNC_CONNECTION_BANDWIDTH_PROPERTY:
		connections_vnc_connection_set_bandwidth (self, g_value_get_string (value));
		break;
		case CONNECTIONS_VNC_CONNECTION_SCALE_MODE_PROPERTY:
		connections_vnc_connection_set_scale_mode (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

