/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EncapsulatingSecretGenerator;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.Key;
import org.bouncycastle.crypto.KeyWrapperUsingSecureRandom;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPublicKey;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsEncapsulatedSecretExtractor;
import org.bouncycastle.crypto.fips.FipsEncapsulatingSecretGenerator;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsKTSOperatorFactory;
import org.bouncycastle.crypto.fips.FipsKeyUnwrapperUsingSecureRandom;
import org.bouncycastle.crypto.fips.FipsKeyWrapOperatorFactory;
import org.bouncycastle.crypto.fips.FipsKeyWrapperUsingSecureRandom;
import org.bouncycastle.crypto.fips.FipsOutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.fips.FipsOutputVerifier;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSignatureOperatorFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.PSSSigner;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.RsaBlindedEngine;
import org.bouncycastle.crypto.fips.RsaDigestSigner;
import org.bouncycastle.crypto.fips.RsaKeyPairGenerator;
import org.bouncycastle.crypto.fips.SHA1Digest;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.fips.X931Signer;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.CryptoException;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.crypto.internal.PrimeCertaintyCalculator;
import org.bouncycastle.crypto.internal.Signer;
import org.bouncycastle.crypto.internal.encodings.OAEPEncoding;
import org.bouncycastle.crypto.internal.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.internal.io.SignerOutputStream;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.params.RsaKeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.RsaKeyParameters;
import org.bouncycastle.crypto.internal.params.RsaPrivateCrtKeyParameters;
import org.bouncycastle.crypto.internal.signers.BaseRsaDigestSigner;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.FixedSecureRandom;
import org.bouncycastle.util.test.TestRandomData;

public final class FipsRSA {
    public static final FipsAlgorithm ALGORITHM = new FipsAlgorithm("RSA");
    static final FipsEngineProvider<AsymmetricBlockCipher> ENGINE_PROVIDER;
    private static final FipsAlgorithm ALGORITHM_PKCS1v1_5;
    private static final FipsAlgorithm ALGORITHM_PSS;
    private static final FipsAlgorithm ALGORITHM_X931;
    private static final FipsAlgorithm ALGORITHM_OAEP;
    private static final FipsAlgorithm ALGORITHM_SVE;
    public static final PKCS1v15SignatureParameters PKCS1v1_5;
    public static final PSSSignatureParameters PSS;
    public static final X931SignatureParameters X931;
    public static final PKCS1v15Parameters WRAP_PKCS1v1_5;
    public static final OAEPParameters WRAP_OAEP;
    public static final SVEKTSParameters KTS_SVE;
    public static final OAEPKTSParameters KTS_OAEP;
    private static final BigInteger MIN_PUB_EXP;
    private static final BigInteger MAX_PUB_EXP;
    private static BigInteger katE;
    private static BigInteger katM;
    private static BigInteger katD;
    private static BigInteger katP;
    private static BigInteger katQ;
    private static BigInteger katDP;
    private static BigInteger katDQ;
    private static BigInteger katQInv;
    private static byte[] msg;
    private static byte[] pkcs15Sig;
    private static final RsaKeyParameters testPubKey;
    private static final RsaPrivateCrtKeyParameters testPrivKey;

    private FipsRSA() {
    }

    private static Signer getPSSSigner(PSSSignatureParameters pSSSignatureParameters) {
        byte[] byArray = pSSSignatureParameters.getSalt();
        if (byArray != null) {
            return new PSSSigner((AsymmetricBlockCipher)new RsaBlindedEngine(), (Digest)FipsSHS.createDigest(pSSSignatureParameters.getDigestAlgorithm()), (Digest)FipsSHS.createDigest(pSSSignatureParameters.getMGFDigest()), byArray, pSSSignatureParameters.getTrailer());
        }
        return new PSSSigner((AsymmetricBlockCipher)new RsaBlindedEngine(), (Digest)FipsSHS.createDigest(pSSSignatureParameters.getDigestAlgorithm()), (Digest)FipsSHS.createDigest(pSSSignatureParameters.getMGFDigest()), pSSSignatureParameters.getSaltLength(), pSSSignatureParameters.getTrailer());
    }

    private static AsymmetricBlockCipher createCipher(boolean bl, AsymmetricRSAKey asymmetricRSAKey, WrapParameters wrapParameters, SecureRandom secureRandom) {
        CipherParameters cipherParameters;
        Object object;
        AsymmetricBlockCipher asymmetricBlockCipher = (AsymmetricBlockCipher)ENGINE_PROVIDER.createEngine();
        if (!asymmetricRSAKey.canBeUsed(AsymmetricRSAKey.Usage.ENCRYPT_OR_DECRYPT)) {
            throw new IllegalKeyException("Attempt to encrypt/decrypt with RSA modulus already used for sign/verify.");
        }
        if (asymmetricRSAKey instanceof AsymmetricRSAPublicKey) {
            object = (AsymmetricRSAPublicKey)asymmetricRSAKey;
            cipherParameters = new RsaKeyParameters(false, ((AsymmetricRSAKey)object).getModulus(), ((AsymmetricRSAPublicKey)object).getPublicExponent());
        } else {
            object = (AsymmetricRSAPrivateKey)asymmetricRSAKey;
            cipherParameters = FipsRSA.getPrivateKeyParameters((AsymmetricRSAPrivateKey)object);
        }
        if (wrapParameters.getAlgorithm().equals(ALGORITHM_OAEP)) {
            object = (OAEPParameters)wrapParameters;
            asymmetricBlockCipher = new OAEPEncoding(asymmetricBlockCipher, FipsSHS.createDigest(((OAEPParameters)object).digestAlgorithm), FipsSHS.createDigest(((OAEPParameters)object).mgfDigestAlgorithm), ((OAEPParameters)object).encodingParams);
        } else if (wrapParameters.getAlgorithm().equals(ALGORITHM_PKCS1v1_5)) {
            object = asymmetricBlockCipher;
            asymmetricBlockCipher = AccessController.doPrivileged(new PrivilegedAction<PKCS1Encoding>((AsymmetricBlockCipher)object){
                final /* synthetic */ AsymmetricBlockCipher val$baseEngine;
                {
                    this.val$baseEngine = asymmetricBlockCipher;
                }

                @Override
                public PKCS1Encoding run() {
                    if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                        Utils.checkPermission(Permissions.TlsPKCS15KeyWrapEnabled);
                    }
                    return new PKCS1Encoding(this.val$baseEngine);
                }
            });
        }
        cipherParameters = new ParametersWithRandom(cipherParameters, secureRandom);
        asymmetricBlockCipher.init(bl, cipherParameters);
        return asymmetricBlockCipher;
    }

    private static RsaKeyParameters getPrivateKeyParameters(final AsymmetricRSAPrivateKey asymmetricRSAPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<RsaKeyParameters>(){

            @Override
            public RsaKeyParameters run() {
                if (asymmetricRSAPrivateKey.getPublicExponent().equals(BigInteger.ZERO)) {
                    return new RsaKeyParameters(true, asymmetricRSAPrivateKey.getModulus(), asymmetricRSAPrivateKey.getPrivateExponent());
                }
                return new RsaPrivateCrtKeyParameters(asymmetricRSAPrivateKey.getModulus(), asymmetricRSAPrivateKey.getPublicExponent(), asymmetricRSAPrivateKey.getPrivateExponent(), asymmetricRSAPrivateKey.getP(), asymmetricRSAPrivateKey.getQ(), asymmetricRSAPrivateKey.getDP(), asymmetricRSAPrivateKey.getDQ(), asymmetricRSAPrivateKey.getQInv());
            }
        });
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        SelfTestExecutor.validate(ALGORITHM, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                byte[] byArray = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                RsaBlindedEngine rsaBlindedEngine = new RsaBlindedEngine();
                rsaBlindedEngine.init(true, asymmetricCipherKeyPair.getPublic());
                byte[] byArray2 = rsaBlindedEngine.processBlock(byArray, 0, byArray.length);
                if (Arrays.areEqual(byArray, byArray2)) {
                    return false;
                }
                rsaBlindedEngine.init(false, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                byte[] byArray3 = rsaBlindedEngine.processBlock(byArray, 0, byArray.length);
                if (Arrays.areEqual(byArray3, byArray)) {
                    return false;
                }
                byArray3 = rsaBlindedEngine.processBlock(byArray2, 0, byArray2.length);
                return Arrays.areEqual(byArray, byArray3);
            }
        });
    }

    private static void rsaSignTest(final EngineProvider engineProvider) {
        SelfTestExecutor.validate(ALGORITHM, new VariantInternalKatTest(ALGORITHM){

            void evaluate() throws Exception {
                RsaDigestSigner rsaDigestSigner = new RsaDigestSigner(engineProvider.createEngine(), FipsSHS.createDigest(FipsSHS.Algorithm.SHA256));
                rsaDigestSigner.init(false, new RsaKeyParameters(false, katM, katE));
                rsaDigestSigner.update(msg, 0, msg.length);
                if (!rsaDigestSigner.verifySignature(pkcs15Sig)) {
                    this.fail("Self test signature verify failed.");
                }
                rsaDigestSigner.init(true, new ParametersWithRandom(testPrivKey, Utils.testRandom));
                rsaDigestSigner.update(msg, 0, msg.length);
                byte[] byArray = rsaDigestSigner.generateSignature();
                if (!Arrays.areEqual(pkcs15Sig, byArray)) {
                    this.fail("Self test signature generate failed.");
                }
            }
        });
    }

    private static void rsaKasTest(final EngineProvider engineProvider) {
        SelfTestExecutor.validate(ALGORITHM_SVE, new VariantInternalKatTest(ALGORITHM_SVE){

            void evaluate() throws Exception {
                ExtractorImpl extractorImpl;
                byte[] byArray;
                byte[] byArray2 = Hex.decode("ce4cf74c1caef7e0455f4210e13fde6847f56c939aedfed9d24c2e6a7c661c461b436ade0a9afd6457be92af33c2626b319e060e9435612215099f9369aaca72351dad4dc14a4c418dbe7fd3b273e91d45fa615c15be8d5e0b97b6aca713cbc549ed4ef2d82f5f8e03b0d0d95d6ce7c7695f8bba938746eff19b70d2c2d56fab");
                byte[] byArray3 = Hex.decode("697140a15ddcb8dc01b7f97d929c20c99f9b1348fa80d67350183e44ca9a90d958758d0299b95fb442338e7c3d3595076f05c51b0152bc8a68a1d0b9eb4077ad716a357f72b10130669eeeb4c7454afe742c14dbcfd469c1f2171b59d2c5b3ebb704157b7df5b8bd68ab15b003355dd3ec033bee5e3d418a8b3dd357d14914143b40b0a6e1900bd1f1bf238f75cbba9a93144bd9ec6ddfe500de2318730d0f55e4ee05cd58201c1993500ff1396a4e66fe868f3eaa8cf09752d48426da24186e7870e610efecc9dc02f959c258d8bbdbc354d652c68e778bb6e523fcd08677d48afbed4f15af72f82b870e4d4b658456dea6f581deb9e6d19a9baa0e30f46023");
                GeneratorImpl generatorImpl = new GeneratorImpl(new RsaKeyParameters(false, katM, katE), new KTSParameters(ALGORITHM_SVE), (SecureRandom)new FixedSecureRandom(new FixedSecureRandom.BigInteger(2048, byArray3), new FixedSecureRandom.Data(byArray2)));
                SecretWithEncapsulation secretWithEncapsulation = generatorImpl.doGeneration(engineProvider.createEngine());
                byte[] byArray4 = secretWithEncapsulation.getEncapsulation();
                if (!Arrays.areEqual(Hex.decode("2dc23f549cedbc83b5efa8c0c666010ea8d59d8c860a473f6f32347b53a7a62b47a63b3f306f03b648aec8defa00414d3a24f422384decd3f147967789f5e7e79a927ec59398f3397d3e930489adbd3f213cebfc29715771f30f38335c4ac6dc8632e0be5649a881d551f9a883925be2f5aed67a09ea8257ca832f9240fc345d64b9d3d0522f533fd2f230803516f359376bdd1df899d8fa793cacae1d84c68a974fa554e88e8d182496c502babf4306c055c05b4f6ff4c9af8b74d20bc564bb9b238b9d16309ed20bc290b615d0cfab69dbf49d594fe256e44ad29025c0d811a63e1fe361ea3d106461069d00981a9c013aded45277ef19e1dba7d18a2249b9"), byArray4)) {
                    this.fail("Self test SVE encryption KAT failed.");
                }
                if (!Arrays.areEqual(byArray3, byArray = (extractorImpl = new ExtractorImpl(new AsymmetricRSAPrivateKey((Algorithm)ALGORITHM_SVE, testPrivKey.getModulus(), testPrivKey.getExponent()), new KTSParameters(ALGORITHM_SVE), Utils.testRandom)).doExtraction(testPrivKey, engineProvider.createEngine(), byArray4, 0, byArray4.length).getSecret())) {
                    this.fail("Self test SVE decryption KAT failed.");
                }
                if (!Arrays.areEqual(secretWithEncapsulation.getSecret(), byArray)) {
                    this.fail("Self test SVE failed.");
                }
            }
        });
    }

    private static void rsaKeyTransportTest(final EngineProvider engineProvider) {
        SelfTestExecutor.validate(ALGORITHM_OAEP, new VariantInternalKatTest(ALGORITHM_OAEP){

            void evaluate() throws Exception {
                byte[] byArray = Hex.decode("4458cce0f94ebd79d275a134d224f95ef4126034e5d979359703b466096fcc15b71b78df4d4a68033112dfcfad7611cc0458475ab4a66b815f87fcb16a8aa1133441b9d61ed846c4856c5d42059fab7505bd8ffa5281a2bb187c6c853f298c98d5752a40be905f85e5ccb27d59415f09ac12a1788d654c675d98f412e6481e6f1159f1736dd96b29c99b411b4e5420b56b07be2885dbc397fa091f66877c41e502cb4afeba460a2ebcdec7d09d933e630b98a4510ad6f32ca7ffc1bdb43e46fff709819d3a69d9b62b774cb12c9dc176a6911bf370ab5029719dc1b4c13e23e57e46a7cd8ba5ee54c954ed460835ddab0086fa36ac110a5790e82c929bc7ca86");
                OAEPEncoding oAEPEncoding = new OAEPEncoding(engineProvider.createEngine(), new SHA1Digest());
                oAEPEncoding.init(true, new ParametersWithRandom(testPubKey, new TestRandomData("18b776ea21069d69776a33e96bad48e1dda0a5ef")));
                byte[] byArray2 = oAEPEncoding.processBlock(msg, 0, msg.length);
                if (!Arrays.areEqual(byArray, byArray2)) {
                    this.fail("Self test OAEP transport encrypt failed.");
                }
                oAEPEncoding.init(false, new ParametersWithRandom(testPrivKey, Utils.testRandom));
                byArray2 = oAEPEncoding.processBlock(byArray, 0, byArray.length);
                if (!Arrays.areEqual(msg, byArray2)) {
                    this.fail("Self test OAEP transport decrypt failed.");
                }
            }
        });
        SelfTestExecutor.validate(ALGORITHM_PKCS1v1_5, new VariantInternalKatTest(ALGORITHM_PKCS1v1_5){

            void evaluate() throws Exception {
                byte[] byArray = Hex.decode("300603e8d5fdb52e4f9d1dea9cac60ef3500700f03f53b1437fee040ef2713ddd0419b69f5ffe92703999895ea4a111f9bb1333c8d5e115f70a41eb9e4a4ee4d20d7781e0c0765b1b3eb51bd96e9a1715c9be703e3dfa9c4195c001a64239709dfb135921ae6de5960d3e13abdf7cb54580db9922e969a9c4f3a35ac1d5c14958159a0e9259556c19daa793892151370012a215fb7a3d2f8daed098e47e9674edbebeba4bbb6c6b9f37d2bdaa218d0cbc1a70030ccb47f72a25168b0e1ef5a5570920db23f092db0be3dbfbee4babf4bd0e4a1355f45bc9e2a3947ed530d0fc66f77ba4167f16ea12f7ace82950de600ef555fb54bea15be1ec3d93e61af1e97");
                PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(engineProvider.createEngine());
                pKCS1Encoding.init(true, new ParametersWithRandom(testPubKey, new RepeatingRandom()));
                byte[] byArray2 = pKCS1Encoding.processBlock(msg, 0, msg.length);
                if (!Arrays.areEqual(byArray, byArray2)) {
                    this.fail("Self test PKCS#1.5 transport encrypt failed.");
                }
                pKCS1Encoding.init(false, new ParametersWithRandom(testPrivKey, Utils.testRandom));
                byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
                if (!Arrays.areEqual(msg, byArray2)) {
                    this.fail("Self test PKCS#1.5 transport decrypt failed.");
                }
            }
        });
    }

    static {
        ALGORITHM_PKCS1v1_5 = new FipsAlgorithm("RSA/PKCS1V1.5", (Enum)Variations.PKCS1v1_5);
        ALGORITHM_PSS = new FipsAlgorithm("RSA/PSS", (Enum)Variations.PSS);
        ALGORITHM_X931 = new FipsAlgorithm("RSA/X9.31", (Enum)Variations.X931);
        ALGORITHM_OAEP = new FipsAlgorithm("RSA/OAEP", (Enum)Variations.OAEP);
        ALGORITHM_SVE = new FipsAlgorithm("RSA/SVE", (Enum)Variations.SVE);
        PKCS1v1_5 = new PKCS1v15SignatureParameters();
        PSS = new PSSSignatureParameters();
        X931 = new X931SignatureParameters();
        WRAP_PKCS1v1_5 = new PKCS1v15Parameters();
        WRAP_OAEP = new OAEPParameters();
        KTS_SVE = new SVEKTSParameters();
        KTS_OAEP = new OAEPKTSParameters(WRAP_OAEP, 128);
        MIN_PUB_EXP = BigInteger.valueOf(65537L);
        MAX_PUB_EXP = BigInteger.ONE.shiftLeft(256).subtract(BigInteger.ONE);
        katE = new BigInteger("10001", 16);
        katM = new BigInteger("83ca29fa6f3da1a20a7d64c741c502def9dff5630c94ca0c674a7602aea3436d432c94e3fe9f8cea4a7975ffa5228cba39acb6d1262c3453280bd8352b0dc7fb0a343f62b2c1405baf44c0f6b37edc94f63de8f772dc30e3b5003ff9a35befa02540e08b128718870fab40dcd91575b6592bb143cc3f29aa82fce7ee72952601c0c815396a9ad382c0a79e494727478606bf92d7b1c445b73368b4d7480500091de498b365719ec9c9b76f37cc97d13d7ce830248f4df2cdc73433a9b5d3fe29122bfdb113be45444b15652059eb51085dfe354d0c87256e6a51c6902ce56d3967dcf32f3bc9464ab437ac4030d00c1e53b4da74b9e70c47a5842f3b4d4dd6c7", 16);
        katD = new BigInteger("22b248d6fc0e77cd5781a7d4a5c61e7961c3cab0e7110d18b2e0f1acc7198898ed8481367d44b82ebea8b79e3475a2232d28018192d1347d681fa62e6945598f0822b54560d66c0137659c7fd6c5e180fe4b5258434f2137f1e13cf696419016d377ff25de1cdf223fc7d06dd46147fa58039ec9c0ae286411d44fa3815b2f040895344a413ba141b4228a704a75883caaa3e9d2ace0d28c179acb571ca8ce0d1c3a0cf9cda8b0088b919a4833f5b46ce556faa923ea5b852a48f153ca6fc26730496d7f06691e08edac984870517d2ef689a94ad23c16d471c9a477d82fd225382a4d1ae1b934bf79f2adf3353c557888e056822809dfb561bbef946c1404d1", 16);
        katP = new BigInteger("df26154977b823cbee3e1861b239197310bc3115ee46e7e70bf6dd826aa834fcdafb8d940b77e43e63c073b2efceaa24805c232a3011fd8b2ac323442d89f246a024c843586174d28475fbf7eca079fae8bbe5263cdef074be0a9a07a37bdad3e72b4b44a39a70415db4b0f7f65515f6806ef88b97f935b8d6d5918feff69edd", 16);
        katQ = new BigInteger("9730fcb5f8e93cb4df58b80ab3e9b7f014a87b90953c26a29277771965bf2720e1808adf55aa5ac4702ba813eb2643d03a89dad3a3767beddd3fa98148057c8398a0106b086caef10603977e69ffe3e513531c7b456bb7079c57761a7eacde4218c08897ac17d4de7a5b19d192b5706694cbb162c9f95b0154232fc7bd0107f3", 16);
        katDP = new BigInteger("dba3666c6bb40937de85ac05ed201a9691304ab82552114bef10cb3264bcaf7afa278350e680d95d375de40389da46c9aab605beae95e6932641efe259585fe97812fc329d393f7d3df7cb4c59d2127e0eb97270d29534e41371e7ee00d215af60e7d22bfb44359d81182adfc5cc35d3ecd24d3d491677f43930f9174dbfd6d9", 16);
        katDQ = new BigInteger("82d8a47ca054ca7306b07366dfd9af94996c4eb40c53a8641e3a41dabb11b9bd5d2bb00424d170087dc36a8d027f7544eac48f9b85e66ecea7220782996016289598415d40473f07dcda92eb96b51cf80dc769e8cd65b15b66d4d2a38f69f05867af89072aaadd5145b73e1affcb02e1e4787ca630821b5e850086c36831523d", 16);
        katQInv = new BigInteger("c6ae6a9ff4614a08e1e501e3dd7586c7cd2e70b9e2581185194b7984452325558f576b54b177df38f6d98e2ffce835608d1d3c81fab9f3696796bd5faacf9870b5ad12868eebccb2f55cc398d70ad6197eaeb4ead5cb0415913f18306bc0327f31db0f04910aea237a657634f1ac82b03bd5b2bc30b5f89077677bd3cab0d255", 16);
        msg = Hex.decode("48656c6c6f20776f726c6421");
        pkcs15Sig = Hex.decode("1669b752b409a66ca38ba7e34ae2d5da4303c091255989a4369885ecbb25db3ec05b06fdb4b1be46f6ab347bad9dbbbc9facf0beb4be70bd5f2ee2760c76f0a55932dd7fb4fe5c7b18226796f955215ec6354da9b3808a0df8c2a328abdd67d537f967ea5147bb85dcd80fdcee250b9bc7cec84a08afcde82afa4e62d80bbaf00bcdaf6bbac2b4a4bd394ee223ea3ee100fd233dd40514ea7a9717bfb52370eb4157e7bd25396e9dd3e3782ec2c64db71cf8380c05d3941481af3a08003737456a00cb265efc1d0987acae40776fa497681cb987a508419cbe1e4601a5e5aef66329288453003101a375ad3ec6e4b9a82f49a0748eb024fe1ce2de910d823938");
        testPubKey = new RsaKeyParameters(false, katM, katE);
        testPrivKey = new RsaPrivateCrtKeyParameters(katM, katE, katD, katP, katQ, katDP, katDQ, katQInv);
        EngineProvider engineProvider = new EngineProvider();
        FipsRSA.rsaSignTest(engineProvider);
        FipsRSA.rsaKasTest(engineProvider);
        FipsRSA.rsaKeyTransportTest(engineProvider);
        ENGINE_PROVIDER = engineProvider;
        FipsRegister.registerEngineProvider(ALGORITHM, engineProvider);
    }

    private static class DummyProvider
    extends Provider {
        DummyProvider() {
            super("FipsRSA_TEST_RNG", 1.0, "BCFIPS FipsRSA Test Provider");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EngineProvider
    extends FipsEngineProvider<AsymmetricBlockCipher> {
        private static final BigInteger mod = new BigInteger("b259d2d6e627a768c94be36164c2d9fc79d97aab9253140e5bf17751197731d6f7540d2509e7b9ffee0a70a6e26d56e92d2edd7f85aba85600b69089f35f6bdbf3c298e05842535d9f064e6b0391cb7d306e0a2d20c4dfb4e7b49a9640bdea26c10ad69c3f05007ce2513cee44cfe01998e62b6c3637d3fc0391079b26ee36d5", 16);
        private static final BigInteger pubExp = new BigInteger("11", 16);
        private static final BigInteger privExp = new BigInteger("92e08f83cc9920746989ca5034dcb384a094fb9c5a6288fcc4304424ab8f56388f72652d8fafc65a4b9020896f2cde297080f2a540e7b7ce5af0b3446e1258d1dd7f245cf54124b4c6e17da21b90a0ebd22605e6f45c9f136d7a13eaac1c0f7487de8bd6d924972408ebb58af71e76fd7b012a8d0e165f3ae2e5077a8648e619", 16);
        private static final BigInteger p = new BigInteger("f75e80839b9b9379f1cf1128f321639757dba514642c206bbbd99f9a4846208b3e93fbbe5e0527cc59b1d4b929d9555853004c7c8b30ee6a213c3d1bb7415d03", 16);
        private static final BigInteger q = new BigInteger("b892d9ebdbfc37e397256dd8a5d3123534d1f03726284743ddc6be3a709edb696fc40c7d902ed804c6eee730eee3d5b20bf6bd8d87a296813c87d3b3cc9d7947", 16);
        private static final BigInteger pExp = new BigInteger("1d1a2d3ca8e52068b3094d501c9a842fec37f54db16e9a67070a8b3f53cc03d4257ad252a1a640eadd603724d7bf3737914b544ae332eedf4f34436cac25ceb5", 16);
        private static final BigInteger qExp = new BigInteger("6c929e4e81672fef49d9c825163fec97c4b7ba7acb26c0824638ac22605d7201c94625770984f78a56e6e25904fe7db407099cad9b14588841b94f5ab498dded", 16);
        private static final BigInteger crtCoef = new BigInteger("dae7651ee69ad1d081ec5e7188ae126f6004ff39556bde90e0b870962fa7b926d070686d8244fe5a9aa709a95686a104614834b0ada4b10f53197a5cb4c97339", 16);
        private static final byte[] edgeInput = Hex.decode("ff6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e");
        private static final byte[] edgeOutput = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc3497a9fb17ba03d95f28fad91247d6f8ebc463fa8ada974f0f4e28961565a73a46a465369e0798ccbf7893cb9afaa7c426cc4fea6f429e67b6205b682a9831337f2548fd165c2dd7bf5b54be5894403d6e9f6283e65fb134cd4687bf86f95e7a");

        private EngineProvider() {
        }

        @Override
        public AsymmetricBlockCipher createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new RsaBlindedEngine(), new VariantKatTest<RsaBlindedEngine>(){

                @Override
                void evaluate(RsaBlindedEngine rsaBlindedEngine) throws Exception {
                    RsaKeyParameters rsaKeyParameters = new RsaKeyParameters(false, mod, pubExp);
                    RsaPrivateCrtKeyParameters rsaPrivateCrtKeyParameters = new RsaPrivateCrtKeyParameters(mod, pubExp, privExp, p, q, pExp, qExp, crtCoef);
                    byte[] byArray = edgeInput;
                    rsaBlindedEngine.init(true, new ParametersWithRandom(rsaKeyParameters, Utils.testRandom));
                    try {
                        byArray = rsaBlindedEngine.processBlock(byArray, 0, byArray.length);
                    }
                    catch (Exception exception) {
                        this.fail("Self test failed: exception " + exception.toString());
                    }
                    if (!Arrays.areEqual(edgeOutput, byArray)) {
                        this.fail("Self test failed: input does not match decrypted output");
                    }
                    rsaBlindedEngine.init(false, new ParametersWithRandom(rsaPrivateCrtKeyParameters, Utils.testRandom));
                    try {
                        byArray = rsaBlindedEngine.processBlock(byArray, 0, byArray.length);
                    }
                    catch (Exception exception) {
                        this.fail("Self test failed: exception " + exception.toString());
                    }
                    if (!Arrays.areEqual(edgeInput, byArray)) {
                        this.fail("Self test failed: input does not match decrypted output");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractorImpl
    extends FipsEncapsulatedSecretExtractor<KTSParameters> {
        private final AsymmetricRSAPrivateKey privKey;
        private final KTSParameters parameters;
        private final SecureRandom random;

        ExtractorImpl(AsymmetricRSAPrivateKey asymmetricRSAPrivateKey, KTSParameters kTSParameters, SecureRandom secureRandom) {
            if (!asymmetricRSAPrivateKey.canBeUsed(AsymmetricRSAKey.Usage.ENCRYPT_OR_DECRYPT)) {
                throw new IllegalKeyException("Attempt to encrypt/decrypt with RSA modulus already used for sign/verify.");
            }
            this.privKey = asymmetricRSAPrivateKey;
            this.parameters = kTSParameters;
            this.random = secureRandom;
        }

        @Override
        public KTSParameters getParameters() {
            return this.parameters;
        }

        @Override
        public SecretWithEncapsulation extractSecret(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
            return this.doExtraction(FipsRSA.getPrivateKeyParameters(this.privKey), (AsymmetricBlockCipher)ENGINE_PROVIDER.createEngine(), byArray, n, n2);
        }

        private SecretWithEncapsulation doExtraction(RsaKeyParameters rsaKeyParameters, AsymmetricBlockCipher asymmetricBlockCipher, byte[] byArray, int n, int n2) throws InvalidCipherTextException {
            Object object;
            AsymmetricBlockCipher asymmetricBlockCipher2;
            if (this.parameters.getAlgorithm() == ALGORITHM_SVE) {
                asymmetricBlockCipher2 = asymmetricBlockCipher;
            } else {
                object = (OAEPKTSParameters)this.parameters;
                OAEPParameters oAEPParameters = ((OAEPKTSParameters)object).oaepParameters;
                asymmetricBlockCipher2 = new OAEPEncoding(asymmetricBlockCipher, FipsSHS.createDigest(oAEPParameters.digestAlgorithm), FipsSHS.createDigest(oAEPParameters.mgfDigestAlgorithm), oAEPParameters.encodingParams);
            }
            asymmetricBlockCipher2.init(false, new ParametersWithRandom(rsaKeyParameters, this.random));
            try {
                object = asymmetricBlockCipher2.processBlock(byArray, n, n2);
                if (this.parameters.getAlgorithm() == ALGORITHM_SVE) {
                    int n3 = (this.privKey.getModulus().bitLength() + 7) / 8;
                    object = this.correctedExtract(n3, (byte[])object);
                }
                return new SecretWithEncapsulationImpl((byte[])object, Arrays.copyOfRange(byArray, n, n + n2));
            }
            catch (org.bouncycastle.crypto.internal.InvalidCipherTextException invalidCipherTextException) {
                throw new InvalidCipherTextException("Unable to extract secret: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
            }
        }

        private byte[] correctedExtract(int n, byte[] byArray) {
            if (byArray.length < n) {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
                Arrays.fill(byArray, (byte)0);
                return byArray2;
            }
            return byArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GeneratorImpl
    extends FipsEncapsulatingSecretGenerator<KTSParameters> {
        private static final BigInteger TWO = BigInteger.valueOf(2L);
        private final RsaKeyParameters pubKey;
        private final KTSParameters parameters;
        private final SecureRandom random;

        GeneratorImpl(AsymmetricRSAPublicKey asymmetricRSAPublicKey, KTSParameters kTSParameters, SecureRandom secureRandom) {
            if (!asymmetricRSAPublicKey.canBeUsed(AsymmetricRSAKey.Usage.ENCRYPT_OR_DECRYPT)) {
                throw new IllegalKeyException("Attempt to encrypt/decrypt with RSA modulus already used for sign/verify.");
            }
            this.pubKey = new RsaKeyParameters(false, asymmetricRSAPublicKey.getModulus(), asymmetricRSAPublicKey.getPublicExponent());
            this.parameters = kTSParameters;
            this.random = secureRandom;
        }

        GeneratorImpl(RsaKeyParameters rsaKeyParameters, KTSParameters kTSParameters, SecureRandom secureRandom) {
            this.pubKey = rsaKeyParameters;
            this.parameters = kTSParameters;
            this.random = secureRandom;
        }

        @Override
        public EncapsulatingSecretGenerator<KTSParameters> withSecureRandom(SecureRandom secureRandom) {
            return new GeneratorImpl(this.pubKey, this.parameters, secureRandom);
        }

        @Override
        public KTSParameters getParameters() {
            return this.parameters;
        }

        @Override
        public SecretWithEncapsulation generate() throws PlainInputProcessingException {
            return this.doGeneration((AsymmetricBlockCipher)ENGINE_PROVIDER.createEngine());
        }

        SecretWithEncapsulation doGeneration(AsymmetricBlockCipher asymmetricBlockCipher) throws PlainInputProcessingException {
            byte[] byArray;
            AsymmetricBlockCipher asymmetricBlockCipher2;
            if (this.parameters.getAlgorithm() == ALGORITHM_SVE) {
                asymmetricBlockCipher2 = asymmetricBlockCipher;
                int n = (this.pubKey.getModulus().bitLength() + 7) / 8;
                BigInteger bigInteger = BigIntegers.createRandomInRange(TWO, this.pubKey.getModulus().subtract(TWO), this.random);
                byArray = BigIntegers.asUnsignedByteArray(n, bigInteger);
                asymmetricBlockCipher2.init(true, new ParametersWithRandom(this.pubKey, this.random));
            } else {
                OAEPKTSParameters oAEPKTSParameters = (OAEPKTSParameters)this.parameters;
                OAEPParameters oAEPParameters = oAEPKTSParameters.oaepParameters;
                asymmetricBlockCipher2 = new OAEPEncoding(asymmetricBlockCipher, FipsSHS.createDigest(oAEPParameters.digestAlgorithm), FipsSHS.createDigest(oAEPParameters.mgfDigestAlgorithm), oAEPParameters.encodingParams);
                asymmetricBlockCipher2.init(true, new ParametersWithRandom(this.pubKey, this.random));
                int n = (oAEPKTSParameters.getKeySizeInBits() + 7) / 8 + (oAEPKTSParameters.getMacKeySizeInBits() + 7) / 8;
                if (n > asymmetricBlockCipher2.getInputBlockSize()) {
                    throw new IllegalArgumentException("Key material size too large for cipher");
                }
                byArray = new byte[n];
                this.random.nextBytes(byArray);
            }
            try {
                return new SecretWithEncapsulationImpl(byArray, asymmetricBlockCipher2.processBlock(byArray, 0, byArray.length));
            }
            catch (Exception exception) {
                throw new PlainInputProcessingException("Unable to wrap secret: " + exception.getMessage(), exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KTSOperatorFactory
    extends FipsKTSOperatorFactory<KTSParameters> {
        private final SecureRandom random;

        public KTSOperatorFactory(SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateRandom(secureRandom, "Attempt to create KTSOperatorFactory with unapproved RNG");
            }
            this.random = secureRandom;
        }

        @Override
        public FipsEncapsulatingSecretGenerator<KTSParameters> createGenerator(Key key, KTSParameters kTSParameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateRandom(this.random, kTSParameters.getAlgorithm(), "Attempt to create generator with unapproved RNG");
            }
            return new GeneratorImpl((AsymmetricRSAPublicKey)key, kTSParameters, this.random);
        }

        @Override
        public FipsEncapsulatedSecretExtractor<KTSParameters> createExtractor(Key key, KTSParameters kTSParameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateRandom(this.random, kTSParameters.getAlgorithm(), "Attempt to create extractor with unapproved RNG");
            }
            AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = (AsymmetricRSAPrivateKey)key;
            return new ExtractorImpl(asymmetricRSAPrivateKey, kTSParameters, this.random);
        }
    }

    public static class KTSParameters
    extends FipsParameters {
        KTSParameters(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }
    }

    public static final class KeyGenParameters
    extends FipsParameters {
        private BigInteger publicExponent;
        private int keySize;
        private int certainty;

        public KeyGenParameters(BigInteger bigInteger, int n) {
            this(ALGORITHM, bigInteger, n, PrimeCertaintyCalculator.getDefaultCertainty(n));
        }

        public KeyGenParameters(BigInteger bigInteger, int n, int n2) {
            this(ALGORITHM, bigInteger, n, n2);
        }

        public KeyGenParameters(SignatureParameters signatureParameters, BigInteger bigInteger, int n) {
            this(signatureParameters.getAlgorithm(), bigInteger, n, PrimeCertaintyCalculator.getDefaultCertainty(n));
        }

        public KeyGenParameters(WrapParameters wrapParameters, BigInteger bigInteger, int n) {
            this(wrapParameters.getAlgorithm(), bigInteger, n, PrimeCertaintyCalculator.getDefaultCertainty(n));
        }

        public KeyGenParameters(KTSParameters kTSParameters, BigInteger bigInteger, int n) {
            this(kTSParameters.getAlgorithm(), bigInteger, n, PrimeCertaintyCalculator.getDefaultCertainty(n));
        }

        private KeyGenParameters(FipsAlgorithm fipsAlgorithm, BigInteger bigInteger, int n, int n2) {
            super(fipsAlgorithm);
            this.publicExponent = bigInteger;
            this.keySize = n;
            this.certainty = n2;
            this.validate();
        }

        private void validate() {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                if (this.keySize < 2048) {
                    throw new FipsUnapprovedOperationError("Attempt to use RSA key size outside of accepted range - requested keySize " + this.keySize + " bits", this.getAlgorithm());
                }
                if (this.publicExponent.compareTo(MIN_PUB_EXP) < 0) {
                    throw new FipsUnapprovedOperationError("Public exponent too small", this.getAlgorithm());
                }
                if (this.publicExponent.compareTo(MAX_PUB_EXP) > 0) {
                    throw new FipsUnapprovedOperationError("Public exponent too large", this.getAlgorithm());
                }
                if (!this.publicExponent.testBit(0)) {
                    throw new FipsUnapprovedOperationError("Public exponent must be an odd number", this.getAlgorithm());
                }
                if (this.certainty < PrimeCertaintyCalculator.getDefaultCertainty(this.keySize)) {
                    throw new FipsUnapprovedOperationError("Prime generation certainty " + this.certainty + " inadequate for key of  " + this.keySize + " bits", this.getAlgorithm());
                }
            } else if (!this.publicExponent.testBit(0)) {
                throw new IllegalArgumentException("Public exponent must be an odd number: " + this.getAlgorithm().getName());
            }
        }

        public BigInteger getPublicExponent() {
            return this.publicExponent;
        }

        public int getKeySize() {
            return this.keySize;
        }

        public int getCertainty() {
            return this.certainty;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends FipsAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey> {
        private final RsaKeyPairGenerator engine = new RsaKeyPairGenerator();
        private final RsaKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            int n = keyGenParameters.getKeySize();
            keyGenParameters.validate();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateKeyPairGenRandom(secureRandom, Utils.getAsymmetricSecurityStrength(n), ALGORITHM);
            }
            this.param = new RsaKeyGenerationParameters(keyGenParameters.getPublicExponent(), secureRandom, n, keyGenParameters.getCertainty());
            this.engine.init(this.param);
        }

        @Override
        public AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey> generateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            RsaKeyParameters rsaKeyParameters = (RsaKeyParameters)asymmetricCipherKeyPair.getPublic();
            RsaPrivateCrtKeyParameters rsaPrivateCrtKeyParameters = (RsaPrivateCrtKeyParameters)asymmetricCipherKeyPair.getPrivate();
            FipsAlgorithm fipsAlgorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            FipsRSA.validateKeyPair(asymmetricCipherKeyPair);
            AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = new AsymmetricRSAPrivateKey(fipsAlgorithm, rsaPrivateCrtKeyParameters.getModulus(), rsaPrivateCrtKeyParameters.getPublicExponent(), rsaPrivateCrtKeyParameters.getExponent(), rsaPrivateCrtKeyParameters.getP(), rsaPrivateCrtKeyParameters.getQ(), rsaPrivateCrtKeyParameters.getDP(), rsaPrivateCrtKeyParameters.getDQ(), rsaPrivateCrtKeyParameters.getQInv());
            return new AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey>(new AsymmetricRSAPublicKey((Algorithm)fipsAlgorithm, rsaKeyParameters.getModulus(), rsaKeyParameters.getExponent()), asymmetricRSAPrivateKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    extends FipsKeyWrapOperatorFactory<WrapParameters, AsymmetricRSAKey> {
        @Override
        public FipsKeyWrapperUsingSecureRandom<WrapParameters> createKeyWrapper(AsymmetricRSAKey asymmetricRSAKey, WrapParameters wrapParameters) {
            return new KeyWrapper(asymmetricRSAKey, wrapParameters, null);
        }

        @Override
        public FipsKeyUnwrapperUsingSecureRandom<WrapParameters> createKeyUnwrapper(AsymmetricRSAKey asymmetricRSAKey, WrapParameters wrapParameters) {
            return new KeyUnwrapper(asymmetricRSAKey, wrapParameters, null);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyUnwrapper
        extends FipsKeyUnwrapperUsingSecureRandom<WrapParameters> {
            private final AsymmetricBlockCipher keyWrapper;
            private final AsymmetricRSAKey key;
            private final WrapParameters parameters;

            public KeyUnwrapper(AsymmetricRSAKey asymmetricRSAKey, WrapParameters wrapParameters, SecureRandom secureRandom) {
                if (!asymmetricRSAKey.canBeUsed(AsymmetricRSAKey.Usage.ENCRYPT_OR_DECRYPT)) {
                    throw new IllegalKeyException("Attempt to encrypt/decrypt with RSA modulus already used for sign/verify.");
                }
                this.key = asymmetricRSAKey;
                this.parameters = wrapParameters;
                this.keyWrapper = secureRandom != null ? FipsRSA.createCipher(false, asymmetricRSAKey, wrapParameters, secureRandom) : null;
            }

            @Override
            public WrapParameters getParameters() {
                return this.parameters;
            }

            @Override
            public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidWrappingException {
                if (this.keyWrapper == null) {
                    throw new IllegalStateException("KeyUnwrapper requires a SecureRandom");
                }
                try {
                    return this.keyWrapper.processBlock(byArray, n, n2);
                }
                catch (Exception exception) {
                    throw new InvalidWrappingException("Unable to unwrap key: " + exception.getMessage(), exception);
                }
            }

            @Override
            public FipsKeyUnwrapperUsingSecureRandom<WrapParameters> withSecureRandom(SecureRandom secureRandom) {
                return new KeyUnwrapper(this.key, this.parameters, secureRandom);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyWrapper
        extends FipsKeyWrapperUsingSecureRandom<WrapParameters> {
            private final AsymmetricBlockCipher keyWrapper;
            private final AsymmetricRSAKey key;
            private final WrapParameters parameters;

            public KeyWrapper(AsymmetricRSAKey asymmetricRSAKey, WrapParameters wrapParameters, SecureRandom secureRandom) {
                if (!asymmetricRSAKey.canBeUsed(AsymmetricRSAKey.Usage.ENCRYPT_OR_DECRYPT)) {
                    throw new IllegalKeyException("Attempt to encrypt/decrypt with RSA modulus already used for sign/verify.");
                }
                this.key = asymmetricRSAKey;
                this.parameters = wrapParameters;
                this.keyWrapper = secureRandom != null ? FipsRSA.createCipher(true, asymmetricRSAKey, wrapParameters, secureRandom) : null;
            }

            @Override
            public WrapParameters getParameters() {
                return this.parameters;
            }

            @Override
            public byte[] wrap(byte[] byArray, int n, int n2) throws PlainInputProcessingException {
                if (this.keyWrapper == null) {
                    throw new IllegalStateException("KeyWrapper requires a SecureRandom");
                }
                try {
                    return this.keyWrapper.processBlock(byArray, n, n2);
                }
                catch (Exception exception) {
                    throw new PlainInputProcessingException("Unable to wrap key: " + exception.getMessage(), exception);
                }
            }

            @Override
            public KeyWrapperUsingSecureRandom<WrapParameters> withSecureRandom(SecureRandom secureRandom) {
                return new KeyWrapper(this.key, this.parameters, secureRandom);
            }
        }
    }

    private static class NullSigner
    implements Signer {
        AsymmetricBlockCipher engine = new PKCS1Encoding((AsymmetricBlockCipher)ENGINE_PROVIDER.createEngine());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        private NullSigner() {
        }

        public void init(boolean bl, CipherParameters cipherParameters) {
            this.engine.init(bl, cipherParameters);
        }

        public void update(byte by) {
            this.bOut.write(by);
        }

        public void update(byte[] byArray, int n, int n2) {
            this.bOut.write(byArray, n, n2);
        }

        public byte[] generateSignature() throws CryptoException, DataLengthException {
            byte[] byArray = this.bOut.toByteArray();
            this.bOut.reset();
            return this.engine.processBlock(byArray, 0, byArray.length);
        }

        public boolean verifySignature(byte[] byArray) throws InvalidSignatureException {
            byte[] byArray2 = this.bOut.toByteArray();
            this.bOut.reset();
            try {
                byte[] byArray3 = this.engine.processBlock(byArray, 0, byArray.length);
                return BaseRsaDigestSigner.checkPKCS1Sig(byArray2, byArray3);
            }
            catch (org.bouncycastle.crypto.internal.InvalidCipherTextException invalidCipherTextException) {
                throw new InvalidSignatureException("Unable to process signature: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
            }
        }

        public void reset() {
            this.bOut = new ByteArrayOutputStream();
        }
    }

    public static final class OAEPKTSParameters
    extends KTSParameters {
        private final OAEPParameters oaepParameters;
        private final int keySizeInBits;
        private final int macKeySizeInBits;

        OAEPKTSParameters(OAEPParameters oAEPParameters, int n) {
            this(oAEPParameters, n, 0);
        }

        private OAEPKTSParameters(OAEPParameters oAEPParameters, int n, int n2) {
            super(ALGORITHM_OAEP);
            this.oaepParameters = oAEPParameters;
            this.keySizeInBits = n;
            this.macKeySizeInBits = n2;
        }

        public OAEPKTSParameters withOAEPParameters(OAEPParameters oAEPParameters) {
            return new OAEPKTSParameters(oAEPParameters, this.keySizeInBits, this.macKeySizeInBits);
        }

        public OAEPKTSParameters withKeySizeInBits(int n) {
            return new OAEPKTSParameters(this.oaepParameters, n, this.macKeySizeInBits);
        }

        public OAEPKTSParameters withMacKeySizeInBits(int n) {
            return new OAEPKTSParameters(this.oaepParameters, this.keySizeInBits, n);
        }

        public OAEPParameters getOAEPParameters() {
            return this.oaepParameters;
        }

        public int getKeySizeInBits() {
            return this.keySizeInBits;
        }

        public int getMacKeySizeInBits() {
            return this.macKeySizeInBits;
        }
    }

    public static final class OAEPParameters
    extends WrapParameters {
        private final FipsDigestAlgorithm digestAlgorithm;
        private final FipsDigestAlgorithm mgfDigestAlgorithm;
        private final byte[] encodingParams;

        OAEPParameters() {
            this(FipsSHS.Algorithm.SHA1, FipsSHS.Algorithm.SHA1, null);
        }

        private OAEPParameters(FipsDigestAlgorithm fipsDigestAlgorithm, FipsDigestAlgorithm fipsDigestAlgorithm2, byte[] byArray) {
            super(ALGORITHM_OAEP);
            this.digestAlgorithm = fipsDigestAlgorithm;
            this.mgfDigestAlgorithm = fipsDigestAlgorithm2;
            this.encodingParams = Arrays.clone(byArray);
        }

        public OAEPParameters withDigest(FipsDigestAlgorithm fipsDigestAlgorithm) {
            return new OAEPParameters(fipsDigestAlgorithm, fipsDigestAlgorithm, this.encodingParams);
        }

        public OAEPParameters withMGFDigest(FipsDigestAlgorithm fipsDigestAlgorithm) {
            return new OAEPParameters(this.digestAlgorithm, fipsDigestAlgorithm, this.encodingParams);
        }

        public OAEPParameters withEncodingParams(byte[] byArray) {
            return new OAEPParameters(this.digestAlgorithm, this.mgfDigestAlgorithm, Arrays.clone(byArray));
        }

        public FipsDigestAlgorithm getDigest() {
            return this.digestAlgorithm;
        }

        public FipsDigestAlgorithm getMGFDigest() {
            return this.mgfDigestAlgorithm;
        }

        public byte[] getEncodingParams() {
            return Arrays.clone(this.encodingParams);
        }
    }

    public static final class PKCS1v15Parameters
    extends WrapParameters {
        PKCS1v15Parameters() {
            super(ALGORITHM_PKCS1v1_5);
        }
    }

    public static final class PKCS1v15SignatureParameters
    extends SignatureParameters {
        PKCS1v15SignatureParameters() {
            super(ALGORITHM_PKCS1v1_5, FipsSHS.Algorithm.SHA1);
        }

        private PKCS1v15SignatureParameters(FipsDigestAlgorithm fipsDigestAlgorithm) {
            super(ALGORITHM_PKCS1v1_5, fipsDigestAlgorithm);
        }

        public PKCS1v15SignatureParameters withDigestAlgorithm(FipsDigestAlgorithm fipsDigestAlgorithm) {
            return new PKCS1v15SignatureParameters(fipsDigestAlgorithm);
        }
    }

    public static final class PSSSignatureParameters
    extends SignatureParameters {
        private final int saltLength;
        private final FipsDigestAlgorithm mgfDigest;
        private final int trailer;
        private final byte[] salt;

        PSSSignatureParameters() {
            this(FipsSHS.Algorithm.SHA1, FipsSHS.Algorithm.SHA1, 20, null, -68);
        }

        private PSSSignatureParameters(FipsDigestAlgorithm fipsDigestAlgorithm, FipsDigestAlgorithm fipsDigestAlgorithm2, int n, byte[] byArray, int n2) {
            super(ALGORITHM_PSS, fipsDigestAlgorithm);
            this.mgfDigest = fipsDigestAlgorithm2;
            this.saltLength = n;
            this.salt = byArray;
            this.trailer = n2;
        }

        public PSSSignatureParameters withDigestAlgorithm(FipsDigestAlgorithm fipsDigestAlgorithm) {
            return new PSSSignatureParameters(fipsDigestAlgorithm, fipsDigestAlgorithm, FipsSHS.createDigest(fipsDigestAlgorithm).getDigestSize(), null, this.trailer);
        }

        public PSSSignatureParameters withMGFDigest(FipsDigestAlgorithm fipsDigestAlgorithm) {
            return new PSSSignatureParameters(this.getDigestAlgorithm(), fipsDigestAlgorithm, this.saltLength, this.salt, this.trailer);
        }

        public PSSSignatureParameters withSaltLength(int n) {
            return new PSSSignatureParameters(this.getDigestAlgorithm(), this.mgfDigest, n, null, this.trailer);
        }

        public PSSSignatureParameters withTrailer(int n) {
            return new PSSSignatureParameters(this.getDigestAlgorithm(), this.mgfDigest, this.saltLength, this.salt, n);
        }

        public PSSSignatureParameters withSalt(byte[] byArray) {
            return new PSSSignatureParameters(this.getDigestAlgorithm(), this.mgfDigest, byArray.length, Arrays.clone(byArray), this.trailer);
        }

        public byte[] getSalt() {
            return Arrays.clone(this.salt);
        }

        public int getSaltLength() {
            return this.saltLength;
        }

        public FipsDigestAlgorithm getMGFDigest() {
            return this.mgfDigest;
        }

        public int getTrailer() {
            return this.trailer;
        }
    }

    private static final class RepeatingRandom
    extends SecureRandom {
        RepeatingRandom() {
            super(null, new DummyProvider());
        }

        public void nextBytes(byte[] byArray) {
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = (byte)(i % 255);
            }
        }
    }

    public static final class SVEKTSParameters
    extends KTSParameters {
        public SVEKTSParameters() {
            super(ALGORITHM_SVE);
        }
    }

    private static class SecretWithEncapsulationImpl
    implements SecretWithEncapsulation {
        private final byte[] secret;
        private final byte[] encapsulation;

        public SecretWithEncapsulationImpl(byte[] byArray, byte[] byArray2) {
            this.secret = Arrays.clone(byArray);
            this.encapsulation = Arrays.clone(byArray2);
        }

        public final byte[] getSecret() {
            return Arrays.clone(this.secret);
        }

        public final byte[] getEncapsulation() {
            return Arrays.clone(this.encapsulation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignatureOperatorFactory<T extends SignatureParameters>
    extends FipsSignatureOperatorFactory<T> {
        @Override
        public FipsOutputSignerUsingSecureRandom<T> createSigner(AsymmetricPrivateKey asymmetricPrivateKey, T t) {
            int n;
            AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = (AsymmetricRSAPrivateKey)asymmetricPrivateKey;
            if (!asymmetricRSAPrivateKey.canBeUsed(AsymmetricRSAKey.Usage.SIGN_OR_VERIFY)) {
                throw new IllegalKeyException("Attempt to sign/verify with RSA modulus already used for encrypt/decrypt.");
            }
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && (n = asymmetricRSAPrivateKey.getModulus().bitLength()) < 2048) {
                throw new FipsUnapprovedOperationError("Attempt to use RSA key with non-approved size: " + n, asymmetricPrivateKey.getAlgorithm());
            }
            return new RSASigner(this, t, (CipherParameters)FipsRSA.getPrivateKeyParameters(asymmetricRSAPrivateKey), null);
        }

        @Override
        public FipsOutputVerifier<T> createVerifier(AsymmetricPublicKey asymmetricPublicKey, T t) {
            int n;
            Signer signer = t instanceof PKCS1v15SignatureParameters ? (((SignatureParameters)t).getDigestAlgorithm() == null ? new NullSigner() : new RsaDigestSigner((AsymmetricBlockCipher)ENGINE_PROVIDER.createEngine(), FipsSHS.createDigest(((SignatureParameters)t).getDigestAlgorithm()))) : (t instanceof PSSSignatureParameters ? FipsRSA.getPSSSigner((PSSSignatureParameters)t) : new X931Signer(new RsaBlindedEngine(), FipsSHS.createDigest(((SignatureParameters)t).getDigestAlgorithm())));
            AsymmetricRSAPublicKey asymmetricRSAPublicKey = (AsymmetricRSAPublicKey)asymmetricPublicKey;
            if (!asymmetricRSAPublicKey.canBeUsed(AsymmetricRSAKey.Usage.SIGN_OR_VERIFY)) {
                throw new IllegalKeyException("Attempt to sign/verify with RSA modulus already used for encrypt/decrypt.");
            }
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && (n = asymmetricRSAPublicKey.getModulus().bitLength()) < 2048 && n != 1024 && n != 1536) {
                throw new FipsUnapprovedOperationError("Attempt to use RSA key with non-approved size: " + n, asymmetricPublicKey.getAlgorithm());
            }
            RsaKeyParameters rsaKeyParameters = new RsaKeyParameters(false, asymmetricRSAPublicKey.getModulus(), asymmetricRSAPublicKey.getPublicExponent());
            signer.init(false, rsaKeyParameters);
            return new FipsOutputVerifier<T>((SignatureParameters)t, signer){
                final /* synthetic */ SignatureParameters val$parameters;
                final /* synthetic */ Signer val$signer;
                {
                    this.val$parameters = signatureParameters;
                    this.val$signer = signer;
                }

                @Override
                public T getParameters() {
                    return this.val$parameters;
                }

                @Override
                public UpdateOutputStream getVerifyingStream() {
                    return new SignerOutputStream(this.val$parameters.getAlgorithm().getName(), this.val$signer);
                }

                @Override
                public boolean isVerified(byte[] byArray) throws InvalidSignatureException {
                    try {
                        return this.val$signer.verifySignature(byArray);
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class RSASigner<P extends SignatureParameters>
        extends FipsOutputSignerUsingSecureRandom<P> {
            final Signer signer;
            private final CipherParameters keyParameters;
            private final P parameters;
            private final SecureRandom random;
            final /* synthetic */ SignatureOperatorFactory this$0;

            RSASigner(P p, CipherParameters cipherParameters, SecureRandom secureRandom) {
                this.this$0 = var1_1;
                this.parameters = p;
                this.keyParameters = cipherParameters;
                this.random = secureRandom;
                this.signer = p instanceof PKCS1v15SignatureParameters ? (((SignatureParameters)p).getDigestAlgorithm() == null ? new NullSigner() : new RsaDigestSigner((AsymmetricBlockCipher)ENGINE_PROVIDER.createEngine(), FipsSHS.createDigest(((SignatureParameters)p).getDigestAlgorithm()))) : (p instanceof PSSSignatureParameters ? FipsRSA.getPSSSigner((PSSSignatureParameters)p) : new X931Signer((AsymmetricBlockCipher)ENGINE_PROVIDER.createEngine(), FipsSHS.createDigest(((SignatureParameters)p).getDigestAlgorithm())));
            }

            @Override
            public P getParameters() {
                return this.parameters;
            }

            @Override
            public UpdateOutputStream getSigningStream() {
                if (this.random != null) {
                    this.signer.init(true, new ParametersWithRandom(this.keyParameters, this.random));
                } else {
                    this.signer.init(true, new ParametersWithRandom(this.keyParameters, CryptoServicesRegistrar.getSecureRandom()));
                }
                return new SignerOutputStream(((FipsParameters)this.parameters).getAlgorithm().getName(), this.signer);
            }

            @Override
            public byte[] getSignature() throws PlainInputProcessingException {
                try {
                    return this.signer.generateSignature();
                }
                catch (Exception exception) {
                    throw new PlainInputProcessingException("Unable to create signature: " + exception.getMessage(), exception);
                }
            }

            @Override
            public FipsOutputSignerUsingSecureRandom<P> withSecureRandom(SecureRandom secureRandom) {
                return new RSASigner(this.this$0, this.parameters, this.keyParameters, secureRandom);
            }

            @Override
            public int getSignature(byte[] byArray, int n) throws PlainInputProcessingException {
                byte[] byArray2 = this.getSignature();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
    }

    public static class SignatureParameters
    extends FipsParameters {
        private final FipsDigestAlgorithm digestAlgorithm;

        SignatureParameters(FipsAlgorithm fipsAlgorithm, FipsDigestAlgorithm fipsDigestAlgorithm) {
            super(fipsAlgorithm);
            if (fipsDigestAlgorithm == null && CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                PrivilegedUtils.checkPermission(Permissions.TlsNullDigestEnabled);
            }
            this.digestAlgorithm = fipsDigestAlgorithm;
        }

        public FipsDigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        PKCS1v1_5,
        PSS,
        X931,
        OAEP,
        SVE;

    }

    public static class WrapParameters
    extends FipsParameters {
        WrapParameters(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }
    }

    public static final class X931SignatureParameters
    extends SignatureParameters {
        X931SignatureParameters() {
            super(ALGORITHM_X931, FipsSHS.Algorithm.SHA1);
        }

        private X931SignatureParameters(FipsDigestAlgorithm fipsDigestAlgorithm) {
            super(ALGORITHM_X931, fipsDigestAlgorithm);
        }

        public X931SignatureParameters withDigestAlgorithm(FipsDigestAlgorithm fipsDigestAlgorithm) {
            return new X931SignatureParameters(fipsDigestAlgorithm);
        }
    }
}

