/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.wrappers;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapper;
import org.bouncycastle.util.Arrays;

public final class SP80038FWrapEngine
extends SP80038FWrapper {
    public SP80038FWrapEngine(BlockCipher blockCipher, boolean bl) {
        super(blockCipher, ivKW, bl);
    }

    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KW";
    }

    public byte[] wrap(byte[] byArray, int n, int n2) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n3 = n2 / this.delta;
        if (n3 * this.delta != n2) {
            throw new DataLengthException("wrap data must be a multiple of " + this.delta + " bytes");
        }
        byte[] byArray2 = new byte[n2 + this.iv.length];
        System.arraycopy(this.iv, 0, byArray2, 0, this.iv.length);
        System.arraycopy(byArray, n, byArray2, this.iv.length, n2);
        return this.W(n3, byArray2);
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n3 = n2 / this.delta;
        if (n3 * this.delta != n2) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of " + this.delta + " bytes");
        }
        byte[] byArray2 = new byte[n2 - this.iv.length];
        byte[] byArray3 = new byte[this.iv.length];
        System.arraycopy(byArray, n, byArray3, 0, this.iv.length);
        System.arraycopy(byArray, n + this.iv.length, byArray2, 0, n2 - this.iv.length);
        this.invW(n3, byArray2, byArray3);
        if (!Arrays.constantTimeAreEqual(byArray3, this.iv)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        return byArray2;
    }
}

