/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.transport.TransportAddress;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.extensions.ExtensionDependency;
import org.opensearch.plugins.PluginInfo;

public class DiscoveryExtensionNode
extends DiscoveryNode
implements Writeable,
ToXContentFragment {
    private final PluginInfo pluginInfo;
    private List<ExtensionDependency> dependencies = Collections.emptyList();

    public DiscoveryExtensionNode(String name, String id, String ephemeralId, String hostName, String hostAddress, TransportAddress address, Map<String, String> attributes, Version version, PluginInfo pluginInfo, List<ExtensionDependency> dependencies) {
        super(name, id, ephemeralId, hostName, hostAddress, address, attributes, DiscoveryNodeRole.BUILT_IN_ROLES, version);
        this.pluginInfo = pluginInfo;
        this.dependencies = dependencies;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.pluginInfo.writeTo(out);
        out.writeVInt(this.dependencies.size());
        for (ExtensionDependency dependency : this.dependencies) {
            dependency.writeTo(out);
        }
    }

    public DiscoveryExtensionNode(StreamInput in) throws IOException {
        super(in);
        this.pluginInfo = new PluginInfo(in);
        int size = in.readVInt();
        this.dependencies = new ArrayList<ExtensionDependency>(size);
        for (int i = 0; i < size; ++i) {
            this.dependencies.add(new ExtensionDependency(in));
        }
    }

    public List<ExtensionDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return null;
    }
}

