/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.WriteableSetting;
import org.opensearch.transport.TransportRequest;

public class UpdateSettingsRequest
extends TransportRequest {
    private static final Logger logger = LogManager.getLogger(UpdateSettingsRequest.class);
    private WriteableSetting.SettingType settingType;
    private Setting<?> componentSetting;
    private Object data;

    public UpdateSettingsRequest(WriteableSetting.SettingType settingType, Setting<?> componentSetting, Object data) {
        this.settingType = settingType;
        this.componentSetting = componentSetting;
        this.data = data;
    }

    public UpdateSettingsRequest(StreamInput in) throws IOException {
        super(in);
        this.settingType = in.readEnum(WriteableSetting.SettingType.class);
        this.componentSetting = new WriteableSetting(in).getSetting();
        this.data = in.readGenericValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum(this.settingType);
        new WriteableSetting(this.componentSetting).writeTo(out);
        out.writeGenericValue(this.data);
    }

    public WriteableSetting.SettingType getSettingType() {
        return this.settingType;
    }

    public Setting<?> getComponentSetting() {
        return this.componentSetting;
    }

    public Object getData() {
        return this.data;
    }

    public String toString() {
        return "UpdateSettingRequest{settingType=" + this.settingType.toString() + "componentSetting=" + this.componentSetting.toString() + ", data=" + this.data.toString() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateSettingsRequest that = (UpdateSettingsRequest)obj;
        return Objects.equals((Object)this.settingType, (Object)that.settingType) && Objects.equals(this.componentSetting, that.componentSetting) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.settingType, this.componentSetting, this.data});
    }
}

