/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.recovery.LocalStorePeerRecoverySourceHandler;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.recovery.RecoverySourceHandler;
import org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.opensearch.indices.recovery.RemoteStorePeerRecoverySourceHandler;
import org.opensearch.indices.recovery.StartRecoveryRequest;

public class RecoverySourceHandlerFactory {
    public static RecoverySourceHandler create(IndexShard shard, RecoveryTargetHandler recoveryTarget, StartRecoveryRequest request, RecoverySettings recoverySettings) {
        boolean isReplicaRecoveryWithRemoteTranslog;
        boolean bl = isReplicaRecoveryWithRemoteTranslog = !request.isPrimaryRelocation() && shard.isRemoteTranslogEnabled();
        if (isReplicaRecoveryWithRemoteTranslog) {
            return new RemoteStorePeerRecoverySourceHandler(shard, recoveryTarget, shard.getThreadPool(), request, Math.toIntExact(recoverySettings.getChunkSize().getBytes()), recoverySettings.getMaxConcurrentFileChunks(), recoverySettings.getMaxConcurrentOperations());
        }
        return new LocalStorePeerRecoverySourceHandler(shard, recoveryTarget, shard.getThreadPool(), request, Math.toIntExact(recoverySettings.getChunkSize().getBytes()), recoverySettings.getMaxConcurrentFileChunks(), recoverySettings.getMaxConcurrentOperations());
    }
}

