/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.xcontent.ObjectParser;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.bucket.terms.ParsedTerms;

public class ParsedMultiTerms
extends ParsedTerms {
    private static final ObjectParser<ParsedMultiTerms, Void> PARSER = new ObjectParser(ParsedMultiTerms.class.getSimpleName(), true, ParsedMultiTerms::new);

    @Override
    public String getType() {
        return "multi_terms";
    }

    public static ParsedMultiTerms fromXContent(XContentParser parser, String name) throws IOException {
        ParsedMultiTerms aggregation = (ParsedMultiTerms)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedMultiTerms.declareParsedTermsFields(PARSER, (CheckedFunction<XContentParser, ParsedTerms.ParsedBucket, IOException>)((CheckedFunction)ParsedBucket::fromXContent));
    }

    public static class ParsedBucket
    extends ParsedTerms.ParsedBucket {
        private List<Object> key;

        @Override
        public List<Object> getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            if (this.key != null) {
                return this.key.toString();
            }
            return null;
        }

        @Override
        public Number getKeyAsNumber() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            if (super.getKeyAsString() != null) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.getKeyAsString());
            }
            return builder;
        }

        static ParsedBucket fromXContent(XContentParser parser) throws IOException {
            return ParsedBucket.parseTermsBucketXContent(parser, ParsedBucket::new, (p, bucket) -> {
                bucket.key = p.list();
            });
        }
    }
}

