/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.common.Strings;
import org.opensearch.common.ValidationException;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexNotFoundException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ.\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/replication/util/ValidationUtil;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "validateAnalyzerSettings", "", "environment", "Lorg/opensearch/env/Environment;", "leaderSettings", "Lorg/opensearch/common/settings/Settings;", "overriddenSettings", "validateIndexSettings", "followerIndex", "", "metadataCreateIndexService", "Lorg/opensearch/cluster/metadata/MetadataCreateIndexService;", "validateLeaderIndexMetadata", "leaderIndexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "validateLeaderIndexState", "leaderAlias", "leaderIndex", "leaderClusterState", "Lorg/opensearch/cluster/ClusterState;", "validateName", "name", "validationException", "Lorg/opensearch/common/ValidationException;", "opensearch-cross-cluster-replication"})
public final class ValidationUtil {
    @NotNull
    public static final ValidationUtil INSTANCE = new ValidationUtil();
    private static final Logger log = LogManager.getLogger(ValidationUtil.class);

    private ValidationUtil() {
    }

    public final void validateIndexSettings(@NotNull Environment environment, @NotNull String followerIndex, @NotNull Settings leaderSettings, @NotNull Settings overriddenSettings, @NotNull MetadataCreateIndexService metadataCreateIndexService) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)followerIndex, (String)"followerIndex");
        Intrinsics.checkNotNullParameter((Object)leaderSettings, (String)"leaderSettings");
        Intrinsics.checkNotNullParameter((Object)overriddenSettings, (String)"overriddenSettings");
        Intrinsics.checkNotNullParameter((Object)metadataCreateIndexService, (String)"metadataCreateIndexService");
        Settings[] settingsArray = new Settings[]{leaderSettings, overriddenSettings};
        Settings[] settingsList = settingsArray;
        Settings.Builder desiredSettingsBuilder = Settings.builder();
        int n = 0;
        int n2 = settingsList.length;
        while (n < n2) {
            Settings settings = settingsList[n];
            ++n;
            for (String key : settings.keySet()) {
                desiredSettingsBuilder.copy(key, settings);
            }
        }
        Settings desiredSettings = desiredSettingsBuilder.build();
        metadataCreateIndexService.validateIndexSettings(followerIndex, desiredSettings, false);
        this.validateAnalyzerSettings(environment, leaderSettings, overriddenSettings);
    }

    public final void validateAnalyzerSettings(@NotNull Environment environment, @NotNull Settings leaderSettings, @NotNull Settings overriddenSettings) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)leaderSettings, (String)"leaderSettings");
        Intrinsics.checkNotNullParameter((Object)overriddenSettings, (String)"overriddenSettings");
        Settings analyserSettings = leaderSettings.filter(ValidationUtil::validateAnalyzerSettings$lambda-0);
        for (String analyserSetting : analyserSettings.keySet()) {
            String settingValue = overriddenSettings.hasValue(analyserSetting) ? overriddenSettings.get(analyserSetting) : analyserSettings.get(analyserSetting);
            Path path = environment.configFile().resolve(settingValue);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"environment.configFile().resolve(settingValue)");
            Path path2 = path;
            if (Files.exists(path2, new LinkOption[0])) continue;
            String message = "IOException while reading " + analyserSetting + ": " + path2;
            log.error(message);
            throw new ResourceNotFoundException(message, new Object[0]);
        }
    }

    public final void validateName(@NotNull String name, @NotNull ValidationException validationException) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)validationException, (String)"validationException");
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        Object object = name.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).toLowerCase(locale)");
        if (!Intrinsics.areEqual((Object)object, (Object)name)) {
            validationException.addValidationError("Value " + name + " must be lowercase");
        }
        if (!Strings.validFileName((String)name)) {
            validationException.addValidationError("Value " + name + " must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"#", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)":", (boolean)false, (int)2, null)) {
            validationException.addValidationError("Value " + name + " must not contain '#' or ':'");
        }
        if (Intrinsics.areEqual((Object)name, (Object)".") || Intrinsics.areEqual((Object)name, (Object)"..")) {
            validationException.addValidationError("Value " + name + " must not be '.' or '..'");
        }
        if (StringsKt.startsWith$default((CharSequence)name, (char)'_', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)name, (char)'-', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)name, (char)'+', (boolean)false, (int)2, null)) {
            validationException.addValidationError("Value " + name + " must not start with '_' or '-' or '+'");
        }
        try {
            object = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forName(charsetName)");
            object = name.getBytes((Charset)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).getBytes(charset)");
            int byteCount = ((Object)object).length;
            if (byteCount > 255) {
                validationException.addValidationError("Value " + name + " must not be longer than 255 bytes");
            }
        }
        catch (UnsupportedEncodingException e) {
            validationException.addValidationError(Intrinsics.stringPlus((String)"Unable to determine length of ", (Object)name));
        }
        if (StringsKt.startsWith$default((String)name, (String)".", (boolean)false, (int)2, null)) {
            validationException.addValidationError("Value " + name + " must not start with '.'");
        }
    }

    private final void validateLeaderIndexMetadata(IndexMetadata leaderIndexMetadata) {
        if (Version.CURRENT.before(leaderIndexMetadata.getCreationVersion())) {
            String err = "Leader index[" + leaderIndexMetadata.getIndex().getName() + "] is on higher version [" + leaderIndexMetadata.getCreationVersion() + "] than follower [" + Version.CURRENT + ']';
            log.error(err);
            throw new IllegalArgumentException(err);
        }
        if (Version.CURRENT.before(leaderIndexMetadata.getUpgradedVersion())) {
            String err = "Leader index[" + leaderIndexMetadata.getIndex().getName() + "] is upgraded with higher version [" + leaderIndexMetadata.getUpgradedVersion() + "] than follower [" + Version.CURRENT + ']';
            log.error(err);
            throw new IllegalArgumentException(err);
        }
    }

    public final void validateLeaderIndexState(@NotNull String leaderAlias, @NotNull String leaderIndex, @NotNull ClusterState leaderClusterState) {
        Intrinsics.checkNotNullParameter((Object)leaderAlias, (String)"leaderAlias");
        Intrinsics.checkNotNullParameter((Object)leaderIndex, (String)"leaderIndex");
        Intrinsics.checkNotNullParameter((Object)leaderClusterState, (String)"leaderClusterState");
        IndexMetadata indexMetadata = leaderClusterState.getMetadata().index(leaderIndex);
        if (indexMetadata == null) {
            throw new IndexNotFoundException(leaderAlias + ':' + leaderIndex);
        }
        IndexMetadata leaderIndexMetadata = indexMetadata;
        this.validateLeaderIndexMetadata(leaderIndexMetadata);
        if (!leaderClusterState.getRoutingTable().index(leaderIndex).allPrimaryShardsActive()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("Primary shards in the Index[" + leaderAlias + ':' + leaderIndex + "] are not active");
            throw validationException;
        }
    }

    private static final boolean validateAnalyzerSettings$lambda-0(String k) {
        String string = k;
        Intrinsics.checkNotNull((Object)string);
        CharSequence charSequence = string;
        return new Regex("index.analysis.*path").matches(charSequence);
    }
}

