"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportsDashboardsPlugin = void 0;

var _asyncMutex = require("async-mutex");

var _opensearchReportsPlugin = _interopRequireDefault(require("./backend/opensearch-reports-plugin"));

var _routes = _interopRequireDefault(require("./routes"));

var _notificationsPlugin = require("./clusters/notificationsPlugin");

var _config = require("./config");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReportsDashboardsPlugin {
  constructor(context) {
    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "semaphore", void 0);

    _defineProperty(this, "initializerContext", void 0);

    _defineProperty(this, "reportingConfig", void 0);

    this.logger = context.logger.get();
    this.initializerContext = context;
    const timeoutError = new Error('Server busy');
    timeoutError.statusCode = 503;
    this.semaphore = (0, _asyncMutex.withTimeout)(new _asyncMutex.Semaphore(1), 300000, timeoutError);
  }

  async setup(core) {
    this.logger.debug('reports-dashboards: Setup');

    try {
      const config = await (0, _config.buildConfig)(this.initializerContext, core, this.logger);
      this.reportingConfig = config;
      this.logger.debug('Setup complete');
    } catch (error) {
      this.logger.error(`Error in Reporting setup, reporting may not function properly`);
      this.logger.error(error);
    }

    if (!this.reportingConfig) {
      throw new Error('Reporting Config is not initialized');
    }

    const router = core.http.createRouter(); // Deprecated API. Switch to the new opensearch client as soon as https://github.com/elastic/kibana/issues/35508 done.

    const opensearchReportsClient = core.opensearch.legacy.createClient('opensearch_reports', {
      plugins: [_opensearchReportsPlugin.default, _notificationsPlugin.NotificationsPlugin]
    });
    const notificationsClient = core.opensearch.legacy.createClient('opensearch_notifications', {
      plugins: [_notificationsPlugin.NotificationsPlugin]
    }); // Register server side APIs

    (0, _routes.default)(router, this.reportingConfig); // put logger into route handler context, so that we don't need to pass through parameters

    core.http.registerRouteHandlerContext( //@ts-ignore
    'reporting_plugin', (context, request) => {
      return {
        logger: this.logger,
        semaphore: this.semaphore,
        opensearchReportsClient,
        notificationsClient
      };
    });
    return {};
  }

  start(core) {
    this.logger.debug('reports-dashboards: Started');
    return {};
  }

  stop() {}

}

exports.ReportsDashboardsPlugin = ReportsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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