/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AddressFamily;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.IpamPoolAwsService;
import com.amazonaws.services.ec2.model.RequestIpamResourceTag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateIpamPoolRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateIpamPoolRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateIpamPoolRequest> {
    private String ipamScopeId;
    private String locale;
    private String sourceIpamPoolId;
    private String description;
    private String addressFamily;
    private Boolean autoImport;
    private Boolean publiclyAdvertisable;
    private Integer allocationMinNetmaskLength;
    private Integer allocationMaxNetmaskLength;
    private Integer allocationDefaultNetmaskLength;
    private SdkInternalList<RequestIpamResourceTag> allocationResourceTags;
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String clientToken;
    private String awsService;

    public void setIpamScopeId(String ipamScopeId) {
        this.ipamScopeId = ipamScopeId;
    }

    public String getIpamScopeId() {
        return this.ipamScopeId;
    }

    public CreateIpamPoolRequest withIpamScopeId(String ipamScopeId) {
        this.setIpamScopeId(ipamScopeId);
        return this;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }

    public CreateIpamPoolRequest withLocale(String locale) {
        this.setLocale(locale);
        return this;
    }

    public void setSourceIpamPoolId(String sourceIpamPoolId) {
        this.sourceIpamPoolId = sourceIpamPoolId;
    }

    public String getSourceIpamPoolId() {
        return this.sourceIpamPoolId;
    }

    public CreateIpamPoolRequest withSourceIpamPoolId(String sourceIpamPoolId) {
        this.setSourceIpamPoolId(sourceIpamPoolId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateIpamPoolRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setAddressFamily(String addressFamily) {
        this.addressFamily = addressFamily;
    }

    public String getAddressFamily() {
        return this.addressFamily;
    }

    public CreateIpamPoolRequest withAddressFamily(String addressFamily) {
        this.setAddressFamily(addressFamily);
        return this;
    }

    public CreateIpamPoolRequest withAddressFamily(AddressFamily addressFamily) {
        this.addressFamily = addressFamily.toString();
        return this;
    }

    public void setAutoImport(Boolean autoImport) {
        this.autoImport = autoImport;
    }

    public Boolean getAutoImport() {
        return this.autoImport;
    }

    public CreateIpamPoolRequest withAutoImport(Boolean autoImport) {
        this.setAutoImport(autoImport);
        return this;
    }

    public Boolean isAutoImport() {
        return this.autoImport;
    }

    public void setPubliclyAdvertisable(Boolean publiclyAdvertisable) {
        this.publiclyAdvertisable = publiclyAdvertisable;
    }

    public Boolean getPubliclyAdvertisable() {
        return this.publiclyAdvertisable;
    }

    public CreateIpamPoolRequest withPubliclyAdvertisable(Boolean publiclyAdvertisable) {
        this.setPubliclyAdvertisable(publiclyAdvertisable);
        return this;
    }

    public Boolean isPubliclyAdvertisable() {
        return this.publiclyAdvertisable;
    }

    public void setAllocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
        this.allocationMinNetmaskLength = allocationMinNetmaskLength;
    }

    public Integer getAllocationMinNetmaskLength() {
        return this.allocationMinNetmaskLength;
    }

    public CreateIpamPoolRequest withAllocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
        this.setAllocationMinNetmaskLength(allocationMinNetmaskLength);
        return this;
    }

    public void setAllocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
        this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
    }

    public Integer getAllocationMaxNetmaskLength() {
        return this.allocationMaxNetmaskLength;
    }

    public CreateIpamPoolRequest withAllocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
        this.setAllocationMaxNetmaskLength(allocationMaxNetmaskLength);
        return this;
    }

    public void setAllocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
        this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
    }

    public Integer getAllocationDefaultNetmaskLength() {
        return this.allocationDefaultNetmaskLength;
    }

    public CreateIpamPoolRequest withAllocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
        this.setAllocationDefaultNetmaskLength(allocationDefaultNetmaskLength);
        return this;
    }

    public List<RequestIpamResourceTag> getAllocationResourceTags() {
        if (this.allocationResourceTags == null) {
            this.allocationResourceTags = new SdkInternalList();
        }
        return this.allocationResourceTags;
    }

    public void setAllocationResourceTags(Collection<RequestIpamResourceTag> allocationResourceTags) {
        if (allocationResourceTags == null) {
            this.allocationResourceTags = null;
            return;
        }
        this.allocationResourceTags = new SdkInternalList(allocationResourceTags);
    }

    public CreateIpamPoolRequest withAllocationResourceTags(RequestIpamResourceTag ... allocationResourceTags) {
        if (this.allocationResourceTags == null) {
            this.setAllocationResourceTags((Collection<RequestIpamResourceTag>)new SdkInternalList(allocationResourceTags.length));
        }
        for (RequestIpamResourceTag ele : allocationResourceTags) {
            this.allocationResourceTags.add((Object)ele);
        }
        return this;
    }

    public CreateIpamPoolRequest withAllocationResourceTags(Collection<RequestIpamResourceTag> allocationResourceTags) {
        this.setAllocationResourceTags(allocationResourceTags);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateIpamPoolRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateIpamPoolRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateIpamPoolRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setAwsService(String awsService) {
        this.awsService = awsService;
    }

    public String getAwsService() {
        return this.awsService;
    }

    public CreateIpamPoolRequest withAwsService(String awsService) {
        this.setAwsService(awsService);
        return this;
    }

    public CreateIpamPoolRequest withAwsService(IpamPoolAwsService awsService) {
        this.awsService = awsService.toString();
        return this;
    }

    @Override
    public Request<CreateIpamPoolRequest> getDryRunRequest() {
        Request<CreateIpamPoolRequest> request = new CreateIpamPoolRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIpamScopeId() != null) {
            sb.append("IpamScopeId: ").append(this.getIpamScopeId()).append(",");
        }
        if (this.getLocale() != null) {
            sb.append("Locale: ").append(this.getLocale()).append(",");
        }
        if (this.getSourceIpamPoolId() != null) {
            sb.append("SourceIpamPoolId: ").append(this.getSourceIpamPoolId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getAddressFamily() != null) {
            sb.append("AddressFamily: ").append(this.getAddressFamily()).append(",");
        }
        if (this.getAutoImport() != null) {
            sb.append("AutoImport: ").append(this.getAutoImport()).append(",");
        }
        if (this.getPubliclyAdvertisable() != null) {
            sb.append("PubliclyAdvertisable: ").append(this.getPubliclyAdvertisable()).append(",");
        }
        if (this.getAllocationMinNetmaskLength() != null) {
            sb.append("AllocationMinNetmaskLength: ").append(this.getAllocationMinNetmaskLength()).append(",");
        }
        if (this.getAllocationMaxNetmaskLength() != null) {
            sb.append("AllocationMaxNetmaskLength: ").append(this.getAllocationMaxNetmaskLength()).append(",");
        }
        if (this.getAllocationDefaultNetmaskLength() != null) {
            sb.append("AllocationDefaultNetmaskLength: ").append(this.getAllocationDefaultNetmaskLength()).append(",");
        }
        if (this.getAllocationResourceTags() != null) {
            sb.append("AllocationResourceTags: ").append(this.getAllocationResourceTags()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getAwsService() != null) {
            sb.append("AwsService: ").append(this.getAwsService());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamPoolRequest)) {
            return false;
        }
        CreateIpamPoolRequest other = (CreateIpamPoolRequest)obj;
        if (other.getIpamScopeId() == null ^ this.getIpamScopeId() == null) {
            return false;
        }
        if (other.getIpamScopeId() != null && !other.getIpamScopeId().equals(this.getIpamScopeId())) {
            return false;
        }
        if (other.getLocale() == null ^ this.getLocale() == null) {
            return false;
        }
        if (other.getLocale() != null && !other.getLocale().equals(this.getLocale())) {
            return false;
        }
        if (other.getSourceIpamPoolId() == null ^ this.getSourceIpamPoolId() == null) {
            return false;
        }
        if (other.getSourceIpamPoolId() != null && !other.getSourceIpamPoolId().equals(this.getSourceIpamPoolId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getAddressFamily() == null ^ this.getAddressFamily() == null) {
            return false;
        }
        if (other.getAddressFamily() != null && !other.getAddressFamily().equals(this.getAddressFamily())) {
            return false;
        }
        if (other.getAutoImport() == null ^ this.getAutoImport() == null) {
            return false;
        }
        if (other.getAutoImport() != null && !other.getAutoImport().equals(this.getAutoImport())) {
            return false;
        }
        if (other.getPubliclyAdvertisable() == null ^ this.getPubliclyAdvertisable() == null) {
            return false;
        }
        if (other.getPubliclyAdvertisable() != null && !other.getPubliclyAdvertisable().equals(this.getPubliclyAdvertisable())) {
            return false;
        }
        if (other.getAllocationMinNetmaskLength() == null ^ this.getAllocationMinNetmaskLength() == null) {
            return false;
        }
        if (other.getAllocationMinNetmaskLength() != null && !other.getAllocationMinNetmaskLength().equals(this.getAllocationMinNetmaskLength())) {
            return false;
        }
        if (other.getAllocationMaxNetmaskLength() == null ^ this.getAllocationMaxNetmaskLength() == null) {
            return false;
        }
        if (other.getAllocationMaxNetmaskLength() != null && !other.getAllocationMaxNetmaskLength().equals(this.getAllocationMaxNetmaskLength())) {
            return false;
        }
        if (other.getAllocationDefaultNetmaskLength() == null ^ this.getAllocationDefaultNetmaskLength() == null) {
            return false;
        }
        if (other.getAllocationDefaultNetmaskLength() != null && !other.getAllocationDefaultNetmaskLength().equals(this.getAllocationDefaultNetmaskLength())) {
            return false;
        }
        if (other.getAllocationResourceTags() == null ^ this.getAllocationResourceTags() == null) {
            return false;
        }
        if (other.getAllocationResourceTags() != null && !other.getAllocationResourceTags().equals(this.getAllocationResourceTags())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getAwsService() == null ^ this.getAwsService() == null) {
            return false;
        }
        return other.getAwsService() == null || other.getAwsService().equals(this.getAwsService());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIpamScopeId() == null ? 0 : this.getIpamScopeId().hashCode());
        hashCode = 31 * hashCode + (this.getLocale() == null ? 0 : this.getLocale().hashCode());
        hashCode = 31 * hashCode + (this.getSourceIpamPoolId() == null ? 0 : this.getSourceIpamPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getAddressFamily() == null ? 0 : this.getAddressFamily().hashCode());
        hashCode = 31 * hashCode + (this.getAutoImport() == null ? 0 : this.getAutoImport().hashCode());
        hashCode = 31 * hashCode + (this.getPubliclyAdvertisable() == null ? 0 : this.getPubliclyAdvertisable().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationMinNetmaskLength() == null ? 0 : this.getAllocationMinNetmaskLength().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationMaxNetmaskLength() == null ? 0 : this.getAllocationMaxNetmaskLength().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationDefaultNetmaskLength() == null ? 0 : this.getAllocationDefaultNetmaskLength().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationResourceTags() == null ? 0 : this.getAllocationResourceTags().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getAwsService() == null ? 0 : this.getAwsService().hashCode());
        return hashCode;
    }

    public CreateIpamPoolRequest clone() {
        return (CreateIpamPoolRequest)super.clone();
    }
}

