/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.DnsEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DnsEntryStaxUnmarshaller
implements Unmarshaller<DnsEntry, StaxUnmarshallerContext> {
    private static DnsEntryStaxUnmarshaller instance;

    public DnsEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        DnsEntry dnsEntry = new DnsEntry();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dnsEntry;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("dnsName", targetDepth)) {
                    dnsEntry.setDnsName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("hostedZoneId", targetDepth)) continue;
                dnsEntry.setHostedZoneId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dnsEntry;
    }

    public static DnsEntryStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DnsEntryStaxUnmarshaller();
        }
        return instance;
    }
}

