/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyVpcAttributeRequestMarshaller
implements Marshaller<Request<ModifyVpcAttributeRequest>, ModifyVpcAttributeRequest> {
    public Request<ModifyVpcAttributeRequest> marshall(ModifyVpcAttributeRequest modifyVpcAttributeRequest) {
        if (modifyVpcAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVpcAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcAttributeRequest.getEnableDnsHostnames() != null) {
            request.addParameter("EnableDnsHostnames.Value", StringUtils.fromBoolean((Boolean)modifyVpcAttributeRequest.getEnableDnsHostnames()));
        }
        if (modifyVpcAttributeRequest.getEnableDnsSupport() != null) {
            request.addParameter("EnableDnsSupport.Value", StringUtils.fromBoolean((Boolean)modifyVpcAttributeRequest.getEnableDnsSupport()));
        }
        if (modifyVpcAttributeRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)modifyVpcAttributeRequest.getVpcId()));
        }
        return request;
    }
}

