/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import com.healthmarketscience.jackcess.Database;
import java.io.File;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import net.ucanaccess.commands.CompositeCommand;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.ICursorCommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.Context;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.FeatureNotSupportedException;
import net.ucanaccess.jdbc.NormalizedSQL;
import net.ucanaccess.jdbc.Session;
import net.ucanaccess.jdbc.UcanaccessBlob;
import net.ucanaccess.jdbc.UcanaccessCallableStatement;
import net.ucanaccess.jdbc.UcanaccessDatabaseMetadata;
import net.ucanaccess.jdbc.UcanaccessDriver;
import net.ucanaccess.jdbc.UcanaccessPreparedStatement;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.jdbc.UcanaccessSavepoint;
import net.ucanaccess.jdbc.UcanaccessStatement;
import net.ucanaccess.util.Logger;
import org.hsqldb.jdbc.JDBCConnection;

public class UcanaccessConnection
implements Connection {
    private static ThreadLocal<Context> ctx = new ThreadLocal();
    private boolean feedbackState;
    private LinkedList<ICommand> commands = new LinkedList();
    private Connection hsqlDBConnection;
    private Map<Savepoint, String> savepointsMap = new HashMap<Savepoint, String>();
    private DBReference ref;
    private boolean checkModified = false;
    private boolean autoCommit = true;
    private Properties clientInfo;
    private boolean testRollback;
    private Session session;
    private SQLWarning warnings;
    private String url;
    private UcanaccessStatement currentStatement;
    private Object lastGeneratedKey;
    private String refId;
    static final String BATCH_ID = "BATCH_ID";

    public static synchronized UcanaccessConnection getCtxConnection() {
        if (ctx == null) {
            return null;
        }
        return ctx.get().getCurrentConnection();
    }

    public static synchronized boolean hasContext() {
        return ctx.get() != null;
    }

    public static synchronized String getCtxExcId() {
        return ctx.get().getCurrentExecId();
    }

    public static synchronized void setCtxConnection(UcanaccessConnection conn) {
        ctx.set(new Context(conn));
    }

    public static synchronized void setCtxExecId(String id) {
        ctx.get().setCurrentExecId(id);
    }

    public UcanaccessConnection(DBReference _ref, Properties _clientInfo, Session _session) throws UcanaccessSQLException {
        try {
            this.ref = _ref;
            this.refId = _ref.getId();
            _ref.incrementActiveConnection();
            this.session = _session;
            this.hsqlDBConnection = _ref.getHSQLDBConnection(_session);
            this.clientInfo = _clientInfo;
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    Object getLastGeneratedKey() {
        return this.lastGeneratedKey;
    }

    String preprocess(String sql) {
        if (SQLConverter.hasIdentity(sql)) {
            return SQLConverter.preprocess(sql, this.lastGeneratedKey);
        }
        return sql;
    }

    void setCurrentStatement(UcanaccessStatement _currentStatement) {
        this.currentStatement = _currentStatement;
    }

    public void setGeneratedKey(Object key) {
        this.lastGeneratedKey = key;
        if (this.currentStatement != null) {
            this.currentStatement.setGeneratedKey(key);
        }
    }

    public boolean isTestRollback() {
        return this.testRollback;
    }

    private void setTestRollback(boolean _testRollback) {
        this.testRollback = _testRollback;
    }

    public void addFunctions(Class<?> clazz) throws SQLException {
        LoadJet lfa = new LoadJet(this.ref.getHSQLDBConnection(this.session), this.ref.getDbIO());
        lfa.addFunctions(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadDbIO() throws IOException {
        Class<UcanaccessConnection> clazz = UcanaccessConnection.class;
        synchronized (UcanaccessConnection.class) {
            this.ref.reloadDbIO();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized boolean add(ICommand c4io) {
        if (c4io.getType().equals((Object)ICommand.TYPES.UPDATE) || c4io.getType().equals((Object)ICommand.TYPES.DELETE)) {
            ICommand last = this.commands.size() > 0 ? this.commands.getLast() : null;
            ICursorCommand c4ioc = (ICursorCommand)c4io;
            if (last != null && !last.getExecId().equals(BATCH_ID) && last.getExecId().equals(c4io.getExecId()) && last.getTableName().equals(c4io.getTableName())) {
                return ((CompositeCommand)last).add(c4ioc);
            }
            CompositeCommand cc4io = new CompositeCommand();
            cc4io.add(c4ioc);
            c4io = cc4io;
        }
        return this.commands.add(c4io);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.hsqlDBConnection.close();
            this.ref.decrementActiveConnection(this.session);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            try {
                if (this.isReadOnly() && this.commands.size() > 0) {
                    this.rollback();
                    if (this.ref.isReadOnlyFileFormat()) {
                        throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.ACCESS_97);
                    }
                    throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.CONCURRENT_PROCESS_ACCESS);
                }
                this.flushIO();
                this.hsqlDBConnection.commit();
                if (this.commands.size() > 0) {
                    this.ref.updateLastModified();
                }
            }
            catch (SQLException e) {
                throw new UcanaccessSQLException(e);
            }
            finally {
                this.finalizeEnlistedResources();
                this.checkModified = true;
            }
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            this.checkConnection();
            return this.hsqlDBConnection.createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            this.checkConnection();
            return new UcanaccessBlob(UcanaccessBlob.createBlob(this), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public Blob createBlob(File fl) throws SQLException {
        try {
            this.checkConnection();
            return new UcanaccessBlob(UcanaccessBlob.createBlob(fl, this), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    private void checkConnection() throws UcanaccessSQLException {
        if (this.autoCommit || this.isCheckModified()) {
            this.checkLastModified();
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new FeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new FeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new FeatureNotSupportedException();
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            this.checkConnection();
            return new UcanaccessStatement(this.hsqlDBConnection.createStatement(), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkConnection();
            return new UcanaccessStatement(this.hsqlDBConnection.createStatement(resultSetType, resultSetConcurrency), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkConnection();
            return new UcanaccessStatement(this.hsqlDBConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            this.checkConnection();
            return this.hsqlDBConnection.createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    private void flushIO() throws SQLException {
        ArrayList<IFeedbackAction> ibal = new ArrayList<IFeedbackAction>();
        LinkedList<ICommand> executed = new LinkedList<ICommand>();
        try {
            for (ICommand command : this.commands) {
                for (IFeedbackAction iFeedbackAction : ibal) {
                    iFeedbackAction.doAction(command);
                }
                IFeedbackAction ib = command.persist();
                executed.add(command);
                if (ib == null) continue;
                if (command instanceof CompositeCommand) {
                    ib.doAction(command);
                    continue;
                }
                ibal.add(ib);
            }
            if (this.testRollback) {
                throw new RuntimeException("PhysicalRollbackTest");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.hsqlDBConnection.rollback();
            ibal.clear();
            Iterator it = executed.descendingIterator();
            while (it.hasNext()) {
                ICommand command = (ICommand)it.next();
                for (IFeedbackAction iFeedbackAction : ibal) {
                    iFeedbackAction.doAction(command);
                }
                IFeedbackAction iFeedbackAction = command.rollback();
                if (iFeedbackAction == null) continue;
                ibal.add(iFeedbackAction);
            }
            this.ref.updateLastModified();
            try {
                this.ref.getDbIO().flush();
                this.unloadDB();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw new UcanaccessSQLException(t);
        }
        try {
            this.ref.getDbIO().flush();
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    private void finalizeEnlistedResources() {
        this.commands.clear();
        this.savepointsMap.clear();
        UcanaccessConnection.setCtxConnection(null);
        UcanaccessConnection.setCtxExecId(null);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.hsqlDBConnection.getCatalog();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.getProperty(name);
    }

    public Database getDbIO() {
        return this.ref.getDbIO();
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.hsqlDBConnection.getHoldability();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public Connection getHSQLDBConnection() {
        return this.hsqlDBConnection;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return new UcanaccessDatabaseMetadata(this.hsqlDBConnection.getMetaData(), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.hsqlDBConnection.getTransactionIsolation();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.hsqlDBConnection.getTypeMap();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void setWarnings(SQLWarning _warnings) {
        this.warnings = _warnings;
    }

    public void addWarnings(SQLWarning _warnings) {
        if (this.warnings == null) {
            this.setWarnings(_warnings);
        } else {
            this.warnings.setNextWarning(_warnings);
        }
    }

    public boolean isFeedbackState() {
        return this.feedbackState;
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.hsqlDBConnection.isClosed();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.ref.isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            return this.hsqlDBConnection.isValid(timeout);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        try {
            return this.hsqlDBConnection.isWrapperFor(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return SQLConverter.convertSQL(sql).getSql();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessCallableStatement(nsql, this.hsqlDBConnection.prepareCall(sql), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessCallableStatement(nsql, this.hsqlDBConnection.prepareCall(sql, resultSetType, resultSetConcurrency), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessCallableStatement(nsql, this.hsqlDBConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    private NormalizedSQL prepare(String sql) throws SQLException {
        this.checkConnection();
        return SQLConverter.convertSQL(sql, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            if (SQLConverter.checkDDL(sql)) {
                Logger.log((Object)Logger.Messages.STATEMENT_DDL);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql())), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (SQLConverter.checkDDL(sql)) {
                Logger.log((Object)Logger.Messages.STATEMENT_DDL);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql()), autoGeneratedKeys), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String oldSql = sql;
        try {
            if (SQLConverter.checkDDL(sql)) {
                Logger.log((Object)Logger.Messages.STATEMENT_DDL);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql()), resultSetType, resultSetConcurrency), this);
        }
        catch (SQLException _ex) {
            if (resultSetType == 1005 && resultSetConcurrency == 1008) {
                return this.prepareStatement(oldSql, 1003, 1007);
            }
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (SQLConverter.checkDDL(sql)) {
                Logger.log((Object)Logger.Messages.STATEMENT_DDL);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql()), resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (SQLConverter.checkDDL(sql)) {
                Logger.log((Object)Logger.Messages.STATEMENT_DDL);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql()), columnIndexes), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            if (SQLConverter.checkDDL(sql)) {
                Logger.log((Object)Logger.Messages.STATEMENT_DDL);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql()), columnNames), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.hsqlDBConnection.releaseSavepoint(((UcanaccessSavepoint)savepoint).getWrapped());
            this.savepointsMap.remove(savepoint);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.hsqlDBConnection.rollback();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
        finally {
            this.finalizeEnlistedResources();
            this.checkModified = true;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.hsqlDBConnection.rollback(((UcanaccessSavepoint)savepoint).getWrapped());
            String lastId = this.savepointsMap.get(savepoint);
            boolean remove = false;
            Iterator it = this.commands.iterator();
            while (it.hasNext()) {
                ICommand c4io = (ICommand)it.next();
                if (remove && !c4io.getExecId().equals(lastId)) {
                    it.remove();
                }
                remove = remove || c4io.getExecId().equals(lastId);
            }
            this.checkModified = true;
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setAutoCommit(boolean _autoCommit) throws SQLException {
        if (!_autoCommit) {
            this.checkLastModified();
        } else {
            this.checkModified = false;
        }
        this.autoCommit = _autoCommit;
    }

    public void setFeedbackState(boolean _feedbackState) {
        this.feedbackState = _feedbackState;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.hsqlDBConnection.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.hsqlDBConnection.setClientInfo(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            this.hsqlDBConnection.setHoldability(holdability);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.hsqlDBConnection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            UcanaccessSavepoint sp = new UcanaccessSavepoint(this.hsqlDBConnection.setSavepoint());
            if (this.commands.size() > 0) {
                this.savepointsMap.put(sp, this.commands.getLast().getExecId());
            }
            return sp;
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            UcanaccessSavepoint sp = new UcanaccessSavepoint(this.hsqlDBConnection.setSavepoint(name));
            if (this.commands.size() > 0) {
                this.savepointsMap.put(sp, this.commands.getLast().getExecId());
            }
            return sp;
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.hsqlDBConnection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.hsqlDBConnection.setTypeMap(map);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        try {
            return this.hsqlDBConnection.unwrap(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.ref.getDbFile() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkLastModified() throws UcanaccessSQLException {
        try {
            this.checkModified = false;
            if (!this.refId.equals(this.ref.getId())) {
                this.hsqlDBConnection = this.ref.getHSQLDBConnection(this.session);
            }
            Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
            synchronized (UcanaccessDriver.class) {
                this.hsqlDBConnection = this.ref.checkLastModified(this.hsqlDBConnection, this.session);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.refId = this.ref.getId();
            }
        }
        catch (Exception e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String _url) {
        this.url = _url;
    }

    public boolean isShowSchema() {
        return this.ref.isShowSchema();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadDB() throws UcanaccessSQLException {
        try {
            Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
            synchronized (UcanaccessDriver.class) {
                this.ref.shutdown(this.session);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            throw new UcanaccessSQLException(e);
        }
        {
            return;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            ((JDBCConnection)this.hsqlDBConnection).abort(executor);
        }
        catch (Exception e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    public boolean isCheckModified() {
        return this.checkModified;
    }
}

