/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import us.fatehi.utility.graph.DirectedGraph;
import us.fatehi.utility.graph.TarjanStronglyConnectedComponentFinder;

public class LinterTableCycles
extends BaseLinter {
    private DirectedGraph<Table> tablesGraph;

    @Override
    public String getSummary() {
        return "cycles in table relationships";
    }

    @Override
    protected void end(Connection connection) {
        Objects.requireNonNull(this.tablesGraph, "Not initialized");
        Collection sccs = new TarjanStronglyConnectedComponentFinder(this.tablesGraph).detectCycles();
        if (!sccs.isEmpty()) {
            for (List list : sccs) {
                this.addCatalogLint(this.getSummary(), new ArrayList(list));
            }
        }
        this.tablesGraph = null;
        super.end(connection);
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        Objects.requireNonNull(this.tablesGraph, "Not initialized");
        this.tablesGraph.addVertex((Comparable)table);
        for (ForeignKey foreignKey : table.getForeignKeys()) {
            Table pkTable = foreignKey.getPrimaryKeyTable();
            Table fkTable = foreignKey.getForeignKeyTable();
            if (pkTable instanceof PartialDatabaseObject || fkTable instanceof PartialDatabaseObject) continue;
            this.tablesGraph.addEdge((Comparable)pkTable, (Comparable)fkTable);
        }
    }

    @Override
    protected void start(Connection connection) {
        super.start(connection);
        this.tablesGraph = new DirectedGraph(this.getLinterId());
    }
}

