/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.offline;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.formatter.serialize.JavaSerializedCatalog;
import schemacrawler.tools.offline.OfflineDatabaseConnector;
import schemacrawler.tools.offline.jdbc.OfflineConnection;

public final class OfflineCatalogLoader
extends BaseCatalogLoader {
    public OfflineCatalogLoader() {
        super(new CommandDescription("offlineloader", "Loader for offline databases"), -1);
    }

    public void loadCatalog() {
        Catalog catalog;
        if (this.isLoaded()) {
            return;
        }
        if (!this.isDatabaseSystemIdentifier(OfflineDatabaseConnector.DB_SERVER_TYPE.getDatabaseSystemIdentifier())) {
            return;
        }
        try (Connection connection = (Connection)this.getDataSource().get();){
            boolean isOfflineConnection;
            if (connection == null) {
                return;
            }
            boolean bl = isOfflineConnection = connection instanceof OfflineConnection || connection.isWrapperFor(OfflineConnection.class);
            if (!isOfflineConnection) {
                return;
            }
            OfflineConnection dbConnection = connection.isWrapperFor(OfflineConnection.class) ? connection.unwrap(OfflineConnection.class) : (OfflineConnection)connection;
            Path offlineDatabasePath = dbConnection.getOfflineDatabasePath();
            try (GZIPInputStream inputFileStream = new GZIPInputStream(Files.newInputStream(offlineDatabasePath, new OpenOption[0]));){
                JavaSerializedCatalog deserializedCatalog = new JavaSerializedCatalog((InputStream)inputFileStream);
                catalog = deserializedCatalog.getCatalog();
            }
            this.reduceCatalog(catalog);
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not load offline database", e);
        }
        catch (SQLException e) {
            throw new DatabaseAccessException("Could not load offline database", e);
        }
        this.setCatalog(catalog);
    }

    private void reduceCatalog(Catalog catalog) {
        SchemaCrawlerOptions schemaCrawlerOptions = this.getSchemaCrawlerOptions();
        catalog.reduce(Schema.class, ReducerFactory.getSchemaReducer((SchemaCrawlerOptions)schemaCrawlerOptions));
        catalog.reduce(Table.class, ReducerFactory.getTableReducer((SchemaCrawlerOptions)schemaCrawlerOptions));
        catalog.reduce(Routine.class, ReducerFactory.getRoutineReducer((SchemaCrawlerOptions)schemaCrawlerOptions));
        catalog.reduce(Synonym.class, ReducerFactory.getSynonymReducer((SchemaCrawlerOptions)schemaCrawlerOptions));
        catalog.reduce(Sequence.class, ReducerFactory.getSequenceReducer((SchemaCrawlerOptions)schemaCrawlerOptions));
    }
}

