/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.v3;

import com.amazon.redshift.copy.CopyIn;
import com.amazon.redshift.copy.CopyOperation;
import com.amazon.redshift.copy.CopyOut;
import com.amazon.redshift.core.RedshiftStream;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.core.v3.CopyDualImpl;
import com.amazon.redshift.core.v3.CopyInImpl;
import com.amazon.redshift.core.v3.CopyOperationImpl;
import com.amazon.redshift.core.v3.CopyOutImpl;
import com.amazon.redshift.core.v3.QueryExecutorImpl;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.ByteStreamWriter;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;

class CopyQueryExecutor {
    private QueryExecutorImpl queryExecutor;
    RedshiftLogger logger;
    final RedshiftStream pgStream;
    AtomicBoolean processingCopyResults = new AtomicBoolean(false);

    CopyQueryExecutor(QueryExecutorImpl queryExecutor, RedshiftLogger logger, RedshiftStream pgStream) {
        this.queryExecutor = queryExecutor;
        this.logger = logger;
        this.pgStream = pgStream;
    }

    CopyOperation startCopy(String sql, boolean suppressBegin) throws SQLException {
        this.queryExecutor.waitForRingBufferThreadToFinish(false, false, null, null);
        QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
        synchronized (queryExecutorImpl) {
            this.queryExecutor.waitOnLock();
            if (!suppressBegin) {
                this.queryExecutor.doSubprotocolBegin();
            }
            byte[] buf = Utils.encodeUTF8(sql);
            try {
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, " FE=> Query(CopyStart)", new Object[0]);
                }
                this.pgStream.sendChar(81);
                this.pgStream.sendInteger4(buf.length + 4 + 1);
                this.pgStream.send(buf);
                this.pgStream.sendChar(0);
                this.pgStream.flush();
                return this.processCopyResults(null, true);
            }
            catch (IOException ioe) {
                throw new RedshiftException(GT.tr("Database connection failed when starting copy", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelCopy(CopyOperationImpl op) throws SQLException {
        int errors;
        SQLException error;
        block27: {
            if (!this.queryExecutor.hasLock(op)) {
                throw new RedshiftException(GT.tr("Tried to cancel an inactive copy operation", new Object[0]), RedshiftState.OBJECT_NOT_IN_STATE);
            }
            error = null;
            errors = 0;
            try {
                if (op instanceof CopyIn) {
                    QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
                    synchronized (queryExecutorImpl) {
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, "FE => CopyFail", new Object[0]);
                        }
                        byte[] msg = Utils.encodeUTF8("Copy cancel requested");
                        this.pgStream.sendChar(102);
                        this.pgStream.sendInteger4(5 + msg.length);
                        this.pgStream.send(msg);
                        this.pgStream.sendChar(0);
                        this.pgStream.flush();
                        do {
                            try {
                                this.processCopyResults(op, true);
                            }
                            catch (SQLException se) {
                                ++errors;
                                if (error != null) {
                                    SQLException next;
                                    SQLException e = se;
                                    while ((next = e.getNextException()) != null) {
                                        e = next;
                                    }
                                    e.setNextException(error);
                                }
                                error = se;
                            }
                        } while (this.queryExecutor.hasLock(op));
                        break block27;
                    }
                }
                if (op instanceof CopyOut) {
                    this.queryExecutor.sendQueryCancel();
                }
            }
            catch (IOException ioe) {
                throw new RedshiftException(GT.tr("Database connection failed when canceling copy operation", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)ioe);
            }
            finally {
                QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
                synchronized (queryExecutorImpl) {
                    if (this.queryExecutor.hasLock(op)) {
                        this.queryExecutor.unlock(op);
                    }
                }
            }
        }
        if (op instanceof CopyIn) {
            if (errors < 1) {
                throw new RedshiftException(GT.tr("Missing expected error response to copy cancel request", new Object[0]), RedshiftState.COMMUNICATION_ERROR);
            }
            if (errors > 1) {
                throw new RedshiftException(GT.tr("Got {0} error responses to single copy cancel request", String.valueOf(errors)), RedshiftState.COMMUNICATION_ERROR, (Throwable)error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CopyOperationImpl processCopyResults(CopyOperationImpl op, boolean block) throws SQLException, IOException {
        if (this.pgStream.isClosed()) {
            throw new RedshiftException(GT.tr("RedshiftStream is closed", op.getClass().getName()), RedshiftState.CONNECTION_DOES_NOT_EXIST);
        }
        if (!this.processingCopyResults.compareAndSet(false, true)) {
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.INFO, "Ignoring request to process copy results, already processing", new Object[0]);
            }
            return null;
        }
        try {
            boolean endReceiving = false;
            SQLException error = null;
            SQLException errors = null;
            while (!endReceiving && (block || this.pgStream.hasMessagePending())) {
                int c;
                if (!block && (c = this.pgStream.peekChar()) == 67) {
                    if (!RedshiftLogger.isEnable()) break;
                    this.logger.log(LogLevel.DEBUG, " <=BE CommandStatus, Ignored until CopyDone", new Object[0]);
                    break;
                }
                c = this.pgStream.receiveChar();
                switch (c) {
                    case 65: {
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE Asynchronous Notification while copying", new Object[0]);
                        }
                        this.queryExecutor.receiveAsyncNotify();
                        break;
                    }
                    case 78: {
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE Notification while copying", new Object[0]);
                        }
                        this.queryExecutor.addWarning(this.queryExecutor.receiveNoticeResponse());
                        break;
                    }
                    case 67: {
                        String status = this.queryExecutor.receiveCommandStatus();
                        try {
                            if (op == null) {
                                throw new RedshiftException(GT.tr("Received CommandComplete ''{0}'' without an active copy operation", status), RedshiftState.OBJECT_NOT_IN_STATE);
                            }
                            op.handleCommandStatus(status);
                        }
                        catch (SQLException se) {
                            error = se;
                        }
                        block = true;
                        break;
                    }
                    case 69: {
                        error = this.queryExecutor.receiveErrorResponse(false);
                        block = true;
                        break;
                    }
                    case 71: {
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE CopyInResponse", new Object[0]);
                        }
                        if (op != null) {
                            error = new RedshiftException(GT.tr("Got CopyInResponse from server during an active {0}", op.getClass().getName()), RedshiftState.OBJECT_NOT_IN_STATE);
                        }
                        op = new CopyInImpl();
                        this.initCopy(op);
                        endReceiving = true;
                        break;
                    }
                    case 72: {
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE CopyOutResponse", new Object[0]);
                        }
                        if (op != null) {
                            error = new RedshiftException(GT.tr("Got CopyOutResponse from server during an active {0}", op.getClass().getName()), RedshiftState.OBJECT_NOT_IN_STATE);
                        }
                        op = new CopyOutImpl();
                        this.initCopy(op);
                        endReceiving = true;
                        break;
                    }
                    case 87: {
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE CopyBothResponse", new Object[0]);
                        }
                        if (op != null) {
                            error = new RedshiftException(GT.tr("Got CopyBothResponse from server during an active {0}", op.getClass().getName()), RedshiftState.OBJECT_NOT_IN_STATE);
                        }
                        op = new CopyDualImpl();
                        this.initCopy(op);
                        endReceiving = true;
                        break;
                    }
                    case 100: {
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE CopyData", new Object[0]);
                        }
                        int len = this.pgStream.receiveInteger4() - 4;
                        assert (len > 0) : "Copy Data length must be greater than 4";
                        byte[] buf = this.pgStream.receive(len);
                        if (op == null) {
                            error = new RedshiftException(GT.tr("Got CopyData without an active copy operation", new Object[0]), RedshiftState.OBJECT_NOT_IN_STATE);
                        } else if (!(op instanceof CopyOut)) {
                            error = new RedshiftException(GT.tr("Unexpected copydata from server for {0}", op.getClass().getName()), RedshiftState.COMMUNICATION_ERROR);
                        } else {
                            op.handleCopydata(buf);
                        }
                        endReceiving = true;
                        break;
                    }
                    case 99: {
                        int len;
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE CopyDone", new Object[0]);
                        }
                        if ((len = this.pgStream.receiveInteger4() - 4) > 0) {
                            this.pgStream.receive(len);
                        }
                        if (!(op instanceof CopyOut)) {
                            error = new RedshiftException("Got CopyDone while not copying from server", RedshiftState.OBJECT_NOT_IN_STATE);
                        }
                        block = true;
                        break;
                    }
                    case 83: {
                        try {
                            this.queryExecutor.receiveParameterStatus();
                        }
                        catch (SQLException e) {
                            error = e;
                            endReceiving = true;
                        }
                        break;
                    }
                    case 90: {
                        this.queryExecutor.receiveRFQ();
                        if (this.queryExecutor.hasLock(op)) {
                            this.queryExecutor.unlock(op);
                        }
                        op = null;
                        endReceiving = true;
                        break;
                    }
                    case 84: {
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE RowDescription (during copy ignored)", new Object[0]);
                        }
                        this.queryExecutor.skipMessage();
                        break;
                    }
                    case 68: {
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE DataRow (during copy ignored)", new Object[0]);
                        }
                        this.queryExecutor.skipMessage();
                        break;
                    }
                    default: {
                        throw new IOException(GT.tr("Unexpected packet type during copy: {0}", Integer.toString(c)));
                    }
                }
                if (error == null) continue;
                if (errors != null) {
                    error.setNextException(errors);
                }
                errors = error;
                error = null;
            }
            if (errors != null) {
                throw errors;
            }
            CopyOperationImpl copyOperationImpl = op;
            return copyOperationImpl;
        }
        finally {
            this.processingCopyResults.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initCopy(CopyOperationImpl op) throws SQLException, IOException {
        QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
        synchronized (queryExecutorImpl) {
            this.pgStream.receiveInteger4();
            int rowFormat = this.pgStream.receiveChar();
            int numFields = this.pgStream.receiveInteger2();
            int[] fieldFormats = new int[numFields];
            for (int i = 0; i < numFields; ++i) {
                fieldFormats[i] = this.pgStream.receiveInteger2();
            }
            this.queryExecutor.lock(op);
            op.init(this.queryExecutor, rowFormat, fieldFormats);
        }
    }

    long endCopy(CopyOperationImpl op) throws SQLException {
        QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
        synchronized (queryExecutorImpl) {
            if (!this.queryExecutor.hasLock(op)) {
                throw new RedshiftException(GT.tr("Tried to end inactive copy", new Object[0]), RedshiftState.OBJECT_NOT_IN_STATE);
            }
            try {
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, " FE=> CopyDone", new Object[0]);
                }
                this.pgStream.sendChar(99);
                this.pgStream.sendInteger4(4);
                this.pgStream.flush();
                do {
                    this.processCopyResults(op, true);
                } while (this.queryExecutor.hasLock(op));
                return op.getHandledRowCount();
            }
            catch (IOException ioe) {
                throw new RedshiftException(GT.tr("Database connection failed when ending copy", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToCopy(CopyOperationImpl op, byte[] data, int off, int siz) throws SQLException {
        QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
        synchronized (queryExecutorImpl) {
            if (!this.queryExecutor.hasLock(op)) {
                throw new RedshiftException(GT.tr("Tried to write to an inactive copy operation", new Object[0]), RedshiftState.OBJECT_NOT_IN_STATE);
            }
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.DEBUG, " FE=> CopyData({0})", siz);
            }
            try {
                this.pgStream.sendChar(100);
                this.pgStream.sendInteger4(siz + 4);
                this.pgStream.send(data, off, siz);
            }
            catch (IOException ioe) {
                throw new RedshiftException(GT.tr("Database connection failed when writing to copy", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToCopy(CopyOperationImpl op, ByteStreamWriter from) throws SQLException {
        QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
        synchronized (queryExecutorImpl) {
            if (!this.queryExecutor.hasLock(op)) {
                throw new RedshiftException(GT.tr("Tried to write to an inactive copy operation", new Object[0]), RedshiftState.OBJECT_NOT_IN_STATE);
            }
            int siz = from.getLength();
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.DEBUG, " FE=> CopyData({0})", siz);
            }
            try {
                this.pgStream.sendChar(100);
                this.pgStream.sendInteger4(siz + 4);
                this.pgStream.send(from);
            }
            catch (IOException ioe) {
                throw new RedshiftException(GT.tr("Database connection failed when writing to copy", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCopy(CopyOperationImpl op) throws SQLException {
        QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
        synchronized (queryExecutorImpl) {
            if (!this.queryExecutor.hasLock(op)) {
                throw new RedshiftException(GT.tr("Tried to write to an inactive copy operation", new Object[0]), RedshiftState.OBJECT_NOT_IN_STATE);
            }
            try {
                this.pgStream.flush();
            }
            catch (IOException ioe) {
                throw new RedshiftException(GT.tr("Database connection failed when writing to copy", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readFromCopy(CopyOperationImpl op, boolean block) throws SQLException {
        QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
        synchronized (queryExecutorImpl) {
            if (!this.queryExecutor.hasLock(op)) {
                throw new RedshiftException(GT.tr("Tried to read from inactive copy", new Object[0]), RedshiftState.OBJECT_NOT_IN_STATE);
            }
            try {
                this.processCopyResults(op, block);
            }
            catch (IOException ioe) {
                throw new RedshiftException(GT.tr("Database connection failed when reading from copy", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
    }
}

