/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.proxy.db2;

import com.ibm.db2.cmx.Database;
import com.ibm.db2.cmx.Profile;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.internal.controller.ControlDataSource;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.internal.metadata.ClientProfileUtil;
import com.ibm.db2.cmx.internal.metadata.DataBeanFirstConnection;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcDataSource;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedXAResourceInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxyCache;
import com.ibm.db2.cmx.runtime.internal.proxy.db2.ProxiedDB2ConnectionInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.proxy.db2.ProxiedDB2XAResourceInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ConnectionExecutionHandler;
import com.ibm.db2.jcc.DB2BaseDataSource;
import com.ibm.db2.jcc.PDQConnection;
import com.ibm.db2.jcc.am.GlobalProperties;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.transaction.xa.XAResource;

public class ProxiedDB2DataSource
extends ProxiedJdbcDataSource {
    private static Properties defaultProperties_;
    public Connection monconnection;
    private static Map<String, String> monitorUrlByServerIPPortDBName__;

    public ProxiedDB2DataSource(Object object) {
        super(object);
        object = (DB2BaseDataSource)object;
        if (defaultProperties_ == null) {
            try {
                defaultProperties_ = ((DB2BaseDataSource)object).getProperties();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    @Override
    public Object invokeGetConnection(Method method, Object[] objectArray, String string) throws Throwable {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logMonitorMessage(logger__, this, "invokeGetConnection", "");
        }
        if (Configuration.isJCCPresent__ && !Configuration.isJCCAtPrerequisiteLevel__ && !DataProperties.getProperty("pdq.disableJDBCPrerequisiteEnforcement").equalsIgnoreCase("true")) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Configuration.getJCCVersionNotSupportedMessage(), null, 10680);
        }
        return super.invokeGetConnection(method, objectArray, string);
    }

    @Override
    public Object createMaterialConnectionProxy_(Connection connection, String string, XAResource xAResource) throws SQLException {
        Object object;
        String string2 = this.getJccGlobalProperty();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string3 = databaseMetaData.getDatabaseProductName();
        String string4 = databaseMetaData.getDatabaseProductVersion();
        int n2 = databaseMetaData.getDatabaseMajorVersion();
        int n3 = databaseMetaData.getDatabaseMinorVersion();
        DB2ConnectionExecutionHandler dB2ConnectionExecutionHandler = new DB2ConnectionExecutionHandler(connection, (DB2BaseDataSource)this.target_, string2, string3, string4, n2, n3);
        ProxiedDB2ConnectionInvocationHandler proxiedDB2ConnectionInvocationHandler = new ProxiedDB2ConnectionInvocationHandler(connection, dB2ConnectionExecutionHandler, this.monitorAgent_, string, (ProxiedJdbcDataSource)this, string3, string4);
        if (xAResource != null) {
            object = (ProxiedXAResourceInvocationHandler)Proxy.getInvocationHandler(xAResource);
            ((ProxiedXAResourceInvocationHandler)object).setProxiedConnection(proxiedDB2ConnectionInvocationHandler);
        }
        object = ProxyCache.createInstance(connection, proxiedDB2ConnectionInvocationHandler);
        proxiedDB2ConnectionInvocationHandler.setConnectionProxy(object);
        return object;
    }

    @Override
    public Object createXAResourceProxy(XAResource xAResource) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.enter(logger__, this, "createXAResourceProxy");
        }
        ProxiedDB2XAResourceInvocationHandler proxiedDB2XAResourceInvocationHandler = new ProxiedDB2XAResourceInvocationHandler(xAResource);
        Object object = ProxyCache.createInstance(xAResource, proxiedDB2XAResourceInvocationHandler);
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "createXAResourceProxy", object);
        }
        return object;
    }

    private String getJccGlobalProperty() {
        String string = null;
        try {
            string = GlobalProperties.getJccGlobalProperty("pdqProperties", false);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return string;
    }

    @Override
    protected void initializeFirstConnectionData_(Connection connection) {
        block10: {
            try {
                Boolean bl2;
                Object object;
                this.firstConnectionBean_ = new DataBeanFirstConnection();
                this.firstConnectionBean_.pdqData_ = new String[]{"IBM InfoSphere Optim pureQuery Runtime", "3.3306.7"};
                DB2BaseDataSource dB2BaseDataSource = (DB2BaseDataSource)this.target_;
                this.firstConnectionBean_.startTimeUTC_ = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
                this.firstConnectionBean_.databaseName_ = dB2BaseDataSource.getDatabaseName();
                this.firstConnectionBean_.serverName_ = Configuration.resolveToIPAddress(dB2BaseDataSource.getServerName());
                this.firstConnectionBean_.portNumber_ = dB2BaseDataSource.getPortNumber();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                this.firstConnectionBean_.databaseProductName_ = databaseMetaData.getDatabaseProductName();
                this.firstConnectionBean_.databaseProductVersion_ = databaseMetaData.getDatabaseProductVersion();
                this.firstConnectionBean_.driverName_ = this.driverNameOverride_ != null ? this.driverNameOverride_ : databaseMetaData.getDriverName();
                this.firstConnectionBean_.driverVersion_ = this.driverVersionOverride_ != null ? this.driverVersionOverride_ : databaseMetaData.getDriverVersion();
                this.firstConnectionBean_.dataSourceName_ = dB2BaseDataSource.getMonitoredDataSourceName();
                this.firstConnectionBean_.wasData_ = this.firstConnectionWasData_;
                this.firstConnectionBean_.connectionProperties_ = dB2BaseDataSource.getProperties().toString();
                if (Configuration.extendedInsightMonitorProtocolClientMaxLevel__ >= 3) {
                    object = ((PDQConnection)((Object)connection)).pullData(3000);
                    bl2 = null;
                    if (object != null) {
                        this.firstConnectionBean_.actualBackendLocationName_ = object[0] == null ? null : ((String)object[0]).trim();
                        bl2 = object[1] == null ? null : (String)object[1];
                        this.firstConnectionBean_.setGatewayPrdid(object[2] == null ? null : (String)object[2]);
                        if (((Object[])object).length >= 4) {
                            this.dbControllerURL_ = (String)object[3];
                        }
                        if (logger__.isLoggable(Level.FINER)) {
                            DataLogger.logMonitorMessage(logger__, this, "initializeFirstConnectionData_", "gateway and location information retrieved from driver: {" + object[0] + ", " + object[1] + ", " + object[2] + "}");
                        }
                    }
                    if (this.firstConnectionBean_.actualBackendLocationName_ != null && bl2 != null && Configuration.isProductDB2Z((String)((Object)bl2))) {
                        this.monitoredLocationName_ = this.firstConnectionBean_.actualBackendLocationName_;
                        this.haveNewActualBackendLocation_ = true;
                    }
                }
                if (Configuration.isMonitorSPSupported__) {
                    String string;
                    object = DataProperties.getProperty("pdq.cmx.controllerURL");
                    bl2 = DataProperties.getPropertyBoolean("pdq.cmx.server");
                    if (this.monitorServer_ == null && this.dbControllerURL_ == null && object == null && !bl2.booleanValue() && monitorUrlByServerIPPortDBName__.containsKey(string = "" + this.firstConnectionBean_.serverName_ + ":" + this.firstConnectionBean_.portNumber_ + "/" + this.firstConnectionBean_.databaseName_)) {
                        this.monitorURLFromStoredProc_ = monitorUrlByServerIPPortDBName__.get(string);
                    }
                }
                super.compute_isOCMClient();
                super.compute_isOPMClient();
                if (this.monitorURLFromStoredProc_ == null && !super.isControllableClient() && super.isPureQueryDisabled()) {
                    this.disableProxies_ = true;
                }
            }
            catch (SQLException sQLException) {
                if (!logger__.isLoggable(Level.FINER)) break block10;
                logger__.log(Level.FINER, "Error ignored in initializeFirstConnectionData_()", sQLException);
            }
        }
    }

    @Override
    protected void getClientSettingsFromWrapper_() {
        if (this.target_ instanceof DB2BaseDataSource) {
            DB2BaseDataSource dB2BaseDataSource = (DB2BaseDataSource)this.target_;
            this.monitorEnabled_ = dB2BaseDataSource.getMonitorEnabled();
            if (this.monitorEnabled_ != 2 && this.monitorEnabled_ != 1 && this.monitorEnabled_ != 0) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_INVALID_MONITOR_ENABLED", this.monitorEnabled_), null, 10605);
            }
            this.monitorServer_ = dB2BaseDataSource.getMonitorServerName();
            this.monitorPort_ = dB2BaseDataSource.getMonitorPort();
            this.monitorCollectionInterval_ = dB2BaseDataSource.getMonitorCollectionInterval();
            this.monitoredDataSourceName_ = dB2BaseDataSource.getMonitoredDataSourceName();
            this.monitoredDatabaseServerName_ = dB2BaseDataSource.getServerName();
            this.monitoredDatabasePort_ = dB2BaseDataSource.getPortNumber();
            this.monitoredDatabaseName_ = dB2BaseDataSource.getDatabaseName();
            this.dataSourceName_ = dB2BaseDataSource.getDataSourceName();
            if (Configuration.isJCCAtCMX5ProtocolLevel__) {
                this.profileName_ = dB2BaseDataSource.getProfileName();
            }
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logMonitorMessage(logger__, this, "getClientSettingsFromWrapper", "wrapper settings:: monitorEnabled: " + this.monitorEnabled_ + " monitorServer_: " + this.monitorServer_ + " monitorPort_: " + this.monitorPort_ + " monitorCollectionInterval: " + this.monitorCollectionInterval_ + " monitoredDataSourceName: " + this.monitoredDataSourceName_ + " monitoredDatabaseServerName: " + this.monitoredDatabaseServerName_ + " monitoredDatabasePort: " + this.monitoredDatabasePort_ + " monitoredDatabaseName: " + this.monitoredDatabaseName_);
        }
    }

    @Override
    protected JSONObject getCurrentNonDefaultClientProperties_() {
        try {
            Properties properties = ((DB2BaseDataSource)this.target_).getProperties();
            Iterator<Object> iterator = properties.keySet().iterator();
            JSONObject jSONObject = new JSONObject();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = properties.getProperty(string);
                if (defaultProperties_.get(string).equals(string2) || string.equals("password")) continue;
                jSONObject.put(string, string2);
            }
            return jSONObject;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    @Override
    public Object[] pullData(int n2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void applyStaticPushDownProperties() {
        HashMap<String, String> hashMap;
        Object object;
        Profile.DataSource dataSource = this.compositecds_.getDataSourceProfile();
        Database database = null;
        Properties properties = null;
        Object[] objectArray = ControlDriver.getInstance().getDriverProfile();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<PushDownError> arrayList3 = new ArrayList<PushDownError>();
        Database database2 = null;
        int n2 = 0;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.enter(logger__, this, "applyStaticPushDownProperties");
        }
        Object object2 = ClientProfileUtil.globalPushdownLock_;
        // MONITORENTER : object2
        if (objectArray != null && !ControlDriver.getInstance().getStaticDriverProfileApplied()) {
            block45: {
                block44: {
                    object = objectArray;
                    // MONITORENTER : objectArray
                    hashMap = objectArray.getJccDirectives();
                    properties = objectArray.getSpecialRegisters();
                    if (hashMap != null && Configuration.isJCCAtCMX5ProtocolLevel__) {
                        try {
                            if (logger__.isLoggable(Level.FINEST)) {
                                logger__.log(Level.FINEST, "Applying static driver overrides : " + hashMap);
                            }
                            GlobalProperties.pushDown(true, hashMap, arrayList2);
                            ControlDriver.getInstance().setDriverProfileVersion(objectArray.getVersion());
                        }
                        catch (SQLException sQLException) {
                            if (!logger__.isLoggable(Level.FINEST)) break block44;
                            DataLogger.logTrappedException(logger__, this, "applyStaticPushDownProperties", sQLException, null);
                        }
                    }
                }
                if (Configuration.isJCCAtCMX9ProtocolLevel__ && properties != null) {
                    try {
                        if (logger__.isLoggable(Level.FINEST)) {
                            logger__.log(Level.FINEST, "Applying static driver specialRegister : " + properties);
                        }
                        ((DB2BaseDataSource)this.target_).setSpecialRegisters(properties);
                    }
                    catch (Throwable throwable) {
                        if (!logger__.isLoggable(Level.FINEST)) break block45;
                        DataLogger.logTrappedException(logger__, this, "applyStaticPushDownProperties", throwable, null);
                    }
                }
            }
            // MONITOREXIT : object
        }
        ControlDriver.getInstance().setStaticDriverProfileApplied();
        // MONITOREXIT : object2
        for (int i10 = 0; i10 < arrayList2.size(); ++i10) {
            object = (Object[])arrayList2.get(i10);
            arrayList3.add(ClientProfileUtil.getPushDownError(object, PushDownError.PushDownLevel.driver));
        }
        if (arrayList3.size() > 0) {
            ControlDriver.getInstance().sendPushDownErrors(arrayList3, null);
            arrayList3.clear();
        }
        if (dataSource != null) {
            block48: {
                HashMap<String, String> hashMap2;
                block47: {
                    block46: {
                        Profile.DataSource dataSource2 = dataSource;
                        // MONITORENTER : dataSource2
                        database = dataSource.getTargetDatabase();
                        this.lastDataSrcProfileVersion_ = dataSource.getVersion();
                        if (database != null) {
                            this.lastDatabaseVersion_ = database.getVersion();
                            this.lastPhysicalLocationChangeVersion_ = database.getVersionOfLastPhysicalLocationChange();
                        }
                        if ((database2 = dataSource.getRedirectDatabase()) == null) {
                            database2 = database;
                        }
                        if (database2 != null) {
                            String string = database2.getServerName();
                            n2 = database2.getPort();
                            String string2 = database2.getDatabaseName();
                            if (string != null && n2 > 0 && string2 != null) {
                                if (logger__.isLoggable(Level.FINEST)) {
                                    logger__.log(Level.FINEST, "Applying static redirect rule : " + string + "," + n2 + "," + string2);
                                }
                                ((DB2BaseDataSource)this.target_).setServerName(database2.getServerName());
                                ((DB2BaseDataSource)this.target_).setPortNumber(database2.getPort());
                                ((DB2BaseDataSource)this.target_).setDatabaseName(database2.getDatabaseName());
                                ((DB2BaseDataSource)this.target_).setClientRerouteServerList(null);
                                this.redirectPending_ = false;
                            }
                        }
                        if ((hashMap = dataSource.getJccDirectives()) != null) {
                            if (logger__.isLoggable(Level.FINEST)) {
                                logger__.log(Level.FINEST, "Applying static datasource overrides : " + hashMap);
                            }
                            if (hashMap.containsKey("traceLevel") && !hashMap.containsKey("traceTimer")) {
                                hashMap.put("traceTimer", "300");
                            }
                            if (Configuration.isJCCAtCMX5ProtocolLevel__) {
                                try {
                                    ((DB2BaseDataSource)this.target_).pushDown(true, hashMap, arrayList);
                                    this.setDataSourceProfileVersion(dataSource.getVersion());
                                    if (this.cmxListener_ != null) {
                                        if (logger__.isLoggable(Level.FINEST)) {
                                            logger__.log(Level.FINEST, "WAS is being informed of jcc overrides properties : " + hashMap);
                                        }
                                        this.cmxListener_.inform(hashMap);
                                    }
                                }
                                catch (SQLException sQLException) {
                                    if (!logger__.isLoggable(Level.FINEST)) break block46;
                                    DataLogger.logTrappedException(logger__, this, "applyStaticPushDownProperties", sQLException, null);
                                }
                            }
                        }
                    }
                    object = ClientProfileUtil.getSpecialRegisters(dataSource);
                    if (Configuration.isJCCAtCMX9ProtocolLevel__ && object != null) {
                        try {
                            if (logger__.isLoggable(Level.FINEST)) {
                                logger__.log(Level.FINEST, "Applying static datasource specialRegister : " + object);
                            }
                            ((DB2BaseDataSource)this.target_).setSpecialRegisters((Properties)object);
                        }
                        catch (Throwable throwable) {
                            if (!logger__.isLoggable(Level.FINEST)) break block47;
                            DataLogger.logTrappedException(logger__, this, "applyStaticPushDownProperties", throwable, null);
                        }
                    }
                }
                if ((hashMap2 = ClientProfileUtil.getWASOverrideProperties(dataSource)) != null && this.cmxListener_ != null) {
                    if (logger__.isLoggable(Level.FINEST)) {
                        logger__.log(Level.FINEST, "Applying WAS datasource and pool properties : " + hashMap2);
                    }
                    try {
                        this.appliedPropsStatusFromWAS_ = this.cmxListener_.configure(hashMap2);
                        if (hashMap2.get(ClientProfileUtil.supportedWASDataSourceOrPoolProperties[0]) != null) {
                            this.wasMaxPoolConnectionsApplied_ = Integer.parseInt(hashMap2.get(ClientProfileUtil.supportedWASDataSourceOrPoolProperties[0]));
                        }
                        if (hashMap2.get(ClientProfileUtil.supportedWASDataSourceOrPoolProperties[1]) != null) {
                            this.wasConnTimeoutApplied_ = Integer.parseInt(hashMap2.get(ClientProfileUtil.supportedWASDataSourceOrPoolProperties[1]));
                        }
                    }
                    catch (Exception exception) {
                        if (!logger__.isLoggable(Level.FINEST)) break block48;
                        DataLogger.logTrappedException(logger__, this, "applyStaticPushDownProperties", exception, null);
                    }
                }
            }
            // MONITOREXIT : dataSource2
        }
        for (int i11 = 0; i11 < arrayList.size(); ++i11) {
            object = (Object[])arrayList.get(i11);
            arrayList3.add(ClientProfileUtil.getPushDownError(object, PushDownError.PushDownLevel.datasource));
        }
        if (arrayList3.size() > 0) {
            ControlDriver.getInstance().sendPushDownErrors(arrayList3, this.getControlDataSource().getDataSourceId());
        }
        if (!logger__.isLoggable(Level.FINER)) return;
        DataLogger.exit(logger__, this, "applyStaticPushDownProperties", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkAndReportApplnException(SQLException sQLException) {
        if (this.isOCMEnabled()) {
            if (this.applicationExceptionSet_.contains(sQLException.getErrorCode())) {
                return;
            }
            ControlDataSource controlDataSource = this.getControlDataSource();
            if (controlDataSource != null) {
                ControlDriver.getInstance().sendApplicationException(controlDataSource.getDataSourceId(), sQLException);
            }
            HashSet hashSet = this.applicationExceptionSet_;
            synchronized (hashSet) {
                this.applicationExceptionSet_.add(sQLException.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyDynamicProperties(Profile.DataSource dataSource) {
        Object object4;
        ArrayList<PushDownError> arrayList;
        ArrayList arrayList2;
        block38: {
            HashMap<String, String> hashMap;
            block37: {
                Iterator iterator;
                arrayList2 = new ArrayList();
                arrayList = new ArrayList<PushDownError>();
                hashMap = null;
                HashMap hashMap2 = null;
                HashMap hashMap3 = null;
                HashMap<String, String> hashMap4 = null;
                HashMap<String, Integer> hashMap5 = null;
                HashMap<String, String> hashMap6 = null;
                HashMap<String, String> hashMap7 = null;
                Set set = null;
                Object object2 = null;
                boolean bl2 = false;
                if (!Configuration.isJCCAtCMX5ProtocolLevel__) {
                    return;
                }
                if (this.getRefCount() == 0 || this.dataSourceState_ == 1) {
                    return;
                }
                hashMap3 = ClientProfileUtil.getDataSourceDynamicProperties(dataSource);
                if (logger__.isLoggable(Level.FINEST)) {
                    logger__.log(Level.FINEST, "applyDynamicProperties - properties from profile : " + (hashMap3 == null ? "null" : hashMap3));
                }
                hashMap4 = ClientProfileUtil.getWASOverrideProperties(dataSource);
                if (logger__.isLoggable(Level.FINEST)) {
                    logger__.log(Level.FINEST, "applyDynamicProperties - properties from profile : " + (hashMap4 == null ? "null" : hashMap4));
                }
                hashMap5 = new HashMap<String, Integer>();
                if (this.maxPoolConnectionsOverride_ != -1) {
                    hashMap5.put(ClientProfileUtil.supportedWASDataSourceOrPoolProperties[0], this.maxPoolConnectionsOverride_);
                }
                if (this.connectionTimeoutOverride_ != -1) {
                    hashMap5.put(ClientProfileUtil.supportedWASDataSourceOrPoolProperties[1], this.connectionTimeoutOverride_);
                }
                if (logger__.isLoggable(Level.FINEST)) {
                    logger__.log(Level.FINEST, "applyDynamicProperties - original properties from was : " + (hashMap5 == null ? "null" : hashMap5));
                }
                hashMap2 = (HashMap)((DB2BaseDataSource)this.target_).pullData(4001)[0];
                if (logger__.isLoggable(Level.FINEST)) {
                    logger__.log(Level.FINEST, "applyDynamicProperties - properties from jcc : " + (hashMap2 == null ? "null" : hashMap2));
                }
                if (hashMap6 == null) {
                    hashMap6 = new HashMap<String, String>();
                }
                if (hashMap5 != null) {
                    set = hashMap5.keySet();
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        object4 = iterator.next();
                        object2 = hashMap5.get((String)object4);
                        if (object2 == null) continue;
                        hashMap6.put((String)object4, object2.toString());
                    }
                }
                if (hashMap4 != null) {
                    hashMap6.putAll(hashMap4);
                }
                if (Boolean.parseBoolean(DataProperties.getProperty("pdq.cmx.purgeWASPool")) && this.cmxListener_ != null && (iterator = dataSource.getRedirectDatabase()) != null) {
                    object4 = (DB2BaseDataSource)this.target_;
                    if (!((Database)((Object)iterator)).getDatabaseName().equalsIgnoreCase(((DB2BaseDataSource)object4).getDatabaseName()) || ((Database)((Object)iterator)).getPort() != ((DB2BaseDataSource)object4).getPortNumber() || !((Database)((Object)iterator)).getServerName().equalsIgnoreCase(((DB2BaseDataSource)object4).getServerName())) {
                        hashMap7 = new HashMap<String, String>();
                        hashMap7.put("purgePolicy", "EntirePool");
                        hashMap7.put("purgePoolContents", "true");
                        bl2 = true;
                        Object object3 = lock;
                        synchronized (object3) {
                            if (this.getRefCount() > 0 && Boolean.parseBoolean(DataProperties.getProperty("pdq.cmx.purgeWASPool.type"))) {
                                hashMap7.put("pause", "");
                                this.wasPoolPaused_ = true;
                            }
                        }
                        hashMap6.putAll(hashMap7);
                    }
                }
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                }
                if (hashMap2 != null) {
                    set = hashMap2.keySet();
                    for (Object object4 : set) {
                        object2 = hashMap2.get((String)object4);
                        if (object2 == null) continue;
                        hashMap.put((String)object4, object2.toString());
                    }
                }
                if (hashMap3 != null) {
                    hashMap.putAll(hashMap3);
                }
                try {
                    if (this.cmxListener_ != null && hashMap6.size() != 0) {
                        if (logger__.isLoggable(Level.FINEST)) {
                            logger__.log(Level.FINEST, "Before - Pushing down WAS datasource and pool config properties : " + hashMap6);
                        }
                        this.appliedPropsStatusFromWAS_ = this.cmxListener_.configure(hashMap6);
                        if (logger__.isLoggable(Level.FINEST)) {
                            logger__.log(Level.FINEST, "After - Pushing down WAS datasource and pool config properties");
                        }
                        if (bl2) {
                            this.redirectPending_ = true;
                        }
                        this.wasMaxPoolConnectionsApplied_ = Integer.parseInt(hashMap6.get(ClientProfileUtil.supportedWASDataSourceOrPoolProperties[0]));
                        this.wasConnTimeoutApplied_ = Integer.parseInt(hashMap6.get(ClientProfileUtil.supportedWASDataSourceOrPoolProperties[1]));
                    }
                }
                catch (Exception exception) {
                    if (!logger__.isLoggable(Level.FINEST)) break block37;
                    DataLogger.logTrappedException(logger__, this, "applyDynamicProperties", exception, null);
                }
            }
            if (hashMap == null || hashMap.size() == 0) {
                return;
            }
            try {
                if (hashMap != null) {
                    if (logger__.isLoggable(Level.FINEST)) {
                        logger__.log(Level.FINEST, "Applying datasource dynamic properties : " + hashMap);
                    }
                    ((DB2BaseDataSource)this.target_).pushDown(false, hashMap, arrayList2);
                    if (this.cmxListener_ != null) {
                        if (logger__.isLoggable(Level.FINEST)) {
                            logger__.log(Level.FINEST, "WAS is being informed of jcc overrides properties : " + hashMap);
                        }
                        this.cmxListener_.inform(hashMap);
                    }
                }
            }
            catch (Exception exception) {
                if (!logger__.isLoggable(Level.FINEST)) break block38;
                DataLogger.logTrappedException(logger__, this, "applyDynamicProperties", exception, null);
            }
        }
        for (int i10 = 0; i10 < arrayList2.size(); ++i10) {
            object4 = (Object[])arrayList2.get(i10);
            arrayList.add(ClientProfileUtil.getPushDownError((Object[])object4, PushDownError.PushDownLevel.datasource));
        }
        if (arrayList.size() > 0) {
            ControlDriver.getInstance().sendPushDownErrors(arrayList, this.getControlDataSource().getDataSourceId());
        }
    }

    @Override
    protected void purgeWASPool() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.cmxListener_ != null && this.redirectPending_) {
            hashMap.put("purgePolicy", "EntirePool");
            hashMap.put("purgePoolContents", "true");
            if (logger__.isLoggable(Level.FINEST)) {
                logger__.log(Level.FINEST, "Before - RedirectPending: purgePool for post connections :" + hashMap);
            }
            this.appliedPropsStatusFromWAS_ = this.cmxListener_.configure(hashMap);
            if (logger__.isLoggable(Level.FINEST)) {
                logger__.log(Level.FINEST, "After - RedirectPending: purgePool for post connections : " + hashMap);
            }
        }
    }

    @Override
    protected HashMap getDataSourceDescriptorProperties() {
        HashMap hashMap = null;
        if (Configuration.isJCCAtCMX5ProtocolLevel__) {
            hashMap = (HashMap)((DB2BaseDataSource)this.target_).pullData(4000)[0];
        }
        return hashMap;
    }

    static {
        monitorUrlByServerIPPortDBName__ = Collections.synchronizedMap(new HashMap());
    }
}

