/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.data.handlers.SimpleParamMarkerParameterHandler;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.generator.ParameterHandler;
import com.ibm.db2.cmx.runtime.handlers.CallHandlerWithParameters;
import com.ibm.db2.cmx.runtime.handlers.ResultHandler;
import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.ConnectionInfoHelper;
import com.ibm.db2.cmx.runtime.internal.db.LiteralsInfo;
import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXml;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlPackage;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlParameterMetaData;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlResultSetMetaData;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlSpecialRegValuesSet;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatement;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementAttributes;
import com.ibm.db2.cmx.runtime.internal.xml.XmlBuf;
import com.ibm.db2.cmx.runtime.internal.xml.XmlExporter;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.SQLStatementInInputSQLFile;
import com.ibm.db2.jcc.DB2PreparedStatement;
import com.ibm.db2.jcc.DBPreparedStatementInfoInterface;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PDQXmlStatementDescriptor
implements XmlExporter {
    private transient PDQXmlPackage packageInfo_;
    private PDQXmlStatementAttributes statementAttributes_;
    protected PDQXmlStatement parentStatement_;
    @Deprecated
    private String methodName_;
    private String sql_;
    private String[] autogenColumnNames_;
    private int[] autogenColumnIndexes_;
    private int autogenColumnIndicator_ = 0;
    private SqlStatementType statementType_;
    private String parameterHandlerName_;
    private PDQXmlParameterMetaData parameterMetadata_;
    private String resultHandlerName_;
    private String rowHandlerName_;
    private PDQXmlResultSetMetaData resultSetMetaData_;
    private String callHandlerName_;
    private int sectionNumber_;
    protected TreeSet<Integer> specialRegisterValuesSets_ = null;
    private boolean firstSpecialRegisterValuesSetHasBeenObserved_ = false;
    private String currentSchemaFirstObserved_ = null;
    private String processedSql_;
    private int lineNumber_;
    private int columnNumber_;

    public String getMethodName() {
        return this.methodName_;
    }

    public void setMethodName(String string) {
        this.methodName_ = string;
    }

    public String getParameterHandlerName() {
        return this.parameterHandlerName_;
    }

    public void setParameterHandlerName(String string) {
        this.parameterHandlerName_ = string;
    }

    public PDQXmlParameterMetaData getParameterMetadata() {
        return this.parameterMetadata_;
    }

    public void setParameterMetadata(PDQXmlParameterMetaData pDQXmlParameterMetaData) {
        this.parameterMetadata_ = pDQXmlParameterMetaData;
    }

    public PDQXmlResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData_;
    }

    public void setResultSetMetaData(PDQXmlResultSetMetaData pDQXmlResultSetMetaData) {
        this.resultSetMetaData_ = pDQXmlResultSetMetaData;
    }

    public String getResultHandlerName() {
        return this.resultHandlerName_;
    }

    public void setResultHandlerName(String string) {
        this.resultHandlerName_ = string;
    }

    public String getRowHandlerName() {
        return this.rowHandlerName_;
    }

    public void setRowHandlerName(String string) {
        this.rowHandlerName_ = string;
    }

    public int getSectionNumber() {
        return this.sectionNumber_;
    }

    public void setSectionNumber(int n2) {
        this.sectionNumber_ = n2;
    }

    public String getSql() {
        return this.sql_;
    }

    public void setSql(String string) {
        this.sql_ = string;
    }

    @Deprecated
    public void setSqlAndMetaData(String string, Connection connection) throws SQLException {
        this.setSqlAndMetaData(string, null, connection, (short)21, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSqlAndMetaData(String string, SQLStatementInInputSQLFile sQLStatementInInputSQLFile, Connection connection, short s2, String string2, String string3) throws SQLException {
        Object object;
        String string4;
        block32: {
            Object object2;
            string4 = string;
            try {
                object = new EscapeLexer(string4);
                object2 = ((EscapeLexer)object).parseSqlAndGetSqlType();
                this.setStatementType((SqlStatementType)((Object)object2));
            }
            catch (Throwable throwable) {
                this.setStatementType(SqlStatementType.QUERY);
                object2 = Log.getLogger();
                if (null == object2) break block32;
                ((Logger)object2).log(Level.WARNING, "Error while parsing statement to detect statement type. pureQuery will assume statement type is QUERY.", throwable);
            }
        }
        object = new StaticProfileConstants.DBInfo(connection.getMetaData());
        boolean bl2 = false;
        Statement statement = null;
        try {
            Object object3;
            block37: {
                if (StaticProfileConstants.isValueSet(this.currentSchemaFirstObserved_) && !this.currentSchemaFirstObserved_.equals(string2)) {
                    bl2 = true;
                    ConnectionInfoHelper.setConnectionSchema(connection, (StaticProfileConstants.DBInfo)object, this.currentSchemaFirstObserved_);
                    sQLStatementInInputSQLFile.setCurrentSchemaInInputFile(this.currentSchemaFirstObserved_);
                }
                if (s2 == 22 || s2 == 24) {
                    block33: {
                        block34: {
                            object3 = null;
                            boolean bl3 = false;
                            LiteralsInfo literalsInfo = null;
                            try {
                                literalsInfo = LiteralsInfo.getLiteralsInfoForGeneratePureQueryXml(string4, sQLStatementInInputSQLFile, Log.getLogger(), (StaticProfileConstants.DBInfo)object, string3, s2);
                                sQLStatementInInputSQLFile.setLiteralsInfo(literalsInfo);
                                if (literalsInfo.isLiteralSubstitutionAllowed()) {
                                    object3 = literalsInfo.getLiteralReplacedSql();
                                    statement = this.createPreparedStatement((String)object3, connection, (StaticProfileConstants.DBInfo)object);
                                    bl3 = literalsInfo.verifyAndSetActualLiteralsDataType((PreparedStatement)statement, null);
                                }
                                if (!bl3) break block33;
                                if (null != object3 && null != statement) break block34;
                            }
                            catch (Throwable throwable) {
                                block35: {
                                    block36: {
                                        try {
                                            bl3 = false;
                                            if (null != literalsInfo) {
                                                literalsInfo.disallowLiteralSubstitution(true, throwable, Messages.getText("MSG_LIT_SUB_ERROR_WHILE_TRYING_TO_PREPARE", "pureQuery Runtime"));
                                            }
                                            if (!bl3) break block35;
                                            if (null != object3 && null != statement) break block36;
                                        }
                                        catch (Throwable throwable2) {
                                            if (bl3) {
                                                if (null == object3 || null == statement) {
                                                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_INVALID_SWITCH_CASE", (String)object3 + " " + statement), null, 11106);
                                                }
                                                this.sql_ = object3;
                                                sQLStatementInInputSQLFile.setIsSqlLiteralSubstituted(true);
                                            } else {
                                                sQLStatementInInputSQLFile.setIsSqlLiteralSubstituted(false);
                                                if (null != statement) {
                                                    try {
                                                        statement.close();
                                                    }
                                                    catch (Throwable throwable3) {
                                                        // empty catch block
                                                    }
                                                    statement = null;
                                                }
                                            }
                                            throw throwable2;
                                        }
                                        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_INVALID_SWITCH_CASE", (String)object3 + " " + statement), null, 11106);
                                    }
                                    this.sql_ = object3;
                                    sQLStatementInInputSQLFile.setIsSqlLiteralSubstituted(true);
                                }
                                sQLStatementInInputSQLFile.setIsSqlLiteralSubstituted(false);
                                if (null == statement) break block37;
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable4) {
                                    // empty catch block
                                }
                                statement = null;
                            }
                            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_INVALID_SWITCH_CASE", (String)object3 + " " + statement), null, 11106);
                        }
                        this.sql_ = object3;
                        sQLStatementInInputSQLFile.setIsSqlLiteralSubstituted(true);
                        break block37;
                    }
                    sQLStatementInInputSQLFile.setIsSqlLiteralSubstituted(false);
                    if (null != statement) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        statement = null;
                    }
                }
            }
            if (null == statement) {
                this.sql_ = string4;
                sQLStatementInInputSQLFile.setIsSqlLiteralSubstituted(false);
                statement = this.createPreparedStatement(string4, connection, (StaticProfileConstants.DBInfo)object);
            }
            if (StaticProfileConstants.DatabaseType.Oracle != ((StaticProfileConstants.DBInfo)object).databaseType_) {
                object3 = new PDQXmlParameterMetaData();
                ((PDQXmlParameterMetaData)object3).init((PreparedStatement)statement);
                this.setParameterMetadata((PDQXmlParameterMetaData)object3);
                PDQXmlResultSetMetaData pDQXmlResultSetMetaData = new PDQXmlResultSetMetaData();
                pDQXmlResultSetMetaData.init((PreparedStatement)statement);
                this.setResultSetMetaData(pDQXmlResultSetMetaData);
            }
        }
        finally {
            if (null != statement) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (Throwable throwable) {}
            }
            if (bl2) {
                ConnectionInfoHelper.setConnectionSchema(connection, (StaticProfileConstants.DBInfo)object, string2);
                bl2 = false;
            }
        }
        PDQXml.currentConnection__ = connection;
    }

    private PreparedStatement createPreparedStatement(String string, Connection connection, StaticProfileConstants.DBInfo dBInfo) throws SQLException {
        PreparedStatement preparedStatement;
        block5: {
            if (this.statementAttributes_ != null) {
                int n2 = this.statementAttributes_.getType();
                int n3 = this.statementAttributes_.getHoldability();
                int n4 = this.statementAttributes_.getConcurrency();
                preparedStatement = connection.prepareStatement(string, n2, n4, n3);
            } else {
                preparedStatement = connection.prepareStatement(string);
            }
            if (dBInfo.databaseType_.isDB2()) {
                try {
                    this.initDB2PrepareOptions(preparedStatement);
                }
                catch (Throwable throwable) {
                    Logger logger = Log.getLogger();
                    if (null == logger) break block5;
                    logger.log(Level.WARNING, "Error while retrieving DB2 prepare options.", throwable);
                }
            }
        }
        return preparedStatement;
    }

    private void initDB2PrepareOptions(PreparedStatement preparedStatement) throws SQLException {
        String string;
        DB2PreparedStatement dB2PreparedStatement;
        DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface;
        if (this.statementAttributes_ != null && (dBPreparedStatementInfoInterface = (dB2PreparedStatement = (DB2PreparedStatement)preparedStatement).getDBPreparedStatementInfo()) != null && (string = dBPreparedStatementInfoInterface.getPrepareAttributes()) != null) {
            this.statementAttributes_.setPrepareOptions(string);
        }
    }

    public String getStatementType() {
        if (null == this.statementType_) {
            return null;
        }
        return XmlTags.getStatementTypeXmlTag(this.statementType_);
    }

    public SqlStatementType getStatementTypeEnum() {
        return this.statementType_;
    }

    public void setStatementType(String string) {
        this.statementType_ = XmlTags.getStatementTypeFromXmlTag(string);
    }

    public void setStatementType(SqlStatementType sqlStatementType) {
        this.statementType_ = sqlStatementType;
    }

    public String[] getAutogenColumnNames() {
        return this.autogenColumnNames_;
    }

    public void setAutogenColumnNames(String[] stringArray) {
        this.autogenColumnNames_ = stringArray;
        this.initAutoGeneratedKeySql();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initAutoGeneratedKeySql() {
        if (this.processedSql_ != null) {
            return;
        }
        if (PDQXml.currentConnection__ == null) return;
        if (this.autogenColumnNames_ != null && this.autogenColumnNames_.length > 0) {
            try {
                Connection connection = PDQXml.currentConnection__;
                PreparedStatement preparedStatement = connection.prepareStatement(this.sql_, this.autogenColumnNames_);
                try {
                    try {
                        this.initProcessedSqlForAGKFromDB2Statement(preparedStatement);
                        return;
                    }
                    catch (Throwable throwable) {
                        Logger logger = Log.getLogger();
                        if (null == logger) return;
                        logger.log(Level.WARNING, "Error while retrieving statement Auto Generated Key details.", throwable);
                    }
                    return;
                }
                finally {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsNoLog(exception.getLocalizedMessage(), exception, 10912);
            }
        }
        if (this.autogenColumnIndexes_ == null || this.autogenColumnIndexes_.length <= 0) return;
        try {
            Connection connection = PDQXml.currentConnection__;
            PreparedStatement preparedStatement = connection.prepareStatement(this.sql_, this.autogenColumnIndexes_);
            try {
                try {
                    this.initProcessedSqlForAGKFromDB2Statement(preparedStatement);
                    return;
                }
                catch (Throwable throwable) {
                    Logger logger = Log.getLogger();
                    if (null == logger) return;
                    logger.log(Level.WARNING, "Error while retrieving statement Auto Generated Key details.", throwable);
                }
                return;
            }
            finally {
                preparedStatement.close();
            }
        }
        catch (Exception exception) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsNoLog(exception.getLocalizedMessage(), exception, 10913);
        }
    }

    private void initProcessedSqlForAGKFromDB2Statement(PreparedStatement preparedStatement) throws SQLException {
        DB2PreparedStatement dB2PreparedStatement = (DB2PreparedStatement)preparedStatement;
        DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = dB2PreparedStatement.getDBPreparedStatementInfo();
        String[] stringArray = dBPreparedStatementInfoInterface.getSQLString();
        if (stringArray != null && stringArray.length > 1) {
            this.setProcessedSql(stringArray[1]);
        }
    }

    public String getCallHandlerName() {
        return this.callHandlerName_;
    }

    public void setCallHandlerName(String string) {
        this.callHandlerName_ = string;
    }

    public String getProcessedSql() {
        return this.processedSql_;
    }

    public void setProcessedSql(String string) {
        this.processedSql_ = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getXml(int n2) {
        XmlBuf xmlBuf = new XmlBuf(n2);
        xmlBuf.startElement("statementDescriptor");
        xmlBuf.addElement("processedSql", this.processedSql_);
        xmlBuf.addElement("prepareSql", this.sql_);
        xmlBuf.addElement("statementType", this.getStatementType());
        if (this.autogenColumnNames_ != null) {
            xmlBuf.startElement("autoGeneratedColumnNames");
            for (String string : this.autogenColumnNames_) {
                xmlBuf.addElement("columnName", string);
            }
            xmlBuf.endElement();
        }
        if (this.autogenColumnIndexes_ != null) {
            xmlBuf.startElement("autoGeneratedColumnIndexes");
            for (int n3 : this.autogenColumnIndexes_) {
                xmlBuf.addElement("columnIndex", String.valueOf(n3));
            }
            xmlBuf.endElement();
        }
        if (this.autogenColumnIndicator_ != 0 && this.autogenColumnIndicator_ != 2) {
            xmlBuf.addElement("autoGeneratedcolumnIndicator", String.valueOf(this.autogenColumnIndicator_));
        }
        xmlBuf.addElement("parameterHandlerName", this.parameterHandlerName_);
        xmlBuf.addBranch(this.parameterMetadata_);
        xmlBuf.addElement("resultHandlerName", this.resultHandlerName_);
        xmlBuf.addElement("rowHandlerName", this.rowHandlerName_);
        xmlBuf.addBranch(this.resultSetMetaData_);
        if (this.statementAttributes_ == null) {
            this.statementAttributes_ = PDQXmlStatementAttributes.getPDQXmlStatementAttributesForClientOptimizer();
        }
        if (null != this.statementType_) {
            this.statementAttributes_.setBindable(XmlFileHelper.getIsBindableDefaultForStatement(this.statementType_));
            if (this.statementAttributes_.getCursorName() == null && this.sectionNumber_ > 0) {
                switch (this.statementType_) {
                    case QUERY: {
                        this.statementAttributes_.setCursorName("DB_PDQ_SPC" + ++PDQXml.lastCursorIndex__);
                        break;
                    }
                    case INSERT: 
                    case UPDATE: 
                    case MERGE: 
                    case DELETE: {
                        if (this.autogenColumnIndexes_ == null && this.autogenColumnNames_ == null && this.autogenColumnIndicator_ <= 0 || this.processedSql_ == null || !this.processedSql_.toLowerCase().startsWith("select")) break;
                        this.statementAttributes_.setCursorName("DB_PDQ_SPC" + ++PDQXml.lastCursorIndex__);
                    }
                }
            }
        }
        if (null == this.statementAttributes_.getIncrementalSpecialRegValuesUsed() && null != this.specialRegisterValuesSets_ && !this.specialRegisterValuesSets_.isEmpty()) {
            this.statementAttributes_.setIncrementalSpecialRegValuesUsed(this.specialRegisterValuesSets_);
        }
        if (this.statementAttributes_.getPrepareOptions() == null) {
            void var3_10;
            void var3_8;
            Object var3_6 = null;
            if (this.parameterMetadata_ != null) {
                String string = this.parameterMetadata_.prepareOptions_;
            }
            if (var3_8 == null && this.resultSetMetaData_ != null) {
                String string = this.resultSetMetaData_.prepareOptions_;
            }
            this.statementAttributes_.setPrepareOptions((String)var3_10);
        }
        xmlBuf.addBranch(this.statementAttributes_);
        xmlBuf.addElement("callHandlerName", this.callHandlerName_);
        xmlBuf.endElement();
        return xmlBuf.toString();
    }

    public PDQXmlPackage getPackageInfo() {
        return this.packageInfo_;
    }

    public void setPackageInfo(PDQXmlPackage pDQXmlPackage) {
        this.packageInfo_ = pDQXmlPackage;
    }

    public PDQXmlStatementAttributes getStatementAttributes() {
        return this.statementAttributes_;
    }

    public void setStatementAttributes(PDQXmlStatementAttributes pDQXmlStatementAttributes) {
        this.statementAttributes_ = pDQXmlStatementAttributes;
        if (this.statementAttributes_ != null) {
            this.statementAttributes_.statementDesc_ = this;
        }
    }

    public StatementDescriptorImpl createStatementDescriptorForBinder() {
        if (null == this.packageInfo_) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_NO_STMT_DESC_BECAUSE_PKG_NULL", new Object[0]), null, 10309);
        }
        String string = this.sql_;
        if (this.parentStatement_.getPDQXmlStatementDescriptor() != null && this.parentStatement_.getPDQXmlStatementDescriptor().getProcessedSql() != null) {
            string = this.parentStatement_.getPDQXmlStatementDescriptor().getProcessedSql();
        }
        StatementDescriptorImpl statementDescriptorImpl = new StatementDescriptorImpl(this.methodName_, string, this.statementType_, PDQXmlStatementAttributes.createStatementAttributesArray(this.statementAttributes_), this.autogenColumnNames_, null, this.parameterMetadata_ != null ? this.parameterMetadata_.toIntArray() : (int[][])null, null, null, this.resultSetMetaData_ != null ? this.resultSetMetaData_.toIntArray() : (int[][])null, null, null, this.packageInfo_.getPackageName(), this.packageInfo_.getConsistencyToken(), this.packageInfo_.getCollectionName(), false, null, this.sectionNumber_, this.parentStatement_.getId());
        return statementDescriptorImpl;
    }

    public StatementDescriptorImpl createStatementDescriptorForRuntime() {
        return this.createStatementDescriptorForRuntime(null);
    }

    public StatementDescriptorImpl createStatementDescriptorForRuntime(ClassLoader classLoader) {
        String[] stringArray;
        if (null == this.packageInfo_) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_NO_STMT_DESC_BECAUSE_PKG_NULL", new Object[0]), null, 10320);
        }
        StatementDescriptorImpl statementDescriptorImpl = null;
        try {
            stringArray = this.sql_;
            statementDescriptorImpl = new StatementDescriptorImpl(this.methodName_, (String)stringArray, this.statementType_, PDQXmlStatementAttributes.createStatementAttributesArray(this.statementAttributes_), this.autogenColumnNames_, this.createParameterHandler(classLoader), this.parameterMetadata_ != null ? this.parameterMetadata_.toIntArray() : (int[][])null, this.createResultHandler(classLoader), this.createRowHandler(classLoader), this.resultSetMetaData_ != null ? this.resultSetMetaData_.toIntArray() : (int[][])null, null, this.createCallHandler(classLoader), this.packageInfo_.getPackageName(), this.packageInfo_.getConsistencyToken(), this.packageInfo_.getCollectionName(), this.packageInfo_.isForceSingleBindIsolation(), null, this.sectionNumber_, this.parentStatement_.getId());
        }
        catch (InstantiationException instantiationException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_CANNOT_CREATE_STMT_DESC", new Object[0]), instantiationException, 10321);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_CANNOT_CREATE_STMT_DESC", new Object[0]), illegalAccessException, 10322);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_CANNOT_CREATE_STMT_DESC", new Object[0]), classNotFoundException, 10323);
        }
        catch (Exception exception) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_CANNOT_CREATE_STMT_DESC", new Object[0]), exception, 10387);
        }
        stringArray = null;
        if (this.resultSetMetaData_ != null) {
            stringArray = this.resultSetMetaData_.getColumnNames();
        }
        statementDescriptorImpl.setResultSetMetaDataColNames(stringArray);
        return statementDescriptorImpl;
    }

    private CallHandlerWithParameters createCallHandler(ClassLoader classLoader) throws Exception {
        if (classLoader == null) {
            return this.callHandlerName_ != null ? (CallHandlerWithParameters)PDQXmlStatementDescriptor.getClassForNameUseThreadContextClassLoader(this.callHandlerName_).newInstance() : null;
        }
        return this.callHandlerName_ != null ? (CallHandlerWithParameters)Class.forName(this.callHandlerName_, true, classLoader).newInstance() : null;
    }

    private ResultHandler createResultHandler(ClassLoader classLoader) throws Exception {
        if (classLoader == null) {
            return this.resultHandlerName_ != null ? (ResultHandler)PDQXmlStatementDescriptor.getClassForNameUseThreadContextClassLoader(this.resultHandlerName_).newInstance() : null;
        }
        return this.resultHandlerName_ != null ? (ResultHandler)Class.forName(this.resultHandlerName_, true, classLoader).newInstance() : null;
    }

    private RowHandler createRowHandler(ClassLoader classLoader) throws Exception {
        if (classLoader == null) {
            return this.rowHandlerName_ != null ? (RowHandler)PDQXmlStatementDescriptor.getClassForNameUseThreadContextClassLoader(this.rowHandlerName_).newInstance() : null;
        }
        return this.rowHandlerName_ != null ? (RowHandler)Class.forName(this.rowHandlerName_, true, classLoader).newInstance() : null;
    }

    private ParameterHandler createParameterHandler(ClassLoader classLoader) throws Exception {
        int[][] nArray;
        if (this.parameterHandlerName_ != null) {
            if (classLoader == null) {
                return (ParameterHandler)PDQXmlStatementDescriptor.getClassForNameUseThreadContextClassLoader(this.parameterHandlerName_).newInstance();
            }
            return (ParameterHandler)Class.forName(this.parameterHandlerName_, true, classLoader).newInstance();
        }
        PDQXmlParameterMetaData pDQXmlParameterMetaData = this.parameterMetadata_;
        int[] nArray2 = null;
        if (pDQXmlParameterMetaData != null && null != (nArray = pDQXmlParameterMetaData.toIntArray()) && nArray.length > 1) {
            nArray2 = nArray[0];
        }
        return new SimpleParamMarkerParameterHandler(nArray2);
    }

    public int getLineNumber() {
        return this.lineNumber_;
    }

    public void setLineNumber(int n2) {
        this.lineNumber_ = n2;
    }

    public int getColumnNumber() {
        return this.columnNumber_;
    }

    public void setColumnNumber(int n2) {
        this.columnNumber_ = n2;
    }

    private static Class<?> getClassForNameUseThreadContextClassLoader(String string) throws Exception {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(PDQXmlStatementDescriptor.getClassForNameUseThreadContextClassLoaderPriv(string));
        }
        return PDQXmlStatementDescriptor.getClassForNameUseThreadContextClassLoaderNonPriv(string);
    }

    private static Class<?> getClassForNameUseThreadContextClassLoaderNonPriv(String string) throws Exception {
        return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
    }

    private static final PrivilegedExceptionAction<Class<?>> getClassForNameUseThreadContextClassLoaderPriv(final String string) {
        return new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws Exception {
                return PDQXmlStatementDescriptor.getClassForNameUseThreadContextClassLoaderNonPriv(string);
            }
        };
    }

    public int[] getAutogenColumnIndexes() {
        return this.autogenColumnIndexes_;
    }

    public void setAutogenColumnIndexes(int[] nArray) {
        this.autogenColumnIndexes_ = nArray;
        this.initAutoGeneratedKeySql();
    }

    public int getAutogenColumnIndicator() {
        return this.autogenColumnIndicator_;
    }

    public void setAutogenColumnIndicator(int n2) {
        this.autogenColumnIndicator_ = n2;
    }

    public void addSpecialRegisterValuesSet(PDQXmlSpecialRegValuesSet pDQXmlSpecialRegValuesSet, Map<String, String> map) {
        if (null == pDQXmlSpecialRegValuesSet) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_INVALID_SWITCH_CASE", pDQXmlSpecialRegValuesSet), null, 11204);
        }
        if (null != map && !map.isEmpty()) {
            if (null == this.specialRegisterValuesSets_) {
                this.specialRegisterValuesSets_ = new TreeSet();
            }
            int n2 = pDQXmlSpecialRegValuesSet.addSpecialRegisterValuesSet(map);
            this.specialRegisterValuesSets_.add(n2);
            if (!this.firstSpecialRegisterValuesSetHasBeenObserved_) {
                this.currentSchemaFirstObserved_ = map.get("SCHEMA");
                if (null != this.currentSchemaFirstObserved_ && !StaticProfileConstants.isValueSet(this.currentSchemaFirstObserved_)) {
                    this.currentSchemaFirstObserved_ = null;
                }
            }
        }
        this.firstSpecialRegisterValuesSetHasBeenObserved_ = true;
    }

    public void addAllSpecialRegisterValuesSets(PDQXmlStatementDescriptor pDQXmlStatementDescriptor) {
        if (null != pDQXmlStatementDescriptor.specialRegisterValuesSets_) {
            if (null == this.specialRegisterValuesSets_) {
                this.specialRegisterValuesSets_ = new TreeSet();
            }
            this.specialRegisterValuesSets_.addAll(pDQXmlStatementDescriptor.specialRegisterValuesSets_);
        }
    }

    public TreeSet<Integer> getSpecialRegisterValuesSets() {
        return this.specialRegisterValuesSets_;
    }
}

