/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.diagram;

import java.util.Map;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.tools.command.text.diagram.options.DiagramOptions;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.base.BaseFormatter;
import schemacrawler.tools.text.options.BaseTextOptions;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.html.Alignment;
import us.fatehi.utility.html.Tag;
import us.fatehi.utility.html.TagBuilder;
import us.fatehi.utility.html.TagOutputFormat;

public abstract class BaseDotFormatter
extends BaseFormatter<DiagramOptions> {
    protected BaseDotFormatter(SchemaTextDetailType schemaTextDetailType, DiagramOptions options, OutputOptions outputOptions, String identifierQuoteString) {
        super(schemaTextDetailType, (BaseTextOptions)options, outputOptions, identifierQuoteString);
    }

    public void begin() {
        String header = this.makeGraphvizHeader();
        this.formattingHelper.append(header).println();
    }

    public void end() {
        this.formattingHelper.append("}").println();
        super.end();
    }

    public void handle(CrawlInfo crawlInfo) {
        Tag row;
        if (crawlInfo == null) {
            return;
        }
        if (this.outputOptions.hasTitle()) {
            String title = this.outputOptions.getTitle();
            row = TagBuilder.tableRow().make();
            row.addInnerTag(TagBuilder.tableCell().withEscapedText(title).withAlignment(Alignment.left).withEmphasis(true).withColumnSpan(2).make());
            this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
        }
        if (((DiagramOptions)this.options).isNoInfo()) {
            return;
        }
        if (!((DiagramOptions)this.options).isNoSchemaCrawlerInfo()) {
            row = TagBuilder.tableRow().make();
            row.addInnerTag(TagBuilder.tableCell().withEscapedText("generated by").withAlignment(Alignment.right).make());
            row.addInnerTag(TagBuilder.tableCell().withEscapedText(crawlInfo.getSchemaCrawlerVersion().toString()).withAlignment(Alignment.left).make());
            this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
            row = TagBuilder.tableRow().make();
            row.addInnerTag(TagBuilder.tableCell().withEscapedText("generated on").withAlignment(Alignment.right).make());
            row.addInnerTag(TagBuilder.tableCell().withEscapedText(crawlInfo.getCrawlTimestamp()).withAlignment(Alignment.left).make());
            this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
        }
        if (((DiagramOptions)this.options).isShowDatabaseInfo()) {
            row = TagBuilder.tableRow().make();
            row.addInnerTag(TagBuilder.tableCell().withEscapedText("database version").withAlignment(Alignment.right).make());
            row.addInnerTag(TagBuilder.tableCell().withEscapedText(crawlInfo.getDatabaseVersion().toString()).withAlignment(Alignment.left).make());
            this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
        }
    }

    public void handle(DatabaseInfo dbInfo) {
    }

    public void handle(JdbcDriverInfo driverInfo) {
    }

    public void handleHeaderEnd() {
        if (((DiagramOptions)this.options).isNoInfo() && !this.outputOptions.hasTitle()) {
            return;
        }
        this.formattingHelper.append("      </table>").println();
        this.formattingHelper.append("    >").println();
        this.formattingHelper.append("  ];").println();
        this.formattingHelper.println();
    }

    public void handleHeaderStart() {
        if (((DiagramOptions)this.options).isNoInfo() && !this.outputOptions.hasTitle()) {
            return;
        }
        this.formattingHelper.append("  /* ").append("Title Block").append(" -=-=-=-=-=-=-=-=-=-=-=-=-=- */").println();
        this.formattingHelper.append("  graph [ ").println();
        this.formattingHelper.append("    label=<").println();
        this.formattingHelper.append("      <table border=\"1\" cellborder=\"0\" cellspacing=\"0\" color=\"#888888\">").println();
    }

    public void handleInfoEnd() {
    }

    public void handleInfoStart() {
    }

    private String makeGraphvizAttributes(Map<String, String> graphvizAttributes, String prefix) {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, String> entry : graphvizAttributes.entrySet()) {
            String[] key = entry.getKey().split("\\.");
            if (key.length != 2 || !key[0].equals(prefix)) continue;
            buffer.append("    ").append(key[1]).append("=").append("\"").append(entry.getValue()).append("\"").append("\n");
        }
        return buffer.toString();
    }

    private String makeGraphvizHeader() {
        Map<String, String> graphvizAttributes = ((DiagramOptions)this.options).getGraphvizAttributes();
        String graphvizHeaderTemplate = IOUtility.readResourceFully((String)"/dot.header.txt");
        String graphvizHeader = String.format(graphvizHeaderTemplate, this.makeGraphvizAttributes(graphvizAttributes, "graph"), this.makeGraphvizAttributes(graphvizAttributes, "node"), this.makeGraphvizAttributes(graphvizAttributes, "edge"));
        return graphvizHeader;
    }
}

