/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ReplaceAggregatesWithCRVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubstituteExpressionVisitor;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.AggregatorInfoList;

class GroupByNode
extends SingleChildResultSetNode {
    GroupByList groupingList;
    private List<AggregateNode> aggregates;
    private AggregatorInfoList aggInfo;
    FromTable parent;
    private boolean addDistinctAggregate;
    private boolean singleInputRowOptimization;
    private int addDistinctAggregateColumnNum;
    private final boolean isInSortedOrder;
    private ValueNode havingClause;
    private SubqueryList havingSubquerys;

    GroupByNode(ResultSetNode resultSetNode, GroupByList groupByList, List<AggregateNode> list, ValueNode valueNode, SubqueryList subqueryList, int n, ContextManager contextManager) throws StandardException {
        super(resultSetNode, null, contextManager);
        this.setLevel(n);
        this.havingClause = valueNode;
        this.havingSubquerys = subqueryList;
        this.groupingList = groupByList;
        this.aggregates = list;
        this.parent = this;
        ResultColumnList resultColumnList = this.childResult.getResultColumns().copyListAndObjects();
        this.setResultColumns(this.childResult.getResultColumns());
        this.childResult.setResultColumns(resultColumnList);
        this.addAggregates();
        if (this.groupingList != null && this.groupingList.isRollup()) {
            this.getResultColumns().setNullability(true);
            this.parent.getResultColumns().setNullability(true);
        }
        if (!this.addDistinctAggregate && groupByList != null) {
            GroupByColumn groupByColumn;
            int n2;
            ColumnReference[] columnReferenceArray = new ColumnReference[this.groupingList.size()];
            int n3 = this.groupingList.size();
            for (n2 = 0; n2 < n3 && (groupByColumn = (GroupByColumn)this.groupingList.elementAt(n2)).getColumnExpression() instanceof ColumnReference; ++n2) {
                columnReferenceArray[n2] = (ColumnReference)groupByColumn.getColumnExpression();
            }
            this.isInSortedOrder = n2 == n3 && this.childResult.isOrderedOn(columnReferenceArray, true, null);
        } else {
            this.isInSortedOrder = false;
        }
    }

    boolean getIsInSortedOrder() {
        return this.isInSortedOrder;
    }

    private void addAggregates() throws StandardException {
        this.addNewPRNode();
        this.addNewColumnsForAggregation();
        this.addDistinctAggregatesToOrderBy();
    }

    private void addDistinctAggregatesToOrderBy() {
        int n = GroupByNode.numDistinctAggregates(this.aggregates);
        if (n != 0) {
            AggregatorInfo aggregatorInfo = null;
            int n2 = this.aggInfo.size();
            for (int i = 0; i < n2 && !(aggregatorInfo = (AggregatorInfo)this.aggInfo.elementAt(i)).isDistinct(); ++i) {
            }
            this.addDistinctAggregate = true;
            this.addDistinctAggregateColumnNum = aggregatorInfo.getInputColNum();
        }
    }

    private void addNewPRNode() throws StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        for (ResultColumn resultColumn : this.getResultColumns()) {
            if (resultColumn.isGenerated()) continue;
            resultColumnList.addElement(resultColumn);
        }
        resultColumnList.copyOrderBySelect(this.getResultColumns());
        this.parent = new ProjectRestrictNode(this, resultColumnList, null, null, null, this.havingSubquerys, this.tableProperties, this.getContextManager());
        this.childResult.setResultColumns(new ResultColumnList(this.getContextManager()));
        this.setResultColumns(new ResultColumnList(this.getContextManager()));
    }

    private ArrayList<SubstituteExpressionVisitor> addUnAggColumns() throws StandardException {
        ResultColumnList resultColumnList = this.childResult.getResultColumns();
        ResultColumnList resultColumnList2 = this.getResultColumns();
        ArrayList<SubstituteExpressionVisitor> arrayList = new ArrayList<SubstituteExpressionVisitor>();
        ArrayList<SubstituteExpressionVisitor> arrayList2 = null;
        if (this.havingClause != null) {
            arrayList2 = new ArrayList<SubstituteExpressionVisitor>();
        }
        for (GroupByColumn groupByColumn : this.groupingList) {
            ResultColumn resultColumn = new ResultColumn("##UnaggColumn", groupByColumn.getColumnExpression(), this.getContextManager());
            resultColumnList.addElement(resultColumn);
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumn.setVirtualColumnId(resultColumnList.size());
            ResultColumn resultColumn2 = new ResultColumn("##UnaggColumn", groupByColumn.getColumnExpression(), this.getContextManager());
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.markGenerated();
            resultColumn2.bindResultColumnToExpression();
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            VirtualColumnNode virtualColumnNode = new VirtualColumnNode(this, resultColumn2, resultColumnList2.size(), this.getContextManager());
            ValueNode valueNode = groupByColumn.getColumnExpression();
            SubstituteExpressionVisitor substituteExpressionVisitor = new SubstituteExpressionVisitor(valueNode, virtualColumnNode, AggregateNode.class);
            arrayList.add(substituteExpressionVisitor);
            if (this.havingClause != null) {
                SubstituteExpressionVisitor substituteExpressionVisitor2 = new SubstituteExpressionVisitor(valueNode, virtualColumnNode, null);
                arrayList2.add(substituteExpressionVisitor2);
            }
            groupByColumn.setColumnPosition(resultColumnList.size());
        }
        ExpressionSorter expressionSorter = new ExpressionSorter();
        Collections.sort(arrayList, expressionSorter);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.parent.getResultColumns().accept((Visitor)arrayList.get(i));
        }
        if (arrayList2 != null) {
            Collections.sort(arrayList2, expressionSorter);
        }
        return arrayList2;
    }

    private void addNewColumnsForAggregation() throws StandardException {
        this.aggInfo = new AggregatorInfoList();
        ArrayList<SubstituteExpressionVisitor> arrayList = null;
        if (this.groupingList != null) {
            arrayList = this.addUnAggColumns();
        }
        this.addAggregateColumns();
        if (this.havingClause != null) {
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.havingClause.accept(arrayList.get(i));
                }
            }
            CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class, AggregateNode.class);
            this.havingClause.accept(collectNodesVisitor);
            for (ColumnReference columnReference : collectNodesVisitor.getList()) {
                if (columnReference.getGeneratedToReplaceAggregate() || columnReference.getGeneratedToReplaceWindowFunctionCall() || columnReference.getSourceLevel() != this.level) continue;
                throw StandardException.newException("42X24", columnReference.getSQLColumnName());
            }
        }
    }

    private void addAggregateColumns() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        ResultColumnList resultColumnList = this.childResult.getResultColumns();
        ResultColumnList resultColumnList2 = this.getResultColumns();
        LanguageFactory languageFactory = this.getLanguageConnectionContext().getLanguageFactory();
        ReplaceAggregatesWithCRVisitor replaceAggregatesWithCRVisitor = new ReplaceAggregatesWithCRVisitor(new ResultColumnList(this.getContextManager()), ((FromTable)this.childResult).getTableNumber(), ResultSetNode.class);
        this.parent.getResultColumns().accept(replaceAggregatesWithCRVisitor);
        if (this.havingClause != null) {
            replaceAggregatesWithCRVisitor = new ReplaceAggregatesWithCRVisitor(new ResultColumnList(this.getContextManager()), ((FromTable)this.childResult).getTableNumber());
            this.havingClause.accept(replaceAggregatesWithCRVisitor);
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.parent;
            projectRestrictNode.setRestriction(this.havingClause);
        }
        int n = this.aggregates.size();
        for (int i = 0; i < n; ++i) {
            AggregateNode aggregateNode = this.aggregates.get(i);
            ResultColumn resultColumn = new ResultColumn("##aggregate result", aggregateNode.getNewNullResultExpression(), this.getContextManager());
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumnList.addElement(resultColumn);
            resultColumn.setVirtualColumnId(resultColumnList.size());
            int n2 = resultColumn.getVirtualColumnId();
            ColumnReference columnReference = new ColumnReference(resultColumn.getName(), null, this.getContextManager());
            columnReference.setSource(resultColumn);
            columnReference.setNestingLevel(this.getLevel());
            columnReference.setSourceLevel(this.getLevel());
            ResultColumn resultColumn2 = new ResultColumn(resultColumn.getColumnName(), (ValueNode)columnReference, this.getContextManager());
            resultColumn2.markGenerated();
            resultColumn2.bindResultColumnToExpression();
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            columnReference = aggregateNode.getGeneratedRef();
            columnReference.setSource(resultColumn2);
            resultColumn = aggregateNode.getNewExpressionResultColumn(dataDictionary);
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumnList.addElement(resultColumn);
            resultColumn.setVirtualColumnId(resultColumnList.size());
            int n3 = resultColumn.getVirtualColumnId();
            ResultColumn resultColumn3 = new ResultColumn("##aggregate expression", aggregateNode.getNewNullResultExpression(), this.getContextManager());
            resultColumn2 = this.getColumnReference(resultColumn, dataDictionary);
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            resultColumn = aggregateNode.getNewAggregatorResultColumn(dataDictionary);
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumnList.addElement(resultColumn);
            resultColumn.setVirtualColumnId(resultColumnList.size());
            int n4 = resultColumn.getVirtualColumnId();
            resultColumn2 = this.getColumnReference(resultColumn, dataDictionary);
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            ResultColumnList resultColumnList3 = new ResultColumnList(this.getContextManager());
            resultColumnList3.addElement(resultColumn3);
            this.aggInfo.addElement(new AggregatorInfo(aggregateNode.getAggregateName(), aggregateNode.getAggregatorClassName(), n3 - 1, n2 - 1, n4 - 1, aggregateNode.isDistinct(), languageFactory.getResultDescription(resultColumnList3.makeResultDescriptors(), "SELECT")));
        }
    }

    final FromTable getParent() {
        return this.parent;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, optimizablePredicateList, costEstimate, rowOrdering);
        CostEstimate costEstimate2 = super.optimizeIt(optimizer, optimizablePredicateList, costEstimate, rowOrdering);
        return costEstimate2;
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        CostEstimate costEstimate2 = ((Optimizable)((Object)this.childResult)).estimateCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizer, rowOrdering);
        CostEstimate costEstimate3 = this.getCostEstimate(optimizer);
        costEstimate3.setCost(costEstimate2.getEstimatedCost(), costEstimate2.rowCount(), costEstimate2.singleScanRowCount());
        return costEstimate3;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return ((Optimizable)((Object)this.childResult)).pushOptPredicate(optimizablePredicate);
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, predicateList, d);
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.getCostEstimate().setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    @Override
    ResultColumnDescriptor[] makeResultDescriptors() {
        return this.childResult.makeResultDescriptors();
    }

    @Override
    boolean isOneRowResultSet() throws StandardException {
        return this.groupingList == null || this.groupingList.size() == 0;
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        FormatableArrayHolder formatableArrayHolder = activationClassBuilder.getColumnOrdering(this.groupingList);
        if (this.addDistinctAggregate) {
            formatableArrayHolder = activationClassBuilder.addColumnToOrdering(formatableArrayHolder, this.addDistinctAggregateColumnNum);
        }
        int n = activationClassBuilder.addItem(formatableArrayHolder);
        int n2 = activationClassBuilder.addItem(this.aggInfo);
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.childResult.generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.isInSortedOrder);
        methodBuilder.push(n2);
        methodBuilder.push(n);
        methodBuilder.push(activationClassBuilder.addItem(this.getResultColumns().buildRowTemplate()));
        methodBuilder.push(this.getResultColumns().getTotalColumnSize());
        methodBuilder.push(this.getResultSetNumber());
        if (this.groupingList == null || this.groupingList.size() == 0) {
            this.genScalarAggregateResultSet(activationClassBuilder, methodBuilder);
        } else {
            this.genGroupedAggregateResultSet(activationClassBuilder, methodBuilder);
        }
    }

    private void genScalarAggregateResultSet(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) {
        String string = this.addDistinctAggregate ? "getDistinctScalarAggregateResultSet" : "getScalarAggregateResultSet";
        methodBuilder.push(this.singleInputRowOptimization);
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.callMethod((short)185, null, string, "org.apache.derby.iapi.sql.execute.NoPutResultSet", 10);
    }

    private void genGroupedAggregateResultSet(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String string = this.addDistinctAggregate ? "getDistinctGroupedAggregateResultSet" : "getGroupedAggregateResultSet";
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.push(this.groupingList.isRollup());
        methodBuilder.callMethod((short)185, null, string, "org.apache.derby.iapi.sql.execute.NoPutResultSet", 10);
    }

    private ResultColumn getColumnReference(ResultColumn resultColumn, DataDictionary dataDictionary) throws StandardException {
        ColumnReference columnReference = new ColumnReference(resultColumn.getName(), null, this.getContextManager());
        columnReference.setSource(resultColumn);
        columnReference.setNestingLevel(this.getLevel());
        columnReference.setSourceLevel(this.getLevel());
        ResultColumn resultColumn2 = new ResultColumn(resultColumn.getColumnName(), (ValueNode)columnReference, this.getContextManager());
        resultColumn2.markGenerated();
        resultColumn2.bindResultColumnToExpression();
        return resultColumn2;
    }

    void considerPostOptimizeOptimizations(boolean bl) throws StandardException {
        AggregateNode aggregateNode;
        AggregateDefinition aggregateDefinition;
        if (this.groupingList == null && this.aggregates.size() == 1 && (aggregateDefinition = (aggregateNode = this.aggregates.get(0)).getAggregateDefinition()) instanceof MaxMinAggregateDefinition) {
            if (aggregateNode.getOperand() instanceof ColumnReference) {
                ArrayList<FromBaseTable> arrayList;
                ColumnReference[] columnReferenceArray = new ColumnReference[]{(ColumnReference)aggregateNode.getOperand()};
                boolean bl2 = this.isOrderedOn(columnReferenceArray, false, arrayList = new ArrayList<FromBaseTable>(1));
                if (bl2) {
                    boolean bl3 = true;
                    int n = columnReferenceArray[0].getColumnNumber();
                    AccessPath accessPath = this.getTrulyTheBestAccessPath();
                    if (accessPath == null || accessPath.getConglomerateDescriptor() == null || accessPath.getConglomerateDescriptor().getIndexDescriptor() == null) {
                        return;
                    }
                    IndexRowGenerator indexRowGenerator = accessPath.getConglomerateDescriptor().getIndexDescriptor();
                    int[] nArray = indexRowGenerator.baseColumnPositions();
                    boolean[] blArray = indexRowGenerator.isAscending();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (n != nArray[i]) continue;
                        if (blArray[i]) break;
                        bl3 = false;
                        break;
                    }
                    FromBaseTable fromBaseTable = arrayList.get(0);
                    MaxMinAggregateDefinition maxMinAggregateDefinition = (MaxMinAggregateDefinition)aggregateDefinition;
                    if (!maxMinAggregateDefinition.isMax() && bl3 || maxMinAggregateDefinition.isMax() && !bl3) {
                        fromBaseTable.disableBulkFetch();
                        this.singleInputRowOptimization = true;
                    } else if (!bl && (maxMinAggregateDefinition.isMax() && bl3 || !maxMinAggregateDefinition.isMax() && !bl3)) {
                        fromBaseTable.disableBulkFetch();
                        fromBaseTable.doSpecialMaxScan();
                        this.singleInputRowOptimization = true;
                    }
                }
            } else if (aggregateNode.getOperand() instanceof ConstantNode) {
                this.singleInputRowOptimization = true;
            }
        }
    }

    private static class ExpressionSorter
    implements Comparator<SubstituteExpressionVisitor> {
        private ExpressionSorter() {
        }

        @Override
        public int compare(SubstituteExpressionVisitor substituteExpressionVisitor, SubstituteExpressionVisitor substituteExpressionVisitor2) {
            try {
                ValueNode valueNode = substituteExpressionVisitor.getSource();
                ValueNode valueNode2 = substituteExpressionVisitor2.getSource();
                CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
                valueNode.accept(collectNodesVisitor);
                int n = collectNodesVisitor.getList().size();
                collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
                valueNode2.accept(collectNodesVisitor);
                int n2 = collectNodesVisitor.getList().size();
                return n2 - n;
            }
            catch (StandardException standardException) {
                throw new RuntimeException(standardException);
            }
        }
    }
}

