/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.shell;

import java.util.Collection;
import picocli.CommandLine;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.CommandRegistry;
import us.fatehi.utility.Utility;

@CommandLine.Command(name="commands", header={"** List available SchemaCrawler commands"}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"commands"}, optionListHeading="Options:%n")
public class AvailableCommandsCommand
implements Runnable {
    private static String availableCommandsDescriptive() {
        CommandLine.Help.ColorScheme.Builder colorSchemaBuilder = new CommandLine.Help.ColorScheme.Builder();
        colorSchemaBuilder.ansi(CommandLine.Help.Ansi.OFF);
        CommandLine.Help.TextTable textTable = CommandLine.Help.TextTable.forColumns((CommandLine.Help.ColorScheme)colorSchemaBuilder.build(), (CommandLine.Help.Column[])new CommandLine.Help.Column[]{new CommandLine.Help.Column(15, 1, CommandLine.Help.Column.Overflow.SPAN), new CommandLine.Help.Column(65, 1, CommandLine.Help.Column.Overflow.WRAP)});
        Collection commandDescriptions = CommandRegistry.getCommandRegistry().getSupportedCommands();
        commandDescriptions.add(new CommandDescription("<query_name>", "Shows results of query <query_name>, as specified in the configuration properties file"));
        commandDescriptions.add(new CommandDescription("<query>", String.join((CharSequence)"\n", "Shows results of SQL <query>", "The query itself can contain the variables ${table}, ${columns} and ${tabletype}, or system properties referenced as ${<system-property-name>}", "Queries without any variables are executed exactly once", "Queries with variables are executed once for each table, with the variables substituted")));
        for (CommandDescription commandDescription : commandDescriptions) {
            textTable.addRowValues(new String[]{commandDescription.getName(), commandDescription.getDescription()});
        }
        return textTable.toString();
    }

    @Override
    public void run() {
        String availableCommands = AvailableCommandsCommand.availableCommandsDescriptive();
        if (!Utility.isBlank((CharSequence)availableCommands)) {
            System.out.println();
            System.out.println("Available SchemaCrawler commands:");
            System.out.println(availableCommands);
            System.out.println("Notes:");
            System.out.println("- For help on an individual SchemaCrawler command,");
            System.out.println("  run SchemaCrawler with options like: `-h command:schema`");
            System.out.println("  or from the SchemaCrawler interactive shell: `help command:schema`");
            System.out.println("- Options for the commands should be provided with the `execute` command");
        }
    }
}

