/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.utility;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class CommandLineConfigUtility {
    private static final Logger LOGGER = Logger.getLogger(CommandLineConfigUtility.class.getName());

    public static Map<String, Object> loadConfig() {
        ConfigFactory.invalidateCaches();
        Config config = CommandLineConfigUtility.loadConfig("schemacrawler.config");
        Config colormapConfig = CommandLineConfigUtility.loadConfig("schemacrawler.colormap");
        Config totalConfig = config.withValue("schemacrawler.format.color_map", (ConfigValue)ConfigValueFactory.fromMap((Map)colormapConfig.root().unwrapped())).withFallback((ConfigMergeable)ConfigFactory.load()).resolve();
        LOGGER.log(Level.FINE, () -> totalConfig.root().render());
        Map<String, Object> configMap = totalConfig.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ConfigValue)entry.getValue()).unwrapped()));
        return configMap;
    }

    private static Config loadConfig(String baseName) {
        ConfigParseOptions configParseOptions = ConfigParseOptions.defaults().setAllowMissing(true);
        Config config = ConfigFactory.parseFileAnySyntax((File)new File(baseName), (ConfigParseOptions)configParseOptions).withFallback((ConfigMergeable)ConfigFactory.parseResourcesAnySyntax((String)baseName, (ConfigParseOptions)configParseOptions));
        LOGGER.log(Level.CONFIG, () -> config.root().render());
        return config;
    }

    private CommandLineConfigUtility() {
    }
}

