/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.IServiceProperties;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.gds.ng.wire.WireServiceConnection;

public final class FbWireDatabaseFactory
implements FbDatabaseFactory {
    private static final FbWireDatabaseFactory INSTANCE = new FbWireDatabaseFactory();

    @Override
    public FbWireDatabase connect(IConnectionProperties connectionProperties) throws SQLException {
        WireDatabaseConnection connection = new WireDatabaseConnection(connectionProperties);
        return this.performConnect(connection);
    }

    @Override
    public FbService serviceConnect(IServiceProperties serviceProperties) throws SQLException {
        WireServiceConnection connection = new WireServiceConnection(serviceProperties);
        return this.performConnect(connection);
    }

    private <T extends FbWireAttachment> T performConnect(WireConnection<?, T> connection) throws SQLException {
        try {
            connection.socketConnect();
            return (T)connection.identify();
        }
        catch (SQLException ex) {
            try {
                connection.close();
            }
            catch (IOException ioex) {
                ex.setNextException(new SQLException(ioex.getMessage(), ioex));
            }
            throw ex;
        }
    }

    public static FbWireDatabaseFactory getInstance() {
        return INSTANCE;
    }
}

