/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class DoubleToRealConverter
extends AbstractArrowVectorConverter {
    private Float8Vector float8Vector;
    private ByteBuffer byteBuf = ByteBuffer.allocate(8);

    public DoubleToRealConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.REAL.name(), fieldVector, columnIndex, context);
        this.float8Vector = (Float8Vector)fieldVector;
    }

    @Override
    public double toDouble(int index) {
        if (this.float8Vector.isNull(index)) {
            return 0.0;
        }
        return this.float8Vector.getDataBuffer().getDouble(index * 8);
    }

    @Override
    public byte[] toBytes(int index) {
        if (this.isNull(index)) {
            return null;
        }
        this.byteBuf.putDouble(0, this.toDouble(index));
        return this.byteBuf.array();
    }

    @Override
    public float toFloat(int index) {
        return (float)this.toDouble(index);
    }

    @Override
    public Object toObject(int index) {
        return this.isNull(index) ? null : Double.valueOf(this.toDouble(index));
    }

    @Override
    public String toString(int index) {
        return this.isNull(index) ? null : String.valueOf(this.toDouble(index));
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        if (this.isNull(index)) {
            return false;
        }
        double val = this.toDouble(index);
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "boolean", val);
    }

    @Override
    public short toShort(int rowIndex) throws SFException {
        try {
            if (this.isNull(rowIndex)) {
                return 0;
            }
            return (short)this.toDouble(rowIndex);
        }
        catch (ClassCastException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "short", this.toObject(rowIndex));
        }
    }

    @Override
    public int toInt(int rowIndex) throws SFException {
        try {
            if (this.isNull(rowIndex)) {
                return 0;
            }
            return (int)this.toDouble(rowIndex);
        }
        catch (ClassCastException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "int", this.toObject(rowIndex));
        }
    }

    @Override
    public long toLong(int rowIndex) throws SFException {
        try {
            if (this.isNull(rowIndex)) {
                return 0L;
            }
            return (long)this.toDouble(rowIndex);
        }
        catch (ClassCastException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "long", this.toObject(rowIndex));
        }
    }

    @Override
    public BigDecimal toBigDecimal(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return null;
        }
        return BigDecimal.valueOf(this.toDouble(rowIndex));
    }
}

