/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal;

import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceRequest;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkTestInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.internal.SdkPredicate;
import net.snowflake.client.jdbc.internal.amazonaws.retry.RetryPolicy;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.CompleteMultipartUploadRetryablePredicate;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.AmazonS3Exception;
import net.snowflake.client.jdbc.internal.amazonaws.util.ValidationUtils;

public class CompleteMultipartUploadRetryCondition
implements RetryPolicy.RetryCondition {
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private final SdkPredicate<AmazonS3Exception> completeMultipartRetryablePredicate;
    private final int maxCompleteMultipartUploadRetries;

    public CompleteMultipartUploadRetryCondition() {
        this(new CompleteMultipartUploadRetryablePredicate(), 3);
    }

    @SdkTestInternalApi
    CompleteMultipartUploadRetryCondition(SdkPredicate<AmazonS3Exception> predicate, int maxRetryAttempts) {
        ValidationUtils.assertNotNull(predicate, "sdk predicate");
        this.completeMultipartRetryablePredicate = predicate;
        this.maxCompleteMultipartUploadRetries = maxRetryAttempts;
    }

    @Override
    public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
        if (exception instanceof AmazonS3Exception) {
            return this.completeMultipartRetryablePredicate.test((AmazonS3Exception)exception) && retriesAttempted < this.maxCompleteMultipartUploadRetries;
        }
        return false;
    }
}

