/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob;

import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.internal.apache.commons.lang3.tuple.Pair;
import net.snowflake.client.jdbc.internal.microsoft.azure.keyvault.core.IKey;
import net.snowflake.client.jdbc.internal.microsoft.azure.keyvault.core.IKeyResolver;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobDecryptStream;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobEncryptionData;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobRequestOptions;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobType;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlob;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.EncryptionAgent;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.EncryptionAlgorithm;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.WrappedContentKey;

public final class BlobEncryptionPolicy {
    public IKeyResolver keyResolver;
    public IKey keyWrapper;

    public BlobEncryptionPolicy(IKey key, IKeyResolver keyResolver) {
        this.keyWrapper = key;
        this.keyResolver = keyResolver;
    }

    public IKey getKey() {
        return this.keyWrapper;
    }

    public IKeyResolver getKeyResolver() {
        return this.keyResolver;
    }

    public void setKey(IKey key) {
        this.keyWrapper = key;
    }

    public void setKeyResolver(IKeyResolver keyResolver) {
        this.keyResolver = keyResolver;
    }

    OutputStream decryptBlob(OutputStream userProvidedStream, Map<String, String> metadata, Boolean requireEncryption, byte[] iv, boolean noPadding) throws StorageException {
        Utility.assertNotNull("metadata", metadata);
        String encryptionDataString = metadata.get("encryptiondata");
        if (requireEncryption != null && requireEncryption.booleanValue() && encryptionDataString == null) {
            throw new StorageException("DecryptionError", "Encryption data does not exist. If you do not want to decrypt the data, please do not set the require encryption flag on request options", null);
        }
        try {
            if (encryptionDataString != null) {
                BlobEncryptionData encryptionData = BlobEncryptionData.deserialize(encryptionDataString);
                Utility.assertNotNull("encryptionData", encryptionData);
                Utility.assertNotNull("contentEncryptionIV", encryptionData.getContentEncryptionIV());
                Utility.assertNotNull("encryptedKey", encryptionData.getWrappedContentKey().getEncryptedKey());
                if (!"1.0".equals(encryptionData.getEncryptionAgent().getProtocol())) {
                    throw new StorageException("DecryptionError", "Invalid Encryption Agent. This version of the client library does not understand the Encryption Agent set on the blob.", null);
                }
                if (this.keyWrapper == null && this.keyResolver == null) {
                    throw new StorageException("DecryptionError", "Key and Resolver are not initialized. Decryption requires either of them to be initialized.", null);
                }
                byte[] contentEncryptionKey = null;
                if (this.keyResolver != null) {
                    IKey keyEncryptionKey = this.keyResolver.resolveKeyAsync(encryptionData.getWrappedContentKey().getKeyId()).get();
                    Utility.assertNotNull("keyEncryptionKey", keyEncryptionKey);
                    contentEncryptionKey = keyEncryptionKey.unwrapKeyAsync(encryptionData.getWrappedContentKey().getEncryptedKey(), encryptionData.getWrappedContentKey().getAlgorithm()).get();
                } else if (encryptionData.getWrappedContentKey().getKeyId().equals(this.keyWrapper.getKid())) {
                    contentEncryptionKey = this.keyWrapper.unwrapKeyAsync(encryptionData.getWrappedContentKey().getEncryptedKey(), encryptionData.getWrappedContentKey().getAlgorithm()).get();
                } else {
                    throw new StorageException("DecryptionError", "Key mismatch. The key id stored on the service does not match the specified key.", null);
                }
                switch (encryptionData.getEncryptionAgent().getEncryptionAlgorithm()) {
                    case AES_CBC_256: {
                        Cipher myAes = noPadding ? Cipher.getInstance("AES/CBC/NoPadding") : Cipher.getInstance("AES/CBC/PKCS5Padding");
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv != null ? iv : encryptionData.getContentEncryptionIV());
                        SecretKeySpec keySpec = new SecretKeySpec(contentEncryptionKey, 0, contentEncryptionKey.length, "AES");
                        myAes.init(2, (Key)keySpec, ivParameterSpec);
                        return new CipherOutputStream(userProvidedStream, myAes);
                    }
                }
                throw new StorageException("DecryptionError", "Invalid Encryption Algorithm found on the resource. This version of the client library does not support the specified encryption algorithm.", null);
            }
            return userProvidedStream;
        }
        catch (StorageException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new StorageException("DecryptionError", "Decryption logic threw error. Please check the inner exception for more details.", ex);
        }
    }

    static OutputStream wrapUserStreamWithDecryptStream(CloudBlob blob, OutputStream userProvidedStream, BlobRequestOptions options, Map<String, String> metadata, long blobLength, boolean rangeRead, Long endOffset, Long userSpecifiedLength, int discardFirst, boolean bufferIV) throws StorageException {
        if (!rangeRead) {
            OutputStream decryptStream = options.getEncryptionPolicy().decryptBlob(userProvidedStream, metadata, options.requireEncryption(), null, blob.getProperties().getBlobType() == BlobType.PAGE_BLOB);
            return decryptStream;
        }
        boolean noPadding = blob.getProperties().getBlobType() == BlobType.PAGE_BLOB || endOffset != null && endOffset < blobLength - 16L;
        return new BlobDecryptStream(userProvidedStream, metadata, userSpecifiedLength, discardFirst, bufferIV, noPadding, options.getEncryptionPolicy(), options.requireEncryption());
    }

    Cipher createAndSetEncryptionContext(Map<String, String> metadata, boolean noPadding) throws StorageException {
        Utility.assertNotNull("metadata", metadata);
        if (this.keyWrapper == null) {
            throw new IllegalArgumentException("Key is not initialized. Encryption requires it to be initialized.");
        }
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            Cipher myAes = noPadding ? Cipher.getInstance("AES/CBC/NoPadding") : Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKey aesKey = keyGen.generateKey();
            myAes.init(1, aesKey);
            BlobEncryptionData encryptionData = new BlobEncryptionData();
            if (encryptionData.getKeyWrappingMetadata() == null) {
                encryptionData.setKeyWrappingMetadata(new HashMap<String, String>());
            }
            encryptionData.getKeyWrappingMetadata().put("EncryptionLibrary", "Java 5.0.0");
            encryptionData.setEncryptionAgent(new EncryptionAgent("1.0", EncryptionAlgorithm.AES_CBC_256));
            Pair<byte[], String> encryptedKey = this.keyWrapper.wrapKeyAsync(aesKey.getEncoded(), null).get();
            encryptionData.setWrappedContentKey(new WrappedContentKey(this.keyWrapper.getKid(), (byte[])encryptedKey.getKey(), (String)encryptedKey.getValue()));
            encryptionData.setContentEncryptionIV(myAes.getIV());
            metadata.put("encryptiondata", encryptionData.serialize());
            return myAes;
        }
        catch (Exception e) {
            throw StorageException.translateClientException(e);
        }
    }
}

