/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.InternalPluginException;
import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazon.redshift.plugin.httpserver.RequestHandler;
import com.amazon.redshift.plugin.httpserver.Server;
import com.amazon.redshift.plugin.utils.CheckUtils;
import com.amazon.redshift.plugin.utils.RandomStateUtil;
import com.amazon.redshift.plugin.utils.ResponseUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;

public class BrowserAzureCredentialsProvider
extends SamlCredentialsProvider {
    public static final String KEY_IDP_RESPONSE_TIMEOUT = "idp_response_timeout";
    public static final String KEY_LISTEN_PORT = "listen_port";
    public static final String KEY_IDP_TENANT = "idp_tenant";
    public static final String KEY_CLIENT_ID = "client_id";
    public static final String OAUTH_STATE_PARAMETER_NAME = "state";
    public static final String OAUTH_REDIRECT_PARAMETER_NAME = "redirect_uri";
    public static final String OAUTH_IDP_CODE_PARAMETER_NAME = "code";
    public static final String OAUTH_CLIENT_ID_PARAMETER_NAME = "client_id";
    public static final String OAUTH_RESPONSE_TYPE_PARAMETER_NAME = "response_type";
    public static final String OAUTH_REQUESTED_TOKEN_TYPE_PARAMETER_NAME = "requested_token_type";
    public static final String OAUTH_GRANT_TYPE_PARAMETER_NAME = "grant_type";
    public static final String OAUTH_SCOPE_PARAMETER_NAME = "scope";
    public static final String OAUTH_RESOURCE_PARAMETER_NAME = "resource";
    public static final String OAUTH_RESPONSE_MODE_PARAMETER_NAME = "response_mode";
    private static final String MICROSOFT_IDP_HOST = "login.microsoftonline.com";
    private static final String CURRENT_INTERACTION_SCHEMA = "https";
    private String m_idp_tenant;
    private String m_clientId;
    private int m_idp_response_timeout = 120;
    private int m_listen_port = 0;
    private String redirectUri;

    @Override
    protected String getSamlAssertion() throws IOException {
        try {
            CheckUtils.checkMissingAndThrows(this.m_idp_tenant, KEY_IDP_TENANT);
            CheckUtils.checkMissingAndThrows(this.m_clientId, "client_id");
            CheckUtils.checkAndThrowsWithMessage(this.m_idp_response_timeout < 10, "idp_response_timeout should be 10 seconds or greater.");
            CheckUtils.checkInvalidAndThrows(this.m_listen_port != 0 && (this.m_listen_port < 1 || this.m_listen_port > 65535), KEY_LISTEN_PORT);
            if (this.m_listen_port == 0) {
                this.m_log.logDebug("Listen port set to 0. Will pick random port", new Object[0]);
            }
            String token = this.fetchAuthorizationToken();
            String content = this.fetchSamlResponse(token);
            String samlAssertion = this.extractSamlAssertion(content);
            return this.wrapAndEncodeAssertion(samlAssertion);
        }
        catch (InternalPluginException | URISyntaxException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logError(ex);
            }
            throw new IOException(ex);
        }
    }

    @Override
    public void addParameter(String key, String value) {
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("key: {0}", key);
        }
        switch (key) {
            case "idp_tenant": {
                this.m_idp_tenant = value;
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("m_idp_tenant: {0}", this.m_idp_tenant);
                break;
            }
            case "client_id": {
                this.m_clientId = value;
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("m_clientId: {0}", this.m_clientId);
                break;
            }
            case "idp_response_timeout": {
                this.m_idp_response_timeout = Integer.parseInt(value);
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("m_idp_response_timeout: {0}", this.m_idp_response_timeout);
                break;
            }
            case "listen_port": {
                this.m_listen_port = Integer.parseInt(value);
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("m_listen_port: {0}", this.m_listen_port);
                break;
            }
            default: {
                super.addParameter(key, value);
            }
        }
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return (this.m_idp_tenant != null ? this.m_idp_tenant : "") + (this.m_clientId != null ? this.m_clientId : "");
    }

    private String fetchAuthorizationToken() throws IOException, URISyntaxException {
        final String state = RandomStateUtil.generateRandomState();
        RequestHandler requestHandler = new RequestHandler(new Function<List<NameValuePair>, Object>(){

            @Override
            public Object apply(List<NameValuePair> nameValuePairs) {
                String incomingState = ResponseUtils.findParameter(BrowserAzureCredentialsProvider.OAUTH_STATE_PARAMETER_NAME, nameValuePairs);
                if (!state.equals(incomingState)) {
                    return new InternalPluginException("Incoming state " + incomingState + " does not match the outgoing state " + state);
                }
                String code = ResponseUtils.findParameter(BrowserAzureCredentialsProvider.OAUTH_IDP_CODE_PARAMETER_NAME, nameValuePairs);
                if (StringUtils.isNullOrEmpty((String)code)) {
                    return new InternalPluginException("No valid code found");
                }
                return code;
            }
        });
        Server server = new Server(this.m_listen_port, requestHandler, Duration.ofSeconds(this.m_idp_response_timeout), this.m_log);
        server.listen();
        int localPort = server.getLocalPort();
        this.redirectUri = "http://localhost:" + localPort + "/redshift/";
        try {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.DEBUG, String.format("Listening for connection on port %d", this.m_listen_port), new Object[0]);
            }
            this.openBrowser(state);
            server.waitForResult();
        }
        catch (IOException | URISyntaxException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logError(ex);
            }
            server.stop();
            throw ex;
        }
        Object result = requestHandler.getResult();
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("result: {0}", result);
        }
        if (result instanceof InternalPluginException) {
            throw (InternalPluginException)result;
        }
        if (result instanceof String) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.DEBUG, "Got SAML assertion", new Object[0]);
            }
            return (String)result;
        }
        throw new InternalPluginException("Fail to login during timeout.");
    }

    private String wrapAndEncodeAssertion(String samlAssertion) {
        String samlAssertionString = "<samlp:Response xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"><samlp:Status><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/></samlp:Status>" + samlAssertion + "</samlp:Response>";
        return org.apache.commons.codec.binary.StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])samlAssertionString.getBytes()));
    }

    /*
     * Exception decompiling
     */
    private String fetchSamlResponse(String token) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String extractSamlAssertion(String content) {
        JsonNode accessTokenField;
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("content: {0}", content);
        }
        CheckUtils.checkAndThrowsWithMessage((accessTokenField = Jackson.jsonNodeOf((String)content).findValue("access_token")) == null, "Failed to find access_token");
        String encodedSamlAssertion = accessTokenField.textValue();
        CheckUtils.checkAndThrowsWithMessage(StringUtils.isNullOrEmpty((String)encodedSamlAssertion), "Invalid access_token value.");
        if (RedshiftLogger.isEnable()) {
            this.m_log.log(LogLevel.DEBUG, "Successfully got SAML assertion", new Object[0]);
        }
        return org.apache.commons.codec.binary.StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)encodedSamlAssertion));
    }

    private HttpPost createAuthorizationRequest(String authorizationCode) throws IOException {
        URIBuilder builder = new URIBuilder().setScheme(CURRENT_INTERACTION_SCHEMA).setHost(MICROSOFT_IDP_HOST).setPath("/" + this.m_idp_tenant + "/oauth2/token");
        String tokenRequestUrl = builder.toString();
        this.validateURL(tokenRequestUrl);
        HttpPost post = new HttpPost(tokenRequestUrl);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair(OAUTH_IDP_CODE_PARAMETER_NAME, authorizationCode));
        parameters.add(new BasicNameValuePair(OAUTH_REQUESTED_TOKEN_TYPE_PARAMETER_NAME, "urn:ietf:params:oauth:token-type:saml2"));
        parameters.add(new BasicNameValuePair(OAUTH_GRANT_TYPE_PARAMETER_NAME, "authorization_code"));
        parameters.add(new BasicNameValuePair(OAUTH_SCOPE_PARAMETER_NAME, "openid"));
        parameters.add(new BasicNameValuePair(OAUTH_RESOURCE_PARAMETER_NAME, this.m_clientId));
        parameters.add(new BasicNameValuePair("client_id", this.m_clientId));
        parameters.add(new BasicNameValuePair(OAUTH_REDIRECT_PARAMETER_NAME, this.redirectUri));
        post.addHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
        post.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8));
        if (RedshiftLogger.isEnable()) {
            this.m_log.log(LogLevel.DEBUG, String.format("Request token URI: \n%s\nRequest parameters:\n%s", tokenRequestUrl, Arrays.toString(parameters.toArray())), new Object[0]);
        }
        return post;
    }

    private void openBrowser(String state) throws URISyntaxException, IOException {
        URIBuilder builder = new URIBuilder().setScheme(CURRENT_INTERACTION_SCHEMA).setHost(MICROSOFT_IDP_HOST).setPath("/" + this.m_idp_tenant + "/oauth2/authorize").addParameter(OAUTH_SCOPE_PARAMETER_NAME, "openid").addParameter(OAUTH_RESPONSE_TYPE_PARAMETER_NAME, OAUTH_IDP_CODE_PARAMETER_NAME).addParameter(OAUTH_RESPONSE_MODE_PARAMETER_NAME, "form_post").addParameter("client_id", this.m_clientId).addParameter(OAUTH_REDIRECT_PARAMETER_NAME, this.redirectUri).addParameter(OAUTH_STATE_PARAMETER_NAME, state);
        URI authorizeRequestUrl = builder.build();
        this.validateURL(authorizeRequestUrl.toString());
        Desktop.getDesktop().browse(authorizeRequestUrl);
        if (RedshiftLogger.isEnable()) {
            this.m_log.log(LogLevel.DEBUG, String.format("Authorization code request URI: \n%s", authorizeRequestUrl.toString()), new Object[0]);
        }
    }
}

