/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.jdbc.diagnostics.EncryptionStream;
import oracle.jdbc.diagnostics.MessageFormatUtils;
import oracle.jdbc.diagnostics.Releaser;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.diagnostics.SecuredLoggerImpl;
import oracle.jdbc.internal.Monitor;

final class SecuredMemoryLogHandler
extends Handler
implements Monitor {
    private final String loggerId;
    private final X509Certificate certificate;
    private String dumpFileLocation;
    private int bufferMaxSize = 10000;
    private boolean isOpen = false;
    private Object[] buffer;
    private int head;
    private int tail;
    private int available;
    private ConcurrentHashMap<String, String> headers;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();
    private Properties userProperties = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;

    SecuredMemoryLogHandler(SecuredLoggerImpl securedLogger) {
        this.loggerId = securedLogger.getId();
        this.certificate = securedLogger.getCertificate();
        this.headers = securedLogger.getHeaders();
        this.userProperties = securedLogger.getUserProperties();
        this.configure();
        this.available = this.bufferMaxSize;
        if (this.dumpFileLocation != null) {
            this.buffer = new Object[this.bufferMaxSize];
            this.isOpen = true;
        } else {
            this.isOpen = false;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    public boolean isEmpty() {
        return this.available == this.bufferMaxSize;
    }

    private void configure() {
        String cname = SecuredLogger.class.getName();
        this.dumpFileLocation = SecuredLogger.getStringProperty(cname + ".logLocation", SecuredLogger.DEFAULT_LOG_LOCATION, this.userProperties);
        this.setFilter(SecuredLogger.getFilterProperty(cname + ".filter", SecuredLogger.DEFAULT_FILTER, this.userProperties));
        this.setFormatter(SecuredLogger.getFormatterProperty(cname + ".formatter", new SimpleFormatter(), this.userProperties));
        try {
            this.setEncoding(SecuredLogger.getStringProperty(cname + ".encoding", null, this.userProperties));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.addEvent(logLevel, eventId, logTime, className, methodName, debugMsg, null, 0);
        }
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Object debugMsgParam1, Releaser releaser) {
        boolean isEventAdded;
        if (!this.isOpen) {
            return;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            isEventAdded = this.addEvent(logLevel, eventId, logTime, className, methodName, debugMsg, releaser, 1);
            if (isEventAdded) {
                this.addToBuffer(debugMsgParam1);
            }
        }
        if (!isEventAdded && releaser != null) {
            this.releaseParam(releaser, 1, debugMsgParam1);
        }
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2, Releaser releaser) {
        boolean isEventAdded;
        if (!this.isOpen) {
            return;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            isEventAdded = this.addEvent(logLevel, eventId, logTime, className, methodName, debugMsg, releaser, 2);
            if (isEventAdded) {
                this.addToBuffer(debugMsgParam1);
                this.addToBuffer(debugMsgParam2);
            }
        }
        if (!isEventAdded && releaser != null) {
            this.releaseParam(releaser, 1, debugMsgParam1);
            this.releaseParam(releaser, 2, debugMsgParam2);
        }
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2, Object debugMsgParam3, Releaser releaser) {
        boolean isEventAdded;
        if (!this.isOpen) {
            return;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            isEventAdded = this.addEvent(logLevel, eventId, logTime, className, methodName, debugMsg, releaser, 3);
            if (isEventAdded) {
                this.addToBuffer(debugMsgParam1);
                this.addToBuffer(debugMsgParam2);
                this.addToBuffer(debugMsgParam3);
            }
        }
        if (!isEventAdded && releaser != null) {
            this.releaseParam(releaser, 1, debugMsgParam1);
            this.releaseParam(releaser, 2, debugMsgParam2);
            this.releaseParam(releaser, 3, debugMsgParam3);
        }
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2, Object debugMsgParam3, Object debugMsgParam4, Releaser releaser) {
        boolean isEventAdded;
        if (!this.isOpen) {
            return;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            isEventAdded = this.addEvent(logLevel, eventId, logTime, className, methodName, debugMsg, releaser, 4);
            if (isEventAdded) {
                this.addToBuffer(debugMsgParam1);
                this.addToBuffer(debugMsgParam2);
                this.addToBuffer(debugMsgParam3);
                this.addToBuffer(debugMsgParam4);
            }
        }
        if (!isEventAdded && releaser != null) {
            this.releaseParam(releaser, 1, debugMsgParam1);
            this.releaseParam(releaser, 2, debugMsgParam2);
            this.releaseParam(releaser, 3, debugMsgParam3);
            this.releaseParam(releaser, 4, debugMsgParam4);
        }
    }

    public void add(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Releaser releaser, Object ... debugMsgParams) {
        boolean isEventAdded;
        if (!this.isOpen) {
            return;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            isEventAdded = this.addEvent(logLevel, eventId, logTime, className, methodName, debugMsg, releaser, 1);
            if (isEventAdded) {
                for (int i2 = 0; i2 < debugMsgParams.length; ++i2) {
                    this.addToBuffer(debugMsgParams[i2]);
                }
            }
        }
        if (!isEventAdded && releaser != null) {
            for (int i3 = 0; i3 < debugMsgParams.length; ++i3) {
                this.releaseParam(releaser, i3 + 1, debugMsgParams[i3]);
            }
        }
    }

    private boolean addEvent(Level logLevel, long eventId, long logTime, String className, String methodName, String debugMsg, Releaser releaser, int noOfMsgParams) {
        int lengthOfDataToBeInserted = 9 + noOfMsgParams;
        if (lengthOfDataToBeInserted > this.bufferMaxSize) {
            throw new RuntimeException("Data length more than buffer length : " + lengthOfDataToBeInserted);
        }
        if (lengthOfDataToBeInserted > this.available) {
            this.free(lengthOfDataToBeInserted - this.available);
        }
        this.addToBuffer(lengthOfDataToBeInserted);
        this.addToBuffer(eventId);
        this.addToBuffer(Thread.currentThread().getId());
        this.addToBuffer(className);
        this.addToBuffer(methodName);
        this.addToBuffer(logLevel);
        this.addToBuffer(logTime);
        this.addToBuffer(debugMsg);
        this.addToBuffer(releaser);
        this.available -= lengthOfDataToBeInserted;
        return true;
    }

    private void releaseResources(Releaser releaser, Object[] buffer, int startIndex, int length) {
        int paramCount = 1;
        int index = startIndex;
        while (paramCount <= length) {
            this.releaseParam(releaser, paramCount++, buffer[index++]);
            if (index != this.bufferMaxSize) continue;
            index = 0;
        }
    }

    private void releaseParam(Releaser releaser, int index, Object param) {
        releaser.release(index, param);
    }

    private void addToBuffer(Object data) {
        this.buffer[this.tail++] = data;
        if (this.tail == this.bufferMaxSize) {
            this.tail = 0;
        }
    }

    private void free(int noOfSpaceNeeded) {
        int spaceFreed;
        int recordLength;
        for (spaceFreed = 0; spaceFreed < noOfSpaceNeeded; spaceFreed += recordLength) {
            recordLength = (Integer)this.buffer[this.head];
            this.head = (this.head + recordLength) % this.bufferMaxSize;
            Object releaser = this.buffer[(this.head + 9 - 1) % this.bufferMaxSize];
            if (releaser == null) continue;
            this.releaseResources((Releaser)releaser, this.buffer, (this.head + 9) % this.bufferMaxSize, recordLength - 9);
        }
        this.available += spaceFreed;
    }

    @Override
    public void close() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.isOpen = false;
        }
        if (!this.isEmpty()) {
            this.free(this.bufferMaxSize - this.available);
        }
        this.buffer = null;
        this.headers.clear();
    }

    public void dumpLog() {
        if (!this.isOpen || this.isEmpty()) {
            return;
        }
        try {
            int noOfObjectsToBeDumped;
            ConcurrentHashMap<String, String> dumpHeaders;
            int dumpBufferTail;
            int dumpBufferHead;
            Object[] dumpBuffer;
            EncryptionStream encStream = this.initializeEncryptionStream();
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                dumpBuffer = this.buffer;
                dumpBufferHead = this.head;
                dumpBufferTail = this.tail;
                dumpHeaders = this.headers;
                noOfObjectsToBeDumped = this.bufferMaxSize - this.available;
                this.reset();
            }
            this.publishHeader(dumpHeaders, encStream);
            this.publishDebugEvents(dumpBuffer, dumpBufferHead, dumpBufferTail, encStream, noOfObjectsToBeDumped);
            encStream.close();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private void publishHeader(ConcurrentHashMap<String, String> dumpHeaders, EncryptionStream encStream) throws Exception {
        StringBuilder sb = new StringBuilder(System.lineSeparator());
        dumpHeaders.forEach((key, value) -> sb.append(key + " = " + value + System.lineSeparator()));
        LogRecord headerRecord = new LogRecord(Level.CONFIG, sb.toString());
        headerRecord.setSourceClassName("Configurations");
        this.publish(headerRecord, encStream);
    }

    private void publishDebugEvents(Object[] dumpBuffer, int head, int tail, EncryptionStream encStream, int noOfObjectsToBeDumped) throws Exception {
        int noOfObjectsWritten;
        int currentHeadIndex = head;
        for (int noOfObjectsToBeWritten = noOfObjectsToBeDumped; noOfObjectsToBeWritten > 0; noOfObjectsToBeWritten -= noOfObjectsWritten) {
            noOfObjectsWritten = this.publishEvent(encStream, dumpBuffer, currentHeadIndex);
            currentHeadIndex = (currentHeadIndex + noOfObjectsWritten) % dumpBuffer.length;
        }
    }

    private int publishEvent(EncryptionStream encStream, Object[] dumpBuffer, int headPosition) throws Exception {
        int recordLength = (Integer)dumpBuffer[headPosition];
        this.publish(this.createLogRecord(headPosition, dumpBuffer, recordLength), encStream);
        Releaser releaser = (Releaser)dumpBuffer[(headPosition + 9 - 1) % this.bufferMaxSize];
        if (releaser != null) {
            this.releaseResources(releaser, dumpBuffer, (headPosition + 9) % dumpBuffer.length, recordLength - 9);
        }
        return recordLength;
    }

    private LogRecord createLogRecord(int startIndex, Object[] dumpBuffer, int recordLength) {
        LogRecord logRecord = new LogRecord((Level)SecuredLogger.Attribute.LOG_LEVEL.getAttributeValue(startIndex, dumpBuffer), (String)SecuredLogger.Attribute.DEBUG_MESSAGE.getAttributeValue(startIndex, dumpBuffer));
        logRecord.setSequenceNumber((Long)SecuredLogger.Attribute.EVENT_ID.getAttributeValue(startIndex, dumpBuffer));
        logRecord.setSourceClassName((String)SecuredLogger.Attribute.CLASS_NAME.getAttributeValue(startIndex, dumpBuffer));
        logRecord.setSourceMethodName((String)SecuredLogger.Attribute.METHOD_NAME.getAttributeValue(startIndex, dumpBuffer));
        logRecord.setThreadID(((Long)SecuredLogger.Attribute.THREAD_ID.getAttributeValue(startIndex, dumpBuffer)).intValue());
        logRecord.setMillis((Long)SecuredLogger.Attribute.EVENT_TIME.getAttributeValue(startIndex, dumpBuffer));
        if (recordLength > 9) {
            logRecord.setParameters(this.getDebugMessageParams(dumpBuffer, startIndex + 9, recordLength - 9));
        }
        return logRecord;
    }

    EncryptionStream initializeEncryptionStream() {
        String fileName = "alert_ojdbc_" + this.loggerId + "_" + System.currentTimeMillis() + ".log";
        try {
            return EncryptionStream.newEncryptionStream(new FileOutputStream(this.dumpFileLocation + fileName), this.certificate);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void publish(LogRecord record) {
        throw new UnsupportedOperationException();
    }

    public void publish(LogRecord record, EncryptionStream encStream) {
        if (!this.getFilter().isLoggable(record)) {
            return;
        }
        try {
            String debugMessage = this.getFormatter().format(record);
            encStream.write(debugMessage.getBytes());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void flush() {
    }

    private Object[] getDebugMessageParams(Object[] buffer, int startIndex, int length) {
        int bufferMaxSize = buffer.length;
        Object[] subArr = new Object[length];
        int noOfObjectsToBeCopied = length;
        int srcIndx = startIndex;
        int destIndx = 0;
        while (noOfObjectsToBeCopied-- > 0) {
            Object curObj = buffer[srcIndx++ % bufferMaxSize];
            subArr[destIndx++] = MessageFormatUtils.formatLogParam(curObj);
        }
        return subArr;
    }

    public void reset() {
        if (this.dumpFileLocation == null) {
            return;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.buffer = new Object[this.bufferMaxSize];
            this.tail = 0;
            this.head = 0;
            this.available = this.bufferMaxSize;
            this.headers = new ConcurrentHashMap();
            this.isOpen = true;
        }
    }

    public void disable() {
        this.close();
    }

    public void enable() {
        this.reset();
    }

    static {
        try {
            $$$methodRef$$$29 = SecuredMemoryLogHandler.class.getDeclaredConstructor(SecuredLoggerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = SecuredMemoryLogHandler.class.getDeclaredMethod("lambda$publishHeader$0", StringBuilder.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = SecuredMemoryLogHandler.class.getDeclaredMethod("enable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = SecuredMemoryLogHandler.class.getDeclaredMethod("disable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = SecuredMemoryLogHandler.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = SecuredMemoryLogHandler.class.getDeclaredMethod("getDebugMessageParams", Object[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = SecuredMemoryLogHandler.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = SecuredMemoryLogHandler.class.getDeclaredMethod("publish", LogRecord.class, EncryptionStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = SecuredMemoryLogHandler.class.getDeclaredMethod("publish", LogRecord.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = SecuredMemoryLogHandler.class.getDeclaredMethod("initializeEncryptionStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = SecuredMemoryLogHandler.class.getDeclaredMethod("createLogRecord", Integer.TYPE, Object[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = SecuredMemoryLogHandler.class.getDeclaredMethod("publishEvent", EncryptionStream.class, Object[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = SecuredMemoryLogHandler.class.getDeclaredMethod("publishDebugEvents", Object[].class, Integer.TYPE, Integer.TYPE, EncryptionStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = SecuredMemoryLogHandler.class.getDeclaredMethod("publishHeader", ConcurrentHashMap.class, EncryptionStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = SecuredMemoryLogHandler.class.getDeclaredMethod("dumpLog", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = SecuredMemoryLogHandler.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = SecuredMemoryLogHandler.class.getDeclaredMethod("free", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = SecuredMemoryLogHandler.class.getDeclaredMethod("addToBuffer", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = SecuredMemoryLogHandler.class.getDeclaredMethod("releaseParam", Releaser.class, Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = SecuredMemoryLogHandler.class.getDeclaredMethod("releaseResources", Releaser.class, Object[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = SecuredMemoryLogHandler.class.getDeclaredMethod("addEvent", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Releaser.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Releaser.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Object.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = SecuredMemoryLogHandler.class.getDeclaredMethod("configure", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = SecuredMemoryLogHandler.class.getDeclaredMethod("isEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = SecuredMemoryLogHandler.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

