/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.security.auth.DestroyFailedException;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;

class OpaquePrivateKey {
    private final OpaqueString opaqueEncoding;
    private static final byte[] BEGIN_PRIVATE_KEY_UTF8;
    private static final byte[] END_PRIVATE_KEY_UTF8;
    private static final byte[] LINE_SEPARATOR;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OpaquePrivateKey fromPemFile(Path path) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] pemBytes = Files.readAllBytes(path);
        try {
            OpaquePrivateKey opaquePrivateKey;
            int beginTagOffset = OpaquePrivateKey.findTag(pemBytes, 0, BEGIN_PRIVATE_KEY_UTF8);
            if (beginTagOffset == -1) {
                throw new IOException(path + " does not contain " + new String(BEGIN_PRIVATE_KEY_UTF8, StandardCharsets.UTF_8));
            }
            int payloadOffset = beginTagOffset + BEGIN_PRIVATE_KEY_UTF8.length + LINE_SEPARATOR.length;
            int endTagOffset = OpaquePrivateKey.findTag(pemBytes, payloadOffset, END_PRIVATE_KEY_UTF8);
            if (endTagOffset == -1) {
                throw new IOException(path + " does not contain " + new String(END_PRIVATE_KEY_UTF8, StandardCharsets.UTF_8));
            }
            byte[] base64Key = Arrays.copyOfRange(pemBytes, payloadOffset, endTagOffset);
            try {
                opaquePrivateKey = new OpaquePrivateKey(OpaquePrivateKey.decodeBase64Key(base64Key));
            }
            catch (Throwable throwable) {
                Arrays.fill(base64Key, (byte)0);
                throw throwable;
            }
            Arrays.fill(base64Key, (byte)0);
            return opaquePrivateKey;
        }
        finally {
            Arrays.fill(pemBytes, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static OpaqueString decodeBase64Key(byte[] base64Key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encodedKey = Base64.getMimeDecoder().decode(base64Key);
        try {
            OpaqueString opaqueString;
            PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
            try {
                opaqueString = OpaquePrivateKey.encodeKey(privateKey);
            }
            catch (Throwable throwable) {
                OpaquePrivateKey.tryDestroyKey(privateKey);
                throw throwable;
            }
            OpaquePrivateKey.tryDestroyKey(privateKey);
            return opaqueString;
        }
        finally {
            Arrays.fill(encodedKey, (byte)0);
        }
    }

    private OpaquePrivateKey(@Blind OpaqueString opaqueEncoding) {
        this.opaqueEncoding = opaqueEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    public static OpaqueString encodeKey(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encoded = KeyFactory.getInstance("RSA").getKeySpec(privateKey, PKCS8EncodedKeySpec.class).getEncoded();
        try {
            char[] encodedChars = new char[encoded.length];
            for (int i2 = 0; i2 < encoded.length; ++i2) {
                encodedChars[i2] = (char)encoded[i2];
            }
            OpaqueString opaqueString = OpaqueString.newOpaqueString(encodedChars);
            return opaqueString;
        }
        finally {
            Arrays.fill(encoded, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private PrivateKey decodeKey(OpaqueString opaqueString) throws NoSuchAlgorithmException, InvalidKeySpecException {
        char[] encodedChars = opaqueString.getChars();
        try {
            PrivateKey privateKey;
            byte[] encoded = new byte[encodedChars.length];
            try {
                for (int i2 = 0; i2 < encodedChars.length; ++i2) {
                    encoded[i2] = (byte)encodedChars[i2];
                }
                privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(encoded));
            }
            catch (Throwable throwable) {
                Arrays.fill(encoded, (byte)0);
                throw throwable;
            }
            Arrays.fill(encoded, (byte)0);
            return privateKey;
        }
        finally {
            Arrays.fill(encodedChars, '\u0000');
        }
    }

    private static void tryDestroyKey(PrivateKey privateKey) {
        try {
            privateKey.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
    }

    private static int findTag(byte[] pemBytes, int offset, byte[] tag) {
        while (offset < pemBytes.length) {
            if (OpaquePrivateKey.arrayEquals(pemBytes, offset, tag)) {
                return offset;
            }
            int lineEnd = OpaquePrivateKey.arrayIndexOf(pemBytes, offset, LINE_SEPARATOR);
            if (lineEnd == -1) break;
            offset = lineEnd + 1;
        }
        return -1;
    }

    private static boolean arrayEquals(byte[] a2, int aOffset, byte[] b2) {
        if (aOffset + b2.length > a2.length) {
            return false;
        }
        for (int i2 = 0; i2 < b2.length; ++i2) {
            if (a2[i2 + aOffset] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    private static int arrayIndexOf(byte[] array, int arrayOffset, byte[] match) {
        for (int i2 = arrayOffset; i2 < array.length; ++i2) {
            if (!OpaquePrivateKey.arrayEquals(array, i2, match)) continue;
            return i2;
        }
        return -1;
    }

    @Blind
    static OpaquePrivateKey fromPrivateKey(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        OpaqueString encodedKey = OpaquePrivateKey.encodeKey(privateKey);
        return new OpaquePrivateKey(encodedKey);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof OpaquePrivateKey && Objects.equals(this.opaqueEncoding, ((OpaquePrivateKey)object).opaqueEncoding);
    }

    public int hashCode() {
        return Objects.hash(this.opaqueEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    <T, E extends Throwable> T map(ThrowingFunction<PrivateKey, T, E> mapper) throws E, NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey deobfuscatedKey = this.decodeKey(this.opaqueEncoding);
        try {
            T t2 = mapper.applyOrThrow(deobfuscatedKey);
            return t2;
        }
        finally {
            OpaquePrivateKey.tryDestroyKey(deobfuscatedKey);
        }
    }

    static {
        try {
            $$$methodRef$$$12 = OpaquePrivateKey.class.getDeclaredConstructor(OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OpaquePrivateKey.class.getDeclaredMethod("map", ThrowingFunction.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OpaquePrivateKey.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OpaquePrivateKey.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OpaquePrivateKey.class.getDeclaredMethod("fromPrivateKey", PrivateKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OpaquePrivateKey.class.getDeclaredMethod("arrayIndexOf", byte[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OpaquePrivateKey.class.getDeclaredMethod("arrayEquals", byte[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OpaquePrivateKey.class.getDeclaredMethod("findTag", byte[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OpaquePrivateKey.class.getDeclaredMethod("tryDestroyKey", PrivateKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OpaquePrivateKey.class.getDeclaredMethod("decodeKey", OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OpaquePrivateKey.class.getDeclaredMethod("encodeKey", PrivateKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OpaquePrivateKey.class.getDeclaredMethod("decodeBase64Key", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OpaquePrivateKey.class.getDeclaredMethod("fromPemFile", Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        BEGIN_PRIVATE_KEY_UTF8 = "-----BEGIN PRIVATE KEY-----".getBytes(StandardCharsets.UTF_8);
        END_PRIVATE_KEY_UTF8 = "-----END PRIVATE KEY-----".getBytes(StandardCharsets.UTF_8);
        LINE_SEPARATOR = "\n".getBytes(StandardCharsets.UTF_8);
    }

    static interface ThrowingFunction<T, R, E extends Throwable>
    extends Function<T, R> {
        public R applyOrThrow(T var1) throws E;

        @Override
        default public R apply(T input) {
            try {
                return this.applyOrThrow(input);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(throwable);
            }
        }
    }
}

