/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.BFILE;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CBfileAccessor
extends BfileAccessor {
    T4CMAREngine mare;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    T4CBfileAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, 530, form, external_type, forBind);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$10, null, stmt, max_len, form, external_type, forBind, _mare);
            }
            this.mare = _mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    T4CBfileAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, 530, nullable, flags, precision, scale, contflag, total_elems, form);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$11, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, _definedColumnType, _definedColumnSize, _mare);
            }
            this.mare = _mare;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    public T4CMAREngine getMAREngine() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$0, this, new Object[0]);
            }
            T4CMAREngine t4CMAREngine = this.mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$0, this, t4CMAREngine);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$0, this, null);
            }
            return t4CMAREngine;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
                this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processIndicator(int n2) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
                this.mare.unmarshalSB2();
                this.mare.unmarshalUB2();
            } else if (this.statement.connection.versionNumber < 9200) {
                this.mare.unmarshalSB2();
                if (!this.statement.sqlKind.isPlsqlOrCall()) {
                    this.mare.unmarshalSB2();
                }
            } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
                void size;
                this.mare.processIndicator(size <= 0, (int)size);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    int getPreviousRowProcessed() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            int n2 = this.previousRowProcessed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$3, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmt;
            void dba;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$4, this, byteArray, oracleStatement);
            }
            this.rowData = dba;
            this.mare = ((T4CConnection)stmt.connection).mare;
            this.rowNull = null;
            this.setCapacity(stmt.getFetchSize());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$5, this, new Object[0]);
            }
            boolean isStream = false;
            if (!this.isUseless()) {
                if (this.isUnexpected()) {
                    long pos = this.rowData.getPosition();
                    this.unmarshalColumnMetadata();
                    this.unmarshalBytes();
                    this.rowData.setPosition(pos);
                    this.setNull(this.lastRowProcessed, true);
                } else if (this.isNullByDescribe()) {
                    this.setNull(this.lastRowProcessed, true);
                    this.unmarshalColumnMetadata();
                    if (this.statement.connection.versionNumber < 9200) {
                        this.processIndicator(0);
                    }
                } else {
                    this.unmarshalColumnMetadata();
                    isStream = this.unmarshalBytes();
                }
            }
            this.previousRowProcessed = this.lastRowProcessed++;
            boolean bl2 = isStream;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$5, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void copyRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (this.isNullByDescribe || this.previousRowProcessed == -1) {
                this.setNull(this.lastRowProcessed, true);
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            } else if (this.lastRowProcessed == 0) {
                long previousOffset = this.getOffset(this.previousRowProcessed);
                long previousPrefetchedDataOffset = this.getPrefetchedDataOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    if (this.isPrefetched()) {
                        this.setPrefetchedLength(this.lastRowProcessed, this.getPrefetchedLength(this.previousRowProcessed));
                        this.setPrefetchedChunkSize(this.lastRowProcessed, this.getPrefetchedChunkSize(this.previousRowProcessed));
                        this.setPrefetchedDataLength(this.lastRowProcessed, this.getPrefetchedDataLength(this.previousRowProcessed));
                        this.setPrefetchedDataOffset(this.lastRowProcessed);
                        ((DynamicByteArray)this.rowData).copyLeft(previousPrefetchedDataOffset, this.getPrefetchedDataLength(this.previousRowProcessed));
                    }
                    this.setOffset(this.lastRowProcessed);
                    ((DynamicByteArray)this.rowData).copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            } else {
                int previousRowProcessed = this.lastRowProcessed - 1;
                if (this.isPrefetched()) {
                    this.setPrefetchedLength(this.lastRowProcessed, this.getPrefetchedLength(previousRowProcessed));
                    this.setPrefetchedChunkSize(this.lastRowProcessed, this.getPrefetchedChunkSize(previousRowProcessed));
                    this.setPrefetchedDataLength(this.lastRowProcessed, this.getPrefetchedDataLength(previousRowProcessed));
                    this.setPrefetchedDataOffset(this.lastRowProcessed, this.getPrefetchedDataOffset(previousRowProcessed));
                }
                this.setNull(this.lastRowProcessed, this.isNull(previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[previousRowProcessed];
                this.setOffset(this.lastRowProcessed, this.getOffset(previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(previousRowProcessed));
            }
            this.previousRowProcessed = this.lastRowProcessed++;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean unmarshalBytes() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$7, this, new Object[0]);
            }
            if ((len = (int)this.mare.unmarshalUB4()) == 0) {
                this.setNull(this.lastRowProcessed, true);
                this.processIndicator(0);
            } else {
                if (this.isPrefetched()) {
                    this.unmarshalPrefetchData();
                }
                this.setOffset(this.lastRowProcessed);
                int actualLength = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
                this.setNull(this.lastRowProcessed, actualLength == 0);
                this.setLength(this.lastRowProcessed, actualLength);
                this.processIndicator(actualLength);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$7, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$7, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    void unmarshalPrefetchData() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$8, this, new Object[0]);
            }
            this.setPrefetchedLength(this.lastRowProcessed, this.mare.unmarshalSB8());
            this.setPrefetchedDataOffset(this.lastRowProcessed);
            this.setPrefetchedDataLength(this.lastRowProcessed, 0);
            if (this.getPrefetchLength() > 0) {
                this.mare.unmarshalUB1();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$9, this, n2);
            }
            if (this.definedColumnType == 0) {
                Object object = super.getObject((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$9, this, object);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$9, this, null);
                }
                return object;
            }
            if (this.isNull((int)currentRow)) {
                Object var3_4 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$9, this, var3_4);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$9, this, null);
                }
                return null;
            }
            if (this.definedColumnType == -13) {
                BFILE bFILE = this.getBFILE((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$9, this, bFILE);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$9, this, null);
                }
                return bFILE;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$9, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CBfileAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$11 = T4CBfileAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE, Integer.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CBfileAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CBfileAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CBfileAccessor.class.getDeclaredMethod("unmarshalPrefetchData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CBfileAccessor.class.getDeclaredMethod("unmarshalBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CBfileAccessor.class.getDeclaredMethod("copyRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CBfileAccessor.class.getDeclaredMethod("unmarshalOneRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CBfileAccessor.class.getDeclaredMethod("reinitForResultSetCache", ByteArray.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CBfileAccessor.class.getDeclaredMethod("getPreviousRowProcessed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CBfileAccessor.class.getDeclaredMethod("processIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CBfileAccessor.class.getDeclaredMethod("unmarshalColumnMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CBfileAccessor.class.getDeclaredMethod("getMAREngine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

