/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler;

import java.util.Objects;
import schemacrawler.ProductVersion;

public class BaseProductVersion
implements ProductVersion {
    private static final long serialVersionUID = 4051323422934251828L;
    private final String productName;
    private final String productVersion;

    public BaseProductVersion(ProductVersion productVersion) {
        this(Objects.requireNonNull(productVersion, "No product name provided").getProductName(), productVersion.getProductVersion());
    }

    public BaseProductVersion(String productName, String productVersion) {
        this.productName = Objects.requireNonNull(productName, "No product name provided");
        this.productVersion = Objects.requireNonNull(productVersion, "No product version provided");
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseProductVersion)) {
            return false;
        }
        ProductVersion other = (ProductVersion)obj;
        return Objects.equals(this.productName, other.getProductName()) && Objects.equals(this.productVersion, other.getProductVersion());
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    public final int hashCode() {
        return Objects.hash(this.productName, this.productVersion);
    }

    public String toString() {
        return String.format("%s %s", this.productName, this.productVersion);
    }
}

