/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Schema;
import us.fatehi.utility.Utility;

public final class AlternateKeyBuilder {
    private static final Logger LOGGER = Logger.getLogger(AlternateKeyBuilder.class.getName());
    private final Catalog catalog;

    public static AlternateKeyBuilder builder(Catalog catalog) {
        return new AlternateKeyBuilder(catalog);
    }

    private AlternateKeyBuilder(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    public Optional<PrimaryKey> addAlternateKey(AlternateKeyDefinition alternateKeyDefinition) {
        Objects.requireNonNull(alternateKeyDefinition, "No alternate key provided");
        Optional lookupTable = this.catalog.lookupTable(alternateKeyDefinition.getSchema(), alternateKeyDefinition.getTableName());
        if (!lookupTable.isPresent()) {
            LOGGER.log(Level.CONFIG, "Table not found, for " + alternateKeyDefinition);
            return Optional.empty();
        }
        MutableTable table = (MutableTable)lookupTable.get();
        MutablePrimaryKey alternateKey = MutablePrimaryKey.newAlternateKey(table, alternateKeyDefinition.getAlternateKeyName());
        List<String> columns = alternateKeyDefinition.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            String columnName = columns.get(i);
            Optional<MutableColumn> lookupColumn = table.lookupColumn(columnName);
            if (!lookupColumn.isPresent()) {
                LOGGER.log(Level.CONFIG, String.format("Column <%s> not found, for %s", columnName, alternateKeyDefinition));
                return Optional.empty();
            }
            Column column = lookupColumn.get();
            MutableTableConstraintColumn pkColumn = new MutableTableConstraintColumn(alternateKey, column);
            pkColumn.setKeyOrdinalPosition(i + 1);
            alternateKey.addColumn(pkColumn);
        }
        table.addAlternateKey(alternateKey);
        return Optional.of(alternateKey);
    }

    public static final class AlternateKeyDefinition {
        private final Schema schema;
        private final String tableName;
        private final String alternateKeyName;
        private final List<String> columns;

        public AlternateKeyDefinition(Schema schema, String table, String alternateKeyName, List<String> columns) {
            this.schema = Objects.requireNonNull(schema, "No schema provided");
            this.tableName = Utility.requireNotBlank(table, "No table name provided");
            this.alternateKeyName = Utility.requireNotBlank(alternateKeyName, "No alternate key name provided");
            if (columns == null || columns.isEmpty()) {
                throw new IllegalArgumentException("No columns provided");
            }
            this.columns = new ArrayList<String>(columns);
        }

        public String getAlternateKeyName() {
            return this.alternateKeyName;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String toString() {
            return String.format("alternate key <%s.%s.%s[%s]>", this.schema, this.tableName, this.alternateKeyName, this.columns);
        }
    }
}

