/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.json4j;

import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.internal.json4j.OrderedJSONObject;
import com.ibm.db2.cmx.internal.json4j.Token;
import com.ibm.db2.cmx.internal.json4j.Tokenizer;
import java.io.IOException;
import java.io.Reader;

public class Parser {
    private Tokenizer tokenizer;
    private Token lastToken;

    public Parser(Reader reader) throws IOException {
        this.tokenizer = new Tokenizer(reader);
    }

    public JSONObject parse() throws IOException {
        return this.parse(false);
    }

    public JSONObject parse(boolean bl2) throws IOException {
        this.lastToken = this.tokenizer.next();
        return this.parseObject(bl2);
    }

    public JSONObject parseObject() throws IOException {
        return this.parseObject(false);
    }

    public JSONObject parseObject(boolean bl2) throws IOException {
        JSONObject jSONObject;
        block6: {
            jSONObject = null;
            jSONObject = !bl2 ? new JSONObject() : new OrderedJSONObject();
            if (this.lastToken != Token.TokenBraceL) {
                throw new IOException("Expecting '{' " + this.tokenizer.onLineCol() + " instead, obtained token: '" + this.lastToken + "'");
            }
            this.lastToken = this.tokenizer.next();
            while (true) {
                if (this.lastToken == Token.TokenEOF) {
                    throw new IOException("Unterminated object " + this.tokenizer.onLineCol());
                }
                if (this.lastToken == Token.TokenBraceR) break block6;
                if (!this.lastToken.isString()) {
                    throw new IOException("Expecting string key " + this.tokenizer.onLineCol());
                }
                String string = this.lastToken.getString();
                this.lastToken = this.tokenizer.next();
                if (this.lastToken != Token.TokenColon) {
                    throw new IOException("Expecting colon " + this.tokenizer.onLineCol());
                }
                this.lastToken = this.tokenizer.next();
                Object object = this.parseValue(bl2);
                jSONObject.put(string, object);
                if (this.lastToken == Token.TokenComma) {
                    this.lastToken = this.tokenizer.next();
                    continue;
                }
                if (this.lastToken != Token.TokenBraceR) break;
            }
            throw new IOException("expecting either ',' or '}' " + this.tokenizer.onLineCol());
        }
        this.lastToken = this.tokenizer.next();
        return jSONObject;
    }

    public JSONArray parseArray() throws IOException {
        return this.parseArray(false);
    }

    public JSONArray parseArray(boolean bl2) throws IOException {
        JSONArray jSONArray;
        block4: {
            jSONArray = new JSONArray();
            if (this.lastToken != Token.TokenBrackL) {
                throw new IOException("Expecting '[' " + this.tokenizer.onLineCol());
            }
            this.lastToken = this.tokenizer.next();
            while (true) {
                if (this.lastToken == Token.TokenEOF) {
                    throw new IOException("Unterminated array " + this.tokenizer.onLineCol());
                }
                if (this.lastToken == Token.TokenBrackR) break block4;
                Object object = this.parseValue(bl2);
                jSONArray.add(object);
                if (this.lastToken == Token.TokenComma) {
                    this.lastToken = this.tokenizer.next();
                    continue;
                }
                if (this.lastToken != Token.TokenBrackR) break;
            }
            throw new IOException("expecting either ',' or ']' " + this.tokenizer.onLineCol());
        }
        this.lastToken = this.tokenizer.next();
        return jSONArray;
    }

    public Object parseValue() throws IOException {
        return this.parseValue(false);
    }

    public Object parseValue(boolean bl2) throws IOException {
        if (this.lastToken == Token.TokenEOF) {
            throw new IOException("Expecting property value " + this.tokenizer.onLineCol());
        }
        if (this.lastToken.isNumber()) {
            Number number = this.lastToken.getNumber();
            this.lastToken = this.tokenizer.next();
            return number;
        }
        if (this.lastToken.isString()) {
            String string = this.lastToken.getString();
            this.lastToken = this.tokenizer.next();
            return string;
        }
        if (this.lastToken == Token.TokenFalse) {
            this.lastToken = this.tokenizer.next();
            return Boolean.FALSE;
        }
        if (this.lastToken == Token.TokenTrue) {
            this.lastToken = this.tokenizer.next();
            return Boolean.TRUE;
        }
        if (this.lastToken == Token.TokenNull) {
            this.lastToken = this.tokenizer.next();
            return null;
        }
        if (this.lastToken == Token.TokenBrackL) {
            return this.parseArray(bl2);
        }
        if (this.lastToken == Token.TokenBraceL) {
            return this.parseObject(bl2);
        }
        throw new IOException("Invalid token " + this.tokenizer.onLineCol());
    }
}

