/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.metadata;

import com.ibm.db2.cmx.annotation.Column;
import com.ibm.db2.cmx.annotation.Format;
import com.ibm.db2.cmx.annotation.GeneratedKey;
import com.ibm.db2.cmx.annotation.Id;
import com.ibm.db2.cmx.annotation.JoinColumn;
import com.ibm.db2.cmx.annotation.JoinPoint;
import com.ibm.db2.cmx.annotation.Required;
import com.ibm.db2.cmx.runtime.exception.DataSQLException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.WarningFactory;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanInformation;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanInformationCache;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.runtime.internal.metadata.PropertyIntrospector;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.jcc.DBTimestamp;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BeanIntrospection {
    private StringBuffer errorBuffer_ = new StringBuffer();
    private boolean allowPublicFieldWithGetterSetter_ = true;
    private boolean ignoreOrphanGetterSetter_ = true;
    private boolean allowBeanRulesForMDM_ = false;
    private static final Class[] LONG_SET_PARAMS = new Class[]{String.class, String.class, Integer.TYPE, Object.class};
    private static final Class[] SHORT_SET_PARAMS = new Class[]{String.class, Object.class};

    public BeanIntrospection() {
        this.getPropertiesForBeanIntrospection();
    }

    public BeanInformation getBeanInstrospectionInformation(Class<?> clazz) throws DataSQLException {
        return this.chooseAndExecuteAlgorithmForBeanIntrospection(clazz);
    }

    public Map<String, BeanPropertyInformation> getBeanInformation(Class<?> clazz, OutputStreamWriter outputStreamWriter, boolean bl2, boolean bl3, boolean bl4) throws DataSQLException {
        BeanInformation beanInformation = null;
        if (bl4) {
            this.allowBeanRulesForMDM_ = true;
            beanInformation = this.getBeanIntrospectionInformationForMDM(clazz);
            if (beanInformation.getBeanPropertyMap() != null) {
                System.out.println("Bean Introspection successful for " + clazz.getName());
            } else {
                System.out.println("Bean Introspection failed for " + clazz.getName());
            }
        } else {
            this.allowPublicFieldWithGetterSetter_ = bl2;
            this.ignoreOrphanGetterSetter_ = bl3;
            beanInformation = this.getBeanIntrospectionInformationUsingBaseRules(clazz);
            if (this.errorBuffer_.length() > 0) {
                try {
                    outputStreamWriter.write("\nERRORS found during Bean Introspection in BEAN " + clazz + "\n" + this.errorBuffer_.toString());
                    outputStreamWriter.flush();
                    return null;
                }
                catch (IOException iOException) {
                    System.out.println("Encountered an IO exception");
                    return null;
                }
            }
        }
        if (beanInformation != null) {
            return beanInformation.getBeanPropertyMap();
        }
        return null;
    }

    private void getPropertiesForBeanIntrospection() {
        String string = DataProperties.getProperty("pdq.allowGetterSetterMethodWithPublicField");
        String string2 = DataProperties.getProperty("pdq.ignoreOrphanGetterSetterMethods");
        String string3 = DataProperties.getProperty("pdq.allowMDMBeanRules");
        if ("true".equalsIgnoreCase(string3)) {
            this.allowBeanRulesForMDM_ = true;
        }
        if ("true".equalsIgnoreCase(string)) {
            this.allowPublicFieldWithGetterSetter_ = true;
        }
        if ("true".equalsIgnoreCase(string2)) {
            this.ignoreOrphanGetterSetter_ = true;
        }
    }

    public String[] getBeanInformationForGeneratedKeys(Class<?> clazz) throws DataSQLException {
        BeanInformation beanInformation = this.chooseAndExecuteAlgorithmForBeanIntrospection(clazz);
        return beanInformation.getAutoGenColumnNames();
    }

    private BeanInformation chooseAndExecuteAlgorithmForBeanIntrospection(Class<?> clazz) throws DataSQLException {
        BeanInformation beanInformation = null;
        beanInformation = this.allowBeanRulesForMDM_ ? this.getBeanIntrospectionInformationForMDM(clazz) : this.getBeanIntrospectionInformationUsingBaseRules(clazz);
        beanInformation.setGenericSetWithParamsMethod(this.getGenericSetWithParamsMethod(clazz));
        beanInformation.setGenericSetMethod(this.getGenericSetMethod(clazz));
        BeanInformationCache.addBeanToBeanMap(clazz, beanInformation);
        return beanInformation;
    }

    private BeanInformation getBeanIntrospectionInformationUsingBaseRules(Class<?> clazz) throws DataSQLException {
        HashMap<String, BeanPropertyInformation> hashMap = new HashMap<String, BeanPropertyInformation>();
        HashSet<String> hashSet = new HashSet<String>();
        BeanInformation beanInformation = new BeanInformation(hashMap);
        boolean bl2 = this.retriveMethodInfoUsingPropertyIntrospector(clazz, hashMap, hashSet, beanInformation);
        bl2 |= this.retrieveFieldInfoUsingPropertyIntrospector(clazz, hashMap, hashSet, beanInformation);
        if (this.errorBuffer_.length() > 0) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_BEAN_INTRO", clazz) + "\n" + this.errorBuffer_.toString(), null, 10092);
        }
        if (hashSet.size() > 0) {
            beanInformation.setAutoGenColumnNames(hashSet.toArray(new String[hashSet.size()]));
        }
        beanInformation.setNestedBean(bl2);
        beanInformation.setBeanClass(clazz);
        List<BeanPropertyInformation> list = this.findIdKeysForBean(beanInformation);
        beanInformation.setIdKeys(list);
        beanInformation.mapPropertiesByTableColumnName();
        return beanInformation;
    }

    private List<BeanPropertyInformation> findIdKeysForBean(BeanInformation beanInformation) {
        ArrayList<BeanPropertyInformation> arrayList = new ArrayList<BeanPropertyInformation>();
        Map<String, BeanPropertyInformation> map = beanInformation.getBeanPropertyMap();
        for (BeanPropertyInformation beanPropertyInformation : map.values()) {
            if (!beanPropertyInformation.isIdProperty()) continue;
            arrayList.add(beanPropertyInformation);
        }
        return arrayList;
    }

    public static BeanPropertyInformation getPropertyUsingCaseSensitiveName(Map<String, BeanPropertyInformation> map, String string) {
        BeanPropertyInformation beanPropertyInformation = BeanIntrospection.getPropertyUsingCaseInSensitiveName(string.toLowerCase(), null, map);
        Field field = null;
        Method method = null;
        if (beanPropertyInformation != null) {
            field = beanPropertyInformation.getFieldFromIntrospector();
            if (field != null && field.getName().equals(string)) {
                return beanPropertyInformation;
            }
            method = beanPropertyInformation.getReadMethod();
            if (method != null && beanPropertyInformation.getDerivedPropertyNameFromMethod(method.getName()).equals(string)) {
                return beanPropertyInformation;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean retrieveFieldInfoUsingPropertyIntrospector(Class<?> clazz, Map<String, BeanPropertyInformation> map, HashSet<String> hashSet, BeanInformation beanInformation) throws DataSQLException {
        boolean bl2 = false;
        PropertyIntrospector propertyIntrospector = new PropertyIntrospector();
        List<Field> list = propertyIntrospector.getFields(clazz);
        String string = propertyIntrospector.getTableAnnotation(clazz);
        Map<String, String> map2 = propertyIntrospector.getColumnOverideAnnotations(clazz);
        Iterator<Field> iterator = list.iterator();
        while (true) {
            String string2;
            String string3;
            BeanPropertyInformation beanPropertyInformation;
            boolean bl3;
            Field field;
            block13: {
                if (!iterator.hasNext()) {
                    return bl2;
                }
                field = iterator.next();
                bl3 = false;
                beanPropertyInformation = null;
                string3 = field.getName();
                String string4 = string3.toLowerCase();
                if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                BeanPropertyInformation beanPropertyInformation2 = BeanIntrospection.getPropertyUsingCaseInSensitiveName(string4, null, map);
                if (beanPropertyInformation2 != null) {
                    if (this.allowPublicFieldWithGetterSetter_) {
                        beanPropertyInformation = beanPropertyInformation2;
                        beanPropertyInformation.setFieldFromIntrospector(field);
                        break block13;
                    } else {
                        this.errorBuffer_.append(Messages.getText("ERR_BEAN_FIELD", string3) + "\n");
                        continue;
                    }
                }
                beanPropertyInformation = new BeanPropertyInformation(beanInformation);
                beanPropertyInformation.setFieldFromIntrospector(field);
                this.addBeanPropertyMap(string4, beanPropertyInformation, map);
                beanPropertyInformation.setCaseSensitivePropertyName(string3);
            }
            if (hashSet != null && field.isAnnotationPresent(GeneratedKey.class)) {
                bl3 = true;
            }
            if (field.isAnnotationPresent(Id.class)) {
                beanPropertyInformation.setIdProperty(true);
            }
            if (field.isAnnotationPresent(Required.class)) {
                beanPropertyInformation.setInputValueRequired(true);
            }
            if ((string2 = this.checkAndSetColumnOverride(map, map2, beanPropertyInformation, string3)) != null) {
                if (!bl3) continue;
                this.addGeneratedKeyToColumnNames(hashSet, string2);
                continue;
            }
            BeanPropertyInformation beanPropertyInformation3 = propertyIntrospector.getColumnAnnotationFromField(field, string);
            BeanPropertyInformation[] beanPropertyInformationArray = propertyIntrospector.getJoinPointAnnotationsFromField(field, string);
            beanPropertyInformation.columnPrefix_ = propertyIntrospector.getJoinPointColumnPrefix(field);
            if (beanPropertyInformationArray != null) {
                if (beanPropertyInformation3 != null) {
                    WarningFactory.createPureQueryWarningForRuntimeLogOnly(Messages.getText("WARN_JOINCOL_AND_COL", string3, clazz.getCanonicalName()), 11225, this.getClass(), "mapResultSetToBean (ResultSet resultSet)");
                }
                beanPropertyInformation.setJoinPointColumns(beanPropertyInformationArray);
                beanPropertyInformation.setHasJoinPoint(true);
                bl2 = true;
            } else if (beanPropertyInformation3 != null && beanPropertyInformation != null) {
                beanPropertyInformation.setPropertyDerivedFromAnnotation(true);
                beanPropertyInformation.setColumnName(beanPropertyInformation3.getColumnName());
                beanPropertyInformation.setTableName(beanPropertyInformation3.getTableName());
                this.addBeanPropertyMap(beanPropertyInformation3.getColumnName(), beanPropertyInformation, map);
                if (!bl3) continue;
                this.addGeneratedKeyToColumnNames(hashSet, beanPropertyInformation3.getColumnName());
                continue;
            }
            if (!bl3) continue;
            this.addGeneratedKeyToColumnNames(hashSet, string3);
        }
    }

    private void addGeneratedKeyToColumnNames(HashSet<String> hashSet, String string) {
        hashSet.add(string);
    }

    private BeanPropertyInformation addAnnotationIfExistsOnMethod(Map<String, BeanPropertyInformation> map, PropertyIntrospector propertyIntrospector, Method method, BeanPropertyInformation beanPropertyInformation, String string) throws DataSQLException {
        BeanPropertyInformation beanPropertyInformation2 = null;
        if (null != beanPropertyInformation) {
            BeanPropertyInformation[] beanPropertyInformationArray = this.getJoinPointAnnotationFromMethod(method, propertyIntrospector, string);
            String string2 = propertyIntrospector.getJoinPointColumnPrefix(method);
            if (string2 != null) {
                beanPropertyInformation.columnPrefix_ = string2;
            }
            beanPropertyInformation2 = this.getColumnAnnotationFromMethod(beanPropertyInformation, method, propertyIntrospector, string);
            if (null != beanPropertyInformationArray) {
                if (null != beanPropertyInformation2) {
                    WarningFactory.createPureQueryWarningForRuntimeLogOnly(Messages.getText("WARN_JOINCOL_AND_COL", method.getName(), method.getDeclaringClass().getCanonicalName()), 11226, this.getClass(), "mapResultSetToBean (ResultSet resultSet)");
                }
                beanPropertyInformation.setJoinPointColumns(beanPropertyInformationArray);
                beanPropertyInformation.setHasJoinPoint(true);
            } else {
                if (null != beanPropertyInformation2) {
                    beanPropertyInformation.setPropertyDerivedFromAnnotation(true);
                    beanPropertyInformation.setColumnName(beanPropertyInformation2.getColumnName());
                    beanPropertyInformation.setTableName(beanPropertyInformation2.getTableName());
                    this.addBeanPropertyMap(beanPropertyInformation2.getColumnName(), beanPropertyInformation, map);
                }
                if (method.isAnnotationPresent(Id.class)) {
                    beanPropertyInformation.setIdProperty(true);
                }
                if (method.isAnnotationPresent(Required.class)) {
                    beanPropertyInformation.setInputValueRequired(true);
                }
                if (method.isAnnotationPresent(Format.class)) {
                    Format format = method.getAnnotation(Format.class);
                    beanPropertyInformation.setFormatterClassQualifiedName(format.formatterClass().getName());
                    beanPropertyInformation.setFormatterClassName(format.formatterClass().getSimpleName());
                    beanPropertyInformation.setFormattingOptions(format.formattingOptions());
                }
            }
        }
        return beanPropertyInformation2;
    }

    private String checkAndSetColumnOverride(Map<String, BeanPropertyInformation> map, Map<String, String> map2, BeanPropertyInformation beanPropertyInformation, String string) {
        String string2;
        if (map2 != null && (string2 = map2.get(string)) != null && beanPropertyInformation != null) {
            String string3 = string2.toLowerCase();
            beanPropertyInformation.setPropertyDerivedFromAnnotation(true);
            this.addBeanPropertyMap(string3, beanPropertyInformation, map);
            return string3;
        }
        return null;
    }

    private void setValuesInMethodInstance(MethodsForProperty methodsForProperty, AccessorType accessorType, String string, Method method) {
        methodsForProperty.method = method;
        methodsForProperty.currentAccessorMethod = accessorType;
        switch (accessorType) {
            case SET: {
                methodsForProperty.getMethod = this.getMatchingAccessorMethod(string, "get");
                methodsForProperty.isMethod = this.getMatchingAccessorMethod(string, "is");
                methodsForProperty.setMethod = method.getName();
                break;
            }
            case GET: {
                methodsForProperty.setMethod = this.getMatchingAccessorMethod(string, "set");
                methodsForProperty.isMethod = this.getMatchingAccessorMethod(string, "is");
                methodsForProperty.method = method;
                methodsForProperty.getMethod = method.getName();
                break;
            }
            case IS: {
                methodsForProperty.setMethod = this.getMatchingAccessorMethod(string, "set");
                methodsForProperty.getMethod = this.getMatchingAccessorMethod(string, "get");
                methodsForProperty.isMethod = method.getName();
            }
        }
    }

    private boolean retriveMethodInfoUsingPropertyIntrospector(Class<?> clazz, Map<String, BeanPropertyInformation> map, HashSet<String> hashSet, BeanInformation beanInformation) throws DataSQLException {
        boolean bl2 = false;
        PropertyIntrospector propertyIntrospector = new PropertyIntrospector();
        List<Method> list = propertyIntrospector.getMethods(clazz);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = propertyIntrospector.getTableAnnotation(clazz);
        Map<String, String> map2 = propertyIntrospector.getColumnOverideAnnotations(clazz);
        for (int i10 = 0; i10 < list.size(); ++i10) {
            Method method;
            Method method2;
            String string2;
            BeanPropertyInformation beanPropertyInformation = new BeanPropertyInformation(beanInformation);
            Method method3 = list.get(i10);
            String string3 = method3.getName();
            String string4 = beanPropertyInformation.getDerivedPropertyNameFromMethod(string3);
            if (string4 == null || BeanIntrospection.getPropertyUsingCaseInSensitiveName(string2 = string4.toLowerCase(), null, map) != null || hashMap.get(string4) != null) continue;
            MethodsForProperty methodsForProperty = new MethodsForProperty();
            if (string3.startsWith("set")) {
                this.setValuesInMethodInstance(methodsForProperty, AccessorType.SET, string4, method3);
                if (this.checkAccessorMethodIntegrity(clazz, i10, list, methodsForProperty, beanPropertyInformation)) {
                    this.addBeanPropertyMap(string2, beanPropertyInformation, map);
                    beanPropertyInformation.setCaseSensitivePropertyName(string4);
                    method2 = method3;
                    method = beanPropertyInformation.getReadMethod();
                    this.processAnnotationsForGetterSetter(beanPropertyInformation, method, method2, map, string4, hashSet, propertyIntrospector, string, map2);
                } else {
                    this.errorBuffer_.append(Messages.getText("ERR_BEAN_ACC", string3) + "\n");
                    hashMap.put(string4, string3);
                }
            } else if (string3.startsWith("get")) {
                this.setValuesInMethodInstance(methodsForProperty, AccessorType.GET, string4, method3);
                if (this.checkAccessorMethodIntegrity(clazz, i10, list, methodsForProperty, beanPropertyInformation)) {
                    this.addBeanPropertyMap(string2, beanPropertyInformation, map);
                    beanPropertyInformation.setCaseSensitivePropertyName(string4);
                    method2 = beanPropertyInformation.getWriteMethod();
                    method = method3;
                    this.processAnnotationsForGetterSetter(beanPropertyInformation, method, method2, map, string4, hashSet, propertyIntrospector, string, map2);
                } else {
                    this.errorBuffer_.append(Messages.getText("ERR_BEAN_ACC", string3) + "\n");
                    hashMap.put(string4, string3);
                }
            } else {
                if (!string3.startsWith("is")) continue;
                this.setValuesInMethodInstance(methodsForProperty, AccessorType.IS, string4, method3);
                if (this.checkAccessorMethodIntegrity(clazz, i10, list, methodsForProperty, beanPropertyInformation)) {
                    this.addBeanPropertyMap(string2, beanPropertyInformation, map);
                    beanPropertyInformation.setCaseSensitivePropertyName(string4);
                    method2 = beanPropertyInformation.getWriteMethod();
                    method = method3;
                    this.processAnnotationsForGetterSetter(beanPropertyInformation, method, method2, map, string4, hashSet, propertyIntrospector, string, map2);
                } else {
                    this.errorBuffer_.append(Messages.getText("ERR_BEAN_ACC", string3) + "\n");
                    hashMap.put(string4, string3);
                }
            }
            if (!beanPropertyInformation.getHasJoinPoint()) continue;
            bl2 = true;
        }
        return bl2;
    }

    private void processAnnotationsForGetterSetter(BeanPropertyInformation beanPropertyInformation, Method method, Method method2, Map<String, BeanPropertyInformation> map, String string, HashSet<String> hashSet, PropertyIntrospector propertyIntrospector, String string2, Map<String, String> map2) throws DataSQLException {
        String string3 = this.addAnnotations(map, method, method2, propertyIntrospector, map2, string, beanPropertyInformation, string2);
        if (string3 == null) {
            string3 = string;
        }
        if (method2 != null && method2.isAnnotationPresent(GeneratedKey.class) || method != null && method.isAnnotationPresent(GeneratedKey.class)) {
            this.addGeneratedKeyToColumnNames(hashSet, string3);
        }
    }

    private String addAnnotations(Map<String, BeanPropertyInformation> map, Method method, Method method2, PropertyIntrospector propertyIntrospector, Map<String, String> map2, String string, BeanPropertyInformation beanPropertyInformation, String string2) throws DataSQLException {
        String string3 = this.checkAndSetColumnOverride(map, map2, beanPropertyInformation, string);
        if (string3 == null) {
            boolean bl2 = false;
            boolean bl3 = false;
            BeanPropertyInformation beanPropertyInformation2 = null;
            BeanPropertyInformation beanPropertyInformation3 = null;
            if (method != null) {
                beanPropertyInformation2 = this.addAnnotationIfExistsOnMethod(map, propertyIntrospector, method, beanPropertyInformation, string2);
                boolean bl4 = bl2 = null != beanPropertyInformation2;
            }
            if (method2 != null) {
                beanPropertyInformation3 = this.addAnnotationIfExistsOnMethod(map, propertyIntrospector, method2, beanPropertyInformation, string2);
                boolean bl5 = bl3 = null != beanPropertyInformation3;
            }
            if (bl2 && bl3 && !beanPropertyInformation2.equalsColumnTable(beanPropertyInformation3)) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_PROP_CONF", string, Column.class.getCanonicalName(), beanPropertyInformation2.getColumnName(), method.toGenericString(), beanPropertyInformation3.getColumnName(), method2.toGenericString()), null, 10288);
            }
            if (beanPropertyInformation2 != null) {
                return beanPropertyInformation2.getColumnName();
            }
            if (beanPropertyInformation3 != null) {
                return beanPropertyInformation3.getColumnName();
            }
        }
        return null;
    }

    private boolean checkAccessorMethodIntegrity(Class<?> clazz, int n2, List<Method> list, MethodsForProperty methodsForProperty, BeanPropertyInformation beanPropertyInformation) {
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        switch (methodsForProperty.currentAccessorMethod) {
            case GET: {
                this.findMatchingMethods(n2, list, clazz, methodsForProperty);
                method = methodsForProperty.matchedSetter;
                method2 = methodsForProperty.matchedIs;
                if (methodsForProperty.getAndIsMethodExist) {
                    this.errorBuffer_.append(Messages.getText("ERR_BEAN_ISGET", clazz.getName(), beanPropertyInformation.getDerivedPropertyNameFromMethod(methodsForProperty.getMethod)) + "\n");
                    break;
                }
                if (methodsForProperty.duplicateMethodFound) {
                    if (this.ignoreOrphanGetterSetter_) {
                        return true;
                    }
                    this.errorBuffer_.append(Messages.getText("ERR_BEAN_MULT_ACCES", beanPropertyInformation.getDerivedPropertyNameFromMethod(methodsForProperty.getMethod), clazz.getName()) + "\n");
                    break;
                }
                if (method != null) {
                    beanPropertyInformation.setReadMethod(methodsForProperty.method);
                    beanPropertyInformation.setWriteMethod(method);
                    return true;
                }
                if (this.ignoreOrphanGetterSetter_) {
                    beanPropertyInformation.setReadMethod(methodsForProperty.method);
                    return true;
                }
                this.errorBuffer_.append(Messages.getText("ERR_BEAN_GETSET", clazz.getName(), methodsForProperty.getMethod, list.get(n2).getDeclaringClass().getName()) + "\n");
                break;
            }
            case SET: {
                this.findMatchingMethods(n2, list, clazz, methodsForProperty);
                method3 = methodsForProperty.matchedGetter;
                method2 = methodsForProperty.matchedIs;
                if (methodsForProperty.getAndIsMethodExist) {
                    this.errorBuffer_.append(Messages.getText("ERR_BEAN_ISGET", clazz.getName(), list.get(n2).getDeclaringClass().getName()) + "\n");
                    break;
                }
                if (methodsForProperty.duplicateMethodFound) {
                    if (this.ignoreOrphanGetterSetter_) {
                        return true;
                    }
                    this.errorBuffer_.append(Messages.getText("ERR_BEAN_MULT_ACCES", beanPropertyInformation.getDerivedPropertyNameFromMethod(methodsForProperty.getMethod), clazz.getName()) + "\n");
                    break;
                }
                if (method3 != null) {
                    beanPropertyInformation.setWriteMethod(methodsForProperty.method);
                    beanPropertyInformation.setReadMethod(method3);
                    return true;
                }
                if (method2 != null) {
                    beanPropertyInformation.setWriteMethod(methodsForProperty.method);
                    beanPropertyInformation.setReadMethod(method2);
                    return true;
                }
                if (this.ignoreOrphanGetterSetter_) {
                    beanPropertyInformation.setWriteMethod(methodsForProperty.method);
                    return true;
                }
                this.errorBuffer_.append(Messages.getText("ERR_BEAN_SET_NO_GET", clazz.getName(), methodsForProperty.setMethod, list.get(n2).getDeclaringClass().getName()) + "\n");
                break;
            }
            case IS: {
                this.findMatchingMethods(n2, list, clazz, methodsForProperty);
                method3 = methodsForProperty.matchedGetter;
                method = methodsForProperty.matchedSetter;
                if (methodsForProperty.getAndIsMethodExist) {
                    this.errorBuffer_.append(Messages.getText("ERR_BEAN_ISGET", clazz.getName(), list.get(n2).getDeclaringClass().getName()) + "\n");
                    break;
                }
                if (methodsForProperty.duplicateMethodFound) {
                    if (this.ignoreOrphanGetterSetter_) {
                        return true;
                    }
                    this.errorBuffer_.append(Messages.getText("ERR_BEAN_MULT_ACCES", beanPropertyInformation.getDerivedPropertyNameFromMethod(methodsForProperty.getMethod), clazz.getName()) + "\n");
                    break;
                }
                if (method != null) {
                    beanPropertyInformation.setReadMethod(methodsForProperty.method);
                    beanPropertyInformation.setWriteMethod(method);
                    return true;
                }
                if (this.ignoreOrphanGetterSetter_) {
                    beanPropertyInformation.setReadMethod(methodsForProperty.method);
                    return true;
                }
                this.errorBuffer_.append(Messages.getText("ERR_BEAN_GETSET", clazz.getName(), methodsForProperty.isMethod, list.get(n2).getDeclaringClass().getName()) + "\n");
            }
        }
        return false;
    }

    private void findMatchingMethods(int n2, List<Method> list, Class<?> clazz, MethodsForProperty methodsForProperty) {
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        switch (methodsForProperty.currentAccessorMethod) {
            case GET: 
            case IS: {
                clazz2 = methodsForProperty.method.getReturnType();
                break;
            }
            case SET: {
                clazz2 = methodsForProperty.method.getParameterTypes()[0];
            }
        }
        for (int i10 = n2 + 1; i10 < list.size(); ++i10) {
            Method method = list.get(i10);
            String string = method.getName();
            if (string.equals(methodsForProperty.getMethod)) {
                if (methodsForProperty.currentAccessorMethod == AccessorType.GET || methodsForProperty.methodNameHasMatched) {
                    methodsForProperty.duplicateMethodFound = true;
                }
                if (methodsForProperty.currentAccessorMethod == AccessorType.IS) {
                    methodsForProperty.getAndIsMethodExist = true;
                }
                clazz3 = method.getReturnType();
                if (clazz2 != null && clazz2.equals(clazz3)) {
                    methodsForProperty.matchedGetter = method;
                }
                methodsForProperty.methodNameHasMatched = true;
                continue;
            }
            if (string.equals(methodsForProperty.setMethod)) {
                if (methodsForProperty.currentAccessorMethod == AccessorType.SET || methodsForProperty.methodNameHasMatched) {
                    methodsForProperty.duplicateMethodFound = true;
                }
                clazz3 = method.getParameterTypes()[0];
                if (clazz2 != null && clazz2.equals(clazz3)) {
                    methodsForProperty.matchedSetter = method;
                }
                methodsForProperty.methodNameHasMatched = true;
                continue;
            }
            if (!string.equals(methodsForProperty.isMethod)) continue;
            if (methodsForProperty.currentAccessorMethod == AccessorType.IS || methodsForProperty.methodNameHasMatched) {
                methodsForProperty.duplicateMethodFound = true;
            } else if (methodsForProperty.currentAccessorMethod == AccessorType.GET) {
                methodsForProperty.getAndIsMethodExist = true;
            }
            clazz3 = method.getReturnType();
            if (clazz2 != null && clazz2.equals(clazz3)) {
                methodsForProperty.matchedIs = method;
            }
            methodsForProperty.methodNameHasMatched = true;
        }
    }

    private String getMatchingAccessorMethod(String string, String string2) {
        return string2 + string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public boolean checkIfFieldIsAccessible(Field field) {
        int n2 = field.getModifiers();
        return Modifier.isFinal(n2) && Modifier.isStatic(n2) || Modifier.isPrivate(n2) || Modifier.isProtected(n2);
    }

    protected BeanPropertyInformation getColumnAnnotationFromMethod(BeanPropertyInformation beanPropertyInformation, Method method, PropertyIntrospector propertyIntrospector, String string) {
        if (method.isAnnotationPresent(Column.class)) {
            Column column = method.getAnnotation(Column.class);
            return PropertyIntrospector.getColumnAnnotations(column, string);
        }
        if (string != null && string.length() > 0 && !method.isAnnotationPresent(JoinPoint.class)) {
            Method method2;
            String string2 = method.getName();
            String string3 = null;
            String string4 = null;
            if (string2.startsWith("get") || string2.startsWith("is")) {
                Method method3 = beanPropertyInformation.getWriteMethod();
                if (method3 != null) {
                    string3 = this.getColumnNameFromMethodOrField(beanPropertyInformation, method3);
                    string4 = this.getColumnTableNameFromMethodOrField(beanPropertyInformation, method3, string);
                }
            } else if (string2.startsWith("set") && (method2 = beanPropertyInformation.getReadMethod()) != null) {
                string3 = this.getColumnNameFromMethodOrField(beanPropertyInformation, method2);
                string4 = this.getColumnTableNameFromMethodOrField(beanPropertyInformation, method2, string);
            }
            if (string3 != null) {
                return new BeanPropertyInformation(string3, string4);
            }
        }
        return null;
    }

    private String getColumnNameFromMethodOrField(BeanPropertyInformation beanPropertyInformation, Method method) {
        Object object;
        String string = null;
        if (method != null && method.isAnnotationPresent(Column.class)) {
            object = method.getAnnotation(Column.class);
            string = PropertyIntrospector.getAnnotationValue((Annotation)object, "name", null);
        }
        if (string == null) {
            object = beanPropertyInformation.getFieldFromIntrospector();
            if (object != null && ((AccessibleObject)object).isAnnotationPresent(Column.class)) {
                Column column = ((Field)object).getAnnotation(Column.class);
                string = PropertyIntrospector.getAnnotationValue(column, "name", null);
            }
            if (string == null) {
                int n2 = method.getName().startsWith("is") ? 2 : 3;
                string = method.getName().substring(n2);
            }
        }
        return string;
    }

    private String getColumnTableNameFromMethodOrField(BeanPropertyInformation beanPropertyInformation, Method method, String string) {
        Object object;
        String string2 = null;
        if (method != null && method.isAnnotationPresent(Column.class)) {
            object = method.getAnnotation(Column.class);
            string2 = PropertyIntrospector.getAnnotationValue((Annotation)object, "table", string);
        }
        if (string2 == null && (object = beanPropertyInformation.getFieldFromIntrospector()) != null && ((AccessibleObject)object).isAnnotationPresent(Column.class)) {
            Column column = ((Field)object).getAnnotation(Column.class);
            string2 = PropertyIntrospector.getAnnotationValue(column, "table", string);
        }
        if (string2 == null || "*".equals(string2)) {
            string2 = string;
        } else if ("".equals(string2)) {
            string2 = null;
        }
        return string2;
    }

    protected void printBeanInfo(Map<String, BeanPropertyInformation> map) {
        if (map == null) {
            System.out.println("Bean not found");
        }
        System.out.println("PROPERTIES FOR BEAN INFO \n");
        String string = null;
        String string2 = null;
        String string3 = null;
        for (String string4 : map.keySet()) {
            string = null;
            string2 = null;
            string3 = null;
            BeanPropertyInformation beanPropertyInformation = BeanIntrospection.getPropertyUsingCaseInSensitiveName(string4, null, map);
            if (beanPropertyInformation.getReadMethod() != null) {
                string = beanPropertyInformation.getReadMethod().getName();
            }
            if (beanPropertyInformation.getWriteMethod() != null) {
                string2 = beanPropertyInformation.getWriteMethod().getName();
            }
            if (beanPropertyInformation.getFieldFromIntrospector() != null) {
                string3 = beanPropertyInformation.getFieldFromIntrospector().getName();
            }
            System.out.println("Property Key " + string4);
            System.out.println("ReadMethod: " + string);
            System.out.println("WriteMethod: " + string2);
            System.out.println("FieldName: " + string3);
        }
    }

    private BeanInformation getBeanIntrospectionInformationForMDM(Class<?> clazz) throws DataSQLException {
        HashMap<String, BeanPropertyInformation> hashMap = new HashMap<String, BeanPropertyInformation>();
        HashSet<String> hashSet = new HashSet<String>();
        BeanInformation beanInformation = new BeanInformation(hashMap);
        this.retriveInfoUsingJavaBeanIntrospectorForMDM(clazz, hashMap, beanInformation);
        this.retrievefieldUsingPropertyIntrospectorForMDM(clazz, hashMap, hashSet, beanInformation);
        return beanInformation;
    }

    private void retriveInfoUsingJavaBeanIntrospectorForMDM(Class<?> clazz, Map<String, BeanPropertyInformation> map, BeanInformation beanInformation) {
        List<PropertyDescriptor> list = this.getPropertyListFromBean(clazz);
        for (PropertyDescriptor propertyDescriptor : list) {
            BeanPropertyInformation beanPropertyInformation = new BeanPropertyInformation(beanInformation);
            String string = propertyDescriptor.getName();
            if (propertyDescriptor.getWriteMethod() != null) {
                beanPropertyInformation.setWriteMethod(propertyDescriptor.getWriteMethod());
            }
            if (propertyDescriptor.getReadMethod() != null) {
                beanPropertyInformation.setReadMethod(propertyDescriptor.getReadMethod());
            }
            this.addBeanPropertyMap(string.toLowerCase(), beanPropertyInformation, map);
        }
    }

    public List<PropertyDescriptor> getPropertyListFromBean(Class<?> clazz) {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                if (propertyDescriptor.getName().equalsIgnoreCase("class")) continue;
                arrayList.add(propertyDescriptor);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return arrayList;
    }

    private void retrievefieldUsingPropertyIntrospectorForMDM(Class<?> clazz, Map<String, BeanPropertyInformation> map, HashSet<String> hashSet, BeanInformation beanInformation) throws DataSQLException {
        PropertyIntrospector propertyIntrospector = new PropertyIntrospector();
        List<Field> list = propertyIntrospector.getFields(clazz);
        Map<String, String> map2 = propertyIntrospector.getColumnOverideAnnotations(clazz);
        boolean bl2 = false;
        for (Field field : list) {
            String string;
            bl2 = false;
            BeanPropertyInformation beanPropertyInformation = null;
            BeanPropertyInformation beanPropertyInformation2 = null;
            String string2 = field.getName();
            String string3 = string2.toLowerCase();
            beanPropertyInformation = BeanIntrospection.getPropertyUsingCaseInSensitiveName(string3, null, map);
            if (beanPropertyInformation != null) {
                beanPropertyInformation.setFieldFromIntrospector(field);
            } else {
                beanPropertyInformation2 = new BeanPropertyInformation(beanInformation);
                beanPropertyInformation2.setFieldFromIntrospector(field);
                this.addBeanPropertyMap(string3, beanPropertyInformation2, map);
            }
            if (hashSet != null && field.isAnnotationPresent(GeneratedKey.class)) {
                bl2 = true;
            }
            if ((string = this.checkForColumnOverride(map, map2, beanPropertyInformation, beanPropertyInformation2, string2)) != null) {
                if (!bl2) continue;
                this.addGeneratedKeyToColumnNames(hashSet, string);
                continue;
            }
            BeanPropertyInformation beanPropertyInformation3 = this.annotationExistsOnMethod(map, beanPropertyInformation, propertyIntrospector, null);
            if (beanPropertyInformation3 != null) {
                if (!bl2) continue;
                this.addGeneratedKeyToColumnNames(hashSet, beanPropertyInformation3.getColumnName());
                continue;
            }
            BeanPropertyInformation beanPropertyInformation4 = propertyIntrospector.getColumnAnnotationFromField(field, null);
            if (beanPropertyInformation4 != null) {
                this.appendToBeanInformation(map, beanPropertyInformation, beanPropertyInformation2, beanPropertyInformation4);
                if (!bl2) continue;
                this.addGeneratedKeyToColumnNames(hashSet, beanPropertyInformation4.getColumnName());
                continue;
            }
            this.appendToBeanInformation(map, beanPropertyInformation, beanPropertyInformation2, string3);
            if (!bl2) continue;
            this.addGeneratedKeyToColumnNames(hashSet, string3);
        }
    }

    private String checkForColumnOverride(Map<String, BeanPropertyInformation> map, Map<String, String> map2, BeanPropertyInformation beanPropertyInformation, BeanPropertyInformation beanPropertyInformation2, String string) {
        String string2;
        if (map2 != null && (string2 = map2.get(string)) != null) {
            String string3 = string2.toLowerCase();
            this.appendToBeanInformation(map, beanPropertyInformation, beanPropertyInformation2, string3);
            return string3;
        }
        return null;
    }

    private void appendToBeanInformation(Map<String, BeanPropertyInformation> map, BeanPropertyInformation beanPropertyInformation, BeanPropertyInformation beanPropertyInformation2, String string) {
        if (beanPropertyInformation != null) {
            this.addBeanPropertyMap(string.toLowerCase(), beanPropertyInformation, map);
        } else {
            this.addBeanPropertyMap(string.toLowerCase(), beanPropertyInformation2, map);
        }
    }

    private void appendToBeanInformation(Map<String, BeanPropertyInformation> map, BeanPropertyInformation beanPropertyInformation, BeanPropertyInformation beanPropertyInformation2, BeanPropertyInformation beanPropertyInformation3) {
        if (beanPropertyInformation != null) {
            beanPropertyInformation.setColumnName(beanPropertyInformation3.getColumnName());
            beanPropertyInformation.setTableName(beanPropertyInformation3.getTableName());
            this.addBeanPropertyMap(beanPropertyInformation3.getColumnName(), beanPropertyInformation, map);
        } else {
            beanPropertyInformation2.setColumnName(beanPropertyInformation3.getColumnName());
            beanPropertyInformation2.setTableName(beanPropertyInformation3.getTableName());
            this.addBeanPropertyMap(beanPropertyInformation3.getColumnName(), beanPropertyInformation2, map);
        }
    }

    private BeanPropertyInformation annotationExistsOnMethod(Map<String, BeanPropertyInformation> map, BeanPropertyInformation beanPropertyInformation, PropertyIntrospector propertyIntrospector, String string) {
        BeanPropertyInformation beanPropertyInformation2;
        if (beanPropertyInformation != null && beanPropertyInformation.getWriteMethod() != null && (beanPropertyInformation2 = this.getColumnAnnotationFromMethod(beanPropertyInformation, beanPropertyInformation.getWriteMethod(), propertyIntrospector, string)) != null) {
            this.addBeanPropertyMap(beanPropertyInformation2.getColumnName(), beanPropertyInformation, map);
            return beanPropertyInformation2;
        }
        return null;
    }

    private Method getGenericSetWithParamsMethod(Class<?> clazz) {
        try {
            return this.getMethodWithParmsForClass(clazz, LONG_SET_PARAMS);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Method getGenericSetMethod(Class<?> clazz) {
        try {
            return this.getMethodWithParmsForClass(clazz, SHORT_SET_PARAMS);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static JavaType getParmType(Class<?> clazz) {
        JavaType javaType = String.class.equals(clazz) ? JavaType.STRING : (Boolean.class.equals(clazz) ? JavaType.BOOLEAN : (Boolean.TYPE.equals(clazz) ? JavaType.SIMPLE_BOOLEAN : (Byte.class.equals(clazz) ? JavaType.BYTE : (Byte.TYPE.equals(clazz) ? JavaType.SIMPLE_BYTE : (Short.class.equals(clazz) ? JavaType.SHORT : (Short.TYPE.equals(clazz) ? JavaType.SIMPLE_SHORT : (Integer.class.equals(clazz) ? JavaType.INTEGER : (Integer.TYPE.equals(clazz) ? JavaType.SIMPLE_INTEGER : (Long.class.equals(clazz) ? JavaType.LONG : (Long.TYPE.equals(clazz) ? JavaType.SIMPLE_LONG : (Float.class.equals(clazz) ? JavaType.FLOAT : (Float.TYPE.equals(clazz) ? JavaType.SIMPLE_FLOAT : (Double.class.equals(clazz) ? JavaType.DOUBLE : (Double.TYPE.equals(clazz) ? JavaType.SIMPLE_DOUBLE : (byte[].class.equals(clazz) ? JavaType.BYTE_ARRAY : (Date.class.equals(clazz) ? JavaType.DATE : (Time.class.equals(clazz) ? JavaType.TIME : (Timestamp.class.equals(clazz) ? JavaType.TIMESTAMP : (DBTimestamp.class.equals(clazz) ? JavaType.TIMESTAMPTZ : (BigDecimal.class.equals(clazz) ? JavaType.BIGDECIMAL : (Blob.class.equals(clazz) ? JavaType.BLOB : (Clob.class.equals(clazz) ? JavaType.CLOB : (InputStream.class.equals(clazz) ? JavaType.INPUTSTREAM : (Reader.class.equals(clazz) ? JavaType.READER : (clazz.isAssignableFrom(List.class) ? JavaType.LIST : (clazz.isArray() ? JavaType.ARRAY : (clazz.isAssignableFrom(Iterator.class) ? JavaType.ITERATOR : JavaType.OBJECT)))))))))))))))))))))))))));
        return javaType;
    }

    public void addBeanPropertyMap(String string, BeanPropertyInformation beanPropertyInformation, Map<String, BeanPropertyInformation> map) {
        BeanPropertyInformation beanPropertyInformation2 = map.get(string);
        if (beanPropertyInformation2 == null) {
            map.put(string, beanPropertyInformation);
        } else if (beanPropertyInformation2.getTableName() == null) {
            map.put(string, beanPropertyInformation);
        } else if (beanPropertyInformation.getTableName() == null) {
            map.put(string, beanPropertyInformation);
        } else if (beanPropertyInformation2.getTableName().equals(beanPropertyInformation.getTableName())) {
            beanPropertyInformation.setNextBeanPropInfo(beanPropertyInformation2.getNextBeanPropInfo());
            map.put(string, beanPropertyInformation);
        } else {
            beanPropertyInformation.setNextBeanPropInfo(beanPropertyInformation2.getNextBeanPropInfo());
            beanPropertyInformation2.setNextBeanPropInfo(beanPropertyInformation);
        }
    }

    public static BeanPropertyInformation getPropertyUsingTableColumnName(String string, String string2, Map<String, BeanPropertyInformation> map) {
        BeanPropertyInformation beanPropertyInformation = map.get(string = string.toLowerCase());
        if (beanPropertyInformation == null) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            if (beanPropertyInformation.getColumnName() != null) {
                if (string.equals(beanPropertyInformation.getColumnName())) {
                    return beanPropertyInformation;
                }
                return null;
            }
            return beanPropertyInformation;
        }
        if (beanPropertyInformation.getTableName() == null) {
            if (beanPropertyInformation.getColumnName() != null) {
                if (string.equals(beanPropertyInformation.getColumnName())) {
                    return beanPropertyInformation;
                }
                return null;
            }
            return beanPropertyInformation;
        }
        String string3 = string2.toLowerCase();
        while (beanPropertyInformation != null) {
            if (string3.equals(beanPropertyInformation.getTableName())) {
                if (beanPropertyInformation.getColumnName() != null) {
                    if (string.equals(beanPropertyInformation.getColumnName())) {
                        return beanPropertyInformation;
                    }
                } else {
                    return beanPropertyInformation;
                }
            }
            beanPropertyInformation = beanPropertyInformation.getNextBeanPropInfo();
        }
        return null;
    }

    public static BeanPropertyInformation getPropertyUsingCaseInSensitiveName(String string, String string2, Map<String, BeanPropertyInformation> map) {
        if (string2 == null || string2.length() == 0) {
            return map.get(string.toLowerCase());
        }
        BeanPropertyInformation beanPropertyInformation = map.get(string.toLowerCase());
        if (beanPropertyInformation == null) {
            return null;
        }
        if (beanPropertyInformation.getTableName() == null) {
            return beanPropertyInformation;
        }
        String string3 = string2.toLowerCase();
        while (beanPropertyInformation != null) {
            if (beanPropertyInformation.getTableName().equals(string3)) {
                return beanPropertyInformation;
            }
            beanPropertyInformation = beanPropertyInformation.getNextBeanPropInfo();
        }
        return null;
    }

    private Method getMethodWithParmsForClass(Class<?> clazz, Class[] classArray) throws PrivilegedActionException, SecurityException, NoSuchMethodException {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(BeanIntrospection.getMethodWithParms(clazz, "set", classArray));
        }
        return BeanIntrospection.getMethodWithParmsNoSM(clazz, "set", classArray);
    }

    private static Method getMethodWithParmsNoSM(Class<?> clazz, String string, Class[] classArray) throws SecurityException, NoSuchMethodException {
        return clazz.getMethod(string, classArray);
    }

    private static final PrivilegedExceptionAction<Method> getMethodWithParms(final Class<?> clazz, final String string, final Class[] classArray) {
        return new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws NoSuchMethodException {
                return BeanIntrospection.getMethodWithParmsNoSM(clazz, string, classArray);
            }
        };
    }

    protected BeanPropertyInformation[] getJoinPointAnnotationFromMethod(Method method, PropertyIntrospector propertyIntrospector, String string) throws DataSQLException {
        Object object;
        BeanPropertyInformation[] beanPropertyInformationArray = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (method.isAnnotationPresent(JoinPoint.class)) {
            if (bl3) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_JOINCOL", method.getName(), method.getDeclaringClass().getCanonicalName()), null, 11227);
            }
            bl2 = true;
            object = method.getAnnotation(JoinPoint.class).value();
            if (object != null) {
                beanPropertyInformationArray = new BeanPropertyInformation[((JoinColumn[])object).length];
                int n2 = 0;
                for (JoinColumn joinColumn : object) {
                    beanPropertyInformationArray[n2++] = PropertyIntrospector.getJoinColumnValues(joinColumn);
                }
                if (beanPropertyInformationArray.length == 1 && "*".equals(beanPropertyInformationArray[0].getColumnName()) && beanPropertyInformationArray[0].getTableName() == null && "*".equals(beanPropertyInformationArray[0].getJoinPointPropertyName()) && (object = method.getAnnotation(JoinPoint.class).joinCol()) != null) {
                    beanPropertyInformationArray = new BeanPropertyInformation[((JoinColumn[])object).length];
                    n2 = 0;
                    for (JoinColumn joinColumn : object) {
                        beanPropertyInformationArray[n2++] = PropertyIntrospector.getJoinColumnValues(joinColumn);
                    }
                }
            }
        }
        if (method.isAnnotationPresent(JoinColumn.class)) {
            if (bl2) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_JOINCOL", method.getName(), method.getDeclaringClass().getCanonicalName()), null, 11228);
            }
            bl3 = true;
            object = method.getAnnotation(JoinColumn.class);
            beanPropertyInformationArray = new BeanPropertyInformation[]{PropertyIntrospector.getJoinColumnValues((JoinColumn)object)};
        }
        return beanPropertyInformationArray;
    }

    class MethodsForProperty {
        private AccessorType currentAccessorMethod;
        private Method method;
        private String getMethod;
        private String setMethod;
        private String isMethod;
        private Method matchedGetter;
        private Method matchedSetter;
        private Method matchedIs;
        private boolean duplicateMethodFound;
        private boolean getAndIsMethodExist;
        private boolean methodNameHasMatched;

        MethodsForProperty() {
        }
    }

    private static enum AccessorType {
        GET,
        SET,
        IS;

    }
}

