/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.proxy;

import com.ibm.db2.cmx.client.ManageableProxy;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.proxy.PDQProxy;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcStatementInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ExecutionHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProxiedJdbcResultSetInvocationHandler
implements ManageableProxy,
InvocationHandler,
PDQProxy {
    boolean isMonitoringEnabled_;
    ExecutionHandler target_;
    boolean managed_;
    ProxiedJdbcStatementInvocationHandler statementInvocationHandler_;
    private Object resultSetProxy_;
    private static Logger logger__ = Log.getCMXClientLogger();

    public ProxiedJdbcResultSetInvocationHandler(ExecutionHandler executionHandler, ProxiedJdbcStatementInvocationHandler proxiedJdbcStatementInvocationHandler, boolean bl2) {
        this.target_ = executionHandler;
        this.statementInvocationHandler_ = proxiedJdbcStatementInvocationHandler;
        this.isMonitoringEnabled_ = bl2;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        boolean bl2;
        Object object2 = null;
        String string = method.getName();
        if (logger__.isLoggable(Level.FINER) && !"toString".equals(string) && !"hashCode".equals(string) && !"equals".equals(string)) {
            DataLogger.logAtLevelFiner(logger__, this, "invoke: " + string, "ENTRY " + Arrays.deepToString(objectArray));
            bl2 = true;
        } else {
            bl2 = false;
        }
        try {
            char c10 = string.charAt(0);
            if (this.statementInvocationHandler_.statementBean_.statementTimerStarted()) {
                this.statementInvocationHandler_.connectionInvocationHandler_.startTransactionIfNotStartedAndMonitoringIsEnabled();
            }
            switch (c10) {
                case 'c': {
                    if (string.startsWith("close")) {
                        object2 = this.target_.invoke(string, method, objectArray);
                        if (this.isMonitoringEnabled_) {
                            this.statementInvocationHandler_.completeAndReportStatement();
                        }
                        break;
                    }
                    object2 = this.target_.invoke(string, method, objectArray);
                    break;
                }
                case 'e': {
                    if (string.equals("equals")) {
                        object2 = this.equals(objectArray[0]);
                        break;
                    }
                    object2 = this.target_.invoke(string, method, objectArray);
                    break;
                }
                case 'g': {
                    if (string.startsWith("getStatement")) {
                        object2 = this.statementInvocationHandler_.getStatementProxy();
                        break;
                    }
                    object2 = this.target_.invoke(string, method, objectArray);
                    break;
                }
                case 'n': {
                    if (string.startsWith("next")) {
                        object2 = this.target_.invoke(string, method, objectArray);
                        boolean bl3 = (Boolean)object2;
                        if (this.isMonitoringEnabled_) {
                            if (bl3) {
                                ++this.statementInvocationHandler_.statementBean_.numRowsReturned_;
                                break;
                            }
                            if (this.statementInvocationHandler_.resultSetType_ == 1003) {
                                this.statementInvocationHandler_.completeAndReportStatement();
                            }
                        }
                        break;
                    }
                    object2 = this.target_.invoke(string, method, objectArray);
                    break;
                }
                case 'p': {
                    if (string.startsWith("pushData")) {
                        this.pushData((Integer)objectArray[0], (Object[])objectArray[1], true);
                        break;
                    }
                    object2 = this.target_.invoke(string, method, objectArray);
                    break;
                }
                default: {
                    object2 = this.target_.invoke(string, method, objectArray);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SQLException) {
                this.statementInvocationHandler_.statementBean_.setFirstErrorCode(((SQLException)throwable).getErrorCode());
                this.statementInvocationHandler_.connectionInvocationHandler_.proxiedDataSource_.checkAndReportApplnException((SQLException)throwable);
            }
            DataLogger.logThrowable(logger__, throwable);
            throw throwable;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", method.getName(), illegalAccessException.getMessage()), illegalAccessException, 10604);
        }
        if (bl2) {
            DataLogger.exit(logger__, this, "invoke: " + string, object2);
        }
        return object2;
    }

    @Override
    public void pushData(int n2, Object[] objectArray, boolean bl2) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "pushData", "ENTRY " + Arrays.deepToString(new Object[]{n2, objectArray, bl2}));
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "pushData", null);
        }
    }

    public boolean equals(Object object) {
        return this == object || this.resultSetProxy_ == object;
    }

    public void setResultSetProxy(Object object) {
        this.resultSetProxy_ = object;
    }

    public Object getResultSetProxy() {
        return this.resultSetProxy_;
    }
}

