/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.GenerationException;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.tools.ManageRepository;
import com.ibm.db2.cmx.tools.Tool;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.Help;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.OptionsProcessor;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.cmx.tools.internal.repository.ManageRepositoryImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PureQueryUtility {
    public static final int RESULT_SUCCESS_ = 0;
    public static final int RESULT_MR_SKIP_ = 31;
    public static final int RESULT_COMPLETED_WITH_WARNINGS_ = 63;
    public static final int RESULT_COMPLETED_WITH_ERRORS_ = 127;
    public static final int RESULT_FAILURE_ = 255;
    protected final Tool tool_;
    protected final boolean utilityWillCreateADatabaseConnection_;
    protected final PrintWriter printWriter_;
    public static final String packageVersionAuto_ = "AUTO";
    public static final String optionsFileForBindDefaultInPureQueryXmlDirectory_ = "DEFAULT_IN_PUREQUERYXML_DIRECTORY";
    protected boolean calledMainMethod_ = false;
    protected String summaryLogFileName_ = null;
    protected Document document_ = null;
    protected Element rootElement_ = null;
    protected Element interfaceElement_ = null;
    protected Element exceptionElement = null;

    protected PureQueryUtility(Tool tool, boolean bl2, PrintWriter printWriter) {
        this.tool_ = tool;
        this.utilityWillCreateADatabaseConnection_ = bl2;
        this.printWriter_ = null != printWriter ? printWriter : new PrintWriter(System.out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mainImpl(String[] stringArray) {
        int n2;
        this.calledMainMethod_ = true;
        try {
            Configuration.printProductNameAndCopyrightInformation(this.printWriter_);
            UtilityResults utilityResults = this.processAll(stringArray);
            n2 = utilityResults.getReturnValue(false);
        }
        catch (Throwable throwable) {
            try {
                if (ToolsLogger.getLogger() != null) {
                    ToolsLogger.getLogger().log(Level.SEVERE, throwable.getMessage());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(this.printWriter_);
            }
            this.printMessageLineAndLog(throwable.getMessage());
            throwable.printStackTrace(this.printWriter_);
            n2 = 255;
        }
        finally {
            try {
                ToolsLogger.cleanupLoggerAndDetachDriverManagerLogAndConnectionLog(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.printWriter_);
            }
            this.calledMainMethod_ = false;
        }
        return n2;
    }

    public static void hidePasswordInSystemProps() {
        String string = System.getProperty("sun.java.command");
        if (string != null && string.length() > 0) {
            boolean bl2 = false;
            String string2 = string.toLowerCase();
            for (PossibleArgs possibleArgs : PossibleArgs.getAllOptionsWhichMaskUserValueInOutput()) {
                int n2 = string2.indexOf(possibleArgs.externalOptionName().toLowerCase());
                if (n2 > -1) {
                    if (!bl2) {
                        string = string + " ";
                        bl2 = true;
                    }
                    String string3 = possibleArgs.externalOptionNameWithoutDash() + "[ \t\n]+[^ ]*";
                    String string4 = possibleArgs.externalOptionNameWithoutDash() + " *****";
                    string = Pattern.compile(string3, 2).matcher(string).replaceAll(string4);
                }
                System.setProperty("sun.java.command", string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public UtilityResults processAll(String[] stringArray) {
        UtilityResults utilityResults;
        block46: {
            ArtifactOptionsSet[] artifactOptionsSetArray;
            block45: {
                utilityResults = new UtilityResults();
                ArtifactOptionsSet artifactOptionsSet = null;
                artifactOptionsSetArray = null;
                artifactOptionsSet = OptionsProcessor.getArtifactOptionsSetAndConfigureLogger(this.tool_, stringArray, OptionsProcessor.TypeOfOptions.COMMAND_LINE, null, this.utilityWillCreateADatabaseConnection_);
                if (artifactOptionsSet.isHelpRequested()) {
                    Help.displayHelp(this.tool_, this.printWriter_);
                    break block45;
                }
                if (!artifactOptionsSet.checkIfOptionsAreValidAndLogWarningsForOptionsThatWillBeIgnored()) {
                    utilityResults.generalFailure = true;
                    this.printFailure(null, null, artifactOptionsSet);
                    break block45;
                }
                artifactOptionsSetArray = OptionsProcessor.getAllArtifactOptionsSetsAndConfigureLogger(artifactOptionsSet, this.utilityWillCreateADatabaseConnection_, null, null);
                boolean bl2 = 1 == artifactOptionsSetArray.length;
                for (ArtifactOptionsSet artifactOptionsSet2 : artifactOptionsSetArray) {
                    UtilityResult utilityResult = this.processSingleArtifactAndPrintResult(artifactOptionsSet2, false, bl2);
                    utilityResults.addResult(utilityResult);
                }
            }
            try {
                this.finishProcessingAndCleanupEnvironment(artifactOptionsSetArray, utilityResults);
            }
            catch (Throwable throwable) {
                this.printHorizontalLine();
                this.printMessageLineAndLog(Messages.getText("ERR_FINISHPROCESSING_OR_ENVIRONMENTCLEANUP", this.getUtilityName()));
                throwable.printStackTrace(this.printWriter_);
            }
            try {
                this.printResults(utilityResults, artifactOptionsSetArray);
            }
            catch (Throwable throwable) {
                this.printMessageLineAndLog(this.getMessageForFailure(artifactOptionsSetArray));
                throwable.printStackTrace(this.printWriter_);
            }
            try {
                this.printWriter_.flush();
            }
            catch (Throwable throwable) {
                this.printMessageLineAndLog(this.getMessageForFailure(artifactOptionsSetArray));
                throwable.printStackTrace(this.printWriter_);
            }
            try {
                if (!this.calledMainMethod_) {
                    ToolsLogger.cleanupLoggerAndDetachDriverManagerLogAndConnectionLog(null);
                }
                break block46;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.printWriter_);
            }
            break block46;
            catch (DataRuntimeException dataRuntimeException) {
                utilityResults.generalFailure = true;
                this.printFailure(dataRuntimeException, null, artifactOptionsSetArray);
                try {
                    this.finishProcessingAndCleanupEnvironment(artifactOptionsSetArray, utilityResults);
                }
                catch (Throwable throwable) {
                    this.printHorizontalLine();
                    this.printMessageLineAndLog(Messages.getText("ERR_FINISHPROCESSING_OR_ENVIRONMENTCLEANUP", this.getUtilityName()));
                    throwable.printStackTrace(this.printWriter_);
                }
                try {
                    this.printResults(utilityResults, artifactOptionsSetArray);
                }
                catch (Throwable throwable) {
                    this.printMessageLineAndLog(this.getMessageForFailure(artifactOptionsSetArray));
                    throwable.printStackTrace(this.printWriter_);
                }
                try {
                    this.printWriter_.flush();
                }
                catch (Throwable throwable) {
                    this.printMessageLineAndLog(this.getMessageForFailure(artifactOptionsSetArray));
                    throwable.printStackTrace(this.printWriter_);
                }
                try {
                    if (!this.calledMainMethod_) {
                        ToolsLogger.cleanupLoggerAndDetachDriverManagerLogAndConnectionLog(null);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(this.printWriter_);
                }
            }
            catch (Throwable throwable) {
                utilityResults.generalFailure = true;
                DataRuntimeException dataRuntimeException = ExceptionFactory.createDataRuntimeExceptionForToolsOnly(this.getMessageForFailure(artifactOptionsSetArray), throwable, 10777);
                this.printFailure(dataRuntimeException, null, artifactOptionsSetArray);
                {
                    catch (Throwable throwable2) {
                        try {
                            this.finishProcessingAndCleanupEnvironment(artifactOptionsSetArray, utilityResults);
                        }
                        catch (Throwable throwable3) {
                            this.printHorizontalLine();
                            this.printMessageLineAndLog(Messages.getText("ERR_FINISHPROCESSING_OR_ENVIRONMENTCLEANUP", this.getUtilityName()));
                            throwable3.printStackTrace(this.printWriter_);
                        }
                        try {
                            this.printResults(utilityResults, artifactOptionsSetArray);
                        }
                        catch (Throwable throwable4) {
                            this.printMessageLineAndLog(this.getMessageForFailure(artifactOptionsSetArray));
                            throwable4.printStackTrace(this.printWriter_);
                        }
                        try {
                            this.printWriter_.flush();
                        }
                        catch (Throwable throwable5) {
                            this.printMessageLineAndLog(this.getMessageForFailure(artifactOptionsSetArray));
                            throwable5.printStackTrace(this.printWriter_);
                        }
                        try {
                            if (!this.calledMainMethod_) {
                                ToolsLogger.cleanupLoggerAndDetachDriverManagerLogAndConnectionLog(null);
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable6.printStackTrace(this.printWriter_);
                        }
                        throw throwable2;
                    }
                }
                try {
                    this.finishProcessingAndCleanupEnvironment(artifactOptionsSetArray, utilityResults);
                }
                catch (Throwable throwable7) {
                    this.printHorizontalLine();
                    this.printMessageLineAndLog(Messages.getText("ERR_FINISHPROCESSING_OR_ENVIRONMENTCLEANUP", this.getUtilityName()));
                    throwable7.printStackTrace(this.printWriter_);
                }
                try {
                    this.printResults(utilityResults, artifactOptionsSetArray);
                }
                catch (Throwable throwable8) {
                    this.printMessageLineAndLog(this.getMessageForFailure(artifactOptionsSetArray));
                    throwable8.printStackTrace(this.printWriter_);
                }
                try {
                    this.printWriter_.flush();
                }
                catch (Throwable throwable9) {
                    this.printMessageLineAndLog(this.getMessageForFailure(artifactOptionsSetArray));
                    throwable9.printStackTrace(this.printWriter_);
                }
                try {
                    if (!this.calledMainMethod_) {
                        ToolsLogger.cleanupLoggerAndDetachDriverManagerLogAndConnectionLog(null);
                    }
                }
                catch (Throwable throwable10) {
                    throwable10.printStackTrace(this.printWriter_);
                }
            }
        }
        return utilityResults;
    }

    protected void finishProcessingAndCleanupEnvironment(ArtifactOptionsSet[] artifactOptionsSetArray, UtilityResults utilityResults) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UtilityResult processSingleArtifactAndPrintResult(ArtifactOptionsSet artifactOptionsSet, boolean bl2, boolean bl3) {
        String string;
        UtilityResult utilityResult = new UtilityResult(UtilityResultType.FAILURE);
        DataRuntimeException dataRuntimeException = null;
        try {
            this.printHorizontalLine();
            this.printSingleArtifactStart(artifactOptionsSet);
            if (!artifactOptionsSet.isArtifactToProcessValidForThisTool()) {
                utilityResult = new UtilityResult(UtilityResultType.SKIP);
                utilityResult.reason = string = PureQueryUtility.getMessageForWrongArtifactType(this.tool_);
            } else if (!artifactOptionsSet.checkIfOptionsAreValidAndLogWarningsForOptionsThatWillBeIgnored()) {
                utilityResult = new UtilityResult(UtilityResultType.FAILURE);
                utilityResult.reason = artifactOptionsSet.getErrorMessages(false, false, artifactOptionsSet.getArtifactName());
            } else {
                try {
                    this.printMessageLineAndLog(Messages.getText("MSG_STARTING_TO_PROCESS_OPTIONS", artifactOptionsSet.getAllOptionsAndArtifactsAsString(false)));
                    this.logSingleArtifactStartOrEnd(true, artifactOptionsSet);
                    artifactOptionsSet.recordOptionsAndArtifactsUsed(true);
                    utilityResult = this.processSingleArtifact(artifactOptionsSet, bl3);
                    artifactOptionsSet.recordOptionsAndArtifactsUsed(false);
                    this.logSingleArtifactStartOrEnd(false, artifactOptionsSet);
                }
                catch (DataRuntimeException dataRuntimeException2) {
                    utilityResult = new UtilityResult(UtilityResultType.FAILURE);
                    this.printException(dataRuntimeException2);
                    dataRuntimeException = dataRuntimeException2;
                }
                catch (Throwable throwable) {
                    utilityResult = new UtilityResult(UtilityResultType.FAILURE);
                    dataRuntimeException = ExceptionFactory.createDataRuntimeExceptionForToolsOnly(this.getMessageForFailure(artifactOptionsSet), throwable, 10800);
                }
                finally {
                    artifactOptionsSet.recordOptionsAndArtifactsUsed(false);
                }
            }
            switch (utilityResult.utilityResultType) {
                case SUCCESS: {
                    this.printSuccess(artifactOptionsSet, utilityResult);
                    break;
                }
                case COMPLETED_WITH_WARNINGS: {
                    this.printCompletedWithWarnings(artifactOptionsSet, utilityResult);
                    break;
                }
                case COMPLETED_WITH_ERRORS: {
                    this.printCompletedWithErrors(artifactOptionsSet, utilityResult);
                    break;
                }
                case FAILURE: {
                    this.printFailure(dataRuntimeException, utilityResult, artifactOptionsSet);
                    break;
                }
                case SKIP: 
                case MR_SKIP: {
                    this.printSkipped(artifactOptionsSet, utilityResult);
                    break;
                }
                default: {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{this.tool_}), null, 10801);
                }
            }
            if (artifactOptionsSet.getOptionValueBoolean(PossibleArgs.SHOW_DETAILS)) {
                this.printShowDetails(artifactOptionsSet, utilityResult);
            }
        }
        catch (Throwable throwable) {
            utilityResult.utilityResultType = UtilityResultType.FAILURE;
            dataRuntimeException = throwable instanceof DataRuntimeException ? (DataRuntimeException)throwable : ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_GENERAL_ERROR", new Object[0]), throwable, 10812);
            this.printMessageLineAndLog("");
            dataRuntimeException.printStackTrace(this.printWriter_);
        }
        if (bl2) {
            if (null != dataRuntimeException) {
                throw dataRuntimeException;
            }
            if (!utilityResult.noFailures()) {
                string = this.getMessageForFailure(artifactOptionsSet);
                String string2 = null != utilityResult.reason ? utilityResult.reason : "";
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(string + "  " + string2, null, 10811);
            }
        }
        return utilityResult;
    }

    public void printException(DataRuntimeException dataRuntimeException) {
        String string = null;
        if (dataRuntimeException instanceof GenerationException) {
            string = ((GenerationException)dataRuntimeException).getSqlStmt();
        }
        if (this.document_ != null) {
            this.exceptionElement = this.document_.createElement("exception");
            if (dataRuntimeException.getErrorCode() != null) {
                this.exceptionElement.setAttribute("sqlCode", dataRuntimeException.getErrorCode().toString());
            }
            if (dataRuntimeException.getSQLState() != null) {
                this.exceptionElement.setAttribute("sqlState", dataRuntimeException.getSQLState());
            }
            Element element = this.document_.createElement("message");
            element.setTextContent(dataRuntimeException.getMessage());
            this.exceptionElement.appendChild(element);
            if (string != null) {
                Element element2 = this.document_.createElement("sqlStatement");
                element2.setTextContent(string);
                this.exceptionElement.appendChild(element2);
            }
            if (dataRuntimeException.getNextException() != null) {
                this.exceptionElement.setAttribute("causedBy", dataRuntimeException.getNextException().getMessage());
            }
            this.interfaceElement_.appendChild(this.exceptionElement);
        }
    }

    protected abstract UtilityResult processSingleArtifact(ArtifactOptionsSet var1, boolean var2) throws Exception;

    private void logSingleArtifactStartOrEnd(boolean bl2, ArtifactOptionsSet artifactOptionsSet) {
        String string;
        String string2 = null;
        PossibleArgs possibleArgs = null;
        String string3 = null;
        if (null != artifactOptionsSet) {
            possibleArgs = artifactOptionsSet.getArtifactType();
            string3 = artifactOptionsSet.getArtifactStatementSet();
            string2 = artifactOptionsSet.getArtifactName();
        }
        switch (this.tool_) {
            case GENERATOR: {
                if (bl2) {
                    string = "generating: " + string2;
                    break;
                }
                string = "generation complete: " + string2;
                break;
            }
            case CONFIGURE: {
                if (bl2) {
                    string = "configuring: " + string2;
                    break;
                }
                string = "configure complete: " + string2;
                break;
            }
            case VALIDATOR: {
                if (bl2) {
                    string = "validating: " + string2;
                    break;
                }
                string = "validation complete: " + string2;
                break;
            }
            case BINDER: {
                boolean bl3;
                boolean bl4 = artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.VERIFY_PACKAGES);
                boolean bl5 = bl3 = !bl4 && artifactOptionsSet.getOptionValueBoolean(PossibleArgs.GENERATE_DBRM);
                if (bl4) {
                    if (bl2) {
                        if (null != string3) {
                            string = "begin verifying the packages associated with the statement set '" + string3 + "' in '" + string2 + "'";
                            break;
                        }
                        string = "begin verifying the packages associated with: '" + string2 + "'";
                        break;
                    }
                    if (null != string3) {
                        string = "completed verifying the packages associated with the statement set '" + string3 + "' in '" + string2 + "'";
                        break;
                    }
                    string = "completed verifying the packages associated with: '" + string2 + "'";
                    break;
                }
                if (bl3) {
                    if (bl2) {
                        if (null != string3) {
                            string = "begin generating DBRM: " + string2;
                            break;
                        }
                        string = "begin generating DBRM: " + string2;
                        break;
                    }
                    if (null != string3) {
                        string = "completed generating DBRMs: " + string2;
                        break;
                    }
                    string = "completed generating DBRMs: " + string2;
                    break;
                }
                if (PossibleArgs.PUREQUERY_XML_FILE == possibleArgs) {
                    if (bl2) {
                        if (null != string3) {
                            string = Messages.getText("MSG_BEGIN_BIND_STATEMENTSET", string3, string2);
                            break;
                        }
                        string = Messages.getText("MSG_BIND_PUREQUERYXML_BEGIN", string2);
                        break;
                    }
                    if (null != string3) {
                        string = Messages.getText("MSG_COMPLETED_STATEMENTSET", string3, string2);
                        break;
                    }
                    string = Messages.getText("MSG_COMPLETED_BIND", string2);
                    break;
                }
                if (PossibleArgs.INTERFACE == possibleArgs) {
                    if (bl2) {
                        string = Messages.getText("MSG_BIND_INTERFACE_BEGIN", string2);
                        break;
                    }
                    string = Messages.getText("MSG_COMPLETED_BIND", string2);
                    break;
                }
                if (bl2) {
                    string = "begin binding: " + string2;
                    break;
                }
                string = "completed binding: " + string2;
                break;
            }
            case MERGE: {
                if (bl2) {
                    string = "Merging the input files to create the output file: " + string2;
                    break;
                }
                string = "Merge complete. Merged file contents written to " + string2;
                break;
            }
            case GENERATE_PUREQUERYXML: {
                if (bl2) {
                    string = "Starting to generate the pureQueryXml file: " + string2;
                    break;
                }
                string = "Finished generating the pureQueryXml file:" + string2;
                break;
            }
            case MANAGE_REPOSITORY: {
                String string4 = this.getStringFromSet(ManageRepositoryImpl.getActionNames(artifactOptionsSet));
                if (bl2) {
                    string = "The " + ManageRepository.class.getSimpleName() + " utility is starting to perform the following action(s): " + string4;
                    break;
                }
                string = "The " + ManageRepository.class.getSimpleName() + " utility finished performing the following action(s): " + string4;
                break;
            }
            case METADATAREPLACER: {
                if (bl2) {
                    string = "replacing identifiers in: " + string2;
                    break;
                }
                string = "Finished replacing identifiers in: " + string2;
                break;
            }
            default: {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{this.tool_}), null, 10802);
            }
        }
        ToolsLogger.getLogger().log(Level.FINE, string);
    }

    protected void printHorizontalLine() {
        this.printMessageLineAndLog("");
        this.printMessageLineAndLog("================================================================================");
        this.printMessageLineAndLog("");
    }

    private void printSingleArtifactStart(ArtifactOptionsSet artifactOptionsSet) {
        String string;
        String string2 = null;
        PossibleArgs possibleArgs = null;
        PossibleArgs.PredefinedOptionValues predefinedOptionValues = null;
        boolean bl2 = false;
        String string3 = null;
        if (null != artifactOptionsSet) {
            string2 = artifactOptionsSet.getArtifactName();
            possibleArgs = artifactOptionsSet.getArtifactType();
            predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.VERIFY_PACKAGES);
            bl2 = artifactOptionsSet.getOptionValueBoolean(PossibleArgs.GENERATE_DBRM);
            string3 = artifactOptionsSet.getArtifactStatementSet();
        }
        switch (this.tool_) {
            case BINDER: {
                if (PossibleArgs.PredefinedOptionValues.DETAIL == predefinedOptionValues) {
                    if (null != string3) {
                        string = Messages.getText("MSG_START_BIND_VERIFY_DETAIL_STATEMENTSET", string3, string2);
                        break;
                    }
                    string = Messages.getText("MSG_VERIFY_PKG_DETAIL", string2);
                    break;
                }
                if (PossibleArgs.PredefinedOptionValues.SUMMARY == predefinedOptionValues) {
                    if (null != string3) {
                        string = Messages.getText("MSG_START_BIND_VERIFY_SUMMARY_STATEMENTSET", string3, string2);
                        break;
                    }
                    string = Messages.getText("MSG_VERIFY_PKG_SUMMARY", string2);
                    break;
                }
                if (null != predefinedOptionValues) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10803);
                }
                if (bl2) {
                    string = Messages.getText("MSG_DBRM_START", new Object[0]);
                    break;
                }
                if (PossibleArgs.PUREQUERY_XML_FILE == possibleArgs) {
                    if (null != string3) {
                        string = Messages.getText("MSG_BEGIN_BIND_STATEMENTSET", string3, string2);
                        break;
                    }
                    string = Messages.getText("MSG_BIND_PUREQUERYXML_BEGIN", string2);
                    break;
                }
                string = Messages.getText("MSG_BEGIN_BIND_ARTIFACT2", string2);
                break;
            }
            default: {
                string = null;
            }
        }
        if (null != string) {
            this.printMessageLineAndLog(string);
            this.printMessageLineAndLog("");
        }
    }

    private void printSkipped(ArtifactOptionsSet artifactOptionsSet, UtilityResult utilityResult) {
        String string;
        String string2 = null;
        String string3 = null;
        if (null != artifactOptionsSet) {
            string2 = artifactOptionsSet.getArtifactName();
            string3 = artifactOptionsSet.getArtifactStatementSet();
        }
        String string4 = null != utilityResult.reason ? utilityResult.reason : "";
        String string5 = null != utilityResult ? utilityResult.messagesToPrint : null;
        switch (this.tool_) {
            case GENERATOR: {
                string = Messages.getText("MSG_SKIP_GENERATOR_ARTIFACT", string2, string4);
                break;
            }
            case CONFIGURE: {
                string = Messages.getText("MSG_SKIP_CONFIGURE_ARTIFACT", string2, string4);
                break;
            }
            case METADATAREPLACER: {
                string = Messages.getText("MSG_SKIP_METADATAREPLACER", string2, string4);
                break;
            }
            case BINDER: {
                if (null != string3) {
                    string = Messages.getText("MSG_SKIP_BINDER_STATEMENTSET", string3, string2, string4);
                    break;
                }
                string = Messages.getText("MSG_SKIP_BINDER_ARTIFACT", string2, string4);
                break;
            }
            case MERGE: {
                string = Messages.getText("MSG_SKIP_MERGE_ARTIFACT", string2, string4);
                break;
            }
            case VALIDATOR: {
                string = Messages.getText("MSG_SKIP_VALIDATOR_ARTIFACT", string2, string4);
                break;
            }
            case GENERATE_PUREQUERYXML: {
                string = Messages.getText("MSG_SKIP_GENERATEPUREQUERYXML_ARTIFACT", string2, string4);
                break;
            }
            case MANAGE_REPOSITORY: {
                ArrayList<String> arrayList = new ArrayList<String>();
                PossibleArgs.PredefinedOptionValues predefinedOptionValues = null;
                String string6 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_ID);
                predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.CREATE);
                if (null != predefinedOptionValues) {
                    switch (predefinedOptionValues) {
                        case REPOSITORY: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_CREATE_REPOSITORY", string4));
                            break;
                        }
                        case RUNTIME_GROUP: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_CREATE_RUNTIMEGROUP", string6, string4));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10983);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.UPGRADE))) {
                    switch (predefinedOptionValues) {
                        case REPOSITORY: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_UPGRADE_REPOSITORY", string4));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11241);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.UPDATE))) {
                    switch (predefinedOptionValues) {
                        case RUNTIME_GROUP: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_UPDATE_RUNTIMEGROUP", string6, string4));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10984);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.DELETE))) {
                    switch (predefinedOptionValues) {
                        case REPOSITORY: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_REMOVE_REPOSITORY", string4));
                            break;
                        }
                        case RUNTIME_GROUP: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_REMOVE_RUNTIMEGROUP", string6, string4));
                            break;
                        }
                        case INCREMENTAL: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_REMOVE_INCREMENTAL", string4));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10985);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.ACTIVATE))) {
                    switch (predefinedOptionValues) {
                        case RUNTIME_GROUP: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_ACTIVATE_RUNTIMEGROUP", string6, string4));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10986);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.DEACTIVATE))) {
                    switch (predefinedOptionValues) {
                        case RUNTIME_GROUP: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_DEACTIVATE_RUNTIMEGROUP", string6, string4));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10987);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.COPY))) {
                    switch (predefinedOptionValues) {
                        case RUNTIME_GROUP: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_COPY_RUNTIMEGROUP", string6, string4));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10988);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.LIST))) {
                    switch (predefinedOptionValues) {
                        case RUNTIME_GROUP_VERSIONS: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_LIST_RUNTIMEGROUP", string6, string4));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10989);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.EXTRACT))) {
                    switch (predefinedOptionValues) {
                        case RUNTIME_GROUP: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_EXTRACT_RUNTIMEGROUP", string6, string4));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10990);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.VERIFY))) {
                    switch (predefinedOptionValues) {
                        case REPOSITORY: {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_SKIP_VERIFY_REPOSITORY", string4));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10994);
                        }
                    }
                }
                if (0 == arrayList.size()) {
                    string = "";
                    break;
                }
                string = (String)arrayList.get(0);
                for (int i10 = 1; i10 < arrayList.size(); ++i10) {
                    string = string + "\n" + (String)arrayList.get(1);
                }
                break;
            }
            default: {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{this.tool_}), null, 10804);
            }
        }
        this.printMessageLineAndLog(string);
        if (null != string5 && 0 < string5.length()) {
            this.printMessageLineAndLog("");
            this.printMessageLineAndLog(string5);
        }
    }

    private void printSuccess(ArtifactOptionsSet artifactOptionsSet, UtilityResult utilityResult) {
        Object object;
        String string;
        String string2 = null;
        String string3 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (null != artifactOptionsSet) {
            string2 = artifactOptionsSet.getArtifactName();
            bl2 = artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.VERIFY_PACKAGES);
            bl3 = artifactOptionsSet.getOptionValueBoolean(PossibleArgs.GENERATE_DBRM);
            string3 = artifactOptionsSet.getArtifactStatementSet();
        }
        String string4 = null != utilityResult ? utilityResult.reason : null;
        String string5 = null != utilityResult ? utilityResult.messagesToPrint : null;
        switch (this.tool_) {
            case GENERATOR: {
                string = Messages.getText("MSG_GEN_SUCC", string2);
                break;
            }
            case BINDER: {
                if (bl2) {
                    string = "";
                    break;
                }
                if (bl3) {
                    if (null != string3) {
                        string = Messages.getText("MSG_SUCCESS_BIND_GENERATEDBRM_STATEMENTSET", string3, string2);
                        break;
                    }
                    string = Messages.getText("MSG_SUCCESS_BIND_GENERATEDBRM_ARTIFACT", string2);
                    break;
                }
                if (null != string3) {
                    string = Messages.getText("MSG_SUCCESS_BIND_STATEMENTSET", string3, string2);
                    break;
                }
                string = Messages.getText("MSG_SUCCESS_BIND", string2);
                break;
            }
            case CONFIGURE: {
                string = Messages.getText("MSG_CONFIGURE_SUCC", string2);
                break;
            }
            case METADATAREPLACER: {
                string = Messages.getText("MSG_METADATAREPLACER_SUCC", string2);
                break;
            }
            case MERGE: {
                string = Messages.getText("MSG_MERGE_SUCC", new Object[0]);
                break;
            }
            case VALIDATOR: {
                string = Messages.getText("MSG_VALIDATOR_SUCC", string2);
                break;
            }
            case GENERATE_PUREQUERYXML: {
                string = Messages.getText("MSG_GENERATEPUREQUERYXML_SUCC", string2);
                break;
            }
            case MANAGE_REPOSITORY: {
                object = new ArrayList();
                PossibleArgs.PredefinedOptionValues predefinedOptionValues = null;
                String string6 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_ID);
                String string7 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_VERSION);
                PossibleArgs.PredefinedOptionValues predefinedOptionValues2 = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.ACCESS_LEVEL);
                predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.CREATE);
                if (null != predefinedOptionValues) {
                    if (artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.GENERATE_SCRIPT_ONLY) && predefinedOptionValues == PossibleArgs.PredefinedOptionValues.REPOSITORY) {
                        object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_CREATE_SCRIPT", new Object[0]));
                    } else {
                        switch (predefinedOptionValues) {
                            case REPOSITORY: {
                                object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_CREATE_REPOSITORY", new Object[0]));
                                break;
                            }
                            case RUNTIME_GROUP: {
                                object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_CREATE_RUNTIMEGROUP_VERSION", string6, string7));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10995);
                            }
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.UPDATE))) {
                    switch (predefinedOptionValues) {
                        case REPOSITORY: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_UPDATE_REPOSITORY", new Object[0]));
                            break;
                        }
                        case RUNTIME_GROUP: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_UPDATE_RUNTIMEGROUP_VERSION", string6, string7));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10996);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.DELETE))) {
                    if (artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.GENERATE_SCRIPT_ONLY) != null && predefinedOptionValues == PossibleArgs.PredefinedOptionValues.REPOSITORY) {
                        object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_REMOVE_SCRIPT", new Object[0]));
                    } else {
                        switch (predefinedOptionValues) {
                            case REPOSITORY: {
                                object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_REMOVE_REPOSITORY", new Object[0]));
                                break;
                            }
                            case RUNTIME_GROUP: {
                                object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_REMOVE_RUNTIMEGROUP", string6));
                                break;
                            }
                            case INCREMENTAL: {
                                object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_REMOVE_INCREMENTAL", new Object[0]));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10997);
                            }
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.ACTIVATE))) {
                    switch (predefinedOptionValues) {
                        case RUNTIME_GROUP: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_ACTIVATE_RUNTIMEGROUP_VERSION", string6, string7));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10998);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.DEACTIVATE))) {
                    switch (predefinedOptionValues) {
                        case RUNTIME_GROUP: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_DEACTIVATE_RUNTIMEGROUP", string6));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10999);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.COPY))) {
                    switch (predefinedOptionValues) {
                        case RUNTIME_GROUP: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_COPY_RUNTIMEGROUP", string6));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11000);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.LIST))) {
                    switch (predefinedOptionValues) {
                        case RUNTIME_GROUP_VERSIONS: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_LIST_RUNTIMEGROUP", new Object[0]));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11001);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.EXTRACT))) {
                    switch (predefinedOptionValues) {
                        case RUNTIME_GROUP: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_EXTRACT_RUNTIMEGROUP", string6));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11002);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.EXPORT))) {
                    switch (predefinedOptionValues) {
                        case REPOSITORY: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_EXPORT_RUNTIMEGROUP_VERSION", string6, string7));
                            break;
                        }
                        case RUNTIME_GROUP: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_EXPORT_RUNTIMEGROUP_VERSION", string6, string7));
                            break;
                        }
                        case IMPORT_OR_EXPORT_DATA: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_EXPORT_RUNTIMEGROUP_VERSION", string6, string7));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11003);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.IMPORT))) {
                    switch (predefinedOptionValues) {
                        case REPOSITORY: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_IMPORT_RUNTIMEGROUP_VERSION", string6, string7));
                            break;
                        }
                        case RUNTIME_GROUP: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_IMPORT_RUNTIMEGROUP_VERSION", string6, string7));
                            break;
                        }
                        case IMPORT_OR_EXPORT_DATA: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_IMPORT_RUNTIMEGROUP_VERSION", string6, string7));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11004);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.REPORT))) {
                    switch (predefinedOptionValues) {
                        case REPOSITORY_DATA: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_REPORT_REPOSITORYDATA", new Object[0]));
                            break;
                        }
                        case REPOSITORY_VERSION: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_REPORT_REPOSITORYVERSION", new Object[0]));
                            break;
                        }
                        case PUREQUERY_XML_CHANGES: {
                            object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_REPORT_PUREQUERYXMLCHANGES", new Object[0]));
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11005);
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.BIND))) {
                    if (artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.GENERATE_SCRIPT_ONLY) != null) {
                        object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_BIND_SCRIPT", new Object[0]));
                    } else {
                        switch (predefinedOptionValues) {
                            case PACKAGES: {
                                object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_BIND", new Object[0]));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11006);
                            }
                        }
                    }
                }
                if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.VERIFY))) {
                    if (artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.GENERATE_SCRIPT_ONLY) != null) {
                        object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_VERIFY_REPOSITORY_OBJECTS_SCRIPT", new Object[0]));
                    } else {
                        switch (predefinedOptionValues) {
                            case REPOSITORY: {
                                object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_VERIFY_REPOSITORY_OBJECTS", new Object[0]));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11007);
                            }
                        }
                    }
                }
                if (null != artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.GRANT_OPTIONS)) {
                    if (artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.GENERATE_SCRIPT_ONLY) != null) {
                        object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_GRANT_SCRIPT", new Object[]{predefinedOptionValues2}));
                    } else {
                        object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_GRANT", new Object[]{predefinedOptionValues2}));
                    }
                }
                if (null != artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.REVOKE)) {
                    if (artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.GENERATE_SCRIPT_ONLY) != null) {
                        object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_REVOKE_NO_ACCESSLEVEL_SCRIPT", new Object[0]));
                    } else {
                        object.add(Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS_REVOKE_NO_ACCESSLEVEL", new Object[0]));
                    }
                }
                if (0 == object.size()) {
                    string = Messages.getText("MSG_MANAGEREPOSITORY_SUCCESS", new Object[0]);
                    break;
                }
                string = (String)object.get(0);
                for (int i10 = 1; i10 < object.size(); ++i10) {
                    string = string + "\n" + (String)object.get(1);
                }
                break;
            }
            default: {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{this.tool_}), null, 10375);
            }
        }
        object = artifactOptionsSet.getErrorMessages(true, false, string2);
        if (null != object && 0 < ((String)object).length()) {
            this.printMessageLineAndLog("");
            this.printMessageLineAndLog((String)object);
        }
        if (null != string && 0 < string.length()) {
            this.printMessageLineAndLog("");
            this.printMessageLineAndLog(string);
        }
        if (null != string4 && 0 < string4.length()) {
            this.printMessageLineAndLog("");
            this.printMessageLineAndLog(string4);
        }
        if (null != string5 && 0 < string5.length()) {
            this.printMessageLineAndLog("");
            this.printMessageLineAndLog(string5);
        }
    }

    private void printCompletedWithWarnings(ArtifactOptionsSet artifactOptionsSet, UtilityResult utilityResult) {
        String string = null;
        String string2 = null;
        if (null != artifactOptionsSet) {
            string = artifactOptionsSet.getArtifactName();
            string2 = artifactOptionsSet.getArtifactStatementSet();
        }
        String string3 = null != utilityResult ? utilityResult.reason : null;
        String string4 = null != utilityResult ? utilityResult.messagesToPrint : null;
        boolean bl2 = null != string && 0 < string.length();
        String string5 = "";
        switch (this.tool_) {
            case BINDER: {
                if (bl2 && null != string2) {
                    string5 = Messages.getText("MSG_COMPLETED_WITH_WARNINGS_BIND_STATEMENTSET", string2, string);
                    break;
                }
                if (bl2) {
                    string5 = Messages.getText("MSG_COMPLETED_WITH_WARNINGS_BIND_ARTIFACT", string);
                    break;
                }
                string5 = Messages.getText("MSG_COMPLETED_WITH_WARNINGS_BIND", new Object[0]);
                break;
            }
            case CONFIGURE: {
                if (bl2) {
                    string5 = Messages.getText("MSG_COMPLETED_WITH_WARNINGS_CONFIGURE_ARTIFACT", string);
                    break;
                }
                string5 = Messages.getText("MSG_COMPLETED_WITH_WARNINGS_CONFIGURE_NO_ARTIFACT", new Object[0]);
                break;
            }
            default: {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{this.tool_}), null, 10822);
            }
        }
        String string6 = artifactOptionsSet.getErrorMessages(true, false, string);
        if (null != string6 && 0 < string6.length()) {
            this.printMessageLineAndLog("");
            this.printMessageLineAndLog(string6);
        }
        this.printMessageLineAndLog("");
        this.printMessageLineAndLog(string5);
        if (null != string3 && 0 < string3.length()) {
            this.printMessageLineAndLog("");
            this.printMessageLineAndLog(string3);
        }
        if (null != string4 && 0 < string4.length()) {
            this.printMessageLineAndLog("");
            this.printMessageLineAndLog(string4);
        }
    }

    private void printCompletedWithErrors(ArtifactOptionsSet artifactOptionsSet, UtilityResult utilityResult) {
        String string = null;
        String string2 = null;
        if (null != artifactOptionsSet) {
            string = artifactOptionsSet.getArtifactName();
            string2 = artifactOptionsSet.getArtifactStatementSet();
        }
        String string3 = null != utilityResult ? utilityResult.reason : null;
        String string4 = null != utilityResult ? utilityResult.messagesToPrint : null;
        boolean bl2 = null != string && 0 < string.length();
        String string5 = "";
        switch (this.tool_) {
            case BINDER: {
                if (bl2 && null != string2) {
                    string5 = Messages.getText("MSG_COMPLETED_WITH_ERRORS_BIND_STATEMENTSET", string2, string);
                    break;
                }
                if (bl2) {
                    string5 = Messages.getText("MSG_BIND_COMPLETED_WITH_ERRORS_FOR_ARTIFACT", string);
                    break;
                }
                string5 = Messages.getText("MSG_BIND_COMPLETED_WITH_ERRORS", new Object[0]);
                break;
            }
            default: {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{this.tool_}), null, 10823);
            }
        }
        String string6 = artifactOptionsSet.getErrorMessages(true, false, string);
        if (null != string6 && 0 < string6.length()) {
            this.printMessageLineAndLog("");
            this.printMessageLineAndLog(string6);
        }
        this.printMessageLineAndLog("");
        this.printMessageLineAndLog(string5);
        if (null != string3 && 0 < string3.length()) {
            this.printMessageLineAndLog("");
            this.printMessageLineAndLog(string3);
        }
        if (null != string4 && 0 < string4.length()) {
            this.printMessageLineAndLog("");
            this.printMessageLineAndLog(string4);
        }
    }

    protected void printFailure(DataRuntimeException dataRuntimeException, UtilityResult utilityResult, ArtifactOptionsSet ... artifactOptionsSetArray) {
        try {
            boolean bl2;
            String string;
            String string2;
            String string3 = this.getMessageForFailure(artifactOptionsSetArray);
            boolean bl3 = this.isForSingleArtifact(artifactOptionsSetArray);
            String string4 = Messages.getText("MSG_USAGE", Help.ARGS.defaultArgumentName());
            String string5 = null != utilityResult ? utilityResult.reason : null;
            String string6 = string2 = null != utilityResult ? utilityResult.messagesToPrint : null;
            string = null != artifactOptionsSetArray && 0 < artifactOptionsSetArray.length ? (string = artifactOptionsSetArray[0].getErrorMessages(false, !bl3, artifactOptionsSetArray[0].getArtifactName())) : null;
            boolean bl4 = bl2 = null != string && 0 != string.length();
            if (null != string5 && 0 < string5.length() && !string5.equals(string)) {
                this.printMessageLineAndLog("");
                this.printMessageLineAndLog(string5);
            }
            if (bl2) {
                this.printMessageLineAndLog("");
                this.printMessageLineAndLog(string);
            }
            if (null != string3 && 0 != string3.length()) {
                this.printMessageLineAndLog("");
                this.printMessageLineAndLog(string3);
            }
            if (null != dataRuntimeException) {
                this.printMessageLineAndLog("");
                dataRuntimeException.printStackTrace(this.printWriter_);
                ToolsLogger.getLogger().log(Level.FINE, dataRuntimeException.getMessage(), dataRuntimeException);
            }
            if (bl2) {
                this.printMessageLineAndLog("");
                this.printMessageLineAndLog(string4);
            }
            if (null != string2 && 0 < string2.length()) {
                this.printMessageLineAndLog("");
                this.printMessageLineAndLog(string2);
            }
        }
        catch (Throwable throwable) {
            DataRuntimeException dataRuntimeException2 = throwable instanceof DataRuntimeException ? (DataRuntimeException)throwable : ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_GENERAL_ERROR", new Object[0]), throwable, 10813);
            this.printMessageLineAndLog("");
            dataRuntimeException2.printStackTrace(this.printWriter_);
        }
    }

    protected String getMessageForFailure(ArtifactOptionsSet ... artifactOptionsSetArray) {
        String string = null;
        try {
            boolean bl2 = false;
            boolean bl3 = false;
            String string2 = null;
            String string3 = null;
            boolean bl4 = this.isForSingleArtifact(artifactOptionsSetArray);
            ArtifactOptionsSet artifactOptionsSet = null;
            if (null != artifactOptionsSetArray && 0 < artifactOptionsSetArray.length) {
                artifactOptionsSet = artifactOptionsSetArray[0];
                bl2 = artifactOptionsSetArray[0].isOptionOrArtifactSpecified(PossibleArgs.VERIFY_PACKAGES);
                bl3 = artifactOptionsSetArray[0].getOptionValueBoolean(PossibleArgs.GENERATE_DBRM);
                string2 = artifactOptionsSetArray[0].getArtifactName();
                string3 = artifactOptionsSetArray[0].getArtifactStatementSet();
            }
            switch (this.tool_) {
                case GENERATOR: {
                    if (bl4) {
                        string = Messages.getText("MSG_GEN_FAIL", string2);
                        break;
                    }
                    string = Messages.getText("MSG_FAILURE_GENERATOR_NO_COLON", new Object[0]);
                    break;
                }
                case BINDER: {
                    if (bl4) {
                        if (bl2) {
                            if (null != string3) {
                                string = Messages.getText("MSG_FAILURE_BIND_VERIFY_SINGLE_STATEMENTSET", string3, string2);
                                break;
                            }
                            string = Messages.getText("MSG_BIND_VERIFY_FAIL", string2);
                            break;
                        }
                        if (bl3) {
                            if (null != string3) {
                                string = Messages.getText("MSG_FAILURE_BIND_GENERATEDBRM_FAIL_STATEMENTSET", string3, string2);
                                break;
                            }
                            string = Messages.getText("MSG_FAILURE_BIND_GENERATEDBRM_FAIL_ARTIFACT", string2);
                            break;
                        }
                        if (null != string3) {
                            string = Messages.getText("MSG_FAILURE_BIND_STATEMENTSET", string3, string2);
                            break;
                        }
                        string = Messages.getText("MSG_BIND_FAILURE", string2);
                        break;
                    }
                    if (bl2) {
                        string = Messages.getText("MSG_BIND_VERIFY_FAIL2", new Object[0]);
                        break;
                    }
                    if (bl3) {
                        string = Messages.getText("MSG_FAILURE_BIND_GENERATEDBRM_FAIL", new Object[0]);
                        break;
                    }
                    string = Messages.getText("MSG_FAILURE_BIND_NO_COLON", new Object[0]);
                    break;
                }
                case CONFIGURE: {
                    if (bl4) {
                        string = Messages.getText("MSG_CONFIGURE_FAIL", string2);
                        break;
                    }
                    string = Messages.getText("ERR_PREBIND", new Object[0]);
                    break;
                }
                case METADATAREPLACER: {
                    string = bl4 ? Messages.getText("MSG_METADATAREPLACER_FAIL", string2) : Messages.getText("ERR_METADATAREPLACER", new Object[0]);
                }
                case MERGE: {
                    if (bl4) {
                        string = Messages.getText("MSG_FAILURE_MERGE_ARTIFACT", string2);
                        break;
                    }
                    string = Messages.getText("MSG_FAILURE_MERGE_NO_COLON", new Object[0]);
                    break;
                }
                case VALIDATOR: {
                    if (bl4) {
                        string = Messages.getText("MSG_FAILURE_VALIDATOR_ARTIFACT", string2);
                        break;
                    }
                    string = Messages.getText("MSG_FAILURE_VALIDATOR_NO_COLON", new Object[0]);
                    break;
                }
                case GENERATE_PUREQUERYXML: {
                    if (bl4) {
                        string = Messages.getText("MSG_FAILURE_GENERATEPUREQUERYXML_ARTIFACT", string2);
                        break;
                    }
                    string = Messages.getText("MSG_FAILURE_GENERATEPUREQUERYXML", new Object[0]);
                    break;
                }
                case MANAGE_REPOSITORY: {
                    if (null == artifactOptionsSet) {
                        string = Messages.getText("MSG_MANAGEREPOSITORY_FAILURE", new Object[0]);
                        break;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    PossibleArgs.PredefinedOptionValues predefinedOptionValues = null;
                    String string4 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_ID);
                    String string5 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_VERSION);
                    PossibleArgs.PredefinedOptionValues predefinedOptionValues2 = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.ACCESS_LEVEL);
                    predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.CREATE);
                    if (null != predefinedOptionValues) {
                        if (artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.GENERATE_SCRIPT_ONLY) && predefinedOptionValues == PossibleArgs.PredefinedOptionValues.REPOSITORY) {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_CREATE_SCRIPT", new Object[0]));
                        } else {
                            switch (predefinedOptionValues) {
                                case REPOSITORY: {
                                    arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_CREATE_REPOSITORY", new Object[0]));
                                    break;
                                }
                                case RUNTIME_GROUP: {
                                    arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_CREATE_RUNTIMEGROUP", string4));
                                    break;
                                }
                                default: {
                                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11008);
                                }
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.UPDATE))) {
                        switch (predefinedOptionValues) {
                            case REPOSITORY: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_UPDATE_REPOSITORY", new Object[0]));
                                break;
                            }
                            case RUNTIME_GROUP: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_UPDATE_RUNTIMEGROUP", string4));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11009);
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.DELETE))) {
                        if (artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.GENERATE_SCRIPT_ONLY) && predefinedOptionValues == PossibleArgs.PredefinedOptionValues.REPOSITORY) {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_REMOVE_SCRIPT", new Object[0]));
                        } else {
                            switch (predefinedOptionValues) {
                                case REPOSITORY: {
                                    arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_REMOVE_REPOSITORY", new Object[0]));
                                    break;
                                }
                                case RUNTIME_GROUP: {
                                    arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_REMOVE_RUNTIMEGROUP", string4));
                                    break;
                                }
                                case INCREMENTAL: {
                                    arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_REMOVE_INCREMENTAL", new Object[0]));
                                    break;
                                }
                                default: {
                                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11010);
                                }
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.ACTIVATE))) {
                        switch (predefinedOptionValues) {
                            case RUNTIME_GROUP: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_ACTIVATE_RUNTIMEGROUP_VERSION", string4, string5));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11011);
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.DEACTIVATE))) {
                        switch (predefinedOptionValues) {
                            case RUNTIME_GROUP: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_DEACTIVATE_RUNTIMEGROUP", string4));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11012);
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.COPY))) {
                        switch (predefinedOptionValues) {
                            case RUNTIME_GROUP: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_COPY_RUNTIMEGROUP", string4));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11013);
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.LIST))) {
                        switch (predefinedOptionValues) {
                            case RUNTIME_GROUP_VERSIONS: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_LIST_RUNTIMEGROUP", string4));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11014);
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.EXTRACT))) {
                        switch (predefinedOptionValues) {
                            case RUNTIME_GROUP: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_EXTRACT_RUNTIMEGROUP", string4));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11015);
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.EXPORT))) {
                        switch (predefinedOptionValues) {
                            case REPOSITORY: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_EXPORT_RUNTIMEGROUP_VERSION", string4, string5));
                                break;
                            }
                            case RUNTIME_GROUP: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_EXPORT_RUNTIMEGROUP_VERSION", string4, string5));
                                break;
                            }
                            case IMPORT_OR_EXPORT_DATA: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_EXPORT_RUNTIMEGROUP_VERSION", string4, string5));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11016);
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.IMPORT))) {
                        switch (predefinedOptionValues) {
                            case REPOSITORY: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_IMPORT_RUNTIMEGROUP_VERSION", string4, string5));
                                break;
                            }
                            case RUNTIME_GROUP: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_IMPORT_RUNTIMEGROUP_VERSION", string4, string5));
                                break;
                            }
                            case IMPORT_OR_EXPORT_DATA: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_IMPORT_RUNTIMEGROUP_VERSION", string4, string5));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11017);
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.REPORT))) {
                        switch (predefinedOptionValues) {
                            case REPOSITORY_DATA: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_REPORT_REPOSITORYDATA", new Object[0]));
                                break;
                            }
                            case REPOSITORY_VERSION: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_REPORT_REPOSITORYVERSION", new Object[0]));
                                break;
                            }
                            case PUREQUERY_XML_CHANGES: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_REPORT_PUREQUERYXMLCHANGES", new Object[0]));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11018);
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.VERIFY))) {
                        switch (predefinedOptionValues) {
                            case REPOSITORY: {
                                arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_VERIFY_REPOSITORY_MISSING_OBJECTS", new Object[0]));
                                break;
                            }
                            default: {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11019);
                            }
                        }
                    }
                    if (null != (predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.BIND))) {
                        if (artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.GENERATE_SCRIPT_ONLY)) {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_BIND_SCRIPT", new Object[0]));
                        } else {
                            switch (predefinedOptionValues) {
                                case PACKAGES: {
                                    arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_BIND", new Object[0]));
                                    break;
                                }
                                default: {
                                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 11020);
                                }
                            }
                        }
                    }
                    if (artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.GRANT_OPTIONS)) {
                        if (artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.GENERATE_SCRIPT_ONLY)) {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_GRANT_SCRIPT", new Object[0]));
                        } else {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_GRANT", new Object[]{predefinedOptionValues2}));
                        }
                    }
                    if (artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.REVOKE)) {
                        if (artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.GENERATE_SCRIPT_ONLY)) {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_REVOKE_SCRIPT", new Object[0]));
                        } else {
                            arrayList.add(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_REVOKE", new Object[]{predefinedOptionValues2}));
                        }
                    }
                    if (0 == arrayList.size()) {
                        string = Messages.getText("MSG_MANAGEREPOSITORY_FAILURE", new Object[0]);
                        break;
                    }
                    string = (String)arrayList.get(0);
                    for (int i10 = 1; i10 < arrayList.size(); ++i10) {
                        string = string + "\n" + (String)arrayList.get(1);
                    }
                    break;
                }
                default: {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{this.tool_}), null, 10809);
                }
            }
        }
        catch (Throwable throwable) {
            DataRuntimeException dataRuntimeException = throwable instanceof DataRuntimeException ? (DataRuntimeException)throwable : ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_GENERAL_ERROR", new Object[0]), throwable, 10814);
            this.printMessageLineAndLog("");
            dataRuntimeException.printStackTrace(this.printWriter_);
        }
        if (null == string) {
            string = Messages.getText("ERR_GENERAL_ERROR", new Object[0]);
        }
        return string;
    }

    private boolean isForSingleArtifact(ArtifactOptionsSet ... artifactOptionsSetArray) {
        return null != artifactOptionsSetArray && 1 == artifactOptionsSetArray.length && null != artifactOptionsSetArray[0].getArtifactName();
    }

    protected void printShowDetails(ArtifactOptionsSet artifactOptionsSet, UtilityResult utilityResult) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void printResults(UtilityResults var1_1, ArtifactOptionsSet[] var2_2) throws TransformerException {
        block33: {
            var8_3 = Messages.getText("MSG_TOTAL_SKIP", new Object[]{var1_1.getNumber(UtilityResultType.SKIP)});
            if (null == var2_2) break block33;
            var10_4 = var1_1.getNumber(UtilityResultType.SUCCESS);
            var11_5 = var1_1.getNumber(UtilityResultType.FAILURE);
            var12_6 = var1_1.getNumber(UtilityResultType.COMPLETED_WITH_WARNINGS);
            var13_7 = var1_1.getNumber(UtilityResultType.COMPLETED_WITH_ERRORS);
            var14_8 = var1_1.getNumber(UtilityResultType.SKIP);
            var15_9 = PossibleArgs.VERIFY_PACKAGES.isAllowedForTool(this.tool_) != false && 0 != var2_2.length && var2_2[0].isOptionOrArtifactSpecified(PossibleArgs.VERIFY_PACKAGES) != false;
            switch (1.$SwitchMap$com$ibm$db2$cmx$tools$Tool[this.tool_.ordinal()]) {
                case 1: {
                    var3_10 = Messages.getText("MSG_GEN_RESULTS", new Object[0]);
                    var4_11 = Messages.getText("MSG_GEN_SUCC_COUNT", new Object[]{var10_4});
                    var5_12 = Messages.getText("MSG_GEN_FAIL_COUNT", new Object[]{var11_5});
                    var7_13 = null;
                    var6_14 = null;
                    var9_15 = Messages.getText("MSG_TOTAL_NOTHING_SPECIFIED_GENERATOR", new Object[0]);
                    var16_16 = null;
                    if (this.summaryLogFileName_ == null) ** GOTO lbl37
                    var17_17 = new File(this.summaryLogFileName_);
                    var16_16 = new FileOutputStream(var17_17);
                    if (this.document_ == null || this.rootElement_ == null) ** GOTO lbl37
                    var18_21 = this.document_.createElement("batchResult");
                    var18_21.setAttribute("success", Integer.toString(var10_4));
                    var18_21.setAttribute("failure", Integer.toString(var11_5));
                    this.rootElement_.appendChild(var18_21);
                    var19_22 = TransformerFactory.newInstance();
                    var20_23 = var19_22.newTransformer();
                    var21_24 = new DOMSource(this.document_);
                    var22_25 = new StreamResult((OutputStream)var16_16);
                    var20_23.setOutputProperty("indent", "yes");
                    var20_23.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "5");
                    var20_23.transform(var21_24, var22_25);
                    var16_16.flush();
                    var16_16.close();
lbl37:
                    // 3 sources

                    try {
                        if (var16_16 == null) break;
                        var16_16.close();
                    }
                    catch (IOException var17_18) {
                        var17_18.printStackTrace();
                    }
                    break;
                    catch (IOException var17_19) {
                        try {
                            var17_19.printStackTrace();
                        }
                        catch (Throwable var23_26) {
                            try {
                                if (var16_16 != null) {
                                    var16_16.close();
                                }
                            }
                            catch (IOException var24_27) {
                                var24_27.printStackTrace();
                            }
                            throw var23_26;
                        }
                        try {
                            if (var16_16 == null) break;
                            var16_16.close();
                        }
                        catch (IOException var17_20) {
                            var17_20.printStackTrace();
                        }
                        break;
                    }
                }
                case 4: {
                    var3_10 = Messages.getText("MSG_BIND_RESULTS", new Object[0]);
                    var4_11 = Messages.getText("MSG_TOTAL_SUCCESS_BIND", new Object[]{var10_4});
                    var5_12 = Messages.getText("MSG_TOTAL_FAILURE_BIND", new Object[]{var11_5});
                    var7_13 = Messages.getText("MSG_TOTAL_COMPLETED_WITH_WARNINGS_BIND", new Object[]{var12_6});
                    var6_14 = Messages.getText("MSG_TOTAL_COMPLETED_WITH_ERRORS_BIND", new Object[]{var13_7});
                    var9_15 = Messages.getText("MSG_TOTAL_NOTHING_SPECIFIED_BIND", new Object[0]);
                    break;
                }
                case 2: {
                    var3_10 = Messages.getText("MSG_CONFIGURE_RESULTS", new Object[0]);
                    var4_11 = Messages.getText("MSG_CONFIGURE_SUCC_COUNT", new Object[]{var10_4});
                    var5_12 = Messages.getText("MSG_CONFIGURE_FAIL_COUNT", new Object[]{var11_5});
                    var7_13 = Messages.getText("MSG_CONFIGURE_COMPLETED_WITH_WARNINGS_COUNT", new Object[]{var12_6});
                    var6_14 = null;
                    var9_15 = Messages.getText("MSG_TOTAL_NOTHING_SPECIFIED_CONFIGURE_MERGE", new Object[0]);
                    break;
                }
                case 8: {
                    var3_10 = Messages.getText("MSG_METADATAREPLACER_RESULTS", new Object[0]);
                    var4_11 = Messages.getText("MSG_METADATAREPLACER_SUCC_COUNT", new Object[]{var10_4});
                    var5_12 = Messages.getText("MSG_METADATAREPLACER_FAIL_COUNT", new Object[]{var11_5});
                    var7_13 = null;
                    var6_14 = null;
                    var9_15 = Messages.getText("MSG_TOTAL_NOTHING_SPECIFIED_CONFIGURE_MERGE", new Object[0]);
                    break;
                }
                case 5: {
                    var3_10 = Messages.getText("MSG_MERGE_RESULTS", new Object[0]);
                    var4_11 = Messages.getText("MSG_MERGE_SUCC_COUNT", new Object[]{var10_4});
                    var5_12 = Messages.getText("MSG_MERGE_FAIL_COUNT", new Object[]{var11_5});
                    var7_13 = null;
                    var6_14 = null;
                    var9_15 = Messages.getText("MSG_TOTAL_NOTHING_SPECIFIED_CONFIGURE_MERGE", new Object[0]);
                    break;
                }
                case 3: {
                    var3_10 = Messages.getText("MSG_VALIDATOR_RESULTS", new Object[0]);
                    var4_11 = Messages.getText("MSG_VALIDATOR_SUCC_COUNT", new Object[]{var10_4});
                    var5_12 = Messages.getText("MSG_VALIDATOR_FAIL_COUNT", new Object[]{var11_5});
                    var7_13 = null;
                    var6_14 = null;
                    var9_15 = Messages.getText("MSG_TOTAL_NOTHING_SPECIFIED_CONFIGURE_MERGE", new Object[0]);
                    break;
                }
                case 6: {
                    var3_10 = Messages.getText("MSG_GENERATEPUREQUERYXML_RESULTS", new Object[0]);
                    var4_11 = Messages.getText("MSG_GENERATEPUREQUERYXML_SUCC_COUNT", new Object[]{var10_4});
                    var5_12 = Messages.getText("MSG_GENERATEPUREQUERYXML_FAIL_COUNT", new Object[]{var11_5});
                    var7_13 = null;
                    var6_14 = null;
                    var9_15 = Messages.getText("MSG_TOTAL_NOTHING_SPECIFIED_GENERATEPUREQUERYXML", new Object[0]);
                    break;
                }
                default: {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{this.tool_}), null, 10377);
                }
            }
            if (!var1_1.generalFailure || 0 != var1_1.getTotalItemsProcessed()) {
                this.printHorizontalLine();
                if (null != var1_1.messagesToPrint && 0 < var1_1.messagesToPrint.length()) {
                    this.printMessageLineAndLog("");
                    this.printMessageLineAndLog(var1_1.messagesToPrint);
                    this.printMessageLineAndLog("");
                }
                if (!var15_9) {
                    this.printMessageLineAndLog(var3_10);
                    this.printMessageLineAndLog("");
                    var16_16 = "    ";
                    if (0 == var1_1.getTotalItemsProcessed()) {
                        this.printMessageLineAndLog((String)var16_16 + var9_15);
                    } else {
                        if (0 < var10_4) {
                            this.printMessageLineAndLog((String)var16_16 + var4_11);
                        }
                        if (0 < var11_5) {
                            this.printMessageLineAndLog((String)var16_16 + var5_12);
                        }
                        if (0 < var12_6) {
                            this.printMessageLineAndLog((String)var16_16 + var7_13);
                        }
                        if (0 < var13_7) {
                            this.printMessageLineAndLog((String)var16_16 + var6_14);
                        }
                        if (0 < var14_8) {
                            this.printMessageLineAndLog((String)var16_16 + var8_3);
                        }
                        if (6 != var1_1.getNumberOfTypesOfResults()) {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText(Messages.getText("ERR_NOT_SHOWING_ALL_RESULTS", new Object[0]), new Object[]{this.tool_}), null, 10821);
                        }
                    }
                    this.printMessageLineAndLog("");
                    this.printMessageLineAndLog("");
                }
                if (0 < var13_7 && null == var6_14) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{UtilityResultType.COMPLETED_WITH_ERRORS}), null, 10806);
                }
                if (0 < var12_6 && null == var7_13) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{UtilityResultType.COMPLETED_WITH_WARNINGS}), null, 10807);
                }
            }
        }
    }

    public static String getMessageForWrongArtifactType(Tool tool) {
        String string;
        switch (tool) {
            case GENERATOR: {
                string = Messages.getText("MSG_IGNORING_NOTINTERFACE", OptionsProcessor.descriptionOfHowArtifactTypesAreDeterminedInOptionsFile);
                break;
            }
            case CONFIGURE: 
            case VALIDATOR: 
            case MERGE: 
            case METADATAREPLACER: {
                string = Messages.getText("MSG_IGNORING_NOTPUREQUERYXML", OptionsProcessor.descriptionOfHowArtifactTypesAreDeterminedInOptionsFile);
                break;
            }
            case BINDER: {
                string = Messages.getText("MSG_IGNORING_NOTINTERFACE_NOTPUREQUERYXML", OptionsProcessor.descriptionOfHowArtifactTypesAreDeterminedInOptionsFile);
                break;
            }
            case GENERATE_PUREQUERYXML: {
                string = Messages.getText("MSG_IGNORING_NOTPUREQUERYXML", OptionsProcessor.descriptionOfPureQueryXmlFileNames);
                break;
            }
            default: {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{tool}), null, 10808);
            }
        }
        return string;
    }

    protected void printMessageLineAndLog(String string) {
        if (string != null) {
            this.printWriter_.println(string);
            ToolsLogger.getLogger().log(Level.INFO, string + '\n');
        }
    }

    private String getStringFromSet(EnumSet<PossibleArgs> enumSet) {
        StringBuilder stringBuilder = null;
        if (null == enumSet) {
            stringBuilder = new StringBuilder("");
        } else {
            for (PossibleArgs possibleArgs : enumSet) {
                if (null == stringBuilder) {
                    stringBuilder = new StringBuilder(possibleArgs.externalOptionNameWithoutDash());
                    continue;
                }
                stringBuilder.append(", ").append(possibleArgs.externalOptionNameWithoutDash());
            }
        }
        return stringBuilder.toString();
    }

    public abstract String getUtilityName();

    public static class UtilityResults {
        private Map<UtilityResultType, Integer> counts = new HashMap<UtilityResultType, Integer>();
        public boolean generalFailure = false;
        public String generatedCode = null;
        public String messagesToPrint = null;

        public UtilityResults() {
            for (UtilityResultType utilityResultType : UtilityResultType.values()) {
                this.counts.put(utilityResultType, 0);
            }
        }

        public boolean noFailures() {
            if (this.generalFailure) {
                return false;
            }
            block3: for (Map.Entry<UtilityResultType, Integer> entry : this.counts.entrySet()) {
                switch (entry.getKey()) {
                    case SUCCESS: 
                    case COMPLETED_WITH_WARNINGS: 
                    case SKIP: 
                    case MR_SKIP: {
                        continue block3;
                    }
                }
                if (0 >= entry.getValue()) continue;
                return false;
            }
            return true;
        }

        public int getReturnValue(boolean bl2) {
            if (this.generalFailure || 0 < this.getNumber(UtilityResultType.FAILURE)) {
                return 255;
            }
            if (0 < this.getNumber(UtilityResultType.COMPLETED_WITH_ERRORS)) {
                return 127;
            }
            if (bl2 && 0 < this.getNumber(UtilityResultType.COMPLETED_WITH_WARNINGS)) {
                return 63;
            }
            if (0 < this.getNumber(UtilityResultType.MR_SKIP)) {
                return 31;
            }
            return 0;
        }

        public void addResult(UtilityResult utilityResult) {
            this.counts.put(utilityResult.utilityResultType, this.counts.get((Object)utilityResult.utilityResultType) + 1);
            if (null != this.generatedCode && null != utilityResult.generatedCode) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly("ERR_GENERATED_CODE_NOT_RECORDED_CORRECTLY", null, 10810);
            }
            if (null != utilityResult.generatedCode) {
                this.generatedCode = utilityResult.generatedCode;
            }
        }

        public int getNumber(UtilityResultType utilityResultType) {
            return this.counts.get((Object)utilityResultType);
        }

        public int getTotalItemsProcessed() {
            int n2 = 0;
            for (Map.Entry<UtilityResultType, Integer> entry : this.counts.entrySet()) {
                n2 += entry.getValue().intValue();
            }
            return n2;
        }

        protected int getNumberOfTypesOfResults() {
            return this.counts.size();
        }
    }

    public static class UtilityResult {
        public UtilityResultType utilityResultType;
        public String reason = null;
        public String generatedCode = null;
        public XmlFileHelper.PureQueryXmlFileStatistics inputPureQueryXmlFileStatistics = null;
        public String messagesToPrint = null;

        public UtilityResult(UtilityResultType utilityResultType) {
            this.utilityResultType = utilityResultType;
        }

        public void downgradeUtilityResultType(UtilityResultType utilityResultType, String string) {
            UtilityResultType utilityResultType2 = this.utilityResultType;
            this.utilityResultType = UtilityResultType.returnWorseType(utilityResultType2, utilityResultType);
            if (null == this.reason) {
                this.reason = string;
            } else if (null != string && !this.reason.contains(string)) {
                this.reason = this.reason + XmlTags.CRLF + XmlTags.CRLF + string;
            }
        }

        public boolean noFailures() {
            switch (this.utilityResultType) {
                case SUCCESS: 
                case COMPLETED_WITH_WARNINGS: 
                case SKIP: 
                case MR_SKIP: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum UtilityResultType {
        SUCCESS,
        SKIP,
        MR_SKIP,
        COMPLETED_WITH_WARNINGS,
        COMPLETED_WITH_ERRORS,
        FAILURE;


        public static UtilityResultType returnWorseType(UtilityResultType utilityResultType, UtilityResultType utilityResultType2) {
            return 0 < utilityResultType.compareTo(utilityResultType2) ? utilityResultType : utilityResultType2;
        }
    }
}

